/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.handler;

import cn.schoolwow.quickdao.QuickDAO;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.IndexField;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.handler.DefaultTablePropertyDefiner;
import cn.schoolwow.quickdao.handler.TableDefiner;
import cn.schoolwow.quickdao.handler.TablePropertyDefiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableDefiner
implements TableDefiner {
    private static Logger logger = LoggerFactory.getLogger(DefaultTableDefiner.class);
    private Entity entity;
    private QuickDAO quickDAO;

    public DefaultTableDefiner(Entity entity, QuickDAO quickDAO) {
        this.entity = entity;
        this.quickDAO = quickDAO;
    }

    @Override
    public TableDefiner tableName(String tableName) {
        this.entity.tableName = tableName;
        return this;
    }

    @Override
    public TableDefiner comment(String comment) {
        this.entity.comment = comment;
        return this;
    }

    @Override
    public TableDefiner index(IndexField indexField) {
        this.entity.indexFieldList.add(indexField);
        return this;
    }

    @Override
    public TablePropertyDefiner property(String fieldName) {
        for (Property property : this.entity.properties) {
            if (!property.name.equals(fieldName)) continue;
            return new DefaultTablePropertyDefiner(property, this);
        }
        throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u5b57\u6bb5\u540d\u79f0!\u5b57\u6bb5\u540d:" + fieldName);
    }

    @Override
    public QuickDAO done() {
        return this.quickDAO;
    }
}

