/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.query.subCondition;

import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.FieldFragmentEntry;
import cn.schoolwow.quickdao.domain.SubQuery;
import cn.schoolwow.quickdao.query.condition.Condition;
import cn.schoolwow.quickdao.query.subCondition.LambdaSubCondition;
import cn.schoolwow.quickdao.query.subCondition.LambdaSubConditionInvocationHandler;
import cn.schoolwow.quickdao.query.subCondition.SubCondition;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AbstractSubCondition<T, P>
implements SubCondition<T, P>,
Serializable {
    public List<String> columnList = new ArrayList<String>();
    public List<FieldFragmentEntry> whereList = new ArrayList<FieldFragmentEntry>();
    public List<String> groupByList = new ArrayList<String>();
    public List<FieldFragmentEntry> orderByList = new ArrayList<FieldFragmentEntry>();
    private SubQuery subQuery;

    public AbstractSubCondition(SubQuery subQuery) {
        this.subQuery = subQuery;
    }

    @Override
    public SubCondition<T, P> tableAliasName(String tableAliasName) {
        this.subQuery.tableAliasName = tableAliasName;
        return this;
    }

    @Override
    public SubCondition<T, P> leftJoin() {
        this.subQuery.join = "left outer join";
        return this;
    }

    @Override
    public SubCondition<T, P> rightJoin() {
        this.subQuery.join = "right outer join";
        return this;
    }

    @Override
    public SubCondition<T, P> fullJoin() {
        this.subQuery.join = "full outer join";
        return this;
    }

    @Override
    public SubCondition<T, P> on(String primaryField, String joinTableField) {
        if (null == this.subQuery.parentSubQuery) {
            this.subQuery.onConditionMap.put(this.subQuery.query.entity.getColumnNameByFieldName(primaryField), this.subQuery.entity.getColumnNameByFieldName(joinTableField));
        } else {
            this.subQuery.onConditionMap.put(this.subQuery.parentSubQuery.entity.getColumnNameByFieldName(primaryField), this.subQuery.entity.getColumnNameByFieldName(joinTableField));
        }
        return this;
    }

    @Override
    public SubCondition<T, P> addNullQuery(String field) {
        this.whereList.add(new FieldFragmentEntry(field, "{} is null"));
        return this;
    }

    @Override
    public SubCondition<T, P> addNotNullQuery(String field) {
        this.whereList.add(new FieldFragmentEntry(field, "{} is not null"));
        return this;
    }

    @Override
    public SubCondition<T, P> addEmptyQuery(String field) {
        this.whereList.add(new FieldFragmentEntry(field, "{} is not null and {} = ''"));
        return this;
    }

    @Override
    public SubCondition<T, P> addNotEmptyQuery(String field) {
        this.whereList.add(new FieldFragmentEntry(field, "{} is not null and {} != ''"));
        return this;
    }

    @Override
    public SubCondition<T, P> addInQuery(String field, Object ... values) {
        this.addInQuery(field, values, "in");
        return this;
    }

    @Override
    public SubCondition<T, P> addInQuery(String field, List values) {
        return this.addInQuery(field, values.toArray(new Object[0]));
    }

    @Override
    public SubCondition<T, P> addNotInQuery(String field, Object ... values) {
        this.addInQuery(field, values, "not in");
        return this;
    }

    @Override
    public SubCondition<T, P> addNotInQuery(String field, List values) {
        return this.addNotInQuery(field, values.toArray(new Object[0]));
    }

    @Override
    public SubCondition<T, P> addBetweenQuery(String field, Object start, Object end) {
        this.whereList.add(new FieldFragmentEntry(field, "{} between ? and ?"));
        this.subQuery.parameterList.add(start);
        this.subQuery.parameterList.add(end);
        return this;
    }

    @Override
    public SubCondition<T, P> addLikeQuery(String field, Object value) {
        if (value == null || value.toString().equals("")) {
            return this;
        }
        this.whereList.add(new FieldFragmentEntry(field, "{} like ?"));
        this.subQuery.parameterList.add(value);
        return this;
    }

    @Override
    public SubCondition<T, P> addQuery(String field, Object value) {
        this.addQuery(field, "=", value);
        return this;
    }

    @Override
    public SubCondition<T, P> addQuery(String field, String operator, Object value) {
        if (null == value) {
            this.addNullQuery(field);
        } else if (value.toString().isEmpty()) {
            this.addEmptyQuery(field);
        } else {
            this.whereList.add(new FieldFragmentEntry(field, "{} " + operator + " ?"));
            this.subQuery.parameterList.add(value);
        }
        return this;
    }

    @Override
    public SubCondition<T, P> addRawQuery(String query, Object ... parameterList) {
        this.subQuery.condition.addRawQuery(query, parameterList);
        return this;
    }

    @Override
    public SubCondition<T, P> addColumn(String ... fields) {
        for (String field : fields) {
            this.columnList.add(field);
        }
        return this;
    }

    @Override
    public SubCondition<T, P> excludeColumn(String ... excludeFields) {
        for (String excludeField : excludeFields) {
            this.subQuery.excludeColumnList.add(excludeField);
        }
        return this;
    }

    @Override
    public <E> SubCondition<E, T> joinTable(Class<E> clazz, String primaryField, String joinTableField) {
        return this.joinTable(clazz, primaryField, joinTableField, this.subQuery.entity.getCompositeFieldName(clazz.getName()));
    }

    @Override
    public <E> SubCondition<E, T> joinTable(Class<E> clazz, String primaryField, String joinTableField, String compositField) {
        Entity entity = this.subQuery.query.quickDAOConfig.getEntityByClassName(clazz.getName());
        if (null == entity) {
            throw new IllegalArgumentException("\u672a\u626b\u63cf\u6307\u5b9a\u7c7b\u4fe1\u606f!\u7c7b\u540d:" + clazz.getName());
        }
        joinTableField = entity.getColumnNameByFieldName(joinTableField);
        primaryField = this.subQuery.entity.getColumnNameByFieldName(primaryField);
        AbstractSubCondition abstractSubCondition = (AbstractSubCondition)this.subQuery.condition.joinTable(clazz, primaryField, joinTableField, compositField);
        abstractSubCondition.subQuery.parentSubQuery = this.subQuery;
        abstractSubCondition.subQuery.parentSubCondition = this;
        return abstractSubCondition;
    }

    @Override
    public SubCondition<?, T> joinTable(String tableName, String primaryField, String joinTableField) {
        AbstractSubCondition abstractSubCondition = (AbstractSubCondition)this.subQuery.condition.joinTable(tableName, primaryField, joinTableField);
        abstractSubCondition.subQuery.parentSubQuery = this.subQuery;
        abstractSubCondition.subQuery.parentSubCondition = this;
        return abstractSubCondition;
    }

    @Override
    public SubCondition<T, P> groupBy(String ... fields) {
        for (String field : fields) {
            this.groupByList.add(field);
        }
        return this;
    }

    @Override
    public SubCondition<T, P> order(String field, String asc) {
        this.orderByList.add(new FieldFragmentEntry(field, "{} " + asc));
        return this;
    }

    @Override
    public SubCondition<T, P> orderBy(String ... fields) {
        for (String field : fields) {
            this.orderByList.add(new FieldFragmentEntry(field, "{} asc"));
        }
        return this;
    }

    @Override
    public SubCondition<T, P> orderByDesc(String ... fields) {
        for (String field : fields) {
            this.orderByList.add(new FieldFragmentEntry(field, "{} desc"));
        }
        return this;
    }

    @Override
    public LambdaSubCondition<T, P> lambdaSubCondition() {
        LambdaSubConditionInvocationHandler invocationHandler = new LambdaSubConditionInvocationHandler(this);
        LambdaSubCondition lambdaSubCondition = (LambdaSubCondition)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{LambdaSubCondition.class}, invocationHandler);
        return lambdaSubCondition;
    }

    @Override
    public SubCondition<P, ?> doneSubCondition() {
        return this.subQuery.parentSubCondition;
    }

    @Override
    public Condition<P> done() {
        return this.subQuery.condition;
    }

    public String toString() {
        return this.subQuery.toString();
    }

    private void addInQuery(String field, Object[] values, String in) {
        if (null == values || values.length == 0) {
            this.whereList.add(new FieldFragmentEntry(field, "1 = 2"));
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" {} " + in + " (");
        for (int i = 0; i < values.length; ++i) {
            builder.append("?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        this.whereList.add(new FieldFragmentEntry(new String(field), builder.toString()));
        this.subQuery.parameterList.addAll(Arrays.asList(values));
    }
}

