/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.config;

import cn.schoolwow.quickdao.QuickDAO;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdns.config.QuickDNSServerConfig;
import cn.schoolwow.quickdns.domain.QuickDNSConfigProperties;
import com.zaxxer.hikari.HikariDataSource;
import javax.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@ComponentScan(basePackages={"cn.schoolwow.quickdns"})
public class QuickDNSConfig {
    @Bean
    public HikariDataSource hikariDataSource() {
        HikariDataSource hikariDataSource = new HikariDataSource();
        QuickDNSConfigProperties quickDNSConfigProperties = QuickDNSServerConfig.quickDNSConfigProperties;
        hikariDataSource.setDriverClassName(quickDNSConfigProperties.driverClassName);
        hikariDataSource.setJdbcUrl(quickDNSConfigProperties.jdbcUrl);
        if (null != quickDNSConfigProperties.username && null != quickDNSConfigProperties.password) {
            hikariDataSource.setUsername(quickDNSConfigProperties.username);
            hikariDataSource.setPassword(quickDNSConfigProperties.password);
        }
        return hikariDataSource;
    }

    @Bean
    @Resource
    public DAO quickdao(HikariDataSource hikariDataSource) {
        DAO dao = QuickDAO.newInstance().dataSource(hikariDataSource).packageName("cn.schoolwow.quickdns.entity").autoCreateTable(true).autoCreateProperty(true).autoDeleteTableAndProperty(true).build();
        return dao;
    }

    @Bean
    public ThreadPoolTaskScheduler threadPoolTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(Runtime.getRuntime().availableProcessors());
        threadPoolTaskScheduler.setRemoveOnCancelPolicy(true);
        return threadPoolTaskScheduler;
    }
}

