/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.controller;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.PageVo;
import cn.schoolwow.quickdao.query.condition.Condition;
import cn.schoolwow.quickdns.dns.DNSHandler;
import cn.schoolwow.quickdns.entity.DNSForwardServer;
import cn.schoolwow.quickdns.util.CommonUtil;
import cn.schoolwow.quickdns.util.ValidateUtil;
import cn.schoolwow.quickserver.controller.RequestMethod;
import cn.schoolwow.quickserver.controller.annotation.RequestBody;
import cn.schoolwow.quickserver.controller.annotation.RequestMapping;
import cn.schoolwow.quickserver.controller.annotation.RequestParam;
import cn.schoolwow.quickserver.controller.annotation.RestController;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
@RestController
@RequestMapping(value="/forwardServer")
public class DNSForwardServerController {
    @Resource
    private DAO dao;

    @PostConstruct
    public void postConstruct() {
        this.updateDNSForwardServerCache();
    }

    @RequestMapping(value="/list")
    public JSONObject list(@RequestParam(name="page", required=false, defaultValue="1") int page, @RequestParam(name="pageSize", required=false, defaultValue="10") int pageSize) {
        Condition<DNSForwardServer> condition = this.dao.query(DNSForwardServer.class).page(page, pageSize).orderBy("priority");
        PageVo<DNSForwardServer> dnsForwardServerPageVo = condition.execute().getPagingList();
        JSONObject o = new JSONObject();
        o.put("list", (Object)dnsForwardServerPageVo.getList());
        o.put("total", (Object)dnsForwardServerPageVo.getTotalSize());
        return o;
    }

    @RequestMapping(value="/create", method={RequestMethod.POST})
    public DNSForwardServer create(@RequestBody DNSForwardServer dnsForwardServer) throws IOException {
        ValidateUtil.validateDNSForwardServer(dnsForwardServer);
        int consumeTime = CommonUtil.getDNSConsumeTime(dnsForwardServer.getIpv4(), dnsForwardServer.getPort());
        if (consumeTime < 0) {
            throw new IOException("\u65e0\u6cd5\u8fde\u901aDNS\u670d\u52a1\u5668!DNS\u670d\u52a1\u5668IP:" + dnsForwardServer.getIpv4() + ",\u7aef\u53e3:" + dnsForwardServer.getPort());
        }
        dnsForwardServer.setConsumeTime(consumeTime);
        this.dao.insert(dnsForwardServer);
        this.updateDNSForwardServerCache();
        return dnsForwardServer;
    }

    @RequestMapping(value="/update", method={RequestMethod.POST})
    public DNSForwardServer update(@RequestBody DNSForwardServer dnsForwardServer) {
        this.dao.update(dnsForwardServer);
        this.updateDNSForwardServerCache();
        return dnsForwardServer;
    }

    @RequestMapping(value="/updatePriority", method={RequestMethod.GET})
    public void updatePriority(@RequestParam(name="ids") String ids) {
        String[] dnsForwardServerIds = ids.split(",");
        for (int i = 0; i < dnsForwardServerIds.length; ++i) {
            this.dao.query(DNSForwardServer.class).addQuery("id", dnsForwardServerIds[i]).addUpdate("priority", i).execute().update();
        }
    }

    @RequestMapping(value="/delete", method={RequestMethod.POST})
    public int delete(@RequestParam(name="id") String id) {
        int effect = 0;
        effect = id.contains(",") ? this.dao.query(DNSForwardServer.class).addInQuery("id", id).execute().delete() : this.dao.delete(DNSForwardServer.class, Long.parseLong(id));
        this.updateDNSForwardServerCache();
        return effect;
    }

    @RequestMapping(value="/resetForwardServer", method={RequestMethod.GET})
    public void resetForwardServer() {
        List<DNSForwardServer> dnsForwardServerList = Arrays.asList(this.getDNSForwardServer("114DNS", "114.114.114.114"), this.getDNSForwardServer("\u963f\u91ccDNS", "223.5.5.5"), this.getDNSForwardServer("Google DNS", "8.8.8.8"), this.getDNSForwardServer("OpenDNS", "208.67.222.222"));
        for (int i = 0; i < dnsForwardServerList.size(); ++i) {
            dnsForwardServerList.get(i).setPriority(i);
        }
        this.dao.clear(DNSForwardServer.class);
        this.dao.insertIgnore(dnsForwardServerList);
    }

    @RequestMapping(value="/getConsumeTime", method={RequestMethod.GET})
    public void getConsumeTime(@RequestParam(name="ids", required=false) String ids) {
        ArrayList<DNSForwardServer> dnsForwardServerList = new ArrayList<DNSForwardServer>();
        if (null != ids && !ids.isEmpty()) {
            dnsForwardServerList.addAll(this.dao.query(DNSForwardServer.class).addInQuery("id", ids).execute().getList());
        } else {
            dnsForwardServerList.addAll(this.dao.query(DNSForwardServer.class).execute().getList());
        }
        for (DNSForwardServer dnsForwardServer : dnsForwardServerList) {
            int consumeTime = CommonUtil.getDNSConsumeTime(dnsForwardServer.getIpv4(), dnsForwardServer.getPort());
            dnsForwardServer.setConsumeTime(consumeTime);
            this.dao.query(DNSForwardServer.class).addQuery("id", dnsForwardServer.getId()).addUpdate("consumeTime", consumeTime).execute().update();
        }
    }

    private DNSForwardServer getDNSForwardServer(String name, String ipv4) {
        DNSForwardServer dnsForwardServer = new DNSForwardServer();
        dnsForwardServer.setName(name);
        dnsForwardServer.setIpv4(ipv4);
        dnsForwardServer.setEnable(0);
        dnsForwardServer.setPort(53);
        return dnsForwardServer;
    }

    private void updateDNSForwardServerCache() {
        List<DNSForwardServer> dnsForwardServerList = this.dao.query(DNSForwardServer.class).addQuery("enable", 1).orderBy("priority").execute().getList();
        DNSHandler.dnsForwardServerList.clear();
        DNSHandler.dnsForwardServerList.addAll(dnsForwardServerList);
    }
}

