/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.controller;

import cn.schoolwow.quickdns.config.QuickDNSServerConfig;
import cn.schoolwow.quickdns.dns.DNSServerUtil;
import cn.schoolwow.quickdns.dns.domain.DNSPacket;
import cn.schoolwow.quickdns.dns.domain.DNSRequest;
import cn.schoolwow.quickdns.dns.domain.DNSResponse;
import cn.schoolwow.quickdns.dns.domain.header.constant.RD;
import cn.schoolwow.quickdns.dns.domain.question.Question;
import cn.schoolwow.quickdns.dns.domain.question.constants.QTYPE;
import cn.schoolwow.quickdns.dns.domain.resourceRecord.ResourceRecord;
import cn.schoolwow.quickserver.controller.RequestMethod;
import cn.schoolwow.quickserver.controller.annotation.RequestMapping;
import cn.schoolwow.quickserver.controller.annotation.RequestPart;
import cn.schoolwow.quickserver.controller.annotation.RestController;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@RestController
@RequestMapping(value="/selfQuery")
public class SelfQueryController {
    private Logger logger = LoggerFactory.getLogger(SelfQueryController.class);

    @RequestMapping(value="/query", method={RequestMethod.POST})
    public JSONObject selfQuery(@RequestPart(name="type") String type, @RequestPart(name="host") String host, @RequestPart(name="dnsServerIp", required=false, defaultValue="") String dnsServerIp, @RequestPart(name="rd", required=false, defaultValue="0") int rd) throws IOException {
        if (null == dnsServerIp || dnsServerIp.isEmpty()) {
            dnsServerIp = QuickDNSServerConfig.quickDNSConfigProperties.gatewayIp;
        }
        Question question = new Question(host, QTYPE.getQTYPEByName(type));
        DNSRequest dnsRequest = new DNSRequest(question);
        dnsRequest.header.rd = RD.getRD(rd);
        DNSResponse dnsResponse = DNSServerUtil.sendDNSRequest(dnsServerIp, 53, dnsRequest);
        this.logger.info("[\u81ea\u52a9\u67e5\u8be2]\u7c7b\u578b:{},\u57df\u540d:{},\u8fd4\u56de\u62a5\u6587:{}", type, host, dnsResponse);
        return this.getSelfQueryResult(dnsResponse);
    }

    @RequestMapping(value="/dnsResponseHexQuery", method={RequestMethod.POST})
    public JSONObject selfQuery(@RequestPart(name="dnsResponseHex") String dnsResponseHex) throws IOException {
        DNSResponse dnsResponse = DNSPacket.readDNSResponse(DNSServerUtil.hexToByteArray(dnsResponseHex));
        this.logger.info("[\u81ea\u52a9\u67e5\u8be2]\u539f\u59cb\u62a5\u6587\u67e5\u8be2,\u89e3\u6790\u62a5\u6587:{}", (Object)dnsResponse);
        return this.getSelfQueryResult(dnsResponse);
    }

    private JSONObject getSelfQueryResult(DNSResponse dnsResponse) {
        JSONObject result = new JSONObject();
        result.put("header", (Object)JSON.parseObject(JSON.toJSONString(dnsResponse.header)));
        JSONArray array = new JSONArray();
        array.addAll((Collection<?>)this.getResourceRecord(dnsResponse.answers, "answer"));
        array.addAll((Collection<?>)this.getResourceRecord(dnsResponse.authorities, "authority"));
        array.addAll((Collection<?>)this.getResourceRecord(dnsResponse.additionals, "additional"));
        result.put("resourceRecords", (Object)array);
        return result;
    }

    private JSONArray getResourceRecord(List<ResourceRecord> resourceRecordList, String region) {
        JSONArray array = new JSONArray();
        for (ResourceRecord resourceRecord : resourceRecordList) {
            JSONObject o = new JSONObject();
            o.put("qName", (Object)resourceRecord.qName);
            o.put("qType", (Object)resourceRecord.qType.name());
            o.put("ttl", (Object)resourceRecord.TTL);
            o.put("RDATA", (Object)DNSServerUtil.byteArrayToHex(resourceRecord.RDATA));
            o.put("RDATAFormat", (Object)resourceRecord.RDATAFormat);
            o.put("region", (Object)region);
            array.add(o);
        }
        return array;
    }
}

