/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.controller;

import cn.schoolwow.quickdao.DAOUtils;
import cn.schoolwow.quickdao.QuickDAO;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.util.MigrateOption;
import cn.schoolwow.quickdns.config.QuickDNSServerConfig;
import cn.schoolwow.quickdns.domain.DataBaseConnectionRequest;
import cn.schoolwow.quickdns.service.GFWService;
import cn.schoolwow.quickdns.util.CommonUtil;
import cn.schoolwow.quickserver.controller.RequestMethod;
import cn.schoolwow.quickserver.controller.annotation.RequestBody;
import cn.schoolwow.quickserver.controller.annotation.RequestMapping;
import cn.schoolwow.quickserver.controller.annotation.RestController;
import cn.schoolwow.quickserver.response.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.stereotype.Component;

@Component
@RestController
@RequestMapping(value="/setting")
public class SettingController {
    @Resource
    private DAO dao;
    @Resource
    private GFWService gfwService;

    @PostConstruct
    public void postConstruct() {
        if (QuickDNSServerConfig.quickDNSConfigProperties.enableGFW > 0) {
            try {
                this.gfwService.analyzeGFWFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.gfwService.scheduleGFWTask();
        }
    }

    @RequestMapping(value="/readConfig", method={RequestMethod.GET})
    public JSONObject readConfig() throws IOException {
        JSONObject config = JSON.parseObject(JSON.toJSONString(QuickDNSServerConfig.quickDNSConfigProperties));
        return config;
    }

    @RequestMapping(value="/updateConfig", method={RequestMethod.POST})
    public void updateConfig(@RequestBody String requestBody) throws IOException {
        JSONObject o = JSON.parseObject(requestBody);
        QuickDNSServerConfig.quickDNSConfigProperties.dnsQueryTimeoutSeconds = o.getIntValue("dnsQueryTimeoutSeconds");
        String gatewayIp = o.getString("gatewayIp");
        if (CommonUtil.getDNSConsumeTime(gatewayIp, 53) < 0) {
            throw new IOException("\u65e0\u6cd5\u8fde\u901aDNS\u670d\u52a1\u5668!DNS\u670d\u52a1\u5668IP:" + gatewayIp + ",\u7aef\u53e3:53");
        }
        QuickDNSServerConfig.quickDNSConfigProperties.gatewayIp = gatewayIp;
        QuickDNSServerConfig.quickDNSConfigProperties.enableGFW = o.getIntValue("enableGFW");
        CronExpression.parse(o.getString("gfwCron"));
        QuickDNSServerConfig.quickDNSConfigProperties.gfwCron = o.getString("gfwCron");
        QuickDNSServerConfig.quickDNSConfigProperties.gfwDNS = o.getString("gfwDNS");
        if (QuickDNSServerConfig.quickDNSConfigProperties.enableGFW > 0) {
            this.gfwService.scheduleGFWTask();
        } else {
            this.gfwService.cancelGFWCronTask();
        }
        QuickDNSServerConfig.quickDNSConfigProperties.dnsQueryForwardRetryTimes = o.getIntValue("dnsQueryForwardRetryTimes");
        this.writeToConfigFile();
    }

    @RequestMapping(value="/updateGFWListCache", method={RequestMethod.GET})
    public int updateGFWListCache(@RequestBody String requestBody) throws IOException {
        return this.gfwService.updateGFWListCache();
    }

    @RequestMapping(value="/updatePassword", method={RequestMethod.POST})
    public void updatePassword(@RequestBody String requestBody) throws IOException {
        JSONObject o = JSON.parseObject(requestBody);
        String oldPassword = o.getString("oldPassword");
        String newPassword = o.getString("newPassword");
        String confirmPassword = o.getString("confirmPassword");
        if (!QuickDNSServerConfig.quickDNSConfigProperties.initialPassword.equals(oldPassword)) {
            throw new IllegalArgumentException("\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e!");
        }
        if (!newPassword.equals(confirmPassword)) {
            throw new IllegalArgumentException("\u65b0\u5bc6\u7801\u548c\u786e\u8ba4\u5bc6\u7801\u4e0d\u4e00\u81f4!");
        }
        QuickDNSServerConfig.quickDNSConfigProperties.initialPassword = confirmPassword;
        this.writeToConfigFile();
    }

    @RequestMapping(value="/downloadSQLiteFile", method={RequestMethod.GET})
    public void downloadSQLiteFile(HttpResponse httpResponse) throws IOException {
        String jdbcUrl = QuickDNSServerConfig.quickDNSConfigProperties.jdbcUrl;
        if (!jdbcUrl.startsWith("jdbc:sqlite://")) {
            return;
        }
        File file = new File(jdbcUrl.substring("jdbc:sqlite://".length()));
        httpResponse.download(file.getAbsolutePath());
    }

    @RequestMapping(value="/testDatabaseConnection", method={RequestMethod.POST})
    public void testDatabaseConnection(@RequestBody DataBaseConnectionRequest dataBaseConnectionRequest) throws IOException, ClassNotFoundException, SQLException {
        this.handleDatabaseConnection(dataBaseConnectionRequest);
        Class.forName(dataBaseConnectionRequest.driverClassName);
        Connection connection = DriverManager.getConnection(dataBaseConnectionRequest.jdbcUrl, dataBaseConnectionRequest.username, dataBaseConnectionRequest.password);
        Throwable throwable = null;
        if (connection != null) {
            if (throwable != null) {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                connection.close();
            }
        }
    }

    @RequestMapping(value="/migrateDatabase", method={RequestMethod.POST})
    public void migrateDatabase(@RequestBody DataBaseConnectionRequest dataBaseConnectionRequest) throws IOException, ClassNotFoundException, SQLException {
        this.handleDatabaseConnection(dataBaseConnectionRequest);
        try (Connection connection = DriverManager.getConnection(dataBaseConnectionRequest.jdbcUrl, dataBaseConnectionRequest.username, dataBaseConnectionRequest.password);
             Statement statement = connection.createStatement();){
            statement.executeUpdate("drop database if exists " + dataBaseConnectionRequest.databaseName + ";");
            statement.executeUpdate("create database " + dataBaseConnectionRequest.databaseName + ";");
        }
        HikariDataSource hikariDataSource = new HikariDataSource();
        hikariDataSource.setDriverClassName(dataBaseConnectionRequest.driverClassName);
        hikariDataSource.setJdbcUrl(dataBaseConnectionRequest.jdbcUrl + dataBaseConnectionRequest.databaseName);
        hikariDataSource.setUsername(dataBaseConnectionRequest.username);
        hikariDataSource.setPassword(dataBaseConnectionRequest.password);
        DAO target = QuickDAO.newInstance().dataSource(hikariDataSource).packageName("cn.schoolwow.quickdns.entity").build();
        MigrateOption migrateOption = new MigrateOption();
        migrateOption.source = this.dao;
        migrateOption.target = target;
        DAOUtils.migrate(migrateOption);
    }

    private synchronized void writeToConfigFile() throws IOException {
        String configProperties = JSON.toJSONString(QuickDNSServerConfig.quickDNSConfigProperties);
        Files.write(Paths.get(System.getProperty("user.dir") + "/config.json", new String[0]), configProperties.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }

    private void handleDatabaseConnection(DataBaseConnectionRequest dataBaseConnectionRequest) {
        String url = dataBaseConnectionRequest.ip + ":" + dataBaseConnectionRequest.port + "/";
        switch (dataBaseConnectionRequest.databaseType) {
            case "mysql": {
                dataBaseConnectionRequest.driverClassName = "com.mysql.jdbc.Driver";
                dataBaseConnectionRequest.jdbcUrl = "jdbc:mysql://" + url;
                break;
            }
            case "mariadb": {
                dataBaseConnectionRequest.driverClassName = "org.mariadb.jdbc.Driver";
                dataBaseConnectionRequest.jdbcUrl = "jdbc:mariadb://" + url;
                break;
            }
            case "postgre": {
                dataBaseConnectionRequest.driverClassName = "org.postgresql.Driver";
                dataBaseConnectionRequest.jdbcUrl = "jdbc:postgresql://" + url;
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b:" + dataBaseConnectionRequest.databaseType);
            }
        }
    }
}

