/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.dns.domain;

import cn.schoolwow.quickdns.dns.domain.DNSRequest;
import cn.schoolwow.quickdns.dns.domain.header.Header;
import cn.schoolwow.quickdns.dns.domain.question.Question;
import cn.schoolwow.quickdns.dns.domain.resourceRecord.ResourceRecord;
import java.util.ArrayList;
import java.util.List;

public class DNSResponse {
    public Header header;
    public Question[] questions;
    public List<ResourceRecord> answers = new ArrayList<ResourceRecord>();
    public List<ResourceRecord> authorities = new ArrayList<ResourceRecord>();
    public List<ResourceRecord> additionals = new ArrayList<ResourceRecord>();
    public byte[] rawBytes;

    public DNSResponse() {
    }

    public DNSResponse(DNSRequest dnsRequest) {
        this.header = dnsRequest.header;
        this.questions = dnsRequest.questions;
    }

    public ResourceRecord answer(Question question, String value) {
        ResourceRecord answer = new ResourceRecord(question);
        answer.RDATAFormat = value;
        this.answers.add(answer);
        return answer;
    }

    public ResourceRecord authority(Question question, String value) {
        ResourceRecord authority = new ResourceRecord(question);
        authority.RDATAFormat = value;
        this.authorities.add(authority);
        return authority;
    }

    public ResourceRecord additional(Question question, String value) {
        ResourceRecord additional = new ResourceRecord(question);
        additional.RDATAFormat = value;
        this.additionals.add(additional);
        return additional;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{\u5934\u90e8:" + this.header + "");
        if (this.questions.length > 0) {
            builder.append(",\u95ee\u9898:[");
            for (Question question : this.questions) {
                builder.append(question);
            }
            builder.append("]");
        }
        if (this.answers.size() > 0) {
            builder.append(",\u7b54\u6848:[");
            for (ResourceRecord answer : this.answers) {
                builder.append(answer);
            }
            builder.append("]");
        }
        if (this.authorities.size() > 0) {
            builder.append(",\u6743\u5a01\u8bb0\u5f55:[");
            for (ResourceRecord authority : this.authorities) {
                builder.append(authority);
            }
            builder.append("]");
        }
        if (this.additionals.size() > 0) {
            builder.append(",\u9644\u52a0\u8bb0\u5f55:[");
            for (ResourceRecord additional : this.additionals) {
                builder.append(additional);
            }
            builder.append("]");
        }
        return builder.toString();
    }
}

