/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.dns.domain.question;

import cn.schoolwow.quickdns.dns.DNSServerUtil;
import cn.schoolwow.quickdns.dns.domain.header.Header;
import cn.schoolwow.quickdns.dns.domain.question.constants.QCLASS;
import cn.schoolwow.quickdns.dns.domain.question.constants.QTYPE;
import cn.schoolwow.quickdns.dns.stream.DNSStream;
import cn.schoolwow.quickdns.util.BitUtil;
import cn.schoolwow.quickhttp.QuickHttp;
import cn.schoolwow.quickhttp.request.Request;
import cn.schoolwow.quickhttp.response.Response;
import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Question {
    protected static Logger logger = LoggerFactory.getLogger(Question.class);
    public String qName;
    public QTYPE qType;
    public QCLASS qClass = QCLASS.IN;

    public Question() {
    }

    public Question(String qName, QTYPE qType) {
        this.qName = qName;
        this.qType = qType;
    }

    public static Question[] readQuestions(DNSStream dnsStream, Header header, byte[] rawData, Map<Integer, String> offsetStringCache) throws IOException {
        Question[] questions = new Question[header.questionCount];
        for (int i = 0; i < questions.length; ++i) {
            questions[i] = Question.readQuestion(dnsStream, rawData, offsetStringCache);
        }
        return questions;
    }

    public static void writeQuestion(DNSStream dnsStream, Question question, Map<String, Integer> offsetStringCache) throws IOException {
        Question.writeDomainName(dnsStream, question.qName, offsetStringCache);
        dnsStream.writeShort(question.qType.value);
        dnsStream.writeShort(question.qClass.value);
    }

    public static void writeDomainName(DNSStream dnsStream, String domainName, Map<String, Integer> offsetStringCache) throws IOException {
        while (true) {
            if (offsetStringCache.containsKey(domainName)) {
                dnsStream.writeBit(new int[]{1, 1, 0, 0, 0, 0, 0, 0});
                dnsStream.writeByte(offsetStringCache.get(domainName));
                break;
            }
            if (!domainName.contains(".")) {
                offsetStringCache.put(domainName, dnsStream.size());
                dnsStream.writeByte(domainName.length());
                dnsStream.writeBytes(domainName);
                dnsStream.writeByte(0);
                break;
            }
            String firstDomain = domainName.substring(0, domainName.indexOf("."));
            offsetStringCache.put(domainName, dnsStream.size());
            dnsStream.writeByte(firstDomain.length());
            dnsStream.writeBytes(firstDomain);
            domainName = domainName.substring(firstDomain.length() + 1);
        }
    }

    public static void writeCharacterString(DNSStream dnsStream, String characterString) throws IOException {
        dnsStream.writeByte(characterString.length());
        dnsStream.writeBytes(characterString);
    }

    protected static Question readQuestion(DNSStream dnsStream, byte[] rawData, Map<Integer, String> offsetStringCache) throws IOException {
        short qClass;
        Question question = new Question();
        question.qName = Question.readDomainName(dnsStream, rawData, offsetStringCache);
        short qTypeValue = dnsStream.readShort();
        question.qType = QTYPE.getQTYPE(qTypeValue);
        if (QTYPE.Unknown.equals((Object)question.qType)) {
            logger.warn("[\u4e0d\u652f\u6301\u7684QType\u7c7b\u578b]\u5f53\u524d\u503c:{}", (Object)qTypeValue);
        }
        if ((qClass = dnsStream.readShort()) == 1) {
            question.qClass = QCLASS.IN;
        }
        return question;
    }

    protected static String readDomainName(DNSStream dnsStream, byte[] rawData, Map<Integer, String> offsetStringCache) throws IOException {
        int stackTraceLength = Thread.currentThread().getStackTrace().length;
        if (stackTraceLength >= 255) {
            throw new IOException("DNS\u62a5\u6587\u89e3\u6790\u5931\u8d25!\u9012\u5f52\u6808\u5e27\u8d85\u8fc7255!");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int[] bits = BitUtil.getBitByte((byte)dnsStream.read());
        int value = BitUtil.getBitValue(bits, 0, 7);
        while (value != 0) {
            if (bits[0] == 1 && bits[1] == 1) {
                int[] secondBits = dnsStream.readBitByte();
                int[] offsetBits = new int[16];
                System.arraycopy(bits, 0, offsetBits, 0, 8);
                System.arraycopy(secondBits, 0, offsetBits, 8, 8);
                int offset = BitUtil.getBitValue(offsetBits, 2, 15);
                logger.trace("[\u5916\u90e8-\u8bfb\u53d6\u6307\u9488]{}", (Object)offset);
                Question.readOffsetDomain(baos, offset, rawData, offsetStringCache);
                break;
            }
            if (bits[0] == 0 && bits[1] == 0) {
                for (int i = 0; i < value; ++i) {
                    baos.write(dnsStream.readByte());
                }
            } else {
                throw new IOException("\u57df\u540d\u5b57\u8282\u6700\u9ad8\u4e24\u4f4d\u4e0d\u662f00\u6216\u800511,\u89e3\u6790\u5931\u8d25!\u5f53\u524d\u503c:" + value + ",\u4e8c\u8fdb\u5236\u4f4d:" + JSON.toJSONString(bits));
            }
            bits = dnsStream.readBitByte();
            value = BitUtil.getBitValue(bits, 0, 7);
            if (value <= 0) continue;
            baos.write(46);
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    public static String readCharacterString(DNSStream dnsStream) throws IOException {
        int length = dnsStream.read();
        byte[] bytes = new byte[length];
        dnsStream.read(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void readOffsetDomain(ByteArrayOutputStream baos, int offset, byte[] rawData, Map<Integer, String> offsetStringCache) throws IOException {
        int stackTraceLength = Thread.currentThread().getStackTrace().length;
        if (stackTraceLength >= 255) {
            throw new IOException("DNS\u62a5\u6587\u89e3\u6790\u5931\u8d25!\u9012\u5f52\u6808\u5e27\u8d85\u8fc7255!");
        }
        if (offsetStringCache.containsKey(offset)) {
            baos.write(offsetStringCache.get(offset).getBytes(StandardCharsets.UTF_8));
            logger.trace("[\u8fd4\u56de\u7f13\u5b58\u5b57\u7b26\u4e32]{}", (Object)offsetStringCache.get(offset));
            return;
        }
        ByteArrayOutputStream offsetBaos = new ByteArrayOutputStream();
        int initialOffset = offset;
        int[] bits = BitUtil.getBitByte(rawData[offset]);
        int value = BitUtil.getBitValue(bits, 0, 7);
        while (value != 0) {
            if (bits[0] == 1 && bits[1] == 1) {
                int[] secondBits = BitUtil.getBitByte(rawData[offset + 1]);
                int[] offsetBits = new int[16];
                System.arraycopy(bits, 0, offsetBits, 0, 8);
                System.arraycopy(secondBits, 0, offsetBits, 8, 8);
                int newOffset = BitUtil.getBitValue(offsetBits, 2, 15);
                logger.trace("[\u5185\u90e8-\u8bfb\u53d6\u6307\u9488]{}", (Object)newOffset);
                Question.readOffsetDomain(offsetBaos, newOffset, rawData, offsetStringCache);
                break;
            }
            if (bits[0] == 0 && bits[1] == 0) {
                offsetBaos.write(rawData, offset + 1, value);
                offset += value + 1;
            }
            if ((value = BitUtil.getBitValue(bits = BitUtil.getBitByte(rawData[offset]), 0, 7)) > 0) {
                offsetBaos.write(46);
            }
            if (offsetBaos.size() < 512) continue;
            logger.warn("[\u5f02\u5e38\u4e3b\u673a\u57df\u540d]\u539f\u59cb\u62a5\u6587:{}", (Object)DNSServerUtil.byteArrayToHex(rawData));
            Response response = QuickHttp.connect("https://ntfy.schoolwow.cn/quickdns").method(Request.Method.POST).setHeader("Title", "\u5f02\u5e38\u4e3b\u673a\u57df\u540d").requestBody(DNSServerUtil.byteArrayToHex(rawData)).execute();
            break;
        }
        String cacheString = new String(offsetBaos.toByteArray(), StandardCharsets.UTF_8);
        offsetStringCache.put(initialOffset, cacheString);
        logger.trace("[\u653e\u5165\u5b57\u7b26\u4e32\u7f13\u5b58]{},{}", (Object)initialOffset, (Object)cacheString);
        offsetBaos.writeTo(baos);
    }

    public String toString() {
        return "{\u67e5\u8be2\u57df\u540d:" + this.qName + ",\u67e5\u8be2\u7c7b\u578b:" + this.qType.name() + ",\u67e5\u8be2\u534f\u8bae\u7c7b:" + this.qClass.name() + "}";
    }
}

