/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.install.http;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpResponse {
    public HttpResponseMockConfig httpResponseMockConfig = new HttpResponseMockConfig();

    public static HttpResponse newInstance() {
        return new HttpResponse();
    }

    private HttpResponse() {
    }

    public HttpResponse statusCode(int statusCode) {
        this.httpResponseMockConfig.statusCode = statusCode;
        return this;
    }

    public HttpResponse header(String name, String value) {
        this.httpResponseMockConfig.responseHeader.put(name, Arrays.asList(value));
        return this;
    }

    public HttpResponse header(String name, List<String> valueList) {
        this.httpResponseMockConfig.responseHeader.put(name, valueList);
        return this;
    }

    public HttpResponse body(byte[] body) {
        this.httpResponseMockConfig.body = body;
        return this;
    }

    public HttpResponse body(String body) {
        this.httpResponseMockConfig.body = body.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public HttpResponse body(Object body) {
        this.httpResponseMockConfig.responseHeader.put("Content-Type", Arrays.asList("application/json; charset=utf-8"));
        this.httpResponseMockConfig.body = JSON.toJSONString(body).getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public HttpResponse redirect(String url) {
        this.httpResponseMockConfig.statusCode = 302;
        this.httpResponseMockConfig.responseHeader.put("Location", Arrays.asList(url));
        return this;
    }

    class HttpResponseMockConfig {
        int statusCode = 200;
        String url;
        Map<String, List<String>> responseHeader = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        byte[] body;

        HttpResponseMockConfig() {
        }
    }
}

