/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.service;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdns.dns.DNSHandler;
import cn.schoolwow.quickdns.entity.DNSBlockFile;
import cn.schoolwow.quickdns.service.DNSBlockFileService;
import cn.schoolwow.quickdns.task.DNSBlockFileScheduledThread;
import cn.schoolwow.quickhttp.QuickHttp;
import cn.schoolwow.quickhttp.response.Response;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;

@Service
public class DNSBlockFileServiceImpl
implements DNSBlockFileService {
    private Logger logger = LoggerFactory.getLogger(DNSBlockFileServiceImpl.class);
    @Resource
    private DAO dao;
    @Resource
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    private Map<Long, ScheduledFuture> dnsBlockFileScheduleTaskMap = new HashMap<Long, ScheduledFuture>();

    @Override
    public void scheduleDNSBlockFileCronTask(DNSBlockFile dnsBlockFile) {
        this.logger.info("[\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1]id:{}, cron:{}, url:{}", dnsBlockFile.getId(), dnsBlockFile.getCron(), dnsBlockFile.getUrl());
        DNSBlockFileScheduledThread dnsBlockFileScheduledThread = new DNSBlockFileScheduledThread(this, dnsBlockFile);
        ScheduledFuture<?> scheduledFuture = this.threadPoolTaskScheduler.schedule((Runnable)dnsBlockFileScheduledThread, new CronTrigger(dnsBlockFile.getCron()));
        this.dnsBlockFileScheduleTaskMap.put(dnsBlockFile.getId(), scheduledFuture);
    }

    @Override
    public void cancelDNSBlockFileCronTask(DNSBlockFile dnsBlockFile) {
        this.logger.info("[\u53d6\u6d88\u5b9a\u65f6\u4efb\u52a1]id:{}, cron:{}, url:{}", dnsBlockFile.getId(), dnsBlockFile.getCron(), dnsBlockFile.getUrl());
        if (this.dnsBlockFileScheduleTaskMap.containsKey(dnsBlockFile.getId())) {
            this.dnsBlockFileScheduleTaskMap.get(dnsBlockFile.getId()).cancel(true);
            this.dnsBlockFileScheduleTaskMap.remove(dnsBlockFile.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDNSBlockFileCache(DNSBlockFile dnsBlockFile) throws IOException {
        String url = dnsBlockFile.getUrl();
        Path tempFilePath = null;
        if (url.startsWith("http")) {
            tempFilePath = Files.createTempFile("DNSBlock", ".txt", new FileAttribute[0]);
            Response response = QuickHttp.connect(url).execute();
            if (null != response) {
                response.bodyAsFile(tempFilePath);
            }
        } else {
            tempFilePath = Paths.get(url, new String[0]);
        }
        Map<String, List<String>> map = DNSHandler.dnsBlockCache;
        synchronized (map) {
            DNSHandler.dnsBlockCache.remove(url);
            DNSHandler.dnsBlockCache.put(url, new ArrayList());
            Files.lines(tempFilePath).forEach(line -> {
                if (line.startsWith("#") || line.trim().isEmpty()) {
                    return;
                }
                DNSHandler.dnsBlockCache.get(url).add((String)line);
            });
            dnsBlockFile.setCount(DNSHandler.dnsBlockCache.get(dnsBlockFile.getUrl()).size());
        }
        dnsBlockFile.setLastUpdated(new Timestamp(System.currentTimeMillis()));
    }
}

