/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.service;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdns.config.QuickDNSServerConfig;
import cn.schoolwow.quickdns.dns.DNSHandler;
import cn.schoolwow.quickdns.service.GFWService;
import cn.schoolwow.quickdns.task.GFWScheduledThread;
import cn.schoolwow.quickhttp.QuickHttp;
import cn.schoolwow.quickhttp.response.Response;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Base64;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;

@Service
public class GFWServiceImpl
implements GFWService {
    private Logger logger = LoggerFactory.getLogger(GFWServiceImpl.class);
    @Resource
    private DAO dao;
    @Resource
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    private ScheduledFuture scheduledFuture;

    @Override
    public void scheduleGFWTask() {
        this.logger.info("[\u5f00\u542fGFW\u5b9a\u65f6\u6293\u53d6\u4efb\u52a1]cron:{}", (Object)QuickDNSServerConfig.quickDNSConfigProperties.gfwCron);
        GFWScheduledThread gfwScheduledThread = new GFWScheduledThread(this);
        this.scheduledFuture = this.threadPoolTaskScheduler.schedule((Runnable)gfwScheduledThread, new CronTrigger(QuickDNSServerConfig.quickDNSConfigProperties.gfwCron));
    }

    @Override
    public void cancelGFWCronTask() {
        if (null != this.scheduledFuture) {
            this.scheduledFuture.cancel(true);
        }
    }

    @Override
    public int analyzeGFWFile() throws IOException {
        Path path = Paths.get(System.getProperty("user.dir") + "/gfwlist.txt", new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            this.logger.warn("\u672c\u5730GFW\u6587\u4ef6\u4e0d\u5b58\u5728!{}", (Object)path);
            return 0;
        }
        byte[] bytes = Files.readAllBytes(path);
        bytes = Base64.getMimeDecoder().decode(bytes);
        Path decodeFilePath = Paths.get(System.getProperty("user.dir") + "/gfwlist_decoded.txt", new String[0]);
        Files.deleteIfExists(decodeFilePath);
        Files.write(decodeFilePath, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        String content = new String(bytes, StandardCharsets.UTF_8);
        StringTokenizer st = new StringTokenizer(content, "\n");
        HashSet<String> gfwDomainSet = new HashSet<String>();
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.startsWith("!") || line.startsWith("@@")) continue;
            if (line.startsWith("||")) {
                gfwDomainSet.add(line.substring(2));
                continue;
            }
            if (line.startsWith("|")) {
                int indexOf = line.indexOf("://");
                if (indexOf <= 0) continue;
                gfwDomainSet.add(line.substring(indexOf + 3));
                continue;
            }
            if (line.contains("/")) {
                line = line.substring(0, line.indexOf("/"));
            }
            if (line.contains("*")) {
                line = line.substring(0, line.indexOf("*"));
            }
            if (line.isEmpty()) continue;
            gfwDomainSet.add(line);
        }
        this.logger.info("[\u89e3\u6790GFW\u6587\u4ef6\u6210\u529f]\u57df\u540d\u4e2a\u6570:{}", (Object)gfwDomainSet.size());
        DNSHandler.gfwDomainSet.clear();
        DNSHandler.gfwDomainSet.addAll(gfwDomainSet);
        return gfwDomainSet.size();
    }

    @Override
    public int updateGFWListCache() throws IOException {
        this.downloadGFWFile();
        return this.analyzeGFWFile();
    }

    private void downloadGFWFile() throws IOException {
        Path filePath = Paths.get(System.getProperty("user.dir") + "/gfwlist.txt", new String[0]);
        Files.deleteIfExists(filePath);
        String url = "https://gitlab.com/gfwlist/gfwlist/raw/master/gfwlist.txt";
        Response response = QuickHttp.connect(url).execute();
        response.bodyAsFile(filePath);
    }
}

