/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.document.query;

import cn.schoolwow.quickhttp.document.element.Element;
import cn.schoolwow.quickhttp.document.query.Evaluator;

public abstract class StructuralEvaluator
extends Evaluator {
    protected Evaluator evaluator;

    public StructuralEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public abstract boolean matches(Element var1);

    public static class ImmediatePreviousSibling
    extends StructuralEvaluator {
        public ImmediatePreviousSibling(Evaluator evaluator) {
            super(evaluator);
        }

        @Override
        public boolean matches(Element element) {
            if (element.parent() == null) {
                return false;
            }
            Element prev = element.previousElementSibling();
            return prev != null && this.evaluator.matches(prev);
        }

        public String toString() {
            return String.format(":prev %s", this.evaluator);
        }
    }

    public static class PreviousSibling
    extends StructuralEvaluator {
        public PreviousSibling(Evaluator evaluator) {
            super(evaluator);
        }

        @Override
        public boolean matches(Element element) {
            if (element.parent() == null) {
                return false;
            }
            for (Element prev = element.previousElementSibling(); prev != null; prev = prev.previousElementSibling()) {
                if (!this.evaluator.matches(prev)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format(":prev* %s", this.evaluator);
        }
    }

    public static class ImmediateParent
    extends StructuralEvaluator {
        public ImmediateParent(Evaluator evaluator) {
            super(evaluator);
        }

        @Override
        public boolean matches(Element element) {
            if (element.parent() == null) {
                return false;
            }
            Element parent = element.parent();
            return parent != null && this.evaluator.matches(parent);
        }

        public String toString() {
            return String.format(":ImmediateParent %s", this.evaluator);
        }
    }

    public static class Parent
    extends StructuralEvaluator {
        public Parent(Evaluator evaluator) {
            super(evaluator);
        }

        @Override
        public boolean matches(Element element) {
            if (element.parent() == null) {
                return false;
            }
            Element parent = element.parent();
            while (true) {
                if (this.evaluator.matches(parent)) {
                    return true;
                }
                if (parent.parent() == null) break;
                parent = parent.parent();
            }
            return false;
        }

        public String toString() {
            return String.format(":parent %s", this.evaluator);
        }
    }

    public static class Not
    extends StructuralEvaluator {
        public Not(Evaluator evaluator) {
            super(evaluator);
        }

        @Override
        public boolean matches(Element element) {
            return !this.evaluator.matches(element);
        }

        public String toString() {
            return String.format(":not %s", this.evaluator);
        }
    }

    public static class Has
    extends StructuralEvaluator {
        public Has(Evaluator evaluator) {
            super(evaluator);
        }

        @Override
        public boolean matches(Element element) {
            for (Element e : element.getAllElements()) {
                if (e == element || !this.evaluator.matches(e)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format(":has(%s)", this.evaluator);
        }
    }
}

