/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.handler;

import cn.schoolwow.quickhttp.domain.ClientConfig;
import cn.schoolwow.quickhttp.domain.LogLevel;
import cn.schoolwow.quickhttp.domain.MetaWrapper;
import cn.schoolwow.quickhttp.domain.RequestMeta;
import cn.schoolwow.quickhttp.domain.ResponseMeta;
import cn.schoolwow.quickhttp.handler.Handler;
import cn.schoolwow.quickhttp.request.Request;
import cn.schoolwow.quickhttp.response.Response;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHandler
implements Handler {
    private Logger logger = LoggerFactory.getLogger(AbstractHandler.class);
    protected RequestMeta requestMeta;
    protected Request request;
    protected ResponseMeta responseMeta;
    protected Response response;
    protected ClientConfig clientConfig;
    protected MetaWrapper metaWrapper;

    public AbstractHandler(MetaWrapper metaWrapper) {
        this.requestMeta = metaWrapper.requestMeta;
        this.request = metaWrapper.request;
        this.responseMeta = metaWrapper.responseMeta;
        this.response = metaWrapper.response;
        this.clientConfig = metaWrapper.clientConfig;
        this.metaWrapper = metaWrapper;
    }

    protected void log(LogLevel logLevel, String message, Object ... parameters) {
        if (null != this.metaWrapper.pw) {
            StringBuilder builder = new StringBuilder(message);
            for (Object parameter : parameters) {
                int startIndex = builder.indexOf("{");
                int endIndex = builder.indexOf("}");
                if (startIndex <= 0 || endIndex <= 0) continue;
                builder.replace(startIndex, endIndex + 1, parameter.toString());
            }
            this.metaWrapper.pw.append(logLevel.name().toString() + " " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")) + " " + builder.toString() + "\n");
        }
        switch (logLevel) {
            case TRACE: {
                this.logger.trace(message, parameters);
                break;
            }
            case DEBUG: {
                this.logger.debug(message, parameters);
                break;
            }
            case INFO: {
                this.logger.info(message, parameters);
                break;
            }
            case WARN: {
                this.logger.warn(message, parameters);
                break;
            }
            case ERROR: {
                this.logger.error(message, parameters);
            }
        }
    }
}

