/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.handler;

import cn.schoolwow.quickhttp.document.Document;
import cn.schoolwow.quickhttp.document.element.Element;
import cn.schoolwow.quickhttp.document.element.Elements;
import cn.schoolwow.quickhttp.domain.LogLevel;
import cn.schoolwow.quickhttp.domain.MetaWrapper;
import cn.schoolwow.quickhttp.handler.AbstractHandler;
import cn.schoolwow.quickhttp.handler.EventSourceHandler;
import cn.schoolwow.quickhttp.handler.Handler;
import cn.schoolwow.quickhttp.response.ResponseImpl;
import cn.schoolwow.quickhttp.response.SpeedLimitInputStream;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.www.MessageHeader;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.https.DelegateHttpsURLConnection;
import sun.net.www.protocol.https.HttpsURLConnectionImpl;

public class ResponseHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(ResponseHandler.class);

    public ResponseHandler(MetaWrapper metaWrapper) {
        super(metaWrapper);
    }

    @Override
    public Handler handle() throws IOException {
        boolean statusError = false;
        if (this.requestMeta.ignoreHttpErrors || this.clientConfig.ignoreHttpErrors) {
            try {
                this.getStatusCode();
            }
            catch (FileNotFoundException e) {
                statusError = true;
                this.responseMeta.statusCode = 404;
                this.responseMeta.statusMessage = "Not Found";
                this.log(LogLevel.ERROR, "\u94fe\u63a5404", new Object[0]);
            }
            catch (IOException e) {
                statusError = true;
                String message = e.getMessage();
                if (message.startsWith("Server returned HTTP response code: ")) {
                    this.responseMeta.statusCode = Integer.parseInt(message.substring("Server returned HTTP response code: ".length(), message.indexOf(" for URL: ")));
                    this.responseMeta.statusMessage = "";
                }
                e.printStackTrace(this.metaWrapper.pw);
            }
        } else {
            this.getStatusCode();
        }
        this.getRequestHeader();
        this.getResponseHeader();
        if (!statusError) {
            this.getBody();
            this.getCharset();
        }
        return new EventSourceHandler(this.metaWrapper);
    }

    private void getStatusCode() throws IOException {
        String substring;
        java.net.HttpURLConnection httpURLConnection = this.responseMeta.httpURLConnection;
        this.responseMeta.statusCode = httpURLConnection.getResponseCode();
        this.responseMeta.statusMessage = httpURLConnection.getResponseMessage();
        if (null == this.responseMeta.statusMessage) {
            this.responseMeta.statusMessage = "";
        }
        this.responseMeta.topHost = httpURLConnection.getURL().getHost();
        if (this.responseMeta.topHost.contains(".") && (substring = this.responseMeta.topHost.substring(0, this.responseMeta.topHost.lastIndexOf("."))).contains(".")) {
            this.responseMeta.topHost = this.responseMeta.topHost.substring(substring.lastIndexOf(".") + 1);
        }
    }

    private void getRequestHeader() {
        try {
            Field requestsMessageHeaderField = HttpURLConnection.class.getDeclaredField("requests");
            requestsMessageHeaderField.setAccessible(true);
            MessageHeader requestsMessageHeader = null;
            if (this.responseMeta.httpURLConnection instanceof HttpsURLConnection) {
                Field delegateField = HttpsURLConnectionImpl.class.getDeclaredField("delegate");
                delegateField.setAccessible(true);
                DelegateHttpsURLConnection delegateHttpsURLConnection = (DelegateHttpsURLConnection)delegateField.get(this.responseMeta.httpURLConnection);
                requestsMessageHeader = (MessageHeader)requestsMessageHeaderField.get(delegateHttpsURLConnection);
            } else {
                requestsMessageHeader = (MessageHeader)requestsMessageHeaderField.get(this.responseMeta.httpURLConnection);
            }
            Map<String, List<String>> headerMap = requestsMessageHeader.getHeaders();
            Set<Map.Entry<String, List<String>>> entrySet = headerMap.entrySet();
            this.requestMeta.headerMap.clear();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                if (null == entry.getValue().get(0)) {
                    this.requestMeta.statusLine = entry.getKey();
                    continue;
                }
                this.requestMeta.headerMap.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            URI uri = this.responseMeta.httpURLConnection.getURL().toURI();
            this.clientConfig.cookieManager.put(uri, this.responseMeta.httpURLConnection.getHeaderFields());
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        this.metaWrapper.response = new ResponseImpl(this.requestMeta, this.responseMeta, this.clientConfig);
    }

    private void getResponseHeader() {
        try {
            Field responsesMessageHeaderField = HttpURLConnection.class.getDeclaredField("responses");
            responsesMessageHeaderField.setAccessible(true);
            MessageHeader responsesMessageHeader = null;
            if (this.responseMeta.httpURLConnection instanceof HttpsURLConnection) {
                Field delegateField = HttpsURLConnectionImpl.class.getDeclaredField("delegate");
                delegateField.setAccessible(true);
                DelegateHttpsURLConnection delegateHttpsURLConnection = (DelegateHttpsURLConnection)delegateField.get(this.responseMeta.httpURLConnection);
                responsesMessageHeader = (MessageHeader)responsesMessageHeaderField.get(delegateHttpsURLConnection);
            } else {
                responsesMessageHeader = (MessageHeader)responsesMessageHeaderField.get(this.responseMeta.httpURLConnection);
            }
            Map<String, List<String>> headerMap = responsesMessageHeader.getHeaders();
            Set<Map.Entry<String, List<String>>> entrySet = headerMap.entrySet();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                if (null == entry.getKey()) {
                    this.responseMeta.statusLine = entry.getValue().get(0);
                    continue;
                }
                List<String> values = entry.getValue();
                ArrayList<String> newValues = new ArrayList<String>(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    if (null == values.get(i)) continue;
                    newValues.add(new String(values.get(i).getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8));
                }
                this.responseMeta.headerMap.put(entry.getKey(), newValues);
                if (!"Content-Type".equalsIgnoreCase(entry.getKey())) continue;
                this.responseMeta.contentType = (String)newValues.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getBody() throws IOException {
        if (!this.requestMeta.ignoreHttpErrors && !this.clientConfig.ignoreHttpErrors && this.responseMeta.statusCode >= 400) {
            this.log(LogLevel.WARN, "[\u8df3\u8fc7\u83b7\u53d6\u8bf7\u6c42\u4f53]\u5f53\u524d\u72b6\u6001\u7801\u65e0\u6cd5\u83b7\u53d6\u8bf7\u6c42\u4f53,\u5f53\u524d\u72b6\u6001\u7801:{}", this.responseMeta.statusCode);
            return;
        }
        try {
            InputStream inputStream;
            String contentEncoding = this.responseMeta.httpURLConnection.getContentEncoding();
            InputStream inputStream2 = inputStream = this.responseMeta.httpURLConnection.getErrorStream() != null ? this.responseMeta.httpURLConnection.getErrorStream() : this.responseMeta.httpURLConnection.getInputStream();
            if (contentEncoding != null && !contentEncoding.isEmpty()) {
                if (contentEncoding.equals("gzip")) {
                    inputStream = new GZIPInputStream(inputStream);
                } else if (contentEncoding.equals("deflate")) {
                    inputStream = new InflaterInputStream(inputStream, new Inflater(true));
                }
            }
            this.responseMeta.inputStream = inputStream;
            this.responseMeta.inputStream = new BufferedInputStream(inputStream);
            this.responseMeta.inputStream = new SpeedLimitInputStream(this.responseMeta.inputStream);
        }
        catch (IOException e) {
            this.log(LogLevel.WARN, "\u8bfb\u53d6\u8f93\u5165\u6d41\u5931\u8d25", new Object[0]);
            if (null != this.metaWrapper.pw) {
                e.printStackTrace(this.metaWrapper.pw);
            }
            e.printStackTrace();
        }
    }

    private void getCharset() throws IOException {
        this.getCharsetFromContentType(this.responseMeta.httpURLConnection.getContentType());
        if (this.responseMeta.charset == null && null != this.responseMeta.inputStream) {
            byte[] bytes = new byte[5120];
            this.responseMeta.inputStream.mark(bytes.length);
            this.responseMeta.inputStream.read(bytes, 0, bytes.length);
            boolean readFully = this.responseMeta.inputStream.read() == -1;
            this.responseMeta.inputStream.reset();
            ByteBuffer firstBytes = ByteBuffer.wrap(bytes);
            this.getCharsetFromBOM(firstBytes);
            if (this.responseMeta.charset == null) {
                this.getCharsetFromMeta(firstBytes, readFully);
            }
        }
        if (this.responseMeta.charset == null) {
            this.responseMeta.charset = "utf-8";
        }
    }

    private void getCharsetFromMeta(ByteBuffer byteBuffer, boolean readFully) {
        String docData = StandardCharsets.UTF_8.decode(byteBuffer).toString();
        if (!docData.startsWith("<?xml") && !docData.startsWith("<!DOCTYPE")) {
            return;
        }
        Document doc = Document.parse(docData);
        if (doc.root() == null) {
            return;
        }
        Elements metaElements = doc.select("meta[http-equiv=content-type], meta[charset]");
        Iterator iterator = metaElements.iterator();
        if (iterator.hasNext()) {
            Element meta = (Element)iterator.next();
            if (meta.hasAttr("http-equiv")) {
                this.getCharsetFromContentType(meta.attr("content"));
            }
            if (this.responseMeta.charset == null && meta.hasAttr("charset")) {
                this.responseMeta.charset = meta.attr("charset");
            }
        }
        if (this.responseMeta.charset == null) {
            Element root = doc.root();
            if (doc.root().tagName().equals("?xml") && root.hasAttr("encoding")) {
                this.responseMeta.charset = root.attr("encoding");
            }
        }
        if (readFully) {
            this.responseMeta.document = doc;
        }
    }

    private void getCharsetFromBOM(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer buffer = byteBuffer;
        ((Buffer)buffer).mark();
        byte[] bom = new byte[4];
        if (byteBuffer.remaining() >= bom.length) {
            byteBuffer.get(bom);
            ((Buffer)buffer).rewind();
        }
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1 || bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            this.responseMeta.charset = "utf-32";
        } else if (bom[0] == -2 && bom[1] == -1 || bom[0] == -1 && bom[1] == -2) {
            this.responseMeta.charset = "utf-16";
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            this.responseMeta.charset = "utf-8";
        }
        if (this.responseMeta.charset != null) {
            this.responseMeta.inputStream.skip(1L);
        }
    }

    private void getCharsetFromContentType(String contentType) {
        int startIndex;
        String prefix = "charset=";
        if (contentType != null && contentType.contains(prefix) && (startIndex = contentType.indexOf(prefix)) >= 0) {
            int endIndex = contentType.lastIndexOf(";");
            if (endIndex > startIndex) {
                this.responseMeta.charset = contentType.substring(startIndex + prefix.length(), endIndex).trim();
            } else if (endIndex < startIndex) {
                this.responseMeta.charset = contentType.substring(startIndex + prefix.length()).trim();
            }
        }
    }
}

