/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.response;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedLimitInputStream
extends InputStream {
    private Logger logger = LoggerFactory.getLogger(SpeedLimitInputStream.class);
    private volatile long bytesPerSecond;
    private volatile long totalReceivedBytes;
    private volatile long lastReceivedBytes;
    private volatile long lastRecordTime = System.nanoTime();
    private InputStream inputStream;

    public SpeedLimitInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public synchronized void setMaxDownloadSpeed(int setMaxDownloadSpeed) {
        this.bytesPerSecond = setMaxDownloadSpeed * 1024;
    }

    public synchronized void limit(int length) {
        this.totalReceivedBytes += (long)length;
        while (this.bytesPerSecond > 0L && this.totalReceivedBytes - this.lastReceivedBytes > this.bytesPerSecond) {
            long waitNanoTime = 1000000000L - (System.nanoTime() - this.lastRecordTime);
            if (waitNanoTime > 0L) {
                try {
                    Thread.sleep(waitNanoTime / 1000000L, (int)(waitNanoTime % 1000000L));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.lastRecordTime = System.nanoTime();
            this.lastReceivedBytes += this.bytesPerSecond;
        }
    }

    @Override
    public int read() throws IOException {
        this.limit(1);
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.limit(len);
        return this.inputStream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b.length > 0) {
            this.limit(b.length);
        }
        return this.inputStream.read(b);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }
}

