/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.domain;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.response.HttpStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseMeta {
    public String protocol = "HTTP/1.1";
    public int status;
    public String statusMessage;
    public Map<String, List<String>> headers = new HashMap<String, List<String>>();
    public String charset = "utf-8";
    public String contentType = "text/plain; charset=" + this.charset;
    public long contentLength;
    public String headerString;
    public InputStream bodyInputStream;
    public OutputStream outputStream;
    public String result;
    public Client client;
    private Logger logger = LoggerFactory.getLogger(HttpResponseMeta.class);

    public HttpResponseMeta(Client client) {
        this.headers.put("Date", Arrays.asList(new Date().toString()));
        this.headers.put("Server", Arrays.asList("QuickServer2"));
        this.client = client;
    }

    public void httpStatus(HttpStatus httpStatus) {
        this.status = httpStatus.status;
        this.statusMessage = httpStatus.statusMessage;
    }

    public void fillHeadStream() throws IOException {
        if (this.client.httpResponseMeta.status == 0) {
            this.client.httpResponseMeta.httpStatus(HttpStatus.OK);
        }
        this.headers.put("Content-Type", Arrays.asList(this.contentType));
        if (this.contentLength > 0L) {
            this.headers.put("Content-Length", Arrays.asList(this.contentLength + ""));
        }
        if (null == this.headerString) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.protocol + " " + this.status + " " + this.statusMessage + "\r\n");
            Set<Map.Entry<String, List<String>>> entrySet = this.headers.entrySet();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                for (String value : entry.getValue()) {
                    builder.append(entry.getKey() + ": " + value + "\r\n");
                }
            }
            builder.append("\r\n");
            this.headerString = builder.toString();
            this.outputStream.write(this.headerString.getBytes(this.charset));
            this.outputStream.flush();
        } else {
            this.logger.warn("[\u5934\u90e8\u62a5\u6587\u5df2\u5199\u5165]");
        }
    }
}

