/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.handler.RequestResponseLogHandler;
import cn.schoolwow.quickserver.response.HttpStatus;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseHandler
implements Handler {
    private static Logger logger = LoggerFactory.getLogger(HttpResponseHandler.class);

    @Override
    public Handler handle(Client client) throws IOException {
        if (client.socket.isClosed()) {
            logger.debug("[\u94fe\u63a5\u5df2\u5173\u95ed]\u5957\u63a5\u5b57:{}", (Object)client.socket);
            return new RequestResponseLogHandler();
        }
        if (null != client.httpResponseMeta.headerString) {
            logger.trace("[\u8bf7\u6c42\u5934\u90e8\u62a5\u6587\u5df2\u53d1\u9001]\u7ed3\u675f");
            client.httpResponseMeta.outputStream.flush();
            return new RequestResponseLogHandler();
        }
        this.handleHeader(client);
        this.handleBody(client);
        return new RequestResponseLogHandler();
    }

    private void handleHeader(Client client) throws IOException {
        this.handleRanges(client);
        this.handleGZip(client);
        if (client.httpResponseMeta.contentLength >= 0L) {
            client.httpResponseMeta.headers.put("Content-Length", Arrays.asList(client.httpResponseMeta.contentLength + ""));
        }
        if (client.serverConfigMeta.keepAlive) {
            client.httpResponseMeta.headers.put("Connection", Arrays.asList("keep-alive"));
        } else {
            client.httpResponseMeta.headers.put("Connection", Arrays.asList("close"));
        }
        if (null == client.httpResponseMeta.headerString) {
            client.httpResponseMeta.fillHeadStream();
        }
    }

    private void handleBody(Client client) throws IOException {
        if (null == client.httpResponseMeta.bodyInputStream) {
            return;
        }
        if (client.httpResponseMeta.status != 206) {
            byte[] bytes = new byte[8192];
            int length = 0;
            while ((length = client.httpResponseMeta.bodyInputStream.read(bytes, 0, bytes.length)) != -1) {
                client.httpResponseMeta.outputStream.write(bytes, 0, length);
                client.httpResponseMeta.outputStream.flush();
            }
        } else {
            String range = client.httpRequestMeta.headers.get("Range").get(0);
            int start = Integer.parseInt(range.substring(range.indexOf("=") + 1, range.indexOf("-")).trim());
            int end = range.endsWith("-") ? (int)client.httpResponseMeta.contentLength : Integer.parseInt(range.substring(range.indexOf("-") + 1));
            int size = end - start + 1;
            long skip = client.httpResponseMeta.bodyInputStream.skip(start);
            logger.trace("[\u5206\u6bb5\u4f20\u8f93]\u5b9e\u9645\u8df3\u8fc7\u5b57\u8282\u6570:{}", (Object)skip);
            byte[] bytes = new byte[8192];
            int actualLength = 0;
            int shouldReadLength = Math.min(size, bytes.length);
            while ((actualLength = client.httpResponseMeta.bodyInputStream.read(bytes, 0, shouldReadLength)) != -1) {
                client.httpResponseMeta.outputStream.write(bytes, 0, actualLength);
                if ((size -= bytes.length) > 0) {
                    shouldReadLength = Math.min(size, bytes.length);
                    continue;
                }
                break;
            }
        }
        client.httpResponseMeta.bodyInputStream.close();
        client.httpResponseMeta.outputStream.flush();
    }

    private void handleRanges(Client client) {
        List<String> ranges = client.httpRequestMeta.headers.get("Range");
        if (null != ranges && ranges.size() > 0 && client.httpResponseMeta.contentLength > 0L) {
            client.httpResponseMeta.httpStatus(HttpStatus.PARTIAL_CONTENT);
            String range = ranges.get(0);
            int start = Integer.parseInt(range.substring(range.indexOf("=") + 1, range.indexOf("-")).trim());
            int end = range.endsWith("-") ? (int)(client.httpResponseMeta.contentLength - 1L) : Integer.parseInt(range.substring(range.indexOf("-") + 1));
            int size = end - start + 1;
            if ((long)size > client.httpResponseMeta.contentLength) {
                logger.warn("[Range\u5934\u90e8\u6587\u4ef6\u5927\u4e8e\u5b9e\u9645\u6587\u4ef6]Range\u5934\u90e8\u5927\u5c0f:{},\u5b9e\u9645\u6587\u4ef6\u5927\u5c0f:{}", (Object)size, (Object)client.httpResponseMeta.contentLength);
                return;
            }
            client.httpResponseMeta.contentLength = size;
            logger.trace("[PARTIAL_CONTENT\u54cd\u5e94]start:{},end:{},size:{},\u8def\u5f84:{}", start, end, size, client.httpRequestMeta.uri);
            client.httpResponseMeta.headers.put("Content-Range", Arrays.asList("bytes " + start + "-" + end + "/" + size));
        }
    }

    private void handleGZip(Client client) {
        if (null == client.httpResponseMeta.bodyInputStream) {
            logger.trace("[gzip\u538b\u7f29]\u65e0body\u5185\u5bb9,\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        if (client.httpResponseMeta.headers.containsKey("Accept-Ranges") || client.httpResponseMeta.headers.containsKey("Content-Range")) {
            logger.trace("[gzip\u538b\u7f29]\u5206\u6bb5\u4e0b\u8f7d\u65f6\u4e0d\u8fdb\u884cgzip\u538b\u7f29");
            return;
        }
        if (!client.httpRequestMeta.headers.containsKey("Accept-Encoding") || !client.httpRequestMeta.headers.get("Accept-Encoding").get(0).contains("gzip")) {
            logger.trace("[gzip\u538b\u7f29]\u5ba2\u6237\u7aef\u4e0d\u652f\u6301gzip\u538b\u7f29");
            return;
        }
        if (client.httpResponseMeta.contentLength > 2048L && (null == client.httpResponseMeta.contentType || client.httpResponseMeta.contentType.startsWith("text/") || client.httpResponseMeta.contentType.startsWith("application/") || client.httpResponseMeta.contentType.startsWith("image/"))) {
            logger.trace("[\u5f00\u542fgzip\u538b\u7f29]");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);){
                byte[] bytes = new byte[8192];
                int length = 0;
                while ((length = client.httpResponseMeta.bodyInputStream.read(bytes, 0, bytes.length)) != -1) {
                    gzipOutputStream.write(bytes, 0, length);
                }
                gzipOutputStream.finish();
                client.httpResponseMeta.bodyInputStream = new ByteArrayInputStream(baos.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            client.httpResponseMeta.headers.put("Content-Encoding", Arrays.asList("gzip"));
            client.httpResponseMeta.contentLength = baos.size();
        }
    }
}

