/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.handler.KeepAliveHandler;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestResponseLogHandler
implements Handler {
    private static Logger logger = LoggerFactory.getLogger(RequestResponseLogHandler.class);

    @Override
    public Handler handle(Client client) throws Exception {
        logger.debug("[\u8bf7\u6c42\u4e0e\u54cd\u5e94]\n{}", (Object)this.getRequestAndResponseLog(client));
        return new KeepAliveHandler();
    }

    private String getRequestAndResponseLog(Client client) {
        StringBuilder contentBuilder = new StringBuilder("====================================================================\n");
        contentBuilder.append(client.httpRequestMeta.statusLine + "\n");
        Set<Map.Entry<String, List<String>>> requestHeaderSet = client.httpRequestMeta.headers.entrySet();
        for (Map.Entry<String, List<String>> entry : requestHeaderSet) {
            for (String value : entry.getValue()) {
                contentBuilder.append(entry.getKey() + ": " + value + "\n");
            }
        }
        if (null != client.httpRequestMeta.body) {
            if (client.httpRequestMeta.fileParameterMap.size() > 0) {
                contentBuilder.append("\n" + client.httpRequestMeta.fileParameterMap + "\n\n");
            } else {
                contentBuilder.append("\n" + client.httpRequestMeta.body + "\n\n");
            }
        } else if (null != client.httpRequestMeta.bodyBytes && client.httpRequestMeta.bodyBytes.length > 0) {
            contentBuilder.append("\n{" + client.httpRequestMeta.bodyBytes.length + "}\n\n");
        } else {
            contentBuilder.append("\n");
        }
        contentBuilder.append(client.httpResponseMeta.protocol + " " + client.httpResponseMeta.status + " " + client.httpResponseMeta.statusMessage + "\n");
        Set<Map.Entry<String, List<String>>> responseHeaderSet = client.httpResponseMeta.headers.entrySet();
        for (Map.Entry<String, List<String>> entry : responseHeaderSet) {
            for (String value : entry.getValue()) {
                contentBuilder.append(entry.getKey() + ": " + value + "\n");
            }
        }
        if (client.httpResponseMeta.contentLength > 0L) {
            if (null == client.httpResponseMeta.result) {
                contentBuilder.append("\n[" + client.httpResponseMeta.contentLength + "]");
            } else {
                contentBuilder.append("\n" + client.httpResponseMeta.result);
            }
        } else {
            contentBuilder.append("\n");
        }
        contentBuilder.append("\n====================================================================\n");
        return contentBuilder.toString();
    }
}

