/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.handler.HttpResponseHandler;
import cn.schoolwow.quickserver.response.HttpStatus;
import cn.schoolwow.quickserver.util.MIMEUtil;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticResourceHandler
implements Handler {
    private static Logger logger = LoggerFactory.getLogger(StaticResourceHandler.class);
    private static String[] indexHtmls = new String[]{"index.html", "index.htm", "index.jsp", "default.html", "default.htm"};

    @Override
    public Handler handle(Client client) throws IOException {
        this.getStaticResourcePath(client);
        if (!client.httpResponseMeta.headers.containsKey("ETag")) {
            client.httpResponseMeta.httpStatus(HttpStatus.NOT_FOUND);
            client.httpResponseMeta.contentLength = 0L;
        } else {
            client.httpResponseMeta.headers.put("Accept-Ranges", Arrays.asList("bytes"));
        }
        return new HttpResponseHandler();
    }

    private void getStaticResourcePath(Client client) throws IOException {
        this.getStaticResourcePath(client.httpRequestMeta.uri.getPath(), client);
        if (!client.httpResponseMeta.headers.containsKey("ETag") && client.httpRequestMeta.uri.getPath().endsWith("/")) {
            for (String indexHtml : indexHtmls) {
                this.getStaticResourcePath(client.httpRequestMeta.uri.getPath() + indexHtml, client);
                if (client.httpResponseMeta.headers.containsKey("ETag")) break;
            }
        }
    }

    private void getStaticResourcePath(String path, Client client) throws IOException {
        if ("/".equals(path)) {
            return;
        }
        Set<Map.Entry<String, String>> entrySet = client.serverConfigMeta.staticResourcePathMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            Path resourcePath;
            String staticResourcePath = entry.getKey();
            if (!entry.getValue().isEmpty()) {
                if (!client.httpRequestMeta.uri.getPath().startsWith(entry.getValue())) {
                    logger.trace("[\u9759\u6001\u8d44\u6e90\u8def\u5f84\u524d\u7f00\u4e0d\u5339\u914d]\u8def\u5f84\u524d\u7f00:{},\u5f53\u524d\u8def\u5f84:{}", (Object)entry.getValue(), (Object)path);
                    continue;
                }
                logger.trace("[\u5339\u914d\u9759\u6001\u8d44\u6e90\u8def\u5f84\u524d\u7f00]\u8bf7\u6c42\u8def\u5f84:{},\u8def\u5f84\u524d\u7f00:{}", (Object)path, (Object)entry.getValue());
                path = path.substring(entry.getValue().length());
            }
            if (Files.exists(resourcePath = Paths.get(entry.getKey() + "/" + path, new String[0]), new LinkOption[0]) && Files.isRegularFile(resourcePath, new LinkOption[0])) {
                this.handleETag(Files.getLastModifiedTime(resourcePath, new LinkOption[0]).toMillis(), Files.size(resourcePath), client);
                this.handleContentType(resourcePath.getFileName().toString(), client);
                if (!this.handleIfNoneMatch(client)) {
                    client.httpResponseMeta.bodyInputStream = Files.newInputStream(resourcePath, new OpenOption[0]);
                }
                return;
            }
            logger.warn("[\u4ece\u6307\u5b9a\u8def\u5f84\u4e2d\u83b7\u53d6\u9759\u6001\u8d44\u6e90\u5931\u8d25]\u8bf7\u6c42\u5730\u5740:{},\u8def\u5f84:{}", (Object)path, (Object)resourcePath);
        }
        path = client.serverConfigMeta.staticResourcePathPrefix + path;
        URL url = StaticResourceHandler.class.getResource(path);
        if (null != url) {
            switch (url.getProtocol()) {
                case "file": {
                    File file = new File(url.getFile());
                    if (file.isFile()) {
                        logger.trace("[\u6587\u4ef6\u8d44\u6e90]\u8def\u5f84:{}", (Object)file.getAbsolutePath());
                        this.handleETag(file.lastModified(), file.length(), client);
                        this.handleContentType(file.getName(), client);
                        if (!this.handleIfNoneMatch(client)) {
                            client.httpResponseMeta.bodyInputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
                        }
                        return;
                    }
                    logger.warn("[\u6587\u4ef6\u8d44\u6e90\u4e0d\u5b58\u5728]\u8bf7\u6c42\u8def\u5f84:{}, \u6587\u4ef6\u8def\u5f84:{}", (Object)path, (Object)file.getAbsolutePath());
                    break;
                }
                case "jar": {
                    JarEntry jarEntry;
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    JarFile jarFile = jarURLConnection.getJarFile();
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    if ((jarEntry = jarFile.getJarEntry(path)) == null || jarEntry.isDirectory()) {
                        logger.warn("[jar\u8d44\u6e90]jar\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u8005\u4e3a\u6587\u4ef6\u5939,\u8def\u5f84:{},jarEntry:{}", (Object)path, (Object)jarEntry);
                        return;
                    }
                    logger.trace("[jar\u8d44\u6e90]\u8def\u5f84:{}", (Object)jarEntry.getName());
                    this.handleETag(jarEntry.getLastModifiedTime().toMillis(), jarEntry.getSize(), client);
                    this.handleContentType(jarEntry.getName(), client);
                    if (this.handleIfNoneMatch(client)) break;
                    client.httpResponseMeta.bodyInputStream = jarFile.getInputStream(jarEntry);
                }
            }
        } else {
            logger.debug("[\u4ece\u7c7b\u8def\u5f84\u4e2d\u83b7\u53d6\u9759\u6001\u8d44\u6e90\u5931\u8d25]\u8def\u5f84:{}", (Object)path);
        }
    }

    private void handleETag(long lastModifiedTime, long fileSize, Client client) {
        String ETag = Long.toHexString(lastModifiedTime) + "-" + Long.toHexString(fileSize);
        client.httpResponseMeta.headers.put("ETag", Arrays.asList(ETag));
        client.httpResponseMeta.contentLength = fileSize;
    }

    private void handleContentType(String fileName, Client client) {
        String mimeType = MIMEUtil.getMIMEType(fileName);
        logger.trace("[\u83b7\u53d6Content-Type]Content-Type:{},\u6587\u4ef6\u540d:{}", (Object)mimeType, (Object)fileName);
        client.httpResponseMeta.contentType = mimeType;
    }

    private boolean handleIfNoneMatch(Client client) {
        String nowETag;
        String oldETag;
        if (client.httpRequestMeta.headers.containsKey("If-None-Match") && (oldETag = client.httpRequestMeta.headers.get("If-None-Match").get(0)).equals(nowETag = client.httpResponseMeta.headers.get("ETag").get(0))) {
            logger.trace("[\u6d4f\u89c8\u5668\u5df2\u7f13\u5b58\u9759\u6001\u8d44\u6e90]\u8fd4\u56deNOT_MODIFIED\u54cd\u5e94\u8def\u5f84:{}", (Object)client.httpRequestMeta.uri);
            client.httpResponseMeta.httpStatus(HttpStatus.NOT_MODIFIED);
            return true;
        }
        return false;
    }
}

