/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.request;

import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private InputStream inputStream;
    private int pos = 0;
    private int chunkSize = -1;

    public ChunkedInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.chunkSize == 0) {
            return -1;
        }
        if (this.pos < this.chunkSize) {
            ++this.pos;
            return this.inputStream.read();
        }
        if (this.pos == this.chunkSize) {
            if (13 != this.inputStream.read() || 10 != this.inputStream.read()) {
                throw new IOException("chunked\u5757\u5f02\u5e38!");
            }
            this.pos = 0;
        }
        StringBuilder lengthBuilder = new StringBuilder();
        int b = this.inputStream.read();
        while (-1 != b && b != 13) {
            lengthBuilder.append((char)b);
            b = this.inputStream.read();
        }
        if (b == -1 || 10 != this.inputStream.read()) {
            throw new IOException("chunked\u5757\u5f02\u5e38!");
        }
        this.chunkSize = Integer.parseInt(lengthBuilder.toString(), 16);
        ++this.pos;
        return this.inputStream.read();
    }
}

