/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.response;

import cn.schoolwow.quickserver.domain.HttpResponseMeta;
import cn.schoolwow.quickserver.response.EventSource;
import cn.schoolwow.quickserver.response.HttpResponse;
import cn.schoolwow.quickserver.response.HttpStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class HttpResponseImpl
implements HttpResponse {
    private HttpResponseMeta httpResponseMeta;

    public HttpResponseImpl(HttpResponseMeta httpResponseMeta) {
        this.httpResponseMeta = httpResponseMeta;
    }

    @Override
    public void status(HttpStatus httpStatus) {
        this.httpResponseMeta.httpStatus(httpStatus);
    }

    @Override
    public void charset(String charset) {
        this.httpResponseMeta.charset = charset;
    }

    @Override
    public void addCookie(HttpCookie httpCookie) {
        StringBuilder builder = new StringBuilder(httpCookie.getName() + "=" + httpCookie.getValue() + ";");
        if (httpCookie.getMaxAge() > 0L) {
            String expires = LocalDateTime.now().plusSeconds(httpCookie.getMaxAge()).format(DateTimeFormatter.ofPattern("EEE, d MMM yyyy HH:mm:ss 'GMT'", Locale.US));
            builder.append(" expires=" + expires + ";");
        }
        if (null != httpCookie.getDomain()) {
            builder.append(" domain=" + httpCookie.getDomain() + ";");
        }
        if (null != httpCookie.getPath()) {
            builder.append(" path=" + httpCookie.getPath() + ";");
        }
        if (!this.httpResponseMeta.headers.containsKey("Set-Cookie")) {
            this.httpResponseMeta.headers.put("Set-Cookie", new ArrayList());
        }
        this.httpResponseMeta.headers.get("Set-Cookie").add(builder.toString());
    }

    @Override
    public List<String> getHeader(String name) {
        return this.httpResponseMeta.headers.get(name);
    }

    @Override
    public void addHeader(String name, String value) {
        if (!this.httpResponseMeta.headers.containsKey(name)) {
            this.httpResponseMeta.headers.put(name, new ArrayList());
        }
        this.httpResponseMeta.headers.get(name).add(value);
    }

    @Override
    public void setHeader(String name, String value) {
        this.httpResponseMeta.headers.put(name, new ArrayList<String>(Arrays.asList(value)));
    }

    @Override
    public String getCharset() {
        return this.httpResponseMeta.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.httpResponseMeta.charset = charset;
    }

    @Override
    public void setCharset(Charset charset) {
        this.httpResponseMeta.charset = charset.name();
    }

    @Override
    public void setContentLength(long contentLength) {
        this.httpResponseMeta.contentLength = contentLength;
    }

    @Override
    public String getContentType() {
        return this.httpResponseMeta.contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this.httpResponseMeta.contentType = contentType;
    }

    @Override
    public String getContentDisposition() {
        List<String> values = this.getHeader("Content-Disposition");
        return values == null || values.size() == 0 ? null : values.get(0);
    }

    @Override
    public void setContentDisposition(String fileName) {
        try {
            String contentDisposition = "attachment;filename*=utf-8''" + new String(fileName.getBytes(), this.httpResponseMeta.charset);
            this.setHeader("Content-Disposition", contentDisposition);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void acceptRanges(boolean acceptRanges) {
        if (acceptRanges) {
            this.setHeader("Accept-Ranges", "bytes");
        } else {
            this.httpResponseMeta.headers.remove("Accept-Ranges");
        }
    }

    @Override
    public void redirect(String url) {
        this.httpResponseMeta.httpStatus(HttpStatus.FOUND);
        this.httpResponseMeta.headers.put("Location", Arrays.asList(url));
    }

    @Override
    public void streamingBody(String data) throws IOException {
        if (null == this.httpResponseMeta.headerString) {
            this.setContentType("text/plain");
            this.setCharset(this.httpResponseMeta.charset);
            this.setHeader("Access-Control-Allow-Origin", "*");
            this.httpResponseMeta.fillHeadStream();
        }
        this.httpResponseMeta.outputStream.write(data.getBytes(this.httpResponseMeta.charset));
        this.httpResponseMeta.outputStream.flush();
    }

    @Override
    public void streamingBodyLine(String data) throws IOException {
        this.streamingBody(data + "\n");
    }

    @Override
    public void eventSource(EventSource eventSource) throws IOException {
        if (null == this.httpResponseMeta.headerString) {
            this.setContentType("text/event-stream");
            this.setCharset("utf-8");
            this.httpResponseMeta.fillHeadStream();
        }
        String body = "id:" + eventSource.id + "\r\nevent:" + eventSource.event + "\r\nretry:" + eventSource.retry + "\r\ndata:" + eventSource.data + "\r\n\r\n";
        this.httpResponseMeta.outputStream.write(body.getBytes(this.httpResponseMeta.charset));
        this.httpResponseMeta.outputStream.flush();
    }

    @Override
    public void download(String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IOException("\u6587\u4ef6\u4e0d\u5b58\u5728!" + filePath);
        }
        this.setContentLength(Files.size(path));
        this.setCharset("utf-8");
        this.setContentDisposition(path.toFile().getName());
        OutputStream outputStream = this.getOutputStream();
        byte[] content = Files.readAllBytes(path);
        outputStream.write(content);
        outputStream.flush();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (null == this.httpResponseMeta.headerString) {
            this.httpResponseMeta.fillHeadStream();
        }
        return this.httpResponseMeta.outputStream;
    }
}

