ams.resource("blockFileResource", {
    "key": "id",
    "api": {
        "prefix": "/blockFile/",
        "list": "list",
        "create": "create",
        "update": "update",
        "delete": "delete"
    },
    "fields": {
        "id": {
            "type": "text",
            "label": "id",
            "hidden": true
        },
        "url": {
            "type": "text",
            "label": "路径",
            "info": "指定屏蔽域名文件路径,支持http协议和本地文件<br/>文件内容按行切分,一行一条记录,此外会忽略以'#'开头的行和空白行",
            "rules": [{
                "required": true,
                "message": "请输入屏蔽域名文件路径",
                "trigger": "blur"
            }],
            "props":{
                "placeholder": "指定屏蔽域名文件路径,支持http协议和本地文件"
            }
        },
        "cron": {
            "type": "text",
            "label": "cron表达式",
            "rules": [{
                "required": true,
                "message": "请输入cron表达式",
                "trigger": "blur"
            }],
            "props":{
                "placeholder": "10 * * * * *"
            }
        },
        "count": {
            "type": "text",
            "label": "提取记录个数",
            "ctx": "view"
        },
        "lastUpdated": {
            "type": "text",
            "label": "上次更新时间",
            "ctx": "view"
        },
        "enable": {
            "type": "switch",
            "label": "是否启用",
            "ctx": "edit",
        },
    },
});

ams.block("blockFileList",{
    "resource": "blockFileResource",
    "type": "list",
    "ctx": "view",
    "events": {
        "init": "@list"
    },
    "props": {
        "empty-text": "当前暂无屏蔽域名文件记录",
        "label-width": "200px"
    },
    "options": {
        "multipleSelect": true
    },
    "operations": {
        "addRecord": {
            "type": "button",
            "label": "新增记录",
            "props": {
                "type": "primary",
                "icon": "el-icon-circle-plus"
            },
            "slot": "rightTop",
            "event": "addItemDialogAction list:1"
        },
        "manualUpdate": {
            "type": "button",
            "label": "手动更新",
            "props": {
                "type": "warning",
                "icon": "el-icon-edit"
            },
            "event": "confirm:确认手动更新屏蔽记录吗? manualUpdate list:1"
        },
        "updateRecord": {
            "type": "button",
            "label": "编辑记录",
            "props": {
                "type": "primary",
                "icon": "el-icon-circle-plus"
            },
            "event": "editItemDialogAction list:1"
        },
        "deleteRecord": {
            "type": "button",
            "label": "删除",
            "props": {
                "type": "danger",
                "icon": "el-icon-delete"
            },
            "event": "confirm:确认删除该记录吗? delete list:1"
        },
        "multiDeleteRecord": {
            "slot": "multipleSelect",
            "type": "button",
            "label": "批量删除",
            "props": {
                "type": "danger",
                "icon": "el-icon-delete"
            },
            "event": "confirm:确认批量删除吗? delete list:1"
        },
    },
    "actions":{
        addItemDialogAction(){
            return this.callAction("@addItemDialog",{
                "resource": "blockFileResource",
                "operation":{
                    "formProps":{
                        "label-width": "200px",
                    },
                    "fields":{
                        "count": {
                            "type": "text",
                            "label": "提取记录个数",
                            "hidden": true
                        },
                        "enable": {
                            "type": "switch",
                            "label": "是否启用",
                            "hidden": true
                        },
                        "lastUpdated": {
                            "type": "text",
                            "label": "上次更新时间",
                            "hidden": true
                        },
                    }
                },
            });
        },
        editItemDialogAction(){
            return this.callAction("@editItemDialog",{
                "resource": "blockFileResource",
                "operation":{
                    "formProps":{
                        "label-width": "200px",
                    },
                    "fields":{
                        "url": {
                            "type": "text",
                            "label": "路径",
                            "props":{
                                "disabled": true
                            }
                        },
                        "count": {
                            "type": "text",
                            "label": "提取记录个数",
                            "hidden": true
                        },
                        "enable": {
                            "type": "switch",
                            "label": "是否启用",
                            "hidden": true
                        },
                        "lastUpdated": {
                            "type": "text",
                            "label": "上次更新时间",
                            "hidden": true
                        },
                    }
                },
            });
        },
        manualUpdate(params){
            this.showLoading();
            return ams.request({
                "method": "get",
                "url": "/blockFile/manualUpdate",
                "params": {
                    "id": params.$prevReturn.id
                },
                "contentType": "form"
            }).then((response)=>{
                if(response.data.code==0){
                    this.$message.success("本次更新成功"+response.data.data+"条记录!");
                }else{
                    this.$message.error(response.data.msg);
                }
            }).finally(()=>{
                this.hideLoading();
            });
        },
        fieldChange({field,name,value,path}){
            if(name=="enable"){
                let index = parseInt(path.substring(path.indexOf("[")+1,path.indexOf("]")));
                let row = this.data.list[index];

                let confirmText = null;
                if(value==0){
                    confirmText = "确认禁用该DNS屏蔽文件吗?";
                }else{
                    confirmText = "确认启用该DNS屏蔽文件吗?";
                }
                if(confirm(confirmText)){
                    return ams.request({
                        "method": "get",
                        "url": "/blockFile/enable",
                        "params": {
                            "id": row.id,
                            "enable": value
                        },
                        "contentType": "form"
                    }).then((response)=>{
                        if(response.data.code==0){
                            this.callAction("list:1");
                        }else{
                            this.$message.error(response.data.msg);
                        }
                    }).finally(()=>{
                        this.hideLoading();
                    });
                }else{
                    if(value==0){
                        row.enable = 1;
                    }else{
                        row.enable = 0;
                    }
                }
            }
        },
    }
});