ams.resource("queryResource", {
    "key": "id",
    "api": {
        "prefix": "/query/",
        "list": "list",
    },
    "fields": {
        "requestIp": {
            "type": "text",
            "label": "请求IP",
            "props": {
                "placeholder": "请输入请求IP"
            },
        },
        "type": {
            "type": "select",
            "label": "DNS类型",
            "props": {
                "placeholder": "请选择",
                "clearable": true,
                "multiple": false,
                "options": {
                    "CNAME": "CNAME记录",
                    "NS": "NS记录",
                    "PTR": "PTR记录",
                    "TXT": "TXT记录",
                    "A": "A记录",
                    "AAAA": "AAAA记录",
                    "": "全部",
                },
            },
        },
        "host": {
            "type": "text",
            "label": "主机域名",
            "props": {
                "placeholder": "请输入主机域名"
            },
        },
        "rcode": {
            "type": "select",
            "label": "返回码",
            "props": {
                "placeholder": "请选择",
                "clearable": true,
                "multiple": false,
                "options": {
                    "0": "SUCCESS",
                    "1": "FORMAT_ERROR",
                    "2": "SERVER_FAILURE",
                    "3": "NON_EXISTENT_DOMAIN",
                    "4": "NOT_IMPLEMENTED",
                    "5": "QUERY_REFUSED",
                    "-1": "全部"
                }
            }
        },
        "answerCount": {
            "type": "text",
            "label": "答案",
            "props":{
                "width": 50
            }
        },
        "requestHeader": {
            "type": "text",
            "label": "请求头部",
            "hidden": true,
            "collapseLimit": 100
        },
        "authorityCount": {
            "type": "text",
            "label": "认证资源",
            "props":{
                "width": 80
            }
        },
        "additionalCount": {
            "type": "text",
            "label": "附加资源",
            "props":{
                "width": 80
            }
        },
        "answer": {
            "type": "textarea",
            "label": "答案",
            "props": {
                "placeholder": "请输入答案"
            },
            "style":{
                "width": "100px"
            },
            "hidden": true,
            "collapseLimit": 100
        },
        "authority": {
            "type": "textarea",
            "label": "认证资源",
            "props": {
                "placeholder": "请输入认证资源"
            },
            "hidden": true,
            "collapseLimit": 100
        },
        "additional": {
            "type": "textarea",
            "label": "附加资源",
            "props": {
                "placeholder": "请输入附加资源"
            },
            "hidden": true,
            "collapseLimit": 100
        },
        "rawHex": {
            "type": "textarea",
            "label": "原始报文",
            "hidden": true,
        },
        "handleType": {
            "type": "select",
            "label": "处理类型",
            "props": {
                "placeholder": "请选择",
                "clearable": true,
                "multiple": false,
                "options": {
                    "0": "本机",
                    "1": "转发",
                    "2": "网关",
                    "3": "GFW",
                    "-1": "全部"
                }
            }
        },
        "handlerIp": {
            "type": "text",
            "label": "处理者IP",
        },
        "requestType": {
            "type": "select",
            "label": "请求方式",
            "props": {
                "placeholder": "请选择",
                "clearable": true,
                "multiple": false,
                "options": {
                    "0": "UDP",
                    "1": "DoH",
                    "-1": "全部"
                }
            },
            "info": "0-UDP方式查询<br/>1-DoH(dns over https)方式查询"
        },
        "queryTime":{
            "type": "text",
            "label": "查询时间",
        },
    },
    "sorts": {
        "queryTime": true
    },
});

ams.block("queryList",{
    "resource": "queryResource",
    "type": "list",
    "ctx": "view",
    "events": {
        "init": "@list"
    },
    "props": {
        "empty-text": "当前暂无DNS查询记录",
    },
    "expand": {
        "id": true,
        "requestHeader": true,
        "answer": true,
        "authority": true,
        "additional": true,
    },
    "operations": {
        "requestIp": {
            "slot": "searchs",
            "type": "field",
            "label": "请求IP",
        },
        "type": {
            "slot": "searchs",
            "type": "field",
            "label": "类型",
        },
        "host": {
            "slot": "searchs",
            "type": "field",
            "label": "主机域名",
        },
        "rcode": {
            "slot": "searchs",
            "type": "field",
            "label": "返回码",
        },
        "handleType": {
            "slot": "searchs",
            "type": "field",
            "label": "处理类型",
        },
        "requestType": {
            "slot": "searchs",
            "type": "field",
            "label": "请求方式",
        },
        "search": {
            "slot": "searchs",
            "type": "button",
            "label": "搜索",
            "props": {
                "type": "primary",
                "icon": "el-icon-search"
            },
            "event": "list:1"
        },
        "selfQuery": {
            "type": "button",
            "label": "格式化信息",
            "props": {
                "type": "primary",
                "icon": "el-icon-search"
            },
            "event": "selfQuery"
        },
    },
    "actions":{
        selfQuery(params){
            this.callAction("routerPush", {
                "name": "自助查询",
                "query": { "rawHex": params.$prevReturn.rawHex }
            });
        }
    }
});