//一般查询面板
ams.block("commonSelfQuery",{
    "resource":{
        "fields":{
            "type":{
                "type": "select",
                "label": "DNS类型",
                "props": {
                    "placeholder": "请选择",
                    "clearable": true,
                    "multiple": false,
                    "inline": true,
                    "options": {
                        "CNAME": "CNAME记录",
                        "NS": "NS记录",
                        "PTR": "PTR记录",
                        "TXT": "TXT记录",
                        "A": "A记录",
                        "AAAA": "AAAA记录",
                        "MX": "MX记录",
                        "SOA": "SOA记录",
                        "": "全部",
                    },
                },
                "default": "A",
                "rules": [{
                    "required": true,
                    "message": "请选择DNS类型",
                    "trigger": "blur"
                }],
            },
            "host":{
                "type": "text",
                "label": "主机域名",
                "props":{
                    "inline": true,
                    "placeholder": "请输入要查询的域名"
                },
                "rules": [{
                    "required": true,
                    "message": "请输入要查询的域名",
                    "trigger": "blur"
                }],
            },
            "dnsServerIp":{
                "type": "text",
                "label": "服务器",
                "props":{
                    "inline": true,
                    "placeholder": "指定DNS服务器IP"
                },
                "info": "指定DNS服务器IP,为空则使用网关地址"
            },
            "rd":{
                "type": "select",
                "label": "查询方式",
                "props": {
                    "placeholder": "请选择",
                    "clearable": true,
                    "multiple": false,
                    "inline": true,
                    "options": [{
                        "label": "迭代",
                        "value": 0
                    }, {
                        "label": "递归",
                        "value": 1
                    }]
                },
                "default": 0
            }
        },
    },
    "type": "form",
    "ctx": "edit",
    "operations": {
        "submit": {
            "type": "button",
            "label": "查询",
            "props": {
                "type": "primary",
                "inline": true
            },
            "event": "validate selfQueryDNS"
        },
    },
    "actions":{
        selfQueryDNS(){
            let data = this.data;
            this.showLoading();
            return ams.request({
                "method": "post",
                "url": "/selfQuery/query",
                "data": data,
                "withCredentials": true,
                "contentType": "form",
            }).then((response)=>{
                if(response.data.code==0){
                    let headerBlock = ams.$blocks["headerBlock"];
                    headerBlock.data = response.data.data.header;

                    let resourceRecordBlock = ams.$blocks["resourceRecordBlock"];
                    this.$set(resourceRecordBlock.data, "list", response.data.data.resourceRecords);
                    this.$set(resourceRecordBlock.data, "total", 0);
                }else{
                    this.$message.error(response.data.msg);
                }
            }).finally(()=>{
                this.hideLoading();
            });
        }
    }
});
//响应报文查询面板
ams.block("dnsResponseSelfQuery",{
    "resource":{
        "fields":{
            "dnsResponseHex":{
                "type": "textarea",
                "label": "DNS响应报文",
                "info": "DNS响应报文,格式为十六进制",
                "rules": [{
                    "required": true,
                    "message": "请输入DNS响应报文",
                    "trigger": "blur"
                }],
            },
        }
    },
    "props": {
        "label-width": "200px"
    },
    "type": "form",
    "ctx": "edit",
    "event": "init",
    "operations": {
        "submit": {
            "type": "button",
            "label": "查询",
            "props": {
                "type": "primary",
                "inline": true
            },
            "event": "validate selfQueryDNS"
        },
    },
    "actions":{
        init(){
            let rawHex = ams.utils.getQueryString("rawHex");
            if(null!=rawHex&&rawHex!=""){
                this.data.dnsResponseHex = rawHex;
                let block = ams.$blocks["selfQueryTab"];
                block.setBlockData({
                    "active": "dnsResponseSelfQueryTab"
                });
                this.callAction("selfQueryDNS");
            }
        },
        selfQueryDNS(){
            let data = this.data;
            return ams.request({
                "method": "post",
                "url": "/selfQuery/dnsResponseHexQuery",
                "data": data,
                "withCredentials": true,
                "contentType": "form",
            }).then((response)=>{
                if(response.data.code==0){
                    let headerBlock = ams.$blocks["headerBlock"];
                    headerBlock.data = response.data.data.header;

                    let resourceRecordBlock = ams.$blocks["resourceRecordBlock"];
                    this.$set(resourceRecordBlock.data, "list", response.data.data.resourceRecords);
                    this.$set(resourceRecordBlock.data, "total", 0);
                }else{
                    this.$message.error(response.data.msg);
                }
            });
        }
    }
});

ams.block("selfQueryTab",{
    "type": "tabs",
    "options": {
        "commonSelfQueryTab": "公共查询",
        "dnsResponseSelfQueryTab": "响应报文查询"
    },
    "blocks": {
        "commonSelfQueryTab": ams.blocks["commonSelfQuery"],
        "dnsResponseSelfQueryTab": ams.blocks["dnsResponseSelfQuery"],
    }
});

//查询结果
ams.block("selfQueryResult",{
    "resource":{
        "fields":{
            "qName":{
                "type": "text",
                "label": "域名",
            },
            "qType":{
                "type": "text",
                "label": "类型",
            },
            "ttl":{
                "type": "text",
                "label": "缓存时间(秒)",
            },
            "RDATA":{
                "type": "text",
                "label": "原始数据",
            },
            "RDATAFormat":{
                "type": "text",
                "label": "格式化数据",
            },
            "region":{
                "type": "text",
                "label": "区域",
                "info": "answer-答案<br/>authority-认证资源<br/>additional-附加资源"
            },
        }
    },
    "type": "list",
    "ctx": "view",
});

//查询结果
ams.block("selfQueryResult",{
    "type": "component",
    "blocks":{
        "headerBlock":{
            "resource": {
                "fields":{
                    "qr":{
                        "type": "text",
                        "label": "查询类型"
                    },
                    "opcode":{
                        "type": "text",
                        "label": "操作类型"
                    },
                    "aa":{
                        "type": "text",
                        "label": "是否权威回答"
                    },
                    "tc":{
                        "type": "text",
                        "label": "是否截断"
                    },
                    "rd":{
                        "type": "text",
                        "label": "请求方式"
                    },
                    "ra":{
                        "type": "text",
                        "label": "响应方式"
                    },
                    "rcode":{
                        "type": "text",
                        "label": "响应类型"
                    },
                    "questionCount":{
                        "type": "text",
                        "label": "问题个数"
                    },
                    "answerResourceRecordCount":{
                        "type": "text",
                        "label": "答案个数"
                    },
                    "authorityResourceRecordCount":{
                        "type": "text",
                        "label": "权威资源个数"
                    },
                    "additionalResourceRecordCount":{
                        "type": "text",
                        "label": "附加资源个数"
                    },
                }
            },
            "type": "form",
            "ctx": "view",
            "props": {
                "inline": true
            }
        },
        "resourceRecordBlock":{
            "resource":{
                "fields":{
                    "qName":{
                        "type": "text",
                        "label": "域名",
                    },
                    "qType":{
                        "type": "text",
                        "label": "类型",
                    },
                    "ttl":{
                        "type": "text",
                        "label": "缓存时间(秒)",
                    },
                    "RDATA":{
                        "type": "text",
                        "label": "原始数据",
                    },
                    "RDATAFormat":{
                        "type": "text",
                        "label": "格式化数据",
                    },
                    "region":{
                        "type": "text",
                        "label": "区域",
                        "info": "answer-答案<br/>authority-认证资源<br/>additional-附加资源"
                    },
                }
            },
            "type": "list",
            "ctx": "view",
        }
    }
});

ams.block("selfQueryBlock",{
    "type": "component",
    "blocks":{
        "selfQueryTab": ams.blocks["selfQueryTab"],
        "selfQueryResult": ams.blocks["selfQueryResult"]
    }
});