//设置页面
ams.block("settingTab",{
    "resource":{
        "api": {
            "prefix": "/setting/",
            "read": "readConfig",
            "update": "updateConfig",
        },
        "fields": {
            "enableGFW": {
                "type": "switch",
                "label": "GFW转发",
                "info": "开启该功能后,GFW域名从指定DNS解析,其他域名按照正常流程解析",
                "default": 0
            },
            "gfwCron":{
                "type": "text",
                "label": "GFW定时更新",
                "props": {
                    "placeholder": "0 0 1 * * *"
                },
                "show": function(){
                    return this.data.enableGFW>0;
                },
            },
            "gfwDNS":{
                "type": "text",
                "label": "GFW指定DNS",
                "props": {
                    "placeholder": "8.8.8.8"
                },
                "show": function(){
                    return this.data.enableGFW>0;
                },
            },
            "updateGFWListCacheButton":{
                "type": "button",
                "label": "手动更新GFW列表文件",
                "props": {
                    "type": "primary",
                },
                "show": function(){
                    return this.data.enableGFW>0;
                },
                "event": "confirm:确认手动更新GFW列表文件吗? updateGFWListCache"
            },
            "gatewayIp": {
                "type": "text",
                "label": "网关IP",
            },
            "dnsQueryTimeoutSeconds": {
                "type": "inputnumber",
                "label": "DNS查询超时时间(秒)",
            },
            "dnsQueryForwardRetryTimes": {
                "type": "inputnumber",
                "label": "DNS转发超时重试次数",
            },
        },
    },
    "type": "form",
    "ctx": "edit",
    "props": {
        "label-width": "200px"
    },
    "events": {
        "init": "@read"
    },
    "operations": {
        "submit": {
            "type": "button",
            "label": "修改设置",
            "props": {
                "type": "primary"
            },
            "event": "validate confirm:确认修改设置吗? update"
        },
    },
    "actions":{
        updateGFWListCache(){
            this.showLoading();
            return ams.request({
                "method": "get",
                "url": "/setting/updateGFWListCache",
            }).then((response)=>{
                if(response.data.code==0){
                    this.$message.success("更新成功"+response.data.data+"条记录!");
                }else{
                    this.$message.error(response.data.msg);
                }
            }).finally(()=>{
                this.hideLoading();
            });
        }
    },
    "blocks": {
        "gfwTitle": {
            "type": "title",
            "options": {
                "title": "GFW设置"
            },
            "style": {
                "marginLeft": "50px"
            },
            "slot": "top"
        },
        "dnsTitle": {
            "type": "title",
            "options": {
                "title": "DNS设置"
            },
            "style": {
                "marginLeft": "50px"
            },
            "slot": "field:updateGFWListCacheButton"
        }
    }
});

//修改密码页面
ams.block("modifyPasswordTab",{
    "resource":{
        "api": {
            "prefix": "/setting/",
            "update": "updatePassword",
        },
        "fields": {
            "oldPassword": {
                "type": "password",
                "label": "旧密码",
                "props": {
                    "placeholder": "请输入旧密码"
                },
                "rules": [{
                    "required": true,
                    "message": "请输入旧密码",
                }],
            },
            "newPassword": {
                "type": "password",
                "label": "新密码",
                "props": {
                    "placeholder": "请输入新密码"
                },
                "rules": [{
                    "required": true,
                    "message": "请输入新密码",
                }],
            },
            "confirmPassword": {
                "type": "password",
                "label": "确认新密码",
                "props": {
                    "placeholder": "请再输入一遍新密码"
                },
                "rules": [{
                    "required": true,
                    "message": "请再输入一遍新密码",
                }],
            },
        },
    },
    "type": "form",
    "ctx": "edit",
    "operations": {
        "submit": {
            "type": "button",
            "label": "修改密码",
            "props": {
                "type": "primary"
            },
            "event": "validate confirm:确认修改密码吗? update"
        },
    },
});

ams.block("migrateDatabaseTab",{
    "type": "form",
    "ctx": "edit",
    "props": {
        "label-width": "200px"
    },
    "resource":{
        "fields": {
            "databaseType": {
                "type": "select",
                "label": "迁移目标数据库类型",
                "props": {
                    "placeholder": "请选择",
                    "clearable": true,
                    "multiple": false,
                    "options": {
                        "mysql": "MySQL",
                        "mariadb": "MariaDB",
                        "postgre": "Postgre",
                    },
                },
                "default": "mysql",
                "rules": [{
                    "required": true,
                    "message": "请选择目标数据库类型"
                }],
            },
            "ip": {
                "type": "text",
                "label": "数据库ip地址",
                "props": {
                    "inline": true,
                    "placeholder": "请输入数据库ip地址",
                },
                "default": "127.0.0.1",
                "rules": [{
                    "required": true,
                    "message": "请输入数据库ip地址"
                }],
            },
            "port": {
                "type": "text",
                "label": "数据库端口",
                "props": {
                    "inline": true,
                    "placeholder": "请输入数据库端口",
                },
                "default": "3306",
                "rules": [{
                    "required": true,
                    "message": "请输入数据库端口"
                }],
            },
            "databaseName": {
                "type": "text",
                "label": "数据库名称",
                "props": {
                    "inline": true,
                    "placeholder": "请输入数据库名称",
                },
                "rules": [{
                    "required": true,
                    "message": "请输入数据库名称"
                }],
                "default": "quickdns"
            },
            "username": {
                "type": "text",
                "label": "用户名",
                "props": {
                    "placeholder": "请输入用户名",
                },
                "rules": [{
                    "required": true,
                    "message": "请输入用户名"
                }],
            },
            "password": {
                "type": "password",
                "label": "用户密码",
                "props": {
                    "placeholder": "请输入用户密码",
                },
                "rules": [{
                    "required": true,
                    "message": "请输入用户密码"
                }],
            },
        },
    },
    "operations":{
        "downloadSQLiteFile": {
            "type": "button",
            "label": "下载SQLite数据库文件",
            "props": {
                "type": "primary"
            },
            "event": "downloadSQLiteFile"
        },
        "testConnection": {
            "type": "button",
            "label": "测试连接",
            "props": {
                "type": "primary"
            },
            "event": "validate testConnection"
        },
        "migrate": {
            "type": "button",
            "label": "迁移数据",
            "props": {
                "type": "primary",
                "disabled": true
            },
            "event": "validate confirm:确认迁移数据吗? migrate"
        },
    },
    "actions":{
        downloadSQLiteFile(){
            window.open("/setting/downloadSQLiteFile");
        },
        testConnection(){
            return ams.request({
                "method": "post",
                "url": "/setting/testDatabaseConnection",
                "data": this.data,
                "contentType": "json"
            }).then((response)=>{
                if(response.data.code==0){
                    this.$message.success("测试数据库连接成功!");
                    this.block.operations.migrate.props.disabled = false;
                }else{
                    this.$message.error("测试数据库连接失败!原因:"+response.data.msg);
                    this.block.operations.migrate.props.disabled = true;
                }
            });
        },
        migrate(){
            this.showLoading();
            return ams.request({
                "method": "post",
                "url": "/setting/migrateDatabase",
                "data": this.data,
                "contentType": "json"
            }).then((response)=>{
                if(response.data.code==0){
                    this.$message.success("数据库迁移完成!");
                }else{
                    this.$message.error("数据库迁移失败!原因:"+response.data.msg);
                }
            }).finally(()=>{
                this.hideLoading();
            });
        },
        fieldChange({ name, value }) {
            if("databaseType"===name){
                let port = null;
                switch (value) {
                    case "mysql":
                    case "mariadb":{
                        port = "3306";
                    }break;
                    case "postgre":{
                        port = "5432";
                    }break;
                }
                if(this.data){
                    if(null==this.data.ip||this.data.ip==""){
                        this.data.ip = "127.0.0.1";
                    }
                    this.data.port = port;
                }
            }
        },
    }
});

ams.block("settingPage",{
    "type": "tabs",
    "options": {
        "settingTab": "设置",
        "modifyPasswordTab": "修改密码",
        "migrateDatabaseTab": "迁移数据库"
    },
    "blocks": {
        "settingTab": ams.blocks["settingTab"],
        "modifyPasswordTab": ams.blocks["modifyPasswordTab"],
        "migrateDatabaseTab": ams.blocks["migrateDatabaseTab"],
    }
});