@echo off

::------------------------------------------------------------------------------
:: MSMG ToolKit v13.0
:: Copyright (c) 2013-2022 MSMG. All rights reserved.
::------------------------------------------------------------------------------
::
:: Credits: CREDITS.TXT
:: License: LICENSE.TXT
:: 3rd Party License: <Bin\LICENSES>
::
::-------------------------------------------------------------------------------------------

color 1f
title MSMG Toolkit v13.0

reg add "HKCU\Console\%%SystemRoot%%_system32_cmd.exe" /v "ScreenBufferSize" /t REG_DWORD /d "0x23290050" /f >nul
reg add "HKCU\Console\%%SystemRoot%%_system32_cmd.exe" /v "WindowSize" /t REG_DWORD /d "0x190050" /f >nul

setlocal EnableExtensions EnableDelayedExpansion

:: Setting Toolkit environment path variables
set "Bin=%~dp0Bin"
set "Custom=%~dp0Custom"
set "Drivers=%~dp0Drivers"
set "DVD=%~dp0DVD"
set "ISO=%~dp0ISO"
set "Logs=%~dp0Logs"
set "Mount=%~dp0Mount"
set "Packs=%~dp0Packs"
set "ROOT=%~dp0"
set "Temp=%~dp0Temp"
set "Updates=%~dp0Updates"
set "WHD=%~dp0WHD"

:: Setting Host OS version, architecture and language variables
set HostArchitecture=
set HostBuild=
set HostReleaseVersion=
set HostDisplayVersion=
set HostEdition=
set HostInstallationType=
set HostLanguage=
set HostOSName=
set HostServicePackBuild=
set HostVersion=

if exist "%WinDir%\SysWOW64" (set "HostArchitecture=x64") else (set "HostArchitecture=x86")
for /f "tokens=3 delims= " %%i in ('reg query "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion" /v "CurrentBuild" ^| find "REG_SZ"') do (set HostBuild=%%i)
for /f "tokens=3 delims= " %%j in ('reg query "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion" /f "ReleaseId" ^| find "REG_SZ"') do (set /A HostReleaseVersion=%%j & if "%%j" lss "2004" set /A HostDisplayVersion=%%j)
if "%HostDisplayVersion%" equ "" for /f "tokens=3 delims= " %%k in ('reg query "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion" /v "DisplayVersion" ^| find "REG_SZ"') do (set "HostDisplayVersion=^(%HostReleaseVersion% %%k^)")
for /f "tokens=3 delims= " %%l in ('reg query "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion" /v "EditionID" ^| find "REG_SZ"') do (set HostEdition=%%l)
for /f "tokens=3 delims= " %%m in ('reg query "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion" /v "InstallationType" ^| find "REG_SZ"') do (set HostInstallationType=%%m)
for /f "tokens=6 delims= " %%o in ('DISM /Online /English /Get-Intl ^| findstr /i /C:"Default system UI language"') do (set HostLanguage=%%o)
for /f "tokens=7 delims=[]. " %%r in ('ver 2^>nul') do (set /A HostServicePackBuild=%%r)
for /f "tokens=4-5 delims=[]. " %%s in ('ver 2^>nul') do (set "HostVersion=%%s.%%t" & set "HostOSName=Windows %%s %HostEdition% %HostInstallationType%" & if "%HostBuild%" equ "7601" set "HostOSName=!HostOSName:6=7! SP1" & if "%HostBuild%" equ "9600" set "HostOSName=!HostOSName:6=8!.1" & if "%HostBuild%" geq "21996" set "HostOSName=!HostOSName:10=11!")

:: Setting WADK tools environment path variables
if "%HostVersion%" equ "6.1" set "DISM=%Bin%\%HostArchitecture%\DISM81\Dism.exe"
if "%HostVersion%" neq "6.1" set "DISM=%Bin%\%HostArchitecture%\DISM10\Dism.exe"
set "DismScratch=%Temp%\DISM"
set "DismFormat=/English /ScratchDir:%DismScratch% /LogPath:%Logs%\Dism.txt /LogLevel:3 /NoRestart"
set "Imagex=%Bin%\%HostArchitecture%\imagex.exe"
set "Oscdimg=%Bin%\%HostArchitecture%\oscdimg.exe"
set "Dvdburn=%Bin%\dvdburn.exe"
set "WimConfigFile=%Bin%\wimscript.ini"

:: Setting Source OS variables
set SelectedSourceOS=
set OSID=
set "BootWim=%DVD%\sources\boot.wim"
set "InstallWim=%DVD%\sources\install.wim"
set "InstallEsd=%DVD%\sources\install.esd"
set "WinReWim=Windows\System32\Recovery\winre.wim"
set "BootMount=%Mount%\Boot"
set "InstallMount=%Mount%\Install"
set "WinReMount=%Mount%\WinRE"

:: Setting Source Image information variables
set ImageCount=
set ImageIndexNo=
set ImageArchitecture=
set ImageName=
set ImageDescription=
set ImageFlag=
set ImageEdition=
set ImageInstallationType=
set ImageDefaultLanguage=
set ImageMajorVersion=
set ImageMinorVersion=
set ImageBuild=
set ImageVersion=
set ImageServicePackBuild=
set ImageServicePackLevel=
set PackageBuild=
set PackageVersion=
set PackageServicePackBuild=
set DefaultIndexNo=

:: Setting Toolkit's control flag variables
set "IsSourceSelected=No"
set "IsBootImageSelected=No"
set "IsRecoveryImageSelected=No"
set "IsDialogsEnabled=Yes"
set "IsLogsEnabled=Yes"
set "IsImageRegistryLoaded=No"
set "IsW7SP1CRUSelected=No"

set "PreActTokens=%Custom%\ActivationTokens"
set "CustomFiles=%Custom%\Files"
set "CustomFonts=%Custom%\Fonts"
set "CustomRecoveryImage=%Custom%\RecoveryImage"
set "CustomRegistry=%Custom%\Registry"
set "CustomTerminalServer=%Custom%\TerminalServer"
set "CustomUxTheme=%Custom%\UxTheme"

:: Setting Toolkit's packs environment path variables
set "Apps=%Packs%\Apps"
set "AppLicense=%Bin%\AppLicense"
set "Braille=%Packs%\Braille"
set "DaRT=%Packs%\DaRT"
set "Dedup=%Packs%\Dedup"
set "DirectX9c=%Packs%\DirectX9c"
set "EdgeClassic=%Packs%\EdgeBrowser"
set "EdgeChromium=%Packs%\EdgeChromium"
set "EdgeWebView2=%Packs%\EdgeWebView2"
set "Games=%Packs%\Games"
set "Firefox=%Packs%\Firefox"
set "IE11=%Packs%\IE11"
set "LanguagePacks=%Packs%\LanguagePacks"
set "MediaFeaturePack=%Packs%\MediaFeaturePack"
set "MMRC=%Packs%\MultimediaRestrictedCodecs"
set "NET6=%Packs%\NET6"
set "NET7=%Packs%\NET7"
set "NETCore31=%Packs%\NETCore31"
set "NetFx35=%Packs%\NetFX35"
set "NetFx462=%Packs%\NetFX462"
set "NetFx48=%Packs%\NetFX48"
set "NetFx481=%Packs%\NetFX481"
set "OfficeUWP=%Packs%\OfficeUWP"
set "OpenSSH=%Packs%\OpenSSH"
set "PortableDevices=%Packs%\PortableDevices"
set "PowerShell7=%Packs%\PowerShell7"
set "RDP81=%Packs%\RDP81"
set "RSAT=%Packs%\RSAT"
set "Sidebar=%Packs%\Sidebar"
set "Skins=%Packs%\Skins"
set "SystemRestore=%Packs%\SystemRestore"
set "ThinPC=%Packs%\ThinPC"
set "UAP=%Packs%\UAP"
set "VCRuntime=%Packs%\VCRuntime"
set "Win32Calc=%Packs%\Win32Calc"
set "WinToGo=%Packs%\WinToGo"
set "WMF=%Packs%\WMF"
set "WMR=%Packs%\WMR"
set "WSL=%Packs%\WSL"

:: Setting Toolkit's dependent tools environment path variables
set "Lists=%Bin%\Lists"
set "Patches=%Bin%\Patches"
set "ResourceHacker=%Bin%\ResourceHacker.exe"
set "ToolKitHelper=%Bin%\ToolKitHelper.exe"
set "W10EsdDecrypter=%Bin%\Dism++CUI.exe /ESDFile"
set "W81EsdDecrypter=%Bin%\esddecrypt.exe"
set "WimlibImagex=%Bin%\%HostArchitecture%\wimlib-imagex.exe"
set "XCopy=xcopy.exe /E /I /H /R /Y /J"
set "XMLs=%Bin%\XMLs"
set "W7ESU=%Bin%\Patches\W7ESU"
set "W10CUFix=%Bin%\Patches\W10CUFix"
set "WMCGActTokens=%Bin%\Patches\WMCGActTokens.tpk"
set "PSFExtractor=%Bin%\PSFExtractor.exe"
set "Zip=%Bin%\%HostArchitecture%\7z.exe"

:: Setting Apps status flags
for %%i in (I_3DViewer,I_Alarms,I_AmazonAppStore,I_AV1VideoExtension,I_BingFinance,I_BingFoodDrink,I_BingHealthFitness,I_BingMaps,I_BingNews,I_BingSports,I_BingTravel,I_BingWeather,I_Calculator,I_Camera,I_ClientWebExperience,I_Clipchamp,I_CommunicationsApps,I_Cortana,I_D3DMappingLayers,I_DesktopAppInstaller,I_DirectXRuntime,I_FeedbackHub,I_GamingApp,I_GamingServices,I_GetHelp,I_Getstarted,I_HEIFImageExtension,I_HelpAndTips,I_HEVCVideoExtension,I_Journal,I_Maps,I_Messaging,I_MicrosoftPowerBI,I_MinecraftEducationEdition,I_MixedRealityPortal,I_MPEG2VideoExtension,I_Notepad,I_NVIDIAControlPanel,I_OfficeHub,I_OfficeOneNote,I_OneConnect,I_Paint,I_Paint3D,I_People,I_Photos,I_PowerAutomateDesktop,I_Print3D,I_QuickAssist,I_RawImageExtension,I_Reader,I_ReadingList,I_RealtekAudioControl,I_Scan,I_ScreenSketch,I_SkypeApp,I_SolitaireCollection,I_SoundRecorder,I_StickyNotes,I_StorePurchaseApp,I_TeamsChat,I_Terminal,I_Todos,I_VP9VideoExtensions,I_Wallet,I_WebMediaExtensions,I_WebpImageExtension,I_Whiteboard,I_WindowsDefender,I_WindowsStore,I_WindowsSubsystemForAndroid,I_WindowsSubsystemForLinux,I_Xbox,I_XboxGameOverlay,I_XboxGamingOverlay,I_XboxIdentityProvider,I_XboxLiveGames,I_XboxSpeechToTextOverlay,I_XboxTCUI,I_YourPhone,I_ZuneMusic,I_ZuneVideo) do (
	set "%%i=-"
)

:: Setting Components status flags
for %%i in (C_AdobeFlashForWindows,C_EdgeChromium,C_EdgeWebView,C_InternetExplorer,C_FirstLogonAnimation,C_GameExplorer,C_LockScreenBackground,C_ScreenSavers,C_SnippingTool,C_SoundThemes,C_SpeechRecognition,C_Wallpapers,C_WindowsMediaPlayer,C_WindowsPhotoViewer,C_WindowsThemes,C_WindowsTIFFIFilter,C_WinSAT,C_OfflineFiles,C_OpenSSH,C_RemoteDesktopClient,C_RemoteDifferentialCompression,C_SimpleTCPIPServices,C_TelnetClient,C_TFTPClient,C_WalletService,C_WindowsMail,C_AssignedAccess,C_CEIP,C_FaceRecognition,C_KernelDebugging,C_LocationService,C_PicturePassword,C_PinEnrollment,C_UnifiedTelemetryClient,C_WiFiNetworkManager,C_WindowsErrorReporting,C_WindowsInsiderHub,C_HomeGroup,C_MultiPointConnector,C_OneDrive,C_RemoteAssistance,C_RemoteDesktopServer,C_RemoteRegistry,C_WorkFoldersClient,C_AccessibilityTools,C_Calculator,C_DeviceLockdown,C_EaseOfAccessCursors,C_EaseOfAccessThemes,C_EasyTransfer,C_FileHistory,C_Magnifier,C_ManualSetup,C_Narrator,C_Notepad,C_OnScreenKeyboard,C_Paint,C_ProjFS,C_SecurityCenter,C_StepsRecorder,C_StorageSpaces,C_SystemRestore,C_WindowsBackup,C_WindowsFirewall,C_WindowsSubsystemForLinux,C_WindowsToGo,C_Wordpad,C_AADBrokerPlugin,C_AccountsControl,C_AddSuggestedFoldersToLibraryDialog,C_AppResolverUX,C_AssignedAccessLockApp,C_AsyncTextService,C_BioEnrollment,C_CallingShellApp,C_CapturePicker,C_CBSPreview,C_ContentDeliveryManager,C_Cortana,C_CredDialogHost,C_ECApp,C_Edge,C_EdgeDevToolsClient,C_FileExplorer,C_FilePicker,C_LockApp,C_MapControl,C_NarratorQuickStart,C_NcsiUwpApp,C_OOBENetworkCaptivePortal,C_OOBENetworkConnectionFlow,C_ParentalControls,C_PeopleExperienceHost,C_PinningConfirmationDialog,C_PrintDialog,C_PPIProjection,C_QuickAssist,C_RetailDemoContent,C_SearchApp,C_SecureAssessmentBrowser,C_SettingSync,C_SkypeORTC,C_SmartScreen,C_WebcamExperience,C_Win32WebViewHost,C_WindowsDefender,C_WindowsMixedReality,C_WindowsReaderPDF,C_WindowsStoreClient,C_XboxClient,C_XboxGameCallableUI,C_XGpuEjectDialog,C_3DViewer,C_AdvertisingXaml,C_Alarms,C_BingNews,C_BingWeather,C_CalculatorApp,C_Camera,C_ClientWebExperience,C_Clipchamp,C_CommunicationsApps,C_DesktopAppInstaller,C_Family,C_FeedbackHub,C_GamingApp,C_GetHelp,C_Getstarted,C_HEIFImageExtension,C_HEVCVideoExtension,C_Maps,C_Messaging,C_MixedRealityPortal,C_NotepadApp,C_OfficeHub,C_OfficeOneNote,C_OneConnect,C_Paint3D,C_People,C_Photos,C_PowerAutomateDesktop,C_Print3D,C_RawImageExtension,C_ScreenSketch,C_ServicesStoreEngagement,C_SkypeApp,C_SolitaireCollection,C_SoundRecorder,C_StickyNotes,C_StorePurchaseApp,C_Terminal,C_Todos,C_VP9VideoExtensions,C_Wallet,C_WebMediaExtensions,C_WebpImageExtension,C_WindowsStoreApp,C_XboxApp,C_XboxGameOverlay,C_XboxGamingOverlay,C_XboxIdentityProvider,C_XboxSpeechToTextOverlay,C_XboxTCUI,C_YourPhone,C_ZuneMusic,C_ZuneVideo) do (
	set "%%i=+"
)

::-------------------------------------------------------------------------------------------
:: MSMG ToolKit - EULA
::-------------------------------------------------------------------------------------------
cls

echo.===============================================================================
echo.########################## MSMG ToolKit - EULA ################################
echo.===============================================================================
echo.
echo.
echo. The MSMG Toolkit is basically a tool to service, customize, add or remove
echo. features and components, enable or disable features to Windows operating
echo. system.
echo.
echo. The MSMG Toolkit is intended to be used with licensed Microsoft Windows
echo. operating systems only.
echo.
echo. This MSMG Toolkit is provided 'as-is', without any express or implied warranty.
echo. In no event will the author be held liable for any damages arising from the
echo. use of this script.
echo.
echo. The MSMG Toolkit uses various 3rd party tools to accomplish some of it's
echo. tasks.
echo.
echo. MSMG ToolKit, Windows are registered trademarks of their respective authors
echo. or companies.
echo.
echo.
echo.===============================================================================
choice /C:AR /N /M "###########################[ 'A'ccept / 'R'eject ]############################"
if errorlevel 2 (
	reg delete "HKCU\Console\%%SystemRoot%%_system32_cmd.exe" /f >nul

	color 00
	endlocal

	exit
)

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Startup function
::-------------------------------------------------------------------------------------------
cls

echo.
echo.Performing Toolkit pre-cleanup operation, please wait...
call :Cleanup >nul
cls
echo.===============================================================================
echo.                           MSMG ToolKit - StartUp
echo.===============================================================================
echo.
echo.Reading Host OS Information...
echo.
echo.%HostOSName% %HostDisplayVersion% - v%HostVersion%.%HostBuild%.%HostServicePackBuild% %HostArchitecture% %HostLanguage%

:: Setting DOS character codepage
if "%HostLanguage%" equ "en-GB" chcp 437 >nul
if "%HostLanguage%" equ "en-US" chcp 437 >nul
if "%HostLanguage%" equ "zh-CN" chcp 936 >nul

echo.
echo.Setting Toolkit and WADK tools environment path variables...
echo.
echo.DISM.exe           =  %DISM%
call :CreateFolder "%DismScratch%"
set "DISM=%DISM% %DismFormat%"
echo.Imagex.exe         =  %Imagex%
echo.Oscdimg.exe        =  %Oscdimg%
echo.Dvdburn.exe        =  %Dvdburn%
echo.7zip.exe           =  %Zip%
echo.Dism++CUI.exe      =  %W10EsdDecrypter%
echo.EsdDecrypt.exe     =  %W81EsdDecrypter%
echo.ToolKitHelper.exe  =  %ToolKitHelper%
echo.ResourceHacker.exe =  %ResourceHacker%
echo.WimlibImagex.exe   =  %WimlibImagex%
echo.
echo.===============================================================================
echo.
pause
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Main Menu
::-------------------------------------------------------------------------------------------
:MainMenu

cls
echo.===============================================================================
echo.                           MSMG ToolKit - Main Menu
echo.===============================================================================
echo.
echo.                             [1]   Source
echo.
echo.                             [2]   Integrate
echo.
echo.                             [3]   Remove
echo.
echo.                             [4]   Customize
echo.
echo.                             [5]   Apply
echo.
echo.                             [6]   Target
echo.
echo.                             [7]   Tools
echo.
echo.
echo.                             [X]   Quit
echo.
echo.===============================================================================
echo.
choice /C:1234567X /N /M "Enter Your Choice : "
if errorlevel 8 goto :Quit
if errorlevel 7 goto :ToolsMenu
if errorlevel 6 goto :TargetMenu
if errorlevel 5 goto :ApplyMenu
if errorlevel 4 goto :CustomizeMenu
if errorlevel 3 goto :RemoveMenu
if errorlevel 2 goto :IntegrateMenu
if errorlevel 1 goto :SourceMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Select Source Menu
::-------------------------------------------------------------------------------------------
:SourceMenu

cls
echo.===============================================================================
echo.                         MSMG ToolKit - Source Menu
echo.===============================================================================
echo.

:: Checking whether Source OS is selected
if "%IsSourceSelected%" equ "Yes" (
	echo.Source OS has already been selected...
	echo.
	echo.===============================================================================
	echo.
	pause
	goto :MainMenu
)

:: Checking whether Image Registry is loaded
if "%IsImageRegistryLoaded%" equ "Yes" (
	echo.Source OS Image Registry is loaded, please do unload it using Tools-^>Options..
	echo.
	echo.===============================================================================
	echo.
	pause
	goto :MainMenu
)

echo.  [1]   Select Source from ^<DVD^> Folder
echo.
echo.  [2]   Copy Source from DVD Drive
echo.
echo.  [3]   Extract Source from DVD ISO Image
echo.
echo.  [4]   Extract Source from OEM IMG Image
echo.
echo.  [5]   Extract Source from Store ESD Image
echo.
echo.  [6]   Extract Source from MCT or Custom ESD Image
echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.
choice /C:123456X /N /M "Enter Your Choice : "
if errorlevel 7 goto :MainMenu
if errorlevel 6 goto :ExtractSourceESD
if errorlevel 5 goto :ExtractSourceStoreESD
if errorlevel 4 goto :ExtractSourceIMG
if errorlevel 3 goto :ExtractSourceISO
if errorlevel 2 goto :CopySourceDVD
if errorlevel 1 goto :SelectSourceDVD
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG ToolKit - Integrate Menu
::-------------------------------------------------------------------------------------------
:IntegrateMenu

cls
echo.===============================================================================
echo.                         MSMG ToolKit - Integrate Menu
echo.===============================================================================
echo.
:: Checking whether Source OS is selected
if "%IsSourceSelected%" equ "No" (
	echo.Source OS is not selected, please do select source from "Source" menu..
	echo.
	echo.===============================================================================
	echo.
	pause
	goto :MainMenu
)

:: Checking whether Image Registry is loaded
if "%IsImageRegistryLoaded%" equ "Yes" (
	echo.Source OS Image Registry is loaded, please do unload it using Tools-^>Options..
	echo.
	echo.===============================================================================
	echo.
	pause
	goto :MainMenu
)

echo.  [1]   Windows Language Packs
echo.
echo.  [2]   Windows Drivers
echo.
echo.  [3]   Windows Features
echo.
echo.  [4]   Windows Updates
echo.
echo.  [5]   Windows Custom Features
echo.
echo.
echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.
choice /C:12345X /N /M "Enter Your Choice : "
if errorlevel 6 goto :MainMenu
if errorlevel 5 goto :IntCustomFeaturesMenu
if errorlevel 4 goto :IntUpdatesMenu
if errorlevel 3 goto :IntFeaturesMenu
if errorlevel 2 goto :IntDriversMenu
if errorlevel 1 goto :IntLanguagePacksMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG ToolKit - Integrate Windows Features Menu
::-------------------------------------------------------------------------------------------
:IntFeaturesMenu

cls
echo.===============================================================================
echo.                MSMG ToolKit - Integrate Windows Features Menu
echo.===============================================================================

:: Checking whether the selected Source OS is a Windows 7 Client/Embedded
if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType:~,6%" neq "Server" (
	echo.  [A]   Microsoft .NET Framework 4.8
	echo.  [B]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [C]   Microsoft .NET Desktop Runtime 6
	echo.  [D]   Microsoft .NET Desktop Runtime 7
	echo.  [E]   Microsoft Internet Explorer 11
	echo.  [F]   Microsoft Edge Chromium Browser
	echo.  [G]   Microsoft Edge WebView 2
	echo.  [H]   Mozilla Firefox Browser
	echo.  [I]   Remote Desktop Protocol ^(RDP^) 8.0 ^& 8.1
	echo.  [J]   Windows Media Feature Pack
	echo.  [K]   Windows Management Framework ^(WMF^) 5.1 ^| Depends on .NET Framework 4.8
	echo.  [L]   Windows PowerShell 7 ^| Depends on Windows Management Framework 5.1
	echo.  [M]   Windows Thin PC Add-on Features
	echo.  [N]   Remote Server Administration Tool ^(RSAT^)
	echo.  [O]   Microsoft DaRT 7.0 Tools
	echo.  [P]   Microsoft DirectX 9.0c
	echo.  [Q]   Microsoft Games
	echo.  [R]   Microsoft Visual C++ Runtime
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRX /N /M "Enter Your Choice : "
	if errorlevel 19 goto :IntegrateMenu
	if errorlevel 18 goto :IntVCRuntime
	if errorlevel 17 goto :IntGames
	if errorlevel 16 goto :IntDirectX9c
	if errorlevel 15 goto :IntDaRT
	if errorlevel 14 goto :IntRSAT
	if errorlevel 13 goto :IntThinPcPkgs
	if errorlevel 12 goto :IntPowerShell7
	if errorlevel 11 goto :IntWMF
	if errorlevel 10 goto :IntMediaFeaturePack
	if errorlevel 9  goto :IntRDP81
	if errorlevel 8  goto :IntFirefox
	if errorlevel 7  goto :IntEdgeWebView2
	if errorlevel 6  goto :IntEdgeChromium
	if errorlevel 5  goto :IntIE11
	if errorlevel 4  goto :IntNET7
	if errorlevel 3  goto :IntNET6
	if errorlevel 2  goto :IntNETCore31
	if errorlevel 1  goto :IntNetFX48
)

:: Checking whether the selected Source OS is a Windows Server 2008 R2 Core/Non Core Edition
if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" neq "Client" if "%ImageInstallationType%" neq "Embedded" (
	echo.  [A]   Microsoft .NET Framework 4.8
	echo.  [B]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [C]   Microsoft .NET Desktop Runtime 6
	echo.  [D]   Microsoft .NET Desktop Runtime 7
	echo.  [E]   Microsoft Internet Explorer 11
	echo.  [F]   Microsoft Edge Chromium Browser
	echo.  [G]   Microsoft Edge WebView 2
	echo.  [H]   Mozilla Firefox Browser
	echo.  [I]   Remote Desktop Protocol ^(RDP^) 8.0 ^& 8.1
	echo.  [J]   Windows Management Framework ^(WMF^) 5.1 ^| Depends on .NET Framework 4.8
	echo.  [K]   Windows PowerShell 7 ^| Depends on Windows Management Framework 5.1
	echo.  [L]   Windows System Restore
	echo.  [M]   Microsoft DaRT 7.0 Tools
	echo.  [N]   Microsoft DirectX 9.0c
	echo.  [O]   Microsoft Games
	echo.  [P]   Windows Sidebar
	echo.  [Q]   Microsoft Visual C++ Runtime
	echo.
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQX /N /M "Enter Your Choice : "
	if errorlevel 18 goto :IntegrateMenu
	if errorlevel 17 goto :IntVCRuntime
	if errorlevel 16 goto :IntSidebar
	if errorlevel 15 goto :IntGames
	if errorlevel 14 goto :IntDirectX9c
	if errorlevel 13 goto :IntDaRT
	if errorlevel 12 goto :IntSystemRestore
	if errorlevel 11 goto :IntPowerShell7
	if errorlevel 10 goto :IntWMF
	if errorlevel 9  goto :IntRDP81
	if errorlevel 8  goto :IntFirefox
	if errorlevel 7  goto :IntEdgeWebView2
	if errorlevel 6  goto :IntEdgeChromium
	if errorlevel 5  goto :IntIE11
	if errorlevel 4  goto :IntNET7
	if errorlevel 3  goto :IntNET6
	if errorlevel 2  goto :IntNETCore31
	if errorlevel 1  goto :IntNetFX48
)

:: Checking whether the selected Source OS is a Windows 8.1 RT (ARM)
if "%SelectedSourceOS%" equ "w81" if "%ImageArchitecture%" equ "arm" (
	echo.
	echo.  [1]   Microsoft .NET Framework 4.8
	echo.
	echo.  [2]   Microsoft Default Inbox Apps
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:12X /N /M "Enter Your Choice : "
	if errorlevel 3 goto :IntegrateMenu
	if errorlevel 2 goto :IntInboxAppsMenu
	if errorlevel 1 goto :IntNetFX48
)

:: Checking whether the selected Source OS is a Windows 8.1 Client Edition
if "%SelectedSourceOS%" equ "w81" if "%ImageArchitecture%" neq "arm" if "%ImageInstallationType:~,6%" neq "Server" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge Chromium Browser
	echo.  [G]   Microsoft Edge WebView 2
	echo.  [H]   Mozilla Firefox Browser
	echo.  [I]   Windows Data Deduplication
	echo.  [J]   Windows To Go Workspace
	echo.  [K]   Windows Media Feature Pack
	echo.  [L]   Microsoft Default Inbox Apps
	echo.  [M]   Windows Management Framework ^(WMF^) 5.1
	echo.  [N]   Windows PowerShell 7
	echo.  [O]   Remote Server Administration Tool ^(RSAT^)
	echo.  [P]   Microsoft DaRT 8.1 Tools
	echo.  [Q]   Microsoft DirectX 9.0c
	echo.  [R]   Microsoft Games
	echo.  [S]   Windows Sidebar
	echo.  [T]   Microsoft Visual C++ Runtime
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSTX /N /M "Enter Your Choice : "
	if errorlevel 21 goto :IntegrateMenu
	if errorlevel 20 goto :IntVCRuntime
	if errorlevel 19 goto :IntSidebar
	if errorlevel 18 goto :IntGames
	if errorlevel 17 goto :IntDirectX9c
	if errorlevel 16 goto :IntDaRT
	if errorlevel 15 goto :IntRSAT
	if errorlevel 14 goto :IntPowerShell7
	if errorlevel 13 goto :IntWMF
	if errorlevel 12 goto :IntInboxAppsMenu
	if errorlevel 11 goto :IntMediaFeaturePack
	if errorlevel 10 goto :IntWinToGo
	if errorlevel 9  goto :IntDedup
	if errorlevel 8  goto :IntFirefox
	if errorlevel 7  goto :IntEdgeWebView2
	if errorlevel 6  goto :IntEdgeChromium
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX48
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows Server 2012 R2 Core/None Core Edition
if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType%" neq "Client" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge Chromium Browser
	echo.  [G]   Microsoft Edge WebView 2
	echo.  [H]   Mozilla Firefox Browser
	echo.  [I]   Microsoft Default Inbox Apps
	echo.  [J]   Windows Management Framework ^(WMF^) 5.1
	echo.  [K]   Windows PowerShell 7
	echo.  [L]   Microsoft DaRT 8.1 Tools
	echo.  [M]   Microsoft DirectX 9.0c
	echo.  [N]   Microsoft Games
	echo.  [O]   Windows Sidebar
	echo.  [P]   Microsoft Visual C++ Runtime
	echo.
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPX /N /M "Enter Your Choice : "
	if errorlevel 17 goto :IntegrateMenu
	if errorlevel 16 goto :IntVCRuntime
	if errorlevel 15 goto :IntSidebar
	if errorlevel 14 goto :IntGames
	if errorlevel 13 goto :IntDirectX9c
	if errorlevel 12 goto :IntDaRT
	if errorlevel 11 goto :IntPowerShell7
	if errorlevel 10 goto :IntWMF
	if errorlevel 9  goto :IntInboxAppsMenu
	if errorlevel 8  goto :IntFirefox
	if errorlevel 7  goto :IntEdgeWebView2
	if errorlevel 6  goto :IntEdgeChromium
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX48
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows 10 v1507 Client Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "10240" if "%ImageInstallationType%" equ "Client" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.6.2
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge Classic Browser
	echo.  [G]   Microsoft Edge Chromium Browser
	echo.  [H]   Microsoft Win32 Calculator
	echo.  [I]   Mozilla Firefox Browser
	echo.  [J]   Windows To Go Workspace
	echo.  [K]   Windows Media Feature Pack
	echo.  [L]   Windows PowerShell 7
	echo.  [M]   Remote Server Administration Tool ^(RSAT^)
	echo.  [N]   Microsoft Default Inbox Apps
	echo.  [O]   Microsoft DaRT 10.0 Tools
	echo.  [P]   Microsoft DirectX 9.0c
	echo.  [Q]   Microsoft Games
	echo.  [R]   Windows Sidebar ^| Depends on: Windows Mail App
	echo.  [S]   Microsoft Visual C++ Runtime
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSX /N /M "Enter Your Choice : "
	if errorlevel 19 goto :IntegrateMenu
	if errorlevel 18 goto :IntVCRuntime
	if errorlevel 18 goto :IntSidebar
	if errorlevel 17 goto :IntGames
	if errorlevel 16 goto :IntDirectX9c
	if errorlevel 15 goto :IntDaRT
	if errorlevel 14 goto :IntInboxAppsMenu
	if errorlevel 13 goto :IntRSAT
	if errorlevel 12 goto :IntPowerShell7
	if errorlevel 11 goto :IntMediaFeaturePack
	if errorlevel 10 goto :IntWinToGo
	if errorlevel 9  goto :IntFirefox
	if errorlevel 8  goto :IntWin32Calc
	if errorlevel 7  goto :IntEdgeChromium
	if errorlevel 6  goto :IntEdgeClassic
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX462
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows 10 v1511 Client Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "10586" if "%ImageInstallationType%" equ "Client" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.6.2
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge Chromium Browser
	echo.  [G]   Microsoft Win32 Calculator
	echo.  [H]   Mozilla Firefox Browser
	echo.  [I]   Windows Data Deduplication
	echo.  [J]   Windows To Go Workspace
	echo.  [K]   Windows Media Feature Pack
	echo.  [L]   Windows PowerShell 7
	echo.  [M]   Remote Server Administration Tool ^(RSAT^)
	echo.  [N]   Microsoft Default Inbox Apps
	echo.  [O]   Microsoft DaRT 10.0 Tools
	echo.  [P]   Microsoft DirectX 9.0c
	echo.  [Q]   Microsoft Games
	echo.  [R]   Windows Sidebar
	echo.  [S]   Microsoft Visual C++ Runtime
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSX /N /M "Enter Your Choice : "
	if errorlevel 20 goto :IntegrateMenu
	if errorlevel 19 goto :IntVCRuntime
	if errorlevel 18 goto :IntSidebar
	if errorlevel 17 goto :IntGames
	if errorlevel 16 goto :IntDirectX9c
	if errorlevel 15 goto :IntDaRT
	if errorlevel 14 goto :IntInboxAppsMenu
	if errorlevel 13 goto :IntRSAT
	if errorlevel 12 goto :IntPowerShell7
	if errorlevel 11 goto :IntMediaFeaturePack
	if errorlevel 10 goto :IntWinToGo
	if errorlevel 9  goto :IntDedup
	if errorlevel 8  goto :IntFirefox
	if errorlevel 7  goto :IntWin32Calc
	if errorlevel 6  goto :IntEdgeChromium
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX462
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows 10 v1607 Client Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "14393" if "%ImageInstallationType%" equ "Client" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge Classic Browser
	echo.  [G]   Microsoft Edge Chromium Browser
	echo.  [H]   Microsoft Edge WebView 2
	echo.  [I]   Microsoft Win32 Calculator
	echo.  [J]   Mozilla Firefox Browser
	echo.  [K]   Windows Data Deduplication
	echo.  [L]   Windows To Go Workspace
	echo.  [M]   Windows Media Feature Pack
	echo.  [N]   Windows Multimedia Restricted Codecs
	echo.  [O]   Windows PowerShell 7
	echo.  [P]   Remote Server Administration Tool ^(RSAT^)
	echo.  [Q]   Microsoft Default Inbox Apps
	echo.  [R]   Microsoft DaRT 10.0 Tools
	echo.  [S]   Microsoft DirectX 9.0c
	echo.  [T]   Microsoft Games
	echo.  [U]   Windows Sidebar
	echo.  [V]   Microsoft Visual C++ Runtime
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSTUVX /N /M "Enter Your Choice : "
	if errorlevel 23 goto :IntegrateMenu
	if errorlevel 22 goto :IntVCRuntime
	if errorlevel 21 goto :IntSidebar
	if errorlevel 20 goto :IntGames
	if errorlevel 19 goto :IntDirectX9c
	if errorlevel 18 goto :IntDaRT
	if errorlevel 17 goto :IntInboxAppsMenu
	if errorlevel 16 goto :IntRSAT
	if errorlevel 15 goto :IntPowerShell7
	if errorlevel 14 goto :IntMMRC
	if errorlevel 13 goto :IntMediaFeaturePack
	if errorlevel 12 goto :IntWinToGo
	if errorlevel 11 goto :IntDedup
	if errorlevel 10 goto :IntFirefox
	if errorlevel 9  goto :IntWin32Calc
	if errorlevel 8  goto :IntEdgeWebView2
	if errorlevel 7  goto :IntEdgeChromium
	if errorlevel 6  goto :IntEdgeClassic
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX48
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows 10 v1703 Client Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "15063" if "%ImageInstallationType%" equ "Client" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge Chromium Browser
	echo.  [G]   Microsoft Win32 Calculator
	echo.  [H]   Mozilla Firefox Browser
	echo.  [I]   Windows Accessibility Braille
	echo.  [J]   Windows Data Deduplication
	echo.  [K]   Windows To Go Workspace
	echo.  [L]   Windows Media Feature Pack
	echo.  [M]   Windows PowerShell 7
	echo.  [N]   Remote Server Administration Tool ^(RSAT^)
	echo.  [O]   Microsoft Default Inbox Apps
	echo.  [P]   Microsoft DaRT 10.0 Tools
	echo.  [Q]   Microsoft DirectX 9.0c
	echo.  [R]   Microsoft Games
	echo.  [S]   Windows Sidebar
	echo.  [T]   Microsoft Visual C++ Runtime
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSTX /N /M "Enter Your Choice : "
	if errorlevel 21 goto :IntegrateMenu
	if errorlevel 20 goto :IntVCRuntime
	if errorlevel 19 goto :IntSidebar
	if errorlevel 18 goto :IntGames
	if errorlevel 17 goto :IntDirectX9c
	if errorlevel 16 goto :IntDaRT
	if errorlevel 15 goto :IntInboxAppsMenu
	if errorlevel 14 goto :IntRSAT
	if errorlevel 13 goto :IntPowerShell7
	if errorlevel 12 goto :IntMediaFeaturePack

	if errorlevel 11 goto :IntWinToGo
	if errorlevel 10 goto :IntDedup
	if errorlevel 9  goto :IntFirefox
	if errorlevel 8  goto :IntBraille
	if errorlevel 7  goto :IntWin32Calc
	if errorlevel 6  goto :IntEdgeChromium
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX48
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows 10 v1709 Client Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "16299" if "%ImageInstallationType%" equ "Client" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge Chromium Browser
	echo.  [G]   Microsoft Win32 Calculator
	echo.  [H]   Mozilla Firefox Browser
	echo.  [I]   Windows Accessibility Braille
	echo.  [J]   Windows Data Deduplication
	echo.  [K]   Windows To Go Workspace
	echo.  [L]   Windows Media Feature Pack
	echo.  [M]   Windows PowerShell 7
	echo.  [N]   Remote Server Administration Tool ^(RSAT^)
	echo.  [O]   Open Secure Shell ^(SSH^) Client ^& Server
	echo.  [P]   Microsoft Default Inbox Apps
	echo.  [Q]   Microsoft DaRT 10.0 Tools
	echo.  [R]   Microsoft DirectX 9.0c
	echo.  [S]   Microsoft Games
	echo.  [T]   Windows Sidebar
	echo.  [U]   Microsoft Visual C++ Runtime
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSTUX /N /M "Enter Your Choice : "
	if errorlevel 22 goto :IntegrateMenu
	if errorlevel 21 goto :IntVCRuntime
	if errorlevel 20 goto :IntSidebar
	if errorlevel 19 goto :IntGames
	if errorlevel 18 goto :IntDirectX9c
	if errorlevel 17 goto :IntDaRT
	if errorlevel 16 goto :IntInboxAppsMenu
	if errorlevel 15 goto :IntOpenSSH
	if errorlevel 14 goto :IntRSAT
	if errorlevel 13 goto :IntPowerShell7
	if errorlevel 12 goto :IntMediaFeaturePack
	if errorlevel 11 goto :IntWinToGo
	if errorlevel 10 goto :IntDedup
	if errorlevel 9  goto :IntBraille
	if errorlevel 8  goto :IntFirefox
	if errorlevel 7  goto :IntWin32Calc
	if errorlevel 6  goto :IntEdgeChromium
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX48
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows 10 v1803 Client Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "17134" if "%ImageInstallationType%" equ "Client" if "%ImageArchitecture%" neq "arm64" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge Chromium Browser
	echo.  [G]   Microsoft Win32 Calculator
	echo.  [H]   Mozilla Firefox Browser
	echo.  [I]   Windows Accessibility Braille
	echo.  [J]   Windows Data Deduplication
	echo.  [K]   Windows To Go Workspace
	echo.  [L]   Windows Media Feature Pack
	echo.  [M]   Windows PowerShell 7
	echo.  [N]   Remote Server Administration Tool ^(RSAT^)
	echo.  [O]   Open Secure Shell ^(SSH^) Client ^& Server
	echo.  [P]   Microsoft Default Inbox Apps
	echo.  [Q]   Microsoft Office Desktop UWP Apps
	echo.  [R]   Microsoft DaRT 10.0 Tools
	echo.  [S]   Microsoft DirectX 9.0c
	echo.  [T]   Microsoft Games
	echo.  [U]   Windows Sidebar
	echo.  [V]   Microsoft Visual C++ Runtime
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSTUVX /N /M "Enter Your Choice : "
	if errorlevel 23 goto :IntegrateMenu
	if errorlevel 22 goto :IntVCRuntime
	if errorlevel 21 goto :IntSidebar
	if errorlevel 20 goto :IntGames
	if errorlevel 19 goto :IntDirectX9c
	if errorlevel 18 goto :IntDaRT
	if errorlevel 17 goto :IntOfficeUWPApps
	if errorlevel 16 goto :IntInboxAppsMenu
	if errorlevel 15 goto :IntOpenSSH
	if errorlevel 14 goto :IntRSAT
	if errorlevel 13 goto :IntPowerShell7
	if errorlevel 12 goto :IntMediaFeaturePack
	if errorlevel 11 goto :IntWinToGo
	if errorlevel 10 goto :IntDedup
	if errorlevel 9  goto :IntBraille
	if errorlevel 8  goto :IntFirefox
	if errorlevel 7  goto :IntWin32Calc
	if errorlevel 6  goto :IntEdgeChromium
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX48
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows 10 v1809 Client Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "17763" if "%ImageInstallationType%" equ "Client" if "%ImageArchitecture%" neq "arm64" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge Classic Browser
	echo.  [G]   Microsoft Edge WebView 2
	echo.  [H]   Microsoft Win32 Calculator
	echo.  [I]   Mozilla Firefox Browser
	echo.  [J]   Windows Accessibility Braille
	echo.  [K]   Windows Data Deduplication
	echo.  [L]   Windows To Go Workspace
	echo.  [M]   Windows Media Feature Pack
	echo.  [N]   Windows Mixed Reality
	echo.  [O]   Windows Multimedia Restricted Codecs
	echo.  [P]   Windows Portable Devices
	echo.  [Q]   Windows PowerShell 7
	echo.  [R]   Open Secure Shell ^(SSH^) Client ^& Server
	echo.  [S]   Microsoft Default Inbox Apps
	echo.  [T]   Microsoft Office Desktop UWP Apps
	echo.  [U]   Microsoft DaRT 10.0 Tools
	echo.  [V]   Microsoft DirectX 9.0c
	echo.  [W]   Microsoft Games
	echo.  [X]   Windows Sidebar
	echo.  [Y]   Microsoft Visual C++ Runtime
	echo.  [1]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSTUVWXY1 /N /M "Enter Your Choice : "
	if errorlevel 26 goto :IntegrateMenu
	if errorlevel 25 goto :IntVCRuntime
	if errorlevel 24 goto :IntSidebar
	if errorlevel 23 goto :IntGames
	if errorlevel 22 goto :IntDirectX9c
	if errorlevel 21 goto :IntDaRT
	if errorlevel 20 goto :IntOfficeUWPApps
	if errorlevel 19 goto :IntInboxAppsMenu
	if errorlevel 18 goto :IntOpenSSH
	if errorlevel 17 goto :IntPowerShell7
	if errorlevel 16 goto :IntPortableDevices
	if errorlevel 15 goto :IntMMRC
	if errorlevel 14 goto :IntWMR
	if errorlevel 13 goto :IntMediaFeaturePack
	if errorlevel 12 goto :IntWinToGo
	if errorlevel 11 goto :IntDedup
	if errorlevel 10 goto :IntBraille
	if errorlevel 9  goto :IntFirefox
	if errorlevel 8  goto :IntWin32Calc
	if errorlevel 7  goto :IntEdgeWebView2
	if errorlevel 6  goto :IntEdgeClassic
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX48
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows 10 v1903/v1909 Client Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "18362" if "%ImageBuild%" leq "18363" if "%ImageInstallationType%" equ "Client" if "%ImageArchitecture%" neq "arm64" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [C]   Microsoft .NET Desktop Runtime 6
	echo.  [D]   Microsoft .NET Desktop Runtime 7
	echo.  [E]   Microsoft Edge WebView 2
	echo.  [F]   Microsoft Win32 Calculator
	echo.  [G]   Mozilla Firefox Browser
	echo.  [H]   Windows Accessibility Braille
	echo.  [I]   Windows Data Deduplication
	echo.  [J]   Windows To Go Workspace
	echo.  [K]   Windows Media Feature Pack
	echo.  [L]   Windows Portable Devices
	echo.  [M]   Windows PowerShell 7
	echo.  [N]   Open Secure Shell ^(SSH^) Client ^& Server
	echo.  [O]   Microsoft Default Inbox Apps
	echo.  [P]   Microsoft Office Desktop UWP Apps
	echo.  [Q]   Microsoft DaRT 10.0 Tools
	echo.  [R]   Microsoft DirectX 9.0c
	echo.  [S]   Microsoft Games
	echo.  [T]   Windows Sidebar
	echo.  [U]   Microsoft Visual C++ Runtime
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSTUX /N /M "Enter Your Choice : "
	if errorlevel 22 goto :IntegrateMenu
	if errorlevel 21 goto :IntVCRuntime
	if errorlevel 20 goto :IntSidebar
	if errorlevel 19 goto :IntGames
	if errorlevel 18 goto :IntDirectX9c
	if errorlevel 17 goto :IntDaRT
	if errorlevel 16 goto :IntOfficeUWPApps
	if errorlevel 15 goto :IntInboxAppsMenu
	if errorlevel 14 goto :IntOpenSSH
	if errorlevel 13 goto :IntPowerShell7
	if errorlevel 12 goto :IntPortableDevices
	if errorlevel 11 goto :IntMediaFeaturePack
	if errorlevel 10 goto :IntWinToGo
	if errorlevel 9  goto :IntDedup
	if errorlevel 8  goto :IntBraille
	if errorlevel 7  goto :IntFirefox
	if errorlevel 6  goto :IntWin32Calc
	if errorlevel 5  goto :IntEdgeWebView2
	if errorlevel 4  goto :IntNET7
	if errorlevel 3  goto :IntNET6
	if errorlevel 2  goto :IntNETCore31
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows 10 v2004/v20H2/v21H1/v21H2/v22H2 Client Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "19045" if "%ImageInstallationType%" equ "Client" if "%ImageArchitecture%" neq "arm64" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8.1
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge WebView 2
	echo.  [G]   Microsoft Win32 Calculator
	echo.  [H]   Mozilla Firefox Browser
	echo.  [I]   Windows Accessibility Braille
	echo.  [J]   Windows Data Deduplication
	echo.  [K]   Windows Media Feature Pack
	echo.  [L]   Windows Multimedia Restricted Codecs
	echo.  [M]   Windows Portable Devices
	echo.  [N]   Windows PowerShell 7
	echo.  [O]   Open Secure Shell ^(SSH^) Client ^& Server
	echo.  [P]   Microsoft Default Inbox Apps
	echo.  [Q]   Microsoft Office Desktop UWP Apps
	echo.  [R]   Microsoft DaRT 10.0 Tools
	echo.  [S]   Microsoft DirectX 9.0c
	echo.  [T]   Microsoft Games
	echo.  [U]   Windows Sidebar
	echo.  [V]   Microsoft Visual C++ Runtime
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSTUVX /N /M "Enter Your Choice : "
	if errorlevel 23 goto :IntegrateMenu
	if errorlevel 22 goto :IntVCRuntime
	if errorlevel 21 goto :IntSidebar
	if errorlevel 20 goto :IntGames
	if errorlevel 19 goto :IntDirectX9c
	if errorlevel 18 goto :IntDaRT
	if errorlevel 17 goto :IntOfficeUWPApps
	if errorlevel 16 goto :IntInboxAppsMenu
	if errorlevel 15 goto :IntOpenSSH
	if errorlevel 14 goto :IntPowerShell7
	if errorlevel 13 goto :IntPortableDevices
	if errorlevel 12 goto :IntMMRC
	if errorlevel 11 goto :IntMediaFeaturePack
	if errorlevel 10 goto :IntDedup
	if errorlevel 9  goto :IntBraille
	if errorlevel 8  goto :IntFirefox
	if errorlevel 7  goto :IntWin32Calc
	if errorlevel 6  goto :IntEdgeWebView2
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX481
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows 11 v21H2 Client Edition
if "%SelectedSourceOS%" equ "w11" if "%ImageBuild%" equ "22000" if "%ImageInstallationType%" equ "Client" if "%ImageArchitecture%" neq "arm64" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8.1
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge WebView 2
	echo.  [G]   Microsoft Win32 Calculator
	echo.  [H]   Mozilla Firefox Browser
	echo.  [I]   Windows Accessibility Braille
	echo.  [J]   Windows Media Feature Pack
	echo.  [K]   Windows Portable Devices
	echo.  [L]   Windows PowerShell 7
	echo.  [M]   Open Secure Shell ^(SSH^) Client ^& Server
	echo.  [N]   Microsoft Default Inbox Apps
	echo.  [O]   Microsoft DaRT 11.0 Tools
	echo.  [P]   Microsoft DirectX 9.0c
	echo.  [Q]   Microsoft Games
	echo.  [R]   Windows Sidebar
	echo.  [S]   Microsoft Visual C++ Runtime
	echo.
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSX /N /M "Enter Your Choice : "
	if errorlevel 20 goto :IntegrateMenu
	if errorlevel 19 goto :IntVCRuntime
	if errorlevel 18 goto :IntSidebar
	if errorlevel 17 goto :IntGames
	if errorlevel 16 goto :IntDirectX9c
	if errorlevel 15 goto :IntDaRT
	if errorlevel 14 goto :IntInboxAppsMenu
	if errorlevel 13 goto :IntOpenSSH
	if errorlevel 12 goto :IntPowerShell7
	if errorlevel 11 goto :IntPortableDevices
	if errorlevel 10 goto :IntMediaFeaturePack
	if errorlevel 9  goto :IntBraille
	if errorlevel 8  goto :IntFirefox
	if errorlevel 7  goto :IntWin32Calc
	if errorlevel 6  goto :IntEdgeWebView2
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX481
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows 11 v22H2 Client Edition
if "%SelectedSourceOS%" equ "w11" if "%ImageBuild%" geq "22621" if "%ImageInstallationType%" equ "Client" if "%ImageArchitecture%" neq "arm64" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8.1
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Win32 Calculator
	echo.  [G]   Mozilla Firefox Browser
	echo.  [H]   Windows Accessibility Braille
	echo.  [I]   Windows Media Feature Pack
	echo.  [J]   Windows Portable Devices
	echo.  [K]   Windows PowerShell 7
	echo.  [L]   Open Secure Shell ^(SSH^) Client ^& Server
	echo.  [M]   Microsoft Default Inbox Apps
	echo.  [N]   Microsoft DaRT 11.0 Tools
	echo.  [O]   Microsoft DirectX 9.0c
	echo.  [P]   Microsoft Games
	echo.  [Q]   Windows Sidebar
	echo.  [R]   Microsoft Visual C++ Runtime
	echo.
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRX /N /M "Enter Your Choice : "
	if errorlevel 19 goto :IntegrateMenu
	if errorlevel 18 goto :IntVCRuntime
	if errorlevel 17 goto :IntSidebar
	if errorlevel 16 goto :IntGames
	if errorlevel 15 goto :IntDirectX9c
	if errorlevel 14 goto :IntDaRT
	if errorlevel 13 goto :IntInboxAppsMenu
	if errorlevel 12 goto :IntOpenSSH
	if errorlevel 11 goto :IntPowerShell7
	if errorlevel 10 goto :IntPortableDevices
	if errorlevel 9  goto :IntMediaFeaturePack
	if errorlevel 8  goto :IntBraille
	if errorlevel 7  goto :IntFirefox
	if errorlevel 6  goto :IntWin32Calc
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX481
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows 10 v1803/v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2, Windows 11 v21H2 arm64 Client
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "17134" if "%ImageArchitecture%" equ "arm64" (
	echo.
	echo.  [1]   Microsoft .NET Framework 3.5
	echo.
	echo.  [2]   Microsoft .NET Framework 4.8.1
	echo.
	echo.  [3]   Microsoft Default Inbox Apps
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:123X /N /M "Enter Your Choice : "
	if errorlevel 4 goto :IntegrateMenu
	if errorlevel 3 goto :IntInboxAppsMenu
	if errorlevel 2 goto :IntNetFX481
	if errorlevel 1 goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows Server 2016/2019, Server v1709/v1803/v1809 Core Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "14393" if "%ImageBuild%" leq "17763" if "%ImageInstallationType%" equ "Server Core" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Windows PowerShell 7
	echo.  [G]   Windows Subsystem for Linux ^(WSL^)
	echo.  [H]   Microsoft DaRT 10.0 Tools
	echo.  [I]   Microsoft DirectX 9.0c
	echo.  [J]   Microsoft Visual C++ Runtime
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJX /N /M "Enter Your Choice : "
	if errorlevel 11 goto :IntegrateMenu
	if errorlevel 10 goto :IntVCRuntime
	if errorlevel 9  goto :IntDirectX9c
	if errorlevel 8  goto :IntDaRT
	if errorlevel 7  goto :IntWSL
	if errorlevel 6  goto :IntPowerShell7
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX48
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows Server 2016/2019 Non Core Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "14393" if "%ImageBuild%" leq "17763" if "%ImageInstallationType%" equ "Server" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge Classic Browser
	echo.  [G]   Microsoft Edge Chromium Browser
	echo.  [H]   Microsoft Edge WebView 2
	echo.  [I]   Mozilla Firefox Browser
	echo.  [J]   Windows Multimedia Restricted Codecs
	echo.  [K]   Windows System Restore
	echo.  [L]   Windows Subsystem for Linux ^(WSL^)
	echo.  [M]   Windows To Go Workspace
	echo.  [N]   Windows PowerShell 7
	echo.  [O]   Microsoft Default Inbox Apps
	echo.  [P]   Microsoft DaRT 10.0 Tools
	echo.  [Q]   Microsoft DirectX 9.0c
	echo.  [R]   Microsoft Games
	echo.  [S]   Windows Sidebar
	echo.  [T]   Microsoft Visual C++ Runtime
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSTX /N /M "Enter Your Choice : "
	if errorlevel 21 goto :IntegrateMenu
	if errorlevel 20 goto :IntVCRuntime
	if errorlevel 19 goto :IntSidebar
	if errorlevel 18 goto :IntGames
	if errorlevel 17 goto :IntDirectX9c
	if errorlevel 16 goto :IntDaRT
	if errorlevel 15 goto :IntInboxAppsMenu
	if errorlevel 14 goto :IntPowerShell7
	if errorlevel 13 goto :IntWinToGo
	if errorlevel 12 goto :IntWSL
	if errorlevel 11  goto :IntSystemRestore
	if errorlevel 10 goto :IntMMRC
	if errorlevel 9  goto :IntFirefox
	if errorlevel 8  goto :IntEdgeWebView2
	if errorlevel 7  goto :IntEdgeChromium
	if errorlevel 6  goto :IntEdgeClassic
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX48
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows Server v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2/Windows Server LTSC 2022 Core Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "18362" if "%ImageInstallationType%" equ "Server Core" (
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8.1
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Windows PowerShell 7
	echo.  [G]   Windows Subsystem for Linux ^(WSL^)
	echo.  [H]   Microsoft DaRT 10.0 Tools
	echo.  [I]   Microsoft DirectX 9.0c
	echo.  [J]   Microsoft Visual C++ Runtime
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJX /N /M "Enter Your Choice : "
	if errorlevel 11 goto :IntegrateMenu
	if errorlevel 10 goto :IntVCRuntime
	if errorlevel 9  goto :IntDirectX9c
	if errorlevel 8  goto :IntDaRT
	if errorlevel 7  goto :IntWSL
	if errorlevel 6  goto :IntPowerShell7
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX481
	if errorlevel 1  goto :IntNetFX35
)

:: Checking whether the selected Source OS is a Windows Server LTSC 2022 Non Core Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "20348" if "%ImageInstallationType%" equ "Server" (
	echo.
	echo.  [A]   Microsoft .NET Framework 3.5
	echo.  [B]   Microsoft .NET Framework 4.8.1
	echo.  [C]   Microsoft .NET Core Desktop Runtime 3.1
	echo.  [D]   Microsoft .NET Desktop Runtime 6
	echo.  [E]   Microsoft .NET Desktop Runtime 7
	echo.  [F]   Microsoft Edge WebView 2
	echo.  [G]   Mozilla Firefox Browser
	echo.  [H]   Windows PowerShell 7
	echo.  [I]   Microsoft Default Inbox Apps
	echo.  [J]   Microsoft DaRT 10.0 Tools
	echo.  [K]   Microsoft DirectX 9.0c
	echo.  [L]   Microsoft Games
	echo.  [M]   Windows Sidebar
	echo.  [N]   Microsoft Visual C++ Runtime
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:ABCDEFGHIJKLMNX /N /M "Enter Your Choice : "
	if errorlevel 15 goto :IntegrateMenu
	if errorlevel 14 goto :IntVCRuntime
	if errorlevel 13 goto :IntSidebar
	if errorlevel 12 goto :IntGames
	if errorlevel 11 goto :IntDirectX9c
	if errorlevel 10 goto :IntDaRT
	if errorlevel 9  goto :IntInboxAppsMenu
	if errorlevel 8  goto :IntPowerShell7
	if errorlevel 7  goto :IntFirefox
	if errorlevel 6  goto :IntEdgeWebView2
	if errorlevel 5  goto :IntNET7
	if errorlevel 4  goto :IntNET6
	if errorlevel 3  goto :IntNETCore31
	if errorlevel 2  goto :IntNetFX481
	if errorlevel 1  goto :IntNetFX35
)
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Integrate Windows Custom Features Menu
::-------------------------------------------------------------------------------------------
:IntCustomFeaturesMenu

cls
echo.===============================================================================
echo.            MSMG ToolKit - Integrate Windows Custom Features Menu
echo.===============================================================================

if "%IsDialogsEnabled%" equ "Yes" (
	cls
	echo.===============================================================================
	echo.            MSMG ToolKit - Integrate Windows Custom Features Menu
	echo.===============================================================================
	echo.
	echo.
	echo.
	echo.                                W A R N I N G
	echo.                                =============
	echo.
	echo.   Integrating Windows Custom Features involves patching system files and so
	echo.   the SFC can report about Windows System Files corruption, This is normal.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.   To turn off Warning Dialogs, Choose Disable Dialogs in Tools-^>Options Menu
	echo.
	echo.===============================================================================
	echo.
	choice /C:YN /N /M "Do You Want to Continue ? ['Y'es/'N'o] : "
	if errorlevel 2 goto :IntegrateMenu
)

cls
echo.===============================================================================
echo.            MSMG ToolKit - Integrate Windows Custom Features Menu
echo.===============================================================================
:: Checking whether the selected Source OS is a Windows 7 Client/Server 2008 R2 Non-Core Edition
if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" neq "Embedded" if "%ImageInstallationType%" neq "Server Core" (
	echo.
	echo.  [1]   Microsoft Terminal Server Patch
	echo.
	echo.  [2]   Custom Themes UxTheme Patch
	echo.
	echo.  [3]   Custom Windows Recovery Environment ^(WinRE^)
	echo.
	echo.  [4]   Custom Default User Account Pictures
	echo.
	echo.  [5]   Custom System Files
	echo.
	echo.  [6]   Custom Fonts
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:123456X /N /M "Enter Your Choice : "
	if errorlevel 7 goto :IntegrateMenu
	if errorlevel 6 goto :IntCustomFonts
	if errorlevel 5 goto :IntCustomFiles
	if errorlevel 4 goto :IntUAP
	if errorlevel 3 goto :IntCustomRecoveryImage
	if errorlevel 2 goto :IntCustomUxTheme
	if errorlevel 1 goto :IntCustomTerminalServer
)

:: Checking whether the selected Source OS is a Windows 7 Embedded Edition
if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Embedded" (
	echo.
	echo.  [1]   Microsoft Terminal Server Patch
	echo.
	echo.  [2]   Custom Themes UxTheme Patch
	echo.
	echo.  [3]   Custom Default User Account Pictures
	echo.
	echo.  [4]   Custom System Files
	echo.
	echo.  [5]   Custom Fonts
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:12345X /N /M "Enter Your Choice : "
	if errorlevel 6 goto :IntegrateMenu
	if errorlevel 5 goto :IntCustomFonts
	if errorlevel 4 goto :IntCustomFiles
	if errorlevel 3 goto :IntUAP
	if errorlevel 2 goto :IntCustomUxTheme
	if errorlevel 1 goto :IntCustomTerminalServer
)

:: Checking whether the selected Source OS is a Windows Server 2008 Core Edition
if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Server Core" (
	echo.
	echo.  [1]   Microsoft Terminal Server Patch
	echo.
	echo.  [2]   Custom Windows Recovery Environment ^(WinRE^)
	echo.
	echo.  [3]   Custom System Files
	echo.
	echo.  [4]   Custom Fonts
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:1234X /N /M "Enter Your Choice : "
	if errorlevel 5 goto :IntegrateMenu
	if errorlevel 4 goto :IntCustomFonts
	if errorlevel 3 goto :IntCustomFiles
	if errorlevel 2 goto :IntCustomRecoveryImage
	if errorlevel 1 goto :IntCustomTerminalServer
)

:: Checking whether the selected Source OS is a Windows 8.1 Client Non-Professioanl WMC/Server 2012 R2 Non-Core Edition
if "%SelectedSourceOS%" equ "w81" if "%ImageFlag%" neq "ProfessionalWMC" if "%ImageInstallationType%" neq "Server Core" (
	echo.
	echo.  [1]   Windows 8.1 Pre-Activation Data
	echo.
	echo.  [2]   Microsoft Terminal Server Patch
	echo.
	echo.  [3]   Custom Themes UxTheme Patch
	echo.
	echo.  [4]   Custom Windows Recovery Environment ^(WinRE^)
	echo.
	echo.  [5]   Custom Default User Account Pictures
	echo.
	echo.  [6]   Custom System Files
	echo.
	echo.  [7]   Custom Fonts
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:1234567X /N /M "Enter Your Choice : "
	if errorlevel 8 goto :IntegrateMenu
	if errorlevel 7 goto :IntCustomFonts
	if errorlevel 6 goto :IntCustomFiles
	if errorlevel 5 goto :IntUAP
	if errorlevel 4 goto :IntCustomRecoveryImage
	if errorlevel 3 goto :IntCustomUxTheme
	if errorlevel 2 goto :IntCustomTerminalServer
	if errorlevel 1 goto :IntPreActTokens
)

:: Checking whether the selected Source OS is a Windows 8.1 Professioanl WMC Edition
if "%SelectedSourceOS%" equ "w81" if "%ImageEdition%" equ "ProfessionalWMC" (
	echo.
	echo.  [1]   Windows 8.1 Media Center Generic Activation Tokens
	echo.
	echo.  [2]   Windows 8.1 Pre-Activation Data
	echo.
	echo.  [3]   Microsoft Terminal Server Patch
	echo.
	echo.  [4]   Custom Themes UxTheme Patch
	echo.
	echo.  [5]   Custom Windows Recovery Environment ^(WinRE^)
	echo.
	echo.  [6]   Custom Default User Account Pictures
	echo.
	echo.  [7]   Custom System Files
	echo.
	echo.  [8]   Custom Fonts
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	choice /C:12345678X /N /M "Enter Your Choice : "
	if errorlevel 9 goto :IntegrateMenu
	if errorlevel 8 goto :IntCustomFonts
	if errorlevel 7 goto :IntCustomFiles
	if errorlevel 6 goto :IntUAP
	if errorlevel 5 goto :IntCustomRecoveryImage
	if errorlevel 4 goto :IntCustomUxTheme
	if errorlevel 3 goto :IntCustomTerminalServer
	if errorlevel 2 goto :IntPreActTokens
	if errorlevel 1 goto :IntWMCGActTokens
)

:: Checking whether the selected Source OS is a Windows Server 2012 R2 Core Edition
if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType%" equ "Server Core" (
	echo.
	echo.  [1]   Microsoft Terminal Server Patch
	echo.
	echo.  [2]   Custom Windows Recovery Environment ^(WinRE^)
	echo.
	echo.  [3]   Custom System Files
	echo.
	echo.  [4]   Custom Fonts
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:1234X /N /M "Enter Your Choice : "
	if errorlevel 5 goto :IntegrateMenu
	if errorlevel 4 goto :IntCustomFonts
	if errorlevel 3 goto :IntCustomFiles
	if errorlevel 2 goto :IntCustomRecoveryImage
	if errorlevel 1 goto :IntCustomTerminalServer
)

:: Checking whether the selected Source OS is a Windows Server Core Edition
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageInstallationType%" equ "Server Core" (
	echo.
	echo.  [1]   Microsoft Terminal Server Patch
	echo.
	echo.  [2]   Custom Windows Recovery Environment ^(WinRE^)
	echo.
	echo.  [3]   Custom System Files
	echo.
	echo.  [4]   Custom Fonts
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:1234X /N /M "Enter Your Choice : "
	if errorlevel 5 goto :IntegrateMenu
	if errorlevel 4 goto :IntCustomFonts
	if errorlevel 3 goto :IntCustomFiles
	if errorlevel 2 goto :IntCustomRecoveryImage
	if errorlevel 1 goto :IntCustomTerminalServer
)

:: Checking whether the selected Source OS is a Windows 10 Client/Server Non-Core Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageInstallationType%" neq "Server Core" if "%ImageBuild%" leq "20348"  (
	echo.
	echo.  [A]   Microsoft Terminal Server Patch
	echo.  [B]   Custom Themes UxTheme Patch
	echo.  [C]   Custom Windows Recovery Environment ^(WinRE^)
	echo.  [D]   Custom Default User Account Pictures
	echo.  [E]   Custom System Files
	echo.  [F]   Custom Fonts
	echo.  [G]   Microsoft Win32Calc Metro Skin
	echo.  [H]   Windows Icons Skin
	echo.  [I]   Windows Photo Viewer Metro Skin
	echo.  [J]   Windows Media Player Metro Skin
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:ABCDEFGHIJX /N /M "Enter Your Choice : "
	if errorlevel 11 goto :IntegrateMenu
	if errorlevel 10 goto :IntWMPMetroSkin
	if errorlevel 9  goto :IntWPVMetroSkin
	if errorlevel 8  goto :IntWIconsSkin
	if errorlevel 7  goto :IntWin32CalcMetroSkin
	if errorlevel 6  goto :IntCustomFonts
	if errorlevel 5  goto :IntCustomFiles
	if errorlevel 4  goto :IntUAP
	if errorlevel 3  goto :IntCustomRecoveryImage
	if errorlevel 2  goto :IntCustomUxTheme
	if errorlevel 1  goto :IntCustomTerminalServer
)

:: Checking whether the selected Source OS is a Windows 11 v21H2/v22H2 Client Edition
if "%SelectedSourceOS%" equ "w11" if "%ImageBuild%" geq "22000"  (
	echo.
	echo.  [A]   Microsoft Terminal Server Patch
	echo.  [B]   Custom Themes UxTheme Patch
	echo.  [C]   Custom Windows Recovery Environment ^(WinRE^)
	echo.  [D]   Custom Default User Account Pictures
	echo.  [E]   Custom System Files
	echo.  [F]   Custom Fonts
	echo.  [G]   Microsoft Win32Calc Metro Skin
	echo.  [H]   Windows Photo Viewer Metro Skin
	echo.  [I]   Windows Media Player Metro Skin
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:ABCDEFGHIX /N /M "Enter Your Choice : "
	if errorlevel 10 goto :IntegrateMenu
	if errorlevel 9  goto :IntWMPMetroSkin
	if errorlevel 8  goto :IntWPVMetroSkin
	if errorlevel 7  goto :IntWin32CalcMetroSkin
	if errorlevel 6  goto :IntCustomFonts
	if errorlevel 5  goto :IntCustomFiles
	if errorlevel 4  goto :IntUAP
	if errorlevel 3  goto :IntCustomRecoveryImage
	if errorlevel 2  goto :IntCustomUxTheme
	if errorlevel 1  goto :IntCustomTerminalServer
)
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Remove Menu
::-------------------------------------------------------------------------------------------
:RemoveMenu

cls
echo.===============================================================================
echo.                          MSMG ToolKit - Remove Menu
echo.===============================================================================
echo.

:: Checking whether Source OS is selected
if "%IsSourceselected%" equ "No" (
	echo.Source OS is not selected, please do select source from "Source" menu..
	echo.
	echo.===============================================================================
	echo.
	pause
	goto :MainMenu
)

:: Checking whether Image Registry is loaded
if "%IsImageRegistryLoaded%" equ "Yes" (
	echo.Source OS Image Registry is loaded, please do unload it using Tools-^>Options..
	echo.
	echo.===============================================================================
	echo.
	pause
	goto :MainMenu
)

:: Checking whether the selected Source OS is Windows 7 Source OS
if "%SelectedSourceOS%" equ "w7" (
	echo.  [1]   Remove Windows Components Using Package List
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
)

:: Checking whether the selected Source OS is Windows 8.1 Source OS
if "%SelectedSourceOS%" equ "w81" (
	echo.  [1]   Remove Windows Apps Using Apps List
	echo.
	echo.  [2]   Remove Windows Components Using Package List
	echo.
	echo.
	echo.
	echo.
)

:: Checking whether the selected Source OS is Windows 10 Enterprise 2015/2016 LTSB Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" leq "17134" if "%ImageFlag%" equ "EnterpriseS" (
	echo.  [1]   Remove Windows Components Using Package List
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
)

:: Checking whether the selected Source OS is Windows 10 Enterprise N 2015/2016 LTSB Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" leq "17134" if "%ImageFlag%" equ "EnterpriseSN" (
	echo.  [1]   Remove Windows Components Using Package List
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
)

:: Checking whether the selected Source OS is Windows 10 v1507/v1511/v1607/v1703/v1709/v1803 Client Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" leq "17134" if "%ImageInstallationType%" equ "Client" if "%ImageFlag%" neq "EnterpriseS" if "%ImageFlag%" neq "EnterpriseSN" (
	echo.  [1]   Remove Windows Apps Using Apps List
	echo.
	echo.  [2]   Remove Windows Components Using Package List
	echo.
	echo.
	echo.
	echo.
)

:: Checking whether the selected Source OS is a Windows 10 Enterprise 2019/2021 LTSC Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "19045" if "%ImageFlag%" equ "EnterpriseS" (
	echo.  [1]   Remove Windows Components
	echo.
	echo.  [2]   Remove Windows Components Using Package List
	echo.
	echo.
	echo.
	echo.
)

:: Checking whether the selected Source OS is a Windows 10 Enterprise N 2019/2021 LTSC Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "19045" if "%ImageFlag%" equ "EnterpriseSN" (
	echo.  [1]   Remove Windows Components
	echo.
	echo.  [2]   Remove Windows Components Using Package List
	echo.
	echo.
	echo.
	echo.
)

:: Checking whether the selected Source OS is a Windows 10 v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2, Windows 11 v21H2/v22H2 Client Edition
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "22623" if "%ImageInstallationType%" equ "Client" if "%ImageFlag%" neq "EnterpriseS" if "%ImageFlag%" neq "EnterpriseSN" (
	echo.  [1]   Remove Windows Components
	echo.
	echo.  [2]   Remove Windows Apps Using Apps List
	echo.
	echo.  [3]   Remove Windows Components Using Package List
	echo.
	echo.
)

:: Checking whether the selected Source OS is a Windows 11 v23H2 Client
if "%SelectedSourceOS%" equ "w11" if "%ImageBuild%" gtr "22623" if "%ImageInstallationType%" equ "Client" (
	echo.  [1]   Remove Windows Apps Using Apps List
	echo.
	echo.  [2]   Remove Windows Components Using Package List
	echo.
	echo.
	echo.
	echo.
)

:: Checking whether the selected Source OS is a Windows 10/11 Server Edition
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageInstallationType:~,6%" equ "Server" (
	echo.  [1]   Remove Windows Components Using Package List
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
)

echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.
:: Checking whether the selected Source OS is Windows 7 Source OS
if "%SelectedSourceOS%" equ "w7" (
	choice /C:1X /N /M "Enter Your Choice : "
	if errorlevel 2 goto :MainMenu
	if errorlevel 1 goto :RemoveWindowsComponentsList
)

:: Checking whether the selected Source OS is Windows 8.1 Source OS
if "%SelectedSourceOS%" equ "w81" (
	choice /C:12X /N /M "Enter Your Choice : "
	if errorlevel 3 goto :MainMenu
	if errorlevel 2 goto :RemoveWindowsComponentsList
	if errorlevel 1 goto :RemoveWindowsAppsList
)

:: Checking whether the selected Source OS is Windows 10 Enterprise 2015/2016 LTSB Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" leq "17134" if "%ImageFlag%" equ "EnterpriseS" (
	choice /C:1X /N /M "Enter Your Choice : "
	if errorlevel 2 goto :MainMenu
	if errorlevel 1 goto :RemoveWindowsComponentsList
)

:: Checking whether the selected Source OS is Windows 10 Enterprise N 2015/2016 LTSB Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" leq "17134" if "%ImageFlag%" equ "EnterpriseSN" (
	choice /C:1X /N /M "Enter Your Choice : "
	if errorlevel 2 goto :MainMenu
	if errorlevel 1 goto :RemoveWindowsComponentsList
)

:: Checking whether the selected Source OS is Windows 10 v1507/v1511/v1607/v1703/v1709/v1803 Client Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" leq "17134" if "%ImageInstallationType%" equ "Client" if "%ImageFlag%" neq "EnterpriseS" if "%ImageFlag%" neq "EnterpriseSN" (
	choice /C:12X /N /M "Enter Your Choice : "
	if errorlevel 3 goto :MainMenu
	if errorlevel 2 goto :RemoveWindowsComponentsList
	if errorlevel 1 goto :RemoveWindowsAppsList
)

:: Checking whether the selected Source OS is a Windows 10 Enterprise 2019/2021 LTSC Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "19045" if "%ImageFlag%" equ "EnterpriseS" (
	choice /C:12X /N /M "Enter Your Choice : "
	if errorlevel 3 goto :MainMenu
	if errorlevel 2 goto :RemoveWindowsComponentsList
	if errorlevel 1 goto :RemoveWindowsComponentsMenu
)

:: Checking whether the selected Source OS is a Windows 10 Enterprise N 2019/2021 LTSC Edition
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "19045" if "%ImageFlag%" equ "EnterpriseSN" (
	choice /C:12X /N /M "Enter Your Choice : "
	if errorlevel 3 goto :MainMenu
	if errorlevel 2 goto :RemoveWindowsComponentsList
	if errorlevel 1 goto :RemoveWindowsComponentsMenu
)

:: Checking whether the selected Source OS is a Windows 10 v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2, Windows 11 v21H2/v22H2 Client Edition
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "22623" if "%ImageInstallationType%" equ "Client" if "%ImageFlag%" neq "EnterpriseS" if "%ImageFlag%" neq "EnterpriseSN" (
	choice /C:123X /N /M "Enter Your Choice : "
	if errorlevel 4 goto :MainMenu
	if errorlevel 3 goto :RemoveWindowsComponentsList
	if errorlevel 2 goto :RemoveWindowsAppsList
	if errorlevel 1 goto :RemoveWindowsComponentsMenu
)

:: Checking whether the selected Source OS is a Windows 11 v23H2 Client
if "%SelectedSourceOS%" equ "w11" if "%ImageBuild%" gtr "22623" if "%ImageInstallationType%" equ "Client" (
	choice /C:12X /N /M "Enter Your Choice : "
	if errorlevel 3 goto :MainMenu
	if errorlevel 2 goto :RemoveWindowsComponentsList
	if errorlevel 1 goto :RemoveWindowsAppsList
)

:: Checking whether the selected Source OS is a Windows 10/11 Server Edition
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageInstallationType:~,6%" equ "Server" (
	choice /C:1X /N /M "Enter Your Choice : "
	if errorlevel 2 goto :MainMenu
	if errorlevel 1 goto :RemoveWindowsComponentsList
)
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Customize Menu
::-------------------------------------------------------------------------------------------
:CustomizeMenu

cls
echo.===============================================================================
echo.                         MSMG ToolKit - Customize Menu
echo.===============================================================================
echo.
:: Checking whether Source OS is selected
if "%IsSourceselected%" equ "No" (
	echo.Source OS is not selected, please do select source from "Source" menu..
	echo.
	echo.===============================================================================
	echo.
	pause
	goto :MainMenu
)

:: Checking whether Image Registry is loaded
if "%IsImageRegistryLoaded%" equ "Yes" (
	echo.Source OS Image Registry is loaded, please do unload it using Tools-^>Options..
	echo.
	echo.===============================================================================
	echo.
	pause
	goto :MainMenu
)

:: Checking whether the selected Source OS is a Windows 7/Server 2008 R2 Edition
if "%SelectedSourceOS%" equ "w7" (
	echo.This feature is not yet implemented...
	echo.
	echo.===============================================================================
	echo.
	pause
	goto :MainMenu
)

echo.  [1]   Enable Windows Features using Features List
echo.  [2]   Disable Windows Features using Features List
echo.  [3]   Import Custom Default Inbox Apps Association from XML File
echo.  [4]   Export Default Inbox Apps Association to XML File
echo.  [5]   Remove Default Inbox Apps Association XML
echo.  [6]   Import Custom StartMenu Layout from XML File
echo.  [7]   Import Custom Registry Setting from Registry File
echo.  [8]   Apply Tweaks
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.
choice /C:12345678X /N /M "Enter Your Choice : "
if errorlevel 9 goto :MainMenu
if errorlevel 8 goto :ApplyTweaksMenu
if errorlevel 7 goto :ImportCustomRegistry
if errorlevel 6 goto :ImportStartMenuLayout
if errorlevel 5 goto :RemoveMetroAppsAssociation
if errorlevel 4 goto :ExportMetroAppsAssociation
if errorlevel 3 goto :ImportMetroAppsAssociation
if errorlevel 2 goto :DisableFeatures
if errorlevel 1 goto :EnableFeatures
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Apply Source Menu
::-------------------------------------------------------------------------------------------
:ApplyMenu

cls
echo.===============================================================================
echo.                       MSMG ToolKit - Apply Source Menu
echo.===============================================================================
echo.
:: Checking whether Source OS is selected
if "%IsSourceselected%" equ "No" (
	echo.Source OS is not selected, please do select source from "Source" menu..
	echo.
	echo.===============================================================================
	echo.
	pause
	goto :MainMenu
)

:: Checking whether Image Registry is loaded
if "%IsImageRegistryLoaded%" equ "Yes" (
	echo.Source OS Image Registry is loaded, please do unload it using Tools-^>Options..
	echo.
	echo.===============================================================================
	echo.
	pause
	goto :MainMenu
)

if "%IsSourceselected%" equ "Yes" if "%SelectedSourceOS%" equ "w7" (
	echo.  [1]   Apply ^& Save Changes to Source Images
	echo.
	echo.  [2]   Discard Changes ^& Unmount Source Images
	echo.
	echo.
)

if "%IsSourceselected%" equ "Yes" if "%SelectedSourceOS%" neq "w7" (
	echo.  [1]   Cleanup Source Images using DISM Cleanup-Image
	echo.
	echo.  [2]   Apply ^& Save Changes to Source Images
	echo.
	echo.  [3]   Discard Changes ^& Unmount Source Images
)
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.

if "%IsSourceselected%" equ "Yes" if "%SelectedSourceOS%" equ "w7" (
	choice /C:12X /N /M "Enter Your Choice : "
	if errorlevel 3 goto :MainMenu
	if errorlevel 2 goto :DiscardSource
	if errorlevel 1 goto :SaveSource
)

if "%IsSourceselected%" equ "Yes" if "%SelectedSourceOS%" neq "w7" (
	choice /C:1234X /N /M "Enter Your Choice : "
	if errorlevel 5 goto :MainMenu
	if errorlevel 3 goto :DiscardSource
	if errorlevel 2 goto :SaveSource
	if errorlevel 1 goto :CleanupSource
)
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Select Target Menu
::-------------------------------------------------------------------------------------------
:TargetMenu

cls
echo.===============================================================================
echo.                      MSMG ToolKit - Select Target Menu
echo.===============================================================================
echo.
:: Checking whether Source OS is selected
if "%IsSourceselected%" equ "Yes" (
	echo.Source OS is selected, please do save or discard source from "Apply" menu..
	echo.
	echo.===============================================================================
	echo.
	pause
	goto :MainMenu
)

echo.  [1]   Make a DVD ISO Image
echo.
echo.  [2]   Burn an ISO Image to DVD
echo.
echo.  [3]   Copy Source to USB Flash Drive
echo.
echo.  [4]   Sync Source Boot ^& Install Images to USB Flash Drive
echo.
echo.  [5]   Burn an ISO Image to Bootable USB Flash Drive
echo.
echo.  [6]   Format a USB Flash Drive
echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.
choice /C:123456X /N /M "Enter Your Choice : "
if errorlevel 7 goto :MainMenu
if errorlevel 6 goto :FormatUSB
if errorlevel 5 goto :BurnUSB
if errorlevel 4 goto :SyncUSB
if errorlevel 3 goto :CopyUSB
if errorlevel 2 goto :BurnISO
if errorlevel 1 goto :MakeISO
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Tools Menu
::-------------------------------------------------------------------------------------------
:ToolsMenu

cls
echo.===============================================================================
echo.                         MSMG ToolKit - Tools Menu
echo.===============================================================================
echo.
echo.  [1]   WIM Manager
echo.
echo.  [2]   Debug Info
echo.
echo.  [3]   Options
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.
choice /C:123X /N /M "Enter Your Choice : "
if errorlevel 4 goto :MainMenu
if errorlevel 3 goto :Options
if errorlevel 2 goto :Debug
if errorlevel 1 goto :WIMManager
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Select Source from <DVD> folder
::-------------------------------------------------------------------------------------------
:SelectSourceDVD

cls
echo.===============================================================================
echo.               MSMG ToolKit - Select Source from ^<DVD^> folder
echo.===============================================================================
echo.

:: Checking whether Windows Source Boot Image exist
if not exist "%BootWim%" (
	echo.Can't find Windows Setup "Boot.wim" Image in ^<DVD\Sources^> folder...
	echo.
	echo.Please copy Windows Setup "Boot.wim" Image to ^<DVD\Sources^> folder...
	goto :Stop
)

:: Checking whether Windows Source Install Image is a ESD Image
if exist "%InstallEsd%" (
	echo.ToolKit found Windows Installation image in a .esd format, an ESD image
	echo.is a highly compressed image which cannot be directly serviced.
	echo.
	echo.The Toolkit requires the Windows Installation image to be in a .wim
	echo.format for servciing.
	echo.
	echo.Please use a Windows Installation image in a .wim format or use the
	echo.Extract Source from Store ESD Image menu from Source menu.
	goto :Stop
)

:: Checking whether Windows Source Install Image exist
if not exist "%InstallWim%" (
	echo.Can't find Windows Setup "Install.wim" Image in ^<DVD\Sources^> folder...
	echo.
	echo.Please copy Windows Setup "Install.wim" Image to ^<DVD\Sources^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Selecting Source Images####################################################
echo.-------------------------------------------------------------------------------

:: Getting Image Index Number to Service
call :GetImageIndexNo "%InstallWim%"

:: Checking for Image Index Validation
if not defined ImageIndexNo (
	echo.
	echo.Invalid Index # Entered, Valid Range is [1,...%ImageCount%, 'A'll, 'Q'uit]
	echo.
	pause
	goto :SelectSourceDVD
)

if /i "%ImageIndexNo%" equ "A" (
	set "ImageIndexNo=1"
    for /l %%i in (2, 1, %ImageCount%) do (
        set "ImageIndexNo=!ImageIndexNo!,%%i"
    )
)

if /i "%ImageIndexNo%" equ "Q" (
   set ImageIndexNo=
   goto :MainMenu
)

:: Setting the default Image Index No
for /f "tokens=1 delims=," %%a in ("!ImageIndexNo!") do (set DefaultIndexNo=%%a)

:: Getting first Image Index Information
call :GetImageIndexInfo "%InstallWim%", %DefaultIndexNo% >nul

:: Setting selected Source OS version
if "%ImageVersion%" equ "6.1.7601" set "SelectedSourceOS=w7"
if "%ImageVersion%" equ "6.3.9600" set "SelectedSourceOS=w81"

if "%ImageVersion:~0,-6%" equ "10.0" (
   if "%ImageBuild%" leq "20348" (
       set "SelectedSourceOS=w10"
       set "OSID=10"
   )
   if "%ImageBuild%" geq "22000" (
       set "SelectedSourceOS=w11"
       set "OSID=11"
   )
)

if "%ImageVersion:~0,-6%" equ "11.0" (
   set "SelectedSourceOS=w11"
   set "OSID=11"
)

:: Setting Package Service Pack Build, Version and Service Pack Build 
if "%SelectedSourceOS%" equ "w7" set "PackageServicePackBuild=17514"
if "%SelectedSourceOS%" equ "w81" set "PackageServicePackBuild=16384"

if "%SelectedSourceOS%" equ "w10" (
   if "%ImageBuild%" geq "10240" if "%ImageBuild%" leq "15063" (
       set "PackageBuild=%ImageBuild%"
       set "PackageVersion=10.0.%ImageBuild%"
       set "PackageServicePackBuild=0"
   )
   if "%ImageBuild%" equ "16299" (
		set "PackageBuild=16299"
		set "PackageVersion=10.0.16299"
		set "PackageServicePackBuild=15"
	)
	if "%ImageBuild%" geq "17134" if "%ImageBuild%" leq "17763" (
       set "PackageBuild=%ImageBuild%"
       set "PackageVersion=10.0.%ImageBuild%"
       set "PackageServicePackBuild=1"
   )
	if "%ImageBuild%" geq "18362" if "%ImageBuild%" leq "18363" (
		set "PackageBuild=18362"
		set "PackageVersion=10.0.18362"
		set "PackageServicePackBuild=1"
	)
	if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "19045" (
		set "PackageBuild=19041"
		set "PackageVersion=10.0.19041"
		set "PackageServicePackBuild=1"
	)
	if "%ImageBuild%" equ "20348" (
		set "PackageBuild=%ImageBuild%"
		set "PackageVersion=10.0.%ImageBuild%"
		set "PackageServicePackBuild=1"
	)
)

if "%SelectedSourceOS%" equ "w11" (
	if "%ImageBuild%" geq "22000" (
		set "PackageBuild=%ImageBuild%"
		set "PackageVersion=10.0.%ImageBuild%"
		set "PackageServicePackBuild=1"
	)
)

:: Setting Package Index and Architecture
if "%ImageArchitecture%" equ "x86" (
   set "PackageIndex=1"
   set "PackageArchitecture=x86"
)
if "%ImageArchitecture%" equ "x64" (
   set "PackageIndex=2"
   set "PackageArchitecture=amd64"
)
if "%ImageArchitecture%" equ "arm" (
   set "PackageIndex=3"
   set "PackageArchitecture=arm"
)
if "%ImageArchitecture%" equ "arm64" (
   set "PackageIndex=4"
   set "PackageArchitecture=arm64"
)

:: Checking whether the HOST OS is Windows 7 and selected Source OS is Windows 10/11
if "%HostVersion%" equ "6.1" if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
    echo.
    echo.ToolKit cannot service Windows 10/11 Source OS on Windows 7 HOST OS...
    echo.
    echo.ToolKit requires a Windows 8.1/10/11 HOST OS for servicing Windows 10/11 Source OS...
    goto :Stop
)

echo.
choice /C:YN /N /M "Do you want to mount Windows Setup Boot Image ? ['Y'es/'N'o] : "
if errorlevel 2 set "IsBootImageSelected=No"
if errorlevel 1 set "IsBootImageSelected=Yes"

choice /C:YN /N /M "Do you want to mount Windows Recovery Image ? ['Y'es/'N'o] : "
if errorlevel 2 set "IsRecoveryImageSelected=No"
if errorlevel 1 set "IsRecoveryImageSelected=Yes"

echo.
echo.-------------------------------------------------------------------------------
echo.####Source Image Information###################################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    :  Install.wim
echo.    Image Index No           :  %ImageIndexNo%
echo.    Image Architecture       :  %ImageArchitecture%
echo.    Image Version            :  %ImageVersion%
echo.    Image Service Pack Build :  %ImageServicePackBuild%
echo.    Image Service Pack Level :  %ImageServicePackLevel%
echo.    Image Build              :  %ImageBuild%
echo.    Image Default Language   :  %ImageDefaultLanguage%
echo.
echo.-------------------------------------------------------------------------------
echo.####Mounting Source Images#####################################################
echo.-------------------------------------------------------------------------------
echo.
:: Mounting Source Boot Image Index to Service
if "%IsBootImageSelected%" equ "Yes" (
   for /l %%i in (1, 1, 2) do (
	   call :CreateFolder "%BootMount%\%%i"

       echo.-------------------------------------------------------------------------------
       echo.Mounting [Boot.wim, Index : %%i] Image at ^<\Mount\Boot\%%i^>...
       echo.-------------------------------------------------------------------------------
       call :MountImage "%BootWim%", %%i, "%BootMount%\%%i"
   )
)

:: Mounting Source Install & Recovery Images Index to Service
for %%i in (%ImageIndexNo%) do (
	call :CreateFolder "%InstallMount%\%%i"

	:: Mounting Source Install Image Indexes to Service
	echo.-------------------------------------------------------------------------------
	echo.Mounting [Install.wim, Index : %%i] Image at ^<\Mount\Install\%%i^>...
	echo.-------------------------------------------------------------------------------
	call :MountImage "%InstallWim%", %%i, "%InstallMount%\%%i"
)

if "%IsRecoveryImageSelected%" equ "Yes" (
	call :CreateFolder "%WinReMount%"

	:: Mounting Source Recovery Image Indexes to Service
	echo.-------------------------------------------------------------------------------
	echo.Mounting [Install.wim, Index : %DefaultIndexNo% -^> WinRE.wim] Image at ^<\Mount\WinRE^>...
	echo.-------------------------------------------------------------------------------
	call :MountImage "%InstallMount%\%DefaultIndexNo%\%WinReWim%", 1, "%WinReMount%"
)

echo.-------------------------------------------------------------------------------
echo.####Finished Selecting ^& Mounting Source Images################################
echo.-------------------------------------------------------------------------------

set "IsSourceSelected=Yes"

:Stop
echo.
echo.===============================================================================
echo.
pause

goto :MainMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Copy Source from DVD Drive to ^<DVD^> folder
::-------------------------------------------------------------------------------------------
:CopySourceDVD

setlocal

set DriveLetter=

cls
echo.===============================================================================
echo.          MSMG ToolKit - Copy Source from DVD Drive to ^<DVD^> folder
echo.===============================================================================
echo.

:: Checking whether Windows Source DVD folder is empty
if exist "%DVD%\sources\*.wim" (
	echo.Toolkit's Source ^<DVD^> folder is not empty...
	echo.
	choice /C:YN /N /M "Do you want to remove it & continue ? ['Y'es/'N'o] : "
	if errorlevel 2 goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Starting Copying Source from DVD Drive to ^<DVD^> folder#####################
echo.-------------------------------------------------------------------------------
echo.
echo.-------------------------------------------------------------------------------
echo.####Getting DVD Drive Options##################################################
echo.-------------------------------------------------------------------------------
echo.
:: Getting DVD Drive Letter
set /p DriveLetter=Enter DVD Drive Letter : 

:: Setting DVD Drive Letter
set "DriveLetter=%DriveLetter%:"
echo.

:: Checking whether the specified DVD Drive letter is empty
if not exist "%DriveLetter%\sources\boot.wim" (
	echo.Can't find Windows OS Installation files in the specified Drive Letter..
	echo.
	echo.Please enter the correct DVD Drive Letter..
	goto :Stop
)

:: Checking whether the specified DVD Drive Letter is empty
if not exist "%DriveLetter%\sources\install.wim" (
	echo.Can't find Windows OS Installation files in the specified Drive Letter..
	echo.
	echo.Please enter the correct DVD Drive Letter..
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Copying Source from DVD Drive to ^<DVD^> folder##############################
echo.-------------------------------------------------------------------------------
echo.
call :RemoveFolder "%DVD%"
echo.Copying Source from DVD Drive ^<%DriveLetter%^> to Source ^<DVD^> folder...
echo.
echo.Copying from DVD Drive may take some time, so please wait...
%XCopy% %DriveLetter% "%DVD%" >nul
echo.
echo.Copying Complete...
echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Copying Source from DVD Drive to ^<DVD^> folder#####################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set DriveLetter=

endlocal

:: Returning to Main Menu
goto :MainMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Extract Source from DVD ISO Image to <DVD> folder
::-------------------------------------------------------------------------------------------
:ExtractSourceISO

setlocal

set ISOFileName=

cls
echo.===============================================================================
echo.      MSMG ToolKit - Extract Source from DVD ISO Image to ^<DVD^> folder
echo.===============================================================================
echo.

:: Checking whether Windows Source DVD folder is empty
if exist "%DVD%\sources\*.wim" (
	echo.Toolkit's Source ^<DVD^> folder is not empty...
	echo.
	choice /C:YN /N /M "Do you want to remove it & continue ? ['Y'es/'N'o] : "
	if errorlevel 2 goto :Stop
	echo.
)

:: Checking whether DVD ISO Image folder is empty
if not exist "%ISO%\*.iso" (
	echo.DVD ISO Image folder ^<ISO^> is empty...
	echo.
	echo.Please copy DVD ISO Images to ^<ISO^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Starting Extracting Source from DVD ISO Image to ^<DVD^> folder##############
echo.-------------------------------------------------------------------------------
echo.
echo.-------------------------------------------------------------------------------
echo.####Getting DVD ISO Image Options##############################################
echo.-------------------------------------------------------------------------------
echo.
:: Getting DVD ISO Image file Name
set /p ISOFileName=Enter the ISO Image filename without .iso : 

:: Setting DVD ISO Image file Name
set "ISOFileName=%ISOFileName%.iso"
echo.

:: Checking whether the specified DVD ISO Image file exist
if not exist "%ISO%\%ISOFileName%" (
	echo.Can't find the specified DVD ISO Image in ^<ISO^> folder...
	echo.
	echo.Please enter the correct DVD ISO Image filename...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Extracting Source from DVD ISO Image to ^<DVD^> folder#######################
echo.-------------------------------------------------------------------------------
echo.
call :RemoveFolder "%DVD%"
echo.Extracting DVD ISO Image contents to Source ^<DVD^> folder...
echo.
echo.Extraction may take some time, so please wait...
"%Zip%" x -y "%ISO%\%ISOFileName%" -o"%DVD%" >nul
echo.
set /a n=0
if exist "%DVD%\sources\boot.wim" set /a n+=1
if exist "%DVD%\sources\install.wim" set /a n+=1
if exist "%DVD%\sources\install.esd" set /a n+=1
if "%n%" equ "2" (echo.Extraction Complete...) else echo.Extraction Failed...
echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Extracting Source from DVD ISO Image to ^<DVD^> folder##############
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set ISOFileName=

endlocal

:: Returning to Main Menu
goto :MainMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Extract Source from OEM IMG Image to <DVD> folder
::-------------------------------------------------------------------------------------------
:ExtractSourceIMG

setlocal

set IMGFileName=

cls
echo.===============================================================================
echo.      MSMG ToolKit - Extract Source from OEM IMG Image to ^<DVD^> folder
echo.===============================================================================
echo.

:: Checking whether Windows Source DVD folder is empty
if exist "%DVD%\sources\*.wim" (
	echo.Toolkit's Source ^<DVD^> folder is not empty...
	echo.
	choice /C:YN /N /M "Do you want to remove it & continue ? ['Y'es/'N'o] : "
	if errorlevel 2 goto :Stop
)

:: Checking whether OEM IMG folder is empty
if not exist "%ISO%\*.img" (
	echo.Can't find Windows Install OEM IMG Image file in ^<ISO^> folder...
	echo.
	echo.Please copy Windows Install OEM IMG Image file to ^<ISO^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Starting Extracting Source from OEM IMG Image to ^<DVD^> folder##############
echo.-------------------------------------------------------------------------------
echo.
echo.-------------------------------------------------------------------------------
echo.####Getting OEM IMG Image Options##############################################
echo.-------------------------------------------------------------------------------
echo.
:: Getting OEM IMG file Name
set /p IMGFileName=Enter the OEM IMG filename without .img : 

:: Setting OEM IMG file Name
set "IMGFileName=%IMGFileName%.img"
echo.

:: Checking whether the specified OEM IMG Image file exist
if not exist "%ISO%\%IMGFileName%" (
	echo.Can't find the specified OEM IMG Image file...
	echo.
	echo.Please enter the correct OEM IMG Image filename...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Extracting Source from OEM IMG Image to ^<DVD^> folder#######################
echo.-------------------------------------------------------------------------------
echo.
call :RemoveFolder "%DVD%"
echo.Extracting OEM IMG Image Contents to Source ^<DVD^> folder...
echo.
echo.Extraction may take some time, so please wait...
"%Zip%" x -y "%ISO%\%IMGFileName%" -o"%DVD%" >nul
echo.
set /a n=0
if exist "%DVD%\sources\boot.wim" set /a n+=1
if exist "%DVD%\sources\install.wim" set /a n+=1
if "%n%" equ "2" (echo.Extraction Complete...) else echo.Extraction Failed...
echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Extracting Source from OEM IMG Image to ^<DVD^> folder##############
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set IMGFileName=

endlocal

:: Returning to Main Menu
goto :MainMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Extract Source from Store ESD Image
::-------------------------------------------------------------------------------------------
:ExtractSourceStoreESD

setlocal

set ImageBuild=

cls
echo.===============================================================================
echo.            MSMG ToolKit - Extract Source from Store ESD Image
echo.===============================================================================
echo.

:: Checking whether Windows Source DVD folder is empty
if not exist "%InstallEsd%" (
	echo.Can't find Windows Store ESD Image file "Install.esd" in ^<DVD\Sources^> folder.
	echo.
	echo.Please copy Windows Store ESD Image file to ^<DVD\Sources^> folder...
	goto :Stop
)
echo.-------------------------------------------------------------------------------
echo.####Starting Extracting Source from Store ESD Image############################
echo.-------------------------------------------------------------------------------
echo.
echo.Reading Image Information...
echo.
echo.===============================================================================
echo.^|Index^| Arch ^| Name
echo.===============================================================================
for /f "tokens=2 delims=: " %%a in ('%DISM% /Get-WimInfo /WimFile:"%InstallEsd%" ^| findstr Index') do (
	for /f "tokens=2 delims=:" %%b in ('%DISM% /Get-WimInfo /WimFile:"%InstallEsd%" /Index:%%a ^| findstr /i Architecture') do (
		for /f "tokens=2 delims=:  " %%c in ('%DISM% /Get-WimInfo /WimFile:"%InstallEsd%" /Index:%%a ^| findstr /i Name') do (
			if %%a equ 1 echo.^|  %%a  ^|  -   ^|%%c
			if %%a gtr 1 if %%a leq 9 echo.^|  %%a  ^|%%b  ^|%%c
			if %%a gtr 9 echo.^|  %%a ^|%%b  ^|%%c
		)
	)
)
echo.===============================================================================
echo.

:: Finding total no of indexes present inside the ESD Image
call :GetImageCount "%InstallEsd%"

if %ImageCount% equ 4 set ImageIndexNo=4

if %ImageCount% gtr 4 (
	:: Getting Image Index Number to Service
	set /p ImageIndexNo=Enter the Image Index # [Range : 4,...%ImageCount%, 'A'll, 'Q'uit] : 

	:: Checking for Image Index Validation
	if not defined ImageIndexNo (
		echo.
		echo.Invalid Index # Entered, Valid Range is [4,...%ImageCount%, 'A'll, 'Q'uit]
		echo.
		pause
		goto :ExtractSourceStoreESD
	)

	if /i "%ImageIndexNo%" equ "A" (
		set "ImageIndexNo=3"

    	for /l %%i in (4, 1, %ImageCount%) do (
        	set "ImageIndexNo=!ImageIndexNo!,%%i"
    	)
	)

	if /i "%ImageIndexNo%" equ "Q" goto :MainMenu
)
echo.
echo.-------------------------------------------------------------------------------
echo.####Extracting Source from Store ESD Image#####################################
echo.-------------------------------------------------------------------------------
echo.
echo.Decrypting Windows Store ESD Image if it's been encrypted...
attrib -r -h -s -a "%InstallEsd%" >nul
for /f "skip=1 tokens=4 delims=:." %%e in ('%DISM% /Get-WimInfo /WimFile:"%InstallEsd%" /Index:4 ^| find /i "Version"') do set ImageBuild=%%e
if %ImageBuild% equ 9600 "%W81EsdDecrypter%" "%InstallEsd%" 2>nul
if %ImageBuild% gtr 9600 "%W10EsdDecrypter%" "%InstallEsd%" >nul
echo.
echo.-------------------------------------------------------------------------------
echo.Applying Windows Store ESD Image [Install.esd, Index : 1] to ^<Temp\DVD^>...
echo.-------------------------------------------------------------------------------
:: Creating Windows Setup Installation Media folder "%Temp%\DVD"
call :RemoveFolder "%Temp%\DVD"
call :CreateFolder "%Temp%\DVD"
call :ApplyImage "%InstallEsd%", 1, "%Temp%\DVD"
echo.-------------------------------------------------------------------------------
echo.Exporting Windows Store ESD Image [Install.esd, Index : 2] to Boot Image...
echo.-------------------------------------------------------------------------------
rem call :ExportImageIndex "%InstallEsd%", 2, "%Temp%\DVD\sources\boot.wim", "WIM", "Yes"
echo.
"%WimlibImagex%" export "%InstallEsd%" 2 "%Temp%\DVD\sources\boot.wim" --boot --compress=LZX
call :DeleteImage "%Temp%\DVD\sources\boot.wim", 1 >nul
echo.
echo.-------------------------------------------------------------------------------
echo.Exporting Windows Store ESD Image [Install.esd, Index : 3] to Boot Image...
echo.-------------------------------------------------------------------------------
rem call :ExportImageIndex "%InstallEsd%", 3, "%Temp%\DVD\sources\boot.wim", "WIM", "Yes"
echo.
"%WimlibImagex%" export "%InstallEsd%" 3 "%Temp%\DVD\sources\boot.wim" --boot --compress=LZX
echo.
if %ImageBuild% equ 9600 (
	echo.-------------------------------------------------------------------------------
	echo.Exporting Windows Store ESD Image [Install.esd, Index : 4] to Install Image...
	echo.-------------------------------------------------------------------------------
	rem call :ExportImageIndex "%InstallEsd%", 4, "%Temp%\DVD\sources\install.wim", "WIM", "No"
	echo.
	"%WimlibImagex%" export "%InstallEsd%" 4 "%Temp%\DVD\sources\install.wim" --compress=LZX
	echo.
)

if %ImageBuild% gtr 9600 (
	for %%i in (%ImageIndexNo%) do (
		echo.-------------------------------------------------------------------------------
		echo.Exporting Windows Store ESD Image [Install.esd, Index : %%i] to Install Image...
		echo.-------------------------------------------------------------------------------
		rem call :ExportImageIndex "%InstallEsd%", %%i, "%Temp%\DVD\sources\install.wim", "WIM", "No"
		echo.
		"%WimlibImagex%" export "%InstallEsd%" %%i "%Temp%\DVD\sources\install.wim" --compress=LZX
		echo.
	)
)

:: Moving ESD to WIM converted folder <Temp\DVD> to <DVD> Source Folder
call :RemoveFolder "%DVD%"
move /y "%Temp%\DVD" "%ROOT%" >nul

echo.-------------------------------------------------------------------------------
echo.####Copying EI.CFG Config file to Source ^<DVD\sources^> folder##################
echo.-------------------------------------------------------------------------------
echo.
:: Getting Install Image Index Edition
call :GetImageEdition "%InstallWim%", 1

:: Writing EI.cfg Config file to <DVD\sources> folder
echo.Copying EI.CFG file to ^<DVD\sources^> folder...

if exist "%DVD%\sources\EI.CFG" del /f /q "%DVD%\sources\EI.CFG" >nul
(
	echo.[EditionID]
	if %ImageCount% equ 1 echo.%ImageEdition%
	if %ImageCount% gtr 1 echo.
	echo.
	echo.[Channel]
	echo.Retail
	echo.
	echo.[VL]
	echo.0
	echo.
)>"%DVD%\sources\EI.CFG"

:: Cleaning Up Unwanted files from Source folder
call :RemoveFile "%DVD%\MediaMeta.xml"
echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Extracting Source from Store ESD Image############################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set ImageBuild=

endlocal

:: Returning to Main Menu
goto :MainMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG Toolkit - Extract Source from MCT or Custom ESD Install Image
::-------------------------------------------------------------------------------------------
:ExtractSourceESD

setlocal

cls
echo.===============================================================================
echo.   MSMG ToolKit - Extract Source from MCT or Custom ESD Install Image
echo.===============================================================================
echo.

:: Checking whether Windows Source Boot Image exist
if not exist "%BootWim%" (
	echo.Can't find Windows Setup "Boot.wim" Image in ^<DVD\Sources^> folder...
	echo.
	echo.Please copy Windows Setup "Boot.wim" Image to ^<DVD\Sources^> folder...
	goto :Stop
)

:: Checking whether Windows Source Install ESD Image exist
if not exist "%InstallEsd%" (
	echo.Can't find Windows Setup "Install.esd" Image in ^<DVD\Sources^> folder...
	echo.
	echo.Please copy Windows Setup "Install.esd" Image to ^<DVD\Sources^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Starting Extract Source from MCT or Custom ESD Install Image###############
echo.-------------------------------------------------------------------------------
echo.
echo.Reading Image Information...
echo.
echo.===============================================================================
echo.^|Index^| Arch ^| Name
echo.===============================================================================
for /f "tokens=2 delims=: " %%a in ('%DISM% /Get-WimInfo /WimFile:"%InstallEsd%" ^| findstr Index') do (
	for /f "tokens=2 delims=:" %%b in ('%DISM% /Get-WimInfo /WimFile:"%InstallEsd%" /Index:%%a ^| findstr /i Architecture') do (
		for /f "tokens=2 delims=:  " %%c in ('%DISM% /Get-WimInfo /WimFile:"%InstallEsd%" /Index:%%a ^| findstr /i Name') do (
			if %%a leq 9 echo.^|  %%a  ^|%%b  ^|%%c
			if %%a gtr 9 echo.^|  %%a ^|%%b  ^|%%c
		)
	)
)
echo.===============================================================================
echo.

:: Finding total no of indexes present inside the ESD Image
call :GetImageCount "%InstallEsd%"

if %ImageCount% equ 1 (
	set /p ImageIndexNo=Enter the ESD Image Index # ['Q'uit] : 
) else set /p ImageIndexNo=Enter the ESD Image Index # [Range : 1,2,...%ImageCount%, 'A'll, 'Q'uit] : 

:: Checking for Image Index Validation
if not defined ImageIndexNo (
	echo.
	echo.Invalid Index # Entered, Valid Range is [1,2,...%ImageCount%, 'A'll, 'Q'uit]
	echo.
	pause
	goto :ExtractSourceESD
)

if /i "%ImageIndexNo%" equ "A" (
	set "ImageIndexNo=1"
    for /l %%i in (2, 1, %ImageCount%) do (
        set "ImageIndexNo=!ImageIndexNo!,%%i"
    )
)

if /i "%ImageIndexNo%" equ "Q" goto :MainMenu

echo.
echo.-------------------------------------------------------------------------------
echo.####Extracting Source from MCT or Custom ESD Install Image#####################
echo.-------------------------------------------------------------------------------

:: Converting Source MCT or Custom ESD Install Image to WIM Image
for %%i in (%ImageIndexNo%) do (
	echo.-------------------------------------------------------------------------------
	echo.Exporting [Install.esd, Index : %%i] to Install Image...
	echo.-------------------------------------------------------------------------------
	rem call :ExportImageIndex "%InstallEsd%", %%i, "%InstallWim%", "WIM", "No"
	echo.
	"%WimlibImagex%" export "%InstallEsd%" %%i "%InstallWim%" --compress=LZX
	echo.
)

:: Deleting original Source MCT or Custom ESD Install Image
call :RemoveFile "%InstallEsd%"

echo.-------------------------------------------------------------------------------
echo.####Finished Extract Source from MCT or Custom ESD Install Image###############
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

endlocal

:: Returning to Main Menu
goto :MainMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Language Packs Menu
::-------------------------------------------------------------------------------------------
:IntLanguagePacksMenu

if "%IsDialogsEnabled%" equ "Yes" (
	cls
	echo.===============================================================================
	echo.               MSMG ToolKit - Integrate Windows Language Packs
	echo.===============================================================================
	echo.
	echo.
	echo.
	echo.                                W A R N I N G
	echo.                                =============
	echo.
	echo.   Do not integrate a language pack after an update. If you integrate any
	echo.   updates ^(Hotfix, General Distribution Release [GDR], Zero Day Patch [ZDP]
	echo.   or Service Pack [SP]^) that contains language-dependent resources before
	echo.   you integrate a language pack, The language-specific changes that are
	echo.   contained in the update are not applied and you will have to re-integrate
	echo.   the update. Always integrate language packs before you integrate updates.
	echo.
	echo.
	echo.
	echo.
	echo.   To turn off Warning Dialogs, Choose Disable Dialogs in Tools-^>Options Menu
	echo.
	echo.===============================================================================
	echo.
	choice /C:YN /N /M "Do you want to Continue ? ['Y'es/'N'o] : "
	if errorlevel 2 goto :IntegrateMenu
)

setlocal

set LanguagePackType=
set LanguagePackCode=

cls
echo.===============================================================================
echo.             MSMG ToolKit - Integrate Windows Language Packs Menu
echo.===============================================================================
echo.
echo.  [1]   Integrate to Windows Setup Boot Image
echo.
echo.  [2]   Integrate to Windows Installation Image
echo.
echo.  [3]   Integrate to Windows Recovery Image
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.
choice /C:123X /N /M "Enter Your Choice : "
if errorlevel 4 goto :IntegrateMenu
if errorlevel 3 set "LanguagePackType=Recovery"
if errorlevel 2 set "LanguagePackType=Install"
if errorlevel 1 set "LanguagePackType=Boot"

cls
echo.===============================================================================
echo.             MSMG ToolKit - Integrate Windows Language Packs Menu
echo.===============================================================================
echo.

if "%LanguagePackType%" equ "Boot" if "%IsBootImageSelected%" equ "No" (
	echo.Windows Setup Boot Image is not selected...
	echo.
	echo.Please choose Windows Setup Boot Image while selecting Source...
	goto :Stop
)

if "%LanguagePackType%" equ "Recovery" if "%IsRecoveryImageSelected%" equ "No" (
	echo.Windows Recovery Image is not selected...
	echo.
	echo.Please choose Windows Recovery Image while selecting Source...
	goto :Stop
)

cls
echo.===============================================================================
echo.    MSMG ToolKit - Integrate Windows Language Packs - Choose Language Menu
echo.===============================================================================

if "%SelectedSourceOS%" equ "w7" (
	echo. Arabic - Saudi Arabia    [ar-SA]    Latvian - Latvia         [lv-LV]
	echo. Bulgarian - Bulgaria     [bg-BG]    Lithuanian - Lithuania   [lt-LT]
	echo. Chinese - Hong Kong SAR  [zh-HK]    Norwegian - Norway       [nb-NO]
	echo. Chinese - Simplified     [zh-CN]    Polish - Poland          [pl-PL]
	echo. Chinese - Taiwan         [zh-TW]    Portuguese - Brazil      [pt-BR]
	echo. Croatian - Croatia       [hr-HR]    Portuguese - Portugal    [pt-PT]
	echo. Czech - Czech Republic   [cs-CZ]    Romanian - Romania       [ro-RO]
	echo. Danish - Denmark         [da-DK]    Russian - Russia         [ru-RU]
	echo. Dutch - The Netherlands  [nl-NL]    Serbian - Serbia         [sr-Latn-CS]
	echo. English - United States  [en-US]    Slovak - Slovakia        [sk-SK]
	echo. Estonian - Estonia       [et-EE]    Slovenian - Slovenia     [sl-SI]
	echo. Finnish - Finland        [fi-FI]    Spanish - Spain          [es-ES]
	echo. French - France          [fr-FR]    Swedish - Sweden         [sv-SE]
	echo. German - Germany         [de-DE]    Thai - Thailand          [th-TH]
	echo. Greek - Greece           [el-GR]    Turkish - Turkey         [tr-TR]
	echo. Hebrew - israel          [he-IL]    Ukrainian - Ukraine      [uk-UA]
	echo. Hungarian - Hungary      [hu-HU]
	echo. Italian - Italy          [it-IT]
	echo. Japanese - Japan         [ja-JP]
	echo. Korean - Korea           [ko-KR]   [X] Go-Back
)

if "%SelectedSourceOS%" equ "w81" (
	echo. Arabic - Saudi Arabia    [ar-SA]    Korean - Korea           [ko-KR]
	echo. Bulgarian - Bulgaria     [bg-BG]    Latvian - Latvia         [lv-LV]
	echo. Chinese - Hong Kong SAR  [zh-HK]    Lithuanian - Lithuania   [lt-LT]
	echo. Chinese - Simplified     [zh-CN]    Norwegian - Norway       [nb-NO]
	echo. Chinese - Taiwan         [zh-TW]    Polish - Poland          [pl-PL]
	echo. Croatian - Croatia       [hr-HR]    Portuguese - Brazil      [pt-BR]
	echo. Czech - Czech Republic   [cs-CZ]    Portuguese - Portugal    [pt-PT]
	echo. Danish - Denmark         [da-DK]    Romanian - Romania       [ro-RO]
	echo. Dutch - The Netherlands  [nl-NL]    Russian - Russia         [ru-RU]
	echo. English - United Kingdom [en-GB]    Serbian - Serbia         [sr-Latn-CS]
	echo. English - United States  [en-US]    Slovak - Slovakia        [sk-SK]
	echo. Estonian - Estonia       [et-EE]    Slovenian - Slovenia     [sl-SI]
	echo. Finnish - Finland        [fi-FI]    Spanish - Spain          [es-ES]
	echo. French - France          [fr-FR]    Swedish - Sweden         [sv-SE]
	echo. German - Germany         [de-DE]    Thai - Thailand          [th-TH]
	echo. Greek - Greece           [el-GR]    Turkish - Turkey         [tr-TR]
	echo. Hebrew - israel          [he-IL]    Ukrainian - Ukraine      [uk-UA]
	echo. Hungarian - Hungary      [hu-HU]
	echo. Italian - Italy          [it-IT]
	echo. Japanese - Japan         [ja-JP]	  [X] Go-Back
)

if "%SelectedSourceOS%" equ "w10" (
	echo. Arabic - Saudi Arabia    [ar-SA]    Japanese - Japan         [ja-JP]
	echo. Bulgarian - Bulgaria     [bg-BG]    Korean - Korea           [ko-KR]
	echo. Chinese - Hong Kong SAR  [zh-HK]    Latvian - Latvia         [lv-LV]
	echo. Chinese - Simplified     [zh-CN]    Lithuanian - Lithuania   [lt-LT]
	echo. Chinese - Taiwan         [zh-TW]    Norwegian - Norway       [nb-NO]
	echo. Croatian - Croatia       [hr-HR]    Polish - Poland          [pl-PL]
	echo. Czech - Czech Republic   [cs-CZ]    Portuguese - Brazil      [pt-BR]
	echo. Danish - Denmark         [da-DK]    Portuguese - Portugal    [pt-PT]
	echo. Dutch - The Netherlands  [nl-NL]    Romanian - Romania       [ro-RO]
	echo. English - United Kingdom [en-GB]    Russian - Russia         [ru-RU]
	echo. English - United States  [en-US]    Serbian - Serbia         [sr-Latn-RS]
	echo. Estonian - Estonia       [et-EE]    Slovak - Slovakia        [sk-SK]
	echo. Finnish - Finland        [fi-FI]    Slovenian - Slovenia     [sl-SI]
	echo. French - Canada          [fr-CA]    Spanish - Mexico         [es-MX]
	echo. French - France          [fr-FR]    Spanish - Spain          [es-ES]
	echo. German - Germany         [de-DE]    Swedish - Sweden         [sv-SE]
	echo. Greek - Greece           [el-GR]    Thai - Thailand          [th-TH]
	echo. Hebrew - israel          [he-IL]    Turkish - Turkey         [tr-TR]
	echo. Hungarian - Hungary      [hu-HU]    Ukrainian - Ukraine      [uk-UA]
	echo. Italian - Italy          [it-IT]    [X] Go-Back
)

if "%SelectedSourceOS%" equ "w11" (
	echo. Arabic - Saudi Arabia    [ar-SA]    Italian - Italy          [it-IT]
	echo. Basque - Spain           [eu-ES]    Japanese - Japan         [ja-JP]
	echo. Bulgarian - Bulgaria     [bg-BG]    Korean - Korea           [ko-KR]
	echo. Catalan - Spain          [ca-ES]    Latvian - Latvia         [lt-LT]
	echo. Chinese - Simplified     [zh-CN]    Lithuanian - Lithuania   [lv-LV]
	echo. Chinese - Taiwan         [zh-TW]    Norwegian - Norway       [nb-NO]
	echo. Croatian - Croatia       [hr-HR]    Polish - Poland          [pl-PL]
	echo. Czech - Czech Republic   [cs-CZ]    Portuguese - Brazil      [pt-BR]
	echo. Danish - Denmark         [da-DK]    Portuguese - Portugal    [pt-PT]
	echo. Dutch - The Netherlands  [nl-NL]    Romanian - Romania       [ro-RO]
	echo. English - United Kingdom [en-GB]    Russian - Russia         [ru-RU]
	echo. English - United States  [en-US]    Serbian - Serbia         [sr-Latn-RS]
	echo. Estonian - Estonia       [et-EE]    Slovak - Slovakia        [sk-SK]
	echo. Finnish - Finland        [fi-FI]    Slovenian - Slovenia     [sl-SI]
	echo. French - Canada          [fr-CA]    Spanish - Mexico         [es-MX]
	echo. French - France          [fr-FR]    Spanish - Spain          [es-ES]
	echo. Galician - Spain         [gl-ES]    Swedish - Sweden         [sv-SE]
	echo. German - Germany         [de-DE]    Thai - Thailand          [th-TH]
	echo. Greek - Greece           [el-GR]    Turkish - Turkey         [tr-TR]
	echo. Hebrew - israel          [he-IL]    Ukrainian - Ukraine      [uk-UA]
	echo. Hungarian - Hungary      [hu-HU]    Vietnamese - Viet Nam    [vi-VN]
	echo. Indonesian - Indonesia   [id-ID]    [X] Go-Back
)
echo.===============================================================================
set /p LanguagePackCode=Enter Language Code without '[' ']' : 

if /i "%LanguagePackCode%" equ "X" goto :IntegrateMenu

cls
echo.===============================================================================
if "%LanguagePackType%" equ "Boot" echo.  MSMG ToolKit - Integrate Windows Language Packs to Windows Setup Boot Image
if "%LanguagePackType%" equ "Install" echo. MSMG ToolKit - Integrate Windows Language Packs to Windows Installation Image
if "%LanguagePackType%" equ "Recovery" echo.   MSMG ToolKit - Integrate Windows Language Packs to Windows Recovery Image
echo.===============================================================================
echo.

:: Getting Source Image Index Architecture
if "%LanguagePackType%" equ "Boot" (
	call :GetImageArchitecture "%BootWim%", 1 >nul
) else (
	call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul
)

:: Settings Windows Language Packs folder path
if "%SelectedSourceOS%" neq "w10" if "%SelectedSourceOS%" neq "w11" set "LanguagePacks=%LanguagePacks%\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%"
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" set "LanguagePacks=%LanguagePacks%\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%"

:: Checking whether Windows PE Language Packs folder is empty
if "%LanguagePackType%" equ "Boot" (
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType:~,6%" neq "Server" if not exist "%LanguagePacks%\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType:~,6%" equ "Server" if not exist "%LanguagePacks%\WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-EnhancedStorage-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-EnhancedStorage-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if "%PackageArchitecture%" neq "arm" if not exist "%LanguagePacks%\WinPE-Rejuv-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Rejuv-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-SecureStartup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-SecureStartup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType:~,6%" neq "Server" if not exist "%LanguagePacks%\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType:~,6%" equ "Server" if not exist "%LanguagePacks%\WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if "%PackageArchitecture%" neq "arm" if not exist "%LanguagePacks%\WinPE-StorageWMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-StorageWMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if not exist "%LanguagePacks%\WinPE-ATBroker-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-ATBroker-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if not exist "%LanguagePacks%\WinPE-AudioCore-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-AudioCore-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if not exist "%LanguagePacks%\WinPE-AudioDrivers-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-AudioDrivers-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-EnhancedStorage-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-EnhancedStorage-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if not exist "%LanguagePacks%\WinPE-Narrator-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Narrator-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-SecureStartup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-SecureStartup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageInstallationType:~,6%" neq "Server" if not exist "%BootMount%\2\Windows\servicing\Packages\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" if not exist "%Packs%\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageInstallationType:~,6%" neq "Server" if not exist "%LanguagePacks%\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageInstallationType:~,6%" equ "Server" if not exist "%BootMount%\2\Windows\servicing\Packages\WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" if not exist "%Packs%\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageInstallationType:~,6%" equ "Server" if not exist "%LanguagePacks%\WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%BootMount%\2\Windows\servicing\Packages\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" if not exist "%Packs%\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if "%ImageBuild%" leq "22000" (
		for /d %%i in (de-DE, en-GB, es-ES, es-MX, fr-CA, fr-FR, it-IT, ja-JP, ko-KR, pl-PL, pt-BR, pt-PT, ru-RU, zh-CN, zh-HK, zh-TW) do (
			if "%LanguagePackCode%" equ "%%i" if not exist "%LanguagePacks%\WinPE-Speech-TTS-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
				echo.Windows Language Pack folder is missing the below file...
				echo.
				echo."WinPE-Speech-TTS-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.
				echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
				goto :Stop
			)
		)
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if not exist "%LanguagePacks%\WinPE-Speech-TTS-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Speech-TTS-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if not exist "%LanguagePacks%\WinPE-SRH-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-SRH-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
)

:: Checking whether Windows Language or Language Features Packs folder is empty
if "%LanguagePackType%" equ "Install" (
	if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Client" if not exist "%LanguagePacks%\Microsoft-Windows-Client-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-Client-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Embedded" if not exist "%LanguagePacks%\Microsoft-Windows-Embedded-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-Embedded-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType:~,6%" equ "Server" if not exist "%LanguagePacks%\Microsoft-Windows-Server-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-Server-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType:~,6%" neq "Server" if not exist "%LanguagePacks%\Microsoft-Windows-Client-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-Client-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType:~,6%" equ "Server" if not exist "%LanguagePacks%\Microsoft-Windows-Server-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-Server-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageInstallationType%" equ "Client" if not exist "%LanguagePacks%\Microsoft-Windows-Client-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-Client-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageInstallationType:~,6%" equ "Server" if not exist "%LanguagePacks%\Microsoft-Windows-Server-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-Server-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
)

:: Checking whether Windows PE Language Packs folder is empty
if "%LanguagePackType%" equ "Recovery" (
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w7" if not exist "%LanguagePacks%\WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-EnhancedStorage-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-EnhancedStorage-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-Rejuv-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Rejuv-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-SecureStartup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-SecureStartup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if "%PackageArchitecture%" neq "arm" if "%ImageInstallationType:~,6%" neq "Server" if not exist "%LanguagePacks%\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType:~,6%" equ "Server" if not exist "%LanguagePacks%\WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if "%PackageArchitecture%" neq "arm" if not exist "%LanguagePacks%\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-StorageWMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-StorageWMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" equ "w81" if not exist "%LanguagePacks%\WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "22621" if not exist "%LanguagePacks%\WinPE-AppxDeployment-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-AppxDeployment-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17134" if not exist "%LanguagePacks%\WinPE-AppxPackaging-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-AppxPackaging-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if not exist "%LanguagePacks%\WinPE-ATBroker-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-ATBroker-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if not exist "%LanguagePacks%\WinPE-AudioCore-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-AudioCore-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if not exist "%LanguagePacks%\WinPE-AudioDrivers-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-AudioDrivers-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-EnhancedStorage-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-EnhancedStorage-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-HTA-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-HTA-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if not exist "%LanguagePacks%\WinPE-Narrator-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Narrator-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17134" if not exist "%LanguagePacks%\WinPE-OpcServices-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-OpcServices-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-Rejuv-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Rejuv-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-SecureStartup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-SecureStartup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if "%ImageBuild%" leq "22000" (
		for /d %%i in (de-DE, en-GB, es-ES, es-MX, fr-CA, fr-FR, it-IT, ja-JP, ko-KR, pl-PL, pt-BR, pt-PT, ru-RU, zh-CN, zh-HK, zh-TW) do (
			if "%LanguagePackCode%" equ "%%i" if not exist "%LanguagePacks%\WinPE-Speech-TTS-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
				echo.Windows Language Pack folder is missing the below file...
				echo.
				echo."WinPE-Speech-TTS-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.
				echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
				goto :Stop
			)
		)
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if not exist "%LanguagePacks%\WinPE-Speech-TTS-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-Speech-TTS-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if not exist "%LanguagePacks%\WinPE-SRH-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-SRH-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-StorageWMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-StorageWMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "14393" if not exist "%LanguagePacks%\WinPE-WiFi-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WiFi-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "22621" if not exist "%LanguagePacks%\WinPE-WindowsUpdate-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WindowsUpdate-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%LanguagePacks%\WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Language Pack folder is missing the below file...
		echo.
		echo."WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\%LanguagePackCode%^> folder...
		goto :Stop
	)
)
echo.-------------------------------------------------------------------------------
if "%LanguagePackType%" equ "Boot" echo.####Started Integrating Windows Language Packs to Windows Boot Image###########
if "%LanguagePackType%" equ "Install" echo.####Started Integrating Windows Language Packs to Windows Installation Image###
if "%LanguagePackType%" equ "Recovery" echo.####Started Integrating Windows Language Packs to Windows Recovery Image#######
echo.-------------------------------------------------------------------------------
echo.
if "%LanguagePackType%" equ "Boot" (
	echo.    Image                    : Boot.wim
	echo.    Image Index              : 1, 2
)
if "%LanguagePackType%" equ "Install" (
	echo.    Image                    : Install.wim
	echo.    Image Index              : %ImageIndexNo%
)
if "%LanguagePackType%" equ "Recovery" (
	echo.    Image                    : WinRE.wim
	echo.    Image Index              : 1
)
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
if "%LanguagePackType%" equ "Boot" echo.####Integrating Windows Language Packs to Windows Boot Image###################
if "%LanguagePackType%" equ "Install" echo.####Integrating Windows Language Packs to Windows Installation Image###########
if "%LanguagePackType%" equ "Recovery" echo.####Integrating Windows Language Packs to Windows Recovery Image###############
echo.-------------------------------------------------------------------------------
echo.
if "%LanguagePackType%" equ "Boot" (
	for /l %%i in (1, 1, 2) do (
		echo.=============================[Boot.wim, Index : %%i]=============================
		echo.
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE Language Pack [%LanguagePackCode%] to Windows Boot Image...
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w7" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" equ "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
			call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"

			if "%ImageBuild%" geq "15063" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating WinPE - AT Broker [%LanguagePackCode%] to Windows Boot Image...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-ATBroker-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WinPE - Audio Core [%LanguagePackCode%] to Windows Boot Image...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-AudioCore-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WinPE - Audio Drivers [%LanguagePackCode%] to Windows Boot Image...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-AudioDrivers-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
			)
		)

		if "%SelectedSourceOS%" neq "w7" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - Enhanced Storage Pack [%LanguagePackCode%] to Windows Boot Image...
			echo.-------------------------------------------------------------------------------
			if "%SelectedSourceOS%" equ "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-EnhancedStorage-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
			if "%SelectedSourceOS%" neq "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-EnhancedStorage-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		)
		
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - Narrator [%LanguagePackCode%] to Windows Boot Image...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-Narrator-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		)

		if "%SelectedSourceOS%" equ "w81" if exist "%LanguagePacks%\WinPE-IbsProvider-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - IBS Provider Pack [%LanguagePackCode%] to Windows Boot Image...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-IbsProvider-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		)

		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - Scripting Pack [%LanguagePackCode%] to Windows Boot Image...
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w7" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" equ "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"

		if "%SelectedSourceOS%" neq "w7" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - Secure Startup Pack [%LanguagePackCode%] to Windows Boot Image...
			echo.-------------------------------------------------------------------------------
			if "%SelectedSourceOS%" equ "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-SecureStartup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
			if "%SelectedSourceOS%" neq "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-SecureStartup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		)
	)

	echo.=============================[Boot.wim, Index : 2]=============================
	echo.
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%BootMount%\2\Windows\servicing\Packages\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - Setup Pack to Windows Boot Image...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%BootMount%\2", "%Packs%\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
	)

	echo.-------------------------------------------------------------------------------
	echo.Integrating WinPE - Setup Pack [%LanguagePackCode%] to Windows Boot Image...
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" call :AddPackage "%BootMount%\2", "%LanguagePacks%\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
	if "%SelectedSourceOS%" equ "w81" call :AddPackage "%BootMount%\2", "%LanguagePacks%\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%BootMount%\2", "%LanguagePacks%\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"

	if "%ImageInstallationType:~,6%" neq "Server" (
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%BootMount%\2\Windows\servicing\Packages\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - Setup Client Pack to Windows Boot Image...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\2", "%Packs%\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
		)

		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - Setup Client Pack [%LanguagePackCode%] to Windows Boot Image...
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w7" call :AddPackage "%BootMount%\2", "%LanguagePacks%\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" equ "w81" call :AddPackage "%BootMount%\2", "%LanguagePacks%\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%BootMount%\2", "%LanguagePacks%\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
	)

	if "%ImageInstallationType:~,6%" equ "Server" (
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%BootMount%\2\Windows\servicing\Packages\WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - Setup Server Pack to Windows Boot Image...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\2", "%Packs%\LanguagePacks\%SelectedSourceOS%\%PackageVersion%\%ImageArchitecture%\WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
		)

		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - Setup Server Pack [%LanguagePackCode%] to Windows Boot Image...
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w7" call :AddPackage "%BootMount%\2", "%LanguagePacks%\WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" equ "w81" call :AddPackage "%BootMount%\2", "%LanguagePacks%\WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%BootMount%\2", "%LanguagePacks%\WinPE-Setup-Server-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
	)

	for /l %%i in (1, 1, 2) do (
		echo.=============================[Boot.wim, Index : %%i]=============================
		echo.
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if "%ImageBuild%" leq "22000" (
			for /d %%z in (de-DE, en-GB, es-ES, es-MX, fr-CA, fr-FR, it-IT, ja-JP, ko-KR, pl-PL, pt-BR, pt-PT, ru-RU, zh-CN, zh-HK, zh-TW) do (
				if "%LanguagePackCode%" equ "%%z" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating WinPE - Speech TextToSpeech [%LanguagePackCode%] to Windows Boot Image...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-Speech-TTS-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
				)
			)
		)

		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - Speech TextToSpeech [%LanguagePackCode%] to Windows Boot Image...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-Speech-TTS-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - SRH [%LanguagePackCode%] to Windows Boot Image...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-SRH-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		)

		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - SRT Pack [%LanguagePackCode%] to Windows Boot Image...
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w7" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" equ "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - WDS Pack [%LanguagePackCode%] to Windows Boot Image...
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w7" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" equ "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - WMI Pack [%LanguagePackCode%] to Windows Boot Image...
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w7" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" equ "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"

		for /d %%z in (ja-JP, ko-KR, zh-HK, zh-CN, zh-TW) do (
			if "%LanguagePackCode%" equ "%%z" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating WinPE - Font Support Pack [%LanguagePackCode%] to Windows Boot Image...
				echo.-------------------------------------------------------------------------------
				if "%SelectedSourceOS%" equ "w7" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-FontSupport-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
				if "%SelectedSourceOS%" equ "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-FontSupport-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
				if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%BootMount%\%%i", "%LanguagePacks%\WinPE-FontSupport-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
			)
		)

		echo.-------------------------------------------------------------------------------
		echo.Generating Windows Boot Language Packs Integration Log File...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Writing Windows Boot Language Packs Integration Log...
		call :GetPackages "%BootMount%\%%i", "Boot-%%i.txt"
		echo.
	)

	echo.-------------------------------------------------------------------------------
	echo.Creating Windows Setup language configuration file [Lang.ini]...
	echo.-------------------------------------------------------------------------------
	%DISM% /Image:"%BootMount%\2" /Gen-LangINI /Distribution:"%DVD%"
	echo.
	echo.-------------------------------------------------------------------------------
	echo.Integrating [%LanguagePackCode%] Localized Windows Setup resources to the Source DVD...
	echo.-------------------------------------------------------------------------------
	echo.
	echo.Extracting Windows PE Language Pack [%LanguagePackCode%] to Temporary folder...
	call :RemoveFolder "%Temp%\LanguagePack"
	call :CreateFolder "%Temp%\LanguagePack"

	if "%SelectedSourceOS%" neq "w10" if "%SelectedSourceOS%" neq "w11" (
		if "%SelectedSourceOS%" equ "w7" expand "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" -f:* "%Temp%\LanguagePack" >nul
		if "%SelectedSourceOS%" equ "w81" expand "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" -f:* "%Temp%\LanguagePack" >nul
		echo.
		echo.Copying Localized Windows Setup resources files to the Source DVD...
		call :CreateFolder "%DVD%\sources\%LanguagePackCode%"
		if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType:~,6%" neq "Server" call :CreateFolder "%DVD%\sources\cli"
		if "%ImageArchitecture%" equ "x86" call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		if "%SelectedSourceOS%" equ "w81" call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-sxs\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\etwproviders\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%"
		if "%SelectedSourceOS%" equ "w81" call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		if "%SelectedSourceOS%" equ "w81" call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%"
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\*.*" "%DVD%\sources\%LanguagePackCode%" >nul
		if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType:~,6%" neq "Server" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\cli\*.*" "%DVD%\sources\cli" >nul
		if "%ImageArchitecture%" equ "x86" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-iasserver-migplugin\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
		if "%SelectedSourceOS%" equ "w81" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\etwproviders\*.*" "%DVD%\sources\etwproviders\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-offlinefiles-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%" >nul
		if "%SelectedSourceOS%" equ "w81" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
		if "%SelectedSourceOS%" equ "w81" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
		echo.
	)

	if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" leq "15063" (
		expand "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" -f:* "%Temp%\LanguagePack" >nul
		echo.
		echo.Copying Localized Windows Setup resources files to the Source DVD...
		call :CreateFolder "%DVD%\sources\%LanguagePackCode%"
		if "%ImageBuild%" leq "10586" if "%ImageInstallationType:~,6%" neq "Server" call :CreateFolder "%DVD%\sources\cli\%LanguagePackCode%"
		if "%ImageArchitecture%" equ "x86" call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-shmig-dl\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-sxs\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\etwproviders\%LanguagePackCode%"
		if "%ImageBuild%" neq "10240" if "%ImageBuild%" neq "10586" if "%ImageArchitecture%" equ "x64" call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-fabric-core\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-shmig\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%"
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\*.*" "%DVD%\sources\%LanguagePackCode%" >nul
		if "%ImageBuild%" leq "10586" if "%ImageInstallationType:~,6%" neq "Server" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\cli\*.*" "%DVD%\sources\cli\%LanguagePackCode%" >nul
		if "%ImageArchitecture%" equ "x86" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-iasserver-migplugin\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-shmig-dl\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-shmig-dl\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\etwproviders\*.*" "%DVD%\sources\etwproviders\%LanguagePackCode%" >nul
		if "%ImageBuild%" neq "10240" if "%ImageBuild%" neq "10586" if "%ImageArchitecture%" equ "x64" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-fabric-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-fabric-core\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-offlinefiles-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-shmig\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-shmig\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
		echo.
	)

	if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "16299" if "%ImageBuild%" leq "17763" if "%LanguagePackCode%" neq "en-US" (
		expand "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" -f:* "%Temp%\LanguagePack" >nul
		echo.
		echo.Copying Localized Windows Setup resources files to the Source DVD...
		call :CreateFolder "%DVD%\sources\%LanguagePackCode%"
		if "%ImageBuild%" leq "17134" if "%ImageArchitecture%" equ "x86" call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%"
		if "%ImageBuild%" leq "17134" call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\etwproviders\%LanguagePackCode%"
		if "%ImageBuild%" equ "16299" if "%ImageArchitecture%" equ "x64" call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-fabric-core\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-shmig\%LanguagePackCode%"
		if "%ImageBuild%" leq "17134" call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%"
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\*.*" "%DVD%\sources\%LanguagePackCode%" >nul
		if "%ImageBuild%" leq "17134" if "%ImageArchitecture%" equ "x86" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-iasserver-migplugin\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%" >nul
		if "%ImageBuild%" leq "17134" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\etwproviders\*.*" "%DVD%\sources\etwproviders\%LanguagePackCode%" >nul
		if "%ImageBuild%" equ "16299" if "%ImageArchitecture%" equ "x64" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-fabric-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-fabric-core\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-offlinefiles-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-shmig\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-shmig\%LanguagePackCode%" >nul
		if "%ImageBuild%" leq "17134" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
		echo.
	)

	echo.Copying Windows Setup language configuration file to the Boot Image...
	copy /y "%DVD%\sources\lang.ini" "%BootMount%\2\sources\lang.ini" >nul
	echo.
)

if "%LanguagePackType%" equ "Install" (
	for /l %%i in (1, 1, %ImageCount%) do (
		if exist "%InstallMount%\%%i" (
			if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
			if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
			echo.
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows Language Pack [%LanguagePackCode%]...
			echo.-------------------------------------------------------------------------------
			if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Client" call :AddPackage "%InstallMount%\%%i", "%LanguagePacks%\Microsoft-Windows-Client-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
			if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Embedded" call :AddPackage "%InstallMount%\%%i", "%LanguagePacks%\Microsoft-Windows-Embedded-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
			if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType:~,6%" equ "Server" call :AddPackage "%InstallMount%\%%i", "%LanguagePacks%\Microsoft-Windows-Server-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
			if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType%" equ "Client" call :AddPackage "%InstallMount%\%%i", "%LanguagePacks%\Microsoft-Windows-Client-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
			if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType:~,6%" equ "Server" call :AddPackage "%InstallMount%\%%i", "%LanguagePacks%\Microsoft-Windows-Server-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"

			if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
				if "%ImageInstallationType%" equ "Client" call :AddPackage "%InstallMount%\%%i", "%LanguagePacks%\Microsoft-Windows-Client-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
				if "%ImageInstallationType:~,6%" equ "Server" call :AddPackage "%InstallMount%\%%i", "%LanguagePacks%\Microsoft-Windows-Server-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"

				if exist "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-Basic-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows Language Features - Basic Pack [%LanguagePackCode%]...
					echo.-------------------------------------------------------------------------------
					if "%ImageBuild%" leq "17134" call :AddPackage "%InstallMount%\%%i", "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-Basic-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"

					if "%ImageBuild%" geq "17763" (
						call :CreateFolder "%Temp%\LanguagePacks"
						copy /y "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-Basic-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" "%Temp%\LanguagePacks\Microsoft-Windows-LanguageFeatures-Basic-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab" >nul
						call :AddPackage "%InstallMount%\%%i", "%Temp%\LanguagePacks\Microsoft-Windows-LanguageFeatures-Basic-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
					)
				)

				if exist "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-Handwriting-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows Language Features - Handwriting Pack [%LanguagePackCode%]...
					echo.-------------------------------------------------------------------------------
					if "%ImageBuild%" leq "17134" call :AddPackage "%InstallMount%\%%i", "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-Handwriting-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"

					if "%ImageBuild%" geq "17763" (
						call :CreateFolder "%Temp%\LanguagePacks"
						copy /y "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-Handwriting-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" "%Temp%\LanguagePacks\Microsoft-Windows-LanguageFeatures-Handwriting-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab" >nul
						call :AddPackage "%InstallMount%\%%i", "%Temp%\LanguagePacks\Microsoft-Windows-LanguageFeatures-Handwriting-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
					)
				)

				if exist "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-OCR-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows Language Features - OCR Pack [%LanguagePackCode%]...
					echo.-------------------------------------------------------------------------------
					if "%ImageBuild%" leq "17134" call :AddPackage "%InstallMount%\%%i", "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-OCR-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"

					if "%ImageBuild%" geq "17763" (
						call :CreateFolder "%Temp%\LanguagePacks"
						copy /y "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-OCR-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" "%Temp%\LanguagePacks\Microsoft-Windows-LanguageFeatures-OCR-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab" >nul
						call :AddPackage "%InstallMount%\%%i", "%Temp%\LanguagePacks\Microsoft-Windows-LanguageFeatures-OCR-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
					)
				)

				if exist "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-TextToSpeech-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows Language Features - Text To Speech Pack [%LanguagePackCode%]...
					echo.-------------------------------------------------------------------------------
					if "%ImageBuild%" leq "17134" call :AddPackage "%InstallMount%\%%i", "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-TextToSpeech-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"

					if "%ImageBuild%" geq "17763" (
						call :CreateFolder "%Temp%\LanguagePacks"
						copy /y "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-TextToSpeech-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" "%Temp%\LanguagePacks\Microsoft-Windows-LanguageFeatures-TextToSpeech-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab" >nul
						call :AddPackage "%InstallMount%\%%i", "%Temp%\LanguagePacks\Microsoft-Windows-LanguageFeatures-TextToSpeech-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
					)
				)

				if exist "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-Speech-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows Language Features - Speech Pack [%LanguagePackCode%]...
					echo.-------------------------------------------------------------------------------
					if "%ImageBuild%" leq "17134" call :AddPackage "%InstallMount%\%%i", "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-Speech-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"

					if "%ImageBuild%" geq "17763" (
						call :CreateFolder "%Temp%\LanguagePacks"
						copy /y "%LanguagePacks%\Microsoft-Windows-LanguageFeatures-Speech-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" "%Temp%\LanguagePacks\Microsoft-Windows-LanguageFeatures-Speech-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab" >nul
						call :AddPackage "%InstallMount%\%%i", "%Temp%\LanguagePacks\Microsoft-Windows-LanguageFeatures-Speech-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
					)
				)
			)

			echo.-------------------------------------------------------------------------------
			echo.Updating Windows Setup language configuration file [Lang.ini]...
			echo.-------------------------------------------------------------------------------
			%DISM% /Image:"%InstallMount%\%%i" /Gen-LangINI /Distribution:"%DVD%"
			echo.
			echo.-------------------------------------------------------------------------------
			echo.Generating Windows Language Packs Integration Log File...
			echo.-------------------------------------------------------------------------------
			echo.
			echo.Writing Windows Language Packs Integration Log...
			call :GetPackages "%InstallMount%\%%i", "LanguagePacks_Install-%%i.txt"
			echo.
		)
	)

	echo.-------------------------------------------------------------------------------
	echo.Integrating [%LanguagePackCode%] Localized Windows Setup resources to Source DVD...
	echo.-------------------------------------------------------------------------------
	echo.
	echo.Extracting Windows Language Pack [%LanguagePackCode%] to Temporary folder...
	call :RemoveFolder "%Temp%\LanguagePack"
	call :CreateFolder "%Temp%\LanguagePack"
	if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Client" expand "%LanguagePacks%\Microsoft-Windows-Client-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" -f:* "%Temp%\LanguagePack" >nul
	if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Embedded" expand "%LanguagePacks%\Microsoft-Windows-Embedded-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" -f:* "%Temp%\LanguagePack" >nul
	if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType:~,6%" equ "Server" expand "%LanguagePacks%\Microsoft-Windows-Server-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab" -f:* "%Temp%\LanguagePack" >nul
	if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType%" equ "Client" expand "%LanguagePacks%\Microsoft-Windows-Client-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" -f:* "%Temp%\LanguagePack" >nul
	if "%SelectedSourceOS%" equ "w81" if "%ImageInstallationType:~,6%" equ "Server" expand "%LanguagePacks%\Microsoft-Windows-Server-Refresh-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" -f:* "%Temp%\LanguagePack" >nul
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageInstallationType%" equ "Client" expand "%LanguagePacks%\Microsoft-Windows-Client-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" -f:* "%Temp%\LanguagePack" >nul
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageInstallationType:~,6%" equ "Server" expand "%LanguagePacks%\Microsoft-Windows-Server-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" -f:* "%Temp%\LanguagePack" >nul
	echo.
	echo.Copying Localized Windows Setup resources files to the Source DVD...
	call :CreateFolder "%DVD%\sources\%LanguagePackCode%"

	if "%SelectedSourceOS%" equ "w7" (
		if "%ImageArchitecture%" equ "x86" call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\etwproviders\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\*.*" "%DVD%\sources\%LanguagePackCode%" >nul
		if "%ImageArchitecture%" equ "x86" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-iasserver-migplugin\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\etwproviders\*.*" "%DVD%\sources\etwproviders\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-offlinefiles-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%" >nul

		if "%ImageInstallationType%" neq "Embedded" (
			call :CreateFolder "%DVD%\sources\sp1\%LanguagePackCode%"
			call :CreateFolder "%DVD%\sources\sp1\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%"
			call :CreateFolder "%DVD%\sources\sp1\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
			call :CreateFolder "%DVD%\sources\sp1\etwproviders\%LanguagePackCode%"
			call :CreateFolder "%DVD%\sources\sp1\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%"
			xcopy /y "%Temp%\LanguagePack\sp1\setup\sources\%LanguagePackCode%\*.*" "%DVD%\sources\sp1\%LanguagePackCode%" >nul
			if "%ImageArchitecture%" equ "x86" xcopy /y "%Temp%\LanguagePack\sp1\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-iasserver-migplugin\*.*" "%DVD%\sources\sp1\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\sp1\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\sp1\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\sp1\setup\sources\%LanguagePackCode%\etwproviders\*.*" "%DVD%\sources\sp1\etwproviders\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\sp1\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-offlinefiles-core\*.*" "%DVD%\sources\sp1\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%" >nul
			echo.Copying Localized Windows Setup license files to the Source DVD...
			call :CreateFolder "%DVD%\sources\license\%LanguagePackCode%"
			call :CreateFolder "%DVD%\sources\sp1\license\%LanguagePackCode%"
			xcopy /y "%Temp%\LanguagePack\sources\license\%LanguagePackCode%\*.*" "%DVD%\sources\license\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\sp1\sources\license\%LanguagePackCode%\*.*" "%DVD%\sources\sp1\license\%LanguagePackCode%" >nul
		)
	)

	if "%SelectedSourceOS%" equ "w81" (
		if "%ImageInstallationType:~,6%" neq "Server" call :CreateFolder "%DVD%\sources\cli\%LanguagePackCode%"
		if "%ImageArchitecture%" equ "x86" call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-sxs\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\etwproviders\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%"
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\*.*" "%DVD%\sources\%LanguagePackCode%" >nul
		if "%ImageInstallationType:~,6%" neq "Server" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\cli\*.*" "%DVD%\sources\cli\%LanguagePackCode%" >nul
		if "%ImageArchitecture%" equ "x86" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-iasserver-migplugin\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\etwproviders\*.*" "%DVD%\sources\etwproviders\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-offlinefiles-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
	)

	if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" leq "15063" (
		if "%ImageBuild%" leq "10586" if "%ImageInstallationType:~,6%" neq "Server" call :CreateFolder "%DVD%\sources\cli\%LanguagePackCode%"
		if "%ImageArchitecture%" equ "x86" call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-shmig-dl\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-sxs\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\etwproviders\%LanguagePackCode%"
		if "%ImageBuild%" neq "10240" if "%ImageBuild%" neq "10586" if "%ImageArchitecture%" equ "x64" call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-fabric-core\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-shmig\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%"
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\*.*" "%DVD%\sources\%LanguagePackCode%" >nul
		if "%ImageBuild%" leq "10586" if "%ImageInstallationType:~,6%" neq "Server" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\cli\*.*" "%DVD%\sources\cli\%LanguagePackCode%" >nul
		if "%ImageArchitecture%" equ "x86" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-iasserver-migplugin\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-shmig-dl\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-shmig-dl\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\etwproviders\*.*" "%DVD%\sources\etwproviders\%LanguagePackCode%" >nul
		if "%ImageBuild%" neq "10240" if "%ImageBuild%" neq "10586" if "%ImageArchitecture%" equ "x64" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-fabric-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-fabric-core\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-offlinefiles-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-shmig\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-shmig\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
		xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
	)

	if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "16299" if "%ImageBuild%" leq "20348" (
		if "%ImageArchitecture%" equ "x86" call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%"
		if "%ImageBuild%" leq "17134" call :CreateFolder "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\etwproviders\%LanguagePackCode%"
		if "%ImageBuild%" equ "16299" if "%ImageArchitecture%" equ "x64" call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-fabric-core\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-shmig\%LanguagePackCode%"
		if "%ImageBuild%" leq "17134" call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-storagemigration\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%"

		if "%LanguagePackCode%" neq "en-US" (
			xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\*.*" "%DVD%\sources\%LanguagePackCode%" >nul
			if "%ImageArchitecture%" equ "x86" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-iasserver-migplugin\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%" >nul
			if "%ImageBuild%" leq "17134" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\dlmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\etwproviders\*.*" "%DVD%\sources\etwproviders\%LanguagePackCode%" >nul
			if "%ImageBuild%" equ "16299" if "%ImageArchitecture%" equ "x64" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-fabric-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-fabric-core\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-offlinefiles-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-shmig\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-shmig\%LanguagePackCode%" >nul
			if "%ImageBuild%" leq "17134" xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
		)

		if "%LanguagePackCode%" equ "en-US" (
			xcopy /y "%Temp%\LanguagePack\setup\sources\*.*" "%DVD%\sources\%LanguagePackCode%" >nul
			if "%ImageArchitecture%" equ "x86" xcopy /y "%Temp%\LanguagePack\setup\sources\dlmanifests\microsoft-windows-iasserver-migplugin\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-iasserver-migplugin\%LanguagePackCode%" >nul
			if "%ImageBuild%" leq "17134" xcopy /y "%Temp%\LanguagePack\setup\sources\dlmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\dlmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\etwproviders\*.*" "%DVD%\sources\etwproviders\%LanguagePackCode%" >nul
			if "%ImageBuild%" equ "16299" if "%ImageArchitecture%" equ "x64" xcopy /y "%Temp%\LanguagePack\setup\sources\replacementmanifests\microsoft-windows-fabric-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-fabric-core\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\replacementmanifests\microsoft-windows-offlinefiles-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\replacementmanifests\microsoft-windows-shmig\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-shmig\%LanguagePackCode%" >nul
			if "%ImageBuild%" leq "17134" xcopy /y "%Temp%\LanguagePack\setup\sources\replacementmanifests\microsoft-windows-storagemigration\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-storagemigration\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\replacementmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
		)
	)

	if "%SelectedSourceOS%" equ "w11" (
		call :CreateFolder "%DVD%\sources\etwproviders\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-shmig\%LanguagePackCode%"
		call :CreateFolder "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%"

		if "%LanguagePackCode%" neq "en-US" (
			xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\*.*" "%DVD%\sources\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\etwproviders\*.*" "%DVD%\sources\etwproviders\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-offlinefiles-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-shmig\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-shmig\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\%LanguagePackCode%\replacementmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
		)

		if "%LanguagePackCode%" equ "en-US" (
			xcopy /y "%Temp%\LanguagePack\setup\sources\*.*" "%DVD%\sources\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\etwproviders\*.*" "%DVD%\sources\etwproviders\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\replacementmanifests\microsoft-windows-offlinefiles-core\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-offlinefiles-core\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\replacementmanifests\microsoft-windows-shmig\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-shmig\%LanguagePackCode%" >nul
			xcopy /y "%Temp%\LanguagePack\setup\sources\replacementmanifests\microsoft-windows-sxs\*.*" "%DVD%\sources\replacementmanifests\microsoft-windows-sxs\%LanguagePackCode%" >nul
		)
	)
	echo.
)

if "%LanguagePackType%" equ "Recovery" if "%IsRecoveryImageSelected%" equ "Yes" (
	echo.-------------------------------------------------------------------------------
	echo.Integrating WinPE Language Pack [%LanguagePackCode%] to Windows Recovery Image...
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" call :AddPackage "%WinReMount%", "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
	if "%SelectedSourceOS%" equ "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
	
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
    	call :AddPackage "%WinReMount%", "%LanguagePacks%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		
    	if "%ImageBuild%" geq "17134" (
			if exist "%LanguagePacks%\Microsoft-Windows-WinPE-AppxPackaging-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
    			echo.-------------------------------------------------------------------------------
				echo.Integrating WinPE - Appx Packaging [%LanguagePackCode%] to Windows Recovery Image...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%WinReMount%", "%LanguagePacks%\Microsoft-Windows-WinPE-AppxPackaging-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
            )
		
			if exist "%LanguagePacks%\Microsoft-Windows-WinPE-OpcServices-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating WinPE - Opc Services [%LanguagePackCode%] to Windows Recovery Image...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%WinReMount%", "%LanguagePacks%\Microsoft-Windows-WinPE-OpcServices-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
			)
		
			if "%ImageBuild%" geq "22621" if exist "%LanguagePacks%\WinPE-AppxDeployment-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating WinPE - Appx Deployment [%LanguagePackCode%] to Windows Recovery Image...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-AppxDeployment-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
			)

			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - Appx Packaging [%LanguagePackCode%] to Windows Recovery Image...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-AppxPackaging-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		)

		if "%ImageBuild%" geq "15063" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - AT Broker [%LanguagePackCode%] to Windows Recovery Image...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-ATBroker-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - Audio Core [%LanguagePackCode%] to Windows Recovery Image...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-AudioCore-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - Audio Drivers [%LanguagePackCode%] to Windows Recovery Image...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-AudioDrivers-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		)
	)
	
	if "%SelectedSourceOS%" neq "w7" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - Enhanced Storage Pack [%LanguagePackCode%] to Windows Recovery Image...
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-EnhancedStorage-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" neq "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-EnhancedStorage-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
	)

	for /d %%z in (ja-JP, ko-KR, zh-HK, zh-CN, zh-TW) do (
		if "%LanguagePackCode%" equ "%%z" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - Font Support Pack [%LanguagePackCode%] to Windows Recovery Image...
			echo.-------------------------------------------------------------------------------
			if "%SelectedSourceOS%" equ "w7" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-FontSupport-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
			if "%SelectedSourceOS%" equ "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-FontSupport-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
			if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-FontSupport-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		)
	)

	if "%SelectedSourceOS%" equ "w81" if exist "%LanguagePacks%\WinPE-IbsProvider-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - IBS Provider Pack [%LanguagePackCode%] to Windows Recovery Image...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-IbsProvider-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
	)
	
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - HTA Pack [%LanguagePackCode%] to Windows Recovery Image...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-HTA-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		
		if "%ImageBuild%" geq "15063" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - Narrator [%LanguagePackCode%] to Windows Recovery Image...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-Narrator-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		)
	
		if "%ImageBuild%" geq "17134" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WinPE - Opc Services [%LanguagePackCode%] to Windows Recovery Image...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-OpcServices-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		)
	)
	
	if "%SelectedSourceOS%" neq "w7" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - Rejuv Pack [%LanguagePackCode%] to Windows Recovery Image...
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-Rejuv-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" neq "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-Rejuv-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
	)
	
	echo.-------------------------------------------------------------------------------
	echo.Integrating WinPE - Scripting Pack [%LanguagePackCode%] to Windows Recovery Image...
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
	if "%SelectedSourceOS%" equ "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-Scripting-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"

	if "%SelectedSourceOS%" equ "w7" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - Setup Pack [%LanguagePackCode%] to Windows Recovery Image...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-Setup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - Setup Client Pack [%LanguagePackCode%] to Windows Recovery Image...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-Setup-Client-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
	)

	if "%SelectedSourceOS%" neq "w7" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - Secure Startup Pack [%LanguagePackCode%] to Windows Recovery Image...
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-SecureStartup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" neq "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-SecureStartup-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
	)

	
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" if "%ImageBuild%" leq "22000" (
		for /d %%z in (de-DE, en-GB, es-ES, es-MX, fr-CA, fr-FR, it-IT, ja-JP, ko-KR, pl-PL, pt-BR, pt-PT, ru-RU, zh-CN, zh-HK, zh-TW) do (
			if "%LanguagePackCode%" equ "%%z" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating WinPE - Speech TextToSpeech [%LanguagePackCode%] to Windows Recovery Image...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-Speech-TTS-%LanguagePackCode%-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
			)
		)
	)
	
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "15063" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - Speech TextToSpeech [%LanguagePackCode%] to Windows Recovery Image...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-Speech-TTS-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - SRH [%LanguagePackCode%] to Windows Recovery Image...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-SRH-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
	)
	
	echo.-------------------------------------------------------------------------------
	echo.Integrating WinPE - SRT Pack [%LanguagePackCode%] to Windows Recovery Image...
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
	if "%SelectedSourceOS%" equ "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-SRT-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
	
	if "%SelectedSourceOS%" neq "w7" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - Storage WMI Pack [%LanguagePackCode%] to Windows Recovery Image...
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-StorageWMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
		if "%SelectedSourceOS%" neq "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-StorageWMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
	)
	
	echo.-------------------------------------------------------------------------------
	echo.Integrating WinPE - WDS Pack [%LanguagePackCode%] to Windows Recovery Image...
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
	if "%SelectedSourceOS%" equ "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-WDS-Tools-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"

	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if exist "%LanguagePacks%\WinPE-WiFi-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - WiFi Pack [%LanguagePackCode%] to Windows Recovery Image...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-WiFi-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
	)

	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "22621" if exist "%LanguagePacks%\WinPE-WindowsUpdate-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WinPE - Windows Update Pack [%LanguagePackCode%] to Windows Recovery Image...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-WindowsUpdate-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"
	)

	echo.-------------------------------------------------------------------------------
	echo.Integrating WinPE - WMI Pack [%LanguagePackCode%] to Windows Recovery Image...
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.1.7601.%PackageServicePackBuild%.cab"
	if "%SelectedSourceOS%" equ "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~6.3.9600.%PackageServicePackBuild%.cab"
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :AddPackage "%WinReMount%", "%LanguagePacks%\WinPE-WMI-Package~31bf3856ad364e35~%PackageArchitecture%~%LanguagePackCode%~%PackageVersion%.%PackageServicePackBuild%.cab"

	echo.-------------------------------------------------------------------------------
	echo.Generating Windows Recovery Language Packs Integration Log File...
	echo.-------------------------------------------------------------------------------
	echo.
	echo.Writing Windows Recovery Language Packs Integration Log...
	echo.
	call :GetPackages "%WinReMount%", "LanguagePacks_Install_WinRE.txt"
)

echo.-------------------------------------------------------------------------------
echo.####Cleaning Up Temporary Files ^& Folders######################################
echo.-------------------------------------------------------------------------------
echo.
echo.Cleaning Up Temporary folder...
call :RemoveFolder "%Temp%\LanguagePacks"
echo.
echo.-------------------------------------------------------------------------------
if "%LanguagePackType%" equ "Boot" echo.####Finished Integrating Windows Language Packs to Windows Boot Image##########
if "%LanguagePackType%" equ "Install" echo.####Finished Integrating Windows Language Packs to Windows Installation Image##
if "%LanguagePackType%" equ "Recovery" echo.####Finished Integrating Windows Language Packs to Windows Recovery Image######
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set LanguagePacks=
set LanguagePackType=
set LanguagePackCode=

endlocal

:: Returning to Integrate Language Packs Menu
goto :IntLanguagePacksMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Drivers Menu
::-------------------------------------------------------------------------------------------
:IntDriversMenu

setlocal

set DriverType=

cls
echo.===============================================================================
echo.                MSMG ToolKit - Integrate Windows Drivers Menu
echo.===============================================================================
echo.
echo.  [1]   Integrate to Windows Setup Boot Image
echo.
echo.  [2]   Integrate to Windows Installation Image
echo.
echo.  [3]   Integrate to Windows Recovery Image
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.
choice /C:123X /N /M "Enter Your Choice : "
if errorlevel 4 goto :IntegrateMenu
if errorlevel 3 set DriverType=Recovery
if errorlevel 2 set DriverType=Install
if errorlevel 1 set DriverType=Boot

cls
echo.===============================================================================
if "%DriverType%" equ "Boot" echo.     MSMG ToolKit - Integrate Windows Drivers to Windows Setup Boot Image
if "%DriverType%" equ "Install" echo.    MSMG ToolKit - Integrate Windows Drivers to Windows Installation Image
if "%DriverType%" equ "Recovery" echo.      MSMG ToolKit - Integrate Windows Drivers to Windows Recovery Image
echo.===============================================================================
echo.

if "%DriverType%" equ "Boot" if "%IsBootImageSelected%" equ "No" (
	echo.Windows Setup Boot Image is not selected...
	echo.
	echo.Please choose Windows Setup Boot Image while selecting Source...
	goto :Stop
)

if "%DriverType%" equ "Recovery" if "%IsRecoveryImageSelected%" equ "No" (
	echo.Windows Recovery Image is not selected...
	echo.
	echo.Please choose Windows Recovery Image while selecting Source...
	goto :Stop
)

:: Getting Source Image Index Architecture
if "%DriverType%" equ "Boot" (
		call :GetImageArchitecture "%BootWim%", 1 >nul
) else (
	call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul
)

:: Settings Windows Drivers folder path
if "%DriverType%" equ "Boot" set "Drivers=%Drivers%\WinPE\%SelectedSourceOS%\%ImageArchitecture%"
if "%DriverType%" equ "Install" set "Drivers=%Drivers%\Install\%SelectedSourceOS%\%ImageArchitecture%"
if "%DriverType%" equ "Recovery" set "Drivers=%Drivers%\WinPE\%SelectedSourceOS%\%ImageArchitecture%"

:: Checking whether Windows Drivers folder is empty
for /f %%i in ('dir /b /s /a:-d "%Drivers%\*.*" 2^>nul ^| find /v /c ""') do (
	if "%%i" equ "0" (
		if "%DriverType%" equ "Boot" echo.Windows Drivers folder ^<Drivers\WinPE\%SelectedSourceOS%\%ImageArchitecture%^> is empty...
		if "%DriverType%" equ "Install" echo.Windows Drivers folder ^<Drivers\Install\%SelectedSourceOS%\%ImageArchitecture%^> is empty...
		if "%DriverType%" equ "Recovery" echo.Windows Drivers folder ^<Drivers\WinPE\%SelectedSourceOS%\%ImageArchitecture%^> is empty...
		echo.
		echo.Please copy Windows Drivers files to respective folder...
		goto :Stop
	)
)

echo.-------------------------------------------------------------------------------
if "%DriverType%" equ "Boot" echo.####Started Integrating Windows Drivers to Windows Boot Image##################
if "%DriverType%" equ "Install" echo.####Started Integrating Windows Drivers to Windows Installation Image##########
if "%DriverType%" equ "Recovery" echo.####Started Integrating Windows Drivers to Windows Recovery Image##############
echo.-------------------------------------------------------------------------------
echo.
if "%DriverType%" equ "Boot" (
	echo.    Image                    : Boot.wim
	echo.    Image Index              : 2
)
if "%DriverType%" equ "Install" (
	echo.    Image                    : Install.wim
	echo.    Image Index              : %ImageIndexNo%
)
if "%DriverType%" equ "Recovery" (
	echo.    Image                    : WinRE.wim
	echo.    Image Index              : 1
)
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
if "%DriverType%" equ "Boot" echo.####Integrating Windows Drivers to Windows Boot Image##########################
if "%DriverType%" equ "Install" echo.####Integrating Windows Drivers to Windows Installation Image##################
if "%DriverType%" equ "Recovery" echo.####Integrating Windows Drivers to Windows Recovery Image######################
echo.-------------------------------------------------------------------------------
echo.

if "%DriverType%" equ "Boot" (
	call :AddDriver "%BootMount%\2", "%Drivers%"
)

if "%DriverType%" equ "Install" (
	for /l %%i in (1, 1, %ImageCount%) do (
		if exist "%InstallMount%\%%i" (
			echo.
			if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
			if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
			call :AddDriver "%InstallMount%\%%i", "%Drivers%"
		)
	)
)

if "%DriverType%" equ "Recovery" (
	call :AddDriver "%WinReMount%", "%Drivers%"
)

echo.-------------------------------------------------------------------------------
if "%DriverType%" equ "Boot" echo.####Finished Integrating Windows Drivers to Windows Boot Image#################
if "%DriverType%" equ "Install" echo.####Finished Integrating Windows Drivers to Windows Installation Image#########
if "%DriverType%" equ "Recovery" echo.####Finished Integrating Windows Drivers to Windows Recovery Image#############
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set Drivers=
set DriverType=

endlocal

:: Returning to Integrate Drivers Menu
goto :IntDriversMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft .NET Framework 3.5
::-------------------------------------------------------------------------------------------
:IntNetFX35

setlocal

cls
echo.===============================================================================
echo.            MSMG ToolKit - Integrate Microsoft .NET Framework 3.5
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Microsoft .NET Framework 3.5 Feature Pack folder path according to Source Image Architecture
if "%SelectedSourceOS%" equ "w81" (
	if exist "%DVD%\sources\sxs" (
		set "NetFX35=%DVD%\sources\sxs"
	) else (
		set "NetFX35=%NetFX35%\%SelectedSourceOS%\%ImageArchitecture%"
	)
)

if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
	if exist "%DVD%\sources\sxs\*.cab" (
		if "%ImageBuild%" leq "16299" set "NetFX35=%DVD%\sources\sxs\microsoft-windows-netfx3-ondemand-package.cab"
		if "%ImageBuild%" geq "17134" set "NetFX35=%DVD%\sources\sxs\microsoft-windows-netfx3-ondemand-package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
	) else (
		set "NetFX35=%NetFX35%\%SelectedSourceOS%\%PackageVersion%\Microsoft-Windows-NetFx3-OnDemand-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
	)
)

:: Checking whether Microsoft .NET Framework 3.5 Feature Pack folder exist
if "%SelectedSourceOS%" equ "w81" if not exist "%NetFX35%\msil_system.net_b03f5f7f11d50a3a_6.3.9600.16384_none_78f2900af99c8442\system.net.dll" (
	echo.Microsoft .NET Framework 3.5 Pack folder is missing or empty...
	echo.
	echo.Please copy the files to ^<Packs\NetFX35\w81\%ImageArchitecture%^> folder...
	echo.
	goto :Stop
)

:: Checking whether Microsoft .NET Framework 3.5 Feature Pack folder exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist %NetFX35% (
	echo.Microsoft .NET Framework 3.5 Pack file is missing...
	echo.
	if "%ImageBuild%" leq "16299" echo.Either copy the "microsoft-windows-netfx3-ondemand-package.cab" file from Source DVD to ^<DVD\sources\sxs^> folder
	if "%ImageBuild%" geq "17134" echo.Either copy the "microsoft-windows-netfx3-ondemand-package~31bf3856ad364e35~%PackageArchitecture%~~.cab" from Source DVD to ^<DVD\sources\sxs^> folder
	echo.
	echo.or Copy the below ToolKit Pack file to ^<Packs\NetFX35\%SelectedSourceOS%\%PackageVersion%^> folder..
	echo.
	echo."Microsoft-Windows-NetFx3-OnDemand-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	goto :Stop
)

if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17763" if "%NetFX35%" neq "%DVD%\sources\sxs\microsoft-windows-netfx3-ondemand-package~31bf3856ad364e35~%PackageArchitecture%~~.cab" if exist %NetFX35% (
	copy /y %NetFX35% "%Temp%\microsoft-windows-netfx3-ondemand-package~31bf3856ad364e35~%PackageArchitecture%~~.cab" >nul
	set "NetFX35=%Temp%\microsoft-windows-netfx3-ondemand-package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft .NET Framework 3.5###########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft .NET Framework 3.5###################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.
		echo.-------------------------------------------------------------------------------
		echo.Checking whether Microsoft .NET Framework 3.5 is enabled...
		echo.-------------------------------------------------------------------------------
		echo.
		if "%SelectedSourceOS%" equ "w81" (
			%DISM% /Image:"%InstallMount%\%%i" /Get-FeatureInfo /FeatureName:NetFX3 | findstr /c:"State : Enable Pending" >nul
			if errorlevel 1 (
				echo.Microsoft .NET Framework 3.5 is not enabled.
				echo.
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 3.5 Package...
				echo.-------------------------------------------------------------------------------
				%DISM% /Image:"%InstallMount%\%%i" /Enable-Feature /All /LimitAccess /FeatureName:NetFX3 /Source:%NetFX35%
			) else (
				echo.Microsoft .NET Framework 3.5 has already been enabled.
			)
		)
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
			%DISM% /Image:"%InstallMount%\%%i" /Get-FeatureInfo /FeatureName:NetFx3 | findstr /c:"State : Enabled" >nul
			if errorlevel 1 (
				echo.Microsoft .NET Framework 3.5 is not enabled.
				echo.
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 3.5 Package...
				echo.-------------------------------------------------------------------------------
				%DISM% /Image:"%InstallMount%\%%i" /Add-Package /PackagePath:%NetFX35%
			) else (
				echo.Microsoft .NET Framework 3.5 has already been enabled.
			)
		)
	)
)

call :RemoveFile "%Temp%\microsoft-windows-netfx3-ondemand-package~31bf3856ad364e35~%PackageArchitecture%~~.cab"

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft .NET Framework 3.5##########################
echo.-------------------------------------------------------------------------------
echo.

:Stop
echo.===============================================================================
echo.
pause

set NetFX35=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft .NET Framework 4.6.2 for Windows 10 v1507 & v1511 Source OS
::-------------------------------------------------------------------------------------------
:IntNetFX462

setlocal

cls
echo.===============================================================================
echo.           MSMG ToolKit - Integrate Microsoft .NET Framework 4.6.2
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Microsoft .NET Framework 4.6.2 Pack file exist
if not exist "%NetFX462%\Microsoft-Windows-NetFX462-Package~31bf3856ad364e35~%PackageArchitecture%.cab" (
	echo.Microsoft .NET Framework 4.6.2 Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-NetFX462-Package~31bf3856ad364e35~%PackageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\NetFX462^> folder...
	goto :Stop
)

:: Checking whether Microsoft .NET Framework 4.6.2 Pack file exist
if "%ImageBuild%" equ "10240" if "%ImageEdition%" neq "Core" if "%ImageEdition%" neq "CoreN" if "%ImageEdition%" neq "CoreSingleLanguage" if "%ImageEdition%" neq "Education" if "%ImageEdition%" neq "EducationN" if "%ImageEdition%" neq "Professional" if "%ImageEdition%" neq "ProfessionalN" if "%ImageEdition%" neq "Enterprise" if "%ImageEdition%" neq "EnterpriseN" (
	if not exist "%NetFX462%\Windows10.0-KB4051600-%ImageArchitecture%.cab" (
		echo.Microsoft .NET Framework 4.6.2 Pack folder is missing the below file...
		echo.
		echo."Windows10.0-KB4051600-%ImageArchitecture%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\NetFX462^> folder...
		goto :Stop
	)
)

:: Checking whether Microsoft .NET Framework 4.6.2 Pack file exist
if "%ImageBuild%" equ "10586" if "%ImageEdition%" neq "Core" if "%ImageEdition%" neq "CoreN" if "%ImageEdition%" neq "CoreSingleLanguage" if "%ImageEdition%" neq "Professional" if "%ImageEdition%" neq "ProfessionalN" (
	if not exist "%NetFX462%\Windows10.0-KB4054057-%ImageArchitecture%.cab" (
		echo.Microsoft .NET Framework 4.6.2 Pack folder is missing the below file...
		echo.
		echo."Windows10.0-KB4054057-%ImageArchitecture%.cab""
		echo.
		echo.Please copy the above file to ^<Packs\NetFX462^> folder...
		goto :Stop
	)
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft .NET Framework 4.6.2#########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft .NET Framework 4.6.2#################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.
		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft .NET Framework 4.6.2 Base Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%NetFX462%\Microsoft-Windows-NetFX462-Package~31bf3856ad364e35~%PackageArchitecture%.cab"

		if exist "%NetFX462%\Microsoft-Windows-NetFX462-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%.cab" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft .NET Framework 4.6.2 [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%NetFX462%\Microsoft-Windows-NetFX462-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%.cab"
		)

		if "%ImageBuild%" equ "10240" if "%ImageEdition%" neq "Core" if "%ImageEdition%" neq "CoreN" if "%ImageEdition%" neq "CoreSingleLanguage" if "%ImageEdition%" neq "Education" if "%ImageEdition%" neq "EducationN" if "%ImageEdition%" neq "Professional" if "%ImageEdition%" neq "ProfessionalN" if "%ImageEdition%" neq "Enterprise" if "%ImageEdition%" neq "EnterpriseN" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft .NET Framework 4.6.2 Update Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%NetFX462%\Windows10.0-KB4051600-%ImageArchitecture%.cab"
		)

		if "%ImageBuild%" equ "10586" if "%ImageEdition%" neq "Core" if "%ImageEdition%" neq "CoreN" if "%ImageEdition%" neq "CoreSingleLanguage" if "%ImageEdition%" neq "Professional" if "%ImageEdition%" neq "ProfessionalN" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft .NET Framework 4.6.2 Update Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%NetFX462%\Windows10.0-KB4054057-%ImageArchitecture%.cab"
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft .NET Framework 4.6.2########################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set NetFX462=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft .NET Framework 4.8
::-------------------------------------------------------------------------------------------
:IntNetFX48

setlocal

set NetFX48Pkg=
set NetFX48LpPkg=

cls
echo.===============================================================================
echo.          MSMG ToolKit - Integrate Microsoft .NET Framework 4.8
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Microsoft .NET Framework 4.8 Pack folder path
set "NetFX48=%NetFX48%\%SelectedSourceOS%"

:: Setting Image Package ServicePackBuildLevel
if "%SelectedSourceOS%" equ "w10" (
	if "%ImageBuild%" geq "14393" if "%ImageBuild%" leq "15063" (
		set "NetFX48Pkg=Microsoft-Windows-NetFX48-Package~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0.cab"
		set "NetFX48LpPkg=Microsoft-Windows-NetFX48-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~10.0.14393.0.cab"
	)

	if "%ImageBuild%" geq "16299" if "%ImageBuild%" leq "17763" (
		set "NetFX48Pkg=Microsoft-Windows-NetFX48-Package~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15.cab"
		set "NetFX48LpPkg=Microsoft-Windows-NetFX48-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~10.0.16299.15.cab"
	)
)

:: Checking whether Microsoft .NET Framework 4.8 Pack file exist
if "%SelectedSourceOS%" equ "w7" if not exist "%NetFX48%\Windows6.1-KB4019990-%ImageArchitecture%.cab" (
	echo.Microsoft .NET Framework 4.8 Pack folder is missing the below file...
	echo.
	echo."Windows6.1-KB4019990-%ImageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\NetFX48\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Microsoft .NET Framework 4.8 Pack file exist
if "%SelectedSourceOS%" equ "w7" if not exist "%NetFX48%\NetFX48.tpk" (
	echo.Microsoft .NET Framework 4.8 Pack folder is missing the below file...
	echo.
	echo."NetFX48.tpk"
	echo.
	echo.Please copy the above file to ^<Packs\NetFX48\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Microsoft .NET Framework 4.8 Pack file exist
if "%SelectedSourceOS%" equ "w7" if not exist "%NetFX48%\NetFX48_%ImageArchitecture%.reg" (
	echo.Microsoft .NET Framework 4.8 Pack folder is missing the below file...
	echo.
	echo."NetFX48_%ImageArchitecture%.reg"
	echo.
	echo.Please copy the above file to ^<Packs\NetFX48\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Microsoft .NET Framework 4.8 Pack file exist
if "%SelectedSourceOS%" equ "w81" if not exist "%NetFX48%\Microsoft-Windows-NetFx48-Package~31bf3856ad364e35~%PackageArchitecture%~~6.3.9600.16384.cab" (
	echo.Microsoft .NET Framework 4.8 Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-NetFx48-Package~31bf3856ad364e35~%PackageArchitecture%~~6.3.9600.16384.cab"
	echo.
	echo.Please copy the above file to ^<Packs\NetFX48\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Microsoft .NET Framework 4.8 Pack file exist
if "%SelectedSourceOS%" equ "w10" if not exist "%NetFX48%\%NetFX48Pkg%" (
	echo.Microsoft .NET Framework 4.8 Pack folder is missing the below file...
	echo.
	echo."%NetFX48Pkg%"
	echo.
	echo.Please copy the above file to ^<Packs\NetFX48\%SelectedSourceOS%^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft .NET Framework 4.8###########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft .NET Framework 4.8###################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		if "%SelectedSourceOS%" equ "w7" (
			echo.
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft .NET Framework 4.8 Prerequisite Update Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%NetFX48%\Windows6.1-KB4019990-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft .NET Framework 4.8 Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%NetFX48%\NetFX48.tpk", %PackageIndex%, "%InstallMount%\%%i"

			if exist "%NetFX48%\NetFX48_%ImageDefaultLanguage%.tpk" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 4.8 [%ImageDefaultLanguage%] Language Package...
				echo.-------------------------------------------------------------------------------
				call :ApplyImage "%NetFX48%\NetFX48_%ImageDefaultLanguage%.tpk", %PackageIndex%, "%InstallMount%\%%i"
			)

			echo.-------------------------------------------------------------------------------
			echo.Importing Microsoft .NET Framework 4.8 Registry Settings...
			echo.-------------------------------------------------------------------------------
			echo.
			echo.Mounting Image Registry...
			call :MountImageRegistry "%InstallMount%\%%i"
			echo.Importing Registry Settings to Image Registry...
			call :ImportRegistry2Image "%NetFX48%\NetFX48_%ImageArchitecture%.reg"

			if exist "%NetFX48%\NetFX48_%ImageArchitecture%_%ImageDefaultLanguage%.reg" call :ImportRegistry2Image "%NetFX48%\NetFX48_%ImageArchitecture%_%ImageDefaultLanguage%.reg"

			echo.Un-Mounting Image Registry...
			call :UnMountImageRegistry
			echo.
		)

		if "%SelectedSourceOS%" equ "w81" (
			if not exist "%NetFX48%\Microsoft-Windows-NetFX48-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~6.3.9600.16384.cab" (
				call :AddPackage "%InstallMount%\%%i", "%NetFX48%\Microsoft-Windows-NetFX48-Package~31bf3856ad364e35~%PackageArchitecture%~~6.3.9600.16384.cab"
			)

			if exist "%NetFX48%\Microsoft-Windows-NetFX48-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~6.3.9600.16384.cab" (
				echo.
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 4.8 Base Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%NetFX48%\Microsoft-Windows-NetFX48-Package~31bf3856ad364e35~%PackageArchitecture%~~6.3.9600.16384.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 4.8 [%ImageDefaultLanguage%] Language Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%NetFX48%\Microsoft-Windows-NetFX48-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~6.3.9600.16384.cab"
			)
		)

		if "%SelectedSourceOS%" equ "w10" (
			if not exist "%NetFX48%\%NetFX48LpPkg%" call :AddPackage "%InstallMount%\%%i", "%NetFX48%\%NetFX48Pkg%"

			if exist "%NetFX48%\%NetFX48LpPkg%" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 4.8 Base Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%NetFX48%\%NetFX48Pkg%"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 4.8 [%ImageDefaultLanguage%] Language Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%NetFX48%\%NetFX48LpPkg%"
			)
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft .NET Framework 4.8##########################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set NetFX48=
set NetFX48Pkg=
set NetFX48LpPkg=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft .NET Framework 4.8.1
::-------------------------------------------------------------------------------------------
:IntNetFX481

setlocal

cls
echo.===============================================================================
echo.         MSMG ToolKit - Integrate Microsoft .NET Framework 4.8.1
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Microsoft .NET Framework 4.8.1 Pack file exist
if not exist "%NetFX481%\Microsoft-Windows-NetFX481-Package~31bf3856ad364e35~%PackageArchitecture%.cab" (
	echo.Microsoft .NET Framework 4.8.1 Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-NetFX481-Package~31bf3856ad364e35~%PackageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\NetFX481^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft .NET Framework 4.8.1#########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft .NET Framework 4.8.1#################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft .NET Framework 4.8.1 Base Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%NetFX481%\Microsoft-Windows-NetFX481-Package~31bf3856ad364e35~%PackageArchitecture%.cab"

		if exist "%NetFX481%\Microsoft-Windows-NetFX481-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%.cab" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft .NET Framework 4.8.1 [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%NetFX481%\Microsoft-Windows-NetFX481-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%.cab"
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft .NET Framework 4.8.1########################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft .NET Core Desktop Runtime 3.1
::-------------------------------------------------------------------------------------------
:IntNETCore31

setlocal

cls
echo.===============================================================================
echo.      MSMG ToolKit - Integrate Microsoft .NET Core Desktop Runtime 3.1
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Microsoft .NET Core Desktop Runtime 3.1 Pack file exist
if not exist "%NETCore31%\NETCore31_%SelectedSourceOS%.tpk" (
	echo.Microsoft .NET Core Desktop Runtime 3.1 Pack folder is missing the below file...
	echo.
	echo."NETCore31_%SelectedSourceOS%.tpk"
	echo.
	echo.Please copy the above file to ^<Packs\NETCore31^> folder...
	goto :Stop
)

if not exist "%NETCore31%\NETCore31_%SelectedSourceOS%_%ImageArchitecture%.reg" (
	echo.Microsoft .NET Core Desktop Runtime 3.1 Pack folder is missing the below file...
	echo.
	echo."NETCore31_%SelectedSourceOS%_%ImageArchitecture%.reg"
	echo.
	echo.Please copy the above file to ^<Packs\NETCore31^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft .NET Core Desktop Runtime 3.1################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft .NET Core Desktop Runtime 3.1########################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft .NET Core Desktop Runtime 3.1 Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%NETCore31%\NETCore31_%SelectedSourceOS%.tpk", %PackageIndex%, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------
		echo.Importing Microsoft .NET Core Desktop Runtime 3.1 Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Importing Registry Settings to Image Registry...
		call :ImportRegistry2Image "%NETCore31%\NETCore31_%SelectedSourceOS%_%ImageArchitecture%.reg"

		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
		echo.
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft .NET Core Desktop Runtime 3.1###############
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft .NET Desktop Runtime 6
::-------------------------------------------------------------------------------------------
:IntNET6

setlocal

cls
echo.===============================================================================
echo.         MSMG ToolKit - Integrate Microsoft .NET Desktop Runtime 6
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Microsoft .NET Desktop Runtime 6 Pack file exist
if not exist "%NET6%\NET6_%SelectedSourceOS%.tpk" (
	echo.Microsoft .NET Desktop Runtime 6 Pack folder is missing the below file...
	echo.
	echo."NET6_%SelectedSourceOS%.tpk"
	echo.
	echo.Please copy the above file to ^<Packs\NET6^> folder...
	goto :Stop
)

if not exist "%NET6%\NET6_%SelectedSourceOS%_%ImageArchitecture%.reg" (
	echo.Microsoft .NET Desktop Runtime 6 Pack folder is missing the below file...
	echo.
	echo."NET6_%SelectedSourceOS%_%ImageArchitecture%.reg"
	echo.
	echo.Please copy the above file to ^<Packs\NET6^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft .NET Desktop Runtime 6#######################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft .NET Desktop Runtime 6###############################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft .NET Desktop Runtime 6 Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%NET6%\NET6_%SelectedSourceOS%.tpk", %PackageIndex%, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------
		echo.Importing Microsoft .NET Desktop Runtime 6 Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Importing Registry Settings to Image Registry...
		call :ImportRegistry2Image "%NET6%\NET6_%SelectedSourceOS%_%ImageArchitecture%.reg"

		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
		echo.
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft .NET Desktop Runtime 6######################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft .NET Desktop Runtime 7
::-------------------------------------------------------------------------------------------
:IntNET7

setlocal

cls
echo.===============================================================================
echo.         MSMG ToolKit - Integrate Microsoft .NET Desktop Runtime 7
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Microsoft .NET Desktop Runtime 7 Pack file exist
if not exist "%NET7%\NET7_%SelectedSourceOS%.tpk" (
	echo.Microsoft .NET Desktop Runtime 7 Pack folder is missing the below file...
	echo.
	echo."NET7_%SelectedSourceOS%.tpk"
	echo.
	echo.Please copy the above file to ^<Packs\NET7^> folder...
	goto :Stop
)

if not exist "%NET7%\NET7_%SelectedSourceOS%_%ImageArchitecture%.reg" (
	echo.Microsoft .NET Desktop Runtime 7 Pack folder is missing the below file...
	echo.
	echo."NET7_%SelectedSourceOS%_%ImageArchitecture%.reg"
	echo.
	echo.Please copy the above file to ^<Packs\NET7^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft .NET Desktop Runtime 7#######################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft .NET Desktop Runtime 7###############################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft .NET Desktop Runtime 7 Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%NET7%\NET7_%SelectedSourceOS%.tpk", %PackageIndex%, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------
		echo.Importing Microsoft .NET Desktop Runtime 7 Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Importing Registry Settings to Image Registry...
		call :ImportRegistry2Image "%NET7%\NET7_%SelectedSourceOS%_%ImageArchitecture%.reg"

		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
		echo.
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft .NET Desktop Runtime 7######################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft Internet Explorer 11
::-------------------------------------------------------------------------------------------
:IntIE11

setlocal

cls
echo.===============================================================================
echo.             MSMG ToolKit - Integrate Microsoft Internet Explorer 11
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Microsoft Internet Explorer 11 Pack file exist
if not exist "%IE11%\Microsoft-Windows-PlatformUpdate-Win7-SRV08R2-Package~31bf3856ad364e35~%PackageArchitecture%.cab" (
	echo.Microsoft Internet Explorer 11 Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-PlatformUpdate-Win7-SRV08R2-Package~31bf3856ad364e35~%PackageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\IE11^> folder...
	goto :Stop
)

:: Checking whether Microsoft Internet Explorer 11 Pack file exist
if not exist "%IE11%\Microsoft-Windows-InternetExplorer-Package~31bf3856ad364e35~%PackageArchitecture%.cab" (
	echo.Microsoft Internet Explorer 11 Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-InternetExplorer-Package~31bf3856ad364e35~%PackageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\IE11^> folder...
	goto :Stop
)

:: Checking whether Microsoft Internet Explorer 11 Pack file exist
if "%ImageDefaultLanguage%" equ "en-US" if not exist "%IE11%\Microsoft-Windows-IE-Hyphenation-Package~31bf3856ad364e35~en-US.cab" (
	echo.Microsoft Internet Explorer 11 Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-IE-Hyphenation-Package~31bf3856ad364e35~en-US.cab"
	echo.
	echo.Please copy the above file to ^<Packs\IE11^> folder...
	goto :Stop
)

:: Checking whether Microsoft Internet Explorer 11 Pack file exist
if "%ImageDefaultLanguage%" equ "en-US" if not exist "%IE11%\Microsoft-Windows-IE-Spelling-Package~31bf3856ad364e35~en-US.cab" (
	echo.Microsoft Internet Explorer 11 Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-IE-Spelling-Package~31bf3856ad364e35~en-US.cab"
	echo.
	echo.Please copy the above file to ^<Packs\IE11^> folder...
	goto :Stop
)

:: Checking whether Microsoft Internet Explorer 11 Pack file exist
if "%ImageDefaultLanguage%" neq "en-US" if not exist "%IE11%\Microsoft-Windows-InternetExplorer-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%.cab" (
	echo.Microsoft Internet Explorer 11 Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-InternetExplorer-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\IE11^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft Internet Explorer 11#########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft Internet Explorer 11#################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft Internet Explorer 11 Prerequisite Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%IE11%\Microsoft-Windows-PlatformUpdate-Win7-SRV08R2-Package~31bf3856ad364e35~%PackageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft Internet Explorer 11 Base Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%IE11%\Microsoft-Windows-InternetExplorer-Package~31bf3856ad364e35~%PackageArchitecture%.cab"

		if "%ImageDefaultLanguage%" equ "en-US" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Internet Explorer 11 Hyphenation Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%IE11%\Microsoft-Windows-IE-Hyphenation-Package~31bf3856ad364e35~en-US.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Internet Explorer 11 Spelling Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%IE11%\Microsoft-Windows-IE-Spelling-Package~31bf3856ad364e35~en-US.cab"
		) else (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Internet Explorer 11 [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%IE11%\Microsoft-Windows-InternetExplorer-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%.cab"

			if exist "%IE11%\Microsoft-Windows-IE-Hyphenation-Package~31bf3856ad364e35~%ImageDefaultLanguage%.cab" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft Internet Explorer 11 Hyphenation Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%IE11%\Microsoft-Windows-IE-Hyphenation-Package~31bf3856ad364e35~%ImageDefaultLanguage%.cab"
			) else (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft Internet Explorer 11 Hyphenation Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%IE11%\Microsoft-Windows-IE-Hyphenation-Package~31bf3856ad364e35~en-US.cab"
			)

			if exist "%IE11%\Microsoft-Windows-IE-Spelling-Package~31bf3856ad364e35~%ImageDefaultLanguage%.cab" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft Internet Explorer 11 Spelling Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%IE11%\Microsoft-Windows-IE-Spelling-Package~31bf3856ad364e35~%ImageDefaultLanguage%.cab"
			) else (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft Internet Explorer 11 Spelling Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%IE11%\Microsoft-Windows-IE-Spelling-Package~31bf3856ad364e35~en-US.cab"
			)
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Internet Explorer 11##################################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set IE11=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Remote Desktop Protocol (RDP) 8.0 & 8.1
::-------------------------------------------------------------------------------------------
:IntRDP81

setlocal

cls
echo.===============================================================================
echo.       MSMG ToolKit - Integrate Remote Desktop Protocol ^(RDP^) 8.0 ^& 8.1
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Remote Desktop Protocol (RDP) 8.0 & 8.1 Pack file exist
if not exist "%RDP81%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%.cab" (
	echo.Remote Desktop Protocol ^(RDP^) 8.0 ^& 8.1 Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\RDP81^> folder...
	goto :Stop
)

:: Checking whether Remote Desktop Protocol (RDP) 8.0 & 8.1 Pack file exist
if not exist "%RDP81%\Microsoft-Windows-RDP-WinIP-Package~31bf3856ad364e35~%PackageArchitecture%.cab" (
	echo.Remote Desktop Protocol ^(RDP^) 8.0 ^& 8.1 Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-RDP-WinIP-Package~31bf3856ad364e35~%PackageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\RDP81^> folder...
	goto :Stop
)

:: Checking whether Remote Desktop Protocol (RDP) 8.0 & 8.1 Pack file exist
if not exist "%RDP81%\Microsoft-Windows-RDP-BlueIP-Package~31bf3856ad364e35~%PackageArchitecture%.cab" (
	echo.Remote Desktop Protocol ^(RDP^) 8.0 ^& 8.1 Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-RDP-BlueIP-Package~31bf3856ad364e35~%PackageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\RDP81^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Remote Desktop Protocol ^(RDP^) 8.0 ^& 8.1################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Remote Desktop Protocol ^(RDP^) 8.0 ^& 8.1########################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Remote Desktop Protocol ^(RDP^) 8.0 ^& 8.1 Prerequisite Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%RDP81%\Microsoft-Windows-WinPE-LanguagePack-Package~31bf3856ad364e35~%PackageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating Remote Desktop Protocol ^(RDP^) 8.0 ^& 8.1 Prerequisite Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%RDP81%\Microsoft-Windows-RDP-WinIP-Package~31bf3856ad364e35~%PackageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating Remote Desktop Protocol ^(RDP^) 8.0 ^& 8.1 Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%RDP81%\Microsoft-Windows-RDP-BlueIP-Package~31bf3856ad364e35~%PackageArchitecture%.cab"
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Remote Desktop Protocol ^(RDP^) 8.0 ^& 8.1###############
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set RDP81=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Management Framework (WMF) 5.1
::-------------------------------------------------------------------------------------------
:IntWMF

setlocal

cls
echo.===============================================================================
echo.       MSMG ToolKit - Integrate Windows Management Framework ^(WMF^) 5.1
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Windows Management Framework (WMF) 5.1 Pack folder path accroding to selected Source OS
set "WMF=%WMF%\%SelectedSourceOS%"

:: Checking whether Windows Management Framework (WMF) 5.1 Pack file exist
if "%SelectedSourceOS%" equ "w7" if "%ImageArchitecture%" equ "x64" if not exist "%WMF%\Windows6.1-KB2809215-%ImageArchitecture%.cab" (
	echo.Windows Management Framework 5 Pack folder is missing the below file...
	echo.
	echo."Windows6.1-KB2809215-%ImageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\WMF\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Management Framework (WMF) 5.1 Pack file exist
if "%SelectedSourceOS%" equ "w7" if not exist "%WMF%\Windows6.1-KB2872035-%ImageArchitecture%.cab" (
	echo.Windows Management Framework 5 Pack folder is missing the below file...
	echo.
	echo."Windows6.1-KB2872035-%ImageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\WMF\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Management Framework (WMF) 5.1 Pack file exist
if "%SelectedSourceOS%" equ "w7" if not exist "%WMF%\Windows6.1-KB2872047-%ImageArchitecture%.cab" (
	echo.Windows Management Framework 5 Pack folder is missing the below file...
	echo.
	echo."Windows6.1-KB2872047-%ImageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\WMF\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Management Framework (WMF) 5.1 Pack file exist
if "%SelectedSourceOS%" equ "w7" if not exist "%WMF%\Windows6.1-KB3033929-%ImageArchitecture%.cab" (
	echo.Windows Management Framework 5 Pack folder is missing the below file...
	echo.
	echo."Windows6.1-KB3033929-%ImageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\WMF\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Management Framework (WMF) 5.1 Pack file exist
if "%SelectedSourceOS%" equ "w7" if not exist "%WMF%\Windows6.1-KB3191566-%ImageArchitecture%.cab" (
	echo.Windows Management Framework 5 Pack folder is missing the below file...
	echo.
	echo."Windows6.1-KB3191566-%ImageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\WMF\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Management Framework (WMF) 5.1 Pack file exist
if "%SelectedSourceOS%" equ "w81" if not exist "%WMF%\Windows8.1-KB3191564-%ImageArchitecture%.cab" (
	echo.Windows Management Framework 5 Pack folder is missing the below file...
	echo.
	echo."Windows8.1-KB3191564-%ImageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\WMF\%SelectedSourceOS%^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Management Framework ^(WMF^) 5.1#################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Management Framework ^(WMF^) 5.1#########################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		if "%SelectedSourceOS%" equ "w7" (
			if "%ImageArchitecture%" equ "x64" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Management Framework ^(WMF^) 5.1 Prerequisite Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%WMF%\Windows6.1-KB2809215-%ImageArchitecture%.cab"
			)

			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows Management Framework ^(WMF^) 5.1 Prerequisite Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%WMF%\Windows6.1-KB2872035-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows Management Framework ^(WMF^) 5.1 Prerequisite Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%WMF%\Windows6.1-KB2872047-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows Management Framework ^(WMF^) 5.1 Prerequisite Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%WMF%\Windows6.1-KB3033929-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows Management Framework ^(WMF^) 5.1 Feature Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%WMF%\Windows6.1-KB3191566-%ImageArchitecture%.cab"
		)

		if "%SelectedSourceOS%" equ "w81" call :AddPackage "%InstallMount%\%%i", "%WMF%\Windows8.1-KB3191564-%ImageArchitecture%.cab"
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Management Framework ^(WMF^) 5.1################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set WMF=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft Win32 Calculator
::-------------------------------------------------------------------------------------------
:IntWin32Calc

setlocal

cls
echo.===============================================================================
echo.             MSMG ToolKit - Integrate Microsoft Win32 Calculator
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Microsoft Win32 Calculator Pack file exist
if not exist "%Win32Calc%\Win32Calc.tpk" (
	echo.Microsoft Win32 Calculator Pack folder is missing the below file...
	echo.
	echo."Win32Calc.tpk"
	echo.
	echo.Please copy the above file to ^<Packs\Win32Calc^> folder...
	goto :Stop
)

:: Checking whether Microsoft Win32 Calculator Pack file exist
if "%ImageArchitecture%" neq "arm64" if not exist "%Win32Calc%\Win32Calc_%ImageDefaultLanguage%.tpk" (
	echo.Microsoft Win32 Calculator Pack folder is missing the below file...
	echo.
	echo."Win32Calc_%ImageDefaultLanguage%.tpk"
	echo.
	echo.Please copy the above file to ^<Packs\Win32Calc^> folder...
	goto :Stop
)

:: Checking whether Microsoft Win32 Calculator Pack file exist
if not exist "%Win32Calc%\Win32Calc_%ImageArchitecture%.reg" (
	echo.Microsoft Win32 Calculator Pack folder is missing the below file...
	echo.
	echo."Win32Calc_%ImageArchitecture%.reg"
	echo.
	echo.Please copy the above file to ^<Packs\Win32Calc^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft Win32 Calculator#############################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft Win32 Calculator#####################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft Win32 Calculator Base Package...
		echo.-------------------------------------------------------------------------------
		if "%ImageArchitecture%" neq "arm64" call :ApplyImage "%Win32Calc%\Win32Calc.tpk", %PackageIndex%, "%InstallMount%\%%i"
		if "%ImageArchitecture%" equ "arm64" call :ApplyImage "%Win32Calc%\Win32Calc.tpk", 3, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------

		if "%ImageArchitecture%" neq "arm64" (
			echo.Integrating Microsoft Win32 Calculator [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Win32Calc%\Win32Calc_%ImageDefaultLanguage%.tpk", %PackageIndex%, "%InstallMount%\%%i"
		)

		echo.-------------------------------------------------------------------------------
		echo.Importing Microsoft Win32 Calculator Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Importing Registry Settings to Image Registry...
		call :ImportRegistry2Image "%Win32Calc%\Win32Calc_%ImageArchitecture%.reg"
		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft Win32 Calculator############################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set Win32Calc=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Data Deduplication
::-------------------------------------------------------------------------------------------
:IntDedup

setlocal

cls
echo.===============================================================================
echo.             MSMG ToolKit - Integrate Windows Data Deduplication
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether the Source OS architecture is not 64-bit
if "%ImageArchitecture%" neq "x64" (
	echo.This feature is not applicable for 32-bit Source OS...
	goto :Stop
)

:: Setting Windows Data Deduplication Pack folder path accroding to selected Source OS
set "FSSMRESReg=%Dedup%\fssmres.dll.reg"
if "%SelectedSourceOS%"=="w81" set "Dedup=%Dedup%\%SelectedSourceOS%"
if "%SelectedSourceOS%"=="w10" set "Dedup=%Dedup%\%SelectedSourceOS%\%PackageVersion%"

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w81" if not exist "%Dedup%\Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~~6.3.9600.16384.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~~6.3.9600.16384.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w81" if not exist "%Dedup%\Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~6.3.9600.16384.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~6.3.9600.16384.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w81" if not exist "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~6.3.9600.16384.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~6.3.9600.16384.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w81" if not exist "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~6.3.9600.16384.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~6.3.9600.16384.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "10586" if not exist "%Dedup%\Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "10586" if not exist "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "10586" if "%ImageDefaultLanguage%" neq "de-DE" if "%ImageDefaultLanguage%" neq "es-ES" if "%ImageDefaultLanguage%" neq "fr-FR" if "%ImageDefaultLanguage%" neq "it-IT" if "%ImageDefaultLanguage%" neq "ja-JP" if "%ImageDefaultLanguage%" neq "ko-KR" if "%ImageDefaultLanguage%" neq "pt-BR" if "%ImageDefaultLanguage%" neq "ru-RU" if "%ImageDefaultLanguage%" neq "tr-TR" if "%ImageDefaultLanguage%" neq "zh-CN" if "%ImageDefaultLanguage%" neq "zh-TW" (
	if not exist "%Dedup%\Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~en-US~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Data Deduplication Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~en-US~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
		goto :Stop
	)

	if not exist "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~en-US~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Data Deduplication Pack folder is missing the below file...
		echo.
		echo."Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~en-US~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
		goto :Stop
	)
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "10586" (
	for %%j in (de-DE, es-ES, fr-FR, it-IT, ja-JP, ko-KR, pt-BR, ru-RU, tr-TR, zh-CN, zh-TW) do (
		if "%ImageDefaultLanguage%" equ "%%j" (
			if not exist "%Dedup%\Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
				echo.Windows Data Deduplication Pack folder is missing the below file...
				echo.
				echo."Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.
				echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
				goto :Stop
			)

			if not exist "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
				echo.Windows Data Deduplication Pack folder is missing the below file...
				echo.
				echo."Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.
				echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
				goto :Stop
			)
		)
	)
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "14393" if not exist "%Dedup%\Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "14393" if not exist "%Dedup%\Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "14393" if not exist "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "14393" if not exist "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "15063" if not exist "%Dedup%\Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "15063" if not exist "%Dedup%\Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~en-US~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~en-US~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "15063" if not exist "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "15063" if not exist "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~en-US~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~en-US~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "16299" if not exist "%Dedup%\Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "16299" if not exist "%Dedup%\Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "16299" if not exist "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Data Deduplication Pack file exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "16299" if not exist "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Data Deduplication Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Dedup\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Data Deduplication#############################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Data Deduplication#####################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		if "%SelectedSourceOS%" equ "w81" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows File Server Base Package....
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~~6.3.9600.16384.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows File Server [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~6.3.9600.16384.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows Deduplication Base Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~6.3.9600.16384.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows Deduplication [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~6.3.9600.16384.cab"
		)

		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
			if "%ImageBuild%" equ "10586" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows File Server Base Package....
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------

				if "%ImageDefaultLanguage%" neq "de-DE" if "%ImageDefaultLanguage%" neq "es-ES" if "%ImageDefaultLanguage%" neq "fr-FR" if "%ImageDefaultLanguage%" neq "it-IT" if "%ImageDefaultLanguage%" neq "ja-JP" if "%ImageDefaultLanguage%" neq "ko-KR" if "%ImageDefaultLanguage%" neq "pt-BR" if "%ImageDefaultLanguage%" neq "ru-RU" if "%ImageDefaultLanguage%" neq "tr-TR" if "%ImageDefaultLanguage%" neq "zh-CN" if "%ImageDefaultLanguage%" neq "zh-TW" (
					echo.Integrating Windows File Server [en-US] Language Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~en-US~%PackageVersion%.%PackageServicePackBuild%.cab"
				)

				for %%j in (de-DE, es-ES, fr-FR, it-IT, ja-JP, ko-KR, pt-BR, ru-RU, tr-TR, zh-CN, zh-TW) do (
					if "%ImageDefaultLanguage%" equ "%%j" (
						echo.Integrating Windows File Server [%ImageDefaultLanguage%] Language Package...
						echo.-------------------------------------------------------------------------------
						call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-FileServer-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
					)
				)

				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Deduplication Base Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------

				if "%ImageDefaultLanguage%" neq "de-DE" if "%ImageDefaultLanguage%" neq "es-ES" if "%ImageDefaultLanguage%" neq "fr-FR" if "%ImageDefaultLanguage%" neq "it-IT" if "%ImageDefaultLanguage%" neq "ja-JP" if "%ImageDefaultLanguage%" neq "ko-KR" if "%ImageDefaultLanguage%" neq "pt-BR" if "%ImageDefaultLanguage%" neq "ru-RU" if "%ImageDefaultLanguage%" neq "tr-TR" if "%ImageDefaultLanguage%" neq "zh-CN" if "%ImageDefaultLanguage%" neq "zh-TW" (
					echo.Integrating Windows Deduplication [en-US] Language Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~en-US~%PackageVersion%.%PackageServicePackBuild%.cab"
				)

				for %%j in (de-DE, es-ES, fr-FR, it-IT, ja-JP, ko-KR, pt-BR, ru-RU, tr-TR, zh-CN, zh-TW) do (
					if "%ImageDefaultLanguage%" equ "%%j" (
						echo.Integrating Windows Deduplication [%ImageDefaultLanguage%] Language Package...
						echo.-------------------------------------------------------------------------------
						call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
					)
				)
			)

			if "%ImageBuild%" equ "14393" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows File Server Core Base Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows File Server Core [%ImageDefaultLanguage%] Language Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Deduplication Base Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Deduplication [%ImageDefaultLanguage%] Language Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"

				if exist "%Dedup%\Updates\*.cab" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows Deduplication Update Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Dedup%\Updates"
				)
			)

			if "%ImageBuild%" equ "15063" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows File Server Core Base Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows File Server Core [en-US] Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~en-US~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Deduplication Base Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Deduplication [en-US] Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~en-US~%PackageVersion%.%PackageServicePackBuild%.cab"
			)

			if "%ImageBuild%" geq "16299" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows File Server Core Base Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows File Server Core [%ImageDefaultLanguage%] Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-FileServer-ServerCore-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Deduplication Base Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Deduplication [%ImageDefaultLanguage%] Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Microsoft-Windows-Dedup-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
			)

			if exist "%Dedup%\Updates\*.cab" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Deduplication Update Packages...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Dedup%\Updates"
			)
		)

		echo.-------------------------------------------------------------------------------
		echo.Enabling Windows Data Deduplication Feature...
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w81" (
			call :EnableFeature "%InstallMount%\%%i", "Dedup-Core /All"
			echo.-------------------------------------------------------------------------------
			echo.Enabling Windows File Services Search Service Feature...
			echo.-------------------------------------------------------------------------------
			call :EnableFeature "%InstallMount%\%%i", "File-Services-Search-Service /All"
		)

		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" call :EnableFeature "%InstallMount%\%%i", "Dedup-Core /All"

		echo.-------------------------------------------------------------------------------
		echo.Importing Windows File Server ^(fssmres.dll^) Fix Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Importing Registry Settings to Image Registry...
		call :ImportRegistry2Image "%FSSMRESReg%"
		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Data Deduplication############################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set Dedup=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows To Go Workspace
::-------------------------------------------------------------------------------------------
:IntWinToGo

setlocal

cls
echo.===============================================================================
echo.              MSMG ToolKit - Integrate Windows To Go Workspace
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Windows To Go Workspace Pack path
if "%SelectedSourceOS%" equ "w81" set "WinToGo=%WinToGo%\%SelectedSourceOS%"
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" set "WinToGo=%WinToGo%\%SelectedSourceOS%\%PackageVersion%"

:: Checking whether Windows To Go Workspace Pack file exist
if "%SelectedSourceOS%" equ "w81" if not exist "%WinToGo%\WTG.tpk" (
	echo.Windows To Go Workspace Pack file "WTG.tpk" not found...
	echo.
	echo.Please copy the above file to ^<Packs\WinToGo\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows To Go Workspace Pack file exist
if "%SelectedSourceOS%" equ "w81" if not exist "%WinToGo%\WTG_%ImageDefaultLanguage%.tpk" (
	echo.Windows To Go Workspace Pack file "WTG_%ImageDefaultLanguage%.tpk" not found...
	echo.
	echo.Please copy the above file to ^<Packs\WinToGo\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows To Go Workspace Pack file exist
if "%SelectedSourceOS%" equ "w81" if not exist "%WinToGo%\WTG_%ImageArchitecture%.reg" (
	echo.Windows To Go Workspace Pack file "WTG_%ImageArchitecture%.reg" not found...
	echo.
	echo.Please copy the above file to ^<Packs\WinToGo\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows To Go Workspace Pack file exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%WinToGo%\Microsoft-Windows-PortableWorkspaces-Creator-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows To Go Workspace Pack folder is missing the below file...
	echo.
	echo.Microsoft-Windows-PortableWorkspaces-Creator-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\WinToGo\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows To Go Workspace Pack file exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%WinToGo%\Microsoft-Windows-PortableWorkspaces-Creator-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows To Go Workspace Pack folder is missing the below file...
	echo.
	echo.Microsoft-Windows-PortableWorkspaces-Creator-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\WinToGo\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows To Go Workspace################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows To Go Workspace########################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		if "%SelectedSourceOS%" equ "w81" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows To Go Workspace Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%WinToGo%\WTG.tpk", %PackageIndex%, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows To Go Workspace [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%WinToGo%\WTG_%ImageDefaultLanguage%.tpk", %PackageIndex%, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Importing Windows To Go Workspace Registry Settings...
			echo.-------------------------------------------------------------------------------
			echo.
			echo.Mounting Image Registry...
			call :MountImageRegistry "%InstallMount%\%%i"
			echo.Importing Registry Settings to Image Registry...
			call :ImportRegistry2Image "%WinToGo%\WTG_%ImageArchitecture%.reg"
			echo.Un-Mounting Image Registry...
			call :UnMountImageRegistry
		)

		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows To Go Workspace Base Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", %WinToGo%\Microsoft-Windows-PortableWorkspaces-Creator-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows To Go Workspace [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", %WinToGo%\Microsoft-Windows-PortableWorkspaces-Creator-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows To Go Workspace###############################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set WinToGo=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows System Restore
::-------------------------------------------------------------------------------------------
:IntSystemRestore

setlocal

cls
echo.===============================================================================
echo.               MSMG ToolKit - Integrate Windows System Restore
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Windows System Restore Pack Path
if "%SelectedSourceOS%" equ "w7" set "SystemRestore=%SystemRestore%\%SelectedSourceOS%"
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" set "SystemRestore=%SystemRestore%\%SelectedSourceOS%\%PackageVersion%"

:: Checking whether Windows System Restore Pack file exist
if not exist "%SystemRestore%\Microsoft-Windows-SystemRestore-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows System Restore Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-SystemRestore-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	if "%SelectedSourceOS%" equ "w7" echo.Please copy the above file to ^<Packs\SystemRestore\%SelectedSourceOS%^> folder...
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.Please copy the above file to ^<Packs\SystemRestore\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows System Restore Pack file exist
if not exist "%SystemRestore%\Microsoft-Windows-SystemRestore-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows System Restore Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-SystemRestore-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	if "%SelectedSourceOS%" equ "w7" echo.Please copy the above file to ^<Packs\SystemRestore\%SelectedSourceOS%^> folder...
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.Please copy the above file to ^<Packs\SystemRestore\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows System Restore#################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows System Restore#########################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows System Restore Base Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%SystemRestore%\Microsoft-Windows-SystemRestore-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows System Restore [%ImageDefaultLanguage%] Language Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%SystemRestore%\Microsoft-Windows-SystemRestore-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows System Restore################################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set SystemRestore=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft Edge Classic Browser
::-------------------------------------------------------------------------------------------
:IntEdgeClassic

setlocal

cls
echo.===============================================================================
echo.            MSMG ToolKit - Integrate Microsoft Edge Classic Browser
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Microsoft Edge Classic Browser Pack path
set "EdgeClassic=%EdgeClassic%\%PackageVersion%"

:: Checking whether Microsoft Edge Classic Browser Pack file exist
if "%SelectedSourceOS%" equ "w10" if not exist "%EdgeClassic%\Microsoft-Windows-Internet-Browser-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Microsoft Edge Classic Browser Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Internet-Browser-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\EdgeBrowser\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Microsoft Edge Classic Browser Pack file exist
if "%SelectedSourceOS%" equ "w10" if not exist "%EdgeClassic%\Microsoft-Windows-Internet-Browser-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Microsoft Edge Classic Browser Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Internet-Browser-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\EdgeBrowser\%PackageVersion%^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft Edge Classic Browser#########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft Edge Classic Browser#################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft Edge Classic Browser Base Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%EdgeClassic%\Microsoft-Windows-Internet-Browser-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft Edge Classic Browser [%ImageDefaultLanguage%] Language Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%EdgeClassic%\Microsoft-Windows-Internet-Browser-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"

		:: Importing Registry Fix to Enable Integrating Windows 10 Cumulative Update.
		if "%ImageBuild%" lss "17763" (
			for %%j in (EnterpriseS, ServerStandard, ServerDatacenter) do (
				if "%ImageEdition%" equ "%%j" if exist "%InstallMount%\%%i\Windows\servicing\packages\Microsoft-Windows-Internet-Browser-Package~31bf3856ad364e35~*.mum" (
					call :MountImageRegistry "%InstallMount%\%%i"
					reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
					reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.mum" /f >nul
					reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs.bin.%PackageArchitecture%fre.dep\mergedcomponents\images\client\packages\\" /f >nul
					reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
					reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
					reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "Visibility" /t REG_DWORD /d "1" /f >nul
					reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "InstallTimeHigh" /t REG_DWORD /d "30531506" /f >nul
					reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "InstallTimeLow" /t REG_DWORD /d "76431985" /f >nul
					reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
					call :UnMountImageRegistry
				)
			)

			if "%ImageEdition%" equ "EnterpriseSN" if exist "%InstallMount%\%%i\Windows\servicing\packages\Microsoft-Windows-Internet-Browser-Package~31bf3856ad364e35~*.mum" (
				call :MountImageRegistry "%InstallMount%\%%i"
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.mum" /f >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs.bin.%PackageArchitecture%fre.dep\mergedcomponents\images\client\packages\\" /f >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "Visibility" /t REG_DWORD /d "1" /f >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "InstallTimeHigh" /t REG_DWORD /d "30531506" /f >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "InstallTimeLow" /t REG_DWORD /d "76431985" /f >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
				call :UnMountImageRegistry
			)
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft Edge Classic Browser########################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set EdgeClassic=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft Edge Chromium Browser
::-------------------------------------------------------------------------------------------
:IntEdgeChromium

setlocal

cls
echo.===============================================================================
echo.          MSMG ToolKit - Integrate Microsoft Edge Chromium Browser
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Microsoft Edge Chromium Browser Pack file exist
if not exist "%EdgeChromium%\EdgeChromium_%SelectedSourceOS%.tpk" (
	echo.Microsoft Edge Chromium Browser Pack folder is missing the below file...
	echo.
	echo.EdgeChromium_%SelectedSourceOS%.tpk
	echo.
	echo.Please copy the above file to ^<Packs\EdgeChromium^> folder...
	goto :Stop
)

if not exist "%EdgeChromium%\EdgeChromium_%SelectedSourceOS%_%ImageArchitecture%.reg" (
	echo.Microsoft Edge Chromium Browser Pack folder is missing the below file...
	echo.
	echo.EdgeChromium_%SelectedSourceOS%_%ImageArchitecture%.reg
	echo.
	echo.Please copy the above file to ^<Packs\EdgeChromium^> folder...
	goto :Stop
)

if not exist "%EdgeChromium%\EdgeChrGPD.tpk" (
	echo.Microsoft Edge Chromium Browser Pack folder is missing the below file...
	echo.
	echo.EdgeChrGPD.tpk
	echo.
	echo.Please copy the above file to ^<Packs\EdgeChromium^> folder...
	goto :Stop
)

for /d %%k in (cs-CZ,da-DK,de-DE,el-GR,en-US,es-ES,fi-FI,fr-FR,hu-HU,it-IT,ja-JP,ko-KR,nb-NO,nl-NL,pl-PL,pt-BR,pt-PT,ru-RU,sv-SE,tr-TR,zh-CN,zh-TW) do (
	if "%ImageDefaultLanguage%" equ "%%k" (
		if not exist "%EdgeChromium%\EdgeChrGPD_%%k.tpk" (
			echo.Microsoft Edge Chromium Browser Pack folder is missing the below file...
			echo.
			echo.EdgeChrGPD_%%k.tpk
			echo.
			echo.Please copy the above file to ^<Packs\EdgeChromium^> folder...
			goto :Stop
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft Edge Chromium Browser########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft Edge Chromium Browser################################
echo.-------------------------------------------------------------------------------
echo.
for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft Edge Chromium Browser Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%EdgeChromium%\EdgeChromium_%SelectedSourceOS%.tpk", %PackageIndex%, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft Edge Chromium Browser Group Policy Base Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%EdgeChromium%\EdgeChrGPD.tpk", 1, "%InstallMount%\%%i"

		for /d %%k in (cs-CZ,da-DK,de-DE,el-GR,en-US,es-ES,fi-FI,fr-FR,hu-HU,it-IT,ja-JP,ko-KR,nb-NO,nl-NL,pl-PL,pt-BR,pt-PT,ru-RU,sv-SE,tr-TR,zh-CN,zh-TW) do (
			if "%ImageDefaultLanguage%" equ "%%k" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft Edge Chromium Browser Group Policy [%%k] Package...
				echo.-------------------------------------------------------------------------------
				call :ApplyImage "%EdgeChromium%\EdgeChrGPD_%%k.tpk", 1, "%InstallMount%\%%i"
			)
		)

		echo.-------------------------------------------------------------------------------
		echo.Importing Microsoft Edge Chromium Browser Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Importing Registry Settings to Image Registry...
		call :ImportRegistry2Image "%EdgeChromium%\EdgeChromium_%SelectedSourceOS%_%ImageArchitecture%.reg"
		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
		echo.
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft Edge Chromium Browser#######################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft Edge WebView 2
::-------------------------------------------------------------------------------------------
:IntEdgeWebView2

setlocal

cls
echo.===============================================================================
echo.             MSMG ToolKit - Integrate Microsoft Edge WebView 2
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Microsoft Edge WebView 2 Pack file exist
if not exist "%EdgeWebView2%\EdgeWebView2_%SelectedSourceOS%.tpk" (
	echo.Microsoft Edge WebView 2 Pack folder is missing the below file...
	echo.
	echo.EdgeWebView2_%SelectedSourceOS%.tpk
	echo.
	echo.Please copy the above file to^<Packs\EdgeWebView2^> folder...
	goto :Stop
)

:: Checking whether Microsoft Edge WebView 2 Pack file exist
if not exist "%EdgeWebView2%\EdgeWebView2_%SelectedSourceOS%_%ImageArchitecture%.reg" (
	echo.Microsoft Edge WebView 2 Pack folder is missing the below file...
	echo.
	echo.EdgeWebView2_%SelectedSourceOS%_%ImageArchitecture%.reg
	echo.
	echo.Please copy the above file to^<Packs\EdgeWebView2^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft Edge WebView 2###############################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft Edge WebView 2#######################################
echo.-------------------------------------------------------------------------------
echo.
for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft Edge WebView 2 Base Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%EdgeWebView2%\EdgeWebView2_%SelectedSourceOS%.tpk", %PackageIndex%, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------
		echo.Importing Microsoft Edge WebView 2 Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Importing Registry Settings to Image Registry...
		call :ImportRegistry2Image "%EdgeWebView2%\EdgeWebView2_%SelectedSourceOS%_%ImageArchitecture%.reg"
		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
		echo.
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft Edge WebView 2##############################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Mozilla Firefox Browser
::-------------------------------------------------------------------------------------------
:IntFirefox

setlocal

cls
echo.===============================================================================
echo.             MSMG ToolKit - Integrate Mozilla Firefox Browser
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Mozilla Firefox Browser Pack file exist
if not exist "%Firefox%\Firefox_%SelectedSourceOS%.tpk" (
	echo.Mozilla Firefox Browser Pack folder is missing the below file...
	echo.
	echo."Firefox_%SelectedSourceOS%.tpk"
	echo.
	echo.Please copy the above file to ^<Packs\Firefox^> folder...
	goto :Stop
)

if not exist "%Firefox%\Firefox_%SelectedSourceOS%_%ImageArchitecture%.reg" (
	echo.Mozilla Firefox Browser Pack folder is missing the below file...
	echo.
	echo."Firefox_%SelectedSourceOS%_%ImageArchitecture%.reg"
	echo.
	echo.Please copy the above file to ^<Packs\Firefox^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Mozilla Firefox Browser################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Mozilla Firefox Browser########################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Mozilla Firefox Browser Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%Firefox%\Firefox_%SelectedSourceOS%.tpk", %PackageIndex%, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------
		echo.Importing Mozilla Firefox Browser Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Importing Registry Settings to Image Registry...
		call :ImportRegistry2Image "%Firefox%\Firefox_%SelectedSourceOS%_%ImageArchitecture%.reg"

		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
		echo.
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Mozilla Firefox Browser###############################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Accessibility Braille
::-------------------------------------------------------------------------------------------
:IntBraille

setlocal

cls
echo.===============================================================================
echo.           MSMG ToolKit - Integrate Windows Accessibility Braille
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Braille Pack Path
set "Braille=%Braille%\%SelectedSourceOS%\%PackageVersion%"

:: Checking whether Windows Accessibility Braille Pack file exist
if not exist "%Braille%\Microsoft-Windows-Accessibility-Braille-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Accessibility Braille Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Accessibility-Braille-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\Braille\%PackageVersion%^> folder...
	goto :Stop
)

call :RemoveFile "%Temp%\Microsoft-Windows-Accessibility-Braille-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
if "%ImageBuild%" geq "17763" copy /y "%Braille%\Microsoft-Windows-Accessibility-Braille-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" "%Temp%\Microsoft-Windows-Accessibility-Braille-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab" >nul

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Accessibility Braille##########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Accessibility Braille##################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		if "%ImageBuild%" leq "17134" call :AddPackage "%InstallMount%\%%i", "%Braille%\Microsoft-Windows-Accessibility-Braille-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
		if "%ImageBuild%" geq "17763" call :AddPackage "%InstallMount%\%%i", "%Temp%\Microsoft-Windows-Accessibility-Braille-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
	)
)

call :RemoveFile "%Temp%\Microsoft-Windows-Accessibility-Braille-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Accessibility Braille#########################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set Braille=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Multimedia Restricted Codecs
::-------------------------------------------------------------------------------------------
:IntMMRC

setlocal

cls
echo.===============================================================================
echo.       MSMG ToolKit - Integrate Windows Multimedia Restricted Codecs
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Multimedia Restricted Codecs Pack path
set "MMRC=%MMRC%\%SelectedSourceOS%\%PackageVersion%"

:: Checking whether Windows Multimedia Restricted Codecs Pack file exist
if not exist "%MMRC%\Multimedia-RestrictedCodecsDolby-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Multimedia Restricted Codecs Pack folder is missing the below file...
	echo.
	echo."Multimedia-RestrictedCodecsDolby-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\MultimediaRestrictedCodecs\%PackageVersion%^> folder...
	goto :Stop
)

if "%ImageArchitecture%" equ "x64" if not exist "%MMRC%\Multimedia-RestrictedCodecsDolby-WOW64-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Multimedia Restricted Codecs Pack folder is missing the below file...
	echo.
	echo."Multimedia-RestrictedCodecsDolby-WOW64-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\MultimediaRestrictedCodecs\%PackageVersion%^> folder...
	goto :Stop
)

if "%ImageInstallationType%" equ "Server" (
	if not exist "%MMRC%\Multimedia-RestrictedCodecsExt-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Multimedia Restricted Codecs Pack folder is missing the below file...
		echo.
		echo."Multimedia-RestrictedCodecsExt-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\MultimediaRestrictedCodecs\%PackageVersion%^> folder...
		goto :Stop
	)

	if not exist "%MMRC%\Multimedia-RestrictedCodecsExt-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Multimedia Restricted Codecs Pack folder is missing the below file...
		echo.
		echo."Multimedia-RestrictedCodecsExt-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\MultimediaRestrictedCodecs\%PackageVersion%^> folder...
		goto :Stop
	)

	if "%ImageArchitecture%" equ "x64" if not exist "%MMRC%\Multimedia-RestrictedCodecsExt-WOW64-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Multimedia Restricted Codecs Pack folder is missing the below file...
		echo.
		echo."Multimedia-RestrictedCodecsExt-WOW64-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\MultimediaRestrictedCodecs\%PackageVersion%^> folder...
		goto :Stop
	)

	if "%ImageArchitecture%" equ "x64" if not exist "%MMRC%\Multimedia-RestrictedCodecsExt-WOW64-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
		echo.Windows Multimedia Restricted Codecs Pack folder is missing the below file...
		echo.
		echo."Multimedia-RestrictedCodecsExt-WOW64-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.
		echo.Please copy the above file to ^<Packs\MultimediaRestrictedCodecs\%PackageVersion%^> folder...
		goto :Stop
	)
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Multimedia Restricted Codecs###################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Multimedia Restricted Codecs###########################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows Multimedia Restricted Dolby Codec Base Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%MMRC%\Multimedia-RestrictedCodecsDolby-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows Multimedia Restricted Dolby Codec [%ImageDefaultLanguage%] Language Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%MMRC%\Multimedia-RestrictedCodecsDolby-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.-------------------------------------------------------------------------------

		if "%ImageArchitecture%" equ "x64" (
			echo.Integrating Windows Multimedia Restricted Dolby Codec WOW64 Base Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%MMRC%\Multimedia-RestrictedCodecsDolby-WOW64-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows Multimedia Restricted Dolby Codec WOW64 [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%MMRC%\Multimedia-RestrictedCodecsDolby-WOW64-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
		)

		if "%ImageInstallationType%" equ "Server" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows Multimedia Restricted Extended Codecs Base Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%MMRC%\Multimedia-RestrictedCodecsExt-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows Multimedia Restricted Extended Codecs [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%MMRC%\Multimedia-RestrictedCodecsExt-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
			echo.-------------------------------------------------------------------------------

			if "%ImageArchitecture%" equ "x64" (
				echo.Integrating Windows Multimedia Restricted Extended Codecs WOW64 Base Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%MMRC%\Multimedia-RestrictedCodecsExt-WOW64-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Multimedia Restricted Extended Codecs WOW64 [%ImageDefaultLanguage%] Language Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%MMRC%\Multimedia-RestrictedCodecsExt-WOW64-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
			)
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Multimedia Restricted Codecs##################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set MMRC=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Subsystem for Linux ^(WSL^)
::-------------------------------------------------------------------------------------------
:IntWSL

setlocal

cls
echo.===============================================================================
echo.        MSMG ToolKit - Integrate Windows Subsystem for Linux ^(WSL^)
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Windows Subsystem for Linux (WSL) Pack Path
set "WSL=%WSL%\%SelectedSourceOS%\%PackageVersion%"

:: Checking whether Windows Subsystem for Linux (WSL) Pack file exist
if not exist "%WSL%\Microsoft-Windows-Lxss-Optional-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Subsystem for Linux ^(WSL^) Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Lxss-Optional-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\WSL\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Subsystem for Linux (WSL) Pack file exist
if not exist "%WSL%\Microsoft-Windows-Lxss-Optional-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Subsystem for Linux ^(WSL^) Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Lxss-Optional-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\WSL\%PackageVersion%^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Subsystem for Linux ^(WSL^)######################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Subsystem for Linux ^(WSL^)##############################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows Subsystem for Linux ^(WSL^) Base Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%WSL%\Microsoft-Windows-Lxss-Optional-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows Subsystem for Linux ^(WSL^) [%ImageDefaultLanguage%] Language Package...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%InstallMount%\%%i", "%WSL%\Microsoft-Windows-Lxss-Optional-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Enabling Windows Subsystem for Linux ^(WSL^) Feature...
		echo.-------------------------------------------------------------------------------
		call :EnableFeature "%InstallMount%\%%i", "Microsoft-Windows-Subsystem-Linux /All"
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Subsystem for Linux ^(WSL^)#####################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set WSL=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Open Secure Shell (SSH) Client & Server
::-------------------------------------------------------------------------------------------
:IntOpenSSH

setlocal

cls
echo.===============================================================================
echo.      MSMG ToolKit - Integrate Open Secure Shell ^(SSH^) Client ^& Server
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Open Secure Shell Pack Path
set "OpenSSH=%OpenSSH%\%SelectedSourceOS%\%PackageVersion%"

:: Checking whether Open Secure Shell (SSH) Client Pack file exist
if not exist "%OpenSSH%\OpenSSH-Client-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.OpenSSH Client ^& Server Pack folder is missing the below file...
	echo.
	echo."OpenSSH-Client-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\OpenSSH\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Open Secure Shell (SSH) Server Pack file exist
if not exist "%OpenSSH%\OpenSSH-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.OpenSSH Client ^& Server Pack folder is missing the below file...
	echo.
	echo."OpenSSH-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\OpenSSH\%PackageVersion%^> folder...
	goto :Stop
)

call :RemoveFile "%Temp%\OpenSSH-Client-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
call :RemoveFile "%Temp%\OpenSSH-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"

if "%ImageBuild%" geq "17763" (
	copy /y "%OpenSSH%\OpenSSH-Client-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" "%Temp%\OpenSSH-Client-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab" >nul
	copy /y "%OpenSSH%\OpenSSH-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" "%Temp%\OpenSSH-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab" >nul
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Open Secure Shell ^(SSH^) Client ^& Server###############
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Open Secure Shell ^(SSH^) Client ^& Server#######################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating OpenSSH Client Package...
		echo.-------------------------------------------------------------------------------
		if "%ImageBuild%" leq "17134" call :AddPackage "%InstallMount%\%%i", "%OpenSSH%\OpenSSH-Client-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
		if "%ImageBuild%" geq "17763" call :AddPackage "%InstallMount%\%%i", "%Temp%\OpenSSH-Client-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating OpenSSH Server Package...
		echo.-------------------------------------------------------------------------------
		if "%ImageBuild%" leq "17134" call :AddPackage "%InstallMount%\%%i", "%OpenSSH%\OpenSSH-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
		if "%ImageBuild%" geq "17763" call :AddPackage "%InstallMount%\%%i", "%Temp%\OpenSSH-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
	)
)

call :RemoveFile "%Temp%\OpenSSH-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"
call :RemoveFile "%Temp%\OpenSSH-Server-Package~31bf3856ad364e35~%PackageArchitecture%~~.cab"

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Open Secure Shell ^(SSH^) Client ^& Server##############
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set OpenSSH=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Media Feature Pack
::-------------------------------------------------------------------------------------------
:IntMediaFeaturePack

setlocal

cls
echo.===============================================================================
echo.             MSMG ToolKit - Integrate Windows Media Feature Pack
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether exists N Editions supported for Windows Media Feature Integration are selected as source.
set /A ImageEditionCount=0
for /d %%j in (StarterN, StarterKN, HomeBasicN, HomeBasicKN, CoreN, CloudN, ProfessionalN, ProfessionalKN, ProfessionalEducationN, ProfessionalEducationKN, EnterpriseN, EnterpriseKN, EnterpriseSN, EnterpriseGN, UltimateN, UltimateKN, EducationN, EducationKN) do (
   if "%ImageEdition%" equ "%%j" set /A ImageEditionCount+=1
)

if %ImageEditionCount% equ 0 (
   echo.No N Edition was found. And, Non-N Editions are not supported.
   echo.
   goto :Stop
)

:: Setting Windows Media Feature Pack folder path according to selected Source OS
if "%SelectedSourceOS%" neq "w10" if "%SelectedSourceOS%" neq "w11" set "MediaFeaturePack=%MediaFeaturePack%\%SelectedSourceOS%"
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" set "MediaFeaturePack=%MediaFeaturePack%\%SelectedSourceOS%\%PackageVersion%"

:: Checking whether Windows Media Feature Pack file exist
if "%SelectedSourceOS%" equ "w7" if not exist "%MediaFeaturePack%\Microsoft-Windows-MediaFeaturePack-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~~6.1.7600.16385.cab" (
	echo.Windows Media Feature Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-MediaFeaturePack-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~~6.1.7600.16385.cab"
	echo.
	echo.Please copy the above file to ^<Packs\MediaFeaturePack\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Media Feature Pack file exist
if "%SelectedSourceOS%" equ "w7" if not exist "%MediaFeaturePack%\Microsoft-Windows-Media-Format-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~~6.1.7600.16385.cab" (
	echo.Windows Media Feature Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Media-Format-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~~6.1.7600.16385.cab"
	echo.
	echo.Please copy the above file to ^<Packs\MediaFeaturePack\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Media Feature Pack file exist
if "%SelectedSourceOS%" equ "w81" if not exist "%MediaFeaturePack%\Microsoft-Windows-MediaFeaturePack-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~~6.3.9600.16384.cab" (
	echo.Windows Media Feature Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-MediaFeaturePack-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~~6.3.9600.16384.cab"
	echo.
	echo.Please copy the above file to ^<Packs\MediaFeaturePack\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Media Feature Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" leq "17763" if not exist "%MediaFeaturePack%\Microsoft-Windows-MediaFeaturePack-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Media Feature Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-MediaFeaturePack-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\MediaFeaturePack\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Media Feature Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" leq "17763" if not exist "%MediaFeaturePack%\Microsoft-Windows-MediaFeaturePack-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Media Feature Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-MediaFeaturePack-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\MediaFeaturePack\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Media Feature Pack file exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "18362" if not exist "%MediaFeaturePack%\Microsoft-Windows-Media-Features-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Media Feature Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Media-Features-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\MediaFeaturePack\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Media Feature Pack file exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "18362" if not exist "%MediaFeaturePack%\Microsoft-Windows-Media-Features-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Media Feature Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Media-Features-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\MediaFeaturePack\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Media Feature Pack file exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "18362" if "%ImageArchitecture%" equ "x64" if not exist "%MediaFeaturePack%\Microsoft-Windows-Media-Features-Package~31bf3856ad364e35~wow64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Media Feature Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Media-Features-Package~31bf3856ad364e35~wow64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\MediaFeaturePack\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Media Feature Pack file exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "18362" if "%ImageArchitecture%" equ "x64" if not exist "%MediaFeaturePack%\Microsoft-Windows-Media-Features-Package~31bf3856ad364e35~wow64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Media Feature Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Media-Features-Package~31bf3856ad364e35~wow64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\MediaFeaturePack\%SelectedSourceOS%\%PackageVersion%^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Media Feature Pack#############################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Media Feature Pack#####################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		for /d %%j in (StarterN, StarterKN, HomeBasicN, HomeBasicKN, CoreN, CloudN, ProfessionalN, ProfessionalKN, ProfessionalEducationN, ProfessionalEducationKN, EnterpriseN, EnterpriseKN, EnterpriseSN, EnterpriseGN, UltimateN, UltimateKN, EducationN, EducationKN) do (
			if "%ImageEdition%" equ "%%j" (
				if "%SelectedSourceOS%" equ "w7" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft Windows Media Feature Pack OOB Package
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%MediaFeaturePack%\Microsoft-Windows-MediaFeaturePack-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~~6.1.7600.16385.cab"
					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft Windows Media Format OOB Package
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%MediaFeaturePack%\Microsoft-Windows-Media-Format-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~~6.1.7600.16385.cab"
				)

				if "%SelectedSourceOS%" equ "w81" call :AddPackage "%InstallMount%\%%i", "%MediaFeaturePack%\Microsoft-Windows-MediaFeaturePack-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~~6.3.9600.16384.cab"

				if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" leq "17763" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft Windows Media Feature Pack OOB Package
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%MediaFeaturePack%\Microsoft-Windows-MediaFeaturePack-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft Windows Media Feature Pack OOB [%ImageDefaultLanguage%] Package
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%MediaFeaturePack%\Microsoft-Windows-MediaFeaturePack-OOB-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
				)

				if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "18362" (
					call :RemoveFolder "%Temp%\Updates\MediaFeaturePack"
					call :CreateFolder "%Temp%\Updates\MediaFeaturePack"
					expand -R "%MediaFeaturePack%\Microsoft-Windows-Media-Features-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" -F:* "%Temp%\Updates\MediaFeaturePack" >nul

					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft Windows Media Features Package
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\MediaFeaturePack"
					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft Windows Media Features [%ImageDefaultLanguage%] Package
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%MediaFeaturePack%\Microsoft-Windows-Media-Features-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"

					if "%ImageArchitecture%" equ "x64" (
						echo.-------------------------------------------------------------------------------
						echo.Integrating Microsoft Windows Media Features WOW64 Package...
						echo.-------------------------------------------------------------------------------
						call :AddPackage "%InstallMount%\%%i", "%MediaFeaturePack%\Microsoft-Windows-Media-Features-Package~31bf3856ad364e35~wow64~~%PackageVersion%.%PackageServicePackBuild%.cab"
						echo.-------------------------------------------------------------------------------
						echo.Integrating Microsoft Windows Media Features [%ImageDefaultLanguage%] WOW64 Package...
						echo.-------------------------------------------------------------------------------
						call :AddPackage "%InstallMount%\%%i", "%MediaFeaturePack%\Microsoft-Windows-Media-Features-Package~31bf3856ad364e35~wow64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
					)

					call :RemoveFolder "%Temp%\Updates"
				)
			)
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Media Feature Pack############################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set MediaFeaturePack=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Mixed Reality
::-------------------------------------------------------------------------------------------
:IntWMR

setlocal

cls
echo.===============================================================================
echo.              MSMG ToolKit - Integrate Windows Mixed Reality
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Windows Mixed Reality folder path according to selected Source OS
set "WMR=%WMR%\%SelectedSourceOS%\%PackageVersion%"

:: Checking whether Windows Mixed Reality file exist
if not exist "%WMR%\Microsoft-Windows-Holographic-Desktop-FOD-Package~31bf3856ad364e35~amd64~~.cab" (
	echo.Windows Mixed Reality folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Holographic-Desktop-FOD-Package~31bf3856ad364e35~amd64~~.cab"
	echo.
	echo.Please copy the above file to ^<Packs\WMR\%PackageVersion%^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Mixed Reality##################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Mixed Reality##########################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		call :AddPackage "%InstallMount%\%%i", "%WMR%\Microsoft-Windows-Holographic-Desktop-FOD-Package~31bf3856ad364e35~amd64~~.cab"
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Mixed Reality#################################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set WMR=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Portable Devices
::-------------------------------------------------------------------------------------------
:IntPortableDevices

setlocal

cls
echo.===============================================================================
echo.             MSMG ToolKit - Integrate Windows Portable Devices
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether exists N Editions supported for Portable Devices Integration are selected as source.
set /A ImageEditionCount=0
for /d %%j in (StarterN, StarterKN, HomeBasicN, HomeBasicKN, CoreN, CloudN, ProfessionalN, ProfessionalKN, ProfessionalEducationN, ProfessionalEducationKN, EnterpriseN, EnterpriseKN, EnterpriseSN, EnterpriseGN, UltimateN, UltimateKN, EducationN, EducationKN) do (
   if "%ImageEdition%" equ "%%j" set /A ImageEditionCount+=1
)

if %ImageEditionCount% equ 0 (
   echo.No N Edition was found. And, Non-N Editions are not supported.
   echo.
   goto :Stop
)

:: Setting Windows Portable Devices Pack Path
set "PortableDevices=%PortableDevices%\%SelectedSourceOS%\%PackageVersion%"

:: Checking whether Windows Portable Devices Pack file exist
if not exist "%PortableDevices%\Microsoft-Windows-Portable-Devices-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Portable Devices Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Portable-Devices-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\PortableDevices\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Portable Devices Pack file exist
if not exist "%PortableDevices%\Microsoft-Windows-Portable-Devices-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Portable Devices Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Portable-Devices-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\PortableDevices\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Portable Devices Pack file exist
if "%ImageArchitecture%" equ "x64" if not exist "%PortableDevices%\Microsoft-Windows-Portable-Devices-WOW64-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Portable Devices Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Portable-Devices-WOW64-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\PortableDevices\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Portable Devices Pack file exist
if "%ImageArchitecture%" equ "x64" if not exist "%PortableDevices%\Microsoft-Windows-Portable-Devices-WOW64-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Portable Devices Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Portable-Devices-WOW64-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\PortableDevices\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Portable Devices Pack file exist
if "%ImageBuild%" geq "18362" if "%ImageBuild%" leq "18363" if "%ImageArchitecture%" equ "x64" if not exist "%PortableDevices%\Microsoft-Windows-Portable-Devices-WOW64-Package~31bf3856ad364e35~wow64~~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Portable Devices Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Portable-Devices-WOW64-Package~31bf3856ad364e35~wow64~~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\PortableDevices\%PackageVersion%^> folder...
	goto :Stop
)

:: Checking whether Windows Portable Devices Pack file exist
if "%ImageBuild%" geq "18362" if "%ImageBuild%" leq "18363" if "%ImageArchitecture%" equ "x64" if not exist "%PortableDevices%\Microsoft-Windows-Portable-Devices-WOW64-Package~31bf3856ad364e35~wow64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab" (
	echo.Windows Portable Devices Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-Portable-Devices-WOW64-Package~31bf3856ad364e35~wow64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\PortableDevices\%PackageVersion%^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Portable Devices###############################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Portable Devices#######################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		for /d %%j in (StarterN,StarterKN,HomeBasicN,HomeBasicKN,CoreN,CloudN,ProfessionalN,ProfessionalKN,ProfessionalEducationN,ProfessionalEducationKN,EnterpriseN,EnterpriseKN,EnterpriseSN,EnterpriseGN,UltimateN,UltimateKN,EducationN,EducationKN) do (
			if "%ImageEdition%" equ "%%j" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Portable Devices Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%PortableDevices%\Microsoft-Windows-Portable-Devices-Package~31bf3856ad364e35~%PackageArchitecture%~~%PackageVersion%.%PackageServicePackBuild%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Portable Devices [%ImageDefaultLanguage%] Language Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%PortableDevices%\Microsoft-Windows-Portable-Devices-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"

				if "%ImageArchitecture%" equ "x64" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows Portable Devices WOW64 Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%PortableDevices%\Microsoft-Windows-Portable-Devices-WOW64-Package~31bf3856ad364e35~amd64~~%PackageVersion%.%PackageServicePackBuild%.cab"
					if "%ImageBuild%" geq "18362" if "%ImageBuild%" leq "18363" call :AddPackage "%InstallMount%\%%i", "%PortableDevices%\Microsoft-Windows-Portable-Devices-WOW64-Package~31bf3856ad364e35~wow64~~%PackageVersion%.%PackageServicePackBuild%.cab"
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows Portable Devices [%ImageDefaultLanguage%] Language WOW64 Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%PortableDevices%\Microsoft-Windows-Portable-Devices-WOW64-Package~31bf3856ad364e35~amd64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
					if "%ImageBuild%" geq "18362" if "%ImageBuild%" leq "18363" call :AddPackage "%InstallMount%\%%i", "%PortableDevices%\Microsoft-Windows-Portable-Devices-WOW64-Package~31bf3856ad364e35~wow64~%ImageDefaultLanguage%~%PackageVersion%.%PackageServicePackBuild%.cab"
				)
			)
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Portable Devices##############################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set PortableDevices=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows PowerShell 7
::-------------------------------------------------------------------------------------------
:IntPowerShell7

setlocal

cls
echo.===============================================================================
echo.              MSMG ToolKit - Integrate Windows PowerShell 7
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Windows PowerShell 7 Pack file exist
if not exist "%PowerShell7%\PowerShell7_%SelectedSourceOS%.tpk" (
	echo.Windows PowerShell 7 Pack folder is missing the below file...
	echo.
	echo."PowerShell7_%SelectedSourceOS%.tpk"
	echo.
	echo.Please copy the above file to ^<Packs\PowerShell7^> folder...
	goto :Stop
)

:: Checking whether Windows PowerShell 7 Pack file exist
if not exist "%PowerShell7%\PowerShell7_%SelectedSourceOS%_%ImageArchitecture%.reg" (
	echo.Windows PowerShell 7 Pack folder is missing the below file...
	echo.
	echo."PowerShell7_%SelectedSourceOS%_%ImageArchitecture%.reg"
	echo.
	echo.Please copy the above file to ^<Packs\PowerShell7^> folder...
	goto :Stop
)

:: Checking whether Windows PowerShell 7 Pack file exist
if "%SelectedSourceOS%" equ "w7" if not exist "%PowerShell7%\Windows6.1-KB3118401-%ImageArchitecture%.cab" (
	echo.Windows PowerShell 7 Pack folder is missing the below file...
	echo.
	echo."Windows6.1-KB3118401-%ImageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\PowerShell7^> folder...
	goto :Stop
)

:: Checking whether Windows PowerShell 7 Pack file exist
if "%SelectedSourceOS%" equ "w81" if not exist "%PowerShell7%\Windows8.1-KB3118401-%ImageArchitecture%.cab" (
	echo.Windows PowerShell 7 Pack folder is missing the below file...
	echo.
	echo."Windows8.1-KB3118401-%ImageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\PowerShell7^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows PowerShell 7###################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows PowerShell 7###########################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		if "%SelectedSourceOS%" neq "w10" if "%SelectedSourceOS%" neq "w11" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows Universal C Runtime ^(CRT^) Package...
			echo.-------------------------------------------------------------------------------
			if "%SelectedSourceOS%" equ "w7" call :AddPackage "%InstallMount%\%%i", "%PowerShell7%\Windows6.1-KB3118401-%ImageArchitecture%.cab"
			if "%SelectedSourceOS%" equ "w81" call :AddPackage "%InstallMount%\%%i", "%PowerShell7%\Windows8.1-KB3118401-%ImageArchitecture%.cab"
		)

		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows PowerShell 7 Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%PowerShell7%\PowerShell7_%SelectedSourceOS%.tpk", %PackageIndex%, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------
		echo.Importing Windows PowerShell 7 Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Importing Registry Settings to Image Registry...
		call :ImportRegistry2Image "%PowerShell7%\PowerShell7_%SelectedSourceOS%_%ImageArchitecture%.reg"
		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows PowerShell 7##################################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set PowerShell7=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Remote Server Administration Tool (RSAT)
::-------------------------------------------------------------------------------------------
:IntRSAT

setlocal

set RSATType=

if "%SelectedSourceOS%" equ "w10" (
	cls
	echo.===============================================================================
	echo.   MSMG ToolKit - Integrate Windows Remote Server Administration Tool ^(RSAT^)
	echo.===============================================================================
	echo.
	echo.  [1]  RSAT for Managing targets older than Windows Server, version 1709
	echo.
	echo.  [2]  RSAT for Managing Windows Server, version 1709
	echo.
	echo.  [3]  RSAT for Managing Windows Server, version 1803
	echo.
	echo.  [X]  Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:123X /N /M "Enter Your Choice : "
	if errorlevel 4 goto :IntegrateMenu
	if errorlevel 3 set RSATType=v1803
	if errorlevel 2 set RSATType=v1709
	if errorlevel 1 set RSATType=v1609
)

cls
echo.===============================================================================
echo.   MSMG ToolKit - Integrate Windows Remote Server Administration Tool ^(RSAT^)
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Windows Remote Server Administration Tool (RSAT) Pack folder path according to selected Source OS
set "RSAT=%RSAT%\%SelectedSourceOS%"

:: Checking whether Windows Remote Server Administration Tool (RSAT) Pack file exist
if "%SelectedSourceOS%" equ "w7" if not exist "%RSAT%\Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%.cab" (
	echo.Remote Server Administration Tool Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\RSAT\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Remote Server Administration Tool (RSAT) for Streaming Media Services Pack file exist
if "%SelectedSourceOS%" equ "w7" if not exist "%RSAT%\Microsoft-Windows-MediaServer-Admin-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%.cab" (
	echo.Remote Server Administration Tool Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-MediaServer-Admin-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\RSAT\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Remote Server Administration Tool (RSAT) Pack file exist
if "%SelectedSourceOS%" equ "w81" if not exist "%RSAT%\Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%.cab" (
	echo.Remote Server Administration Tool Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%.cab"
	echo.
	echo.Please copy the above file to ^<Packs\RSAT\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Windows Remote Server Administration Tool (RSAT) Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%RSATType%" equ "v1609" if not exist "%RSAT%\10.0.14393\Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0.cab" (
	echo.Remote Server Administration Tool Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0.cab"
	echo.
	echo.Please copy the above file to ^<Packs\RSAT\%SelectedSourceOS%\10.0.14393^> folder...
	goto :Stop
)

:: Checking whether Windows Remote Server Administration Tool (RSAT) Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%RSATType%" equ "v1709" if not exist "%RSAT%\10.0.16299\Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15.cab" (
	echo.Remote Server Administration Tool Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15.cab"
	echo.
	echo.Please copy the above file to ^<Packs\RSAT\%SelectedSourceOS%\10.0.16299^> folder...
	goto :Stop
)

:: Checking whether Windows Remote Server Administration Tool (RSAT) Pack file exist
if "%SelectedSourceOS%" equ "w10" if "%RSATType%" equ "v1803" if not exist "%RSAT%\10.0.17134\Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1.cab" (
	echo.Remote Server Administration Tool Pack folder is missing the below file...
	echo.
	echo."Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1.cab"
	echo.
	echo.Please copy the above file to ^<Packs\RSAT\%SelectedSourceOS%\10.0.17134^> folder...
	goto :Stop
)
echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Remote Server Administration Tool ^(RSAT^)#######
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Remote Server Administration Tool ^(RSAT^)###############
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul
		
		:: Checking whether the selected Source OS is a valid editions
		if "%SelectedSourceOS%" equ "w7" (
			for /d %%j in (Professional,Ultimate) do (
				if "%ImageEdition%" equ "%%j" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows Remote Server Administration Tool ^(RSAT^) Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%RSAT%\Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%.cab"
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows RSAT for Streaming Media Services Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%RSAT%\Microsoft-Windows-MediaServer-Admin-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%.cab"
				)
			)
		)

		if "%SelectedSourceOS%" neq "w7" (
			for /d %%j in (Professional,Enterprise) do (
				if "%ImageEdition%" equ "%%j" (
					if "%SelectedSourceOS%" equ "w81" call :AddPackage "%InstallMount%\%%i", "%RSAT%\Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%.cab"

					if "%SelectedSourceOS%" equ "w10" (
						if "%RSATType%" equ "v1609" call :AddPackage "%InstallMount%\%%i", "%RSAT%\10.0.14393\Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0.cab"
						if "%RSATType%" equ "v1709" call :AddPackage "%InstallMount%\%%i", "%RSAT%\10.0.16299\Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15.cab"
						if "%RSATType%" equ "v1803" call :AddPackage "%InstallMount%\%%i", "%RSAT%\10.0.17134\Microsoft-Windows-RemoteServerAdministrationTools-Client-Package-TopLevel~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1.cab"
					)
				)
			)
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Remote Server Administration Tool ^(RSAT^)######
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set RSAT=
set RSATType=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG ToolKit - Integrate Microsoft Default Inbox Apps Menu
::-------------------------------------------------------------------------------------------
:IntInboxAppsMenu

cls
echo.===============================================================================
echo.          MSMG ToolKit - Integrate Microsoft Default Inbox Apps Menu
echo.===============================================================================
echo.
echo.  [1]   Select Windows Apps
echo.
echo.  [2]   Start Integrating Windows Apps
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.
choice /C:12X /N /M "Enter Your Choice : "
if errorlevel 3 goto :IntFeaturesMenu
if errorlevel 2 goto :IntInboxApps
if errorlevel 1 goto :SelectInboxAppsMenu

:SelectInboxAppsMenu
cls
echo.===============================================================================
echo.         MSMG ToolKit - Integrate Microsoft Default Inbox Apps Menu
echo.===============================================================================
:: Integrate Windows 8.1 Default Inbox Apps Menu
if "%SelectedSourceOS%" equ "w81" (
	echo.  [01] %I_Alarms% Alarms ^& Clock
	echo.  [02] %I_Calculator% Calculator
	echo.  [03] %I_CommunicationsApps% Calender, Mail ^& People
	echo.  [04] %I_BingFinance% Bing Finance
	echo.  [05] %I_BingFoodDrink% Bing Food ^& Drink
	echo.  [06] %I_BingHealthFitness% Bing Health ^& Fitness
	echo.  [07] %I_BingMaps% Bing Maps
	echo.  [08] %I_BingNews% Bing News
	echo.  [09] %I_BingSports% Bing Sports
	echo.  [10] %I_BingTravel% Bing Travel
	echo.  [11] %I_BingWeather% Bing Weather
	echo.  [12] %I_HelpAndTips% Help ^& Tips
	echo.  [13] %I_OfficeOneNote% Office OneNote
	echo.  [14] %I_Reader% Reader
	echo.  [15] %I_ReadingList% Reading List
	echo.  [16] %I_Scan% Scan
	echo.  [17] %I_SkypeApp% Skype
	echo.  [18] %I_SoundRecorder% Sound Recorder
	echo.  [19] %I_XboxLiveGames% Xbox LIVE Games
	echo.  [20] %I_ZuneMusic% Zune Music
	echo.  [21] %I_ZuneVideo% Zune Video
	echo.
	echo.  [A]    All Windows Apps
	echo.  [X]    Go Back
	echo.===============================================================================
	set /p MenuChoice=Enter Your Choice : 

	if "!MenuChoice!" equ "01" ( if "%I_Alarms%" equ "+" ( set "I_Alarms=-" ) else ( set "I_Alarms=+" ) )
	if "!MenuChoice!" equ "02" ( if "%I_Calculator%" equ "+" ( set "I_Calculator=-" ) else ( set "I_Calculator=+" ) )
	if "!MenuChoice!" equ "03" ( if "%I_CommunicationsApps%" equ "+" ( set "I_CommunicationsApps=-" ) else ( set "I_CommunicationsApps=+" ) )
	if "!MenuChoice!" equ "04" ( if "%I_BingFinance%" equ "+" ( set "I_BingFinance=-" ) else ( set "I_BingFinance=+" ) )
	if "!MenuChoice!" equ "05" ( if "%I_BingFoodDrink%" equ "+" ( set "I_BingFoodDrink=-" ) else ( set "I_BingFoodDrink=+" ) )
	if "!MenuChoice!" equ "06" ( if "%I_BingHealthFitness%" equ "+" ( set "I_BingHealthFitness=-" ) else ( set "I_BingHealthFitness=+" ) )
	if "!MenuChoice!" equ "07" ( if "%I_BingMaps%" equ "+" ( set "I_BingMaps=-" ) else ( set "I_BingMaps=+" ) )
	if "!MenuChoice!" equ "08" ( if "%I_BingNews%" equ "+" ( set "I_BingNews=-" ) else ( set "I_BingNews=+" ) )
	if "!MenuChoice!" equ "09" ( if "%I_BingSports%" equ "+" ( set "I_BingSports=-" ) else ( set "I_BingSports=+" ) )
	if "!MenuChoice!" equ "10" ( if "%I_BingTravel%" equ "+" ( set "I_BingTravel=-" ) else ( set "I_BingTravel=+" ) )
	if "!MenuChoice!" equ "11" ( if "%I_BingWeather%" equ "+" ( set "I_BingWeather=-" ) else ( set "I_BingWeather=+" ) )
	if "!MenuChoice!" equ "12" ( if "%I_HelpAndTips%" equ "+" ( set "I_HelpAndTips=-" ) else ( set "I_HelpAndTips=+" ) )
	if "!MenuChoice!" equ "13" ( if "%I_OfficeOneNote%" equ "+" ( set "I_OfficeOneNote=-" ) else ( set "I_OfficeOneNote=+" ) )
	if "!MenuChoice!" equ "14" ( if "%I_Reader%" equ "+" ( set "I_Reader=-" ) else ( set "I_Reader=+" ) )
	if "!MenuChoice!" equ "15" ( if "%I_ReadingList%" equ "+" ( set "I_ReadingList=-" ) else ( set "I_ReadingList=+" ) )
	if "!MenuChoice!" equ "16" ( if "%I_Scan%" equ "+" ( set "I_Scan=-" ) else ( set "I_Scan=+" ) )
	if "!MenuChoice!" equ "17" ( if "%I_SkypeApp%" equ "+" ( set "I_SkypeApp=-" ) else ( set "I_SkypeApp=+" ) )
	if "!MenuChoice!" equ "18" ( if "%I_SoundRecorder%" equ "+" ( set "I_SoundRecorder=-" ) else ( set "I_SoundRecorder=+" ) )
	if "!MenuChoice!" equ "19" ( if "%I_XboxLiveGames%" equ "+" ( set "I_XboxLiveGames=-" ) else ( set "I_XboxLiveGames=+" ) )
	if "!MenuChoice!" equ "20" ( if "%I_ZuneMusic%" equ "+" ( set "I_ZuneMusic=-" ) else ( set "I_ZuneMusic=+" ) )
	if "!MenuChoice!" equ "21" ( if "%I_ZuneVideo%" equ "+" ( set "I_ZuneVideo=-" ) else ( set "I_ZuneVideo=+" ) )

	if /i "!MenuChoice!" equ "A" (
		set "I_Alarms=+"
		set "I_Calculator=+"
		set "I_CommunicationsApps=+"
		set "I_BingFinance=+"
		set "I_BingFoodDrink=+"
		set "I_BingHealthFitness=+"
		set "I_BingMaps=+"
		set "I_BingNews=+"
		set "I_BingSports=+"
		set "I_BingTravel=+"
		set "I_BingWeather=+"
		set "I_HelpAndTips=+"
		set "I_OfficeOneNote=+"
		set "I_Reader=+"
		set "I_ReadingList=+"
		set "I_Scan=+"
		set "I_SkypeApp=+"
		set "I_SoundRecorder=+"
		set "I_XboxLiveGames=+"
		set "I_ZuneMusic=+"
		set "I_ZuneVideo=+"
	)
	if /i "!MenuChoice!" equ "X" goto :IntInboxAppsMenu
)

:: Integrate Windows 10 v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2 Default Inbox Apps Menu
if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "20348" (
	echo.  [01] %I_3DViewer% 3D Viewer
	echo.  [02] %I_Alarms% Alarms ^& Clock
	echo.  [03] %I_AV1VideoExtension% AOMedia Video 1 ^(AV1^) Codec Plugin
	echo.  [04] %I_Calculator% Calculator
	echo.  [05] %I_Camera% Camera
	echo.  [06] %I_Clipchamp% Clipchamp Video Editor
	if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "19045" echo.  [07] %I_Cortana% Cortana
	echo.  [08] %I_DesktopAppInstaller% Desktop App Installer
	echo.  [09] %I_DirectXRuntime% DirectX Runtime
	echo.  [10] %I_FeedbackHub% Feedback Hub
	if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "18363" echo.  [11] %I_ZuneVideo% Films ^& TV
	echo.  [12] %I_GetHelp% Get Help
	echo.  [13] %I_VP9VideoExtensions% Google's VP9 WebM Video Codec Plugin
	echo.  [14] %I_ZuneMusic% Groove Music
	echo.  [15] %I_HEIFImageExtension% High Efficiency Image File ^(HEIF^) Codec Plugin
	echo.  [16] %I_HEVCVideoExtension% High Efficiency Video Coding ^(HEVC^) Codec Plugin
	if "%ImageBuild%" geq "19042" if "%ImageBuild%" leq "20348" echo.  [17] %I_Journal% Journal
	echo.  [18] %I_Maps% Maps
	if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "18363" echo.  [19] %I_Messaging% Messaging
	echo.  [20] %I_MPEG2VideoExtension% MPEG-2 Video Codec Plugin
	echo.  [21] %I_Wallet% Microsoft Pay
	echo.  [22] %I_MicrosoftPowerBI% Microsoft Power BI
	if "%ImageArchitecture%" equ "x64" echo.  [23] %I_MixedRealityPortal% Mixed Reality Portal
	echo.  [24] %I_MinecraftEducationEdition% Minecraft Education Edition
	if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "18363" echo.  [25] %I_OneConnect% Mobile Plans
	if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "20348" echo.  [26] %I_ZuneVideo% Movies ^& TV
	echo.  [27] %I_OfficeHub% My Office
	echo.  [28] %I_BingNews% News
	echo.  [29] %I_OfficeOneNote% OneNote
	if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "20348" echo.  [30] %I_D3DMappingLayers% OpenCL ^& OpenGL Compatibility Pack
	echo.  [31] %I_Paint3D% Paint 3D
	echo.  [32] %I_People% People
	echo.  [33] %I_YourPhone% Phone Link
	echo.  [34] %I_Photos% Photos
	if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "18363" echo.  [35] %I_Print3D% Print 3D
	if "%ImageBuild%" geq "18362" if "%ImageBuild%" leq "20348" echo.  [36] %I_RawImageExtension% Raw Image Extension
	echo.  [37] %I_ScreenSketch% Snip ^& Sketch
	echo.  [38] %I_SkypeApp% Skype
	echo.  [39] %I_SolitaireCollection% Solitaire Collection
	echo.  [40] %I_StickyNotes% Sticky Notes
	echo.  [41] %I_StorePurchaseApp% Store Experience Host
	if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "20348" echo.  [42] %I_Terminal% Terminal
	echo.  [43] %I_Getstarted% Tips - Windows tips and tutorials for beginners
	echo.  [44] %I_Todos% Todos
	echo.  [45] %I_SoundRecorder% Voice Recorder
	echo.  [46] %I_BingWeather% Weather
	echo.  [47] %I_WebMediaExtensions% Web Media Codec Plugin
	echo.  [48] %I_WebpImageExtension% WebP Image Codec Plugin
	echo.  [49] %I_Whiteboard% Whiteboard
	echo.  [50] %I_CommunicationsApps% Windows Mail
	echo.  [51] %I_WindowsStore% Windows Store
	echo.  [52] %I_XboxTCUI% Xbox UI ^(Xbox TCUI^)
	echo.  [53] %I_Xbox% Xbox Console Companion ^(Xbox App^)
	echo.  [54] %I_XboxGameOverlay% Xbox Game Bar Plugin ^(Xbox Game Overlay^)
	echo.  [55] %I_XboxGamingOverlay% Xbox Game Bar ^(Xbox Gaming Overlay^)
	echo.  [56] %I_XboxIdentityProvider% Xbox Identity Provider
	echo.  [57] %I_XboxSpeechToTextOverlay% Xbox Game Speech Window ^(Xbox Speech To TextOverlay^)
	echo.
	echo.  [58] %I_AMDLink% AMD Link
	echo.  [59] %I_HPSupportAssistant% HP Support Assistant 9
	echo.  [60] %I_IntelGraphicsCommandCenter% Intel Graphics Command Center
	echo.  [61] %I_IntelThunderboltController% Intel Thunderbolt Controller
	echo.  [62] %I_KillerControlCenter% Rivet Networks Killer Control Center
	echo.  [63] %I_NVIDIAControlPanel% NVIDIA Control Panel
	echo.  [64] %I_RealtekAudioControl% Realtek Audio Console
	echo.  [65] %I_WavesMaxxAudioProforDell% Waves MaxxAudio Pro for Dell 2020
	echo.
	echo.  [A]    All Inbox Apps
	echo.  [X]    Go Back
	echo.===============================================================================
	set /p MenuChoice=Enter Your Choice : 

	if "!MenuChoice!" equ "01" ( if "%I_3DViewer%" equ "+" ( set "I_3DViewer=-" ) else ( set "I_3DViewer=+" ) )
	if "!MenuChoice!" equ "02" ( if "%I_Alarms%" equ "+" ( set "I_Alarms=-" ) else ( set "I_Alarms=+" ) )
	if "!MenuChoice!" equ "03" ( if "%I_AV1VideoExtension%" equ "+" ( set "I_AV1VideoExtension=-" ) else ( set "I_AV1VideoExtension=+" ) )
	if "!MenuChoice!" equ "04" ( if "%I_Calculator%" equ "+" ( set "I_Calculator=-" ) else ( set "I_Calculator=+" ) )
	if "!MenuChoice!" equ "05" ( if "%I_Camera%" equ "+" ( set "I_Camera=-" ) else ( set "I_Camera=+" ) )
	if "!MenuChoice!" equ "06" ( if "%I_Clipchamp%" equ "+" ( set "I_Clipchamp=-" ) else ( set "I_Clipchamp=+" ) )
	if "!MenuChoice!" equ "07" if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "19045" ( if "%I_Cortana%" equ "+" ( set "I_Cortana=-" ) else ( set "I_Cortana=+" ) )
	if "!MenuChoice!" equ "08" ( if "%I_DesktopAppInstaller%" equ "+" ( set "I_DesktopAppInstaller=-" ) else ( set "I_DesktopAppInstaller=+" ) )
	if "!MenuChoice!" equ "09" ( if "%I_DirectXRuntime%" equ "+" ( set "I_DirectXRuntime=-" ) else ( set "I_DirectXRuntime=+" ) )
	if "!MenuChoice!" equ "10" ( if "%I_FeedbackHub%" equ "+" ( set "I_FeedbackHub=-" ) else ( set "I_FeedbackHub=+" ) )
	if "!MenuChoice!" equ "11" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "18363" ( if "%I_ZuneVideo%" equ "+" ( set "I_ZuneVideo=-" ) else ( set "I_ZuneVideo=+" ) )
	if "!MenuChoice!" equ "12" ( if "%I_GetHelp%" equ "+" ( set "I_GetHelp=-" ) else ( set "I_GetHelp=+" ) )
	if "!MenuChoice!" equ "13" ( if "%I_VP9VideoExtensions%" equ "+" ( set "I_VP9VideoExtensions=-" ) else ( set "I_VP9VideoExtensions=+" ) )
	if "!MenuChoice!" equ "14" ( if "%I_ZuneMusic%" equ "+" ( set "I_ZuneMusic=-" ) else ( set "I_ZuneMusic=+" ) )
	if "!MenuChoice!" equ "15" ( if "%I_HEIFImageExtension%" equ "+" ( set "I_HEIFImageExtension=-" ) else ( set "I_HEIFImageExtension=+" ) )
	if "!MenuChoice!" equ "16" ( if "%I_HEVCVideoExtension%" equ "+" ( set "I_HEVCVideoExtension=-" ) else ( set "I_HEVCVideoExtension=+" ) )
	if "!MenuChoice!" equ "17" if "%ImageBuild%" geq "19042" if "%ImageBuild%" leq "20348" ( if "%I_Journal%" equ "+" ( set "I_Journal=-" ) else ( set "I_Journal=+" ) )
	if "!MenuChoice!" equ "18" ( if "%I_Maps%" equ "+" ( set "I_Maps=-" ) else ( set "I_Maps=+" ) )
	if "!MenuChoice!" equ "19" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "18363" ( if "%I_Messaging%" equ "+" ( set "I_Messaging=-" ) else ( set "I_Messaging=+" ) )
	if "!MenuChoice!" equ "20" ( if "%I_MPEG2VideoExtension%" equ "+" ( set "I_MPEG2VideoExtension=-" ) else ( set "I_MPEG2VideoExtension=+" ) )
	if "!MenuChoice!" equ "21" ( if "%I_Wallet%" equ "+" ( set "I_Wallet=-" ) else ( set "I_Wallet=+" ) )
	if "!MenuChoice!" equ "22" ( if "%I_MicrosoftPowerBI%" equ "+" ( set "I_MicrosoftPowerBI=-" ) else ( set "I_MicrosoftPowerBI=+" ) )
	if "!MenuChoice!" equ "23" if "%ImageArchitecture%" equ "x64" ( if "%I_MixedRealityPortal%" equ "+" ( set "I_MixedRealityPortal=-" ) else ( set "I_MixedRealityPortal=+" ) )
	if "!MenuChoice!" equ "24" ( if "%I_MinecraftEducationEdition%" equ "+" ( set "I_MinecraftEducationEdition=-" ) else ( set "I_MinecraftEducationEdition=+" ) )
	if "!MenuChoice!" equ "25" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "18363" ( if "%I_OneConnect%" equ "+" ( set "I_OneConnect=-" ) else ( set "I_OneConnect=+" ) )
	if "!MenuChoice!" equ "26" if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "20348" ( if "%I_ZuneVideo%" equ "+" ( set "I_ZuneVideo=-" ) else ( set "I_ZuneVideo=+" ) )
	if "!MenuChoice!" equ "27" ( if "%I_OfficeHub%" equ "+" ( set "I_OfficeHub=-" ) else ( set "I_OfficeHub=+" ) )
	if "!MenuChoice!" equ "28" ( if "%I_BingNews%" equ "+" ( set "I_BingNews=-" ) else ( set "I_BingNews=+" ) )
	if "!MenuChoice!" equ "29" ( if "%I_OfficeOneNote%" equ "+" ( set "I_OfficeOneNote=-" ) else ( set "I_OfficeOneNote=+" ) )
	if "!MenuChoice!" equ "30" if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "20348" ( if "%I_D3DMappingLayers%" equ "+" ( set "I_D3DMappingLayers=-" ) else ( set "I_D3DMappingLayers=+" ) )
	if "!MenuChoice!" equ "31" ( if "%I_Paint3D%" equ "+" ( set "I_Paint3D=-" ) else ( set "I_Paint3D=+" ) )
	if "!MenuChoice!" equ "32" ( if "%I_People%" equ "+" ( set "I_People=-" ) else ( set "I_People=+" ) )
	if "!MenuChoice!" equ "33" ( if "%I_YourPhone%" equ "+" ( set "I_YourPhone=-" ) else ( set "I_YourPhone=+" ) )
	if "!MenuChoice!" equ "34" ( if "%I_Photos%" equ "+" ( set "I_Photos=-" ) else ( set "I_Photos=+" ) )
	if "!MenuChoice!" equ "35" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "18363" ( if "%I_Print3D%" equ "+" ( set "I_Print3D=-" ) else ( set "I_Print3D=+" ) )
	if "!MenuChoice!" equ "36" if "%ImageBuild%" geq "18362" if "%ImageBuild%" leq "20348" ( if "%I_RawImageExtension%" equ "+" ( set "I_RawImageExtension=-" ) else ( set "I_RawImageExtension=+" ) )
	if "!MenuChoice!" equ "37" ( if "%I_ScreenSketch%" equ "+" ( set "I_ScreenSketch=-" ) else ( set "I_ScreenSketch=+" ) )
	if "!MenuChoice!" equ "38" ( if "%I_SkypeApp%" equ "+" ( set "I_SkypeApp=-" ) else ( set "I_SkypeApp=+" ) )
	if "!MenuChoice!" equ "39" ( if "%I_SolitaireCollection%" equ "+" ( set "I_SolitaireCollection=-" ) else ( set "I_SolitaireCollection=+" ) )
	if "!MenuChoice!" equ "40" ( if "%I_StickyNotes%" equ "+" ( set "I_StickyNotes=-" ) else ( set "I_StickyNotes=+" ) )
	if "!MenuChoice!" equ "41" ( if "%I_StorePurchaseApp%" equ "+" ( set "I_StorePurchaseApp=-" ) else ( set "I_StorePurchaseApp=+" ) )
	if "!MenuChoice!" equ "42" if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "20348" ( if "%I_Terminal%" equ "+" ( set "I_Terminal=-" ) else ( set "I_Terminal=+" ) )
	if "!MenuChoice!" equ "43" ( if "%I_Getstarted%" equ "+" ( set "I_Getstarted=-" ) else ( set "I_Getstarted=+" ) )
	if "!MenuChoice!" equ "44" ( if "%I_Todos%" equ "+" ( set "I_Todos=-" ) else ( set "I_Todos=+" ) )
	if "!MenuChoice!" equ "45" ( if "%I_SoundRecorder%" equ "+" ( set "I_SoundRecorder=-" ) else ( set "I_SoundRecorder=+" ) )
	if "!MenuChoice!" equ "46" ( if "%I_BingWeather%" equ "+" ( set "I_BingWeather=-" ) else ( set "I_BingWeather=+" ) )
	if "!MenuChoice!" equ "47" ( if "%I_WebMediaExtensions%" equ "+" ( set "I_WebMediaExtensions=-" ) else ( set "I_WebMediaExtensions=+" ) )
	if "!MenuChoice!" equ "48" ( if "%I_WebpImageExtension%" equ "+" ( set "I_WebpImageExtension=-" ) else ( set "I_WebpImageExtension=+" ) )
	if "!MenuChoice!" equ "49" ( if "%I_Whiteboard%" equ "+" ( set "I_Whiteboard=-" ) else ( set "I_Whiteboard=+" ) )
	if "!MenuChoice!" equ "50" ( if "%I_CommunicationsApps%" equ "+" ( set "I_CommunicationsApps=-" ) else ( set "I_CommunicationsApps=+" ) )
	if "!MenuChoice!" equ "51" ( if "%I_WindowsStore%" equ "+" ( set "I_WindowsStore=-" ) else ( set "I_WindowsStore=+" ) )
	if "!MenuChoice!" equ "52" ( if "%I_XboxTCUI%" equ "+" ( set "I_XboxTCUI=-" ) else ( set "I_XboxTCUI=+" ) )
	if "!MenuChoice!" equ "53" ( if "%I_Xbox%" equ "+" ( set "I_Xbox=-" ) else ( set "I_Xbox=+" ) )
	if "!MenuChoice!" equ "54" ( if "%I_XboxGameOverlay%" equ "+" ( set "I_XboxGameOverlay=-" ) else ( set "I_XboxGameOverlay=+" ) )
	if "!MenuChoice!" equ "55" ( if "%I_XboxGamingOverlay%" equ "+" ( set "I_XboxGamingOverlay=-" ) else ( set "I_XboxGamingOverlay=+" ) )
	if "!MenuChoice!" equ "56" ( if "%I_XboxIdentityProvider%" equ "+" ( set "I_XboxIdentityProvider=-" ) else ( set "I_XboxIdentityProvider=+" ) )
	if "!MenuChoice!" equ "57" ( if "%I_XboxSpeechToTextOverlay%" equ "+" ( set "I_XboxSpeechToTextOverlay=-" ) else ( set "I_XboxSpeechToTextOverlay=+" ) )

	if "!MenuChoice!" equ "58" ( if "%I_AMDLink%" equ "+" ( set "I_AMDLink=-" ) else ( set "I_AMDLink=+" ) )
	if "!MenuChoice!" equ "59" ( if "%I_HPSupportAssistant%" equ "+" ( set "I_HPSupportAssistant=-" ) else ( set "I_HPSupportAssistant=+" ) )
	if "!MenuChoice!" equ "60" ( if "%I_IntelGraphicsCommandCenter%" equ "+" ( set "I_IntelGraphicsCommandCenter=-" ) else ( set "I_IntelGraphicsCommandCenter=+" ) )
	if "!MenuChoice!" equ "61" ( if "%I_IntelThunderboltController%" equ "+" ( set "I_IntelThunderboltController=-" ) else ( set "I_IntelThunderboltController=+" ) )
	if "!MenuChoice!" equ "62" ( if "%I_KillerControlCenter%" equ "+" ( set "I_KillerControlCenter=-" ) else ( set "I_KillerControlCenter=+" ) )
	if "!MenuChoice!" equ "63" ( if "%I_NVIDIAControlPanel%" equ "+" ( set "I_NVIDIAControlPanel=-" ) else ( set "I_NVIDIAControlPanel=+" ) )
	if "!MenuChoice!" equ "64" ( if "%I_RealtekAudioControl%" equ "+" ( set "I_RealtekAudioControl=-" ) else ( set "I_RealtekAudioControl=+" ) )
	if "!MenuChoice!" equ "65" ( if "%I_WavesMaxxAudioProforDell%" equ "+" ( set "I_WavesMaxxAudioProforDell=-" ) else ( set "I_WavesMaxxAudioProforDell=+" ) )

	if /i "!MenuChoice!" equ "A" (
		set "I_3DViewer=+"
		set "I_Alarms=+"
		set "I_AV1VideoExtension=+"
		set "I_BingWeather=+"
		set "I_BingNews=+"
		set "I_Calculator=+"
		set "I_Camera=+"
		set "I_Clipchamp=+"
		set "I_CommunicationsApps=+"
		if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "19045" set "I_Cortana=+"
		if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "20348" set "I_D3DMappingLayers=+"
		set "I_DesktopAppInstaller=+"
		set "I_DirectXRuntime=+"
		set "I_FeedbackHub=+"
		set "I_GetHelp=+"
		set "I_Getstarted=+"
		set "I_HEIFImageExtension=+"
		set "I_HEVCVideoExtension=+"
		if "%ImageBuild%" geq "19042" if "%ImageBuild%" leq "20348" set "I_Journal=+"
		set "I_Maps=+"
		if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "18363" set "I_Messaging=+"
		set "I_MicrosoftPowerBI=+"
		set "I_MinecraftEducationEdition=+"
		if "%ImageArchitecture%" equ "x64" set "I_MixedRealityPortal=+"
		set "I_MPEG2VideoExtension=+"
		set "I_OfficeHub=+"
		set "I_OfficeOneNote=+"
		if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "18363" set "I_OneConnect=+"
		set "I_Paint3D=+"
		set "I_People=+"
		set "I_Photos=+"
		if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "18363" set "I_Print3D=+"
		if "%ImageBuild%" geq "18362" if "%ImageBuild%" leq "20348" set "I_RawImageExtension=+"
		set "I_ScreenSketch=+"
		set "I_SkypeApp=+"
		set "I_SolitaireCollection=+"
		set "I_StickyNotes=+"
		set "I_StorePurchaseApp=+"
		set "I_SoundRecorder=+"
		if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "20348" set "I_Terminal=+"
		set "I_Todos=+"
		set "I_VP9VideoExtensions=+"
		set "I_Wallet=+"
		set "I_WebMediaExtensions=+"
		set "I_WebpImageExtension=+"
		set "I_Whiteboard=+"
		set "I_WindowsStore=+"
		set "I_Xbox=+"
		set "I_XboxGameOverlay=+"
		set "I_XboxGamingOverlay=+"
		set "I_XboxIdentityProvider=+"
		set "I_XboxSpeechToTextOverlay=+"
		set "I_XboxTCUI=+"
		set "I_YourPhone=+"
		set "I_ZuneMusic=+"
		set "I_ZuneVideo=+"

		set "I_AMDLink=+"
		set "I_HPSupportAssistant=+"
		set "I_IntelGraphicsCommandCenter=+"
		set "I_IntelThunderboltController=+"
		set "I_KillerControlCenter=+"
		set "I_NVIDIAControlPanel=+"
		set "I_RealtekAudioControl=+"
		set "I_WavesMaxxAudioProforDell=+"
	)
	if /i "!MenuChoice!" equ "X" goto :IntInboxAppsMenu
)

:: Integrate Windows 11 v21H2/v22H2 Default Inbox Apps Menu
if "%SelectedSourceOS%" equ "w11" if "%ImageBuild%" geq "22000" (
	echo.  [01] %I_Alarms% Alarms ^& Clock
	echo.  [02] %I_AV1VideoExtension% AOMedia Video 1 ^(AV1^) Codec Plugin
	echo.  [03] %I_AmazonAppStore% Amazon App Store
	echo.  [04] %I_Calculator% Calculator
	echo.  [05] %I_Camera% Camera
	echo.  [06] %I_Clipchamp% Clipchamp Video Editor
	echo.  [07] %I_Cortana% Cortana
	echo.  [08] %I_DesktopAppInstaller% Desktop App Installer
	echo.  [09] %I_DirectXRuntime% DirectX Runtime
	echo.  [10] %I_FeedbackHub% Feedback Hub
	echo.  [11] %I_ZuneVideo% Films ^& TV	
	echo.  [12] %I_GamingApp% Gaming App ^(Xbox App^) ^| Depends on  DirectX Runtime, Gaming Services
	echo.  [13] %I_GamingServices% Gaming Services
	echo.  [14] %I_GetHelp% Get Help
	echo.  [15] %I_VP9VideoExtensions% Google's VP9 WebM Video Codec Plugin
	echo.  [16] %I_HEIFImageExtension% High Efficiency Image File ^(HEIF^) Codec Plugin
	echo.  [17] %I_HEVCVideoExtension% High Efficiency Video Coding ^(HEVC^) Codec Plugin
	echo.  [18] %I_Journal% Journal
	echo.  [19] %I_Maps% Maps
	echo.  [20] %I_ZuneMusic% Media Player
	echo.  [21] %I_MPEG2VideoExtension% MPEG-2 Video Codec Plugin
	echo.  [22] %I_MicrosoftPowerBI% Microsoft Power BI
	echo.  [23] %I_MinecraftEducationEdition% Minecraft Education Edition
	echo.  [24] %I_OfficeHub% My Office
	echo.  [25] %I_BingNews% News
	echo.  [26] %I_Notepad% Notepad App
	echo.  [27] %I_D3DMappingLayers% OpenCL ^& OpenGL Compatibility Pack
	echo.  [28] %I_Paint% Paint
	echo.  [29] %I_People% People
	echo.  [30] %I_YourPhone% Phone Link
	echo.  [31] %I_Photos% Photos
	echo.  [32] %I_PowerAutomateDesktop% Power Automate Desktop
	if "%ImageBuild%" geq "22621" echo.  [33] %I_QuickAssist% Quick Assist
	echo.  [34] %I_RawImageExtension% Raw Image Extension
	echo.  [35] %I_ScreenSketch% Snipping Tool App
	echo.  [36] %I_SolitaireCollection% Solitaire Collection
	echo.  [37] %I_StickyNotes% Sticky Notes
	echo.  [38] %I_StorePurchaseApp% Store Experience Host
	echo.  [39] %I_TeamsChat% Teams Chat
	echo.  [40] %I_Terminal% Terminal
	echo.  [41] %I_Getstarted% Tips
	echo.  [42] %I_Todos% Todos
	echo.  [43] %I_SoundRecorder% Voice Recorder
	echo.  [44] %I_BingWeather% Weather
	echo.  [45] %I_WebMediaExtensions% Web Media Codec Plugin
	echo.  [46] %I_WebpImageExtension% WebP Image Codec Plugin
	echo.  [47] %I_Whiteboard% Whiteboard
	echo.  [48] %I_ClientWebExperience% Windows Web Experience Pack - News ^& Interests Widgets App
	echo.  [49] %I_WindowsDefender% Windows Defender Dashboard
	echo.  [50] %I_CommunicationsApps% Windows Mail
	echo.  [51] %I_WindowsStore% Windows Store
	echo.  [52] %I_WindowsSubsystemForAndroid% Windows Subsystem For Android ^(WSA^)
	echo.  [53] %I_WindowsSubsystemForLinux% Windows Subsystem For Linux ^(WSL^)
	echo.  [54] %I_XboxTCUI% Xbox UI ^(Xbox TCUI^)
	echo.  [55] %I_Xbox% Xbox Console Companion ^(Xbox App^)
	echo.  [56] %I_XboxGameOverlay% Xbox Game Bar Plugin ^(Xbox Game Overlay^)
	echo.  [57] %I_XboxGamingOverlay% Xbox Game Bar ^(Xbox Gaming Overlay^)
	echo.  [58] %I_XboxIdentityProvider% Xbox Identity Provider
	echo.  [59] %I_XboxSpeechToTextOverlay% Xbox Game Speech Window ^(Xbox Speech To TextOverlay^)
	echo.
	echo.  [60] %I_AMDLink% AMD Link
	echo.  [61] %I_HPSupportAssistant% HP Support Assistant 9
	echo.  [62] %I_IntelGraphicsCommandCenter% Intel Graphics Command Center
	echo.  [63] %I_IntelThunderboltController% Intel Thunderbolt Controller
	echo.  [64] %I_KillerControlCenter% Rivet Networks Killer Control Center
	echo.  [65] %I_NVIDIAControlPanel% NVIDIA Control Panel
	echo.  [66] %I_RealtekAudioControl% Realtek Audio Console
	echo.  [67] %I_WavesMaxxAudioProforDell% Waves MaxxAudio Pro for Dell 2020
	echo.
	echo.  [A]    All Inbox Apps
	echo.  [X]    Go Back
	echo.===============================================================================
	set /p MenuChoice=Enter Your Choice : 

	if "!MenuChoice!" equ "01" ( if "%I_Alarms%" equ "+" ( set "I_Alarms=-" ) else ( set "I_Alarms=+" ) )
	if "!MenuChoice!" equ "02" ( if "%I_AV1VideoExtension%" equ "+" ( set "I_AV1VideoExtension=-" ) else ( set "I_AV1VideoExtension=+" ) )
	if "!MenuChoice!" equ "03" ( if "%I_AmazonAppStore%" equ "+" ( set "I_AmazonAppStore=-" ) else ( set "I_AmazonAppStore=+" ) )
	if "!MenuChoice!" equ "04" ( if "%I_Calculator%" equ "+" ( set "I_Calculator=-" ) else ( set "I_Calculator=+" ) )
	if "!MenuChoice!" equ "05" ( if "%I_Camera%" equ "+" ( set "I_Camera=-" ) else ( set "I_Camera=+" ) )
	if "!MenuChoice!" equ "06" ( if "%I_Clipchamp%" equ "+" ( set "I_Clipchamp=-" ) else ( set "I_Clipchamp=+" ) )
	if "!MenuChoice!" equ "07" ( if "%I_Cortana%" equ "+" ( set "I_Cortana=-" ) else ( set "I_Cortana=+" ) )
	if "!MenuChoice!" equ "08" ( if "%I_DesktopAppInstaller%" equ "+" ( set "I_DesktopAppInstaller=-" ) else ( set "I_DesktopAppInstaller=+" ) )
	if "!MenuChoice!" equ "09" ( if "%I_DirectXRuntime%" equ "+" ( set "I_DirectXRuntime=-" ) else ( set "I_DirectXRuntime=+" ) )
	if "!MenuChoice!" equ "10" ( if "%I_FeedbackHub%" equ "+" ( set "I_FeedbackHub=-" ) else ( set "I_FeedbackHub=+" ) )
	if "!MenuChoice!" equ "11" ( if "%I_ZuneVideo%" equ "+" ( set "I_ZuneVideo=-" ) else ( set "I_ZuneVideo=+" ) )
	if "!MenuChoice!" equ "12" ( if "%I_GamingApp%" equ "+" ( set "I_GamingApp=-" ) else ( set "I_GamingApp=+" ) )
	if "!MenuChoice!" equ "13" ( if "%I_GamingServices%" equ "+" ( set "I_GamingServices=-" ) else ( set "I_GamingServices=+" ) )
	if "!MenuChoice!" equ "14" ( if "%I_GetHelp%" equ "+" ( set "I_GetHelp=-" ) else ( set "I_GetHelp=+" ) )
	if "!MenuChoice!" equ "15" ( if "%I_VP9VideoExtensions%" equ "+" ( set "I_VP9VideoExtensions=-" ) else ( set "I_VP9VideoExtensions=+" ) )
	if "!MenuChoice!" equ "16" ( if "%I_HEIFImageExtension%" equ "+" ( set "I_HEIFImageExtension=-" ) else ( set "I_HEIFImageExtension=+" ) )
	if "!MenuChoice!" equ "17" ( if "%I_HEVCVideoExtension%" equ "+" ( set "I_HEVCVideoExtension=-" ) else ( set "I_HEVCVideoExtension=+" ) )
	if "!MenuChoice!" equ "18" ( if "%I_Journal%" equ "+" ( set "I_Journal=-" ) else ( set "I_Journal=+" ) )
	if "!MenuChoice!" equ "19" ( if "%I_Maps%" equ "+" ( set "I_Maps=-" ) else ( set "I_Maps=+" ) )
	if "!MenuChoice!" equ "20" ( if "%I_ZuneMusic%" equ "+" ( set "I_ZuneMusic=-" ) else ( set "I_ZuneMusic=+" ) )
	if "!MenuChoice!" equ "21" ( if "%I_MPEG2VideoExtension%" equ "+" ( set "I_MPEG2VideoExtension=-" ) else ( set "I_MPEG2VideoExtension=+" ) )
	if "!MenuChoice!" equ "22" ( if "%I_MicrosoftPowerBI%" equ "+" ( set "I_MicrosoftPowerBI=-" ) else ( set "I_MicrosoftPowerBI=+" ) )
	if "!MenuChoice!" equ "23" ( if "%I_MinecraftEducationEdition%" equ "+" ( set "I_MinecraftEducationEdition=-" ) else ( set "I_MinecraftEducationEdition=+" ) )
	if "!MenuChoice!" equ "24" ( if "%I_OfficeHub%" equ "+" ( set "I_OfficeHub=-" ) else ( set "I_OfficeHub=+" ) )
	if "!MenuChoice!" equ "25" ( if "%I_BingNews%" equ "+" ( set "I_BingNews=-" ) else ( set "I_BingNews=+" ) )
	if "!MenuChoice!" equ "26" ( if "%I_Notepad%" equ "+" ( set "I_Notepad=-" ) else ( set "I_Notepad=+" ) )
	if "!MenuChoice!" equ "27" ( if "%I_D3DMappingLayers%" equ "+" ( set "I_D3DMappingLayers=-" ) else ( set "I_D3DMappingLayers=+" ) )
	if "!MenuChoice!" equ "28" ( if "%I_Paint%" equ "+" ( set "I_Paint=-" ) else ( set "I_Paint=+" ) )
	if "!MenuChoice!" equ "29" ( if "%I_People%" equ "+" ( set "I_People=-" ) else ( set "I_People=+" ) )
	if "!MenuChoice!" equ "30" ( if "%I_YourPhone%" equ "+" ( set "I_YourPhone=-" ) else ( set "I_YourPhone=+" ) )
	if "!MenuChoice!" equ "31" ( if "%I_Photos%" equ "+" ( set "I_Photos=-" ) else ( set "I_Photos=+" ) )
	if "!MenuChoice!" equ "32" ( if "%I_PowerAutomateDesktop%" equ "+" ( set "I_PowerAutomateDesktop=-" ) else ( set "I_PowerAutomateDesktop=+" ) )
	if "!MenuChoice!" equ "33" if "%ImageBuild%" gtr "20000" ( if "%I_QuickAssist%" equ "+" ( set "I_QuickAssist=-" ) else ( set "I_QuickAssist=+" ) )
	if "!MenuChoice!" equ "34" ( if "%I_RawImageExtension%" equ "+" ( set "I_RawImageExtension=-" ) else ( set "I_RawImageExtension=+" ) )
	if "!MenuChoice!" equ "35" ( if "%I_ScreenSketch%" equ "+" ( set "I_ScreenSketch=-" ) else ( set "I_ScreenSketch=+" ) )
	if "!MenuChoice!" equ "36" ( if "%I_SolitaireCollection%" equ "+" ( set "I_SolitaireCollection=-" ) else ( set "I_SolitaireCollection=+" ) )
	if "!MenuChoice!" equ "37" ( if "%I_StickyNotes%" equ "+" ( set "I_StickyNotes=-" ) else ( set "I_StickyNotes=+" ) )
	if "!MenuChoice!" equ "38" ( if "%I_StorePurchaseApp%" equ "+" ( set "I_StorePurchaseApp=-" ) else ( set "I_StorePurchaseApp=+" ) )
	if "!MenuChoice!" equ "39" ( if "%I_TeamsChat%" equ "+" ( set "I_TeamsChat=-" ) else ( set "I_TeamsChat=+" ) )
	if "!MenuChoice!" equ "40" ( if "%I_Terminal%" equ "+" ( set "I_Terminal=-" ) else ( set "I_Terminal=+" ) )
	if "!MenuChoice!" equ "41" ( if "%I_Getstarted%" equ "+" ( set "I_Getstarted=-" ) else ( set "I_Getstarted=+" ) )
	if "!MenuChoice!" equ "42" ( if "%I_Todos%" equ "+" ( set "I_Todos=-" ) else ( set "I_Todos=+" ) )
	if "!MenuChoice!" equ "43" ( if "%I_SoundRecorder%" equ "+" ( set "I_SoundRecorder=-" ) else ( set "I_SoundRecorder=+" ) )
	if "!MenuChoice!" equ "44" ( if "%I_BingWeather%" equ "+" ( set "I_BingWeather=-" ) else ( set "I_BingWeather=+" ) )
	if "!MenuChoice!" equ "45" ( if "%I_WebMediaExtensions%" equ "+" ( set "I_WebMediaExtensions=-" ) else ( set "I_WebMediaExtensions=+" ) )
	if "!MenuChoice!" equ "46" ( if "%I_WebpImageExtension%" equ "+" ( set "I_WebpImageExtension=-" ) else ( set "I_WebpImageExtension=+" ) )
	if "!MenuChoice!" equ "47" ( if "%I_Whiteboard%" equ "+" ( set "I_Whiteboard=-" ) else ( set "I_Whiteboard=+" ) )
	if "!MenuChoice!" equ "48" ( if "%I_ClientWebExperience%" equ "+" ( set "I_ClientWebExperience=-" ) else ( set "I_ClientWebExperience=+" ) )
	if "!MenuChoice!" equ "49" ( if "%I_WindowsDefender%" equ "+" ( set "I_WindowsDefender=-" ) else ( set "I_WindowsDefender=+" ) )
	if "!MenuChoice!" equ "50" ( if "%I_CommunicationsApps%" equ "+" ( set "I_CommunicationsApps=-" ) else ( set "I_CommunicationsApps=+" ) )
	if "!MenuChoice!" equ "51" ( if "%I_WindowsStore%" equ "+" ( set "I_WindowsStore=-" ) else ( set "I_WindowsStore=+" ) )
	if "!MenuChoice!" equ "52" ( if "%I_WindowsSubsystemForAndroid%" equ "+" ( set "I_WindowsSubsystemForAndroid=-" ) else ( set "I_WindowsSubsystemForAndroid=+" ) )
	if "!MenuChoice!" equ "53" ( if "%I_WindowsSubsystemForLinux%" equ "+" ( set "I_WindowsSubsystemForLinux=-" ) else ( set "I_WindowsSubsystemForLinux=+" ) )
	if "!MenuChoice!" equ "54" ( if "%I_XboxTCUI%" equ "+" ( set "I_XboxTCUI=-" ) else ( set "I_XboxTCUI=+" ) )
	if "!MenuChoice!" equ "55" ( if "%I_Xbox%" equ "+" ( set "I_Xbox=-" ) else ( set "I_Xbox=+" ) )
	if "!MenuChoice!" equ "56" ( if "%I_XboxGameOverlay%" equ "+" ( set "I_XboxGameOverlay=-" ) else ( set "I_XboxGameOverlay=+" ) )
	if "!MenuChoice!" equ "57" ( if "%I_XboxGamingOverlay%" equ "+" ( set "I_XboxGamingOverlay=-" ) else ( set "I_XboxGamingOverlay=+" ) )
	if "!MenuChoice!" equ "58" ( if "%I_XboxIdentityProvider%" equ "+" ( set "I_XboxIdentityProvider=-" ) else ( set "I_XboxIdentityProvider=+" ) )
	if "!MenuChoice!" equ "59" ( if "%I_XboxSpeechToTextOverlay%" equ "+" ( set "I_XboxSpeechToTextOverlay=-" ) else ( set "I_XboxSpeechToTextOverlay=+" ) )

	if "!MenuChoice!" equ "60" ( if "%I_AMDLink%" equ "+" ( set "I_AMDLink=-" ) else ( set "I_AMDLink=+" ) )
	if "!MenuChoice!" equ "61" ( if "%I_HPSupportAssistant%" equ "+" ( set "I_HPSupportAssistant=-" ) else ( set "I_HPSupportAssistant=+" ) )
	if "!MenuChoice!" equ "62" ( if "%I_IntelGraphicsCommandCenter%" equ "+" ( set "I_IntelGraphicsCommandCenter=-" ) else ( set "I_IntelGraphicsCommandCenter=+" ) )
	if "!MenuChoice!" equ "63" ( if "%I_IntelThunderboltController%" equ "+" ( set "I_IntelThunderboltController=-" ) else ( set "I_IntelThunderboltController=+" ) )
	if "!MenuChoice!" equ "64" ( if "%I_KillerControlCenter%" equ "+" ( set "I_KillerControlCenter=-" ) else ( set "I_KillerControlCenter=+" ) )
	if "!MenuChoice!" equ "65" ( if "%I_NVIDIAControlPanel%" equ "+" ( set "I_NVIDIAControlPanel=-" ) else ( set "I_NVIDIAControlPanel=+" ) )
	if "!MenuChoice!" equ "66" ( if "%I_RealtekAudioControl%" equ "+" ( set "I_RealtekAudioControl=-" ) else ( set "I_RealtekAudioControl=+" ) )
	if "!MenuChoice!" equ "67" ( if "%I_WavesMaxxAudioProforDell%" equ "+" ( set "I_WavesMaxxAudioProforDell=-" ) else ( set "I_WavesMaxxAudioProforDell=+" ) )

	if /i "!MenuChoice!" equ "A" (
		set "I_Alarms=+"
		set "I_AmazonAppStore=+"
		set "I_AV1VideoExtension=+"
		set "I_BingNews=+"
		set "I_BingWeather=+"
		set "I_Calculator=+"
		set "I_Camera=+"
		set "I_Clipchamp=+"
		set "I_CommunicationsApps=+"
		set "I_Cortana=+"
		set "I_D3DMappingLayers=+"
		set "I_DesktopAppInstaller=+"
		set "I_DirectXRuntime=+"
		set "I_FeedbackHub=+"
		set "I_GamingApp=+"
		set "I_GamingServices=+"
		set "I_GetHelp=+"
		set "I_Getstarted=+"
		set "I_HEIFImageExtension=+"
		set "I_HEVCVideoExtension=+"
		set "I_Journal=+"
		set "I_Maps=+"
		set "I_MicrosoftPowerBI=+"
		set "I_MinecraftEducationEdition=+"
		set "I_MPEG2VideoExtension=+"
		set "I_Notepad=+"
		set "I_OfficeHub=+"
		if "%ImageBuild%" geq "22621" set "I_QuickAssist=+"
		set "I_Paint=+"
		set "I_People=+"
		set "I_Photos=+"
		set "I_PowerAutomateDesktop=+"
		set "I_RawImageExtension=+"
		set "I_ScreenSketch=+"
		set "I_SolitaireCollection=+"
		set "I_SoundRecorder=+"
		set "I_StickyNotes=+"
		set "I_StorePurchaseApp=+"
		set "I_TeamsChat=+"
		set "I_Terminal=+"
		set "I_Todos=+"
		set "I_VP9VideoExtensions=+"
		set "I_WebMediaExtensions=+"
		set "I_WebpImageExtension=+"
		set "I_Whiteboard=+"
		set "I_Widgets=+"
		set "I_WindowsDefender=+"
		set "I_WindowsStore=+"
		set "I_WindowsSubsystemForAndroid=+"
		set "I_WindowsSubsystemForLinux=+"
		set "I_Xbox=+"
		set "I_XboxGameOverlay=+"
		set "I_XboxGamingOverlay=+"
		set "I_XboxIdentityProvider=+"
		set "I_XboxSpeechToTextOverlay=+"
		set "I_XboxTCUI=+"
		set "I_YourPhone=+"
		set "I_ZuneMusic=+"
		set "I_ZuneVideo=+"

		set "I_AMDLink=+"
		set "I_HPSupportAssistant=+"
		set "I_IntelGraphicsCommandCenter=+"
		set "I_IntelThunderboltController=+"
		set "I_KillerControlCenter=+"
		set "I_NVIDIAControlPanel=+"
		set "I_RealtekAudioControl=+"
		set "I_WavesMaxxAudioProforDell=+"
	)
	if /i "!MenuChoice!" equ "X" goto :IntInboxAppsMenu
)

:: Returning to Select Microsoft Default Inbox Apps Menu
goto :SelectInboxAppsMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Default Inbox Apps
::-------------------------------------------------------------------------------------------
:IntInboxApps

setlocal

:: Setting Default Inbox Apps Appx and License files path
set "Apps=%Apps%\%SelectedSourceOS%"

set Alarms_Appx=
set AV1VideoExtension_Appx=
set AmazonAppStore_Appx=
set BingFinance_Appx=
set BingFoodDrink_Appx=
set BingHealthFitness_Appx=
set BingMaps_Appx=
set BingNews_Appx=
set BingSports_Appx=
set BingTravel_Appx=
set BingWeather_Appx=
set Calculator_Appx=
set Camera_Appx=
set ClientWebExperience_Appx=
set Clipchamp_Appx=
set CommunicationsApps_Appx=
set Cortana_Appx=
set D3DMappingLayers_Appx=
set DesktopAppInstaller_Appx=
set DirectXRuntime_Appx=
set FeedbackHub_Appx=
set GamingApp_Appx=
set GamingServices_Appx=
set GetHelp_Appx=
set Getstarted_Appx=
set HEIFImageExtension_Appx=
set HelpAndTips_Appx=
set HEVCVideoExtension_Appx=
set Journal_Appx=
set Maps_Appx=
set Messaging_Appx=
set MicrosoftPowerBI_Appx=
set MinecraftEducationEdition_Appx=
set MixedRealityPortal_Appx=
set MixedRealityViewer_Appx=
set MPEG2VideoExtension_Appx=
set Notepad_Appx=
set NVIDIAControlPanel_Appx=
set OfficeHub_Appx=
set OneConnect_Appx=
set OneNote_Appx=
set QuickAssist_Appx=
set Paint_Appx=
set Paint3D_Appx=
set People_Appx=
set Photos_Appx=
set PhotosMediaEngine_Appx=
set PowerAutomateDesktop_Appx=
set Print3D_Appx=
set RawImageExtension_Appx=
set Reader_Appx=
set ReadingList_Appx=
set Scan_Appx=
set RealtekAudioControl_Appx=
set ScreenSketch_Appx=
set Skype_Appx=
set SolitaireCollection_Appx=
set SoundRecorder_Appx=
set StickyNotes_Appx=
set StorePurchaseApp_Appx=
set Teams_Appx=
set Terminal_Appx=
set Todos_Appx=
set VP9VideoExtensions_Appx=
set Wallet_Appx=
set WebMediaExtensions_Appx=
set WebpImageExtension_Appx=
set Whiteboard_Appx=
set WindowsDefender_Appx=
set WindowsStore_Appx=
set WindowsSubsystemForAndroid_Appx=
set WindowsSubsystemForLinux_Appx=
set Xbox_Appx=
set XboxGameOverlay_Appx=
set XboxGamingOverlay_Appx=
set XboxIdentityProvider_Appx=
set XboxLiveGames_Appx=
set XboxSpeechToTextOverlay_Appx=
set XboxTCUI_Appx=
set YourPhone_Appx=
set ZuneMusic_Appx=
set ZuneVideo_Appx=

set AMDLink_Appx=
set HPSupportAssistant_Appx=
set IntelGraphicsCommandCenter_Appx=
set IntelThunderboltController_Appx=
set KillerControlCenter_Appx=
set NVIDIAControlPanel_Appx=
set RealtekAudioControl_Appx=
set WavesMaxxAudioProforDell_Appx=

set "Alarms_License=/LicensePath:%AppLicense%\Microsoft.WindowsAlarms_8wekyb3d8bbwe_%SelectedSourceOS%.xml"
set "AV1VideoExtension_License=/LicensePath:%AppLicense%\Microsoft.AV1VideoExtension_8wekyb3d8bbwe.%ImageArchitecture%.xml"
set "AmazonAppStore_License=/LicensePath:%AppLicense%\Amazon.comServicesLLC.AmazonAppstore_bvztej1py64t8.xml"
set "BingFinance_License=/LicensePath:%AppLicense%\Microsoft.BingFinance_8wekyb3d8bbwe.xml"
set "BingFoodDrink_License=/LicensePath:%AppLicense%\Microsoft.BingFoodAndDrink_8wekyb3d8bbwe.xml"
set "BingHealthFitness_License=/LicensePath:%AppLicense%\Microsoft.BingHealthAndFitness_8wekyb3d8bbwe.xml"
set "BingMaps_License=/LicensePath:%AppLicense%\Microsoft.BingMaps_8wekyb3d8bbwe.xml"
set "BingNews_License=/LicensePath:%AppLicense%\Microsoft.BingNews_8wekyb3d8bbwe_%SelectedSourceOS%.xml"
set "BingSports_License=/LicensePath:%AppLicense%\Microsoft.BingSports_8wekyb3d8bbwe.xml"
set "BingTravel_License=/LicensePath:%AppLicense%\Microsoft.BingTravel_8wekyb3d8bbwe.xml"
set "BingWeather_License=/LicensePath:%AppLicense%\Microsoft.BingWeather_8wekyb3d8bbwe_%SelectedSourceOS%.xml"
set "Calculator_License=/LicensePath:%AppLicense%\Microsoft.WindowsCalculator_8wekyb3d8bbwe_%SelectedSourceOS%.xml"
set "Camera_License=/LicensePath:%AppLicense%\Microsoft.WindowsCamera_8wekyb3d8bbwe.xml"
set "ClientWebExperience_License=/LicensePath:%AppLicense%\MicrosoftWindows.Client.WebExperience_cw5n1h2txyewy.xml"
set "Clipchamp_License=/LicensePath:%AppLicense%\Clipchamp.Clipchamp_yxz26nhyzhsrt.xml"
set "CommunicationsApps_License=/LicensePath:%AppLicense%\Microsoft.WindowsCommunicationsApps_8wekyb3d8bbwe_%SelectedSourceOS%.xml"
set "Cortana_License=/LicensePath:%AppLicense%\Microsoft.549981c3f5f10_8wekyb3d8bbwe.xml"
set "D3DMappingLayers_License=/LicensePath:%AppLicense%\Microsoft.D3DMappingLayers_8wekyb3d8bbwe.%ImageArchitecture%.xml"
set "DesktopAppInstaller_License=/LicensePath:%AppLicense%\Microsoft.DesktopAppInstaller_8wekyb3d8bbwe.xml"
set "DirectXRuntime_License=/LicensePath:%AppLicense%\Microsoft.DirectXRuntime_8wekyb3d8bbwe.xml"
set "FeedbackHub_License=/LicensePath:%AppLicense%\Microsoft.WindowsFeedbackHub_8wekyb3d8bbwe.xml"
set "GamingApp_License=/LicensePath:%AppLicense%\Microsoft.GamingApp_8wekyb3d8bbwe.xml"
set "GamingServices_License=/LicensePath:%AppLicense%\Microsoft.GamingServices_8wekyb3d8bbwe.xml"
set "GetHelp_License=/LicensePath:%AppLicense%\Microsoft.GetHelp_8wekyb3d8bbwe.xml"
set "Getstarted_License=/LicensePath:%AppLicense%\Microsoft.Getstarted_8wekyb3d8bbwe.xml"
set "HEIFImageExtension_License=/LicensePath:%AppLicense%\Microsoft.HEIFImageExtension_8wekyb3d8bbwe.%ImageArchitecture%.xml"
set "HelpAndTips_License=/LicensePath:%AppLicense%\Microsoft.HelpAndTips_8wekyb3d8bbwe.xml"
set "HEVCVideoExtension_License=/LicensePath:%AppLicense%\Microsoft.HEVCVideoExtension_8wekyb3d8bbwe.%ImageArchitecture%.xml"
set "Journal_License=/LicensePath:%AppLicense%\Microsoft.MicrosoftJournal_8wekyb3d8bbwe.xml"
set "Maps_License=/LicensePath:%AppLicense%\Microsoft.WindowsMaps_8wekyb3d8bbwe.xml"
set "Messaging_License=/LicensePath:%AppLicense%\Microsoft.Messaging_8wekyb3d8bbwe.xml"
set "MicrosoftPowerBI_License=/LicensePath:%AppLicense%\Microsoft.MicrosoftPowerBIForWindows_8wekyb3d8bbwe.xml"
set "MinecraftEducationEdition_License=/LicensePath:%AppLicense%\Microsoft.MinecraftEducationEdition_8wekyb3d8bbwe.xml"
set "MixedRealityPortal_License=/LicensePath:%AppLicense%\Microsoft.MixedReality.Portal_8wekyb3d8bbwe.xml"
set "MixedRealityViewer_License=/LicensePath:%AppLicense%\Microsoft.Microsoft3DViewer_8wekyb3d8bbwe.xml"
set "MPEG2VideoExtension_License=/LicensePath:%AppLicense%\Microsoft.MPEG2VideoExtension_8wekyb3d8bbwe.%ImageArchitecture%.xml"
set "Notepad_License=/LicensePath:%AppLicense%\Microsoft.WindowsNotepad_8wekyb3d8bbwe.xml"
set "OfficeHub_License=/LicensePath:%AppLicense%\Microsoft.MicrosoftOfficeHub_8wekyb3d8bbwe.xml"
set "OneConnect_License=/LicensePath:%AppLicense%\Microsoft.OneConnect_8wekyb3d8bbwe.xml"
set "OneNote_License=/LicensePath:%AppLicense%\Microsoft.Office.OneNote_8wekyb3d8bbwe_%SelectedSourceOS%.xml"
set "QuickAssist_License=/LicensePath:%AppLicense%\MicrosoftCorporationII.QuickAssist_8wekyb3d8bbwe.xml"
set "Paint_License=/LicensePath:%AppLicense%\Microsoft.Paint_8wekyb3d8bbwe.xml"
set "Paint3D_License=/LicensePath:%AppLicense%\Microsoft.MSPaint_8wekyb3d8bbwe.xml"
set "People_License=/LicensePath:%AppLicense%\Microsoft.People_8wekyb3d8bbwe.xml"
set "Photos_License=/LicensePath:%AppLicense%\Microsoft.Windows.Photos_8wekyb3d8bbwe.xml"
set "PhotosMediaEngine_License=/LicensePath:%AppLicense%\Microsoft.Photos.MediaEngineDLC_8wekyb3d8bbwe.xml"
set "PowerAutomateDesktop_License=/LicensePath:%AppLicense%\Microsoft.PowerAutomateDesktop_8wekyb3d8bbwe.xml"
set "Print3D_License=/LicensePath:%AppLicense%\Microsoft.Print3D_8wekyb3d8bbwe.xml"
set "RawImageExtension_License=/LicensePath:%AppLicense%\Microsoft.RawImageExtension_8wekyb3d8bbwe.xml"
set "Reader_License=/LicensePath:%AppLicense%\Microsoft.Reader_8wekyb3d8bbwe.xml"
set "ReadingList_License=/LicensePath:%AppLicense%\Microsoft.WindowsReadingList_8wekyb3d8bbwe.xml"
set "Scan_License=/LicensePath:%AppLicense%\Microsoft.WindowsScan_8wekyb3d8bbwe.xml"
set "ScreenSketch_License=/LicensePath:%AppLicense%\Microsoft.ScreenSketch_8wekyb3d8bbwe.xml"
set "Skype_License=/LicensePath:%AppLicense%\Microsoft.SkypeApp_kzf8qxf38zg5c_%SelectedSourceOS%.xml"
set "SolitaireCollection_License=/LicensePath:%AppLicense%\Microsoft.MicrosoftSolitaireCollection_8wekyb3d8bbwe.xml"
set "SoundRecorder_License=/LicensePath:%AppLicense%\Microsoft.WindowsSoundRecorder_8wekyb3d8bbwe_%SelectedSourceOS%.xml"
set "StickyNotes_License=/LicensePath:%AppLicense%\Microsoft.MicrosoftStickyNotes_8wekyb3d8bbwe.xml"
set "StorePurchaseApp_License=/LicensePath:%AppLicense%\Microsoft.StorePurchaseApp_8wekyb3d8bbwe.xml"
set "Teams_License=/LicensePath:%AppLicense%\MicrosoftTeams_8wekyb3d8bbwe.xml"
set "Terminal_License=/LicensePath:%AppLicense%\Microsoft.WindowsTerminal_8wekyb3d8bbwe.xml"
set "Todos_License=/LicensePath:%AppLicense%\Microsoft.Todos_8wekyb3d8bbwe.xml"
set "VP9VideoExtensions_License=/LicensePath:%AppLicense%\Microsoft.VP9VideoExtensions_8wekyb3d8bbwe.%ImageArchitecture%.xml"
set "Wallet_License=/LicensePath:%AppLicense%\Microsoft.Wallet_8wekyb3d8bbwe.xml"
set "WebMediaExtensions_License=/LicensePath:%AppLicense%\Microsoft.WebMediaExtensions_8wekyb3d8bbwe.xml"
set "WebpImageExtension_License=/LicensePath:%AppLicense%\Microsoft.WebpImageExtension_8wekyb3d8bbwe.%ImageArchitecture%.xml"
set "Whiteboard_License=/LicensePath:%AppLicense%\Microsoft.Whiteboard_8wekyb3d8bbwe.xml"
set "WindowsDefender_License=/LicensePath:%AppLicense%\Microsoft.SecHealthUI_8wekyb3d8bbwe.%ImageArchitecture%.xml"
set "WindowsStore_License=/LicensePath:%AppLicense%\Microsoft.WindowsStore_8wekyb3d8bbwe.xml"
set "WindowsSubsystemForAndroid_License=/LicensePath:%AppLicense%\MicrosoftCorporationII.WindowsSubsystemForAndroid_8wekyb3d8bbwe.xml"
set "WindowsSubsystemForLinux_License=/LicensePath:%AppLicense%\MicrosoftCorporationII.WindowsSubsystemForLinux_8wekyb3d8bbwe.xml"
set "Xbox_License=/LicensePath:%AppLicense%\Microsoft.XboxApp_8wekyb3d8bbwe.xml"
set "XboxGameOverlay_License=/LicensePath:%AppLicense%\Microsoft.XboxGameOverlay_8wekyb3d8bbwe.xml"
set "XboxGamingOverlay_License=/LicensePath:%AppLicense%\Microsoft.XboxGamingOverlay_8wekyb3d8bbwe.xml"
set "XboxIdentityProvider_License=/LicensePath:%AppLicense%\Microsoft.XboxIdentityProvider_8wekyb3d8bbwe.xml"
set "XboxLiveGames_License=/LicensePath:%AppLicense%\Microsoft.XboxLIVEGames_8wekyb3d8bbwe.xml"
set "XboxSpeechToTextOverlay_License=/LicensePath:%AppLicense%\Microsoft.XboxSpeechToTextOverlay_8wekyb3d8bbwe.xml"
set "XboxTCUI_License=/LicensePath:%AppLicense%\Microsoft.Xbox.TCUI_8wekyb3d8bbwe.xml"
set "YourPhone_License=/LicensePath:%AppLicense%\Microsoft.YourPhone_8wekyb3d8bbwe.xml"
set "ZuneMusic_License=/LicensePath:%AppLicense%\Microsoft.ZuneMusic_8wekyb3d8bbwe_%SelectedSourceOS%.xml"
set "ZuneVideo_License=/LicensePath:%AppLicense%\Microsoft.ZuneVideo_8wekyb3d8bbwe_%SelectedSourceOS%.xml"

set "AMDLink_License=/LicensePath:%AppLicense%\AdvancedMicroDevicesInc-2.AMDLink_0a9344xs7nr4m.xml"
set "HPSupportAssistant_License=/LicensePath:%AppLicense%\AD2F1837.HPSupportAssistant_v10z8vjag6ke6.xml"
set "IntelGraphicsCommandCenter_License=/LicensePath:%AppLicense%\AppUp.IntelGraphicsExperience_8j3eq9eme6ctt.xml"
set "IntelThunderboltController_License=/LicensePath:%AppLicense%\AppUp.ThunderboltControlCenter_8j3eq9eme6ctt.xml"
set "KillerControlCenter_License=/LicensePath:%AppLicense%\RivetNetworks.KillerControlCenter_rh07ty8m5nkag.xml"
set "NVIDIAControlPanel_License=/LicensePath:%AppLicense%\NVIDIACorp.NVIDIAControlPanel_56jybvy8sckqj.xml"
set "RealtekAudioControl_License=/LicensePath:%AppLicense%\RealtekSemiconductorCorp.RealtekAudioControl_dt26b99r8h8gj.xml"
set "WavesMaxxAudioProforDell_License=/LicensePath:%AppLicense%\WavesAudio.MaxxAudioProforDell2020_fh4rh281wavaa.xml"

set AdvertisingXaml_Appx=
set MediaPlayReadyClient22_Appx=
set NETNativeFramework13_Appx=
set NETNativeFramework16_Appx=
set NETNativeFramework17_Appx=
set NETNativeFramework21_Appx=
set NETNativeFramework22_Appx=
set NETNativeRuntime13_Appx=
set NETNativeRuntime14_Appx=
set NETNativeRuntime16_Appx=
set NETNativeRuntime17_Appx=
set NETNativeRuntime21_Appx=
set NETNativeRuntime22_Appx=
set ServicesStoreEngagement_Appx=
set UIXaml20_Appx=
set UIXaml21_Appx=
set UIXaml22_Appx=
set UIXaml23_Appx=
set UIXaml24_Appx=
set UIXaml25_Appx=
set UIXaml26_Appx=
set UIXaml27_Appx=
set VCLibs12_arm_Appx=
set VCLibs12_x86_Appx=
set VCLibs12_x64_Appx=
set VCLibsUWPDesktop11_Appx=
set VCLibsUWPDesktop12_Appx=
set VCLibsUWPDesktop14_Appx=
set VCLibs14_Appx=
set WinJS20_Appx=

cls
echo.===============================================================================
echo. 		  MSMG ToolKit - Integrate Microsoft Default Inbox Apps
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Microsoft Default Inbox Apps folder is empty

if not exist "%Apps%\*.appx" (
	echo.Microsoft Default Inbox Apps .Appx files are missing...
	echo.
	echo.Please copy the missing files to ^<Packs\Apps\%SelectedSourceOS%^> folder...
	echo.
	goto :Stop
)

:: Getting Microsoft Default Inbox Apps files full pathnames
cd /d "%Apps%\"

for /f %%i IN ('"dir /b *3DView*.*xbundle" 2^>nul') do if exist %%i set "MixedRealityViewer_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Alarms*.*xbundle" 2^>nul') do if exist %%i set "Alarms_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *AV1VideoExtension*.appx" 2^>nul') do if exist %%i set "AV1VideoExtension_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *AmazonAppstore*.*xbundle" 2^>nul') do if exist %%i set "AmazonAppStore_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *BingFinance*.*xbundle" 2^>nul') do if exist %%i set "BingFinance_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *BingFoodAndDrink*.*xbundle" 2^>nul') do if exist %%i set "BingFoodDrink_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *BingHealthAndFitness*.*xbundle" 2^>nul') do if exist %%i set "BingHealthFitness_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *BingMaps*.*xbundle" 2^>nul') do if exist %%i set "BingMaps_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *BingNews*.*xbundle" 2^>nul') do if exist %%i set "BingNews_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *BingSports*.*xbundle" 2^>nul') do if exist %%i set "BingSports_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *BingTravel*.*xbundle" 2^>nul') do if exist %%i set "BingTravel_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *BingWeather*.*xbundle" 2^>nul') do if exist %%i set "BingWeather_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Calculator*.*xbundle" 2^>nul') do if exist %%i set "Calculator_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Camera*.*xbundle" 2^>nul') do if exist %%i set "Camera_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Client.WebExperience*.*xbundle" 2^>nul') do if exist %%i set "ClientWebExperience_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Clipchamp*.*xbundle" 2^>nul') do if exist %%i set "Clipchamp_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *CommunicationsApps*.*xbundle" 2^>nul') do if exist %%i set "CommunicationsApps_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *D3DMappingLayers*.*appx" 2^>nul') do if exist %%i set "D3DMappingLayers_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *DesktopAppInstaller*.*xbundle" 2^>nul') do if exist %%i set "DesktopAppInstaller_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *DirectXRuntime*%ImageArchitecture%*.appx" 2^>nul') do if exist %%i set "DirectXRuntime_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *FeedbackHub*.*xbundle" 2^>nul') do if exist %%i set "FeedbackHub_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *GamingApp*.*xbundle" 2^>nul') do if exist %%i set "GamingApp_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *GamingServices*.*xbundle" 2^>nul') do if exist %%i set "GamingServices_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *GetHelp*.*xbundle" 2^>nul') do if exist %%i set "GetHelp_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Getstarted*.*xbundle" 2^>nul') do if exist %%i set "Getstarted_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *HEIFImageExtension*%ImageArchitecture%*.appx" 2^>nul') do if exist %%i set "HEIFImageExtension_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *HelpAndTips*.*xbundle" 2^>nul') do if exist %%i set "HelpAndTips_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *HEVCVideoExtension*%ImageArchitecture%*.appx" 2^>nul') do if exist %%i set "HEVCVideoExtension_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *MicrosoftJournal*.*xbundle" 2^>nul') do if exist %%i set "Journal_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *WindowsMaps*.*xbundle" 2^>nul') do if exist %%i set "Maps_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Messaging*.*xbundle" 2^>nul') do if exist %%i set "Messaging_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Microsoft.549981C3F5F10*.*xbundle" 2^>nul') do if exist %%i set "Cortana_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Microsoft.MicrosoftPowerBIForWindows*.*xbundle" 2^>nul') do if exist %%i set "MicrosoftPowerBI_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Microsoft.MinecraftEducationEdition*.*xbundle" 2^>nul') do if exist %%i set "MinecraftEducationEdition_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *MixedReality.Portal*.*xbundle" 2^>nul') do if exist %%i set "MixedRealityPortal_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *MPEG2VideoExtension*%ImageArchitecture%*.appx" 2^>nul') do if exist %%i set "MPEG2VideoExtension_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *OfficeHub*.*xbundle" 2^>nul') do if exist %%i set "OfficeHub_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *OneConnect*.*xbundle" 2^>nul') do if exist %%i set "OneConnect_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *OneNote*.*xbundle" 2^>nul') do if exist %%i set "OneNote_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *QuickAssist*.*xbundle" 2^>nul') do if exist %%i set "QuickAssist_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Paint*.*xbundle" 2^>nul') do if exist %%i set "Paint_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *MSPaint*.*xbundle" 2^>nul') do if exist %%i set "Paint3D_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *People*.*xbundle" 2^>nul') do if exist %%i set "People_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Windows.Photos*.*xbundle" 2^>nul') do if exist %%i set "Photos_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Photos.MediaEngineDLC*.*xbundle" 2^>nul') do if exist %%i set "PhotosMediaEngine_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *PowerAutomateDesktop*.*xbundle" 2^>nul') do if exist %%i set "PowerAutomateDesktop_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Print3D*.*xbundle" 2^>nul') do if exist %%i set "Print3D_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *RawImageExtension*.*xbundle" 2^>nul') do if exist %%i set "RawImageExtension_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Reader*.*xbundle" 2^>nul') do if exist %%i set "Reader_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *ReadingList*.*xbundle" 2^>nul') do if exist %%i set "ReadingList_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Scan*.*xbundle" 2^>nul') do if exist %%i set "Scan_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *ScreenSketch*.*xbundle" 2^>nul') do if exist %%i set "ScreenSketch_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Skype*.*xbundle" 2^>nul') do if exist %%i set "Skype_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *SolitaireCollection*.*xbundle" 2^>nul') do if exist %%i set "SolitaireCollection_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *SoundRecorder*.*xbundle" 2^>nul') do if exist %%i set "SoundRecorder_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *StickyNotes*.*xbundle" 2^>nul') do if exist %%i set "StickyNotes_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *StorePurchaseApp*.*xbundle" 2^>nul') do if exist %%i set "StorePurchaseApp_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Teams*.*msix" 2^>nul') do if exist %%i set "Teams_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Terminal*.*xbundle" 2^>nul') do if exist %%i set "Terminal_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Todos*.*xbundle" 2^>nul') do if exist %%i set "Todos_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *VP9VideoExtensions*%ImageArchitecture%*.appx" 2^>nul') do if exist %%i set "VP9VideoExtensions_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Wallet*.*xbundle" 2^>nul') do if exist %%i set "Wallet_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *WebMediaExtensions*.*xbundle" 2^>nul') do if exist %%i set "WebMediaExtensions_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *WebpImageExtension*%ImageArchitecture%*.appx" 2^>nul') do if exist %%i set "WebpImageExtension_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Whiteboard*.*xbundle" 2^>nul') do if exist %%i set "Whiteboard_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *WindowsNotepad*.*xbundle" 2^>nul') do if exist %%i set "Notepad_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Microsoft.SecHealthUI*%ImageArchitecture%*.appx" 2^>nul') do if exist %%i set "WindowsDefender_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *WindowsStore*.*xbundle" 2^>nul') do if exist %%i set "WindowsStore_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *WindowsSubsystemForAndroid*.*xbundle" 2^>nul') do if exist %%i set "WindowsSubsystemForAndroid_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *WindowsSubsystemForLinux*.*xbundle" 2^>nul') do if exist %%i set "WindowsSubsystemForLinux_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *Xbox.TCUI*.*xbundle" 2^>nul') do if exist %%i set "XboxTCUI_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *XboxApp*.*xbundle" 2^>nul') do if exist %%i set "Xbox_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *XboxGameOverlay*.*xbundle" 2^>nul') do if exist %%i set "XboxGameOverlay_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *XboxGamingOverlay*.*xbundle" 2^>nul') do if exist %%i set "XboxGamingOverlay_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *XboxIdentityProvider*.*xbundle" 2^>nul') do if exist %%i set "XboxIdentityProvider_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *XboxLIVEGames*.*xbundle" 2^>nul') do if exist %%i set "XboxLiveGames_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *XboxSpeechToTextOverlay*.*xbundle" 2^>nul') do if exist %%i set "XboxSpeechToTextOverlay_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *YourPhone*.*xbundle" 2^>nul') do if exist %%i set "YourPhone_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *ZuneMusic*.*xbundle" 2^>nul') do if exist %%i set "ZuneMusic_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *ZuneVideo*.*xbundle" 2^>nul') do if exist %%i set "ZuneVideo_Appx=%Apps%\%%i"

for /f %%i IN ('"dir /b *AMDLink*.*msix" 2^>nul') do if exist %%i set "AMDLink_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *HPSupportAssistant*.*xbundle" 2^>nul') do if exist %%i set "HPSupportAssistant_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *IntelGraphicsExperience*.*xbundle" 2^>nul') do if exist %%i set "IntelGraphicsCommandCenter_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *ThunderboltControlCenter*.*xbundle" 2^>nul') do if exist %%i set "IntelThunderboltController_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *KillerControlCenter*.*xbundle" 2^>nul') do if exist %%i set "KillerControlCenter_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *NVIDIAControlPanel*%ImageArchitecture%*.appx" 2^>nul') do if exist %%i set "NVIDIAControlPanel_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *RealtekAudioControl*.*xbundle" 2^>nul') do if exist %%i set "RealtekAudioControl_Appx=%Apps%\%%i"
for /f %%i IN ('"dir /b *MaxxAudioProforDell*.*xbundle" 2^>nul') do if exist %%i set "WavesMaxxAudioProforDell_Appx=%Apps%\%%i"

for /f %%i IN ('"dir /b Microsoft.Advertising.Xaml*%ImageArchitecture%*.Appx" 2^>nul') do set "AdvertisingXaml_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b *PlayReadyClient*%ImageArchitecture%*.appx" 2^>nul') do set "MediaPlayReadyClient22_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.NET.Native.Framework.1.3*%ImageArchitecture%*.Appx" 2^>nul') do set "NETNativeFramework13_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.NET.Native.Framework.1.6*%ImageArchitecture%*.Appx" 2^>nul') do set "NETNativeFramework16_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.NET.Native.Framework.1.7*%ImageArchitecture%*.Appx" 2^>nul') do set "NETNativeFramework17_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.NET.Native.Framework.2.1*%ImageArchitecture%*.Appx" 2^>nul') do set "NETNativeFramework21_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.NET.Native.Framework.2.2*%ImageArchitecture%*.Appx" 2^>nul') do set "NETNativeFramework22_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.NET.Native.Runtime.1.3*%ImageArchitecture%*.Appx" 2^>nul') do set "NETNativeRuntime13_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.NET.Native.Runtime.1.4*%ImageArchitecture%*.Appx" 2^>nul') do set "NETNativeRuntime14_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.NET.Native.Runtime.1.6*%ImageArchitecture%*.Appx" 2^>nul') do set "NETNativeRuntime16_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.NET.Native.Runtime.1.7*%ImageArchitecture%*.Appx" 2^>nul') do set "NETNativeRuntime17_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.NET.Native.Runtime.2.1*%ImageArchitecture%*.Appx" 2^>nul') do set "NETNativeRuntime21_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.NET.Native.Runtime.2.2*%ImageArchitecture%*.Appx" 2^>nul') do set "NETNativeRuntime22_Appx=/DependencyPackagePath:%Apps%\%%i"
if "%ImageArchitecture%" equ "arm" for /f %%i IN ('"dir /b Microsoft.Services.Store.Engagement*arm*.Appx" 2^>nul') do set "ServicesStoreEngagement_Appx=/DependencyPackagePath:%Apps%\%%i"
if "%ImageArchitecture%" equ "arm64" for /f %%i IN ('"dir /b Microsoft.Services.Store.Engagement*arm64*.Appx" 2^>nul') do set "ServicesStoreEngagement_Appx=/DependencyPackagePath:%Apps%\%%i"
if "%ImageArchitecture%" equ "x86" for /f %%i IN ('"dir /b Microsoft.Services.Store.Engagement*x86*.Appx" 2^>nul') do set "ServicesStoreEngagement_Appx=/DependencyPackagePath:%Apps%\%%i"
if "%ImageArchitecture%" equ "x64" for /f %%i IN ('"dir /b Microsoft.Services.Store.Engagement*x64*.Appx" 2^>nul') do set "ServicesStoreEngagement_Appx=%ServicesStoreEngagement_Appx% /DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.UI.Xaml.2.0*%ImageArchitecture%*.Appx" 2^>nul') do set "UIXaml20_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.UI.Xaml.2.1*%ImageArchitecture%*.Appx" 2^>nul') do set "UIXaml21_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.UI.Xaml.2.2*%ImageArchitecture%*.Appx" 2^>nul') do set "UIXaml22_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.UI.Xaml.2.3*%ImageArchitecture%*.Appx" 2^>nul') do set "UIXaml23_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.UI.Xaml.2.4*%ImageArchitecture%*.Appx" 2^>nul') do set "UIXaml24_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.UI.Xaml.2.5*%ImageArchitecture%*.Appx" 2^>nul') do set "UIXaml25_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.UI.Xaml.2.6*%ImageArchitecture%*.Appx" 2^>nul') do set "UIXaml26_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.UI.Xaml.2.7*%ImageArchitecture%*.Appx" 2^>nul') do set "UIXaml27_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.VCLibs.110.00.UWPDesktop*%ImageArchitecture%*.Appx" 2^>nul') do set "VCLibsUWPDesktop11_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.VCLibs.120.00.UWPDesktop*%ImageArchitecture%*.Appx" 2^>nul') do set "VCLibsUWPDesktop12_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.VCLibs.140.00.UWPDesktop*%ImageArchitecture%*.Appx" 2^>nul') do set "VCLibsUWPDesktop14_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.VCLibs.120.00_*%ImageArchitecture%*.Appx" 2^>nul') do set "VCLibs12_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.VCLibs.140.00_*%ImageArchitecture%*.Appx" 2^>nul') do set "VCLibs14_Appx=/DependencyPackagePath:%Apps%\%%i"
for /f %%i IN ('"dir /b Microsoft.WinJS.2*.appx" 2^>nul') do set "WinJS20_Appx=/DependencyPackagePath:%Apps%\%%i"

cd /d "%ROOT%\"

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft Default Inbox Apps###########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft Default Inbox Apps###################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		:: Integrating Windows 8.1 Default Inbox Apps to Install Image File
		if "%SelectedSourceOS%" equ "w81" (
			if "%I_Alarms%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Alarms and Clock", "%Alarms_Appx%", "%VCLibs12_Appx%", "%Alarms_License%"
			if "%I_BingFinance%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Bing Finance", "%BingFinance_Appx%", "%VCLibs12_Appx% %WinJS20_Appx%", "%BingFinance_License%"
			if "%I_BingFoodDrink%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Bing Food and Drink", "%BingFoodDrink_Appx%", "%VCLibs12_Appx% %WinJS20_Appx%", "%BingFoodDrink_License%"
			if "%I_BingHealthFitness%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Bing Health and Fitness", "%BingHealthFitness_Appx%", "%VCLibs12_Appx% %WinJS20_Appx%", "%BingHealthFitness_License%"
			if "%I_BingMaps%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Bing Maps", "%BingMaps_Appx%", "%VCLibs12_Appx%", "%BingMaps_License%"
			if "%I_BingNews%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Bing News", "%BingNews_Appx%", "%VCLibs12_Appx% %WinJS20_Appx%", "%BingNews_License%"
			if "%I_BingSports%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Bing Sports", "%BingSports_Appx%", "%VCLibs12_Appx% %WinJS20_Appx%", "%BingSports_License%"
			if "%I_BingTravel%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Bing Travel", "%BingTravel_Appx%", "%VCLibs12_Appx% %WinJS20_Appx%", "%BingTravel_License%"
			if "%I_BingWeather%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Bing Weather", "%BingWeather_Appx%", "%VCLibs12_Appx% %WinJS20_Appx%", "%BingWeather_License%"
			if "%I_Calculator%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Calculator", "%Calculator_Appx%", "%VCLibs12_Appx%", "%Calculator_License%"
			if "%I_CommunicationsApps%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Calender, Mail and People", "%CommunicationsApps_Appx%", "%VCLibs12_Appx% %WinJS20_Appx%", "%CommunicationsApps_License%"
			if "%I_HelpAndTips%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Help and Tips", "%HelpAndTips_Appx%", "%VCLibs12_Appx%", "%HelpAndTips_License%"
			if "%I_OneNote%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Office OneNote", "%OneNote_Appx%", "%VCLibs12_Appx%", "%OneNote_License%"
			if "%I_Reader%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Reader", "%Reader_Appx%", "%VCLibs12_Appx%", "%Reader_License%"
			if "%I_ReadingList%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Reading List", "%ReadingList_Appx%", "%VCLibs12_Appx% %WinJS20_Appx%", "%ReadingList_License%"
			if "%I_Scan%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Scan", "%Scan_Appx%", "%VCLibs12_Appx%", "%Scan_License%"
			if "%I_Skype%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Skype App", "%Skype_Appx%", "%VCLibs12_Appx% %WinJS20_Appx%", "%Skype_License%"
			if "%I_SoundRecorder%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Sound Recorder", "%SoundRecorder_Appx%", "%VCLibs12_Appx%", "%SoundRecorder_License%"
			if "%I_XboxLiveGames%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Xbox Live Games", "%XboxLiveGames_Appx%", "%VCLibs12_Appx% %WinJS20_Appx%", "%XboxLiveGames_License%"
			if "%I_ZuneMusic%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Zune Music", "%ZuneMusic_Appx%", "%MediaPlayReadyClient22_Appx% %VCLibs12_Appx% %WinJS20_Appx%", "%ZuneMusic_License%"
			if "%I_ZuneVideo%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Zune Video", "%ZuneVideo_Appx%", "%MediaPlayReadyClient22_Appx% %VCLibs12_Appx% %WinJS20_Appx%", "%ZuneVideo_License%"
		)

		:: Integrating Windows 10/11 Default Inbox Apps to Install Image
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
			if "%I_Alarms%" equ "+" (
				if "%SelectedSourceOS%" equ "w10" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Alarms and Clock", "%Alarms_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml24_Appx% %VCLibs14_Appx%", "%Alarms_License%"
				if "%SelectedSourceOS%" equ "w11" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Alarms and Clock", "%Alarms_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml27_Appx% %VCLibs14_Appx%", "%Alarms_License%"
			)
			if "%I_AV1VideoExtension%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "AV1 Video Codec Plugin", "%AV1VideoExtension_Appx%", "%VCLibs14_Appx%", "%AV1VideoExtension_License%"
			if "%I_AmazonAppStore%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Amazon App Store", "%AmazonAppStore_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibs14_Appx%", "/SkipLicense"
			if "%I_BingNews%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "News", "%BingNews_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml21_Appx% %VCLibs14_Appx%", "%BingNews_License%"
			if "%I_BingWeather%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Weather", "%BingWeather_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml21_Appx% %VCLibs14_Appx%", "%BingWeather_License%"
			if "%I_Calculator%" equ "+" (
				if "%SelectedSourceOS%" equ "w10" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Calculator", "%Calculator_Appx%", "%UIXaml24_Appx% %VCLibs14_Appx%", "%Calculator_License%"
				if "%SelectedSourceOS%" equ "w11" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Calculator", "%Calculator_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml27_Appx% %VCLibs14_Appx%", "%Calculator_License%"
			)
			if "%I_Camera%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Camera", "%Camera_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibs14_Appx%", "%Camera_License%"
			if "%I_ClientWebExperience%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Widgets", "%ClientWebExperience_Appx%", "%VCLibs14_Appx%", "%ClientWebExperience_License%"
			if "%I_Clipchamp%" equ "+" (
				if "%ImageBuild%" geq "16299" if "%ImageBuild%" leq "17763" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Clipchamp Video Editor", "%Clipchamp_Appx%", "%VCLibsUWPDesktop14_Appx%", "%Clipchamp_License%"
				if "%ImageBuild%" geq "18362" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Clipchamp Video Editor", "%Clipchamp_Appx%", "", "%Clipchamp_License%"
			)
			if "%I_CommunicationsApps%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Windows Mail", "%CommunicationsApps_Appx%", "%UIXaml27_Appx% %VCLibs14_Appx%", "%CommunicationsApps_License%"
			if "%I_Cortana%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Cortana", "%Cortana_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml27_Appx% %VCLibsUWPDesktop14_Appx% %VCLibs14_Appx%", "%Cortana_License%"
			if "%I_D3DMappingLayers%" equ "+" if "%ImageArchitecture%" neq "x86" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "OpenCL and OpenGL Compatibility Pack", "%D3DMappingLayers_Appx%", "", "%D3DMappingLayers_License%"
			if "%I_DesktopAppInstaller%" equ "+" (
				if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" leq "17134" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "App Installer", "%DesktopAppInstaller_Appx%", "%VCLibsUWPDesktop14_Appx%", "%DesktopAppInstaller_License%"
				if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" geq "17763" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "App Installer", "%DesktopAppInstaller_Appx%", "%UIXaml27_Appx% %VCLibsUWPDesktop14_Appx%", "%DesktopAppInstaller_License%"
				if "%SelectedSourceOS%" equ "w11" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "App Installer", "%DesktopAppInstaller_Appx%", "%UIXaml27_Appx% %VCLibsUWPDesktop14_Appx%", "%DesktopAppInstaller_License%"
			)
			if "%I_DirectXRuntime%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "DirectX Runtime", "%DirectXRuntime_Appx%", "", "/SkipLicense"
			if "%I_FeedbackHub%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Feedback Hub", "%FeedbackHub_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml27_Appx% %VCLibs14_Appx%", "%FeedbackHub_License%"
			if "%I_GamingApp%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Gaming App", "%GamingApp_Appx%", "%UIXaml27_Appx% %VCLibsUWPDesktop14_Appx% %VCLibs14_Appx%", "%GamingApp_License%"
			if "%I_GamingServices%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Gaming Services", "%GamingServices_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibs14_Appx%", "/SkipLicense"
			if "%I_GetHelp%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Get Help", "%GetHelp_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml27_Appx% %VCLibs14_Appx%", "%GetHelp_License%"
			if "%I_Getstarted%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Tips", "%Getstarted_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml27_Appx% %VCLibs14_Appx%", "%Getstarted_License%"
			if "%I_HEIFImageExtension%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "HEIF Image Codec Plugin", "%HEIFImageExtension_Appx%", "%VCLibs14_Appx%", "%HEIFImageExtension_License%"
			if "%I_HEVCVideoExtension%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "HEVC Video Codec Plugin", "%HEVCVideoExtension_Appx%", "%VCLibs14_Appx%", "%HEVCVideoExtension_License%"
			if "%I_Journal%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Journal", "%Journal_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml27_Appx% %VCLibs14_Appx%", "%Journal_License%"
			if "%I_Maps%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Maps", "%Maps_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml23_Appx% %VCLibs14_Appx%", "%Maps_License%"
			if "%I_Messaging%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Messaging", "%Messaging_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml24_Appx% %VCLibs14_Appx%", "%Messaging_License%"
			if "%I_MicrosoftPowerBI%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Microsoft Power BI for Windows", "%MicrosoftPowerBI_Appx%", "%NETNativeFramework17_Appx% %NETNativeRuntime17_Appx% %UIXaml25_Appx% %VCLibs14_Appx%", "%MicrosoftPowerBI_License%"
			if "%I_MinecraftEducationEdition%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Minecraft Education Edition", "%MinecraftEducationEdition_Appx%", "%VCLibsUWPDesktop14_Appx%", "%MinecraftEducationEdition_License%"
			if "%I_MixedRealityPortal%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Mixed Reality Portal", "%MixedRealityPortal_Appx%", "%VCLibs14_Appx%", "%MixedRealityPortal_License%"
			if "%I_MixedRealityViewer%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "3D Viewer", "%MixedRealityViewer_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml21_Appx% %VCLibsUWPDesktop14_Appx% %VCLibs14_Appx%", "%MixedRealityViewer_License%"
			if "%I_MPEG2VideoExtension%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "MPEG-2 Video Codec Plugin", "%MPEG2VideoExtension_Appx%", "%VCLibs14_Appx%", "%MPEG2VideoExtension_License%"
			if "%I_Notepad%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Notepad", "%Notepad_Appx%", "%UIXaml27_Appx% %VCLibsUWPDesktop14_Appx% %VCLibs14_Appx%", "%Notepad_License%"
			if "%I_OfficeHub%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "My Office", "%OfficeHub_Appx%", "%VCLibsUWPDesktop14_Appx% %VCLibs14_Appx%", "%OfficeHub_License%"
			if "%I_OneConnect%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Mobile Plans", "%OneConnect_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibs14_Appx%", "%OneConnect_License%"
			if "%I_OneNote%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Office OneNote", "%OneNote_Appx%", "%VCLibs14_Appx%", "%OneNote_License%"
			if "%I_QuickAssist%" equ "+" if "%ImageBuild%" geq "22621" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Quick Assist", "%QuickAssist_Appx%", "", "%QuickAssist_License%"
			if "%I_Paint%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Paint", "%Paint_Appx%", "%UIXaml27_Appx% %VCLibsUWPDesktop14_Appx% %VCLibs14_Appx%", "%Paint_License%"
			if "%I_Paint3D%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Paint 3D", "%Paint3D_Appx%", "%UIXaml20_Appx% %VCLibs14_Appx%", "%Paint3D_License%"
			if "%I_People%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "People", "%People_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibs14_Appx%", "%People_License%"
			if "%I_Photos%" equ "+" (
				if "%SelectedSourceOS%" equ "w10" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Photos", "%Photos_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml24_Appx% %VCLibs14_Appx%", "%Photos_License%"
				if "%SelectedSourceOS%" equ "w11" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Photos", "%Photos_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml27_Appx% %VCLibs14_Appx%", "%Photos_License%"
			)
			if "%I_PowerAutomateDesktop%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Power Automate Desktop", "%PowerAutomateDesktop_Appx%", "%VCLibsUWPDesktop14_Appx%", "%PowerAutomateDesktop_License%"
			if "%I_Print3D%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Print 3D", "%Print3D_Appx%", "%VCLibs14_Appx%", "%Print3D_License%"
			if "%I_RawImageExtension%" equ "+" (
				if "%SelectedSourceOS%" equ "w10" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Raw Image Extension", "%RawImageExtension_Appx%", "%VCLibs14_Appx%", "%RawImageExtension_License%"
				if "%SelectedSourceOS%" equ "w11" if "%ImageBuild%" equ "22000" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Raw Image Extension", "%RawImageExtension_Appx%", "%VCLibs14_Appx%", "%RawImageExtension_License%"
				if "%SelectedSourceOS%" equ "w11" if "%ImageBuild%" geq "22621" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Raw Image Extension", "%RawImageExtension_Appx%", "", "%RawImageExtension_License%"
			)
			if "%I_ScreenSketch%" equ "+" (
				if "%SelectedSourceOS%" equ "w10" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Snip and Sketch", "%ScreenSketch_Appx%", "%UIXaml24_Appx% %VCLibs14_Appx%", "%ScreenSketch_License%"
				if "%SelectedSourceOS%" equ "w11" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Snipping Tool", "%ScreenSketch_Appx%", "%UIXaml27_Appx% %VCLibs14_Appx%", "%ScreenSketch_License%"
			)
			if "%I_Skype%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Skype", "%Skype_Appx%", "", "%Skype_License%"
			if "%I_SolitaireCollection%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Solitaire Collection", "%SolitaireCollection_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibs14_Appx%", "%SolitaireCollection_License%"
			if "%I_SoundRecorder%" equ "+" (
				if "%SelectedSourceOS%" equ "w10" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Voice Recorder", "%SoundRecorder_Appx%", "%UIXaml23_Appx% %VCLibs14_Appx%", "%SoundRecorder_License%"
				if "%SelectedSourceOS%" equ "w11" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Voice Recorder", "%SoundRecorder_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml27_Appx% %VCLibs14_Appx%", "%SoundRecorder_License%"
			)
			if "%I_StickyNotes%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Sticky Notes", "%StickyNotes_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibs14_Appx%", "%StickyNotes_License%"
			if "%I_StorePurchaseApp%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Store Experience Host", "%StorePurchaseApp_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibs14_Appx%", "%StorePurchaseApp_License%"
			if "%I_Teams%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Teams Chat", "%Teams_Appx%", "", "/SkipLicense"
			if "%I_Terminal%" equ "+" (
				if "%SelectedSourceOS%" equ "w10" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Terminal", "%Terminal_Appx%", "%VCLibsUWPDesktop14_Appx%", "%Terminal_License%"
				if "%SelectedSourceOS%" equ "w11" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Terminal", "%Terminal_Appx%", "%UIXaml27_Appx% %VCLibsUWPDesktop14_Appx%", "%Terminal_License%"
				call :MountImageRegistry "%InstallMount%\%%i"
				reg add "HKLM\TK_SYSTEM\ControlSet001\Services\condrv" /v "Start" /t REG_DWORD /d "2" /f >nul
				call :UnMountImageRegistry
			)
			if "%I_Todos%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Todos", "%Todos_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml27_Appx% %VCLibs14_Appx%", "%Todos_License%"
			if "%I_VP9VideoExtensions%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Google's VP9 WebM Video Codec Plugin", "%VP9VideoExtensions_Appx%", "%VCLibs14_Appx%", "%VP9VideoExtensions_License%"
			if "%I_Wallet%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Microsoft Pay", "%Wallet_Appx%", "%NETNativeFramework17_Appx% %NETNativeRuntime17_Appx% %VCLibs14_Appx%", "%Wallet_License%"
			if "%I_WebMediaExtensions%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Web Media Codec Plugin", "%WebMediaExtensions_Appx%", "%VCLibs14_Appx%", "%WebMediaExtensions_License%"
			if "%I_WebpImageExtension%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "WebP Image Codec Plugin", "%WebpImageExtension_Appx%", "%VCLibs14_Appx%", "%WebpImageExtension_License%"
			if "%I_Whiteboard%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Whiteboard", "%Whiteboard_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibs14_Appx%", "%Whiteboard_License%"
			if "%I_WindowsDefender%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Windows Defender Dashboard", "%WindowsDefender_Appx%", "%UIXaml24_Appx% %VCLibs14_Appx%", "%WindowsDefender_License%"
			if "%I_WindowsStore%" equ "+" (
				if "%ImageBuild%" geq "14393" if "%ImageBuild%" leq "15063" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Windows Store", "%WindowsStore_Appx%", "%NETNativeFramework17_Appx% %NETNativeRuntime17_Appx% %VCLibs14_Appx%", "%WindowsStore_License%"
				if "%ImageBuild%" geq "16299" if "%ImageBuild%" leq "18362" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Windows Store", "%WindowsStore_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml24_Appx% %VCLibs14_Appx%", "%WindowsStore_License%"
				if "%ImageBuild%" geq "18363" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Windows Store", "%WindowsStore_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml27_Appx% %VCLibs14_Appx%", "%WindowsStore_License%"
			)
			if "%I_WindowsSubsystemForAndroid%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Windows Subsystem For Android", "%WindowsSubsystemForAndroid_Appx%", "%UIXaml26_Appx% %VCLibsUWPDesktop14_Appx% %VCLibs14_Appx%", "/SkipLicense"
			if "%I_WindowsSubsystemForLinux%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Windows Subsystem For Linux", "%WindowsSubsystemForLinux_Appx%", "", "%WindowsSubsystemForLinux_License%"
			if "%I_Xbox%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Xbox Console Companion", "%Xbox_Appx%", "%NETNativeFramework17_Appx% %NETNativeRuntime17_Appx% %VCLibsUWPDesktop14_Appx% %VCLibs14_Appx%", "%Xbox_License%"
			if "%I_XboxGameOverlay%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Xbox Game Bar Plugin", "%XboxGameOverlay_Appx%", "%VCLibs14_Appx%", "%XboxGameOverlay_License%"
			if "%I_XboxGamingOverlay%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Xbox Game Bar", "%XboxGamingOverlay_Appx%", "%UIXaml24_Appx% %VCLibsUWPDesktop14_Appx% %VCLibs14_Appx%", "%XboxGamingOverlay_License%"
			if "%I_XboxIdentityProvider%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Xbox Identity Provider", "%XboxIdentityProvider_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibs14_Appx%", "%XboxIdentityProvider_License%"
			if "%I_XboxSpeechToTextOverlay%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Xbox Game Speech Window", "%XboxSpeechToTextOverlay_Appx%", "%VCLibs14_Appx%", "%XboxSpeechToTextOverlay_License%"
			if "%I_XboxTCUI%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Xbox UI", "%XboxTCUI_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibs14_Appx%", "%XboxTCUI_License%"
			if "%I_YourPhone%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Phone Link", "%YourPhone_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibsUWPDesktop14_Appx% %VCLibs14_Appx%", "%YourPhone_License%"
			if "%I_ZuneMusic%" equ "+" (
				if "%SelectedSourceOS%" equ "w10" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Groove Music", "%ZuneMusic_Appx%", "%UIXaml24_Appx% %VCLibs14_Appx%", "%ZuneMusic_License%"
				if "%SelectedSourceOS%" equ "w11" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Media Player", "%ZuneMusic_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %UIXaml27_Appx% %VCLibs14_Appx%", "%ZuneMusic_License%"
			)
			if "%I_ZuneVideo%" equ "+" (
				if "%ImageBuild%" leq "18363" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Films and TV", "%ZuneVideo_Appx%", "%UIXaml27_Appx% %VCLibs14_Appx%", "%ZuneVideo_License%"
				if "%ImageBuild%" geq "19041" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Movies and TV", "%ZuneVideo_Appx%", "%UIXaml27_Appx% %VCLibs14_Appx%", "%ZuneVideo_License%"
			)

			if "%I_AMDLink%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "AMD Link", "%AMDLink_Appx%", "%VCLibsUWPDesktop14_Appx%", "%AMDLink_License%"
			if "%I_HPSupportAssistant%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "HP Support Assistant 9", "%HPSupportAssistant_Appx%", "%NETNativeFramework13_Appx% %NETNativeRuntime13_Appx% %NETNativeFramework14_Appx% %NETNativeRuntime14_Appx% %VCLibs14_Appx%", "%HPSupportAssistant_License%"
			if "%I_IntelGraphicsCommandCenter%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Intel Graphics Command Center", "%IntelGraphicsCommandCenter_Appx%", "%NETNativeFramework22_Appx% %NETNativeRuntime22_Appx% %VCLibs14_Appx%", "%IntelGraphicsCommandCenter_License%"
			if "%I_IntelThunderboltController%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Intel Thunderbolt Controller", "%IntelThunderboltController_Appx%", "%NETNativeFramework21_Appx% %NETNativeRuntime21_Appx% %VCLibs14_Appx%", "%IntelThunderboltController_License%"
			if "%I_KillerControlCenter%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Rivet Networks Killer Control Center", "%KillerControlCenter_Appx%", "", "%KillerControlCenter_License%"
			if "%I_NVIDIAControlPanel%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "NVIDIA Control Panel", "%NVIDIAControlPanel_Appx%", "", "%NVIDIAControlPanel_License%"
			if "%I_RealtekAudioControl%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Realtek Audio Console", "%RealtekAudioControl_Appx%", "%VCLibs14_Appx%", "%RealtekAudioControl_License%"
			if "%I_WavesMaxxAudioProforDell%" equ "+" call :AddProvisionedAppxPackage "%InstallMount%\%%i", "Waves MaxxAudio Pro for Dell 2020", "%WavesMaxxAudioProforDell_Appx%", "%NETNativeFramework17_Appx% %NETNativeRuntime17_Appx% %VCLibs14_Appx%", "%WavesMaxxAudioProforDell_License%"

			echo.-------------------------------------------------------------------------------
			echo.Optimizing Microsoft Default Inbox Apps...
			echo.-------------------------------------------------------------------------------
			%DISM% /Image:"%InstallMount%\%%i" /Optimize-ProvisionedAppxPackages
			echo.
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft Default Inbox Apps##########################
echo.-------------------------------------------------------------------------------
echo.

:Stop
echo.===============================================================================
echo.
pause

set Apps=

set Alarms_Appx=
set AV1VideoExtension_Appx=
set AmazonAppStore_Appx=
set BingFinance_Appx=
set BingFoodDrink_Appx=
set BingHealthFitness_Appx=
set BingMaps_Appx=
set BingNews_Appx=
set BingSports_Appx=
set BingTravel_Appx=
set BingWeather_Appx=
set Calculator_Appx=
set Camera_Appx=
set ClientWebExperience_Appx=
set CommunicationsApps_Appx=
set Cortana_Appx=
set DesktopAppInstaller_Appx=
set D3DMappingLayers_Appx=
set DirectXRuntime_Appx=
set FeedbackHub_Appx=
set GamingApp_Appx=
set GamingServices_Appx=
set GetHelp_Appx=
set Getstarted_Appx=
set HEIFImageExtension_Appx=
set HelpAndTips_Appx=
set HEVCVideoExtension_Appx=
set Journal_Appx=
set Maps_Appx=
set Messaging_Appx=
set MicrosoftPowerBI_Appx=
set MinecraftEducationEdition_Appx=
set MixedRealityPortal_Appx=
set MixedRealityViewer_Appx=
set MPEG2VideoExtension_Appx=
set Notepad_Appx=
set OfficeHub_Appx=
set OneConnect_Appx=
set OneNote_Appx=
set Paint_Appx=
set Paint3D_Appx=
set People_Appx=
set Photos_Appx=
set PhotosMediaEngine_Appx=
set PowerAutomateDesktop_Appx=
set Print3D_Appx=
set RawImageExtension_Appx=
set Reader_Appx=
set ReadingList_Appx=
set Scan_Appx=
set ScreenSketch_Appx=
set Skype_Appx=
set SolitaireCollection_Appx=
set SoundRecorder_Appx=
set StickyNotes_Appx=
set StorePurchaseApp_Appx=
set Teams_Appx=
set Terminal_Appx=
set Todos_Appx=
set VP9VideoExtensions_Appx=
set Wallet_Appx=
set WebMediaExtensions_Appx=
set WebpImageExtension_Appx=
set Whiteboard_Appx=
set WindowsDefender_Appx=
set WindowsStore_Appx=
set WindowsSubsystemForAndroid_Appx=
set WindowsSubsystemForLinux_Appx=
set Xbox_Appx=
set XboxGameOverlay_Appx=
set XboxGamingOverlay_Appx=
set XboxIdentityProvider_Appx=
set XboxLiveGames_Appx=
set XboxSpeechToTextOverlay_Appx=
set XboxTCUI_Appx=
set YourPhone_Appx=
set ZuneMusic_Appx=
set ZuneVideo_Appx=

set AMDLink_Appx=
set HPSupportAssistant_Appx=
set IntelGraphicsCommandCenter_Appx=
set IntelThunderboltController_Appx=
set KillerControlCenter_Appx=
set NVIDIAControlPanel_Appx=
set RealtekAudioControl_Appx=
set WavesMaxxAudioProforDell_Appx=

set AdvertisingXaml_Appx=
set MediaPlayReadyClient22_Appx=
set NETNativeFramework13_Appx=
set NETNativeFramework16_Appx=
set NETNativeFramework17_Appx=
set NETNativeFramework21_Appx=
set NETNativeFramework22_Appx=
set NETNativeRuntime13_Appx=
set NETNativeRuntime14_Appx=
set NETNativeRuntime16_Appx=
set NETNativeRuntime17_Appx=
set NETNativeRuntime21_Appx=
set NETNativeRuntime22_Appx=
set ServicesStoreEngagement_Appx=
set UIXaml20_Appx=
set UIXaml21_Appx=
set UIXaml22_Appx=
set UIXaml23_Appx=
set UIXaml24_Appx=
set UIXaml25_Appx=
set UIXaml26_Appx=
set UIXaml27_Appx=
set VCLibs12_arm_Appx=
set VCLibs12_x86_Appx=
set VCLibs12_x64_Appx=
set VCLibsUWPDesktop11_Appx=
set VCLibsUWPDesktop12_Appx=
set VCLibsUWPDesktop14_Appx=
set VCLibs14_Appx=
set WinJS20_Appx=

endlocal

:: Resetting Microsoft Default Inbox Apps status flags
for %%i in (I_3DViewer,I_Alarms,I_AmazonAppStore,I_AV1VideoExtension,I_BingFinance,I_BingFoodDrink,I_BingHealthFitness,I_BingMaps,I_BingNews,I_BingSports,I_BingTravel,I_BingWeather,I_Calculator,I_Camera,I_ClientWebExperience,I_Clipchamp,I_CommunicationsApps,I_Cortana,I_D3DMappingLayers,I_DesktopAppInstaller,I_DirectXRuntime,I_FeedbackHub,I_GamingApp,I_GamingServices,I_GetHelp,I_Getstarted,I_HEIFImageExtension,I_HelpAndTips,I_HEVCVideoExtension,I_Journal,I_Maps,I_Messaging,I_MicrosoftPowerBI,I_MinecraftEducationEdition,I_MixedRealityPortal,I_MPEG2VideoExtension,I_Notepad,I_NVIDIAControlPanel,I_OfficeHub,I_OfficeOneNote,I_OneConnect,I_Paint,I_Paint3D,I_People,I_Photos,I_PowerAutomateDesktop,I_Print3D,I_QuickAssist,I_RawImageExtension,I_Reader,I_ReadingList,I_RealtekAudioControl,I_Scan,I_ScreenSketch,I_SkypeApp,I_SolitaireCollection,I_SoundRecorder,I_StickyNotes,I_StorePurchaseApp,I_TeamsChat,I_Terminal,I_Todos,I_VP9VideoExtensions,I_Wallet,I_WebMediaExtensions,I_WebpImageExtension,I_Whiteboard,I_WindowsDefender,I_WindowsStore,I_WindowsSubsystemForAndroid,I_WindowsSubsystemForLinux,I_Xbox,I_XboxGameOverlay,I_XboxGamingOverlay,I_XboxIdentityProvider,I_XboxLiveGames,I_XboxSpeechToTextOverlay,I_XboxTCUI,I_YourPhone,I_ZuneMusic,I_ZuneVideo) do (
	set "%%i=-"
)

:: Returning to Integrate Microsoft Default Inbox Apps Menu
goto :IntInboxAppsMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: MSMG ToolKit - Integrate Microsoft Office Desktop Universal Windows Platform (UWP) Apps
::-------------------------------------------------------------------------------------------
:IntOfficeUWPApps

setlocal

set OfficeUWPApp=
set OfficeDesktop_Appx=
set OfficeAccess_Appx=
set OfficeExcel_Appx=
set OfficeOutlook_Appx=
set OfficePowerPoint_Appx=
set OfficePublisher_Appx=
set OfficeWord_Appx=

set OfficeDesktop_License=
set OfficeAccess_License=
set OfficeExcel_License=
set OfficeOutlook_License=
set OfficePowerPoint_License=
set OfficePublisher_License=
set OfficeWord_License=

cls
echo.===============================================================================
echo.         MSMG ToolKit - Integrate Microsoft Office Desktop ^(UWP^) Apps
echo.===============================================================================
echo.

:: Checking whether Microsoft Office Desktop (UWP) Apps folder is empty
if not exist "%OfficeUWP%\*.appxbundle" (
	echo.Microsoft Office Desktop ^(UWP^) Apps Pack folder ^<Packs\%OfficeUWP%^> is empty...
	echo.
	echo.Please copy Microsoft Office Desktop ^(UWP^) Apps Pack files to respective folder...
	echo.
	goto :Stop
)

if not exist "%OfficeUWP%\*.xml" (
	echo.Microsoft Office Desktop ^(UWP^) Apps Pack folder ^<Packs\%OfficeUWP%^> is empty...
	echo.
	echo.Please copy Microsoft Office Desktop ^(UWP^) Apps Pack files to respective folder...
	echo.
	goto :Stop
)

cls
echo.===============================================================================
echo.      MSMG ToolKit - Integrate Microsoft Office Desktop ^(UWP^) Apps Menu
echo.===============================================================================
echo.
echo.  [1]  Microsoft Office Access 2016
echo.
echo.  [2]  Microsoft Office Excel 2016
echo.
echo.  [3]  Microsoft Office Outlook 2016
echo.
echo.  [4]  Microsoft Office PowerPoint 2016
echo.
echo.  [5]  Microsoft Office Publisher 2016
echo.
echo.  [6]  Microsoft Office Word 2016
echo.
echo.
echo.  [A]  All Apps
echo.
echo.  [X]  Go Back
echo.
echo.===============================================================================
echo.
choice /C:123456AX /N /M "Enter Your Choice : "

if errorlevel 8 goto :IntFeaturesMenu
if errorlevel 7 set "OfficeUWPApp=AllOfficeApps"
if errorlevel 6 set "OfficeUWPApp=OfficeWord"
if errorlevel 5 set "OfficeUWPApp=OfficePublisher"
if errorlevel 4 set "OfficeUWPApp=OfficePowerPoint"
if errorlevel 3 set "OfficeUWPApp=OfficeOutlook"
if errorlevel 2 set "OfficeUWPApp=OfficeExcel"
if errorlevel 1 set "OfficeUWPApp=OfficeAccess"

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Getting Microsoft Office Desktop (UWP) Apps files full pathnames
cd /d "%OfficeUWP%\"

for /f %%i IN ('"dir /b *Microsoft.Office.Desktop_*.appxbundle" 2^>nul') do if exist %%i set "OfficeDesktop_Appx=%OfficeUWP%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Office.Desktop.Access_*.appxbundle" 2^>nul') do if exist %%i set "OfficeAccess_Appx=%OfficeUWP%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Office.Desktop.Excel_*.appxbundle" 2^>nul') do if exist %%i set "OfficeExcel_Appx=%OfficeUWP%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Office.Desktop.Outlook_*.appxbundle" 2^>nul') do if exist %%i set "OfficeOutlook_Appx=%OfficeUWP%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Office.Desktop.PowerPoint*.appxbundle" 2^>nul') do if exist %%i set "OfficePowerPoint_Appx=%OfficeUWP%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Office.Desktop.Publisher_*.appxbundle" 2^>nul') do if exist %%i set "OfficePublisher_Appx=%OfficeUWP%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Office.Desktop.Word_*.appxbundle" 2^>nul') do if exist %%i set "OfficeWord_Appx=%OfficeUWP%\%%i"

for /f %%i IN ('"dir /b *Microsoft.Office.Desktop_*.xml" 2^>nul') do if exist %%i set "OfficeDesktop_License=%OfficeUWP%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Office.Desktop.Access_*.xml" 2^>nul') do if exist %%i set "OfficeAccess_License=%OfficeUWP%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Office.Desktop.Excel_*.xml" 2^>nul') do if exist %%i set "OfficeExcel_License=%OfficeUWP%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Office.Desktop.Outlook_*.xml" 2^>nul') do if exist %%i set "OfficeOutlook_License=%OfficeUWP%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Office.Desktop.PowerPoint_*.xml" 2^>nul') do if exist %%i set "OfficePowerPoint_License=%OfficeUWP%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Office.Desktop.Publisher_*.xml" 2^>nul') do if exist %%i set "OfficePublisher_License=%OfficeUWP%\%%i"
for /f %%i IN ('"dir /b *Microsoft.Office.Desktop.Word_*.xml" 2^>nul') do if exist %%i set "OfficeWord_License=%OfficeUWP%\%%i"

cd /d "%ROOT%\"

cls
echo.===============================================================================
echo.         MSMG ToolKit - Integrate Microsoft Office Desktop ^(UWP^) Apps
echo.===============================================================================
echo.
echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft Office Desktop ^(UWP^) Apps####################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
if "%OfficeUWPApp%" equ "AllOfficeApps" echo.####Integrating Microsoft Office Desktop ^(UWP^) Apps############################
if "%OfficeUWPApp%" equ "OfficeAccess" echo.####Integrating Microsoft Office Desktop - Access ^(UWP^) Apps###################
if "%OfficeUWPApp%" equ "OfficeExcel" echo.####Integrating Microsoft Office Desktop - Excel ^(UWP^) Apps####################
if "%OfficeUWPApp%" equ "OfficeOutlook" echo.####Integrating Microsoft Office Desktop - Outlook ^(UWP^) Apps##################
if "%OfficeUWPApp%" equ "OfficePowerPoint" echo.####Integrating Microsoft Office Desktop - PowerPoint ^(UWP^) Apps###############
if "%OfficeUWPApp%" equ "OfficePublisher" echo.####Integrating Microsoft Office Desktop - Publisher ^(UWP^) Apps################
if "%OfficeUWPApp%" equ "OfficeWord" echo.####Integrating Microsoft Office Desktop - Word ^(UWP^) Apps#####################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		if "%OfficeUWPApp%" equ "OfficeAccess" %DISM% /Image:"%InstallMount%\%%i" /Add-ProvisionedAppxPackage /PackagePath:%OfficeDesktop_Appx% /OptionalPackagePath=%OfficeAccess_Appx% /LicensePath:%OfficeDesktop_License% /LicensePath:%OfficeAccess_License%
		if "%OfficeUWPApp%" equ "OfficeExcel" %DISM% /Image:"%InstallMount%\%%i" /Add-ProvisionedAppxPackage /PackagePath:%OfficeDesktop_Appx% /OptionalPackagePath=%OfficeExcel_Appx% /LicensePath:%OfficeDesktop_License% /LicensePath:%OfficeExcel_License%
		if "%OfficeUWPApp%" equ "OfficeOutlook" %DISM% /Image:"%InstallMount%\%%i" /Add-ProvisionedAppxPackage /PackagePath:%OfficeDesktop_Appx% /OptionalPackagePath=%OfficeOutlook_Appx% /LicensePath:%OfficeDesktop_License% /LicensePath:%OfficeOutlook_License%
		if "%OfficeUWPApp%" equ "OfficePowerPoint" %DISM% /Image:"%InstallMount%\%%i" /Add-ProvisionedAppxPackage /PackagePath:%OfficeDesktop_Appx% /OptionalPackagePath=%OfficePowerPoint_Appx% /LicensePath:%OfficeDesktop_License% /LicensePath:%OfficePowerPoint_License%
		if "%OfficeUWPApp%" equ "OfficePublisher" %DISM% /Image:"%InstallMount%\%%i" /Add-ProvisionedAppxPackage /PackagePath:%OfficeDesktop_Appx% /OptionalPackagePath=%OfficePublisher_Appx% /LicensePath:%OfficeDesktop_License% /LicensePath:%OfficePublisher_License%
		if "%OfficeUWPApp%" equ "OfficeWord" %DISM% /Image:"%InstallMount%\%%i" /Add-ProvisionedAppxPackage /PackagePath:%OfficeDesktop_Appx% /OptionalPackagePath=%OfficeWord_Appx% /LicensePath:%OfficeDesktop_License% /LicensePath:%OfficeWord_License%
		if "%OfficeUWPApp%" equ "AllOfficeApps" %DISM% /Image:"%InstallMount%\%%i" /Add-ProvisionedAppxPackage /PackagePath:%OfficeDesktop_Appx% /OptionalPackagePath=%OfficeAccess_Appx% /OptionalPackagePath=%OfficeExcel_Appx% /OptionalPackagePath=%OfficeOutlook_Appx% /OptionalPackagePath=%OfficePowerPoint_Appx% /OptionalPackagePath=%OfficePublisher_Appx% /OptionalPackagePath=%OfficeWord_Appx% /LicensePath:%OfficeDesktop_License% /LicensePath:%OfficeAccess_License% /LicensePath:%OfficeExcel_License% /LicensePath:%OfficeOutlook_License% /LicensePath:%OfficePowerPoint_License% /LicensePath:%OfficePublisher_License% /LicensePath:%OfficeWord_License%
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft Office Desktop ^(UWP^) Apps###################
echo.-------------------------------------------------------------------------------
echo.

:Stop
echo.===============================================================================
echo.
pause

set OfficeUWPApp=
set OfficeDesktop_Appx=
set OfficeAccess_Appx=
set OfficeExcel_Appx=
set OfficeOutlook_Appx=
set OfficePowerPoint_Appx=
set OfficePublisher_Appx=
set OfficeWord_Appx=

set OfficeDesktop_License=
set OfficeAccess_License=
set OfficeExcel_License=
set OfficeOutlook_License=
set OfficePowerPoint_License=
set OfficePublisher_License=
set OfficeWord_License=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Thin PC Add-on Features
::-------------------------------------------------------------------------------------------
:IntThinPcPkgs

if "%IsDialogsEnabled%" equ "Yes" (
	cls
	echo.===============================================================================
	echo.            MSMG ToolKit - Integrate Windows Thin PC Add-on Features
	echo.===============================================================================
	echo.
	echo.
	echo.
	echo.                              W A R N I N G
	echo.                              =============
	echo.
	echo.  Do not integrate any updates before integrating a language pack or
	echo.  any windows features. If you integrate any updates ^(Hotfix, General
	echo.  Distribution Release [GDR], Zero-Day Patch [ZDP] or Service Pack [SP]^)
	echo.  that contains language/feature-dependent resources before you integrate
	echo.  any updates, The language/feature-specific changes that are contained
	echo.  in the updates are not applied and you will have to re-integrate the
	echo.  updates. Always integrate language packs/Windows features before you
	echo.  install updates.
	echo.
	echo.
	echo.  To turn off Warning Dialogs, Choose Disable Dialogs in Tools-^>Options Menu
	echo.
	echo.===============================================================================
	echo.
	choice /C:YN /N /M "Do you want to Continue ? ['Y'es/'N'o] : "
	if errorlevel 2 goto :IntegrateMenu
)

setlocal

set Feature=

cls
echo.===============================================================================
echo.          MSMG ToolKit - Integrate Windows Thin PC Add-on Features
echo.===============================================================================

:: Checking whether Multi-Index servicing mode is selected
if "%ImageIndexNo:~0,2%" equ "," (
	echo.This feature is not available when Multi-Index servicing mode is enabled...
	echo.
	echo.Please Re-Choose source with a Single Index...
	goto :Stop
)

:: Checking whether the selected Source OS is a Windows Thin PC OS
if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" neq "Embedded" (
	echo.Selected Source OS is not a Windows Thin PC OS..
	echo.
	echo.Please use Windows Thin PC Source OS..
	goto :Stop
)

echo.  [A]  Microsoft .NET Framework 3.5 with Client Profile
echo.  [B]  Windows Backup ^& Restore
echo.  [C]  Windows Basic Help
echo.  [D]  Windows Defender
echo.  [E]  Windows DVD Maker
echo.  [F]  Windows Fax ^& Scan
echo.  [G]  Windows ISO Burner
echo.  [H]  Windows Media Center
echo.  [I]  Windows Media Player Premium Codecs
echo.  [J]  Windows Mobility Center
echo.  [K]  Windows Parental Control
echo.  [L]  Windows Photo Viewer
echo.  [M]  Windows Search
echo.  [N]  Windows Speech ^& Text with Speech US English Pack
echo.  [O]  Windows Tablet PC Support
echo.
echo.  [1]  All Features
echo.
echo.  [X]  Go Back
echo.===============================================================================
choice /C:ABCDEFGHIJKLMNO1X /N /M "Enter your choice : "
if errorlevel 17 goto :IntegrateMenu
if errorlevel 16 set "Feature=All"
if errorlevel 15 set "Feature=TabletPC"
if errorlevel 14 set "Feature=SpeechText"
if errorlevel 13 set "Feature=Search"
if errorlevel 12 set "Feature=PhotoViewer"
if errorlevel 11 set "Feature=ParentalControl"
if errorlevel 10 set "Feature=MobilityCenter"
if errorlevel 9  set "Feature=PremiumCodecs"
if errorlevel 8  set "Feature=MediaCenter"
if errorlevel 7  set "Feature=ISOBurner"
if errorlevel 6  set "Feature=FaxScan"
if errorlevel 5  set "Feature=DVDMaker"
if errorlevel 4  set "Feature=Defender"
if errorlevel 3  set "Feature=BasicHelp"
if errorlevel 2  set "Feature=BackupRestore"
if errorlevel 1  set "Feature=NetFx35"

cls
echo.===============================================================================
if "%Feature%" equ "NetFx35" echo.     MSMG ToolKit - Integrate Microsoft .NET Framework 3.5 Add-on Feature
if "%Feature%" equ "BackupRestore" echo.       MSMG ToolKit - Integrate Windows Backup ^& Restore Add-on Feature
if "%Feature%" equ "BasicHelp" echo.         MSMG ToolKit - Integrate Windows Basic Help Add-on Feature
if "%Feature%" equ "Defender" echo.          MSMG ToolKit - Integrate Windows Defender Add-on Feature
if "%Feature%" equ "DVDMaker" echo.          MSMG ToolKit - Integrate Windows DVD Maker Add-on Feature
if "%Feature%" equ "FaxScan" echo.           MSMG ToolKit - Integrate Windows Fax ^& Scan Add-on Feature
if "%Feature%" equ "ISOBurner" echo.          MSMG ToolKit - Integrate Windows ISO Burner Add-on Feature
if "%Feature%" equ "MediaCenter" echo.        MSMG ToolKit - Integrate Windows Media Center Add-on Feature
if "%Feature%" equ "PremiumCodecs" echo.     MSMG ToolKit - Integrate Windows Media Player Premium Codecs Features
if "%Feature%" equ "MobilityCenter" echo.        MSMG ToolKit - Integrate Windows Mobility Center Add-on Feature
if "%Feature%" equ "ParentalControl" echo.       MSMG ToolKit - Integrate Windows Parental Control Add-on Feature
if "%Feature%" equ "PhotoViewer" echo.          MSMG ToolKit - Integrate Windows Photo Viewer Add-on Feature
if "%Feature%" equ "Search" echo.             MSMG ToolKit - Integrate Windows Search Add-on Feature
if "%Feature%" equ "SpeechText" echo.        MSMG ToolKit - Integrate Windows Speech ^& Text Add-on Feature
if "%Feature%" equ "TabletPC" echo.          MSMG ToolKit - Integrate Windows Tablet PC Add-on Feature
if "%Feature%" equ "All" echo.            MSMG ToolKit - Integrate Windows Thin PC Add-on Features
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Windows Thin PC Add-on Features folder is empty
if not exist "%ThinPC%\*.*" (
	echo.Windows Thin PC Add-on Features folder ^<Packs\ThinPC^> is empty...
	echo.
	echo.Please copy Windows Thin PC Add-on Features files to respective folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
if "%Feature%" equ "NetFx35" echo.####Started Integrating Microsoft .NET Framework 3.5 Add-on Feature############
if "%Feature%" equ "BackupRestore" echo.####Started Integrating Windows Backup ^& Restore Add-on Feature#################
if "%Feature%" equ "BasicHelp" echo.####Started Integrating Windows Basic Help Add-on Feature######################
if "%Feature%" equ "Defender" echo.####Started Integrating Windows Defender Add-on Feature########################
if "%Feature%" equ "DVDMaker" echo.####Started Integrating Windows DVD Maker Add-on Feature#######################
if "%Feature%" equ "FaxScan" echo.####Started Integrating Windows Fax ^& Scan Add-on Feature######################
if "%Feature%" equ "ISOBurner" echo.####Started Integrating Windows ISO Burner Add-on Feature######################
if "%Feature%" equ "MediaCenter" echo.####Started Integrating Windows Media Center Add-on Feature####################
if "%Feature%" equ "PremiumCodecs" echo.####Started Integrating Windows Media Player Premium Codecs Features###########
if "%Feature%" equ "MobilityCenter" echo.####Started Integrating Windows Mobility Center Add-on Feature#################
if "%Feature%" equ "ParentalControl" echo.####Started Integrating Windows Parental Control Add-on Feature################
if "%Feature%" equ "PhotoViewer" echo.####Started Integrating Windows Photo Viewer Add-on Feature####################
if "%Feature%" equ "Search" echo.####Started Integrating Windows Search Add-on Feature##########################
if "%Feature%" equ "SpeechText" echo.####Started Integrating Windows Speech ^& Text Add-on Feature###################
if "%Feature%" equ "TabletPC" echo.####Started Integrating Windows Tablet PC Add-on Feature#######################
if "%Feature%" equ "All" echo.####Started Integrating Windows Thin PC Add-on Features########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
if "%Feature%" equ "NetFx35" echo.####Integrating Microsoft .NET Framework 3.5 Add-on Feature####################
if "%Feature%" equ "BackupRestore" echo.####Integrating Windows Backup ^& Restore Add-on Feature#######################
if "%Feature%" equ "BasicHelp" echo.####Integrating Windows Basic Help Add-on Feature##############################
if "%Feature%" equ "Defender" echo.####Integrating Windows Defender Add-on Feature################################
if "%Feature%" equ "DVDMaker" echo.####Integrating Windows DVD Maker Add-on Feature###############################
if "%Feature%" equ "FaxScan" echo.####Integrating Windows Fax ^& Scan Add-on Feature##############################
if "%Feature%" equ "ISOBurner" echo.####Integrating Windows ISO Burner Add-on Feature##############################
if "%Feature%" equ "MediaCenter" echo.####Integrating Windows Media Center Add-on Feature############################
if "%Feature%" equ "PremiumCodecs" echo.####Integrating Windows Media Player Premium Codecs Features###################
if "%Feature%" equ "MobilityCenter" echo.####Integrating Windows Mobility Center Add-on Feature#########################
if "%Feature%" equ "ParentalControl" echo.####Integrating Windows Parental Control Add-on Feature########################
if "%Feature%" equ "PhotoViewer" echo.####Integrating Windows Photo Viewer Add-on Feature############################
if "%Feature%" equ "Search" echo.####Integrating Windows Search Add-on Feature##################################
if "%Feature%" equ "SpeechText" echo.####Integrating Windows Speech ^& Text Add-on Feature###########################
if "%Feature%" equ "TabletPC" echo.####Integrating Windows Tablet PC Add-on Feature###############################
if "%Feature%" equ "All" echo.####Integrating Windows Thin PC Add-on Features################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		if "%ImageEdition%" equ "Embedded" (
			if "%Feature%" equ "NetFx35" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft IIS Windows Process Activation Service Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-IIS-WAS~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 3.0 Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-NetFx30~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 3.0 Client Profile Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-NetFx30Client~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 3.5 Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-NetFx35~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 3.5 Client Profile Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-NetFx35Client~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
			)

			if "%Feature%" equ "BackupRestore" call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-BackupRestore~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
			if "%Feature%" equ "BasicHelp" call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-HelpEngine~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
			if "%Feature%" equ "Defender" call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-AntiMalware~31bf3856ad364e35~x86~~6.1.7601.17514.cab"

			if "%Feature%" equ "DVDMaker" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows DVD Maker Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-DVDBurning~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows ISO Burner Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-IMAPIv2~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
			)

			if "%Feature%" equ "FaxScan" call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Fax-Scan~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
			if "%Feature%" equ "ISOBurner" call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-IMAPIv2~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
			if "%Feature%" equ "MediaCenter" call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-MediaCenter~31bf3856ad364e35~x86~~6.1.7601.17514.cab"

			if "%Feature%" equ "PremiumCodecs" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player DOLBY AC3 Audio Encoder Premium Codec Package
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-DOLBY-AC3-AudioEncoder~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player MPEG2 Decoder Premium Codec Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-MPEG2-Decoder~31bf3856ad364e35~x86~~6.1.7600.16385.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player MPEG2 Encoder Premium Codec Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-MPEG2-Encoder~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player MPEG2 ^& Dolby Decoder Premium Codec Package..
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-MPEG2andDolbyDecoder~31bf3856ad364e35~x86~~6.1.7600.16385.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player MPEG3 Premium Codec Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-MPEG3~31bf3856ad364e35~x86~~6.1.7600.16385.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player MPEG4 Premium Codec Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-MPEG4~31bf3856ad364e35~x86~~6.1.7600.16385.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player WMV Premium Codec Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-WMV~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
			)

			if "%Feature%" equ "MobilityCenter" call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-MobilePC~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
			if "%Feature%" equ "ParentalControl" call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-ParentalControl~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
			if "%Feature%" equ "PhotoViewer" call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Photos-Viewer~31bf3856ad364e35~x86~~6.1.7601.17514.cab"

			if "%Feature%" equ "Search" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Natural Language Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Natural-Language~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Search Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Search~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
			)
			
			if "%Feature%" equ "SpeechText" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Speech ^& Text US English Language Pack Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Speech-LP-ENG~31bf3856ad364e35~x86~~6.1.7600.16385.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Speech ^& Text Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Speech~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
			)

			if "%Feature%" equ "TabletPC" call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Tablet~31bf3856ad364e35~x86~~6.1.7601.17514.cab"

			if "%Feature%" equ "All" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft IIS Windows Process Activation Service Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-IIS-WAS~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 3.0 Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-NetFx30~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 3.0 Client Profile Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-NetFx30Client~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 3.5 Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-NetFx35~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft .NET Framework 3.5 Client Profile Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-NetFx35Client~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Backup ^& Restore Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-BackupRestore~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Basic Help Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-HelpEngine~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Defender Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-AntiMalware~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows DVD Maker Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-DVDBurning~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Fax ^& Scan Feature...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Fax-Scan~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows ISO Burner Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-IMAPIv2~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Center Feature...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-MediaCenter~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player DOLBY AC3 Audio Encoder Premium Codec Package
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-DOLBY-AC3-AudioEncoder~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player MPEG2 Decoder Premium Codec Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-MPEG2-Decoder~31bf3856ad364e35~x86~~6.1.7600.16385.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player MPEG2 Encoder Premium Codec Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-MPEG2-Encoder~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player MPEG2 ^& Dolby Decoder Premium Codec Package..
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-MPEG2andDolbyDecoder~31bf3856ad364e35~x86~~6.1.7600.16385.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player MPEG3 Premium Codec Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-MPEG3~31bf3856ad364e35~x86~~6.1.7600.16385.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player MPEG4 Premium Codec Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-MPEG4~31bf3856ad364e35~x86~~6.1.7600.16385.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Media Player WMV Premium Codec Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-PremiumCodecs-WMV~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Mobility Center Feature...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-MobilePC~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Parental Control Feature...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-ParentalControl~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Photo Viewer Feature...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Photos-Viewer~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Natural Language Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Natural-Language~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Search Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Search~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Speech ^& Text US English Language Pack Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Speech-LP-ENG~31bf3856ad364e35~x86~~6.1.7600.16385.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Speech ^& Text Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Speech~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows Tablet PC Support Feature...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%ThinPC%\WinEmb-Tablet~31bf3856ad364e35~x86~~6.1.7601.17514.cab"
			)
		)

		if "%IsLogsEnabled%" equ "Yes" (
			echo.-------------------------------------------------------------------------------
			if "%Feature%" equ "NetFx35" echo.Generating Microsoft .NET Framework 3.5 Add-on Feature Integration Log...
			if "%Feature%" equ "BackupRestore" echo.Generating Windows Backup ^& Restore Add-on Feature Integration Log...
			if "%Feature%" equ "BasicHelp" echo.Generating Windows Basic Help Add-on Feature Integration Log...
			if "%Feature%" equ "Defender" echo.Generating Windows Defender Add-on Feature Integration Log...
			if "%Feature%" equ "DVDMaker" echo.Generating Windows DVD Maker Add-on Feature Integration Log...
			if "%Feature%" equ "FaxScan" echo.Generating Windows Fax ^& Scan Add-on Feature Integration Log...
			if "%Feature%" equ "ISOBurner" echo.Generating Windows ISO Burner Add-on Feature Integration Log...
			if "%Feature%" equ "MediaCenter" echo.Generating Windows Media Center Add-on Feature Integration Log...
			if "%Feature%" equ "PremiumCodecs" echo.Generating Windows Media Player Premium Codecs Features Integration Log...
			if "%Feature%" equ "MobilityCenter" echo.Generating Windows Mobility Center Add-on Feature Integration Log...
			if "%Feature%" equ "ParentalControl" echo.Generating Windows Parental Control Add-on Feature Integration Log...
			if "%Feature%" equ "PhotoViewer" echo.Generating Windows Photo Viewer Add-on Feature Integration Log...
			if "%Feature%" equ "Search" echo.Generating Windows Search Add-on Feature Integration Log...
			if "%Feature%" equ "SpeechText" echo.Generating Windows Speech ^& Text Add-on Feature Integration Log...
			if "%Feature%" equ "TabletPC" echo.Generating Windows Tablet PC Add-on Feature Integration Log...
			if "%Feature%" equ "All" echo.Generating Thin PC Add-on Features Integration Log...
			echo.-------------------------------------------------------------------------------
			echo.Writing Thin PC Add-on Features ^<Logs\ThinPC.txt^> Log file.
			call :GetPackages "%InstallMount%\%%i", "ThinPC.txt"
		)
	)
)

echo.
echo.-------------------------------------------------------------------------------
if "%Feature%" equ "NetFx35" echo.####Finished Integrating Microsoft .NET Framework 3.5 Add-on Feature###########
if "%Feature%" equ "BackupRestore" echo.####Finished Integrating Windows Backup ^& Restore Add-on Feature###############
if "%Feature%" equ "BasicHelp" echo.####Finished Integrating Windows Basic Help Add-on Feature#####################
if "%Feature%" equ "Defender" echo.####Finished Integrating Windows Defender Add-on Feature#######################
if "%Feature%" equ "DVDMaker" echo.####Finished Integrating Windows DVD Maker Add-on Feature######################
if "%Feature%" equ "FaxScan" echo.####Finished Integrating Windows Fax ^& Scan Add-on Feature#####################
if "%Feature%" equ "ISOBurner" echo.####Finished Integrating Windows ISO Burner Add-on Feature#####################
if "%Feature%" equ "MediaCenter" echo.####Finished Integrating Windows Media Center Add-on Feature###################
if "%Feature%" equ "PremiumCodecs" echo.####Finished Integrating Windows Media Player Premium Codecs Features##########
if "%Feature%" equ "MobilityCenter" echo.####Finished Integrating Windows Mobility Center Add-on Feature################
if "%Feature%" equ "ParentalControl" echo.####Finished Integrating Windows Parental Control Add-on Feature###############
if "%Feature%" equ "PhotoViewer" echo.####Finished Integrating Windows Photo Viewer Add-on Feature###################
if "%Feature%" equ "Search" echo.####Finished Integrating Windows Search Add-on Feature#########################
if "%Feature%" equ "SpeechText" echo.####Finished Integrating Windows Speech ^& Text Add-on Feature##################
if "%Feature%" equ "TabletPC" echo.####Finished Integrating Windows Tablet PC Add-on Feature######################
if "%Feature%" equ "All" echo.####Finished Integrating Windows Thin PC Add-on Features#######################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set Feature=

endlocal

:: Returning to Integrate Windows Thin PC Add-on Features Menu
goto :IntThinPcPkgs
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft Diagnostics and Recovery Toolset ^(DaRT^) 7.0/8.1/10/11
::-------------------------------------------------------------------------------------------
:IntDaRT

setlocal

set DartType=
set DebugTools=
set PackageLanguage=

cls
echo.===============================================================================
if "%SelectedSourceOS%" equ "w7" echo.              MSMG ToolKit - Integrate Microsoft DaRT 7.0 Tools
if "%SelectedSourceOS%" equ "w81" echo.              MSMG ToolKit - Integrate Microsoft DaRT 8.1 Tools
if "%SelectedSourceOS%" equ "w10" echo.               MSMG ToolKit - Integrate Microsoft DaRT 10 Tools
if "%SelectedSourceOS%" equ "w11" echo.               MSMG ToolKit - Integrate Microsoft DaRT 11 Tools
echo.===============================================================================

if "%IsDialogsEnabled%" equ "Yes" (
	echo.
	echo.
	echo.                              W A R N I N G
	echo.                              =============
	echo.
	echo. Microsoft DaRT 8.1/10/11 Tools includes functionality that lets an
	echo. administrator or a help desk worker run the DaRT tools remotely to resolve
	echo. problems on an end-user computer. In addition, you can save the International
	echo. Organization for Standardization ^(ISO^) image to a USB flash drive or put the
	echo. ISO image on a network to include its contents as a recovery partition on a
	echo. computer's hard disk. These capabilities provide flexibility, but also create
	echo. potential security risks that you should consider when configuring DaRT.
	echo.
	echo.
	echo.
	echo.
	echo. To turn off Warning Dialogs, Choose Disable Dialogs in Tools-^>Options Menu
	echo.
	echo.===============================================================================
	echo.
	choice /C:YN /N /M "Do you want to Continue ? ['Y'es/'N'o] : "
	if errorlevel 2 goto :IntegrateMenu
)

cls
echo.===============================================================================
if "%SelectedSourceOS%" equ "w7" echo.              MSMG ToolKit - Integrate Microsoft DaRT 7.0 Tools
if "%SelectedSourceOS%" equ "w81" echo.              MSMG ToolKit - Integrate Microsoft DaRT 8.1 Tools
if "%SelectedSourceOS%" equ "w10" echo.               MSMG ToolKit - Integrate Microsoft DaRT 10 Tools
if "%SelectedSourceOS%" equ "w11" echo.               MSMG ToolKit - Integrate Microsoft DaRT 11 Tools
echo.===============================================================================
echo.
echo.  [1]  Integrate to Windows Setup Boot Image
echo.
if "%SelectedSourceOS%" neq "w7" (
	echo.  [2]  Integrate to Windows Recovery Image
	echo.
)
if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" neq "Embedded" (
	echo.  [2]  Integrate to Windows Recovery Image
	echo.
)
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.  [X]  Go Back
echo.
echo.===============================================================================
echo.
choice /C:12X /N /M "Enter Your Choice : "
if errorlevel 3 goto :IntegrateMenu
if errorlevel 2 set "DartType=Recovery"
if errorlevel 1 set "DartType=Boot"

cls
echo.===============================================================================
if "%SelectedSourceOS%" equ "w7" echo.              MSMG ToolKit - Integrate Microsoft DaRT 7.0 Tools
if "%SelectedSourceOS%" equ "w81" echo.              MSMG ToolKit - Integrate Microsoft DaRT 8.1 Tools
if "%SelectedSourceOS%" equ "w10" echo.               MSMG ToolKit - Integrate Microsoft DaRT 10 Tools
if "%SelectedSourceOS%" equ "w11" echo.               MSMG ToolKit - Integrate Microsoft DaRT 11 Tools
echo.===============================================================================
echo.

:: Checking whether the Source Boot Image is selected
if "%DartType%" equ "Boot" if "%IsBootImageSelected%" equ "No" (
	echo.Windows Setup Boot Image is not selected...
	echo.
	echo.Please choose Windows Setup Boot Image while selecting Source...
	goto :Stop
)

:: Checking whether the Source Recovery Image is selected
if "%DartType%" equ "Recovery" if "%IsRecoveryImageSelected%" equ "No" (
	echo.Windows Recovery Image Is not selected...
	echo.
	echo.Please choose Windows Recovery Image while selecting Source...
	goto :Stop
)

:: Setting Microsoft DaRT Tools Pack folder path
set "DaRT=%DaRT%\%SelectedSourceOS%"
set "DebugTools=DebugTools_%PackageVersion%.tpk"

:: Setting Package Language
for /d %%i in (ar-SA,bg-BG,cs-CZ,da-DK,el-GR,en-GB,en-US,et-EE,fi-FI,he-IL,hr-HR,hu-HU,lt-LT,lv-LV,nb-NO,nl-NL,pl-PL,ro-RO,sk-SK,sl-SI,sr-Latn-CS,sr-Latn-RS,sv-SE,th-TH,tr-TR,uk-UA) do (
	if "%ImageDefaultLanguage%" equ "%%i" set "PackageLanguage=en-US"
)

for /d %%l in (de-DE,es-ES,fr-FR,it-IT,ja-JP,ko-KR,pt-BR,ru-RU,zh-CN,zh-TW) do (
   if "%ImageDefaultLanguage%" equ "%%l" set "PackageLanguage=%%l"
)

if "%ImageDefaultLanguage%" equ "es-MX" set "PackageLanguage=es-ES"
if "%ImageDefaultLanguage%" equ "fr-CA" set "PackageLanguage=fr-FR"
if "%ImageDefaultLanguage%" equ "pt-PT" set "PackageLanguage=pt-BR"
if "%ImageDefaultLanguage%" equ "zh-HK" set "PackageLanguage=zh-TW"

:: Checking whether Microsoft DaRT 7/8.1/10/11 Tools Base Package file exist
if not exist "%DaRT%\DaRT.tpk" (
	if "%SelectedSourceOS%" equ "w7" echo.Microsoft DaRT 7 Tools Pack file "DaRT.tpk" not found...
	if "%SelectedSourceOS%" equ "w81" echo.Microsoft DaRT 8.1 Tools Pack file "DaRT.tpk" not found...
	if "%SelectedSourceOS%" equ "w10" echo.Microsoft DaRT 10 Tools Pack file "DaRT.tpk" not found...
	if "%SelectedSourceOS%" equ "w11" echo.Microsoft DaRT 11 Tools Pack file "DaRT.tpk" not found...
	echo.
	echo.Please copy the above file to ^<Packs\DaRT\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Microsoft DaRT 7/8.1/10/11 Tools Language Package file exist
if not exist "%DaRT%\DaRT_%PackageLanguage%.tpk" (
	if "%SelectedSourceOS%" equ "w7" echo.Microsoft DaRT 7 Tools Pack file "DaRT_%PackageLanguage%.tpk" not found...
	if "%SelectedSourceOS%" equ "w81" echo.Microsoft DaRT 8.1 Tools Pack file "DaRT_%PackageLanguage%.tpk" not found...
	if "%SelectedSourceOS%" equ "w10" echo.Microsoft DaRT 10 Tools Pack file "DaRT_%PackageLanguage%.tpk" not found...
	if "%SelectedSourceOS%" equ "w11" echo.Microsoft DaRT 11 Tools Pack file "DaRT_%PackageLanguage%.tpk" not found...
	echo.
	echo.Please copy the above file to ^<Packs\DaRT\%SelectedSourceOS%^> folder...
	goto :Stop
)

:: Checking whether Microsoft DaRT 10/11 Debug Tools Package file exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%DaRT%\%DebugTools%" (
	if "%SelectedSourceOS%" equ "w10" echo.Microsoft DaRT 10 Tools Pack folder is missing the below file...
	if "%SelectedSourceOS%" equ "w11" echo.Microsoft DaRT 11 Tools Pack folder is missing the below file...
	echo.
	echo."%DebugTools%"
	echo.
	echo.Please copy the above file to ^<Packs\DaRT\%SelectedSourceOS%^> folder...
	goto :Stop
)

if "%DartType%" equ "Boot" (
	cls
	echo.===============================================================================
	if "%SelectedSourceOS%" equ "w7" echo.  MSMG ToolKit - Integrate Microsoft DaRT 7 Tools to Windows Setup Boot Image
	if "%SelectedSourceOS%" equ "w81" echo. MSMG ToolKit - Integrate Microsoft DaRT 8.1 Tools to Windows Setup Boot Image
	if "%SelectedSourceOS%" equ "w10" echo. MSMG ToolKit - Integrate Microsoft DaRT 10 Tools to Windows Setup Boot Image
	if "%SelectedSourceOS%" equ "w11" echo. MSMG ToolKit - Integrate Microsoft DaRT 11 Tools to Windows Setup Boot Image
	echo.===============================================================================
	echo.

	:: Getting Boot Image Index Architecture
	call :GetImageArchitecture "%BootWim%", 2 >nul

	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" echo.####Started Integrating Microsoft DaRT 7 Tools to Windows Boot Image###########
	if "%SelectedSourceOS%" equ "w81" echo.####Started Integrating Microsoft DaRT 8.1 Tools to Windows Boot Image#########
	if "%SelectedSourceOS%" equ "w10" echo.####Started Integrating Microsoft DaRT 10 Tools to Windows Boot Image##########
	if "%SelectedSourceOS%" equ "w11" echo.####Started Integrating Microsoft DaRT 11 Tools to Windows Boot Image##########
	echo.-------------------------------------------------------------------------------
	echo.
	echo.    Image                    : Boot.wim
	echo.    Image Index              : 2
	echo.    Image Architecture       : %ImageArchitecture%
	echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
	echo.
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" echo.####Integrating Microsoft DaRT 7 Tools to Windows Boot Image###################
	if "%SelectedSourceOS%" equ "w81" echo.####Integrating Microsoft DaRT 8.1 Tools to Windows Boot Image#################
	if "%SelectedSourceOS%" equ "w10" echo.####Integrating Microsoft DaRT 10 Tools to Windows Boot Image##################
	if "%SelectedSourceOS%" equ "w11" echo.####Integrating Microsoft DaRT 11 Tools to Windows Boot Image##################
	echo.-------------------------------------------------------------------------------
	echo.
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" echo.Integrating Microsoft DaRT 7 Tools Base Package...
	if "%SelectedSourceOS%" equ "w81" echo.Integrating Microsoft DaRT 8.1 Tools Base Package...
	if "%SelectedSourceOS%" equ "w10" echo.Integrating Microsoft DaRT 10 Tools Base Package...
	if "%SelectedSourceOS%" equ "w11" echo.Integrating Microsoft DaRT 11 Tools Base Package...
	echo.-------------------------------------------------------------------------------
	call :ApplyImage "%DaRT%\DaRT.tpk", %PackageIndex%, "%BootMount%\2"

	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%BootMount%\2\Windows\System32\fmapi.dll" (
		for /l %%i in (1, 1, %ImageCount%) do (
			if exist "%InstallMount%\%%i" copy /y "%InstallMount%\%%i\Windows\System32\fmapi.dll" "%BootMount%\2\Windows\System32" >nul
		)
	)

	call :RemoveFile "%BootMount%\2\Windows\System32\winpeshl.ini"
	echo.[LaunchApps]>>"%BootMount%\2\Windows\System32\winpeshl.ini"
	echo.%%windir%%\system32\wpeinit.exe>>"%BootMount%\2\Windows\System32\winpeshl.ini"
	echo.%%windir%%\system32\netstart.exe>>"%BootMount%\2\Windows\System32\winpeshl.ini"
	echo.%%systemdrive%%\setup.exe>>"%BootMount%\2\Windows\System32\winpeshl.ini"
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" echo.Integrating Microsoft DaRT 7 Tools [%PackageLanguage%] Language Package...
	if "%SelectedSourceOS%" equ "w81" echo.Integrating Microsoft DaRT 8.1 Tools [%PackageLanguage%] Language Package...
	if "%SelectedSourceOS%" equ "w10" echo.Integrating Microsoft DaRT 10 Tools [%PackageLanguage%] Language Package...
	if "%SelectedSourceOS%" equ "w11" echo.Integrating Microsoft DaRT 11 Tools [%PackageLanguage%] Language Package...
	echo.-------------------------------------------------------------------------------
	call :ApplyImage "%DaRT%\DaRT_%PackageLanguage%.tpk", %PackageIndex%, "%BootMount%\2"

	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w10" echo.Integrating Microsoft DaRT 10 Debug Tools Package...
		if "%SelectedSourceOS%" equ "w11" echo.Integrating Microsoft DaRT 11 Debug Tools Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%DaRT%\%DebugTools%", %PackageIndex%, "%BootMount%\2"
	)

	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" echo.####Finished Integrating Microsoft DaRT 7 Tools to Windows Boot Image##########
	if "%SelectedSourceOS%" equ "w81" echo.####Finished Integrating Microsoft DaRT 8.1 Tools to Windows Boot Image########
	if "%SelectedSourceOS%" equ "w10" echo.####Finished Integrating Microsoft DaRT 10 Tools to Windows Boot Image#########
	if "%SelectedSourceOS%" equ "w11" echo.####Finished Integrating Microsoft DaRT 11 Tools to Windows Boot Image#########
	echo.-------------------------------------------------------------------------------
)

if "%DartType%" equ "Recovery" (
	cls
	echo.===============================================================================
	if "%SelectedSourceOS%" equ "w7" echo.   MSMG ToolKit - Integrate Microsoft DaRT 7 Tools to Windows Recovery Image
	if "%SelectedSourceOS%" equ "w81" echo.  MSMG ToolKit - Integrate Microsoft DaRT 8.1 Tools to Windows Recovery Image
	if "%SelectedSourceOS%" equ "w10" echo.  MSMG ToolKit - Integrate Microsoft DaRT 10 Tools to Windows Recovery Image
	if "%SelectedSourceOS%" equ "w11" echo.  MSMG ToolKit - Integrate Microsoft DaRT 11 Tools to Windows Recovery Image
	echo.===============================================================================
	echo.
	:: Getting Recovery Image Index Architecture
	call :GetImageArchitecture "%InstallMount%\%DefaultIndexNo%\%WinReWim%", 1 >nul
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" echo.####Started Integrating Microsoft DaRT 7 Tools to Windows Recovery Image#######
	if "%SelectedSourceOS%" equ "w81" echo.####Started Integrating Microsoft DaRT 8.1 Tools to Windows Recovery Image#####
	if "%SelectedSourceOS%" equ "w10" echo.####Started Integrating Microsoft DaRT 10 Tools to Windows Recovery Image######
	if "%SelectedSourceOS%" equ "w11" echo.####Started Integrating Microsoft DaRT 11 Tools to Windows Recovery Image######
	echo.-------------------------------------------------------------------------------
	echo.
	echo.    Image                    : WinRE.wim
	echo.    Image Index              : 1
	echo.    Image Architecture       : %ImageArchitecture%
	echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
	echo.
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" echo.####Integrating Microsoft DaRT 7 Tools to Windows Recovery Image###############
	if "%SelectedSourceOS%" equ "w81" echo.####Integrating Microsoft DaRT 8.1 Tools to Windows Recovery Image#############
	if "%SelectedSourceOS%" equ "w10" echo.####Integrating Microsoft DaRT 10 Tools to Windows Recovery Image##############
	if "%SelectedSourceOS%" equ "w11" echo.####Integrating Microsoft DaRT 11 Tools to Windows Recovery Image##############
	echo.-------------------------------------------------------------------------------
	echo.
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" echo.Integrating Microsoft DaRT 7 Tools Base Package...
	if "%SelectedSourceOS%" equ "w81" echo.Integrating Microsoft DaRT 8.1 Tools Base Package...
	if "%SelectedSourceOS%" equ "w10" echo.Integrating Microsoft DaRT 10 Tools Base Package...
	if "%SelectedSourceOS%" equ "w11" echo.Integrating Microsoft DaRT 11 Tools Base Package...
	echo.-------------------------------------------------------------------------------
	call :ApplyImage "%DaRT%\DaRT.tpk", %PackageIndex%, "%WinReMount%"
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" copy /y "%InstallMount%\%DefaultIndexNo%\Windows\System32\fmapi.dll" "%WinReMount%\Windows\System32" >nul

	call :RemoveFile "%WinReMount%\Windows\System32\winpeshl.ini"
	echo.[LaunchApps]>>"%WinReMount%\Windows\System32\winpeshl.ini"
	echo.%%windir%%\system32\wpeinit.exe>>"%WinReMount%\Windows\System32\winpeshl.ini"
	echo.%%windir%%\system32\netstart.exe>>"%WinReMount%\Windows\System32\winpeshl.ini"
	echo.%%systemdrive%%\sources\recovery\recenv.exe>>"%WinReMount%\Windows\System32\winpeshl.ini"

	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" echo.Integrating Microsoft DaRT 7 Tools [%PackageLanguage%] Language Package...
	if "%SelectedSourceOS%" equ "w81" echo.Integrating Microsoft DaRT 8.1 Tools [%PackageLanguage%] Language Package...
	if "%SelectedSourceOS%" equ "w10" echo.Integrating Microsoft DaRT 10 Tools [%PackageLanguage%] Language Package...
	if "%SelectedSourceOS%" equ "w11" echo.Integrating Microsoft DaRT 11 Tools [%PackageLanguage%] Language Package...
	echo.-------------------------------------------------------------------------------
	call :ApplyImage "%DaRT%\DaRT_%PackageLanguage%.tpk", %PackageIndex%, "%WinReMount%"

	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
		echo.-------------------------------------------------------------------------------
		if "%SelectedSourceOS%" equ "w10" echo.Integrating Microsoft DaRT 10 Debug Tools Package...
		if "%SelectedSourceOS%" equ "w11" echo.Integrating Microsoft DaRT 11 Debug Tools Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%DaRT%\%DebugTools%", %PackageIndex%, "%WinReMount%"
	)

	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w7" echo.####Finished Integrating Microsoft DaRT 7 Tools to Windows Recovery Image######
	if "%SelectedSourceOS%" equ "w81" echo.####Finished Integrating Microsoft DaRT 8.1 Tools to Windows Recovery Image####
	if "%SelectedSourceOS%" equ "w10" echo.####Finished Integrating Microsoft DaRT 10 Tools to Windows Recovery Image#####
	if "%SelectedSourceOS%" equ "w11" echo.####Finished Integrating Microsoft DaRT 11 Tools to Windows Recovery Image#####
	echo.-------------------------------------------------------------------------------
)

:Stop
echo.
echo.===============================================================================
echo.
pause

set DaRT=
set DartType=
set DebugTools=
set PackageLanguage=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft DirectX 9.0c
::-------------------------------------------------------------------------------------------
:IntDirectX9c

setlocal

cls
echo.===============================================================================
echo.               MSMG ToolKit - Integrate Microsoft DirectX 9.0c
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Microsoft DirectX 9.0c Pack file exist
if not exist "%DirectX9c%\DirectX9c_%SelectedSourceOS%.tpk" (
	echo.Microsoft DirectX 9.0c Pack file "DirectX9c_%SelectedSourceOS%.tpk" not found...
	echo.
	echo.Please copy the above file to ^<Packs\DirectX9c^> folder...
	goto :Stop
)

:: Checking whether Microsoft DirectX 9.0c Pack file exist
if not exist "%DirectX9c%\DirectX9c_%SelectedSourceOS%_%ImageArchitecture%.reg" (
	echo.Microsoft DirectX 9.0c Pack file "DirectX9c_%SelectedSourceOS%_%ImageArchitecture%.reg" not found...
	echo.
	echo.Please copy the above file to ^<Packs\DirectX9c^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft DirectX 9.0c#################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft DirectX 9.0c#########################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft DirectX 9.0c Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%DirectX9c%\DirectX9c_%SelectedSourceOS%.tpk", %PackageIndex%, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------
		echo.Importing Microsoft DirectX 9.0c Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Importing Registry Settings to Image Registry...
		call :ImportRegistry2Image "%DirectX9c%\DirectX9c_%SelectedSourceOS%_%ImageArchitecture%.reg"
		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft DirectX 9.0c################################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft Games
::-------------------------------------------------------------------------------------------
:IntGames

setlocal

set Game=
set PackageLanguage=

cls
echo.===============================================================================
echo.                   MSMG ToolKit - Integrate Microsoft Games
echo.===============================================================================

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether the selected Source OS is a Windows 7 Client Edition
if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Client" if "%ImageEdition%" neq "HomePremium" if "%ImageEdition%" neq "HomePremiumN" if "%ImageEdition%" neq "Professional" if "%ImageEdition%" neq "ProfessionalN" if "%ImageEdition%" neq "Enterprise" if "%ImageEdition%" neq "EnterpriseN" if "%ImageEdition%" neq "Ultimate" if "%ImageEdition%" neq "UltimateN" (
	cls
	echo.===============================================================================
	echo.                MSMG ToolKit - Integrate Microsoft Games Menu
	echo.===============================================================================
	echo.  [A]  Carioca Rummy
	echo.  [B]  Chess Titans
	echo.  [C]  FreeCell
	echo.  [D]  Hearts
	echo.  [E]  Hold 'Em
	echo.  [F]  Inkball
	echo.  [G]  Mahjong Titans
	echo.  [H]  Minesweeper
	echo.  [I]  Pinball
	echo.  [J]  Purble Place
	echo.  [K]  Solitaire
	echo.  [L]  Spider Solitaire
	echo.  [M]  Sudoku
	echo.  [N]  Tinker
	echo.
	echo.  [1]  All Games
	echo.
	echo.  [X]  Go Back
	echo.===============================================================================
	echo.
	choice /C:ABCDEFGHIJKLMN1X /N /M "Enter your choice : "
	if errorlevel 16 goto :IntFeaturesMenu
	if errorlevel 15 set "Game=AllGames"
	if errorlevel 14 set "Game=Tinker"
	if errorlevel 13 set "Game=Sudoku"
	if errorlevel 12 set "Game=SpiderSolitaire"
	if errorlevel 11 set "Game=Solitaire"
	if errorlevel 10 set "Game=PurblePlace"
	if errorlevel 9  set "Game=Pinball"
	if errorlevel 8  set "Game=Minesweeper"
	if errorlevel 7  set "Game=MahjongTitans"
	if errorlevel 6  set "Game=Inkball"
	if errorlevel 5  set "Game=HoldEm"
	if errorlevel 4  set "Game=Hearts"
	if errorlevel 3  set "Game=FreeCell"
	if errorlevel 2  set "Game=ChessTitans"
	if errorlevel 1  set "Game=CariocaRummy"
)

:: Checking whether the selected Source OS is a Windows 7 Client Edition
if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Client" if "%ImageEdition%" neq "Starter" if "%ImageEdition%" neq "HomeBasic" (
	cls
	echo.===============================================================================
	echo.                MSMG ToolKit - Integrate Microsoft Games Menu
	echo.===============================================================================
	echo.
	echo.  [1]  Carioca Rummy
	echo.  [2]  Chess Titans
	echo.  [3]  Hold 'Em
	echo.  [4]  Inkball
	echo.  [5]  Mahjong Titans
	echo.  [6]  Pinball
	echo.  [7]  Sudoku
	echo.  [8]  Tinker
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [A]  All Games
	echo.  [X]  Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:12345678AX /N /M "Enter your choice : "
	if errorlevel 10 goto :IntFeaturesMenu
	if errorlevel 9  set "Game=AllGames"
	if errorlevel 8  set "Game=Tinker"
	if errorlevel 7  set "Game=Sudoku"
	if errorlevel 6  set "Game=Pinball"
	if errorlevel 5  set "Game=MahjongTitans"
	if errorlevel 4  set "Game=Inkball"
	if errorlevel 3  set "Game=HoldEm"
	if errorlevel 2  set "Game=ChessTitans"
	if errorlevel 1  set "Game=CariocaRummy"
)

:: Checking whether the selected Source OS is not a Windows 7 Client Edition
if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" neq "Client" (
	cls
	echo.===============================================================================
	echo.                MSMG ToolKit - Integrate Microsoft Games Menu
	echo.===============================================================================
	echo.  [A]  Carioca Rummy
	echo.  [B]  Chess Titans
	echo.  [C]  FreeCell
	echo.  [D]  Hearts
	echo.  [E]  Hold 'Em
	echo.  [F]  Inkball
	echo.  [G]  Mahjong Titans
	echo.  [H]  Minesweeper
	echo.  [I]  Pinball
	echo.  [J]  Purble Place
	echo.  [K]  Solitaire
	echo.  [L]  Spider Solitaire
	echo.  [M]  Sudoku
	echo.  [N]  Tinker
	echo.
	echo.  [1]  All Games
	echo.
	echo.  [X]  Go Back
	echo.===============================================================================
	echo.
	choice /C:ABCDEFGHIJKLMN1X /N /M "Enter your choice : "
	if errorlevel 16 goto :IntFeaturesMenu
	if errorlevel 15 set "Game=AllGames"
	if errorlevel 14 set "Game=Tinker"
	if errorlevel 13 set "Game=Sudoku"
	if errorlevel 12 set "Game=SpiderSolitaire"
	if errorlevel 11 set "Game=Solitaire"
	if errorlevel 10 set "Game=PurblePlace"
	if errorlevel 9  set "Game=Pinball"
	if errorlevel 8  set "Game=Minesweeper"
	if errorlevel 7  set "Game=MahjongTitans"
	if errorlevel 6  set "Game=Inkball"
	if errorlevel 5  set "Game=HoldEm"
	if errorlevel 4  set "Game=Hearts"
	if errorlevel 3  set "Game=FreeCell"
	if errorlevel 2  set "Game=ChessTitans"
	if errorlevel 1  set "Game=CariocaRummy"
)

:: Checking whether the selected Source OS is not Windows 7
if "%SelectedSourceOS%" neq "w7" (
	cls
	echo.===============================================================================
	echo.                MSMG ToolKit - Integrate Microsoft Games Menu
	echo.===============================================================================
	echo.  [A]  Carioca Rummy
	echo.  [B]  Chess Titans
	echo.  [C]  FreeCell
	echo.  [D]  Hearts
	echo.  [E]  Hold 'Em
	echo.  [F]  Inkball
	echo.  [G]  Mahjong Titans
	echo.  [H]  Minesweeper
	echo.  [I]  Pinball
	echo.  [J]  Purble Place
	echo.  [K]  Solitaire
	echo.  [L]  Spider Solitaire
	echo.  [M]  Sudoku
	echo.  [N]  Tinker
	echo.
	echo.  [1]  All Games
	echo.
	echo.  [X]  Go Back
	echo.===============================================================================
	echo.
	choice /C:ABCDEFGHIJKLMN1X /N /M "Enter your choice : "
	if errorlevel 16 goto :IntFeaturesMenu
	if errorlevel 15 set "Game=AllGames"
	if errorlevel 14 set "Game=Tinker"
	if errorlevel 13 set "Game=Sudoku"
	if errorlevel 12 set "Game=SpiderSolitaire"
	if errorlevel 11 set "Game=Solitaire"
	if errorlevel 10 set "Game=PurblePlace"
	if errorlevel 9  set "Game=Pinball"
	if errorlevel 8  set "Game=Minesweeper"
	if errorlevel 7  set "Game=MahjongTitans"
	if errorlevel 6  set "Game=Inkball"
	if errorlevel 5  set "Game=HoldEm"
	if errorlevel 4  set "Game=Hearts"
	if errorlevel 3  set "Game=FreeCell"
	if errorlevel 2  set "Game=ChessTitans"
	if errorlevel 1  set "Game=CariocaRummy"
)
cls
echo.===============================================================================
echo.                   MSMG ToolKit - Integrate Microsoft Games
echo.===============================================================================
echo.

:: Checking whether Microsoft Games Pack file exist
if not exist "%Games%\Games_%ImageArchitecture%.tpk" (
	echo.Microsoft Games Pack file "Games_%ImageArchitecture%.tpk" not found...
	echo.
	echo.Please copy the above file to ^<Packs\Games^> folder...
	goto :Stop
)

:: Checking whether Microsoft Games Pack file exist
if not exist "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk" (
	echo.Microsoft Games Pack file "Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk" not found...
	echo.
	echo.Please copy the above file to ^<Packs\Games^> folder...
	goto :Stop
)

:: Checking whether Microsoft Games Pack file exist
for %%j in (ChessTitans,FreeCell,Hearts,Inkball,MahjongTitans,Minesweeper,Pinball,PurblePlace,Solitaire,SpiderSolitaire) do (
	if "%Game%" equ "%%j" if not exist "%Games%\%Game%.reg" (
		echo.Microsoft Games Pack file "%Game%.reg" not found...
		echo.
		echo.Please copy the above file to ^<Packs\Games^> folder...
		goto :Stop
	)
)

:: Checking whether Microsoft Games Pack file exist
for %%j in (AllGames,CariocaRummy,HoldEm,Sudoku,Tinker) do (
	if "%Game%" equ "%%j" if not exist "%Games%\%Game%_%ImageArchitecture%.reg" (
		echo.Microsoft Games Pack file "%Game%_%ImageArchitecture%.reg" not found...
		echo.
		echo.Please copy the above file to ^<Packs\Games^> folder...
		goto :Stop
	)
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft Games########################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft Games################################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft Games Base Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 1, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft Games Base [%ImageDefaultLanguage%] Language Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 1, "%InstallMount%\%%i"

		if "%Game%" equ "CariocaRummy" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Carioca Rummy Game Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 2, "%InstallMount%\%%i"
		)

		if "%Game%" equ "ChessTitans" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Chess Titans Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 3, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Chess Titans Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 2, "%InstallMount%\%%i"
		)

		if "%Game%" equ "FreeCell" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft FreeCell Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 4, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft FreeCell Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 3, "%InstallMount%\%%i"
		)

		if "%Game%" equ "Hearts" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hearts Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 5, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hearts Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 4, "%InstallMount%\%%i"
		)

		if "%Game%" equ "HoldEm" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hold 'Em Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 6, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hold 'Em Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 5, "%InstallMount%\%%i"
		)

		if "%Game%" equ "Inkball" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Inkball Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 7, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Inkball Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 6, "%InstallMount%\%%i"
		)

		if "%Game%" equ "MahjongTitans" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Mahjong Titans Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk",8, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Mahjong Titans Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 7, "%InstallMount%\%%i"
		)

		if "%Game%" equ "Minesweeper" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Minesweeper Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 9, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Minesweeper Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 8, "%InstallMount%\%%i"
		)

		if "%Game%" equ "Pinball" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Pinball Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 10, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Pinball Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 9, "%InstallMount%\%%i"
		)

		if "%Game%" equ "PurblePlace" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Purble Place Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 11, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Purble Place Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 10, "%InstallMount%\%%i"
		)

		if "%Game%" equ "Solitaire" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Solitaire Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 12, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Solitaire Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 11, "%InstallMount%\%%i"
		)

		if "%Game%" equ "SpiderSolitaire" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Spider Solitaire Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 13, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Spider Solitaire Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 12, "%InstallMount%\%%i"
		)

		if "%Game%" equ "Sudoku" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Sudoku Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 14, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Sudoku Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 13, "%InstallMount%\%%i"
		)

		if "%Game%" equ "Tinker" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Tinker Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 15, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Tinker Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 14, "%InstallMount%\%%i"
		)

		if "%Game%" equ "AllGames" if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Client" if "%ImageEdition%" neq "HomePremium" if "%ImageEdition%" neq "HomePremiumN" if "%ImageEdition%" neq "Professional" if "%ImageEdition%" neq "ProfessionalN" if "%ImageEdition%" neq "Enterprise" if "%ImageEdition%" neq "EnterpriseN" if "%ImageEdition%" neq "Ultimate" if "%ImageEdition%" neq "UltimateN" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Carioca Rummy Game Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 2, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Chess Titans Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 3, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Chess Titans Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 2, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft FreeCell Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 4, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft FreeCell Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 3, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hearts Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 5, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hearts Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 4, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hold 'Em Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 6, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hold 'Em Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 5, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Inkball Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 7, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Inkball Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 6, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Mahjong Titans Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk",8, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Mahjong Titans Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 7, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Minesweeper Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 9, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Minesweeper Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 8, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Pinball Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 10, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Pinball Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 9, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Purble Place Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 11, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Purble Place Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 10, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Solitaire Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 12, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Solitaire Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 11, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Spider Solitaire Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 13, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Spider Solitaire Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 12, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Sudoku Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 14, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Sudoku Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 13, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Tinker Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 15, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Tinker Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 14, "%InstallMount%\%%i"
		)

		if "%Game%" equ "AllGames" if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Client" if "%ImageEdition%" neq "Starter" if "%ImageEdition%" neq "StarterN" if "%ImageEdition%" neq "HomeBasic" if "%ImageEdition%" neq "HomeBasicN" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Carioca Rummy Game Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 2, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hold 'Em Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 6, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hold 'Em Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 5, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Inkball Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 7, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Inkball Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 6, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Pinball Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 10, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Pinball Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 9, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Sudoku Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 14, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Sudoku Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 13, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Tinker Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 15, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Tinker Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 14, "%InstallMount%\%%i"
		)

		if "%Game%" equ "AllGames" if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" neq "Client" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Carioca Rummy Game Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 2, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Chess Titans Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 3, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Chess Titans Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 2, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft FreeCell Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 4, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft FreeCell Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 3, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hearts Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 5, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hearts Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 4, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hold 'Em Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 6, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hold 'Em Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 5, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Inkball Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 7, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Inkball Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 6, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Mahjong Titans Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk",8, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Mahjong Titans Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 7, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Minesweeper Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 9, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Minesweeper Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 8, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Pinball Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 10, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Pinball Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 9, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Purble Place Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 11, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Purble Place Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 10, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Solitaire Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 12, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Solitaire Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 11, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Spider Solitaire Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 13, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Spider Solitaire Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 12, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Sudoku Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 14, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Sudoku Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 13, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Tinker Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 15, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Tinker Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 14, "%InstallMount%\%%i"
		)

		if "%Game%" equ "AllGames" if "%SelectedSourceOS%" neq "w7" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Carioca Rummy Game Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 2, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Chess Titans Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 3, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Chess Titans Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 2, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft FreeCell Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 4, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft FreeCell Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 3, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hearts Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 5, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hearts Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 4, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hold 'Em Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 6, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Hold 'Em Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 5, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Inkball Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 7, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Inkball Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 6, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Mahjong Titans Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk",8, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Mahjong Titans Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 7, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Minesweeper Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 9, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Minesweeper Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 8, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Pinball Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 10, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Pinball Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 9, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Purble Place Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 11, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Purble Place Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 10, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Solitaire Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 12, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Solitaire Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 11, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Spider Solitaire Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 13, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Spider Solitaire Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 12, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Sudoku Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 14, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Sudoku Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 13, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Tinker Game Base Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%.tpk", 15, "%InstallMount%\%%i"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Tinker Game [%ImageDefaultLanguage%] Language Package...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%Games%\Games_%ImageArchitecture%_%ImageDefaultLanguage%.tpk", 14, "%InstallMount%\%%i"
		)

		echo.-------------------------------------------------------------------------------
		echo.Importing Microsoft Games Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"

		echo.Importing Registry Settings to Image Registry...
		if "%Game%" equ "CariocaRummy" call :ImportRegistry2Image "%Games%\CariocaRummy_%ImageArchitecture%.reg"
		if "%Game%" equ "ChessTitans" call :ImportRegistry2Image "%Games%\ChessTitans.reg"
		if "%Game%" equ "FreeCell" call :ImportRegistry2Image "%Games%\FreeCell.reg"
		if "%Game%" equ "Hearts" call :ImportRegistry2Image "%Games%\Hearts.reg"
		if "%Game%" equ "HoldEm" call :ImportRegistry2Image "%Games%\HoldEm_%ImageArchitecture%.reg"
		if "%Game%" equ "Inkball" call :ImportRegistry2Image "%Games%\Inkball.reg"
		if "%Game%" equ "MahjongTitans" call :ImportRegistry2Image "%Games%\MahjongTitans.reg"
		if "%Game%" equ "Minesweeper" call :ImportRegistry2Image "%Games%\Minesweeper.reg"
		if "%Game%" equ "Pinball" call :ImportRegistry2Image "%Games%\Pinball.reg"
		if "%Game%" equ "PurblePlace" call :ImportRegistry2Image "%Games%\PurblePlace.reg"
		if "%Game%" equ "Solitaire" call :ImportRegistry2Image "%Games%\Solitaire.reg"
		if "%Game%" equ "SpiderSolitaire" call :ImportRegistry2Image "%Games%\SpiderSolitaire.reg"
		if "%Game%" equ "Sudoku" call :ImportRegistry2Image "%Games%\Sudoku_%ImageArchitecture%.reg"
		if "%Game%" equ "Tinker" call :ImportRegistry2Image "%Games%\Tinker_%ImageArchitecture%.reg"
		if "%Game%" equ "AllGames" (

			if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Client" (
				if "%ImageEdition%" neq "HomePremium" if "%ImageEdition%" neq "HomePremiumN" if "%ImageEdition%" neq "Professional" if "%ImageEdition%" neq "ProfessionalN" if "%ImageEdition%" neq "Enterprise" if "%ImageEdition%" neq "EnterpriseN" if "%ImageEdition%" neq "Ultimate" if "%ImageEdition%" neq "UltimateN" (
					call :ImportRegistry2Image "%Games%\AllGames_%ImageArchitecture%.reg"
				)
				if "%ImageEdition%" neq "Starter" if "%ImageEdition%" neq "StarterN" if "%ImageEdition%" neq "HomeBasic" if "%ImageEdition%" neq "HomeBasicN" (
					call :ImportRegistry2Image "%Games%\CariocaRummy_%ImageArchitecture%.reg"
					call :ImportRegistry2Image "%Games%\HoldEm_%ImageArchitecture%.reg"
					call :ImportRegistry2Image "%Games%\Inkball.reg"
					call :ImportRegistry2Image "%Games%\Sudoku_%ImageArchitecture%.reg"
					call :ImportRegistry2Image "%Games%\Tinker_%ImageArchitecture%.reg"
				)
				if "%ImageInstallationType%" neq "Client" call :ImportRegistry2Image "%Games%\AllGames_%ImageArchitecture%.reg"
			)

			if "%SelectedSourceOS%" neq "w7" call :ImportRegistry2Image "%Games%\AllGames_%ImageArchitecture%.reg"
		)

		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft Games#######################################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set Game=

endlocal

:: Returning to Integrate Microsoft Games Menu
goto :IntGames
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Sidebar
::-------------------------------------------------------------------------------------------
:IntSidebar

setlocal

cls
echo.===============================================================================
echo.                   MSMG ToolKit - Integrate Windows Sidebar
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Checking whether Windows Sidebar Pack file exist
if not exist "%Sidebar%\Sidebar.tpk" (
	echo.Windows Sidebar Pack file "Sidebar.tpk" not found...
	echo.
	echo.Please copy the above file to ^<Packs\Sidebar^> folder...
	goto :Stop
)

:: Checking whether Windows Sidebar Pack file exist
if not exist "%Sidebar%\Sidebar_%ImageDefaultLanguage%.tpk" (
	echo.Windows Sidebar Pack file "Sidebar_%ImageDefaultLanguage%.tpk" not found...
	echo.
	echo.Please copy the above file to ^<Packs\Sidebar^> folder...
	goto :Stop
)

:: Checking whether Windows Sidebar Pack file exist
if not exist "%Sidebar%\Sidebar_%ImageArchitecture%.reg" (
	echo.Windows Sidebar Pack file "Sidebar_%ImageArchitecture%.reg" not found...
	echo.
	echo.Please copy the above file to ^<Packs\Sidebar^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Sidebar########################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Sidebar################################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows Sidebar Base Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%Sidebar%\Sidebar.tpk", %PackageIndex%, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows Sidebar [%ImageDefaultLanguage%] Language Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%Sidebar%\Sidebar_%ImageDefaultLanguage%.tpk", %PackageIndex%, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------
		echo.Importing Windows Sidebar Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Taking Image Registry Ownership...
		echo.Importing Registry Settings to Image Registry...
		call :ImportRegistry2Image "%Sidebar%\Sidebar_%ImageArchitecture%.reg"
		call :ImportRegistry2Image "%Sidebar%\3rdPartyGadgets_%ImageArchitecture%.reg"
		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
		echo.

		:: Deleting Microsoft Sidebar Media Center files if the Source Edition is not MediaCenter
		if /i not exist "%InstallMount%\%%i\Windows\ehome" call :RemoveFolder "%InstallMount%\%%i\Program Files\Windows Sidebar\Gadgets\MediaCenter.Gadget"
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Sidebar#######################################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft Visual C++ Runtime
::-------------------------------------------------------------------------------------------
:IntVCRuntime

setlocal

cls
echo.===============================================================================
echo.            MSMG ToolKit - Integrate Microsoft Visual C++ Runtime
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Microsoft Visual C++ Runtime Pack folder path
set "VCRuntime=%VCRuntime%\%SelectedSourceOS%"

:: Checking whether Microsoft Visual C++ Runtime Pack file exist
if not exist "%VCRuntime%\VC.tpk" (
	echo.Microsoft Visual C++ Runtime Pack file "VC.tpk" not found...
	echo.
	echo.Please copy the above file to ^<Packs\VCRuntime\%SelectedSourceOS%^> folder...
	goto :Stop
)

if "%SelectedSourceOS%" equ "w7" if not exist "%VCRuntime%\Windows6.1-KB3118401-%ImageArchitecture%.cab" (
	echo.Microsoft Visual C++ Runtime Pack file "Windows6.1-KB3118401-%ImageArchitecture%.cab" not found...
	echo.
	echo.Please copy the above file to ^<Packs\VCRuntime\%SelectedSourceOS%^> folder...
	goto :Stop
)

if "%SelectedSourceOS%" equ "w81" if not exist "%VCRuntime%\Windows8.1-KB3118401-%ImageArchitecture%.cab" (
	echo.Microsoft Visual C++ Runtime Pack file "Windows8.1-KB3118401-%ImageArchitecture%.cab" not found...
	echo.
	echo.Please copy the above file to ^<Packs\VCRuntime\%SelectedSourceOS%^> folder...
	goto :Stop
)

for %%i in (Certificates, VC_2005, VC_2008, VC_2010, VC_2012, VC_2013, VC_2022, VC_Legacy) do (
	if not exist "%VCRuntime%\%%i_%ImageArchitecture%.reg" (
		echo.Microsoft Visual C++ Runtime Pack file "%%i_%ImageArchitecture%.reg" not found...
		echo.
		echo.Please copy the above file to ^<Packs\VCRuntime\%SelectedSourceOS%^> folder...
		goto :Stop
	)
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft Visual C++ Runtime###########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft Visual C++ Runtime###################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.

		:: Getting Image Index Information
		call :GetImageIndexInfo "%InstallWim%", %%i >nul

		if "%SelectedSourceOS%" neq "w10" if "%SelectedSourceOS%" neq "w11" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Microsoft Visual C++ Prerequiste Update Package...
			echo.-------------------------------------------------------------------------------
			if "%SelectedSourceOS%" equ "w7" call :AddPackage "%InstallMount%\%%i", "%VCRuntime%\Windows6.1-KB3118401-%ImageArchitecture%.cab"
			if "%SelectedSourceOS%" equ "w81" call :AddPackage "%InstallMount%\%%i", "%VCRuntime%\Windows8.1-KB3118401-%ImageArchitecture%.cab"
		)

		echo.-------------------------------------------------------------------------------
		echo.Integrating Microsoft Visual C++ Runtime Package...
		echo.-------------------------------------------------------------------------------
		call :ApplyImage "%VCRuntime%\VC.tpk", %PackageIndex%, "%InstallMount%\%%i"
		echo.-------------------------------------------------------------------------------
		echo.Importing Microsoft Visual C++ Runtime Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Importing Registry Settings to Image Registry...

		for %%i in (Certificates, VC_2005, VC_2008, VC_2010, VC_2012, VC_2013, VC_2022, VC_Legacy) do (
			call :ImportRegistry2Image "%VCRuntime%\%%i_%ImageArchitecture%.reg"
		)

		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft Visual C++ Runtime##########################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set VCRuntime=

endlocal

:: Returning to Integrate Features Menu
goto :IntFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Updates Menu
::-------------------------------------------------------------------------------------------
:IntUpdatesMenu

if "%IsDialogsEnabled%" equ "Yes" (
	cls
	echo.===============================================================================
	echo.                    MSMG ToolKit - Integrate Windows Updates
	echo.===============================================================================
	echo.
	echo.
	echo.
	echo.                              W A R N I N G
	echo.                              =============
	echo.
	echo.  Do not integrate any updates before integrating a language pack or
	echo.  any windows features. If you integrate any updates ^(Hotfix, General
	echo.  Distribution Release [GDR], Zero-Day Patch [ZDP] or Service Pack [SP]^)
	echo.  that contains language/feature-dependent resources before you integrate
	echo.  any updates, The language/feature-specific changes that are contained
	echo.  in the updates are not applied and you will have to re-integrate the
	echo.  updates. Always integrate language packs/Windows features before you
	echo.  install updates.
	echo.
	echo.
	echo.  To turn off Warning Dialogs, Choose Disable Dialogs in Tools-^>Options Menu
	echo.
	echo.===============================================================================
	echo.
	choice /C:YN /N /M "Do you want to Continue ? ['Y'es/'N'o] : "
	if errorlevel 2 goto :IntegrateMenu
)

cls
echo.===============================================================================
echo.                MSMG ToolKit - Integrate Windows Updates Menu
echo.===============================================================================
echo.
echo.  [1]   Integrate Windows Updates
echo.
echo.  [2]   Integrate WHD Update Pack
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.

choice /C:12X /N /M "Enter Your Choice : "
if errorlevel 3 goto :IntegrateMenu
if errorlevel 2 goto :IntWHDUpdatesMenu
if errorlevel 1 call :IntUpdates WUpdates

:IntWHDUpdatesMenu
cls
echo.===============================================================================
echo.               MSMG ToolKit - Integrate WHD Update Pack Menu
echo.===============================================================================
echo.
if "%SelectedSourceOS%" equ "w7" (
	echo.  [1]   Integrate WHD Update Pack with Service Pack 2
	echo.
	echo.  [2]   Integrate WHD Update Pack without Service Pack 2
	echo.
	echo.  [3]   Integrate Windows Setup Media Updates
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
)

if "%SelectedSourceOS%" equ "w81" (
	echo.  [1]   Integrate WHD Baseline Updates
	echo.
	echo.  [2]   Integrate WHD General Updates
	echo.
	echo.  [3]   Integrate WHD Hotfix Updates
	echo.
	echo.  [4]   Integrate WHD Security Updates
	echo.
	echo.  [5]   Integrate WHD Additional Updates
	echo.
	echo.  [6]   Integrate Windows Setup Media Updates
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
)

if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
	echo.  [1]   Integrate WHD General Updates
	echo.
	echo.  [2]   Integrate Windows Setup Media Updates
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
)

if "%SelectedSourceOS%" equ "w7" (
	choice /C:123X /N /M "Enter Your Choice : "
	if errorlevel 4 goto :IntegrateMenu
	if errorlevel 3 goto :IntWindowsSetupMediaUpdates
	if errorlevel 2 (
		set "IsW7SP1CRUSelected=No"
		goto :IntW7WHDUpdatesMenu
	)
	if errorlevel 1 (
		set "IsW7SP1CRUSelected=Yes"
		goto :IntW7WHDUpdatesMenu
	)
)

if "%SelectedSourceOS%" equ "w81" (
	choice /C:123456X /N /M "Enter Your Choice : "
	if errorlevel 7 goto :IntegrateMenu
	if errorlevel 6 goto :IntWindowsSetupMediaUpdates
	if errorlevel 5 goto :IntWHDAdditionalMenu
	if errorlevel 4 call :IntUpdates Security
	if errorlevel 3 call :IntUpdates Hotfix
	if errorlevel 2 call :IntUpdates General
	if errorlevel 1 goto :IntWHDBaselineMenu
)

if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
	choice /C:12X /N /M "Enter Your Choice : "
	if errorlevel 3 goto :IntegrateMenu
	if errorlevel 2 goto :IntWindowsSetupMediaUpdates
	if errorlevel 1 goto :IntWHDBaselineMenu
)

:IntW7WHDUpdatesMenu
if "%IsDialogsEnabled%" equ "Yes" if "%IsW7SP1CRUSelected%" equ "Yes" (
	cls
	echo.===============================================================================
	echo.          MSMG ToolKit - Integrate WHD Updates with Service Pack 2
	echo.===============================================================================
	echo.## Convenience Rollup Update for Windows 7 SP1 aka Service Pack 2 ##
	echo.
	echo.KB3125574 is a comprehensive rollup update that contains almost all fixes
	echo.released after Windows 7 SP1's release, up through April 2016.
	echo.
	echo.If you intend to integrate any of the following feature packages, integrate
	echo.them *first* ^(before KB3125574^) so the rollup can integrate their updated
	echo.components afterwards:
	echo.
	echo.DCA2.0, AD LDS, VirtualPC, WorkFolders, Server Essentials Connector found
	echo.in WHD Additional and Extra Updates section.
	echo.
	echo.This update aims to simplify the updating process for Windows 7, but it's
	echo.completely optional, and for due diligence purposes, be aware that it does
	echo.contain some telemetry updates components ^(3068708, 3075249^).
	echo.So if you do not want this, you should choose Integrate WHD Updates without
	echo.Service Pack 2 option from Integrate WHD Updates Menu.
	echo.
	echo.You could also block these telemetry effects while having the rollup integrated
	echo.refer to this topic for details: http://forums.mydigitallife.info/threads/68131
	echo.===============================================================================
	pause
)
cls
echo.===============================================================================
echo.                   MSMG ToolKit - Integrate WHD Updates Menu
echo.===============================================================================
echo.
if "%SelectedSourceOS%" equ "w7" (
	echo.  [1]   Integrate WHD Additional Updates
	echo.
	echo.  [2]   Integrate WHD Extra Updates
	echo.
	echo.  [3]   Integrate WHD General Updates
	echo.
	echo.  [4]   Integrate WHD Hotfix Updates
	echo.
	echo.  [5]   Integrate WHD Security Updates
	echo.
	echo.  [6]   Integrate WHD Extended Security Updates
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
)

if "%SelectedSourceOS%" equ "w7" (
	choice /C:123456X /N /M "Enter Your Choice : "
	if errorlevel 7 goto :IntegrateMenu
	if errorlevel 6 call :IntUpdates "ESU"
	if errorlevel 5 call :IntUpdates "Security"
	if errorlevel 4 call :IntUpdates "Hotfix"
	if errorlevel 3 call :IntUpdates "General"
	if errorlevel 2 goto :IntWHDExtraMenu
	if errorlevel 1 goto :IntWHDAdditionalMenu
)

:IntWHDBaselineMenu
cls

echo.===============================================================================
if "%SelectedSourceOS%" equ "w81" echo.               MSMG ToolKit - Integrate WHD Baseline Updates Menu
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.              MSMG ToolKit - Integrate WHD General Updates Menu
echo.===============================================================================
echo.
echo.  [1]   Integrate to Windows Setup Boot Image
echo.
echo.  [2]   Integrate to Windows Setup Install Image
echo.
echo.  [3]   Integrate to Windows Setup Install ^& Recovery Image
echo.
echo.  [4]   Integrate to Windows Setup Boot, Install ^& Recovery Image
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.
choice /C:1234X /N /M "Enter Your Choice : "
if errorlevel 5 goto :IntUpdatesMenu
if errorlevel 4 call :IntWHDBaseLine BootInstallRecovery
if errorlevel 3 call :IntWHDBaseLine InstallRecovery
if errorlevel 2 call :IntWHDBaseLine Install
if errorlevel 1 call :IntWHDBaseLine Boot

:IntWHDAdditionalMenu
cls

echo.===============================================================================
echo.             MSMG ToolKit - Integrate WHD Additional Updates Menu
echo.===============================================================================
echo.
if "%SelectedSourceOS%" equ "w7" (
	echo.  [1]   Integrate Windows Activation Technologies ^(WAT^)
	echo.
	echo.  [2]   Integrate Windows 10 Upgrade Prerequisites
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
)

if "%SelectedSourceOS%" equ "w81" (
	echo.  [1]   Integrate Microsoft .NET Framework 3.5 Updates
	echo.
	echo.  [2]   Integrate Windows 10 Upgrade Prerequisites
	echo.
	echo.  [3]   Integrate Windows PE Updates
	echo.
	echo.  [4]   Integrate Windows Update Satisfy Updates
	echo.
	echo.
	echo.
	echo.
)

echo.
echo.
echo.
echo.
echo.  [X]   Go Back
echo.
echo.===============================================================================
echo.
if "%SelectedSourceOS%" equ "w7" (
	choice /C:12X /N /M "Enter Your Choice : "
	if errorlevel 3 goto :IntW7WHDUpdatesMenu
	if errorlevel 2 call :IntUpdates "Windows10"
	if errorlevel 1 call :IntUpdates "WAT"
)

if "%SelectedSourceOS%" equ "w81" (
	choice /C:1234X /N /M "Enter Your Choice : "
	if errorlevel 5 goto :IntWHDUpdatesMenu
	if errorlevel 4 call :IntUpdates "WUSatisfy"
	if errorlevel 3 call :IntUpdates "WinPE"
	if errorlevel 2 call :IntUpdates "Windows10"
	if errorlevel 1 call :IntUpdates "NET35"
)

:IntWHDExtraMenu
cls

echo.===============================================================================
echo.                MSMG ToolKit - Integrate WHD Extra Updates Menu
echo.===============================================================================

if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "No" (
	echo.  [1]   Active Directory Lightweight Directory Services ^(ADLDS^)
	echo.
	echo.  [2]   File Management API
	echo.
	echo.  [3]   Microsoft Virtual PC
	echo.
	echo.  [4]   Windows Features Updates
	echo.
	echo.  [5]   Sync Agent for Domain Environmernts ^(Work Folders^)
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.===============================================================================
	echo.
)

if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "Yes" (
	echo.
	echo.  [1]   Active Directory Lightweight Directory Services ^(ADLDS^)
	echo.
	echo.  [2]   File Management API
	echo.
	echo.  [3]   Microsoft Virtual PC
	echo.
	echo.  [4]   Sync Agent for Domain Environmernts ^(Work Folders^)
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
)

if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "No" (
	choice /C:12345X /N /M "Enter Your Choice : "
	if errorlevel 6 goto :IntW7WHDUpdatesMenu
	if errorlevel 5 call :IntUpdates "WorkFolders"
	if errorlevel 4 call :IntUpdates "Features"
	if errorlevel 3 call :IntUpdates "VirtualPC"
	if errorlevel 2 call :IntUpdates "FMApi"
	if errorlevel 1 call :IntUpdates "ADLDS"
)

if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "Yes" (
	choice /C:1234X /N /M "Enter Your Choice : "
	if errorlevel 5 goto :IntW7WHDUpdatesMenu
	if errorlevel 4 call :IntUpdates "WorkFolders"
	if errorlevel 3 call :IntUpdates "VirtualPC"
	if errorlevel 2 call :IntUpdates "FMApi"
	if errorlevel 1 call :IntUpdates "ADLDS"
)

::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate WHD Baseline/General Updates to Windows Setup Boot, Install & Recovery Image
::-------------------------------------------------------------------------------------------
:IntWHDBaseline

setlocal

:: Setting WHD Updates Type
set "UpdateType=%~1"

cls
echo.===============================================================================
if "%UpdateType%" equ "Boot" (
	if "%SelectedSourceOS%" equ "w81" echo.   MSMG ToolKit - Integrate WHD Baseline Updates to Windows Setup Boot Image
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.    MSMG ToolKit - Integrate WHD General Updates to Windows Setup Boot Image
)

if "%UpdateType%" equ "Install" (
	if "%SelectedSourceOS%" equ "w81" echo. MSMG ToolKit - Integrate WHD Baseline Updates to Windows Setup Install Image
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.  MSMG ToolKit - Integrate WHD General Updates to Windows Setup Install Image
)

if "%UpdateType%" equ "InstallRecovery" (
	if "%SelectedSourceOS%" equ "w81" echo.                  MSMG ToolKit - Integrate WHD Baseline Updates
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.                   MSMG ToolKit - Integrate WHD General Updates
	echo.                    to Windows Setup Install ^& Recovery Images
)

if "%UpdateType%" equ "BootInstallRecovery" (
	if "%SelectedSourceOS%" equ "w81" echo.                  MSMG ToolKit - Integrate WHD Baseline Updates
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.                   MSMG ToolKit - Integrate WHD General Updates
	echo.                to Windows Setup Boot, Install ^& Recovery Images
)
echo.===============================================================================
echo.

if "%UpdateType%" neq "Install" if "%UpdateType%" neq "InstallRecovery" if "%IsBootImageSelected%" equ "No" (
	echo.Windows Setup Boot Image is not selected...
	echo.
	echo.Please choose Windows Setup Boot Image while selecting Source...
	goto :Stop
)

if "%UpdateType%" neq "Boot" if "%UpdateType%" neq "Install" if "%IsRecoveryImageSelected%" equ "No" (
	echo.Windows Recovery Image is not selected...
	echo.
	echo.Please choose Windows Recovery Image while selecting Source...
	goto :Stop
)

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Package Architecture
if "%ImageArchitecture%" equ "x86" set "PackageArchitecture=x86"
if "%ImageArchitecture%" equ "x64" set "PackageArchitecture=amd64"
if "%ImageArchitecture%" equ "arm64" set "PackageArchitecture=arm64"

:: Settings WHD Baseline Updates folder path
if "%SelectedSourceOS%" equ "w81" set "Updates=%WHD%\%SelectedSourceOS%\%ImageArchitecture%\Baseline"
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" set "Updates=%WHD%\%SelectedSourceOS%\%ImageArchitecture%\%PackageVersion%"

:: Checking whether WHD Baseline Updates folder is empty
if "%SelectedSourceOS%" equ "w81" (
	:: Windows 8.1 RTM (Build : 6.3.9600.16384)
	if %ImageServicePackBuild% equ 16384 if not exist "%Updates%\RTM\*.msu" if not exist "%Updates%\RTM\*.cab" (
		echo.WHD Baseline Updates folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Baseline\RTM^> is empty...
		echo.
		echo.Please copy WHD Baseline Updates to respective folder...
		goto :Stop
	)

	:: Windows 8.1 all Builds include Post-RTM
	if "%ImageServicePackBuild%" neq "16384" if not exist "%Updates%\*.msu" if not exist "%Updates%\*.cab" (
		echo.WHD Baseline Updates folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Baseline^> is empty...
		echo.
		echo.Please copy WHD Baseline Updates to respective folder...
		goto :Stop
	)
)

:: Windows 10
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if not exist "%Updates%\*.msu" if not exist "%Updates%\*.cab" (
	echo.WHD General Updates folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\%PackageVersion%^> is empty...
	echo.
	echo.Please copy WHD General Updates to respective folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
if "%SelectedSourceOS%" equ "w81" echo.##################Started Integrating WHD Baseline Updates#####################
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.##################Started Integrating WHD General Updates######################
if "%UpdateType%" equ "Boot" echo.########################to Windows Setup Boot Image#############################
if "%UpdateType%" equ "Install" echo.######################to Windows Setup Install Image############################
if "%UpdateType%" equ "InstallRecovery" echo.#################to Windows Setup Install ^& Recovery Images####################
if "%UpdateType%" equ "BootInstallRecovery" echo.##############to Windows Setup Boot, Install ^& Recovery Images##################
echo.-------------------------------------------------------------------------------
echo.
if "%UpdateType%" equ "Boot" (
	echo.    Image                    : Boot.wim
	echo.    Image Index              : 1, 2
)

if "%UpdateType%" equ "Install" (
	echo.    Image                    : Install.wim	
	echo.    Image Index              : %ImageIndexNo%
)

if "%UpdateType%" equ "InstallRecovery" (
	echo.    Image                    : Install.wim        ^|  WinRE.wim
	echo.    Image Index              : %ImageIndexNo%                  ^|      1
)

if "%UpdateType%" equ "BootInstallRecovery" (
	echo.    Image                    : Boot.wim         ^|  Install.wim   ^|  WinRE.wim
	echo.    Image Index              : 1, 2             ^|      %ImageIndexNo%         ^|      1
)

echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
if "%SelectedSourceOS%" equ "w81" echo.####Processing WHD Baseline Updates Packages###################################
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.####Processing WHD General Updates Packages####################################
echo.-------------------------------------------------------------------------------
echo.
:: Creating WHD Baseline Updates Temporary folder
if "%SelectedSourceOS%" equ "w81" echo.Creating WHD Baseline Updates Temporary folder...
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.Creating WHD General Updates Temporary folder...
call :RemoveFolder "%Temp%\Updates"
call :CreateFolder "%Temp%\Updates"
echo.

:: Extracting .CAB files From .MSU Package files to CAB Temporary folder
echo.Extracting Update Package files to Temporary folder...

:: Windows 8.1 RTM (Build : 6.3.9600.16384)
if "%SelectedSourceOS%" equ "w81" if %ImageServicePackBuild% equ 16384 (
   if exist "%Updates%\RTM\Windows8.1-KB2919355-%ImageArchitecture%*.msu" expand "%Updates%\RTM\Windows8.1-KB2919355-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\RTM\Windows8.1-KB2932046-%ImageArchitecture%*.msu" expand "%Updates%\RTM\Windows8.1-KB2932046-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB2934018-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB2934018-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\RTM\Windows8.1-KB2937592-%ImageArchitecture%*.msu" expand "%Updates%\RTM\Windows8.1-KB2937592-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\RTM\Windows8.1-KB2938439-%ImageArchitecture%*.msu" expand "%Updates%\RTM\Windows8.1-KB2938439-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\RTM\Windows8.1-KB2938772-%ImageArchitecture%*.msu" expand "%Updates%\RTM\Windows8.1-KB2938772-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3000850-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3000850-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3003057-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3003057-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3014442-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3014442-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul

   :: Copy .CAB files from .MSU package files to CAB Temporary folder
   if exist "%Updates%\RTM\Windows8.1-KB2919355-%ImageArchitecture%*.cab" %XCopy% "%Updates%\RTM\Windows8.1-KB2919355-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\RTM\Windows8.1-KB2932046-%ImageArchitecture%*.cab" %XCopy% "%Updates%\RTM\Windows8.1-KB2932046-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB2934018-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB2934018-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\RTM\Windows8.1-KB2937592-%ImageArchitecture%*.cab" %XCopy% "%Updates%\RTM\Windows8.1-KB2937592-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\RTM\Windows8.1-KB2938439-%ImageArchitecture%*.cab" %XCopy% "%Updates%\RTM\Windows8.1-KB2938439-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\RTM\Windows8.1-KB2938772-%ImageArchitecture%*.cab" %XCopy% "%Updates%\RTM\Windows8.1-KB2938772-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3000850-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3000850-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3003057-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3003057-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3014442-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3014442-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
)

:: Windows 8.1 with Update (IR3 Build : 6.3.9600.17031)
if "%SelectedSourceOS%" equ "w81" if "%ImageServicePackBuild%" equ "17031" (
   if exist "%Updates%\Windows8.1-KB2934018-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB2934018-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3000850-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3000850-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3003057-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3003057-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3014442-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3014442-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul

   :: Copy .CAB files from .MSU package files to CAB Temporary folder
   if exist "%Updates%\Windows8.1-KB2934018-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB2934018-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3000850-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3000850-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3003057-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3003057-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3014442-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3014442-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
)

:: Windows 8.1 with Update Refresh (IR4 Build : 6.3.9600.17056)
if "%SelectedSourceOS%" equ "w81" if "%ImageServicePackBuild%" equ "17056" (
   if exist "%Updates%\Windows8.1-KB3000850-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3000850-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3003057-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3003057-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3014442-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3014442-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul

   :: Copy .CAB files from .MSU package files to CAB Temporary folder
   if exist "%Updates%\Windows8.1-KB3000850-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3000850-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3003057-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3003057-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3014442-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3014442-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
)

:: Windows 8.1 with Update Refresh (IR5 Build : 6.3.9600.17415)
if "%SelectedSourceOS%" equ "w81" if "%ImageServicePackBuild%" equ "17415" (
   if exist "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.msu" expand "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates" >nul

   :: Copy .CAB files from .MSU package files to CAB Temporary folder
   if exist "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB3021910-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
   if exist "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.cab" %XCopy% "%Updates%\Windows8.1-KB5018922-%ImageArchitecture%*.cab" "%Temp%\Updates" >nul
)

:: Windows 10
if "%SelectedSourceOS%" equ "w10" (
	if exist "%Updates%\*.msu" (
		expand -R "%Updates%\*.msu" -F:Win*.cab "%Temp%\Updates" >nul

		if "%ImageBuild%" geq "17763" if exist "%Temp%\Updates\*.cab" (
			call :RemoveFolder "%Temp%\Updates\Temp"
			call :CreateFolder "%Temp%\Updates\Temp"

			for /f %%i in ('"dir /b %Temp%\Updates\*.cab" 2^>nul') do (
				expand -R "%Temp%\Updates\%%i" -F:Win*.cab "%Temp%\Updates\Temp" >nul
				expand -R "%Temp%\Updates\%%i" -F:SSU*.cab "%Temp%\Updates\Temp" >nul
				if exist "%Temp%\Updates\Temp\*.cab" move /y "%Temp%\Updates\Temp\*.cab" "%Temp%\Updates" >nul
			)

			call :RemoveFolder "%Temp%\Updates\Temp"
		)

		for /f %%i in ('"dir /b %Temp%\Updates\*.cab" 2^>nul') do (
			set Update=%%i
			set Update=!Update:~0,-4!
			call :CreateFolder "%Temp%\Updates\!Update!"
			expand -R "%Temp%\Updates\%%i" -F:* "%Temp%\Updates\!Update!" >nul
			if exist "%Temp%\Updates\!Update!\Cab_*.cab" expand -R "%Temp%\Updates\!Update!\Cab_*.cab" -F:* "%Temp%\Updates\!Update!" >nul
			call :RemoveFile "%Temp%\Updates\!Update!\Cab_*.cab"
		)

		call :RemoveFile "%Temp%\Updates\*.cab" >nul
	)

	if exist "%Updates%\*.cab" (
		for /f %%i in ('"dir /b %Updates%\*.cab" 2^>nul') do (
			set Update=%%i
			set Update=!Update:~0,-4!
			call :CreateFolder "%Temp%\Updates\!Update!"
			expand -R "%Updates%\%%i" -F:* "%Temp%\Updates\!Update!" >nul
			if exist "%Temp%\Updates\!Update!\Cab_*.cab" expand -R "%Temp%\Updates\!Update!\Cab_*.cab" -F:* "%Temp%\Updates\!Update!" >nul
			call :RemoveFile "%Temp%\Updates\!Update!\Cab_*.cab"
		)
	)

	if exist "%Updates%\defender-update-kit-%ImageArchitecture%.zip" (
		"%Zip%" x -y "%Updates%\defender-update-kit-%ImageArchitecture%.zip" -o"%Temp%\Updates\Defender" >nul
		expand -R "%Temp%\Updates\Defender\defender-dism-%ImageArchitecture%.cab" -F:* "%Temp%\Updates\Defender" >nul
		call :RemoveFile "%Temp%\Updates\Defender\defender-dism-%ImageArchitecture%.cab"
		call :RemoveFile "%Temp%\Updates\Defender\DefenderUpdateWinImage.ps1"
		call :RemoveFile "%Temp%\Updates\Defender\license.txt"
	)

	:: Renaming Windows Updates folder names matching to their respective update type
	cd /d "%Temp%\Updates\"

	for /f %%i in ('"dir /b *.*" 2^>nul') do (
		if exist "%%i\update.mum" (
			findstr /c:"Package_for_RollupFix" "%%i\update.mum" >nul
			if not errorlevel 1 ren "%%i" "Cumulative" >nul
		)

		if exist "%%i\update.mum" (
			findstr /c:"Package_for_DotNetRollup" "%%i\update.mum" >nul
			if not errorlevel 1 ren "%%i" "NetCumulative" >nul
		)

		if exist "%%i\update.mum" (
			findstr /c:"Update for Removal of Adobe Flash Player" "%%i\update.mum" >nul
			if not errorlevel 1 ren "%%i" "RemoveFlashPlayer" >nul
		)

		if exist "%%i\%PackageArchitecture%_microsoft-windows-m..update-genuineintel_*.manifest" ren "%%i" "CPUMicroCode" >nul
		if exist "%%i\package-defender.xml" ren "%%i" "Defender" >nul
		if exist "%%i\setuphost.exe" ren "%%i" "DVDMedia" >nul
		if exist "%%i\%PackageArchitecture%_microsoft-windows-19h2enablement_*.manifest" ren "%%i" "Enablement" >nul
		if not exist "%%i\%PackageArchitecture%_microsoft-windows-20h2enablement_*.manifest" if exist "%%i\%PackageArchitecture%_microsoft-windows-e..-firsttimeinstaller_*.manifest" ren "%%i" "EdgeChromium" >nul
		if exist "%%i\%PackageArchitecture%_microsoft-windows-20h2enablement_*.manifest" if not exist "%%i\%PackageArchitecture%_microsoft-windows-21h1enablement_*.manifest" if not exist "%%i\%PackageArchitecture%_microsoft-windows-22h1enablement_*.manifest" ren "%%i" "Enablement" >nul
		if exist "%%i\%PackageArchitecture%_microsoft-windows-20h2enablement_*.manifest" if exist "%%i\%PackageArchitecture%_microsoft-windows-21h1enablement_*.manifest" if not exist "%%i\%PackageArchitecture%_microsoft-windows-22h1enablement_*.manifest" ren "%%i" "Enablement" >nul
		if exist "%%i\%PackageArchitecture%_microsoft-windows-20h2enablement_*.manifest" if exist "%%i\%PackageArchitecture%_microsoft-windows-21h1enablement_*.manifest" if exist "%%i\%PackageArchitecture%_microsoft-windows-22h1enablement_*.manifest" ren "%%i" "Enablement" >nul
		if exist "%%i\%PackageArchitecture%_microsoft-windows-asosfe22h2enablement_*.manifest" ren "%%i" "Enablement" >nul
		if exist "%%i\%PackageArchitecture%_adobe-flash-for-*.manifest" if not exist "%%i\%PackageArchitecture%_microsoft-windows-21h1enablement_*.manifest" ren "%%i" "FlashPlayer" >nul
		if exist "%%i\Microsoft-Windows-NetFx3-OnDemand-Package~31bf3856ad364e35~%PackageArchitecture%~~10.0.*.mum" ren "%%i" "NET35" >nul
		if exist "%%i\Microsoft-Windows-NetFx3-OnDemand-Package~31bf3856ad364e35~%PackageArchitecture%~%ImageDefaultLanguage%~10.0.*.mum" ren "%%i" "NET35LP" >nul
		if exist "%%i\%PackageArchitecture%_wcf-m_sm_cfg_ins_exe_31bf3856ad364e35_10.0.*.manifest" ren "%%i" "NET35CDU" >nul
		if exist "%%i\%PackageArchitecture%_netfx4clientcorecomp_31bf3856ad364e35_*.manifest" ren "%%i" "NET48" >nul
		if exist "%%i\%PackageArchitecture%_netfx4clientcorecomp.resources_*%ImageDefaultLanguage%*.manifest" ren "%%i" "NET48LP" >nul
		if exist "%%i\%PackageArchitecture%_microsoft-windows-s..boot-firmwareupdate_*.manifest" ren "%%i" "SecureBoot" >nul
		if exist "%%i\%PackageArchitecture%_microsoft-windows-servicingstack_*.manifest" ren "%%i" "ServicingStack" >nul
		if exist "%%i\%PackageArchitecture%_microsoft-windows-userexperience-desktop_*.manifest" ren "%%i" "WindowsFeatureExperience" >nul
		if exist "%%i\%PackageArchitecture%_microsoft-windows-sysreset_*.manifest" ren "%%i" "SafeOS" >nul
	)

	cd /d "%ROOT%\"
)

:: Windows 11
if "%SelectedSourceOS%" equ "w11" (
	cd /d "%Temp%\Updates\"
	copy "%PSFExtractor%" "%Temp%\Updates" >nul
	copy "%PSFExtractor%.config" "%Temp%\Updates" >nul

	if exist "%Updates%\*.msu" (
		expand -R "%Updates%\*.msu" -F:SSU*.cab "%Temp%\Updates" >nul
		expand -R "%Updates%\*.msu" -F:Win*.cab "%Temp%\Updates" >nul
		expand -R "%Updates%\*.msu" -F:Win*.psf "%Temp%\Updates" >nul
	)

	if exist "%Updates%\*.cab" %XCopy% "%Updates%\*.cab" "%Temp%\Updates" >nul
	if exist "%Updates%\*.psf" %XCopy% "%Updates%\*.psf" "%Temp%\Updates" >nul

	if exist "%Temp%\Updates\*.psf" (
		for /f %%i in ('"dir /b %Temp%\Updates\SSU*.psf" 2^>nul') do (
			ren "%%i" "ServicingStack.psf"
			for /f %%j in ('"dir /b %Temp%\Updates\SSU*.cab" 2^>nul') do (ren "%%j" "ServicingStack.cab")
		)

		for /f "tokens=2 delims=-" %%i in ('"dir /b %Temp%\Updates\Windows*.psf" 2^>nul') do (
			for /f %%j in ('"dir /b %Temp%\Updates\*%%i*.cab" 2^>nul') do (ren "%%j" "Cumulative.cab")
			for /f %%j in ('"dir /b %Temp%\Updates\*%%i*.psf" 2^>nul') do (ren "%%j" "Cumulative.psf")
		)

		if exist "%Temp%\Updates\ServicingStack.psf" (
			md "%Temp%\Updates\ServicingStack"
			expand -f:* ServicingStack.cab "%Temp%\Updates\ServicingStack" >nul

			if exist "%Temp%\Updates\ServicingStack\*cablist.ini" (
				expand -f:* "%Temp%\Updates\ServicingStack\*.cab" "%Temp%\Updates\ServicingStack" >nul
  				call :RemoveFile "%Temp%\Updates\ServicingStack\*cablist.ini"
  				call :RemoveFile "%Temp%\Updates\ServicingStack\*.cab"
			)

			if not exist "%Temp%\Updates\ServicingStack\express.psf.cix.xml" (
				for /f %%# in ('dir /b /a:-d "%Temp%\Updates\ServicingStack\*.psf.cix.xml"') do (
					ren "%Temp%\Updates\ServicingStack\%%#" "%Temp%\Updates\ServicingStack\express.psf.cix.xml"
				)
			)

			PSFExtractor.exe ServicingStack.cab >nul
			call :RemoveFile "%Temp%\Updates\ServicingStack\express.psf.cix.xml"
			call :RemoveFile "%Temp%\Updates\ServicingStack.*"
		)

		if exist "%Temp%\Updates\Cumulative.psf" (
			md "%Temp%\Updates\Cumulative"
			expand -f:* Cumulative.cab "%Temp%\Updates\Cumulative" >nul

			if exist "%Temp%\Updates\Cumulative\*cablist.ini" (
				expand -f:* "%Temp%\Updates\Cumulative\*.cab" "%Temp%\Updates\Cumulative" >nul
  				call :RemoveFile "%Temp%\Updates\Cumulative\*cablist.ini"
  				call :RemoveFile "%Temp%\Updates\Cumulative\*.cab"
			)

			if not exist "%Temp%\Updates\Cumulative\express.psf.cix.xml" (
				for /f %%# in ('dir /b /a:-d "%Temp%\Updates\Cumulative\*.psf.cix.xml"') do (
					ren "%Temp%\Updates\Cumulative\%%#" "%Temp%\Updates\Cumulative\express.psf.cix.xml"
				)
			)
			
			PSFExtractor.exe Cumulative.cab >nul
			call :RemoveFile "%Temp%\Updates\Cumulative\*.psf.cix.xml"
			call :RemoveFile "%Temp%\Updates\Cumulative.*"
		)

		call :RemoveFile "%Temp%\Updates\PSFExtractor.exe"
		call :RemoveFile "%Temp%\Updates\PSFExtractor.exe.config"
	)

	if exist "%Temp%\Updates\*.cab" (
		for /f %%i in ('"dir /b %Temp%\Updates\*.cab" 2^>nul') do (
			set Update=%%i
			set Update=!Update:~0,-4!
			call :CreateFolder "%Temp%\Updates\!Update!"
			expand -R "%Temp%\Updates\%%i" -F:* "%Temp%\Updates\!Update!" >nul
		)

		call :RemoveFile "%Temp%\Updates\*.cab"
	)

	if exist "%Updates%\defender-update-kit-%ImageArchitecture%.zip" (
		"%Zip%" x -y "%Updates%\defender-update-kit-%ImageArchitecture%.zip" -o"%Temp%\Updates\Defender" >nul
		expand -R "%Temp%\Updates\Defender\defender-dism-%ImageArchitecture%.cab" -F:* "%Temp%\Updates\Defender" >nul
		call :RemoveFile "%Temp%\Updates\Defender\defender-dism-%ImageArchitecture%.cab"
		call :RemoveFile "%Temp%\Updates\Defender\DefenderUpdateWinImage.ps1"
		call :RemoveFile "%Temp%\Updates\Defender\license.txt"
	)

	:: Renaming Windows Updates folder names matching to their respective update type
	for /f %%i in ('"dir /b *.*" 2^>nul') do (
		if exist "%%i\update.mum" (
			findstr /c:"Package_for_ServicingStack" "%%i\update.mum" >nul
			if not errorlevel 1 ren "%%i" "ServicingStack" >nul
		)

		if exist "%%i\update.mum" (
			findstr /c:"Package_for_RollupFix" "%%i\update.mum" >nul
			if not errorlevel 1 ren "%%i" "Cumulative" >nul
		)

		if exist "%%i\update.mum" (
			findstr /c:"Package_for_DotNetRollup" "%%i\update.mum" >nul
			if not errorlevel 1 ren "%%i" "NetCumulative" >nul
		)

		if exist "%%i\update.mum" (
			findstr /c:"Microsoft .NET Framework 3.0 OnDemand" "%%i\update.mum" >nul
			if not errorlevel 1 ren "%%i" "NET35" >nul
		)

		if exist "%%i\%PackageArchitecture%_wcf-m_sm_cfg_ins_exe_31bf3856ad364e35_10.0.*.manifest" ren "%%i" "NET35CDU" >nul
		if exist "%%i\%PackageArchitecture%_microsoft-windows-m..update-genuineintel_*.manifest" ren "%%i" "CPUMicroCode" >nul
		if exist "%%i\package-defender.xml" ren "%%i" "Defender" >nul
		if exist "%%i\setuphost.exe" ren "%%i" "DVDMedia" >nul
		if exist "%%i\%PackageArchitecture%_microsoft-windows-sv2moment1enablement_*.manifest" if not exist "%%i\%PackageArchitecture%_microsoft-windows-sv2moment2enablement_*.manifest" ren "%%i" "Enablement" >nul
		if exist "%%i\%PackageArchitecture%_microsoft-windows-sv2moment2enablement_*.manifest" ren "%%i" "Enablement" >nul
		if "%%i" neq "Cumulative" if exist "%%i\%PackageArchitecture%_microsoft-windows-userexperience-desktop_*.manifest" ren "%%i" "WindowsFeatureExperience" >nul
		if "%%i" neq "Cumulative" if exist "%%i\%PackageArchitecture%_microsoft-windows-i..dsetup-rejuvenation_*.manifest" ren "%%i" "SafeOS" >nul
	)

	cd /d "%ROOT%\"
)

echo.
echo.Finished Extracting Update Package files to Temporary folder...
echo.
if "%UpdateType%" neq "Boot" if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "19045" if exist "%Temp%\Updates\Enablement\Update.mum" if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-e..-firsttimeinstaller_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h1enablement_*.manifest" (
	choice /C:YN /N /M "Do you want to skip integrating Microsoft Edge Chromium ? ['Y'es/'N'o] : "
	if !errorlevel! equ 1 (
		del /f /q "%Temp%\Updates\Enablement\Update.mum" >nul
		del /f /q "%Temp%\Updates\Enablement\Update.cat" >nul

		if "%ImageArchitecture%" equ "x86" (
			call :RemoveFolder "%Temp%\Updates\Enablement\x86_microsoft-windows-e..-firsttimeinstaller_31bf3856ad364e35_10.0.19041.681_none_d4e678d60dbf374c"
			move /y "%Temp%\Updates\Enablement\microsoft-windows-20h2enablement-package~31bf3856ad364e35~x86~~10.0.19041.681.cat" "%Temp%\Updates\Enablement\Update.cat" >nul
			move /y "%Temp%\Updates\Enablement\microsoft-windows-20h2enablement-package~31bf3856ad364e35~x86~~10.0.19041.681.mum" "%Temp%\Updates\Enablement\Update.mum" >nul
			del /f /q "%Temp%\Updates\Enablement\x86_88ed58c8b45ef5b335c7e00f1d272a1c_31bf3856ad364e35_*.manifest" >nul
			del /f /q "%Temp%\Updates\Enablement\x86_microsoft-windows-e..-firsttimeinstaller_31bf3856ad364e35_*.manifest" >nul
			del /f /q "%Temp%\Updates\Enablement\package_1_for_kb4562830~31bf3856ad364e35~x86~~*.mum" >nul
			del /f /q "%Temp%\Updates\Enablement\package_1_for_kb4562830~31bf3856ad364e35~x86~~*.cat" >nul
		)

		if "%ImageArchitecture%" equ "x64" (
			call :RemoveFolder "%Temp%\Updates\Enablement\amd64_microsoft-windows-e..-firsttimeinstaller_31bf3856ad364e35_10.0.19041.681_none_31051459c61ca882"
			del /f /q "%Temp%\Updates\Enablement\package_1_for_kb4562830~31bf3856ad364e35~amd64~~*.mum" >nul
			del /f /q "%Temp%\Updates\Enablement\package_1_for_kb4562830~31bf3856ad364e35~amd64~~*.cat" >nul
			del /f /q "%Temp%\Updates\Enablement\amd64_84b67765c88012e177d65b696e48302e_31bf3856ad364e35_*.manifest" >nul
			del /f /q "%Temp%\Updates\Enablement\amd64_microsoft-windows-e..-firsttimeinstaller_31bf3856ad364e35_*.manifest" >nul
			move /y "%Temp%\Updates\Enablement\microsoft-windows-20h2enablement-package~31bf3856ad364e35~amd64~~10.0.19041.681.cat" "%Temp%\Updates\Enablement\Update.cat" >nul
			move /y "%Temp%\Updates\Enablement\microsoft-windows-20h2enablement-package~31bf3856ad364e35~amd64~~10.0.19041.681.mum" "%Temp%\Updates\Enablement\Update.mum" >nul
		)

		if "%ImageArchitecture%" equ "arm64" (
			call :RemoveFolder "%Temp%\Updates\Enablement\arm64_microsoft-windows-e..-firsttimeinstaller_31bf3856ad364e35_10.0.19041.681_none_31051c93c61c9d1e"
			del /f /q "%Temp%\Updates\Enablement\package_1_for_kb4562830~31bf3856ad364e35~arm64~~*.mum" >nul
			del /f /q "%Temp%\Updates\Enablement\package_1_for_kb4562830~31bf3856ad364e35~arm64~~*.cat" >nul
			del /f /q "%Temp%\Updates\Enablement\arm64_d29030e5eb1fbfc0c65c0cd08e617938_31bf3856ad364e35_*.manifest" >nul
			del /f /q "%Temp%\Updates\Enablement\arm64_microsoft-windows-e..-firsttimeinstaller_31bf3856ad364e35_*.manifest" >nul
			move /y "%Temp%\Updates\Enablement\microsoft-windows-20h2enablement-package~31bf3856ad364e35~arm64~~10.0.19041.681.cat" "%Temp%\Updates\Enablement\Update.cat" >nul
			move /y "%Temp%\Updates\Enablement\microsoft-windows-20h2enablement-package~31bf3856ad364e35~arm64~~10.0.19041.681.mum" "%Temp%\Updates\Enablement\Update.mum" >nul
		)
	)
	echo.
)

if "%UpdateType%" neq "Install" if "%UpdateType%" neq "InstallRecovery" (
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w81" echo.####Integrating WHD Baseline Updates to Windows Setup Boot Image###############
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.####Integrating WHD General Updates to Windows Setup Boot Image################
	echo.-------------------------------------------------------------------------------
	echo.

	for /l %%i in (1, 1, 2) do (
		echo.=============================[Boot.wim, Index : %%i]=============================
		echo.
		:: Windows 8.1 RTM (Build : 6.3.9600.16384)
		if "%SelectedSourceOS%" equ "w81" if %ImageServicePackBuild% equ 16384 (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Prerequisite Update ^(KB3021910^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Update ^(KB2919355^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB2919355-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB3000850^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB3000850-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB2932046^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB2932046-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB2934018^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB2934018-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB2937592^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB2937592-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB2938439^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB2938439-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB2938772^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB2938772-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB3003057^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB3003057-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB5018922^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB5018922-%ImageArchitecture%.cab"
		)

		:: Windows 8.1 with Update (IR3 Build : 6.3.9600.17031)
		if "%SelectedSourceOS%" equ "w81" if "%ImageServicePackBuild%" equ "17031" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB3021910^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB5018922^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB5018922-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB3000850^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB3000850-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB2934018^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB2934018-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB3003057^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB3003057-%ImageArchitecture%.cab"
		)

		:: Windows 8.1 with Update (IR4 Build : 6.3.9600.17056)
		if "%SelectedSourceOS%" equ "w81" if "%ImageServicePackBuild%" equ "17056" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB3021910^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB5018922^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB5018922-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB3000850^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB3000850-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB3003057^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB3003057-%ImageArchitecture%.cab"
		)

		:: Windows 8.1 with Update Refresh (IR5 Build : 6.3.9600.17415)
		if "%SelectedSourceOS%" equ "w81" if "%ImageServicePackBuild%" equ "17415" (
			if exist "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB3021910^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab"
			)

			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB5018922^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Windows8.1-KB5018922-%ImageArchitecture%.cab"
		)

		:: Windows 10
		if "%SelectedSourceOS%" equ "w10" (
			if exist "%Temp%\Updates\ServicingStack\Update.mum" (
				if "%ImageBuild%" equ "10240" if "%ImageServicePackBuild%" equ "16384" (
					echo.-------------------------------------------------------------------------------
					echo.Applying Windows 10 v1507 Cumulative Update Integration Fix...
					echo.-------------------------------------------------------------------------------
					call :ApplyImage "%W10CUFix%\TH1CUFix.tpk", %PackageIndex%, "%BootMount%\%%i"
					call :MountImageRegistry "%BootMount%\%%i"
					call :ImportRegistry2Image "%W10CUFix%\TH1CUFix_%ImageArchitecture%.reg" 2>nul
					call :UnMountImageRegistry
				)

				if "%ImageArchitecture%" equ "x86" if "%ImageBuild%" equ "14393" if "%ImageServicePackBuild%" equ "0" (
					echo.-------------------------------------------------------------------------------
					echo.Applying Windows 10 v1607 Cumulative Update Integration Fix...
					echo.-------------------------------------------------------------------------------
					call :ApplyImage "%W10CUFix%\RS1CUFix.tpk", %PackageIndex%, "%BootMount%\%%i"
					call :MountImageRegistry "%BootMount%\%%i"
					call :ImportRegistry2Image "%W10CUFix%\RS1CUFix.reg" 2>nul
					call :UnMountImageRegistry
				)
			)
		)

		:: Windows 10/11
		if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
			if exist "%Temp%\Updates\ServicingStack\Update.mum" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows %OSID% Servicing Stack Update...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\ServicingStack"
			)

			if exist "%Temp%\Updates\General\Update.mum" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows 11 General Update...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\General"
			)

			if exist "%Temp%\Updates\Cumulative\Update.mum" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows %OSID% Cumulative Update...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Cumulative"
			)

			if exist "%Temp%\Updates\Enablement\Update.mum" (
				echo.-------------------------------------------------------------------------------
				if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-19h2enablement_*.manifest" (
					echo.Integrating Windows 10 v1909 Feature Enablement Update Package...
				)
				if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-20h2enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h1enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h2enablement_*.manifest" (
					echo.Integrating Windows 10 v20H2 Feature Enablement Update Package...
				)
				if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-20h2enablement_*.manifest" if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h1enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h2enablement_*.manifest" (
					echo.Integrating Windows 10 v21H1 Feature Enablement Update Package...
				)
				if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h2enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-22h2enablement_*.manifest" (
					echo.Integrating Windows 10 v21H2 Feature Enablement Update Package...
				)
				if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-22h2enablement_*.manifest" (
					echo.Integrating Windows 10 v22H2 Feature Enablement Update Package...
				)
				if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-asosfe22h2enablement_*.manifest" (
					echo.Integrating Windows Server 2022 v22H2 Feature Enablement Update Package...
				)
				if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-sv1moment1enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-sv2moment2enablement_*.manifest" (
					echo.Integrating Windows 11 v22H2 Moment 1 Feature Enablement Update Package...
				)
				if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-sv2moment2enablement_*.manifest" (
					echo.Integrating Windows 11 v22H2 Moment 2 Feature Enablement Update Package...
				)
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%BootMount%\%%i", "%Temp%\Updates\Enablement"
			)
		)
	)

	:: Windows 8.1
	if "%SelectedSourceOS%" equ "w81" if exist "%Temp%\Updates\WinPE\*.cab" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows 8.1 WinPE Updates...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%BootMount%\2", "%Temp%\Updates\WinPE"
	)

	:: Windows 10/11
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
		if exist "%Temp%\Updates\SafeOS\Update.mum" (
		   	echo.-------------------------------------------------------------------------------
		   	echo.Integrating Windows %OSID% Safe OS Dynamic Update...
		   	echo.-------------------------------------------------------------------------------
		   	call :AddPackage "%BootMount%\2", "%Temp%\Updates\SafeOS"
		)

		if exist "%Temp%\Updates\DVDMedia\*.exe" if exist "%Temp%\Updates\DVDMedia\*.dll" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows %OSID% Dynamic Update for Sources...
			echo.-------------------------------------------------------------------------------
			echo.
			echo.Copying Windows %OSID% Dynamic Update for Sources to ^<DVD^> folder.
			%XCopy% "%Temp%\Updates\DVDMedia\*.*" "%DVD%\sources" >nul
			cd /d "%DVD%\sources\" >nul
			
			for /d %%i in (ar-SA,bg-BG,cs-CZ,da-DK,de-DE,el-GR,en-GB,en-US,es-ES,es-MX,et-EE,fi-FI,fr-CA,fr-FR,he-IL,hr-HR,hu-HU,it-IT,ja-JP,ko-KR,lt-LT,lv-LV,nb-NO,nl-NL,pl-PL,pt-BR,pt-PT,ro-RO,ru-RU,sk-SK,sl-SI,sr-Latn-RS,sv-SE,th-TH,tr-TR,uk-UA,zh-CN,zh-HK,zh-TW) do (
				if "%ImageDefaultLanguage%" neq "%%i" call :RemoveFolder "%DVD%\sources\%%i"
			)

			cd /d "%ROOT%\" >nul
			echo.
		)
	)
)

if "%UpdateType%" neq "Boot" (
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w81" echo.####Integrating WHD Baseline Updates to Windows Setup Install Image############
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.####Integrating WHD General Updates to Windows Setup Install Image#############
	echo.-------------------------------------------------------------------------------

	for /l %%i in (1, 1, %ImageCount%) do (
		if exist "%InstallMount%\%%i" (
			echo.
			if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
			if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
			echo.

			:: Windows 8.1 RTM (Build : 6.3.9600.16384)
			if "%SelectedSourceOS%" equ "w81" if %ImageServicePackBuild% equ 16384 (
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Prerequisite Update ^(KB3021910^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Update ^(KB2919355^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB2919355-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB3000850^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3000850-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB2932046^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB2932046-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB2934018^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB2934018-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB2937592^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB2937592-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB2938439^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB2938439-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB2938772^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB2938772-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB3003057^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3003057-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB3014442^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3014442-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB5018922^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB5018922-%ImageArchitecture%.cab"
			)

			:: Windows 8.1 with Update (IR3 Build : 6.3.9600.17031)
			if "%SelectedSourceOS%" equ "w81" if "%ImageServicePackBuild%" equ "17031" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB3021910^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB5018922^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB5018922-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB3000850^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3000850-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB2934018^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB2934018-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB3003057^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3003057-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB3014442^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3014442-%ImageArchitecture%.cab"
			)

			:: Windows 8.1 with Update (IR4 Build : 6.3.9600.17056)
			if "%SelectedSourceOS%" equ "w81" if "%ImageServicePackBuild%" equ "17056" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB3021910^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB5018922^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB5018922-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB3000850^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3000850-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB3003057^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3003057-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB3014442^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3014442-%ImageArchitecture%.cab"
			)

			:: Windows 8.1 with Update Refresh (IR5 Build : 6.3.9600.17415)
			if "%SelectedSourceOS%" equ "w81" if "%ImageServicePackBuild%" equ "17415" (
				if exist "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating WHD Baseline Feature Pack Update ^(KB3021910^)...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab"
				)

				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD Baseline Feature Pack Update ^(KB5018922^)...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Windows8.1-KB5018922-%ImageArchitecture%.cab"
			)

			:: Windows 10
			if "%SelectedSourceOS%" equ "w10" (
				:: Importing registry fix to enable integrating Windows 10 updates to EOL editions.
				if "%ImageBuild%" equ "10240" (
					call :GetImageEdition "%InstallWim%", %%i >nul

					for %%j in (Core, CoreSingleLanguage, Professional, Education, Enterprise, ProfessionalEducation, ProfessionalWorkstation) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "InstallLocation" /t REG_SZ /d "\\?\d:\th1.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)

					for %%j in (CoreN, ProfessionalN, EducationN, EnterpriseN, ProfessionalEducationN, ProfessionalWorkstationN) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "InstallLocation" /t REG_SZ /d "\\?\d:\th1.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10240.16384" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)
				)

				if "%ImageBuild%" equ "10586" (
					call :GetImageEdition "%InstallWim%", %%i >nul

					for %%j in (Core, CoreSingleLanguage, Professional, Education, ProfessionalEducation, ProfessionalWorkstation) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.1.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "InstallLocation" /t REG_SZ /d "\\?\d:\th2.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)

					for %%j in (CoreN, ProfessionalN, EducationN, ProfessionalEducationN, ProfessionalWorkstationN) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.1.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "InstallLocation" /t REG_SZ /d "\\?\d:\th2.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.10586.0" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)
				)

				if "%ImageBuild%" equ "14393" (
					call :GetImageEdition "%InstallWim%", %%i >nul

					for %%j in (Core, CoreSingleLanguage, Professional, Education, Enterprise, ProfessionalEducation, ProfessionalWorkstation) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs1.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)

					for %%j in (CoreN, ProfessionalN, EducationN, EnterpriseN, ProfessionalEducationN, ProfessionalWorkstationN) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs1.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.14393.0" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)
				)

				if "%ImageBuild%" equ "15063" (
					call :GetImageEdition "%InstallWim%", %%i >nul

					for %%j in (Core, CoreSingleLanguage, Professional, Education, ProfessionalEducation, ProfessionalWorkstation) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.1.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs2.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)

					for %%j in (CoreN, ProfessionalN, EducationN, ProfessionalEducationN, ProfessionalWorkstationN) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.1.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs2.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.15063.0" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)
				)

				if "%ImageBuild%" equ "16299" (
					call :GetImageEdition "%InstallWim%", %%i >nul

					for %%j in (Core, CoreSingleLanguage, Professional, Education, ProfessionalEducation, ProfessionalWorkstation) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.1.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs3.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)

					for %%j in (CoreN, ProfessionalN, EducationN, ProfessionalEducationN, ProfessionalWorkstationN) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.1.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs3.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.16299.15" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)
				)

				if "%ImageBuild%" equ "17134" (
					call :GetImageEdition "%InstallWim%", %%i >nul

					for %%j in (Core, CoreSingleLanguage, Professional, ProfessionalEducation, ProfessionalWorkstation) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs4.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)

					for %%j in (CoreN, ProfessionalN, ProfessionalEducationN, ProfessionalWorkstationN) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs4.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17134.1" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)
				)

				if "%ImageBuild%" equ "17763" (
					call :GetImageEdition "%InstallWim%", %%i >nul

					for %%j in (Core, CoreSingleLanguage, ProfessionalEducation, ProfessionalWorkstation) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs5.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)

					for %%j in (CoreN, ProfessionalEducationN, ProfessionalWorkstationN) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs5.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseSNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.17763.1" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)
				)

				if "%ImageBuild%" geq "18362" if "%ImageBuild%" leq "18363" (
					call :GetImageEdition "%InstallWim%", %%i >nul

					for %%j in (Core, CoreSingleLanguage, ProfessionalEducation, ProfessionalWorkstation) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs6.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)

					for %%j in (CoreN, ProfessionalEducationN, ProfessionalWorkstationN) do (
						if "%ImageEdition%" equ "%%j" (
							call :MountImageRegistry "%InstallMount%\%%i"
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "InstallClient" /t REG_SZ /d "DISM Package Manager Provider" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "InstallName" /t REG_SZ /d "Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1.mum" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "InstallLocation" /t REG_SZ /d "\\?\d:\rs6.bin.%PackageArchitecture%fre\csi\pkgs\\" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "CurrentState" /t REG_DWORD /d "112" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "SelfUpdate" /t REG_DWORD /d "0" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "Visibility" /t REG_DWORD /d "1" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "InstallTimeHigh" /t REG_DWORD /d "30649479" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "InstallTimeLow" /t REG_DWORD /d "1431244152" /f >nul
							reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Component Based Servicing\Packages\Microsoft-Windows-EnterpriseNEdition~31bf3856ad364e35~%PackageArchitecture%~~10.0.18362.1" /v "InstallUser" /t REG_SZ /d "S-1-5-18" /f >nul
							call :UnMountImageRegistry
						)
					)
				)
			)

			:: Windows 10/11
			if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
				if exist "%Temp%\Updates\ServicingStack\Update.mum" (
					if "%SelectedSourceOS%" equ "w10" if "%ImageBuild%" equ "10240" if "%ImageServicePackBuild%" equ "16384" (
						echo.-------------------------------------------------------------------------------
						echo.Applying Windows 10 v1507 Cumulative Update Integration Fix...
						echo.-------------------------------------------------------------------------------
						call :ApplyImage "%W10CUFix%\TH1CUFix.tpk", %PackageIndex%, "%InstallMount%\%%i"
						call :MountImageRegistry "%InstallMount%\%%i"
						call :ImportRegistry2Image "%W10CUFix%\TH1CUFix_%ImageArchitecture%.reg" 2>nul
						call :UnMountImageRegistry
					)

					if "%SelectedSourceOS%" equ "w10" if "%ImageArchitecture%" equ "x86" if "%ImageBuild%" equ "14393" if "%ImageServicePackBuild%" equ "0" (
						echo.-------------------------------------------------------------------------------
						echo.Applying Windows 10 v1607 Cumulative Update Integration Fix...
						echo.-------------------------------------------------------------------------------
						call :ApplyImage "%W10CUFix%\RS1CUFix.tpk", %PackageIndex%, "%InstallMount%\%%i"
						call :MountImageRegistry "%InstallMount%\%%i"
						call :ImportRegistry2Image "%W10CUFix%\RS1CUFix.reg" 2>nul
						call :UnMountImageRegistry
					)

					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows %OSID% Servicing Stack Update Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\ServicingStack"
				)

				if exist "%Temp%\Updates\General\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows 11 General Update...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\General"
				)

				if exist "%Temp%\Updates\WindowsFeatureExperience\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows Feature Experience Pack Update Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\WindowsFeatureExperience"
				)

				if exist "%Temp%\Updates\CPUMicroCode\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Intel CPU Microcode Dynamic Update Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\CPUMicroCode"
				)

				if exist "%Temp%\Updates\SecureBoot\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows Secure Boot DBX Update Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\SecureBoot"
				)

				if exist "%Temp%\Updates\FlashPlayer\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Adobe Flash Player Security Update Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\FlashPlayer"
				)

				if exist "%Temp%\Updates\RemoveFlashPlayer\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Remove Adobe Flash Player Update Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\RemoveFlashPlayer"
				)

				if exist "%Temp%\Updates\Cumulative\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows %OSID% Cumulative Update Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Cumulative"
				)

				if exist "%Temp%\Updates\NET35\Update.mum" (
					if "%ImageBuild%" lss "19041" if not exist "%InstallMount%\%%i\Windows\WinSxS\pending.xml" (
						echo.-------------------------------------------------------------------------------
						echo.Performing [Install.wim, Index : %%i] Image Cleanup...
						echo.-------------------------------------------------------------------------------
						call :CleanupImage "%InstallMount%\%%i", "ComponentCleanupResetBase"
					)
					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft .NET Framework 3.5 Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\NET35"
				)

				if exist "%Temp%\Updates\NET35LP\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft .NET Framework 3.5 [%ImageDefaultLanguage%] Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\NET35LP"
				)

				if exist "%Temp%\Updates\NET35CDU\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft .NET Framework 3.5 Critical Dynamic Update Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\NET35CDU"
				)

				if exist "%Temp%\Updates\NET48\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft .NET Framework 4.8 Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\NET48"
				)

				if exist "%Temp%\Updates\NET48LP\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft .NET Framework 4.8 [%ImageDefaultLanguage%] Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\NET48LP"
				)

				if exist "%Temp%\Updates\NetCumulative\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft .NET Cumulative Update Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\NetCumulative"
				)

				if exist "%Temp%\Updates\EdgeChromium\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Microsoft Edge Chromium Browser Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\EdgeChromium"
				)

				if exist "%Temp%\Updates\Enablement\Update.mum" (
					echo.-------------------------------------------------------------------------------
					if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-19h2enablement_*.manifest" (
						echo.Integrating Windows 10 v1909 Feature Enablement Update Package...
					)
					if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-20h2enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h1enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h2enablement_*.manifest" (
						echo.Integrating Windows 10 v20H2 Feature Enablement Update Package...
					)
					if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-20h2enablement_*.manifest" if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h1enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h2enablement_*.manifest" (
						echo.Integrating Windows 10 v21H1 Feature Enablement Update Package...
					)
					if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h2enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-22h2enablement_*.manifest" (
						echo.Integrating Windows 10 v21H2 Feature Enablement Update Package...
					)
					if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-22h2enablement_*.manifest" (
						echo.Integrating Windows 10 v22H2 Feature Enablement Update Package...
					)
					if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-asosfe22h2enablement_*.manifest" (
						echo.Integrating Windows Server 2022 v22H2 Feature Enablement Update Package...
					)
					if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-sv2moment1enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-sv2moment2enablement_*.manifest" (
						echo.Integrating Windows 11 v22H2 Moment 1 Feature Enablement Update Package...
					)
					if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-sv2moment2enablement_*.manifest" (
						echo.Integrating Windows 11 v22H2 Moment 2 Feature Enablement Update Package...
					)
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i",  "%Temp%\Updates\Enablement"
				)

				if exist "%Temp%\Updates\Cumulative\Update.mum" if exist "%Temp%\Updates\NET35\Update.mum" if exist "%Temp%\Updates\NetCumulative\Update.mum" (
					echo.-------------------------------------------------------------------------------
					echo.Re-Integrating Windows %OSID% Cumulative Update Package...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\Cumulative"
				)

				if exist "%Temp%\Updates\Defender\package-defender.xml" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows Defender Definition Update Package...
					echo.-------------------------------------------------------------------------------
					echo.
					for /f %%x IN ('"dir /b %Temp%\Updates\Defender\Platform" 2^>nul') do (set "DefenderVersion=%%x")

					echo.Copying Windows Defender Definition Updates ^(v!DefenderVersion!^).
					%XCopy% "%Temp%\Updates\Defender\Definition Updates\Updates" "%InstallMount%\%%i\ProgramData\Microsoft\Windows Defender\Definition Updates\Updates" >nul

					echo.Copying Windows Defender Platform Updates.
					%XCopy% /s "%Temp%\Updates\Defender\Platform" "%InstallMount%\%%i\ProgramData\Microsoft\Windows Defender\Platform" >nul

					echo.Copying MpAsDesc.dll file.
					Copy /y "%InstallMount%\%%i\Program Files\Windows Defender\MpAsDesc.dll" "%InstallMount%\%%i\ProgramData\Microsoft\Windows Defender\Platform\!DefenderVersion!" >nul
					if "%ImageArchitecture%" equ "x64" Copy /y "%InstallMount%\%%i\Program Files (x86)\Windows Defender\MpAsDesc.dll" "%InstallMount%\%%i\ProgramData\Microsoft\Windows Defender\Platform\!DefenderVersion!\x86" >nul

					echo.Copying MpAsDesc.dll.mui file.
					for /d %%y in (ar-SA,bg-BG,cs-CZ,da-DK,de-DE,el-GR,en-GB,en-US,es-ES,es-MX,et-EE,fi-FI,fr-CA,fr-FR,he-IL,hr-HR,hu-HU,it-IT,ja-JP,ko-KR,lt-LT,lv-LV,nb-NO,nl-NL,pl-PL,pt-BR,pt-PT,ro-RO,ru-RU,sk-SK,sl-SI,sr-Latn-RS,sv-SE,th-TH,tr-TR,uk-UA,zh-CN,zh-HK,zh-TW) do (
						if exist "%InstallMount%\%%i\Program Files\Windows Defender\%%y" (
							call :CreateFolder "%InstallMount%\%%i\ProgramData\Microsoft\Windows Defender\Platform\!DefenderVersion!\%%y"
							Copy /y "%InstallMount%\%%i\Program Files\Windows Defender\%%y\mpasdesc.dll.mui" "%InstallMount%\%%i\ProgramData\Microsoft\Windows Defender\Platform\!DefenderVersion!\%%y\mpasdesc.dll.mui" >nul

							if "%ImageArchitecture%" equ "x64" (
								call :CreateFolder "%InstallMount%\%%i\ProgramData\Microsoft\Windows Defender\Platform\!DefenderVersion!\x86\%%y"
								Copy /y "%InstallMount%\%%i\Program Files (x86)\Windows Defender\%%y\mpasdesc.dll.mui" "%InstallMount%\%%i\ProgramData\Microsoft\Windows Defender\Platform\!DefenderVersion!\x86\%%y\mpasdesc.dll.mui" >nul
							)
						)
					)

					echo.Copying Package-defender.xml to Windows Temp folder.
					Copy /y "%Temp%\Updates\Defender\package-defender.xml" "%InstallMount%\%%i\Windows\Temp" >nul
					echo.
				)
			)
		)
	)
)

if "%UpdateType%" neq "Boot" if "%UpdateType%" neq "Install" (
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w81" echo.####Integrating WHD Baseline Updates to Windows Setup Recovery Image###########
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.####Integrating WHD General Updates to Windows Setup Recovery Image############
	echo.-------------------------------------------------------------------------------
	echo.
	:: Windows 8.1 RTM (Build : 6.3.9600.16384)
	if "%SelectedSourceOS%" equ "w81" if %ImageServicePackBuild% equ 16384 (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Prerequisite Update ^(KB3021910^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Update ^(KB2919355^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB2919355-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB3000850^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB3000850-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB2932046^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB2932046-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB2934018^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB2934018-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB2937592^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB2937592-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB2938439^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB2938439-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB2938772^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB2938772-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB3003057^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB3003057-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB5018922^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB5018922-%ImageArchitecture%.cab"
	)

	:: Windows 8.1 with Update (IR3 Build : 6.3.9600.17031)
	if "%SelectedSourceOS%" equ "w81" if "%ImageServicePackBuild%" equ "17031" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB3021910^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB5018922^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB5018922-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB3000850^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB3000850-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB2934018^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB2934018-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB3003057^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB3003057-%ImageArchitecture%.cab"
	)

	:: Windows 8.1 with Update Refresh (IR4 Build : 6.3.9600.17056)
	if "%SelectedSourceOS%" equ "w81" if "%ImageServicePackBuild%" equ "17056" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB3021910^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB5018922^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB5018922-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB3000850^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB3000850-%ImageArchitecture%.cab"
		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB3003057^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB3003057-%ImageArchitecture%.cab"
	)

	:: Windows 8.1 with Update Refresh (IR5 Build : 6.3.9600.17415)
	if "%SelectedSourceOS%" equ "w81" if "%ImageServicePackBuild%" equ "17415" (
		if exist "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating WHD Baseline Feature Pack Update ^(KB3021910^)...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB3021910-%ImageArchitecture%.cab"
		)

		echo.-------------------------------------------------------------------------------
		echo.Integrating WHD Baseline Feature Pack Update ^(KB5018922^)...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\Windows8.1-KB5018922-%ImageArchitecture%.cab"
	)

   	:: Windows 8.1
	if "%SelectedSourceOS%" equ "w81" if exist "%Temp%\Updates\WinPE\*.cab" (
		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows 10 WinPE Updates...
		echo.-------------------------------------------------------------------------------
		call :AddPackage "%WinReMount%", "%Temp%\Updates\WinPE"
   	)

	:: Windows 10/11
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
		if exist "%Temp%\Updates\ServicingStack\Update.mum" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows %OSID% Servicing Stack Update Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%WinReMount%", "%Temp%\Updates\ServicingStack"
		)

		if exist "%Temp%\Updates\General\Update.mum" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows 11 General Update...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%WinReMount%", "%Temp%\Updates\General"
		)

		if exist "%Temp%\Updates\SafeOS\Update.mum" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows %OSID% Safe OS Dynamic Update...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%WinReMount%", "%Temp%\Updates\SafeOS"
		)

		if not exist "%Temp%\Updates\SafeOS\Update.mum" if exist "%Temp%\Updates\Cumulative\Update.mum" (
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows %OSID% Cumulative Update Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%WinReMount%", "%Temp%\Updates\Cumulative"
		)

		if exist "%Temp%\Updates\Enablement\Update.mum" (
			echo.-------------------------------------------------------------------------------
			if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-19h2enablement_*.manifest" (
				echo.Integrating Windows 10 v1909 Feature Enablement Update Package...
			)
			if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-20h2enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h1enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h2enablement_*.manifest" (
				echo.Integrating Windows 10 v20H2 Feature Enablement Update Package...
			)
			if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-20h2enablement_*.manifest" if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h1enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h2enablement_*.manifest" (
				echo.Integrating Windows 10 v21H1 Feature Enablement Update Package...
			)
			if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-21h2enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-22h2enablement_*.manifest" (
				echo.Integrating Windows 10 v21H2 Feature Enablement Update Package...
			)
			if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-22h2enablement_*.manifest" (
				echo.Integrating Windows 10 v22H2 Feature Enablement Update Package...
			)
			if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-asosfe22h2enablement_*.manifest" (
				echo.Integrating Windows Server 2022 v22H2 Feature Enablement Update Package...
			)
			if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-sv1moment1enablement_*.manifest" if not exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-sv2moment2enablement_*.manifest" (
				echo.Integrating Windows 11 v22H2 Moment 1 Feature Enablement Update Package...
			)
			if exist "%Temp%\Updates\Enablement\%PackageArchitecture%_microsoft-windows-sv2moment2enablement_*.manifest" (
				echo.Integrating Windows 11 v22H2 Moment 2 Feature Enablement Update Package...
			)
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%WinReMount%", "%Temp%\Updates\Enablement"
		)
	)
)

if "%IsLogsEnabled%" equ "Yes" (
	echo.-------------------------------------------------------------------------------
	if "%SelectedSourceOS%" equ "w81" echo.Generating WHD Baseline Updates Integration Log File...
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.Generating WHD General Updates Integration Log File...
	echo.-------------------------------------------------------------------------------
	echo.
	if "%SelectedSourceOS%" equ "w81" echo.Writing WHD Baseline Updates Integration Log.
	if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.Writing WHD General Updates Integration Log.
	echo.

	if "%UpdateType%" neq "Install" if "%UpdateType%" neq "InstallRecovery" (
		for /l %%k in (1, 1, 2) do (
			call :GetPackages "%BootMount%\%%k", "Boot-%%k.txt"
		)
	)

	if "%UpdateType%" neq "Boot" (
		for /l %%i in (1, 1, %ImageCount%) do (
			if exist "%InstallMount%\%%i" (
				call :GetPackages "%InstallMount%\%%i", "Install-%%i.txt"
			)
		)
	)

	if "%UpdateType%" neq "Boot" if "%UpdateType%" neq "Install" (
		call :GetPackages "%WinReMount%", "Install_WinRE.txt"
	)
)

echo.-------------------------------------------------------------------------------
echo.####Cleaning Up Temporary files ^& Folders######################################
echo.-------------------------------------------------------------------------------
echo.
if "%SelectedSourceOS%" equ "w81" echo.Cleaning Up WHD Baseline Updates Temporary folder.
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.Cleaning Up WHD General Updates Temporary folder.
call :RemoveFolder "%Temp%\Updates"
echo.
echo.-------------------------------------------------------------------------------
if "%SelectedSourceOS%" equ "w81" echo.##################Finished Integrating WHD Baseline Updates####################
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" echo.##################Finished Integrating WHD General Updates#####################
if "%UpdateType%" equ "Boot" echo.########################to Windows Setup Boot Image############################
if "%UpdateType%" equ "Install" echo.######################to Windows Setup Install Image###########################
if "%UpdateType%" equ "InstallRecovery" echo.#################to Windows Setup Install ^& Recovery Images####################
if "%UpdateType%" equ "BootInstallRecovery" echo.##############to Windows Setup Boot, Install ^& Recovery Images#################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set PackageArchitecture=
set UpdateType=
set Updates=

endlocal

:: Reading Updated Image Information
call :GetUpdatedImageInformation >nul

:: Returning to Integrate Menu
goto :IntegrateMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Updates
:: Input Parameters [%~1 : UpdateType ]
::-------------------------------------------------------------------------------------------
:IntUpdates

setlocal

:: Setting WHD Updates Type
set "UpdateType=%~1"

cls
echo.===============================================================================
if "%UpdateType%" equ "WUpdates" echo.                   MSMG ToolKit - Integrate Windows Updates
if "%UpdateType%" equ "General" echo.                 MSMG ToolKit - Integrate WHD General Updates
if "%UpdateType%" equ "Hotfix" echo.                 MSMG ToolKit - Integrate WHD Hotfix Updates
if "%UpdateType%" equ "Security" echo.               MSMG ToolKit - Integrate WHD Security Updates
if "%UpdateType%" equ "ESU" echo.           MSMG ToolKit - Integrate WHD Extended Security Updates
if "%UpdateType%" equ "NET35" echo.        MSMG ToolKit - Integrate Microsoft .NET Framework 3.5 Updates
if "%UpdateType%" equ "WAT" echo.        MSMG ToolKit - Integrate Windows Activation Technologies ^(WAT^)
if "%UpdateType%" equ "Windows10" echo.        MSMG ToolKit - Integrate Windows 10 Upgrade Preparation Updates
if "%UpdateType%" equ "WinPE" echo.                MSMG ToolKit - Integrate Windows PE Updates
if "%UpdateType%" equ "WUSatisfy" echo.           MSMG ToolKit - Integrate Windows Update Satisfy Updates
if "%UpdateType%" equ "ADLDS" echo.   MSMG ToolKit - Integrate Active Directory Lightweight Directory Services
if "%UpdateType%" equ "FMApi" echo.                    MSMG ToolKit - Integrate File Management API
if "%UpdateType%" equ "Features" echo.                   MSMG ToolKit - Integrate Windows Features
if "%UpdateType%" equ "VirtualPC" echo.             MSMG ToolKit - Integrate Microsoft Virtual PC Feature
if "%UpdateType%" equ "WorkFolders" echo.  MSMG ToolKit - Integrate Sync Agent for Domain Environmernts ^(Work Folders^)
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Settings Windows/WHD Updates Menu folder path
if "%UpdateType%" equ "WUpdates" set "Updates=%Updates%\%SelectedSourceOS%\%ImageArchitecture%"
if "%UpdateType%" neq "WUpdates" set "Updates=%WHD%\%SelectedSourceOS%\%ImageArchitecture%"

:: Checking Windows/WHD Updates folder is empty
if "%UpdateType%" equ "WUpdates" if not exist "%Updates%\*.msu" if not exist "%Updates%\*.cab" (
	echo.Windows Updates folder ^<Updates\%SelectedSourceOS%\%ImageArchitecture%^> is empty...
	echo.
	echo.Please copy Windows Updates files to respective folder...
	goto :Stop
)

if "%UpdateType%" equ "General" (
	if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "No" if not exist "%Updates%\Extra\WithoutKB3125574\#General\*.msu" if not exist "%Updates%\Extra\WithoutKB3125574\#General\*.cab" (
		echo.WHD General Updates Folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\WithoutKB3125574\#General^> is empty...
		echo.
		echo.Please copy WHD General Updates files to respective folder...
		goto :Stop
	)

	if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "Yes" if not exist "%Updates%\General\*.msu" if not exist "%Updates%\General\*.cab" (
		echo.WHD General Updates Folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\General^> is empty...
		echo.
		echo.Please copy WHD General Updates files to respective folder...
		goto :Stop
	)

	if "%SelectedSourceOS%" equ "w81" if not exist "%Updates%\General\*.msu" if not exist "%Updates%\General\*.cab" (
		echo.WHD General Updates Folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\General^> is empty...
		echo.
		echo.Please copy WHD General Updates files to respective folder...
		goto :Stop
	)
)

if "%UpdateType%" equ "Hotfix" (
	if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "No" if not exist "%Updates%\Extra\WithoutKB3125574\#Hotfix\*.msu" if not exist "%Updates%\Extra\WithoutKB3125574\#Hotfix\*.cab" (
		echo.WHD Hotfix Updates Folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\WithoutKB3125574\#Hotfix^> is empty...
		echo.
		echo.Please copy WHD Hotfix Updates files to respective folder...
		goto :Stop
	)

	if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "Yes" if not exist "%Updates%\Hotfix\*.msu" if not exist "%Updates%\Hotfix\*.cab" (
		echo.WHD Hotfix Updates Folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Hotfix^> is empty...
		echo.
		echo.Please copy WHD Hotfix Updates files to respective folder...
		goto :Stop
	)

	if "%SelectedSourceOS%" equ "w81" if not exist "%Updates%\Hotfix\*.msu" if not exist "%Updates%\Hotfix\*.cab" (
		echo.WHD Hotfix Updates Folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Hotfix^> is empty...
		echo.
		echo.Please copy WHD Hotfix Updates files to respective folder...
		goto :Stop
	)
)

if "%UpdateType%" equ "Security" (
	if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "No" if not exist "%Updates%\Extra\WithoutKB3125574\#Security\*.msu" if not exist "%Updates%\Extra\WithoutKB3125574\#Security\*.cab" (
		echo.WHD Security Updates Folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\WithoutKB3125574\#Security^> is empty...
		echo.
		echo.Please copy WHD Security Updates files to respective folder...
		goto :Stop
	)

	if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "Yes" if not exist "%Updates%\Security\*.msu" if not exist "%Updates%\Security\*.cab" (
		echo.WHD Security Updates Folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Security^> is empty...
		echo.
		echo.Please copy WHD Security Updates files to respective folder...
		goto :Stop
	)
	
	if "%SelectedSourceOS%" equ "w81" if not exist "%Updates%\Security\*.msu" if not exist "%Updates%\Security\*.cab" (
		echo.WHD Security Updates Folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Security^> is empty...
		echo.
		echo.Please copy WHD Security Updates files to respective folder...
		goto :Stop
	)
)

if "%UpdateType%" equ "ESU" (
	if "%SelectedSourceOS%" equ "w7" if not exist "%Updates%\Security\ESU\*.msu" if not exist "%Updates%\Security\ESU\*.cab" (
		echo.WHD Extended Security Updates ^(ESU^) Folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Security\ESU^> is empty...
		echo.
		echo.Please copy WHD Extended Security Updates ^(ESU^) files to respective folder...
		goto :Stop
	)
)

if "%UpdateType%" equ "NET35" if not exist "%Updates%\Additional\NET35\*.msu" if not exist "%Updates%\Additional\NET35\*.cab" (
	echo.			 Microsoft .NET Framework 3.5 Updates Folder
	echo.		   ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Additional\NET35^> is empty...
	echo.
	echo. Please Copy Microsoft .NET Framework 3.5 Updates files to respective folder...
	goto :Stop
)

if "%UpdateType%" equ "WAT" (
	if not exist "%Updates%\Additional\WAT\*.msu" if not exist "%Updates%\Additional\WAT\*.cab" (
		echo.                    Windows Activation Technologies Folder
		echo.                 ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Additional\WAT^> is empty...
		echo.
		echo.    Please Copy Windows Activation Technologies files to respective folder...
		goto :Stop
	)

	if "%ImageEdition%" equ "Embedded" (
		echo.Windows Activation Technologies Requires Client/Server Editions...
		goto :Stop
	)
)

if "%UpdateType%" equ "Windows10" (
	if not exist "%Updates%\Additional\Windows10\*.msu" if not exist "%Updates%\Additional\Windows10\*.cab" (
		echo.                  Windows 10 Upgrade Preparation Updates Folder
		echo.               ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Additional\Windows10^> is empty...
		echo.
		echo.Please copy Windows 10 Upgrade Preparation Updates files to Respective Folder..
		goto :Stop
	)

	if "%IsW7SP1CRUSelected%" equ "No" if not exist "%Updates%\Extra\WithoutKB3125574\_Windows10\*.msu" if not exist "%Updates%\Extra\WithoutKB3125574\_Windows10\*.cab" (
		echo.               Windows 10 Upgrade Preparation Updates Folder
		echo.       ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\WithoutKB3125574\_Windows10^> is empty...
		echo.
		echo.Please copy Windows 10 Upgrade Preparation Updates files to Respective Folder..
		goto :Stop
	)

	if "%ImageEdition%" equ "Embedded" (
		echo.Windows 10 Upgrade Preparation Updates Requires Client Editions...
		goto :Stop
	)
)

if "%UpdateType%" equ "WinPE" if not exist "%Updates%\Additional\WinPE\*.msu" if not exist "%Updates%\Additional\WinPE\*.cab" (
	echo.Windows PE Updates Folder ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Additional\WinPE^> is empty...
	echo.
	echo.Please copy Windows PE Updates files to respective folder...
	goto :Stop
)

if "%UpdateType%" equ "WUSatisfy" if not exist "%Updates%\Additional\WU.Satisfy\*.msu" if not exist "%Updates%\Additional\WU.Satisfy\*.cab" (
	echo.                    Windows Update Satisfy Updates Folder
	echo.              ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Additional\WU.Satisfy^> is empty...
	echo.
	echo.    Please Copy Windows Update Satisfy Updates files to respective folder...
	goto :Stop
)

if "%UpdateType%" equ "ADLDS" (
	if not exist "%Updates%\Extra\AD_LDS\*.msu" if not exist "%Updates%\Extra\AD_LDS\*.cab" (
		echo.        Active Directory Lightweight Directory Services Feature Folder
		echo.                 ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\AD_LDS^> is empty...
		echo.
		echo.           Please Copy ADLDS Feature files to respective folder...
		goto :Stop
	)

	if not exist "%Updates%\Extra\AD_LDS\Updates\*.msu" if not exist "%Updates%\Extra\AD_LDS\Updates\*.cab" (
		echo.     Active Directory Lightweight Directory Services Feature Updates Folder
		echo.           ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\AD_LDS\Updates^> is empty...
		echo.
		echo.        Please Copy ADLDS Feature Updates files to respective folder...
		goto :Stop
	)

	if "%IsW7SP1CRUSelected%" equ "No" if not exist "%Updates%\Extra\WithoutKB3125574\AD_LDS\*.msu" if not exist "%Updates%\Extra\WithoutKB3125574\AD_LDS\*.cab" (
		echo.     Active Directory Lightweight Directory Services Feature Updates Folder
		echo.         ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\WithoutKB3125574\AD_LDS^> is empty...
		echo.
		echo.        Please Copy ADLDS Feature Updates files to respective folder...
		goto :Stop
	)

	if "%ImageEdition%" neq "Professional" if "%ImageEdition%" neq "Enterprise" if "%ImageEdition%" neq "Ultimate" (
		echo.           Active Directory Lightweight Directory Services Feature
		echo.             Requires Professional/Enterprise/Ultimate Editions...
		goto :Stop
	) else (
		goto :Continue
	)
)

if "%UpdateType%" equ "FMApi" if not exist "%Updates%\Extra\Addons\FM.Api\*.msu" if not exist "%Updates%\Extra\Addons\FM.Api\*.cab" (
	echo.                        File Management API Folder
	echo.        ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\Addons\FM.Api^> is empty...
	echo.
	echo.           Please Copy File Management API files to respective folder...
	goto :Stop
)

if "%UpdateType%" equ "Features" if not exist "%Updates%\Extra\WithoutKB3125574\_Features\*.msu" if not exist "%Updates%\Extra\WithoutKB3125574\_Features\*.cab" (
	echo.                           Windows Features Folder
	echo.        ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\WithoutKB3125574\_Features^> is empty...
	echo.
	echo.           Please Copy Windows Features files to respective folder...
	goto :Stop
)

if "%UpdateType%" equ "VirtualPC" (
	if not exist "%Updates%\Extra\VirtualPC\*.msu" if not exist "%Updates%\Extra\VirtualPC\*.cab" (
		echo.                     Microsoft Virtual PC Feature Folder
		echo.                ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\VirtualPC^> is empty...
		echo.
		echo.    Please Copy Microsoft Virtual PC Feature files to respective folder...
		goto :Stop
	)

	if "%IsW7SP1CRUSelected%" equ "No" if not exist "%Updates%\Extra\WithoutKB3125574\VirtualPC\*.msu" if not exist "%Updates%\Extra\WithoutKB3125574\VirtualPC\*.cab" (
		echo.                Microsoft Virtual PC Feature Updates Folder
		echo.       ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\WithoutKB3125574\VirtualPC^> is empty...
		echo.
		echo.Please copy Microsoft Virtual PC Feature Updates files to respective folder...
		goto :Stop
	)
)

if "%UpdateType%" equ "WorkFolders" (
	if not exist "%Updates%\Extra\Addons\WorkFolders\*.msu" if not exist "%Updates%\Extra\Addons\WorkFolders\*.cab" (
		echo.       Sync Agent for Domain Environmernts ^(Work Folders^) Feature Folder
		echo.           ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\Addons\WorkFolders^> is empty...
		echo.
		echo.         Please Copy Sync Agent for Domain Environmernts ^(Work Folders^)
		echo.                   Feature files to respective folder...
		goto :Stop
	)

	if "%IsW7SP1CRUSelected%" equ "No" if not exist "%Updates%\Extra\WithoutKB3125574\WorkFolders\*.msu" if not exist "%Updates%\Extra\WithoutKB3125574\WorkFolders\*.cab" (
		echo.   Sync Agent for Domain Environmernts ^(Work Folders^) Feature Updates Folder
		echo.      ^<WHD\%SelectedSourceOS%\%ImageArchitecture%\Extra\WithoutKB3125574\WorkFolders^> is empty...
		echo.
		echo.        Please Copy Sync Agent for Domain Environmernts ^(Work Folders^)
		echo.                Feature Updates files to respective folder...
		goto :Stop
	)

	if "%ImageEdition%" neq "Professional" if "%ImageEdition%" neq "Enterprise" if "%ImageEdition%" neq "Ultimate" (
		echo.           Sync Agent for Domain Environmernts ^(Work Folders^) Feature
		echo.             Requires Professional/Enterprise/Ultimate Editions...
		goto :Stop
	) else (
		goto :Continue
	)
)

:Continue
echo.-------------------------------------------------------------------------------
if "%UpdateType%" equ "WUpdates" echo.####Started Integrating Windows Updates########################################
if "%UpdateType%" equ "General" echo.####Started Integrating WHD General Updates####################################
if "%UpdateType%" equ "Hotfix" echo.####Started Integrating WHD Hotfix Updates#####################################
if "%UpdateType%" equ "Security" echo.####Started Integrating WHD Security Updates###################################
if "%UpdateType%" equ "ESU" echo.####Started Integrating WHD Extended Security Updates##########################
if "%UpdateType%" equ "NET35" echo.####Started Integrating Microsoft .NET Framework 3.5 Updates###################
if "%UpdateType%" equ "WAT" echo.####Started Integrating Windows Activation Technologies ^(WAT^)##################
if "%UpdateType%" equ "Windows10" echo.####Started Integrating Windows 10 Upgrade Preparation Updates#################
if "%UpdateType%" equ "WinPE" echo.####Started Integrating Windows PE Updates#####################################
if "%UpdateType%" equ "WUSatisfy" echo.####Started Integrating Windows Update Satisfy Updates#########################
if "%UpdateType%" equ "ADLDS" echo.####Started Integrating Active Directory Lightweight Directory Services########
if "%UpdateType%" equ "FMApi" echo.####Started Integrating File Management API####################################
if "%UpdateType%" equ "Features" echo.####Started Integrating Windows Features#######################################
if "%UpdateType%" equ "VirtualPC" echo.####Started Integrating Microsoft Virtual PC Feature###########################
if "%UpdateType%" equ "WorkFolders" echo.####Started Integrating Sync Agent for Domain Environmernts ^(Work Folders^)#####
echo.-------------------------------------------------------------------------------
echo.
if "%UpdateType%" neq "WinPE" (
	echo.    Image                    : Install.wim
	echo.    Image Index              : %ImageIndexNo%
) else (
	echo.    Image                    : Boot.wim         ^|  WinRE.wim
	echo.    Image Indexes            :    2             ^|    1
)
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
if "%UpdateType%" equ "WUpdates" echo.####Processing Windows Updates Packages########################################
if "%UpdateType%" equ "General" echo.####Processing WHD General Updates Packages####################################
if "%UpdateType%" equ "Hotfix" echo.####Processing WHD Hotfix Updates Packages#####################################
if "%UpdateType%" equ "Security" echo.####Processing WHD Security Updates Packages###################################
if "%UpdateType%" equ "ESU" echo.####Processing WHD Extended Security Updates Packages##########################
if "%UpdateType%" equ "NET35" echo.####Processing Microsoft .NET Framework 3.5 Updates Packages###################
if "%UpdateType%" equ "WAT" echo.####Processing Windows Activation Technologies ^(WAT^) Packages##################
if "%UpdateType%" equ "Windows10" echo.####Processing Windows 10 Upgrade Preparation Updates Packages#################
if "%UpdateType%" equ "WinPE" echo.####Processing Windows PE Updates Packages#####################################
if "%UpdateType%" equ "WUSatisfy" echo.####Processing Windows Update Satisfy Updates Packages#########################
if "%UpdateType%" equ "ADLDS" echo.####Processing Active Directory Lightweight Directory Services Packages########
if "%UpdateType%" equ "FMApi" echo.####Processing File Management API Packages####################################
if "%UpdateType%" equ "Features" echo.####Processing Windows Features Packages#######################################
if "%UpdateType%" equ "VirtualPC" echo.####Processing Microsoft Virtual PC Feature Packages###########################
if "%UpdateType%" equ "WorkFolders" echo.####Processing Sync Agent for Domain Environmernts ^(Work Folders^) Packages#####
echo.-------------------------------------------------------------------------------
echo.
:: Creating Windows/WHD Updates Temporary Folder
if "%UpdateType%" equ "WUpdates" echo.Creating Windows Updates Packages Temporary folder...
if "%UpdateType%" equ "General" echo.Creating WHD General Updates Packages Temporary folder...
if "%UpdateType%" equ "Hotfix" echo.Creating WHD Hotfix Updates Packages Temporary folder...
if "%UpdateType%" equ "Security" echo.Creating WHD Security Updates Packages Temporary folder...
if "%UpdateType%" equ "ESU" echo.Creating WHD Extended Security Updates Packages Temporary folder...
if "%UpdateType%" equ "NET35" echo.Creating Microsoft .NET Framework 3.5 Updates Packages Temporary folder...
if "%UpdateType%" equ "WAT" echo.Creating Windows Activation Technologies Packages Temporary folder...
if "%UpdateType%" equ "Windows10" echo.Creating Windows 10 Upgrade Preparation Updates Packages Temporary folder...
if "%UpdateType%" equ "WinPE" echo.Creating Windows PE Updates Packages Temporary folder...
if "%UpdateType%" equ "WUSatisfy" echo.Creating Windows Update Satisfy Updates Packages Temporary folder...
if "%UpdateType%" equ "ADLDS" echo.Creating ADLDS Packages Temporary folder...
if "%UpdateType%" equ "FMApi" echo.Creating File Management API Packages Temporary folder...
if "%UpdateType%" equ "Features" echo.Creating Windows Features Packages Temporary folder...
if "%UpdateType%" equ "VirtualPC" echo.Creating Microsoft Virtual PC Feature Packages Temporary folder...
if "%UpdateType%" equ "WorkFolders" echo.Creating Sync Agent for Domain Environmernts Packages Temporary folder...
echo.

call :RemoveFolder "%Temp%\Updates"
call :CreateFolder "%Temp%\Updates"

if "%UpdateType%" equ "General" call :CreateFolder "%Temp%\Updates\%UpdateType%"
if "%UpdateType%" equ "Hotfix" call :CreateFolder "%Temp%\Updates\%UpdateType%"

if "%UpdateType%" equ "Security" (
	call :CreateFolder "%Temp%\Updates\%UpdateType%" >nul
	if "%SelectedSourceOS%" equ "w81" call :CreateFolder "%Temp%\Updates\%UpdateType%\ProWMC"
)

if "%UpdateType%" equ "ESU" (
	call :CreateFolder "%Temp%\Updates\%UpdateType%" >nul
)

if "%UpdateType%" equ "NET35" call :CreateFolder "%Temp%\Updates\%UpdateType%"
if "%UpdateType%" equ "WAT" call :CreateFolder "%Temp%\Updates\%UpdateType%"
if "%UpdateType%" equ "Windows10" call :CreateFolder "%Temp%\Updates\%UpdateType%"
if "%UpdateType%" equ "WinPE" call :CreateFolder "%Temp%\Updates\%UpdateType%"
if "%UpdateType%" equ "WUSatisfy" call :CreateFolder "%Temp%\Updates\%UpdateType%\ProfessionalWMC"
if "%UpdateType%" equ "ADLDS" call :CreateFolder "%Temp%\Updates\%UpdateType%\Updates"
if "%UpdateType%" equ "FMApi" call :CreateFolder "%Temp%\Updates\%UpdateType%\Updates"
if "%UpdateType%" equ "Features" call :CreateFolder "%Temp%\Updates\%UpdateType%"

if "%UpdateType%" equ "VirtualPC" (
	if "%IsW7SP1CRUSelected%" equ "Yes" call :CreateFolder "%Temp%\Updates\%UpdateType%"
	if "%IsW7SP1CRUSelected%" equ "No" call :CreateFolder "%Temp%\Updates\%UpdateType%\Updates"
)

if "%UpdateType%" equ "WorkFolders" (
	if "%IsW7SP1CRUSelected%" equ "Yes" call :CreateFolder "%Temp%\Updates\%UpdateType%"
	if "%IsW7SP1CRUSelected%" equ "No" call :CreateFolder "%Temp%\Updates\%UpdateType%\Updates"
)

echo.Extracting Update Package files to Temporary folder...
echo.

:: Extracting/Copying Windows/WHD Updates .CAB files to Temporary Folder
if "%UpdateType%" equ "WUpdates" (
	if exist "%Updates%\*%ImageArchitecture%*.msu" expand "%Updates%\*.msu" -F:Win*.cab "%Temp%\Updates" >nul
	if exist "%Updates%\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\*.cab" "%Temp%\Updates" >nul
)

if "%UpdateType%" equ "General" (
	if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "No" (
		if exist "%Updates%\Extra\WithoutKB3125574\#General\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\WithoutKB3125574\#General\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\Extra\WithoutKB3125574\#General\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\WithoutKB3125574\#General\*.cab" "%Temp%\Updates\%UpdateType%" >nul

		if exist "%Temp%\Updates\%UpdateType%\WUClient*.cab" (
			call :CreateFolder "%Temp%\Updates\%UpdateType%\WUClient"
			move /y "%Temp%\Updates\%UpdateType%\WUClient*.cab" "%Temp%\Updates\%UpdateType%\WUClient" >nul
		)
	)

	if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "Yes" (
		if exist "%Updates%\%UpdateType%\*%ImageArchitecture%*.msu" expand "%Updates%\%UpdateType%\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\%UpdateType%\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\%UpdateType%\*.cab" "%Temp%\Updates\%UpdateType%" >nul

		call :CreateFolder "%Temp%\Updates\%UpdateType%\SP2"
		move /y "%Temp%\Updates\%UpdateType%\Windows6.1-KB4490628-%ImageArchitecture%.cab" "%Temp%\Updates\%UpdateType%\SP2" >nul
		move /y "%Temp%\Updates\%UpdateType%\Windows6.1-KB2670838-%ImageArchitecture%.cab" "%Temp%\Updates\%UpdateType%\SP2" >nul
		move /y "%Temp%\Updates\%UpdateType%\Windows6.1-KB3125574-v4-%ImageArchitecture%.cab" "%Temp%\Updates\%UpdateType%\SP2" >nul
		move /y "%Temp%\Updates\%UpdateType%\Windows6.1-KB3172605-%ImageArchitecture%.cab" "%Temp%\Updates\%UpdateType%\SP2" >nul

		call :CreateFolder "%Temp%\Updates\%UpdateType%\Client"
		if exist "%Temp%\Updates\%UpdateType%\Windows6.1-KB917607-%ImageArchitecture%.cab" del /f /q "%Temp%\Updates\%UpdateType%\Windows6.1-KB917607-%ImageArchitecture%.cab" >nul
	)

	if "%SelectedSourceOS%" equ "w81" (
		if exist "%Updates%\%UpdateType%\*%ImageArchitecture%*.msu" expand "%Updates%\%UpdateType%\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\%UpdateType%\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\%UpdateType%\*.cab" "%Temp%\Updates\%UpdateType%" >nul

		if exist "%Temp%\Updates\%UpdateType%\Windows8.1-KB3140185-%ImageArchitecture%.cab" (
			call :CreateFolder "%Temp%\Updates\%UpdateType%\Upgrade"
			move /y "%Temp%\Updates\%UpdateType%\Windows8.1-KB3140185-%ImageArchitecture%.cab" "%Temp%\Updates\%UpdateType%\Upgrade" >nul
		)

		if exist "%Temp%\Updates\%UpdateType%\Windows8.1-KB917607-%ImageArchitecture%.cab" del /f /q "%Temp%\Updates\%UpdateType%\Windows8.1-KB917607-%ImageArchitecture%.cab" >nul
		if exist "%Temp%\Updates\%UpdateType%\Windows8.1-KB4486105-%ImageArchitecture%.cab" del /f /q "%Temp%\Updates\%UpdateType%\Windows8.1-KB4486105-%ImageArchitecture%.cab" >nul
	)
)

if "%UpdateType%" equ "Hotfix" (
	if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "No" (
		if exist "%Updates%\Extra\WithoutKB3125574\#Hotfix\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\WithoutKB3125574\#Hotfix\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\Extra\WithoutKB3125574\#Hotfix\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\WithoutKB3125574\#Hotfix\*.cab" "%Temp%\Updates\%UpdateType%" >nul

		if exist "%Temp%\Updates\%UpdateType%\Windows6.1-KB2780124-%ImageArchitecture%*.cab" (
			call :CreateFolder "%Temp%\Updates\%UpdateType%\Ent_Ultimate"
			move /y "%Temp%\Updates\%UpdateType%\Windows6.1-KB2780124-%ImageArchitecture%*.cab" "%Temp%\Updates\%UpdateType%\Ent_Ultimate" >nul
		)
	)

	if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "Yes" (
		if exist "%Updates%\%UpdateType%\*%ImageArchitecture%*.msu" expand "%Updates%\%UpdateType%\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\%UpdateType%\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\%UpdateType%\*.cab" "%Temp%\Updates\%UpdateType%" >nul

		call :CreateFolder "%Temp%\Updates\%UpdateType%\Client"
		if exist "%Temp%\Updates\%UpdateType%\Windows6.1-KB2727994-v3-%ImageArchitecture%.cab" move /y "%Temp%\Updates\%UpdateType%\Windows6.1-KB2727994-v3-%ImageArchitecture%.cab" "%Temp%\Updates\%UpdateType%\Client" >nul
	)

	if "%SelectedSourceOS%" equ "w81" (
		if exist "%Updates%\%UpdateType%\*%ImageArchitecture%*.msu" expand "%Updates%\%UpdateType%\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\%UpdateType%\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\%UpdateType%\*.cab" "%Temp%\Updates\%UpdateType%" >nul
	)
)

if "%UpdateType%" equ "Security" (
	if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "No" (
		if exist "%Updates%\Extra\WithoutKB3125574\#Security\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\WithoutKB3125574\#Security\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\Extra\WithoutKB3125574\#Security\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\WithoutKB3125574\#Security\*.cab" "%Temp%\Updates\%UpdateType%" >nul

		if exist "%Updates%\%UpdateType%\Windows6.1-KB4490628-%ImageArchitecture%*.msu" expand "%Updates%\%UpdateType%\Windows6.1-KB4490628-%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\%UpdateType%\Windows6.1-KB4490628-%ImageArchitecture%*.cab" %XCopy% "%Updates%\%UpdateType%\Windows6.1-KB4490628-%ImageArchitecture%*.cab" "%Temp%\Updates\%UpdateType%" >nul
	)

	if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "Yes" (
		if exist "%Updates%\%UpdateType%\*%ImageArchitecture%*.msu" expand "%Updates%\%UpdateType%\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\%UpdateType%\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\%UpdateType%\*.cab" "%Temp%\Updates\%UpdateType%" >nul
	)

	if "%SelectedSourceOS%" equ "w81" (
		if exist "%Updates%\%UpdateType%\*%ImageArchitecture%*.msu" expand "%Updates%\%UpdateType%\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\%UpdateType%\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\%UpdateType%\*.cab" "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\%UpdateType%\NET452\*%ImageArchitecture%*.msu" expand "%Updates%\%UpdateType%\NET452\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\%UpdateType%\NET452\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\%UpdateType%\NET452\*.cab" "%Temp%\Updates\%UpdateType%" >nul
	)
)

if "%UpdateType%" equ "ESU" (
	if exist "%Updates%\Security\ESU\*%ImageArchitecture%*.msu" expand "%Updates%\Security\ESU\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\Security\ESU\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Security\ESU\*.cab" "%Temp%\Updates\%UpdateType%" >nul
)

if "%UpdateType%" equ "NET35" (
	if exist "%Updates%\Additional\NET35\*%ImageArchitecture%*.msu" expand "%Updates%\Additional\NET35\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\Additional\NET35\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Additional\NET35\*.cab" "%Temp%\Updates\%UpdateType%" >nul
)

if "%UpdateType%" equ "WAT" (
	if exist "%Updates%\Additional\WAT\*%ImageArchitecture%*.msu" expand "%Updates%\Additional\WAT\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\Additional\WAT\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Additional\WAT\*.cab" "%Temp%\Updates\%UpdateType%" >nul
)

if "%UpdateType%" equ "Windows10" (
	if exist "%Updates%\Additional\Windows10\*%ImageArchitecture%*.msu" expand "%Updates%\Additional\Windows10\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\Additional\Windows10\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Additional\Windows10\*.cab" "%Temp%\Updates\%UpdateType%" >nul

	if "%IsW7SP1CRUSelected%" equ "No" (
		if exist "%Updates%\Extra\WithoutKB3125574\_Windows10\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\WithoutKB3125574\_Windows10\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
		if exist "%Updates%\Extra\WithoutKB3125574\_Windows10\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\WithoutKB3125574\_Windows10\*.cab" "%Temp%\Updates\%UpdateType%" >nul
	)
)

if "%UpdateType%" equ "WinPE" (
	if exist "%Updates%\Additional\WinPE\*%ImageArchitecture%*.msu" expand "%Updates%\Additional\WinPE\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\Additional\WinPE\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Additional\WinPE\*.cab" "%Temp%\Updates\%UpdateType%" >nul

	if exist "%Updates%\General\Windows8.1-KB3084905*%ImageArchitecture%*.msu" expand "%Updates%\General\Windows8.1-KB3084905*%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\General\Windows8.1-KB3084905*%ImageArchitecture%*.cab" %XCopy% "%Updates%\General\Windows8.1-KB3084905*%ImageArchitecture%*.cab" "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\General\Windows8.1-KB3115224*%ImageArchitecture%*.msu" expand "%Updates%\General\Windows8.1-KB3115224*%ImageArchitecture%*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\General\Windows8.1-KB3115224*%ImageArchitecture%*.cab" %XCopy% "%Updates%\General\Windows8.1-KB3115224*%ImageArchitecture%*.cab" "%Temp%\Updates\%UpdateType%" >nul
)

if "%UpdateType%" equ "WUSatisfy" (
	if exist "%Updates%\Additional\WU.Satisfy\*%ImageArchitecture%*.msu" expand "%Updates%\Additional\WU.Satisfy\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\Additional\WU.Satisfy\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Additional\WU.Satisfy\*.cab" "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\Additional\WU.Satisfy\ProfessionalWMC\*%ImageArchitecture%*.msu" expand "%Updates%\Additional\WU.Satisfy\ProfessionalWMC\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%\ProfessionalWMC" >nul
	if exist "%Updates%\Additional\WU.Satisfy\ProfessionalWMC\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Additional\WU.Satisfy\ProfessionalWMC\*.cab" "%Temp%\Updates\%UpdateType%\ProfessionalWMC" >nul
)

if "%UpdateType%" equ "ADLDS" (
	if exist "%Updates%\Extra\AD_LDS\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\AD_LDS\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\Extra\AD_LDS\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\AD_LDS\*.cab" "%Temp%\Updates\%UpdateType%" >nul

	if exist "%Updates%\Extra\AD_LDS\Updates\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\AD_LDS\Updates\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%\Updates" >nul
	if exist "%Updates%\Extra\AD_LDS\Updates\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\AD_LDS\Updates\*.cab" "%Temp%\Updates\%UpdateType%\Updates" >nul

	if "%IsW7SP1CRUSelected%" equ "No" (
		if exist "%Updates%\Extra\WithoutKB3125574\AD_LDS\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\WithoutKB3125574\AD_LDS\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%\Updates" >nul
		if exist "%Updates%\Extra\WithoutKB3125574\AD_LDS\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\WithoutKB3125574\AD_LDS\*.cab" "%Temp%\Updates\%UpdateType%\Updates" >nul
	)
)

if "%UpdateType%" equ "FMApi" (
	if exist "%Updates%\Extra\Addons\FM.Api\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\Addons\FM.Api\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\Extra\Addons\FM.Api\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\Addons\FM.Api\*.cab" "%Temp%\Updates\%UpdateType%" >nul
)

if "%UpdateType%" equ "Features" (
	if exist "%Updates%\Extra\WithoutKB3125574\_Features\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\WithoutKB3125574\_Features\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\Extra\WithoutKB3125574\_Features\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\WithoutKB3125574\_Features\*.cab" "%Temp%\Updates\%UpdateType%" >nul
)

if "%UpdateType%" equ "VirtualPC" (
	if exist "%Updates%\Extra\VirtualPC\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\VirtualPC\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\Extra\VirtualPC\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\VirtualPC\*.cab" "%Temp%\Updates\%UpdateType%" >nul

	if "%IsW7SP1CRUSelected%" equ "No" (
		if exist "%Updates%\Extra\WithoutKB3125574\VirtualPC\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\WithoutKB3125574\VirtualPC\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%\Updates" >nul
		if exist "%Updates%\Extra\WithoutKB3125574\VirtualPC\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\WithoutKB3125574\VirtualPC\*.cab" "%Temp%\Updates\%UpdateType%\Updates" >nul
	)
)

if "%UpdateType%" equ "WorkFolders" (
	if exist "%Updates%\Extra\Addons\WorkFolders\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\Addons\WorkFolders\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%" >nul
	if exist "%Updates%\Extra\Addons\WorkFolders\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\Addons\WorkFolders\*.cab" "%Temp%\Updates\%UpdateType%" >nul

	if "%IsW7SP1CRUSelected%" equ "No" (
		if exist "%Updates%\Extra\WithoutKB3125574\WorkFolders\*%ImageArchitecture%*.msu" expand "%Updates%\Extra\WithoutKB3125574\WorkFolders\*.msu" -F:Win*.cab "%Temp%\Updates\%UpdateType%\Updates" >nul
		if exist "%Updates%\Extra\WithoutKB3125574\WorkFolders\*%ImageArchitecture%*.cab" %XCopy% "%Updates%\Extra\WithoutKB3125574\WorkFolders\*.cab" "%Temp%\Updates\%UpdateType%\Updates" >nul
	)
)

echo.Finished Extracting Update Package files to Temporary folder...
echo.
echo.-------------------------------------------------------------------------------
:: Integrating Windows/WHD Updates Packages to WIM Image
if "%UpdateType%" equ "WUpdates" echo.####Integrating Windows Updates################################################
if "%UpdateType%" equ "General" echo.####Integrating WHD General Updates############################################
if "%UpdateType%" equ "Hotfix" echo.####Integrating WHD Hotfix Updates#############################################
if "%UpdateType%" equ "Security" echo.####Integrating WHD Security Updates###########################################
if "%UpdateType%" equ "ESU" echo.####Integrating WHD Extended Security Updates##################################
if "%UpdateType%" equ "NET35" echo.####Integrating Microsoft .NET Framework 3.5 Updates###########################
if "%UpdateType%" equ "WAT" echo.####Integrating Windows Activation Technologies ^(WAT^) #########################
if "%UpdateType%" equ "Windows10" echo.####Integrating Windows 10 Upgrade Preparation Updates#########################
if "%UpdateType%" equ "WinPE" echo.####Integrating Windows PE Updates#############################################
if "%UpdateType%" equ "WUSatisfy" echo.####Integrating Windows Update Satisfy Updates#################################
if "%UpdateType%" equ "ADLDS" echo.####Integrating Active Directory Lightweight Directory Services Feature########
if "%UpdateType%" equ "FMApi" echo.####Integrating File Management API Feature####################################
if "%UpdateType%" equ "Features" echo.####Integrating Windows Features Updates#######################################
if "%UpdateType%" equ "VirtualPC" echo.####Integrating Microsoft Virtual PC Feature###################################
if "%UpdateType%" equ "WorkFolders" echo.####Integrating Sync Agent for Domain Environmernts ^(Work Folders^)#############
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================

		if "%UpdateType%" equ "WUpdates" call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates"

		if "%UpdateType%" equ "General" (
			call :GetImageEdition "%InstallWim%", %%i

			if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "No" (
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"

				if exist "%Temp%\Updates\%UpdateType%\WUClient\WUClient*.cab" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows 7 - Windows Update Client Updates Packages...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\WUClient\WUClient-SelfUpdate-Core-%ImageArchitecture%-7.6.7600.320.cab"
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\WUClient\WUClient-SelfUpdate-Aux-%ImageArchitecture%-7.6.7600.320.cab"
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\WUClient\WUClient-SelfUpdate-ActiveX-%ImageArchitecture%-7.6.7600.320.cab"
				)
			)

			if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "Yes" (
				echo.
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows 7 SP1 Convenience Rollup Prerequisite Update Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\SP2\Windows6.1-KB4490628-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows 7 SP1 Convenience Rollup Platform Update Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\SP2\Windows6.1-KB2670838-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows 7 SP1 Convenience Rollup Update Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\SP2\Windows6.1-KB3125574-v4-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows 7 SP1 July 2016 Rollup Update Package...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\SP2\Windows6.1-KB3172605-%ImageArchitecture%.cab"
				echo.-------------------------------------------------------------------------------
				echo.Integrating WHD General Updates Packages...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"

				if "%ImageInstallationType%" neq "Embedded" if exist "%Temp%\Updates\%UpdateType%\Client\*.cab" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows 7 Client Updates Packages...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Client"
				)
			)

			if "%SelectedSourceOS%" equ "w81" (
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"

				if exist "%Temp%\Updates\%UpdateType%\Upgrade\*.cab" (
					if "%ImageEdition%" equ "Core" (
						echo.-------------------------------------------------------------------------------
						echo.Integrating Windows 8.1 Upgradeable Editions Updates Packages...
						echo.-------------------------------------------------------------------------------
						call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Upgrade"
					)

					if "%ImageEdition%" equ "CoreSingleLanguage" (
						echo.-------------------------------------------------------------------------------
						echo.Integrating Windows 8.1 Upgradeable Editions Updates Packages...
						echo.-------------------------------------------------------------------------------
						call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Upgrade"
					)

					if "%ImageEdition%" equ "CoreCountrySpecific" (
						echo.-------------------------------------------------------------------------------
						echo.Integrating Windows 8.1 Upgradeable Editions Updates Packages...
						echo.-------------------------------------------------------------------------------
						call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Upgrade"
					)

					if "%ImageEdition%" equ "Professional" if not exist "%InstallMount%\%%i\Windows\Servicing\Packages\Microsoft-Windows-Security-SPP-Component-SKU-Professional-GVLK-Package*.mum" (
						echo.-------------------------------------------------------------------------------
						echo.Integrating Windows 8.1 Upgradeable Editions Updates Packages...
						echo.-------------------------------------------------------------------------------
						call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Upgrade"
					)
				)
			)
		)

		if "%UpdateType%" equ "Hotfix" (
			call :GetImageEdition "%InstallWim%", %%i

			call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"

			if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "No" if exist "%Temp%\Updates\%UpdateType%\Ent_Ultimate\*.cab" (
				if "%ImageEdition%" equ "Enterprise" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows 7 Enterprise Edition Updates Packages...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Ent_Ultimate"
				)

				if "%ImageEdition%" equ "Ultimate"  (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows 7 Ultimate Edition Updates Packages...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Ent_Ultimate"
				)
			)

			if "%SelectedSourceOS%" equ "w7" if "%IsW7SP1CRUSelected%" equ "Yes" if "%ImageInstallationType%" neq "Embedded" if exist "%Temp%\Updates\%UpdateType%\Client\*.cab" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Windows 7 Client Updates Packages...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Client"
			)
		)

		if "%UpdateType%" equ "Security" (
			call :GetImageEdition "%InstallWim%", %%i >nul
			call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"

			:: Applying Anti Microsoft Telemetry Client Patches
			call :MountImageRegistry "%InstallMount%\%%i"
			Reg add "HKLM\TK_SYSTEM\ControlSet001\Services\DiagTrack" /v "Start" /t REG_DWORD /d "4" /f >nul
			Reg delete "HKLM\TK_SYSTEM\ControlSet001\Control\WMI\AutoLogger\AutoLogger-Diagtrack-Listener" /f >nul 2>&1
			Reg delete "HKLM\TK_SYSTEM\ControlSet001\Control\WMI\AutoLogger\SQMLogger" /f >nul 2>&1
			Reg delete "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\Diagnostics\DiagTrack" /f >nul 2>&1
			call :UnMountImageRegistry
		)

		if "%UpdateType%" equ "ESU" (
			set EsuFoundation=
			if "%ImageInstallationType%" equ "Client" set "EsuFoundation=windowsfoundation_31bf3856ad364e35"
			if "%ImageInstallationType%" equ "Embedded" set "EsuFoundation=windowsembe..dfoundation_31bf3856ad364e35"
			if "%ImageInstallationType:~,6%" equ "Server" set "EsuFoundation=windowsserverfoundation_31bf3856ad364e35"

			:: Applying Windows 7 Extended Security Update (ESU) Suppressor Patch
			echo.
			echo.-------------------------------------------------------------------------------
			echo.Apply Windows 7 Extended Security Update ^(ESU^) Suppressor Patch...
			echo.-------------------------------------------------------------------------------
			call :ApplyImage "%W7ESU%\ESU.tpk", %PackageIndex%, "%InstallMount%\%%i"

			call :MountImageRegistry "%InstallMount%\%%i"

			for /f "tokens=5 delims=\" %%a in ('reg query "HKLM\TK_COMPONENTS\DerivedData\Components" ^| findstr "%ImageArchitecture%_!EsuFoundation!"') do (set "EsuFoundation=%%a")

			if "%ImageArchitecture%" equ "x86" (
				reg delete "HKLM\TK_COMPONENTS\DerivedData\Components\x86_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_6eb019927ae880f2" /f >nul 2>&1
				reg add "HKLM\TK_COMPONENTS\DerivedData\Components\x86_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_6eb019927ae880f2" /v "identity" /t REG_BINARY /d "4D6963726F736F66742D57696E646F77732D534C432D436F6D706F6E656E742D457874656E64656453656375726974795570646174657341492C2043756C747572653D6E65757472616C2C2056657273696F6E3D362E312E373630332E32353030302C205075626C69634B6579546F6B656E3D333162663338353661643336346533352C2050726F636573736F724172636869746563747572653D7838362C2076657273696F6E53636F70653D4E6F6E537853" >nul
				reg add "HKLM\TK_COMPONENTS\DerivedData\Components\x86_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_6eb019927ae880f2" /v "S256H" /t REG_BINARY /d "343B7E8DE2FE932E2FA1DB0CDFE69BB648BEE8E834B41728F1C83A12C1766ECB" >nul
				reg add "HKLM\TK_COMPONENTS\DerivedData\Components\x86_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_6eb019927ae880f2" /v "c^!!EsuFoundation!" /t REG_BINARY /d "" >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\SideBySide\Winners\x86_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_none_b26c9b4c15d241fc" /ve /t REG_SZ /d "6.1" >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\SideBySide\Winners\x86_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_none_b26c9b4c15d241fc\6.1" /v "6.1.7603.25000" /t REG_BINARY /d "01" >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\SideBySide\Winners\x86_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_none_b26c9b4c15d241fc\6.1" /ve /t REG_SZ /d "6.1.7603.25000" >nul
			)

			if "%ImageArchitecture%" equ "x64" (
				reg delete "HKLM\TK_COMPONENTS\DerivedData\Components\amd64_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_caceb5163345f228" /f >nul 2>&1
				reg add "HKLM\TK_COMPONENTS\DerivedData\Components\amd64_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_caceb5163345f228" /v "identity" /t REG_BINARY /d "4D6963726F736F66742D57696E646F77732D534C432D436F6D706F6E656E742D457874656E64656453656375726974795570646174657341492C2043756C747572653D6E65757472616C2C2056657273696F6E3D362E312E373630332E32353030302C205075626C69634B6579546F6B656E3D333162663338353661643336346533352C2050726F636573736F724172636869746563747572653D616D6436342C2076657273696F6E53636F70653D4E6F6E537853" >nul
				reg add "HKLM\TK_COMPONENTS\DerivedData\Components\amd64_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_caceb5163345f228" /v "S256H" /t REG_BINARY /d "45D0AE442FD92CE32EE1DDC38EA3B875EAD9A53D6A17155A10FA9D9E16BEDEB2" >nul
				reg add "HKLM\TK_COMPONENTS\DerivedData\Components\amd64_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_caceb5163345f228" /v "c^!!EsuFoundation!" /t REG_BINARY /d "" >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\SideBySide\Winners\amd64_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_caceb5163345f228" /ve /t REG_SZ /d "6.1" >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\SideBySide\Winners\amd64_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_caceb5163345f228\6.1" /v "6.1.7603.25000" /t REG_BINARY /d "01" >nul
				reg add "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\SideBySide\Winners\amd64_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_caceb5163345f228\6.1" /ve /t REG_SZ /d "6.1.7603.25000" >nul
			)

			call :UnMountImageRegistry

			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows 7 Servicing Stack Update Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Windows6.1-KB5006749-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows 7 Extended Security Updates Licensing Preparation Package..
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Windows6.1-KB4575903-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Security and Quality Rollup for .NET Framework 3.5.1 Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Windows6.1-KB4578952-%ImageArchitecture%.cab"
			echo.-------------------------------------------------------------------------------
			echo.Integrating Windows 7 Security Monthly Quality Rollup Update Package...
			echo.-------------------------------------------------------------------------------
			call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Windows6.1-KB5006743-%ImageArchitecture%.cab"

			call :MountImageRegistry "%InstallMount%\%%i"

			if "%ImageArchitecture%" equ "x86" (
				del /f /q "%InstallMount%\%%i\Windows\WinSxS\Manifests\x86_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_6eb019927ae880f2.manifest" > nul
				reg delete "HKLM\TK_COMPONENTS\DerivedData\Components\x86_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_6eb019927ae880f2" /f >nul 2>&1
				reg delete "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\SideBySide\Winners\x86_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_b26c9b4c15d241fc" /f >nul 2>&1
			)

			if "%ImageArchitecture%" equ "x64" (
				del /f /q "%InstallMount%\%%i\Windows\WinSxS\Manifests\amd64_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_caceb5163345f228.manifest" > nul
				reg delete "HKLM\TK_COMPONENTS\DerivedData\Components\amd64_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_6.1.7603.25000_none_caceb5163345f228" /f >nul 2>&1
				reg delete "HKLM\TK_SOFTWARE\Microsoft\Windows\CurrentVersion\SideBySide\Winners\amd64_microsoft-windows-s..edsecurityupdatesai_31bf3856ad364e35_none_0e8b36cfce2fb332" /f >nul 2>&1
			)

			call :UnMountImageRegistry
		)

		if "%UpdateType%" equ "NET35" call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"
		if "%UpdateType%" equ "WAT" call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"
		if "%UpdateType%" equ "Windows10" call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"

		if "%UpdateType%" equ "WinPE" (
			if "%IsBootImageSelected%" equ "Yes" (
				echo.-------------------------------------------------------------------------------
				echo.             Integrating Windows PE Updates to Boot.wim Image...
				echo.---------------------------------[Index : 2]-----------------------------------
				call :AddPackage "%BootMount%\2", "%Temp%\Updates\%UpdateType%"
			)

			if "%IsRecoveryImageSelected%" equ "Yes" (
				echo.-------------------------------------------------------------------------------
				echo.             Integrating Windows PE Updates to WinRE.wim Image...
				echo.---------------------------------[Index : 1]-----------------------------------
				call :AddPackage "%WinReMount%", "%Temp%\Updates\%UpdateType%"
			)
		)

		if "%UpdateType%" equ "WUSatisfy" (
			call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"

			if exist "%Temp%\Updates\%UpdateType%\ProfessionalWMC\*.cab" (
				call :GetImageEdition "%InstallWim%", %%i >nul

				if "%ImageEdition%" equ "ProfessionalWMC" (
					echo.-------------------------------------------------------------------------------
					echo.Integrating Windows 8.1 Pro WMC Edition - Windows Update Satisfy Updates...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\ProfessionalWMC"
				)
			)
		)

		if "%UpdateType%" equ "ADLDS" (
			call :GetImageEdition "%InstallWim%", %%i

			for /d %%j in (Professional, Enterprise, Ultimate) do (
				if "%ImageEdition%" equ "%%j" (
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"

					echo.-------------------------------------------------------------------------------
					echo.Integrating Active Directory Lightweight Directory Services Updates Packages...
					echo.-------------------------------------------------------------------------------
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Updates"
				)
			)
		)

		if "%UpdateType%" equ "FMApi" call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"
		if "%UpdateType%" equ "Features" call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"

		if "%UpdateType%" equ "VirtualPC" (
			call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"

			if "%IsW7SP1CRUSelected%" equ "No"  if exist "%Temp%\Updates\%UpdateType%\Updates\*.cab" (
				echo.-------------------------------------------------------------------------------
				echo.Integrating Microsoft Virtual PC Feature Updates...
				echo.-------------------------------------------------------------------------------
				call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Updates"
			)
		)

		if "%UpdateType%" equ "WorkFolders" (
			call :GetImageEdition "%InstallWim%", %%i

			for /d %%j in (Professional, Enterprise, Ultimate) do (
				if "%ImageEdition%" equ "%%j" (
					call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%"

					if "%IsW7SP1CRUSelected%" equ "No" if exist "%Temp%\Updates\%UpdateType%\Updates\*.cab" (
						echo.-------------------------------------------------------------------------------
						echo.Integrating Microsoft Work Folders Feature Updates...
						echo.-------------------------------------------------------------------------------
						call :AddPackage "%InstallMount%\%%i", "%Temp%\Updates\%UpdateType%\Updates"
					)
				)
			)
		)
	)
)

if "%IsLogsEnabled%" equ "Yes" (
	echo.-------------------------------------------------------------------------------
	if "%UpdateType%" equ "WUpdates" echo.Generating Windows Updates Integration LOG File...
	if "%UpdateType%" equ "General" echo.Generating WHD General Updates Integration LOG File...
	if "%UpdateType%" equ "Hotfix" echo.Generating WHD Hotfix Updates Integration LOG File...
	if "%UpdateType%" equ "Security" echo.Generating WHD Security Updates Integration LOG File...
	if "%UpdateType%" equ "ESU" echo.Generating WHD Extended Security Updates Integration LOG File...
	if "%UpdateType%" equ "NET35" echo.Generating Microsoft .NET Framework 3.5 Updates Integration LOG File...
	if "%UpdateType%" equ "WAT" echo.Generating Windows Activation Technologies Integration ^(WAT^) LOG File...
	if "%UpdateType%" equ "Windows10" echo.Generating Windows 10 Upgrade Preparation Updates Integration LOG File...
	if "%UpdateType%" equ "WinPE" echo.Generating Windows PE Updates Integration LOG File...
	if "%UpdateType%" equ "WUSatisfy" echo.Generating Windows Update Satisfy Updates Integration LOG File...
	if "%UpdateType%" equ "ADLDS" echo.Generating Active Directory Lightweight Directory Services Integration LOG File...
	if "%UpdateType%" equ "FMApi" echo.Generating File Management API Integration LOG File...
	if "%UpdateType%" equ "Features" echo.Generating Windows Features Packages Integration LOG File...
	if "%UpdateType%" equ "VirtualPC" echo.Generating Microsoft Virtual PC Feature Integration LOG File...
	if "%UpdateType%" equ "WorkFolders" echo.Generating Work Folders Integration LOG File...
	echo.-------------------------------------------------------------------------------
	echo.
	if "%UpdateType%" equ "WUpdates" echo.Writing Windows Updates Integration Log file.
	if "%UpdateType%" equ "General" echo.Writing WHD General Updates Integration Log file.
	if "%UpdateType%" equ "Hotfix" echo.Writing WHD Hotfix Updates Integration Log file.
	if "%UpdateType%" equ "Security" echo.Writing WHD Security Updates Integration Log file.
	if "%UpdateType%" equ "ESU" echo.Writing WHD Extended Security Updates Integration Log file.
	if "%UpdateType%" equ "NET35" echo.Writing Microsoft .NET Framework 3.5 Updates Integration Log file.
	if "%UpdateType%" equ "WAT" echo.Writing Windows Activation Technologies Integration Log file.
	if "%UpdateType%" equ "Windows10" echo.Writing Windows 10 Upgrade Preparation Updates Integration Log file.
	if "%UpdateType%" equ "WinPE" echo.Writing Windows PE Updates Integration Log file.
	if "%UpdateType%" equ "WUSatisfy" echo.Writing Windows Update Satisfy Updates Integration Log file.
	if "%UpdateType%" equ "ADLDS" echo.Writing Active Directory Lightweight Directory Services Integration Log file.
	if "%UpdateType%" equ "FMApi" echo.Writing File Management API Integration Log file.
	if "%UpdateType%" equ "Features" echo.Writing Windows Features Packages Integration Log file.
	if "%UpdateType%" equ "VirtualPC" echo.Writing Microsoft Virtual PC Feature Integration Log file.
	if "%UpdateType%" equ "WorkFolders" echo.Writing Work Folders Integration Log file.

	for /l %%i in (1, 1, %ImageCount%) do (
		if exist "%InstallMount%\%%i" call :GetPackages "%InstallMount%\%%i", "Updates-%%i.txt"
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.Cleaning Up Temporary Files ^& Folders...
echo.-------------------------------------------------------------------------------
echo.
:: Cleaning Up Windows/WHD Updates Temporary folder...
if "%UpdateType%" equ "WUpdates" echo.Cleaning Up Windows Updates Temporary folder.
if "%UpdateType%" equ "General" echo.Cleaning Up WHD General Updates Temporary folder.
if "%UpdateType%" equ "Hotfix" echo.Cleaning Up WHD Hotfix Updates Temporary folder.
if "%UpdateType%" equ "Security" echo.Cleaning Up WHD Security Updates Temporary folder.
if "%UpdateType%" equ "ESU" echo.Cleaning Up WHD Extended Security Updates Temporary folder.
if "%UpdateType%" equ "NET35" echo.Cleaning Up Microsoft .NET Framework 3.5 Updates Temporary folder.
if "%UpdateType%" equ "WAT" echo.Cleaning Up Windows Activation Technologies Temporary folder.
if "%UpdateType%" equ "Windows10" echo.Cleaning Up Windows 10 Upgrade Preparation Updates Temporary folder.
if "%UpdateType%" equ "WinPE" echo.Cleaning Up Windows PE Updates Temporary folder.
if "%UpdateType%" equ "WUSatisfy" echo.Cleaning Up Windows Update Satisfy Updates Temporary folder.
if "%UpdateType%" equ "ADLDS" echo.Cleaning Up Active Directory Lightweight Directory Services Temporary folder.
if "%UpdateType%" equ "FMApi" echo.Cleaning Up File Management API Temporary folder.
if "%UpdateType%" equ "Features" echo.Cleaning Up Windows Features Updates Temporary folder.
if "%UpdateType%" equ "VirtualPC" echo.Cleaning Up Microsoft Virtual PC Feature Temporary folder.
if "%UpdateType%" equ "WorkFolders" echo.Cleaning Up Sync Agent for Domain Environmernts Temporary folder.

call :RemoveFolder "%Temp%\Updates"
echo.
echo.-------------------------------------------------------------------------------
if "%UpdateType%" equ "WUpdates" echo.####Finished Integrating Windows Updates#######################################
if "%UpdateType%" equ "General" echo.####Finished Integrating WHD General Updates###################################
if "%UpdateType%" equ "Hotfix" echo.####Finished Integrating WHD Hotfix Updates####################################
if "%UpdateType%" equ "Security" echo.####Finished Integrating WHD Security Updates##################################
if "%UpdateType%" equ "ESU" echo.####Finished Integrating WHD Extended Security Updates#########################
if "%UpdateType%" equ "NET35" echo.####Finished Integrating Microsoft .NET Framework 3.5 Updates##################
if "%UpdateType%" equ "WAT" echo.####Finished Integrating Windows Activation Technologies ^(WAT^) ################
if "%UpdateType%" equ "Windows10" echo.####Finished Windows 10 Upgrade Preparation Updates############################
if "%UpdateType%" equ "WinPE" echo.####Finished Integrating Windows PE Updates####################################
if "%UpdateType%" equ "WUSatisfy" echo.####Finished Integrating Windows Update Satisfy Updates########################
if "%UpdateType%" equ "ADLDS" echo.####Finished Integrating Active Directory Lightweight Directory Service Feature
if "%UpdateType%" equ "FMApi" echo.####Finished Integrating File Management API Feature###########################
if "%UpdateType%" equ "Features" echo.####Finished Integrating Windows Features Updates##############################
if "%UpdateType%" equ "VirtualPC" echo.####Finished Integrating Microsoft Virtual PC Feature##########################
if "%UpdateType%" equ "WorkFolders" echo.####Finished Integrating Sync Agent for Domain Environmernts ^(Work Folders^)####
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set IsW7SP1CRUSelected=
set Updates=
set UpdateType=

endlocal

:: Reading Updated Image Information
call :GetUpdatedImageInformation >nul

:: Returning to Integrate Menu
goto :IntegrateMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Setup Media Updates
::-------------------------------------------------------------------------------------------
:IntWindowsSetupMediaUpdates

setlocal

cls
echo.===============================================================================
echo.                  MSMG ToolKit - Update Windows Setup Media
echo.===============================================================================
echo.

if "%IsBootImageSelected%" equ "No" (
   echo.Windows Setup Boot Image is not selected...
   echo.
   echo.Please Choose Windows Setup Boot Image while selecting Source...
   echo.
   pause
   goto :IntWHDUpdatesMenu
)

echo.-------------------------------------------------------------------------------
echo.####Starting Updating Windows Setup Media######################################
echo.-------------------------------------------------------------------------------
echo.
echo.Getting Windows Setup Media Language Settings...
echo.
for /f "tokens=1 delims= " %%a in ('%DISM% /Get-WimInfo /WimFile:"%BootWim%" /Index:2 ^| findstr /i "Default"') do (set "ImageDefaultLanguage=%%a")
set "ImageDefaultLanguage=!ImageDefaultLanguage:~1!"
echo.Found Windows Setup Media Language : [%ImageDefaultLanguage%]
echo.
echo.Copying Windows Setup Media Update files to ^<DVD^> folder...

:: Creating Directory Structures
call :CreateFolder "%DVD%"
call :CreateFolder "%DVD%\boot"
call :CreateFolder "%DVD%\efi"
call :CreateFolder "%DVD%\sources"
call :CreateFolder "%DVD%\boot\%ImageDefaultLanguage%"
call :CreateFolder "%DVD%\boot\fonts"
call :CreateFolder "%DVD%\boot\resources"
call :CreateFolder "%DVD%\efi\boot"
call :CreateFolder "%DVD%\efi\microsoft"
call :CreateFolder "%DVD%\efi\microsoft\boot"
call :CreateFolder "%DVD%\efi\microsoft\boot\fonts"
call :CreateFolder "%DVD%\efi\microsoft\boot\resources"
call :CreateFolder "%DVD%\sources\%ImageDefaultLanguage%"
call :CreateFolder "%DVD%\sources\inf"

Copy /Y "%BootMount%\2\Windows\Boot\PCAT\bootmgr" "%DVD%\bootmgr" >nul
Copy /Y "%BootMount%\2\Windows\Boot\EFI\bootmgr.efi" "%DVD%\bootmgr.efi" >nul
Copy /Y "%BootMount%\2\setup.exe" "%DVD%\setup.exe" >nul
Copy /Y "%BootMount%\2\Windows\Boot\DVD\PCAT\bcd" "%DVD%\boot\bcd" >nul
Copy /Y "%BootMount%\2\Windows\Boot\DVD\PCAT\boot.sdi" "%DVD%\boot\boot.sdi" >nul
Copy /Y "%BootMount%\2\Windows\Boot\DVD\PCAT\%ImageDefaultLanguage%\bootfix.bin" "%DVD%\boot\bootfix.bin" >nul
Copy /Y "%BootMount%\2\Windows\System32\bootsect.exe" "%DVD%\boot\bootsect.exe" >nul
Copy /Y "%BootMount%\2\Windows\Boot\DVD\PCAT\etfsboot.com" "%DVD%\boot\etfsboot.com" >nul
Copy /Y "%BootMount%\2\Windows\Boot\PCAT\memtest.exe" "%DVD%\boot\memtest.exe" >nul
Copy /Y "%BootMount%\2\Windows\System32\%ImageDefaultLanguage%\bootsect.exe.mui" "%DVD%\boot\%ImageDefaultLanguage%\bootsect.exe.mui" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\chs_boot.ttf" "%DVD%\boot\fonts\chs_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\cht_boot.ttf" "%DVD%\boot\fonts\cht_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\jpn_boot.ttf" "%DVD%\boot\fonts\jpn_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\kor_boot.ttf" "%DVD%\boot\fonts\kor_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\malgunn_boot.ttf" "%DVD%\boot\fonts\malgunn_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\malgun_boot.ttf" "%DVD%\boot\fonts\malgun_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\meiryon_boot.ttf" "%DVD%\boot\fonts\meiryon_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\meiryo_boot.ttf" "%DVD%\boot\fonts\meiryo_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\msjhn_boot.ttf" "%DVD%\boot\fonts\msjhn_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\msjh_boot.ttf" "%DVD%\boot\fonts\msjh_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\msyhn_boot.ttf" "%DVD%\boot\fonts\msyhn_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\msyh_boot.ttf" "%DVD%\boot\fonts\msyh_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\segmono_boot.ttf" "%DVD%\boot\fonts\segmono_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\segoen_slboot.ttf" "%DVD%\boot\fonts\segoen_slboot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\segoe_slboot.ttf" "%DVD%\boot\fonts\segoe_slboot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\wgl4_boot.ttf" "%DVD%\boot\fonts\wgl4_boot.ttf" >nul
Copy /Y "%BootMount%\2\Windows\Boot\Resources\bootres.dll" "%DVD%\boot\resources\bootres.dll" >nul
rem "%DVD%\efi\boot\bootia32.efi" >nul
rem "%DVD%\efi\microsoft\boot\cdboot.efi" >nul
rem "%DVD%\efi\microsoft\boot\cdboot_noprompt.efi" >nul
Copy /Y "%BootMount%\2\Windows\Boot\DVD\EFI\%ImageDefaultLanguage%\efisys.bin" "%DVD%\efi\microsoft\boot\efisys.bin" >nul
Copy /Y "%BootMount%\2\Windows\Boot\DVD\EFI\%ImageDefaultLanguage%\efisys_noprompt.bin" "%DVD%\efi\microsoft\boot\efisys_noprompt.bin" >nul
Copy /Y "%BootMount%\2\Windows\Boot\EFI\memtest.efi" "%DVD%\efi\microsoft\boot\memtest.efi" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\chs_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\chs_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\cht_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\cht_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\jpn_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\jpn_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\kor_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\kor_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\malgunn_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\malgunn_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\malgun_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\malgun_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\meiryon_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\meiryon_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\meiryo_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\meiryo_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\msjhn_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\msjhn_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\msjh_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\msjh_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\msyhn_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\msyhn_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\msyh_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\msyh_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\segmono_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\segmono_boot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\segoen_slboot.ttf" "%DVD%\efi\microsoft\boot\fonts\segoen_slboot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\segoe_slboot.ttf" "%DVD%\efi\microsoft\boot\fonts\segoe_slboot.ttf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Boot\Fonts\wgl4_boot.ttf" "%DVD%\efi\microsoft\boot\fonts\wgl4_boot.ttf" >nul
rem "%DVD%\efi\microsoft\boot\resources\bootres.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\apppatch\acres.dll" "%DVD%\sources\acres.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\actionqueue.dll" "%DVD%\sources\actionqueue.dll" >nul
rem "%DVD%\sources\adfscomp.dll" >nul
rem "%DVD%\sources\admtv3check.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\aeinv.dll" "%DVD%\sources\aeinv.dll" >nul
rem "%DVD%\sources\alert.gif" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-advapi32-l1-1-0.dll" "%DVD%\sources\api-ms-win-downlevel-advapi32-l1-1-0.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-advapi32-l1-1-1.dll" "%DVD%\sources\api-ms-win-downlevel-advapi32-l1-1-1.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-advapi32-l2-1-0.dll" "%DVD%\sources\api-ms-win-downlevel-advapi32-l2-1-0.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-advapi32-l2-1-1.dll" "%DVD%\sources\api-ms-win-downlevel-advapi32-l2-1-1.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-advapi32-l3-1-0.dll" "%DVD%\sources\api-ms-win-downlevel-advapi32-l3-1-0.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-advapi32-l4-1-0.dll" "%DVD%\sources\api-ms-win-downlevel-advapi32-l4-1-0.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-kernel32-l1-1-0.dll" "%DVD%\sources\api-ms-win-downlevel-kernel32-l1-1-0.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-kernel32-l2-1-0.dll" "%DVD%\sources\api-ms-win-downlevel-kernel32-l2-1-0.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-ole32-l1-1-0.dll" "%DVD%\sources\api-ms-win-downlevel-ole32-l1-1-0.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-ole32-l1-1-1.dll" "%DVD%\sources\api-ms-win-downlevel-ole32-l1-1-1.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-shlwapi-l1-1-0.dll" "%DVD%\sources\api-ms-win-downlevel-shlwapi-l1-1-0.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-shlwapi-l1-1-1.dll" "%DVD%\sources\api-ms-win-downlevel-shlwapi-l1-1-1.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-user32-l1-1-0.dll" "%DVD%\sources\api-ms-win-downlevel-user32-l1-1-0.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-user32-l1-1-1.dll" "%DVD%\sources\api-ms-win-downlevel-user32-l1-1-1.dll" >nul
Copy /Y "%BootMount%\2\sources\api-ms-win-downlevel-version-l1-1-0.dll" "%DVD%\sources\api-ms-win-downlevel-version-l1-1-0.dll" >nul
Copy /Y "%BootMount%\2\sources\appcompat.xsl" "%DVD%\sources\appcompat.xsl" >nul
Copy /Y "%BootMount%\2\sources\appcompat_bidi.xsl" "%DVD%\sources\appcompat_bidi.xsl" >nul
rem "%DVD%\sources\appcompat_detailed.xsl" >nul
rem "%DVD%\sources\appcompat_detailed_bidi.xsl" >nul
Copy /Y "%BootMount%\2\sources\appcompat_detailed_bidi_txt.xsl" "%DVD%\sources\appcompat_detailed_bidi_txt.xsl" >nul
Copy /Y "%BootMount%\2\sources\appcompat_detailed_txt.xsl" "%DVD%\sources\appcompat_detailed_txt.xsl" >nul
Copy /Y "%BootMount%\2\sources\arunimg.dll" "%DVD%\sources\arunimg.dll" >nul
Copy /Y "%BootMount%\2\sources\arunres.dll" "%DVD%\sources\arunres.dll" >nul
Copy /Y "%BootMount%\2\sources\autorun.dll" "%DVD%\sources\autorun.dll" >nul
rem "%DVD%\sources\background_cli.bmp" >nul
rem "%DVD%\sources\cdplib.mof" >nul
rem "%DVD%\sources\cdplibuninstall.mof" >nul
rem "%DVD%\sources\clustercompliance.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\cmi2migxml.dll" "%DVD%\sources\cmi2migxml.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\cmifw.dll" "%DVD%\sources\cmifw.dll" >nul
Copy /Y "%BootMount%\2\sources\cmisetup.dll" "%DVD%\sources\cmisetup.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\CompatTel\compatctrl.dll" "%DVD%\sources\compatctrl.dll" >nul
Copy /Y "%BootMount%\2\sources\compatprovider.dll" "%DVD%\sources\compatprovider.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\CompatTel\compatresources.dll" "%DVD%\sources\compatresources.dll" >nul
Copy /Y "%BootMount%\2\sources\compliance.ini" "%DVD%\sources\compliance.ini" >nul
rem "%DVD%\sources\compres.dll" >nul
Copy /Y "%BootMount%\2\sources\cryptosetup.dll" "%DVD%\sources\cryptosetup.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\csiagent.dll" "%DVD%\sources\csiagent.dll" >nul
rem "%DVD%\sources\cversion.ini" >nul
rem "%DVD%\sources\db_msftproductionwindowssigningca.cer" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\devinv.dll" "%DVD%\sources\devinv.dll" >nul
Copy /Y "%BootMount%\2\sources\diager.dll" "%DVD%\sources\diager.dll" >nul
Copy /Y "%BootMount%\2\sources\diagnostic.dll" "%DVD%\sources\diagnostic.dll" >nul
Copy /Y "%BootMount%\2\sources\dism.exe" "%DVD%\sources\dism.exe" >nul
Copy /Y "%BootMount%\2\Windows\System32\dismapi.dll" "%DVD%\sources\dismapi.dll" >nul
Copy /Y "%BootMount%\2\sources\dismcore.dll" "%DVD%\sources\dismcore.dll" >nul
Copy /Y "%BootMount%\2\sources\dismcoreps.dll" "%DVD%\sources\dismcoreps.dll" >nul
Copy /Y "%BootMount%\2\sources\dismprov.dll" "%DVD%\sources\dismprov.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\apppatch\drvmain.sdb" "%DVD%\sources\drvmain.sdb" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\CompatTel\drvmain32.sdb" "%DVD%\sources\drvmain32.sdb" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\CompatTel\drvmain64.sdb" "%DVD%\sources\drvmain64.sdb" >nul
rem "%DVD%\sources\drvmainarm.sdb" >nul
Copy /Y "%BootMount%\2\sources\drvmgrtn.dll" "%DVD%\sources\drvmgrtn.dll" >nul
Copy /Y "%BootMount%\2\sources\du.dll" "%DVD%\sources\du.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\WinSxS\x86_microsoft-windows-servicingstack-net_31bf3856ad364e35_6.3.9600.17031_none_d358249e46914d92\firewallofflineapi.dll" "%DVD%\sources\firewallofflineapi.dll" >nul
Copy /Y "%BootMount%\2\sources\folderprovider.dll" "%DVD%\sources\folderprovider.dll" >nul
rem "%DVD%\sources\fveupg.dll" >nul
Copy /Y "%BootMount%\2\sources\hwcompat.dll" "%DVD%\sources\hwcompat.dll" >nul
Copy /Y "%BootMount%\2\sources\hwcompat.txt" "%DVD%\sources\hwcompat.txt" >nul
rem "%DVD%\sources\hwcompatPE.txt" >nul
Copy /Y "%BootMount%\2\sources\hwexclude.txt" "%DVD%\sources\hwexclude.txt" >nul
rem "%DVD%\sources\hwexcludePE.txt" >nul
rem "%DVD%\sources\hypervcomplcheck.dll" >nul
Copy /Y "%BootMount%\2\sources\idwbinfo.txt" "%DVD%\sources\idwbinfo.txt" >nul
rem "%DVD%\sources\iiscomp.dll" >nul
Copy /Y "%BootMount%\2\sources\imagingprovider.dll" "%DVD%\sources\imagingprovider.dll" >nul
Copy /Y "%BootMount%\2\sources\input.dll" "%DVD%\sources\input.dll" >nul
rem "%DVD%\sources\install.exe" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\oobe\installeventres.dll" "%DVD%\sources\installeventres.dll" >nul
rem "%DVD%\sources\installprep.exe" >nul
rem "%DVD%\sources\itgtupg.dll" >nul
Copy /Y "%BootMount%\2\sources\lang.ini" "%DVD%\sources\lang.ini" >nul
Copy /Y "%BootMount%\2\sources\locale.nls" "%DVD%\sources\locale.nls" >nul
Copy /Y "%BootMount%\2\sources\logprovider.dll" "%DVD%\sources\logprovider.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\luainstall.dll" "%DVD%\sources\luainstall.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\migapp.xml" "%DVD%\sources\migapp.xml" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\migcore.dll" "%DVD%\sources\migcore.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\mighost.exe" "%DVD%\sources\mighost.exe" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migisol.dll" "%DVD%\sources\migisol.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\migres.dll" "%DVD%\sources\migres.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\migstore.dll" "%DVD%\sources\migstore.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\migsys.dll" "%DVD%\sources\migsys.dll" >nul
rem "%DVD%\sources\migtestplugin.dll" >nul
Copy /Y "%BootMount%\2\sources\msxml6.dll" "%DVD%\sources\msxml6.dll" >nul
Copy /Y "%BootMount%\2\sources\msxml6r.dll" "%DVD%\sources\msxml6r.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\mxeagent.dll" "%DVD%\sources\mxeagent.dll" >nul
Copy /Y "%BootMount%\2\sources\ndiscompl.dll" "%DVD%\sources\ndiscompl.dll" >nul
Copy /Y "%BootMount%\2\sources\nlsbres.dll" "%DVD%\sources\nlsbres.dll" >nul
Copy /Y "%BootMount%\2\sources\ntdsupg.dll" "%DVD%\sources\ntdsupg.dll" >nul
rem "%DVD%\sources\ntfrsupg.dll" >nul
rem "%DVD%\sources\nxquery.cat" >nul
rem "%DVD%\sources\nxquery.inf" >nul
rem "%DVD%\sources\nxquery.sys" >nul
Copy /Y "%BootMount%\2\sources\offline.xml" "%DVD%\sources\offline.xml" >nul
rem "%DVD%\sources\oscomps.woa.xml" >nul
rem "%DVD%\sources\oscomps.xml" >nul
rem "%DVD%\sources\osfilter.inf" >nul
rem "%DVD%\sources\outofbox_windows_db.bin" >nul
Copy /Y "%BootMount%\2\sources\pnpibs.dll" "%DVD%\sources\pnpibs.dll" >nul
rem "%DVD%\sources\postrollback.exe" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\CompatTel\queryappblock.exe" "%DVD%\sources\queryappblock.exe" >nul
rem "%DVD%\sources\quirks.ait" >nul
rem "%DVD%\sources\rdsupgcheck.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\PolicyDefinitions\reagent.admx" "%DVD%\sources\reagent.admx" >nul
Copy /Y "%BootMount%\2\sources\reagent.dll" "%DVD%\sources\reagent.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\Recovery\reagent.xml" "%DVD%\sources\reagent.xml" >nul
rem "%DVD%\sources\reportgen.dll" >nul
rem "%DVD%\sources\rmsupg.dll" >nul
Copy /Y "%BootMount%\2\sources\rollback.exe" "%DVD%\sources\rollback.exe" >nul
Copy /Y "%BootMount%\2\sources\schema.dat" "%DVD%\sources\schema.dat" >nul
Copy /Y "%BootMount%\2\sources\sdbapiu.dll" "%DVD%\sources\sdbapiu.dll" >nul
Copy /Y "%BootMount%\2\sources\segoeui.ttf" "%DVD%\sources\segoeui.ttf" >nul
Copy /Y "%BootMount%\2\sources\setup.exe" "%DVD%\sources\setup.exe" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\CompatTel\setupcompat.dll" "%DVD%\sources\setupcompat.dll" >nul
rem "%DVD%\sources\setuperror.exe" >nul
Copy /Y "%BootMount%\2\sources\setupplatform.cfg" "%DVD%\sources\setupplatform.cfg" >nul
Copy /Y "%BootMount%\2\sources\setupplatform.dll" "%DVD%\sources\setupplatform.dll" >nul
Copy /Y "%BootMount%\2\sources\setupplatform.exe" "%DVD%\sources\setupplatform.exe" >nul
rem "%DVD%\sources\setupresume.exe" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\sfcn.dat" "%DVD%\sources\sfcn.dat" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\sflcid.dat" "%DVD%\sources\sflcid.dat" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\sflistw7.dat" "%DVD%\sources\sflistw7.dat" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\sflistw8.dat" "%DVD%\sources\sflistw8.dat" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\sflistw8.woa.dat" "%DVD%\sources\sflistw8.woa.dat" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\sflistwb.dat" "%DVD%\sources\sflistwb.dat" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\sflistwb.woa.dat" "%DVD%\sources\sflistwb.woa.dat" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\sfpat.inf" "%DVD%\sources\sfpat.inf" >nul
rem "%DVD%\sources\sfpatpg.inf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\sfpatw7.inf" "%DVD%\sources\sfpatw7.inf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\sfpatw8.inf" "%DVD%\sources\sfpatw8.inf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\sfpatwb.inf" "%DVD%\sources\sfpatwb.inf" >nul
Copy /Y "%BootMount%\2\sources\smiengine.dll" "%DVD%\sources\smiengine.dll" >nul
Copy /Y "%BootMount%\2\sources\spflvrnt.dll" "%DVD%\sources\spflvrnt.dll" >nul
Copy /Y "%BootMount%\2\sources\spprgrss.dll" "%DVD%\sources\spprgrss.dll" >nul
Copy /Y "%BootMount%\2\sources\spwizeng.dll" "%DVD%\sources\spwizeng.dll" >nul
Copy /Y "%BootMount%\2\sources\spwizimg.dll" "%DVD%\sources\spwizimg.dll" >nul
Copy /Y "%BootMount%\2\sources\spwizres.dll" "%DVD%\sources\spwizres.dll" >nul
Copy /Y "%BootMount%\2\sources\sqmapi.dll" "%DVD%\sources\sqmapi.dll" >nul
Copy /Y "%BootMount%\2\sources\ssshim.dll" "%DVD%\sources\ssshim.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\apppatch\sysmain.sdb" "%DVD%\sources\sysmain.sdb" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\CompatTel\sysmain32.sdb" "%DVD%\sources\sysmain32.sdb" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\CompatTel\sysmain64.sdb" "%DVD%\sources\sysmain64.sdb" >nul
rem "%DVD%\sources\telemetry.xsd" >nul
rem "%DVD%\sources\uddicomp.dll" >nul
Copy /Y "%BootMount%\2\sources\unattend.dll" "%DVD%\sources\unattend.dll" >nul
Copy /Y "%BootMount%\2\sources\unbcl.dll" "%DVD%\sources\unbcl.dll" >nul
rem "%DVD%\sources\upgcompat.inf" >nul" >nul
rem "%DVD%\sources\upgdriver.dll" >nul" >nul
Copy /Y "%BootMount%\2\sources\upgloader.dll" "%DVD%\sources\upgloader.dll" >nul
rem "%DVD%\sources\upgradeagent.dll" >nul
rem "%DVD%\sources\upgradeagent.xml" >nul
rem "%DVD%\sources\upgrade_bulk.xml" >nul
rem "%DVD%\sources\upgrade_data.xml" >nul
Copy /Y "%BootMount%\2\sources\upgrade_frmwrk.xml" "%DVD%\sources\upgrade_frmwrk.xml" >nul
Copy /Y "%BootMount%\2\sources\upgreport.dll" "%DVD%\sources\upgreport.dll" >nul
rem "%DVD%\sources\upgwow_bulk.xml" >nul
Copy /Y "%BootMount%\2\sources\uxlib.dll" "%DVD%\sources\uxlib.dll" >nul
Copy /Y "%BootMount%\2\sources\uxlibres.dll" "%DVD%\sources\uxlibres.dll" >nul
Copy /Y "%BootMount%\2\sources\vhdprovider.dll" "%DVD%\sources\vhdprovider.dll" >nul
Copy /Y "%BootMount%\2\sources\w32uiimg.dll" "%DVD%\sources\w32uiimg.dll" >nul
Copy /Y "%BootMount%\2\sources\w32uires.dll" "%DVD%\sources\w32uires.dll" >nul
Copy /Y "%BootMount%\2\sources\warning.gif" "%DVD%\sources\warning.gif" >nul
Copy /Y "%BootMount%\2\sources\wdsclient.dll" "%DVD%\sources\wdsclient.dll" >nul
Copy /Y "%BootMount%\2\sources\wdsclientapi.dll" "%DVD%\sources\wdsclientapi.dll" >nul
Copy /Y "%BootMount%\2\sources\wdscore.dll" "%DVD%\sources\wdscore.dll" >nul
Copy /Y "%BootMount%\2\sources\wdscsl.dll" "%DVD%\sources\wdscsl.dll" >nul
Copy /Y "%BootMount%\2\sources\wdsimage.dll" "%DVD%\sources\wdsimage.dll" >nul
Copy /Y "%BootMount%\2\sources\wdstptc.dll" "%DVD%\sources\wdstptc.dll" >nul
rem "%DVD%\sources\wdsupgcompl.dll" >nul
Copy /Y "%BootMount%\2\sources\wdsutil.dll" "%DVD%\sources\wdsutil.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\CompatTel\wica.dll" "%DVD%\sources\wica.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\CompatTel\wica.ini" "%DVD%\sources\wica.ini" >nul
rem "%DVD%\sources\wicadevicefilters.xml" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\CompatTel\wicainventory.exe" "%DVD%\sources\wicainventory.exe" >nul
rem "%DVD%\sources\wicatel.dll" >nul
Copy /Y "%BootMount%\2\sources\wimprovider.dll" "%DVD%\sources\wimprovider.dll" >nul
Copy /Y "%BootMount%\2\sources\win32ui.dll" "%DVD%\sources\win32ui.dll" >nul
Copy /Y "%BootMount%\2\sources\winsetup.dll" "%DVD%\sources\winsetup.dll" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\apppatch\%ImageDefaultLanguage%\acres.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\acres.dll.mui" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\%ImageDefaultLanguage%\actionqueue.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\actionqueue.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\arunres.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\arunres.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\cmisetup.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\cmisetup.dll.mui" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\compatctrl.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\compatprovider.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\compatprovider.dll.mui" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\compatresources.dll.mui" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\compres.dll.mui" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\Help\%ImageDefaultLanguage%\credits.rtf" "%DVD%\sources\%ImageDefaultLanguage%\credits.rtf" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\dism.exe.mui" "%DVD%\sources\%ImageDefaultLanguage%\dism.exe.mui" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\%ImageDefaultLanguage%\dismapi.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\dismapi.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\dismcore.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\dismcore.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\dismprov.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\dismprov.dll.mui" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\%ImageDefaultLanguage%\erofflps.txt" "%DVD%\sources\%ImageDefaultLanguage%\erofflps.txt" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\folderprovider.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\folderprovider.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\imagingprovider.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\imagingprovider.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\input.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\input.dll.mui" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\install.exe.mui" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\oobe\%ImageDefaultLanguage%\installeventres.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\installeventres.dll.mui" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\installprep.exe.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\logprovider.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\logprovider.dll.mui" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\%ImageDefaultLanguage%\migcore.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\migcore.dll.mui" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\migwiz\%ImageDefaultLanguage%\migres.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\migres.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\msxml6r.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\msxml6r.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\nlsbres.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\nlsbres.dll.mui" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\oobe\%ImageDefaultLanguage%\oobe_help_opt_in_details.rtf" "%DVD%\sources\%ImageDefaultLanguage%\oobe_help_opt_in_details.rtf" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\pnpibs.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\pnpibs.dll.mui" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\postrollback.exe.mui" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\oobe\%ImageDefaultLanguage%\privacy.rtf" "%DVD%\sources\%ImageDefaultLanguage%\privacy.rtf" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\PolicyDefinitions\%ImageDefaultLanguage%\reagent.adml" "%DVD%\sources\%ImageDefaultLanguage%\reagent.adml" >nul
Copy /Y "%InstallMount%\%DefaultIndexNo%\Windows\System32\%ImageDefaultLanguage%\reagent.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\reagent.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\rollback.exe.mui" "%DVD%\sources\%ImageDefaultLanguage%\rollback.exe.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\setup.exe.mui" "%DVD%\sources\%ImageDefaultLanguage%\setup.exe.mui" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\setupcompat.dll.mui" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\setuperror.exe.mui" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\setupplatform.exe.mui" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\setupresume.exe.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\setup_help_upgrade_or_custom.rtf" "%DVD%\sources\%ImageDefaultLanguage%\setup_help_upgrade_or_custom.rtf" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\setup_help_whattokeep.rtf" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\smiengine.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\smiengine.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\spwizres.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\spwizres.dll.mui" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\upgdriver.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\upgloader.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\upgloader.dll.mui" >nul
rem "%DVD%\sources\%ImageDefaultLanguage%\upgreport.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\uxlibres.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\uxlibres.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\vhdprovider.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\vhdprovider.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\vofflps.rtf" "%DVD%\sources\%ImageDefaultLanguage%\vofflps.rtf" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\w32uires.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\w32uires.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\wdsclient.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\wdsclient.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\wdsimage.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\wdsimage.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\wimprovider.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\wimprovider.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\%ImageDefaultLanguage%\winsetup.dll.mui" "%DVD%\sources\%ImageDefaultLanguage%\winsetup.dll.mui" >nul
Copy /Y "%BootMount%\2\sources\inf\setup.cfg" "%DVD%\sources\inf\setup.cfg" >nul
echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Updating Windows Setup Media######################################
echo.-------------------------------------------------------------------------------
echo.
echo.===============================================================================
echo.
pause

endlocal

:: Returning to Integrate Menu
goto :IntegrateMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows 8.1 Media Center Generic Activation Tokens to Install Image
::-------------------------------------------------------------------------------------------
:IntWMCGActTokens

if "%IsDialogsEnabled%" equ "Yes" (
	cls
	echo.===============================================================================
	echo. MSMG ToolKit - Integrate Windows 8.1 Media Center Generic Activation Tokens
	echo.===============================================================================
	echo.
	echo.
	echo.                            I N F O R M A T I O N
	echo.                            =====================
	echo.
	echo.  Windows 8.1 Media Center Generic Activation Tokens are Generic Tokens data
	echo.  files that have been extracted from an Un-Activated Windows 8.0 Pro WMC
	echo.  OS upgraded to Windows 8.1 Pro WMC OS through Windows Store upgrade method.
	echo.
	echo.  Since Windows 8.1 Pro OS doesn't accepts Windows 8.0 Pro WMC or WMC Add-on
	echo.  Keys to install the OS, These Generic Tokens helps to make Windows Setup to
	echo.  accept and install Windows 8.0 Pro WMC or WMC Add-on Keys for installation.
	echo.
	echo.  Later the installed OS can be directly activated through Online or Phone
	echo.  activation method.
	echo.
	echo.
	echo.  To turn off Warning Dialogs, Choose Disable Dialogs in Tools-^>Options Menu
	echo.
	echo.===============================================================================
	echo.
	choice /C:YN /N /M "Do you want to continue ? ['Y'es/'N'o] : "
	if errorlevel 2 goto :IntCustomFeaturesMenu
)

setlocal

cls
echo.===============================================================================
echo.  MSMG ToolKit - Integrate Windows 8.1 Media Center Generic Activation Tokens
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows 8.1 Media Center Generic Activation Tokens#####
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows 8.1 Media Center Generic Activation Tokens#############
echo.-------------------------------------------------------------------------------
echo.

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		if "%ImageEdition%" equ "ProfessionalWMC" call :ApplyImage "%WMCGActTokens%", 1, "%InstallMount%\%%i"
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows 8.1 Media Center Generic Activation Tokens####
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

endlocal

:: Returning to Integrate Custom Features Menu
goto :IntCustomFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Pre-Activation Data
::-------------------------------------------------------------------------------------------
:IntPreActTokens

if "%IsDialogsEnabled%" equ "Yes" (
	cls
	echo.===============================================================================
	echo.          MSMG ToolKit - Integrate Windows 8.1 Pre-Activation Data
	echo.===============================================================================
	echo.
	echo. MSMG ToolKit will allow you to integrate your system activation details to
	echo. Windows Installation Disc Image to perform auto activation of system without
	echo. any need to activate online or through phone activation.
	echo.
	echo. Note: When you make any changes to your System Hardware, then the activation
	echo. status will be Lost.
	echo.
	echo. Requirements:
	echo. -------------
	echo. 1^) Windows Product Key
	echo.
	echo. 2^) Latest Pre-Activated Tokens files from Windows Activated System Drive
	echo.
	echo.    - "data.dat" from "<%SytemDrive%\Windows\System32\spp\store>" folder
	echo.    - "tokens.dat" from "<%SytemDrive%\Windows\System32\spp\store>" folder
	echo.    - "cache.dat" from "<%SytemDrive%\Windows\System32\spp\store>" folder
	echo.
	echo.===============================================================================
	echo.
	choice /C:YN /N /M "Do you want to Continue ? ['Y'es/'N'o] : "
	if errorlevel 2 goto :IntCustomFeaturesMenu
)

setlocal

cls
echo.===============================================================================
echo.           MSMG ToolKit - Integrate Windows 8.1 Pre-Activation Data
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Settings Windows Pre-Activation Details folder path
set "PreActTokens=%PreActTokens%\%SelectedSourceOS%\%ImageArchitecture%"

:: Checking whether Windows Pre-Activation Token data files exist
if not exist "%PreActTokens%\data.dat" if not exist "%PreActTokens%\cache.dat" if not exist "%PreActTokens%\tokens.dat" (
	echo.Windows Pre-Activation Token files folder ^<Packs\PreActTokens\%SelectedSourceOS%\%ImageArchitecture%^> is empty
	echo.
	choice /C:YN /N /M "Do you want to copy Activation files from System Folder? ['Y'es/'N'o] : "
	if errorlevel 2 (
		echo.
		echo.Please copy Pre-Activation Token files to respective folder...
		goto :Stop
	)
	if errorlevel 1 (
		echo.
		echo.Copying Pre-Activation Token files from ^<System32\Spp\store\2.0^>
		Xcopy /O /H /R /K /Y "%SystemRoot%\System32\spp\store\2.0\data.dat" %PreActTokens% >nul
		Xcopy /O /H /R /K /Y "%SystemRoot%\System32\spp\store\2.0\tokens.dat" %PreActTokens% >nul
		Xcopy /O /H /R /K /Y "%SystemRoot%\System32\spp\store\2.0\cache\cache.dat" %PreActTokens% >nul
	)
)

cls
echo.===============================================================================
echo.           MSMG ToolKit - Integrate Windows 8.1 Pre-Activation Data
echo.===============================================================================
echo.
echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows 8.1 Pre-Activation Data########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Getting Windows 8.1 Activation Product Key Details#########################
echo.-------------------------------------------------------------------------------
echo.
set /p ProductKey=Enter the Product Key with the '-'s : 
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows 8.1 Pre-Activation Data################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows 8.1 Product Key [%ProductKey%]...
		echo.-------------------------------------------------------------------------------
		%DISM% /Image:"%InstallMount%\%%i" /Set-ProductKey:%ProductKey%
		echo.
		echo.-------------------------------------------------------------------------------
		echo.Integrating Windows 8.1 Pre-Activated Token files...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Copying Windows 8.1 Pre-Activated Token files...
		Xcopy /O /H /R /K /Y %PreActTokens%\tokens.dat "%InstallMount%\%%i\Windows\System32\spp\store\2.0"
		Xcopy /O /H /R /K /Y %PreActTokens%\data.dat "%InstallMount%\%%i\Windows\System32\spp\store\2.0"
		Xcopy /O /H /R /K /Y %PreActTokens%\cache.dat "%InstallMount%\%%i\Windows\System32\spp\store\2.0\cache"
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows 8.1 Pre-Activation Data#######################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set PreActTokens=
set ProductKey=

endlocal

:: Returning to Integrate Custom Features Menu
goto :IntCustomFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Terminal Server Patch
::-------------------------------------------------------------------------------------------
:IntCustomTerminalServer

setlocal

cls
echo.===============================================================================
echo.          MSMG ToolKit - Integrate Microsoft Terminal Server Patch
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Terminal Server path according to selected Source OS
set "CustomTerminalServer=%CustomTerminalServer%\%SelectedSourceOS%\%ImageArchitecture%"

:: Checking whether Microsoft Terminal Server Patch Pack file exist
if not exist "%CustomTerminalServer%\termsrv.dll" (
	echo.Microsoft Terminal Server Patch file "termsrv.dll" not found...
	echo.
	echo.Please copy the above file to ^<Custom\TerminalServer\%SelectedSourceOS%\%ImageArchitecture%^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft Terminal Server Patch########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft Terminal Server Patch################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.
		echo.-------------------------------------------------------------------------------
		echo.Copying Patched Microsoft Terminal Server [termsrv.dll] file...
		echo.-------------------------------------------------------------------------------
		echo.
		%XCopy% %CustomTerminalServer%\*.* "%InstallMount%\%%i\Windows\System32"
		echo.
		echo.-------------------------------------------------------------------------------
		echo.Importing Microsoft Terminal Server Patch Registry Settings...
		echo.-------------------------------------------------------------------------------
		echo.
		echo.Mounting Image Registry...
		call :MountImageRegistry "%InstallMount%\%%i"
		echo.Importing Registry Settings to Image Registry...
		Reg add "HKLM\TK_SYSTEM\ControlSet001\Control\Terminal Server" /v "fDenyTSConnections" /t REG_DWORD /d "0" /f >nul
		Reg add "HKLM\TK_SYSTEM\ControlSet001\Control\Terminal Server" /v "fSingleSessionPerUser" /t REG_DWORD /d "0" /f >nul
		echo.Un-Mounting Image Registry...
		call :UnMountImageRegistry
		echo.
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft Terminal Server Patch#######################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set CustomTerminalServer=

endlocal

:: Returning to Integrate Custom Features Menu
goto :IntCustomFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Custom UxTheme Patch
::-------------------------------------------------------------------------------------------
:IntCustomUxTheme

setlocal

cls
echo.===============================================================================
echo.                MSMG ToolKit - Integrate Custom UxTheme Patch
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Custom UxTheme Patch Pack files path according to selected Source OS
set "CustomUxTheme=%CustomUxTheme%\%SelectedSourceOS%\%ImageArchitecture%"

:: Checking whether Custom UxTheme Patch Pack file exist
if "%SelectedSourceOS%" equ "w7" (
	for %%i in (themeservice.dll, themeui.dll, uxtheme.dll) do (
		if not exist "%CustomUxTheme%\%%i" (
			echo.Custom UxTheme Patch file "%%i" not found...
			echo.
			echo.Please copy the above file to ^<Custom\UxTheme\%SelectedSourceOS%\%ImageArchitecture%^> folder...
			goto :Stop
		)
	)
)

:: Checking whether Custom UxTheme Patch Pack file exist
if "%SelectedSourceOS%" neq "w7" (
	for %%i in (themeui.dll, UXInit.dll, uxtheme.dll) do (
		if not exist "%CustomUxTheme%\%%i" (
			echo.Custom UxTheme Patch file "%%i" not found...
			echo.
			echo.Please copy the above file to ^<Custom\UxTheme\%SelectedSourceOS%\%ImageArchitecture%^> folder...
			goto :Stop
		)
	)
)
echo.-------------------------------------------------------------------------------
echo.####Started Integrating Custom UxTheme Patch###################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Custom UxTheme Patch###########################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.
		echo.Copying Custom UxTheme Patch files...
		echo.
		%XCopy% %CustomUxTheme%\*.* "%InstallMount%\%%i\Windows\System32"
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Custom UxTheme Patch##################################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set CustomUxTheme=

endlocal

:: Returning to Integrate Custom Features Menu
goto :IntCustomFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Custom Windows Recovery Image
::-------------------------------------------------------------------------------------------
:IntCustomRecoveryImage

setlocal

cls
echo.===============================================================================
echo.          MSMG ToolKit - Integrate Custom Windows Recovery Image
echo.===============================================================================
echo.

:: Checking whether Source Windows Recovery Image is selected
if "%IsRecoveryImageSelected%" equ "Yes" (
	echo.Windows Recovery Image is selected...
	echo.
	echo.Please skip Windows Recovery Image while selecting Source...
	goto :Stop
)

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Custom Windows Recovery Image file path according to selected Source OS
set "RecoveryImage=%CustomRecoveryImage%\%SelectedSourceOS%\%ImageArchitecture%\winre.wim"

:: Checking whether Custom Windows Recovery Image file exist
if not exist "%RecoveryImage%" (
	echo.Custom Windows Recovery Image file "winre.wim" not found...
	echo.
	echo.Please copy the above file to ^<Custom\RecoveryImage\%SelectedSourceOS%\%ImageArchitecture%^> folder...
	goto :Stop
)
echo.-------------------------------------------------------------------------------
echo.####Started Integrating Custom Windows Recovery Image##########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Custom Windows Recovery Image##################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.=====================[Install.wim, Index : %%i -^> WinRE.wim]====================
		if %%i gtr 9 echo.=====================[Install.wim, Index : %%i -^> WinRE.wim]===================
		echo.
		echo.Copying Custom Windows Recovery Environment ^(WinRE^) Image...
		copy /y "%RecoveryImage%" "%InstallMount%\%%i\Windows\System32\Recovery" >nul
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Custom Windows Recovery Image#########################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set RecoveryImage=

endlocal

:: Returning to Integrate Custom Features Menu
goto :IntCustomFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Custom Default User Account Pictures
::-------------------------------------------------------------------------------------------
:IntUAP

setlocal

cls
echo.===============================================================================
echo.        MSMG ToolKit - Integrate Custom Default User Account Pictures
echo.===============================================================================
echo.

:: Setting Custom User Account Pictures path according to selected Source OS
set "UAP=%UAP%\%SelectedSourceOS%"

:: Checking whether Custom Default User Account Pictures Pack file exist
if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" neq "Server" (
	if not exist "%UAP%\user.bmp" (
		echo.Custom Default User Account Pictures Pack file "user.bmp" not found...
		echo.
		echo.Please copy the above file to ^<Packs\UAP\%SelectedSourceOS%^> folder...
		goto :Stop
	)
)

:: Checking whether Custom Default User Account Pictures Pack file exist
if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" equ "Server" (
	if not exist "%UAP%\user.bmp" (
		echo.Custom Default User Account Pictures Pack file "user.bmp" not found...
		echo.
		echo.Please copy the above file to ^<Packs\UAP\%SelectedSourceOS%^> folder...
		goto :Stop
	)
)

:: Checking whether Custom Default User Account Pictures Pack file exist
if "%SelectedSourceOS%" equ "w81" (
	for %%i in (guest.bmp, guest.png, user.bmp, user.png, user-40.png, user-200.png) do (
		if not exist "%UAP%\%%i" (
			echo.Custom Default User Account Pictures Pack file "%%i" not found...
			echo.
			echo.Please copy the above file to ^<Packs\UAP\%SelectedSourceOS%^> folder...
			goto :Stop
		)
	)
)

:: Checking whether Custom Default User Account Pictures Pack file exist
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
	for %%i in (guest.bmp, guest.png, user.bmp, user.png, user-32.png, user-40.png, user-48.png, user-192.png, user-200.png) do (
		if not exist "%UAP%\%%i" (
			echo.Custom Default User Account Pictures Pack file "%%i" not found...
			echo.
			echo.Please copy the above file to ^<Packs\UAP\%SelectedSourceOS%^> folder...
			goto :Stop
		)
	)
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Custom Default User Account Pictures###################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Custom Default User Account Pictures###########################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.
		echo.Copying Custom Default User Account Pictures files...
		echo.

		if "%SelectedSourceOS%" equ "w7" if "%ImageInstallationType%" neq "Server Core" (
			if "%ImageInstallationType%" neq "Server" %XCopy% %UAP%\*.* "%InstallMount%\%%i\ProgramData\Microsoft\User Account Pictures"
			if "%ImageInstallationType%" equ "Server" %XCopy% %UAP%\user.bmp "%InstallMount%\%%i\ProgramData\Microsoft\User Account Pictures"
		)

		if "%SelectedSourceOS%" neq "w7" %XCopy% %UAP%\*.* "%InstallMount%\%%i\ProgramData\Microsoft\User Account Pictures"
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Custom Default User Account Pictures##################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set UAP=

endlocal

:: Returning to Integrate Custom Features Menu
goto :IntCustomFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Custom System Files
::-------------------------------------------------------------------------------------------
:IntCustomFiles

setlocal

cls
echo.===============================================================================
echo.                MSMG ToolKit - Integrate Custom System Files
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

:: Setting Custom System files path according to selected Source OS
set "CustomFiles=%CustomFiles%\%SelectedSourceOS%\%ImageArchitecture%"

:: Checking whether Custom System files Pack file exist
for /f %%i in ('dir /b /s /a:-d "%CustomFiles%\*.*" 2^>nul ^| find /v /c ""') do (
	if "%%i" equ "0" (
		echo.Custom System files Pack folder is empty...
		echo.
		echo.Please copy the custom files to ^<Custom\Files\%SelectedSourceOS%\%ImageArchitecture%^> folder...
		goto :Stop
	)
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Custom System Files####################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Custom System Files############################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.
		echo.Copying Custom System files...
		echo.
		%XCopy% %CustomFiles%\*.* "%InstallMount%\%%i"
	)
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Custom System Files###################################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set CustomFiles=

endlocal

:: Returning to Integrate Custom Features Menu
goto :IntCustomFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Custom Fonts
::-------------------------------------------------------------------------------------------
:IntCustomFonts

cls
echo.===============================================================================
echo.                   MSMG ToolKit - Integrate Custom Fonts
echo.===============================================================================
echo.

:: Checking whether Custom Fonts Pack file exist
for /f %%i in ('dir /b /s /a:-d "%CustomFonts%\*.ttf" 2^>nul ^| find /v /c ""') do (
	if "%%i" equ "0" (
		echo.Custom Fonts Pack folder is empty...
		echo.
		echo.Please copy the font files to ^<Custom\Fonts^> folder...
		goto :Stop
	)
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Custom Fonts###########################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Custom Fonts###################################################
echo.-------------------------------------------------------------------------------

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.
		call :MountImageRegistry "%InstallMount%\%%i"
		PowerShell -Executionpolicy Bypass -File "%Bin%\AddFonts.ps1" -mountPath "%InstallMount%\%%i\Windows\Fonts" -fontsPath "%CustomFonts%"
		call :UnMountImageRegistry
		echo.
	)
)

echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Custom Fonts##########################################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

:: Returning to Integrate Custom Features Menu
goto :IntCustomFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Microsoft Win32Calc Metro Skin
::-------------------------------------------------------------------------------------------
:IntWin32CalcMetroSkin

setlocal

cls
echo.===============================================================================
echo.          MSMG ToolKit - Integrate Microsoft Win32Calc Metro Skin
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

set "Skins=%Skins%\Win32Calc"

:: Checking whether Microsoft Win32Calc Metro Skin Pack file exist
if not exist "%Skins%\Win32Calc.exe.res" (
	echo.Microsoft Win32Calc Metro Skin Pack file "Win32Calc.exe.res" not found...
	echo.
	echo.Please copy the above file to ^<Packs\Skins\Win32Calc^> folder...
	goto :Stop
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Microsoft Win32Calc Metro Skin#########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Microsoft Win32Calc Metro Skin#################################
echo.-------------------------------------------------------------------------------

copy /y "%ResourceHacker%" "%Temp%" >nul

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.
		echo.Copying Microsoft Win32Calc files to Temporary Folder...
		if "%ImageArchitecture%" equ "x86" copy /y "%InstallMount%\%%i\Windows\System32\Win32Calc.exe" "%Temp%\Win32Calc_x.exe" >nul

		if "%ImageArchitecture%" equ "x64" (
			copy /y "%InstallMount%\%%i\Windows\System32\Win32Calc.exe" "%Temp%\Win32Calc64_x.exe" >nul
			copy /y "%InstallMount%\%%i\Windows\SysWOW64\Win32Calc.exe" "%Temp%\Win32Calc32_x.exe" >nul
		)

		echo.
		echo.Applying Microsoft Win32Calc Metro Skin to [Win32Calc.exe] file...
		if "%ImageArchitecture%" equ "x86" (
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\Win32Calc_x.exe", "%Temp%\Win32Calc.exe", "%Skins%\Win32Calc.exe.res" ,,,
			call :RemoveFile "%Temp%\Win32Calc_x.exe"
		)

		if "%ImageArchitecture%" equ "x64" (
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\Win32Calc32_x.exe", "%Temp%\Win32Calc32.exe", "%Skins%\Win32Calc.exe.res" ,,,
			call :RemoveFile "%Temp%\Win32Calc32_x.exe"
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\Win32Calc64_x.exe", "%Temp%\Win32Calc64.exe", "%Skins%\Win32Calc.exe.res" ,,,
			call :RemoveFile "%Temp%\Win32Calc64_x.exe"
		)

		echo.
		echo.Copying Patched Microsoft Win32Calc files...
		if "%ImageArchitecture%" equ "x86" move /y "%Temp%\Win32Calc.exe" "%InstallMount%\%%i\Windows\System32\Win32Calc.exe" >nul

		if "%ImageArchitecture%" equ "x64" (
			move /y "%Temp%\Win32Calc64.exe" "%InstallMount%\%%i\Windows\System32\Win32Calc.exe" >nul
			move /y "%Temp%\Win32Calc32.exe" "%InstallMount%\%%i\Windows\SysWOW64\Win32Calc.exe" >nul
		)
	)
)

call :RemoveFile "%Temp%\ResourceHacker.exe"
call :RemoveFile "%Temp%\ResourceHacker.ini"
call :RemoveFile "%Temp%\ResourceHacker.log"
echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Microsoft Win32Calc Metro Skin########################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set Skins=

endlocal

:: Returning to Integrate Custom Features Menu
goto :IntCustomFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Icons Skin
::-------------------------------------------------------------------------------------------
:IntWIconsSkin

setlocal

cls
echo.===============================================================================
echo.              MSMG ToolKit - Integrate Windows Icons Skin
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

set "Skins=%Skins%\Icons"

:: Checking whether Windows Icons Skin Pack file exist
for %%i in (cmd.exe.res, imageres.dll.res, imagesp1.dll.res, mydocs.dll.res, snippingtool.exe.res, shell32.dll.res, taskmgr.exe.res, win32calc.exe.res, zipfldr.dll.res) do (
	if not exist "%Skins%\%%i" (
		echo.Windows Icons Skin Pack file "%%i" not found...
		echo.
		echo.Please copy the above file to ^<Packs\Skins\Icons^> folder...
		goto :Stop
	)
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Icons Skin#####################################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Processing Windows Icons Resource Skin#####################################
echo.-------------------------------------------------------------------------------
echo.
echo.Copying Windows Icons resource files...
copy /y "%ResourceHacker%" "%Temp%" >nul

copy /y "%InstallMount%\%DefaultIndexNo%\Windows\System32\cmd.exe" "%Temp%\cmd.bak" >nul
copy /y "%InstallMount%\%DefaultIndexNo%\Windows\System32\SnippingTool.exe" "%Temp%\SnippingTool.bak" >nul
if exist "%InstallMount%\%DefaultIndexNo%\Windows\System32\win32calc.exe" copy /y "%InstallMount%\%DefaultIndexNo%\Windows\System32\win32calc.exe" "%Temp%\win32calc.bak" >nul

if "%ImageArchitecture%" equ "x64" (
	copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SysWOW64\cmd.exe" "%Temp%\cmd_wow64.bak" >nul
	if exist "%InstallMount%\%DefaultIndexNo%\Windows\SysWOW64\win32calc.exe" copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SysWOW64\win32calc.exe" "%Temp%\win32calc_wow64.bak" >nul
)

if "%ImageBuild%" leq "17763" (
	copy /y "%InstallMount%\%DefaultIndexNo%\Windows\System32\imageres.dll" "%Temp%\imageres.bak" >nul
	copy /y "%InstallMount%\%DefaultIndexNo%\Windows\System32\imagesp1.dll" "%Temp%\imagesp1.bak" >nul
	copy /y "%InstallMount%\%DefaultIndexNo%\Windows\System32\mydocs.dll" "%Temp%\mydocs.bak" >nul
	rem copy /y "%InstallMount%\%DefaultIndexNo%\Windows\System32\shell32.dll" "%Temp%\shell32.bak" >nul
	rem copy /y "%InstallMount%\%DefaultIndexNo%\Windows\System32\taskmgr.exe" "%Temp%\taskmgr.bak" >nul
	copy /y "%InstallMount%\%DefaultIndexNo%\Windows\System32\zipfldr.dll" "%Temp%\zipfldr.bak" >nul
	
	if "%ImageArchitecture%" equ "x64" (
		copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SysWOW64\imageres.dll" "%Temp%\imageres_wow64.bak" >nul
		copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SysWOW64\imagesp1.dll" "%Temp%\imagesp1_wow64.bak" >nul
		copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SysWOW64\mydocs.dll" "%Temp%\mydocs_wow64.bak" >nul
		rem copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SysWOW64\taskmgr.exe" "%Temp%\taskmgr_wow64.bak" >nul
		copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SysWOW64\zipfldr.dll" "%Temp%\zipfldr_wow64.bak" >nul
	)
	echo.
	echo.Patching [\Windows\System32\imageres.dll] file...
	"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\imageres.bak", "%Temp%\imageres.dll", "%Skins%\imageres.dll.res" ,,,
	call :RemoveFile "%Temp%\imageres.bak"
	echo.Patching [\Windows\System32\imagesp1.dll] file...
	"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\imagesp1.bak", "%Temp%\imagesp1.dll", "%Skins%\imagesp1.dll.res" ,,,
	call :RemoveFile "%Temp%\imagesp1.bak"
	echo.Patching [\Windows\System32\mydocs.dll] file...
	"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\mydocs.bak", "%Temp%\mydocs.dll", "%Skins%\mydocs.dll.res" ,,,
	call :RemoveFile "%Temp%\mydocs.bak"
	rem echo.Patching [\Windows\System32\shell32.dll] file...
	rem "%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\shell32.bak", "%Temp%\shell32.dll", "%Skins%\shell32.dll.res" ,,,
	rem call :RemoveFile "%Temp%\shell32.bak"
	rem echo.Patching [\Windows\System32\taskmgr.exe] file...
	rem "%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\taskmgr.bak", "%Temp%\taskmgr.exe", "%Skins%\taskmgr.exe.res" ,,,
	rem call :RemoveFile "%Temp%\taskmgr.bak"
	echo.Patching [\Windows\System32\zipfldr.dll] file...
	"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\zipfldr.bak", "%Temp%\zipfldr.dll", "%Skins%\zipfldr.dll.res" ,,,
	call :RemoveFile "%Temp%\zipfldr.bak"

	if "%ImageArchitecture%" equ "x64" (
		echo.Patching [\Windows\SysWOW64\imageres.dll] file...
		"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\imageres_wow64.bak", "%Temp%\imageres_wow64.dll", "%Skins%\imageres.dll.res" ,,,
		call :RemoveFile "%Temp%\imageres_wow64.bak"
		echo.Patching [\Windows\SysWOW64\imagesp1.dll] file...
		"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\imagesp1_wow64.bak", "%Temp%\imagesp1_wow64.dll", "%Skins%\imagesp1.dll.res" ,,,
		call :RemoveFile "%Temp%\imagesp1_wow64.bak"
		echo.Patching [\Windows\SysWOW64\mydocs.dll] file...
		"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\mydocs_wow64.bak", "%Temp%\mydocs_wow64.dll", "%Skins%\mydocs.dll.res" ,,,
		call :RemoveFile "%Temp%\mydocs_wow64.bak"
		rem echo.Patching [\Windows\SysWOW64\taskmgr.exe] file...
		rem "%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\taskmgr_wow64.bak", "%Temp%\taskmgr_wow64.exe", "%Skins%\taskmgr.exe.res" ,,,
		rem call :RemoveFile "%Temp%\taskmgr_wow64.bak"
		echo.Patching [\Windows\SysWOW64\zipfldr.dll] file...
		"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\zipfldr_wow64.bak", "%Temp%\zipfldr_wow64.dll", "%Skins%\zipfldr.dll.res" ,,,
		call :RemoveFile "%Temp%\zipfldr_wow64.bak"
	)
)

echo.Patching [\Windows\System32\cmd.exe] file...
"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\cmd.bak", "%Temp%\cmd.exe", "%Skins%\cmd.exe.res" ,,,
call :RemoveFile "%Temp%\cmd.bak"
echo.Patching [\Windows\System32\SnippingTool.exe] file...
"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\SnippingTool.bak", "%Temp%\SnippingTool.exe", "%Skins%\snippingtool.exe.res" ,,,
call :RemoveFile "%Temp%\SnippingTool.bak"

if exist "%InstallMount%\%DefaultIndexNo%\Windows\System32\win32calc.exe" (
	echo.Patching [\Windows\System32\win32calc.exe] file...
	"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\win32calc.bak", "%Temp%\win32calc.exe", "%Skins%\win32calc.exe.res" ,,,
	call :RemoveFile "%Temp%\win32calc.bak"
)

if "%ImageArchitecture%" equ "x64" (
	echo.Patching [\Windows\SysWOW64\cmd.exe] file...
	"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\cmd_wow64.bak", "%Temp%\cmd_wow64.exe", "%Skins%\cmd.exe.res" ,,,
	call :RemoveFile "%Temp%\cmd_wow64.bak"

    if exist "%InstallMount%\%DefaultIndexNo%\Windows\SysWOW64\win32calc.exe" (
		echo.Patching [\Windows\SysWOW64\win32calc.exe] file...
		"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\win32calc_wow64.bak", "%Temp%\win32calc_wow64.exe", "%Skins%\win32calc.exe.res" ,,,
		call :RemoveFile "%Temp%\win32calc_wow64.bak"
	)
)

if "%ImageBuild%" geq "18363" (
	copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SystemResources\imageres.dll.mun" "%Temp%\imageres.bak" >nul
	copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SystemResources\imagesp1.dll.mun" "%Temp%\imagesp1.bak" >nul
	copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SystemResources\mydocs.dll.mun" "%Temp%\mydocs.bak" >nul
	copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SystemResources\shell32.dll.mun" "%Temp%\shell32.bak" >nul
	copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SystemResources\taskmgr.exe.mun" "%Temp%\taskmgr.bak" >nul
	copy /y "%InstallMount%\%DefaultIndexNo%\Windows\SystemResources\zipfldr.dll.mun" "%Temp%\zipfldr.bak" >nul
	echo.
	echo.Patching [\Windows\SystemResources\imageres.dll.mun] file...
	"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\imageres.bak", "%Temp%\imageres.dll.mun", "%Skins%\imageres.dll.res" ,,,
	call :RemoveFile "%Temp%\imageres.bak"
	echo.Patching [\Windows\SystemResources\imagesp1.dll.mun] file...
	"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\imagesp1.bak", "%Temp%\imagesp1.dll.mun", "%Skins%\imagesp1.dll.res" ,,,
	call :RemoveFile "%Temp%\imagesp1.bak"
	echo.Patching [\Windows\SystemResources\mydocs.dll.mun] file...
	"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\mydocs.bak", "%Temp%\mydocs.dll.mun", "%Skins%\mydocs.dll.res" ,,,
	call :RemoveFile "%Temp%\mydocs.bak"
	echo.Patching [\Windows\SystemResources\shell32.dll.mun] file...
	"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\shell32.bak", "%Temp%\shell32.dll.mun", "%Skins%\shell32.dll.res" ,,,
	call :RemoveFile "%Temp%\shell32.bak"
	echo.Patching [\Windows\SystemResources\taskmgr.exe.mun] file...
	"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\taskmgr.bak", "%Temp%\taskmgr.exe.mun", "%Skins%\taskmgr.exe.res" ,,,
	call :RemoveFile "%Temp%\taskmgr.bak"
	echo.Patching [\Windows\SystemResources\zipfldr.dll.mun] file...
	"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\zipfldr.bak", "%Temp%\zipfldr.dll.mun", "%Skins%\zipfldr.dll.res" ,,,
	call :RemoveFile "%Temp%\zipfldr.bak"
)
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Icons Skin#############################################
echo.-------------------------------------------------------------------------------
echo.
for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.
		echo.Copying Patched Windows Icons files...
		echo.
		echo.Copying [\Windows\System32\cmd.exe] file...
		copy /y "%Temp%\cmd.exe" "%InstallMount%\%%i\Windows\System32\cmd.exe" >nul
		echo.Copying [\Windows\System32\SnippingTool.exe] file...
		copy /y "%Temp%\SnippingTool.exe" "%InstallMount%\%%i\Windows\System32\SnippingTool.exe" >nul

		if exist "%InstallMount%\%%i\Windows\System32\win32calc.exe" (
			echo.Copying [\Windows\System32\win32calc.exe] file...
			copy /y "%Temp%\win32calc.exe" "%InstallMount%\%%i\Windows\System32\win32calc.exe" >nul
		)

		if "%ImageArchitecture%" equ "x64" (
			echo.Copying [\Windows\SysWOW64\cmd.exe] file...
			copy /y "%Temp%\cmd_wow64.exe" "%InstallMount%\%%i\Windows\SysWOW64\cmd.exe" >nul

			if exist "%InstallMount%\%%i\Windows\SysWOW64\win32calc.exe" (
				echo.Copying [\Windows\SysWOW64\win32calc.exe] file...
				copy /y "%Temp%\Win32Calc_wow64.exe" "%InstallMount%\%%i\Windows\SysWOW64\Win32Calc.exe" >nul
			)
		)

		if "%ImageBuild%" leq "17763" (
			echo.Copying [\Windows\System32\imageres.dll] file...
			copy /y "%Temp%\imageres.dll" "%InstallMount%\%%i\Windows\System32\imageres.dll" >nul
			echo.Copying [\Windows\System32\imagesp1.dll] file...
			copy /y "%Temp%\imagesp1.dll" "%InstallMount%\%%i\Windows\System32\imagesp1.dll" >nul
			echo.Copying [\Windows\System32\mydocs.dll] file...
			copy /y "%Temp%\mydocs.dll" "%InstallMount%\%%i\Windows\System32\mydocs.dll" >nul
			rem echo.Copying [\Windows\System32\shell32.dll] file...
			rem copy /y "%Temp%\shell32.dll" "%InstallMount%\%%i\Windows\System32\shell32.dll" >nul
			rem echo.Copying [\Windows\System32\taskmgr.exe] file...
			rem copy /y "%Temp%\taskmgr.exe" "%InstallMount%\%%i\Windows\System32\taskmgr.exe" >nul
			echo.Copying [\Windows\System32\zipfldr.dll] file...
			copy /y "%Temp%\zipfldr.dll" "%InstallMount%\%%i\Windows\System32\zipfldr.dll" >nul

			if "%ImageArchitecture%" equ "x64" (
				echo.Copying [\Windows\SysWOW64\imageres.dll] file...
				copy /y "%Temp%\imageres_wow64.dll" "%InstallMount%\%%i\Windows\SysWOW64\imageres.dll" >nul
				echo.Copying [\Windows\SysWOW64\imagesp1.dll] file...
				copy /y "%Temp%\imagesp1_wow64.dll" "%InstallMount%\%%i\Windows\SysWOW64\imagesp1.dll" >nul
				echo.Copying [\Windows\SysWOW64\mydocs.dll] file...
				copy /y "%Temp%\mydocs_wow64.dll" "%InstallMount%\%%i\Windows\SysWOW64\mydocs.dll" >nul
				rem echo.Copying [\Windows\SysWOW64\taskmgr.exe] file...
				rem copy /y "%Temp%\taskmgr_wow64.exe" "%InstallMount%\%%i\Windows\SysWOW64\taskmgr.exe" >nul
				echo.Copying [\Windows\SysWOW64\zipfldr.dll] file...
				copy /y "%Temp%\zipfldr_wow64.dll" "%InstallMount%\%%i\Windows\SysWOW64\zipfldr.dll" >nul
			)
		)

		if "%ImageBuild%" geq "18363" (
			echo.Copying [\Windows\SystemResources\imageres.dll.mun] file...
			copy /y "%Temp%\imageres.dll.mun" "%InstallMount%\%%i\Windows\SystemResources\imageres.dll.mun" >nul
			echo.Copying [\Windows\SystemResources\imagesp1.dll.mun] file...
			copy /y "%Temp%\imagesp1.dll.mun" "%InstallMount%\%%i\Windows\SystemResources\imagesp1.dll.mun" >nul
			echo.Copying [\Windows\SystemResources\mydocs.dll.mun] file...
			copy /y "%Temp%\mydocs.dll.mun" "%InstallMount%\%%i\Windows\SystemResources\mydocs.dll.mun" >nul
			echo.Copying [\Windows\SystemResources\shell32.dll.mun] file...
			copy /y "%Temp%\shell32.dll.mun" "%InstallMount%\%%i\Windows\SystemResources\shell32.dll.mun" >nul
			echo.Copying [\Windows\SystemResources\taskmgr.exe.mun] file...
			copy /y "%Temp%\taskmgr.exe.mun" "%InstallMount%\%%i\Windows\SystemResources\taskmgr.exe.mun" >nul
			echo.Copying [\Windows\SystemResources\zipfldr.dll.mun] file...
			copy /y "%Temp%\zipfldr.dll.mun" "%InstallMount%\%%i\Windows\SystemResources\zipfldr.dll.mun" >nul
		)
	)
)

for %%f in (cmd; cmd_wow64; imageres; imageres_wow64; imagesp1; imagesp1_wow64; SnippingTool; SnippingTool_wow64; shell32; shell32_wow64; taskmgr; taskmgr_wow64; Win32Calc; Win32Calc_wow64; zipfldr; zipfldr_wow64; ResourceHacker.exe; ResourceHacker.ini; ResourceHacker.log) do (
	call :RemoveFile "%Temp%\%%f"
	call :RemoveFile "%Temp%\%%f.bak"
	call :RemoveFile "%Temp%\%%f.dll"
	call :RemoveFile "%Temp%\%%f.exe"
	call :RemoveFile "%Temp%\%%f.dll.mun"
	call :RemoveFile "%Temp%\%%f.exe.mun"
)

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Icons Skin####################################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set Skins=

endlocal

:: Returning to Integrate Custom Features Menu
goto :IntCustomFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Photo Viewer Metro Skin
::-------------------------------------------------------------------------------------------
:IntWPVMetroSkin

setlocal

cls
echo.===============================================================================
echo.          MSMG ToolKit - Integrate Windows Photo Viewer Metro Skin
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

set "Skins=%Skins%\PhotoViewer"

:: Checking whether Windows Photo Viewer Metro Skin Pack file exist
for %%i in (PhotoViewer.dll.res, photowiz.dll.res) do (
	if not exist "%Skins%\%%i" (
		echo.Windows Photo Viewer Metro Skin Pack file "%%i" not found...
		echo.
		echo.Please copy the above file to ^<Packs\Skins\PhotoViewer^> folder...
		goto :Stop
	)
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Photo Viewer Metro Skin########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Photo Viewer Metro Skin################################
echo.-------------------------------------------------------------------------------

copy /y "%ResourceHacker%" "%Temp%" >nul

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.
		echo.Copying Windows Photo Viewer files to Temporary Folder...
		if "%ImageArchitecture%" equ "x86" (
			copy /y "%InstallMount%\%%i\Program Files\Windows Photo Viewer\PhotoViewer.dll" "%Temp%\PhotoViewer_x.dll" >nul
			copy /y "%InstallMount%\%%i\Windows\System32\photowiz.dll" "%Temp%\photowiz_x.dll" >nul
		)

		if "%ImageArchitecture%" equ "x64" (
			copy /y "%InstallMount%\%%i\Program Files\Windows Photo Viewer\PhotoViewer.dll" "%Temp%\PhotoViewer64_x.dll" >nul
			copy /y "%InstallMount%\%%i\Program Files (x86)\Windows Photo Viewer\PhotoViewer.dll" "%Temp%\PhotoViewer32_x.dll" >nul
			copy /y "%InstallMount%\%%i\Windows\System32\photowiz.dll" "%Temp%\photowiz64_x.dll" >nul
			copy /y "%InstallMount%\%%i\Windows\SysWOW64\photowiz.dll" "%Temp%\photowiz32_x.dll" >nul
		)

		echo.
		if "%ImageArchitecture%" equ "x86" (
			echo.Applying Windows Photo Viewer Metro Skin to [PhotoViewer.dll] file...
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\PhotoViewer_x.dll", "%Temp%\PhotoViewer.dll", "%Skins%\PhotoViewer.dll.res" ,,,
			call :RemoveFile "%Temp%\PhotoViewer_x.dll"
			echo.
			echo.Applying Windows Photo Viewer Metro Skin to [photowiz.dll] file...
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\photowiz_x.dll", "%Temp%\photowiz.dll", "%Skins%\photowiz.dll.res" ,,,
			call :RemoveFile "%Temp%\photowiz_x.dll"
		)

		if "%ImageArchitecture%" equ "x64" (
			echo.Applying Windows Photo Viewer Metro Skin to [PhotoViewer.dll] file...
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\PhotoViewer32_x.dll", "%Temp%\PhotoViewer32.dll", "%Skins%\PhotoViewer.dll.res" ,,,
			call :RemoveFile "%Temp%\PhotoViewer32_x.dll"
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\PhotoViewer64_x.dll", "%Temp%\PhotoViewer64.dll", "%Skins%\PhotoViewer.dll.res" ,,,
			call :RemoveFile "%Temp%\PhotoViewer64_x.dll"
			echo.
			echo.Applying Windows Photo Viewer Metro Skin to [photowiz.dll] file...
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\photowiz32_x.dll", "%Temp%\photowiz32.dll", "%Skins%\photowiz.dll.res" ,,,
			call :RemoveFile "%Temp%\photowiz32_x.dll"
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\photowiz64_x.dll", "%Temp%\photowiz64.dll", "%Skins%\photowiz.dll.res" ,,,
			call :RemoveFile "%Temp%\photowiz64_x.dll"
		)

		echo.
		echo.Copying Patched Windows Photo Viewer files...
		if "%ImageArchitecture%" equ "x86" (
			move /y "%Temp%\PhotoViewer.dll" "%InstallMount%\%%i\Program Files\Windows Photo Viewer\PhotoViewer.dll" >nul
			move /y "%Temp%\photowiz.dll" "%InstallMount%\%%i\Windows\System32\photowiz.dll" >nul
		)

		if "%ImageArchitecture%" equ "x64" (
			move /y "%Temp%\PhotoViewer64.dll" "%InstallMount%\%%i\Program Files\Windows Photo Viewer\PhotoViewer.dll" >nul
			move /y "%Temp%\PhotoViewer32.dll" "%InstallMount%\%%i\Program Files (x86)\Windows Photo Viewer\PhotoViewer.dll" >nul
			move /y "%Temp%\photowiz64.dll" "%InstallMount%\%%i\Windows\System32\photowiz.dll" >nul
			move /y "%Temp%\photowiz32.dll" "%InstallMount%\%%i\Windows\SysWOW64\photowiz.dll" >nul
		)
	)
)

call :RemoveFile "%Temp%\ResourceHacker.exe"
call :RemoveFile "%Temp%\ResourceHacker.ini"
call :RemoveFile "%Temp%\ResourceHacker.log"

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Photo Viewer Metro Skin#######################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set Skins=

endlocal

:: Returning to Integrate Custom Features Menu
goto :IntCustomFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Integrate Windows Media Player Metro Skin
::-------------------------------------------------------------------------------------------
:IntWMPMetroSkin

setlocal

cls
echo.===============================================================================
echo.          MSMG ToolKit - Integrate Windows Media Player Metro Skin
echo.===============================================================================
echo.

:: Getting Install Image Index Architecture
call :GetImageArchitecture "%InstallWim%", %DefaultIndexNo% >nul

set "Skins=%Skins%\MediaPlayer"

:: Checking whether Windows Media Player Metro Skin Pack file exist
for %%i in (setup_wm.exe.res, wmpconfig.exe.res, wmplayer.exe.res, wmploc.dll.res, wmpshare.exe.res, WMPSideShowGadget.exe.res) do (
	if not exist "%Skins%\%%i" (
		echo.Windows Media Player Metro Skin Pack file "%%i" not found...
		echo.
		echo.Please copy the above file to ^<Packs\Skins\MediaPlayer^> folder...
		goto :Stop
	)
)

echo.-------------------------------------------------------------------------------
echo.####Started Integrating Windows Media Player Metro Skin########################
echo.-------------------------------------------------------------------------------
echo.
echo.    Image                    : Install.wim
echo.    Image Index              : %ImageIndexNo%
echo.    Image Architecture       : %ImageArchitecture%
echo.    Image Version            : %ImageVersion%.%ImageServicePackBuild%.%ImageServicePackLevel%
echo.
echo.-------------------------------------------------------------------------------
echo.####Integrating Windows Media Player Metro Skin################################
echo.-------------------------------------------------------------------------------

copy /y "%ResourceHacker%" "%Temp%" >nul

for /l %%i in (1, 1, %ImageCount%) do (
	if exist "%InstallMount%\%%i" (
		echo.
		if not %%i gtr 9 echo.===========================[Install.wim, Index : %%i]============================
		if %%i gtr 9 echo.==========================[Install.wim, Index : %%i]============================
		echo.
		echo.Copying Windows Media Player files to Temporary Folder...
		if "%ImageArchitecture%" equ "x86" (
			copy /y "%InstallMount%\%%i\Program Files\Windows Media Player\setup_wm.exe" "%Temp%\setup_wm_x.exe" >nul
			copy /y "%InstallMount%\%%i\Program Files\Windows Media Player\wmpconfig.exe" "%Temp%\wmpconfig_x.exe" >nul
			copy /y "%InstallMount%\%%i\Program Files\Windows Media Player\wmplayer.exe" "%Temp%\wmplayer_x.exe" >nul
			copy /y "%InstallMount%\%%i\Program Files\Windows Media Player\wmpshare.exe" "%Temp%\wmpshare_x.exe" >nul
			if exist "%InstallMount%\%%i\Program Files\Windows Media Player\WMPSideShowGadget.exe" copy /y "%InstallMount%\%%i\Program Files\Windows Media Player\WMPSideShowGadget.exe" "%Temp%\WMPSideShowGadget_x.exe" >nul
			copy /y "%InstallMount%\%%i\Windows\System32\wmploc.dll" "%Temp%\wmploc_x.dll" >nul
		)

		if "%ImageArchitecture%" equ "x64" (
			copy /y "%InstallMount%\%%i\Program Files\Windows Media Player\setup_wm.exe" "%Temp%\setup_wm_x.exe" >nul
			copy /y "%InstallMount%\%%i\Program Files\Windows Media Player\wmpconfig.exe" "%Temp%\wmpconfig_x.exe" >nul
			copy /y "%InstallMount%\%%i\Program Files\Windows Media Player\wmplayer.exe" "%Temp%\wmplayer_x.exe" >nul
			copy /y "%InstallMount%\%%i\Program Files\Windows Media Player\wmpshare.exe" "%Temp%\wmpshare_x.exe" >nul
			if exist "%InstallMount%\%%i\Program Files\Windows Media Player\WMPSideShowGadget.exe" copy /y "%InstallMount%\%%i\Program Files\Windows Media Player\WMPSideShowGadget.exe" "%Temp%\WMPSideShowGadget_x.exe" >nul
			copy /y "%InstallMount%\%%i\Windows\System32\wmploc.dll" "%Temp%\wmploc64_x.dll" >nul
			copy /y "%InstallMount%\%%i\Windows\SysWOW64\wmploc.dll" "%Temp%\wmploc32_x.dll" >nul
		)

		echo.
		echo.Applying Windows Media Player Metro Skin to [setup_wm.exe] file...
		"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\setup_wm_x.exe", "%Temp%\setup_wm.exe", "%Skins%\setup_wm.exe.res" ,,,
		call :RemoveFile "%Temp%\setup_wm_x.exe"
		echo.Applying Windows Media Player Metro Skin to [wmpconfig.exe] file...
		"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\wmpconfig_x.exe", "%Temp%\wmpconfig.exe", "%Skins%\wmpconfig.exe.res" ,,,
		call :RemoveFile "%Temp%\wmpconfig_x.exe"
		echo.Applying Windows Media Player Metro Skin to [wmplayer.exe] file...
		"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\wmplayer_x.exe", "%Temp%\wmplayer.exe", "%Skins%\wmplayer.exe.res" ,,,
		call :RemoveFile "%Temp%\wmplayer_x.exe"
		echo.Applying Windows Media Player Metro Skin to [wmpshare.exe] file...
		"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\wmpshare_x.exe", "%Temp%\wmpshare.exe", "%Skins%\wmpshare.exe.res" ,,,
		call :RemoveFile "%Temp%\wmpshare_x.exe"

		if exist "%Temp%\WMPSideShowGadget_x.exe" (
			echo.Applying Windows Media Player Metro Skin to [WMPSideShowGadget.exe] file...
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\WMPSideShowGadget_x.exe", "%Temp%\WMPSideShowGadget.exe", "%Skins%\WMPSideShowGadget.exe.res" ,,,
			call :RemoveFile "%Temp%\WMPSideShowGadget_x.exe"
		)

		if "%ImageArchitecture%" equ "x86" (
			echo.Applying Windows Media Player Metro Skin to [wmploc.dll] file...
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\wmploc_x.dll", "%Temp%\wmploc.dll", "%Skins%\wmploc.dll.res" ,,,
			call :RemoveFile "%Temp%\wmploc_x.dll"
		)

		if "%ImageArchitecture%" equ "x64" (
			echo.Applying Windows Media Player Metro Skin to [wmploc.dll] file...
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\wmploc32_x.dll", "%Temp%\wmploc32.dll", "%Skins%\wmploc.dll.res" ,,,
			call :RemoveFile "%Temp%\wmploc32_x.dll"
			"%Temp%\ResourceHacker.exe" -addoverwrite "%Temp%\wmploc64_x.dll", "%Temp%\wmploc64.dll", "%Skins%\wmploc.dll.res" ,,,
			call :RemoveFile "%Temp%\wmploc64_x.dll"
		)

		echo.
		echo.Copying Patched Windows Media Player files...
		move /y "%Temp%\setup_wm.exe" "%InstallMount%\%%i\Program Files\Windows Media Player\setup_wm.exe" >nul
		move /y "%Temp%\wmpconfig.exe" "%InstallMount%\%%i\Program Files\Windows Media Player\wmpconfig.exe" >nul
		move /y "%Temp%\wmplayer.exe" "%InstallMount%\%%i\Program Files\Windows Media Player\wmplayer.exe" >nul
		move /y "%Temp%\wmpshare.exe" "%InstallMount%\%%i\Program Files\Windows Media Player\wmpshare.exe" >nul
		if exist "%Temp%\WMPSideShowGadget.exe" move /y "%Temp%\WMPSideShowGadget.exe" "%InstallMount%\%%i\Program Files\Windows Media Player\WMPSideShowGadget.exe" >nul
		if "%ImageArchitecture%" equ "x86" move /y "%Temp%\wmploc.dll" "%InstallMount%\%%i\Windows\System32\wmploc.dll" >nul
		if "%ImageArchitecture%" equ "x64" move /y "%Temp%\wmploc64.dll" "%InstallMount%\%%i\Windows\System32\wmploc.dll" >nul
		if "%ImageArchitecture%" equ "x64" move /y "%Temp%\wmploc32.dll" "%InstallMount%\%%i\Windows\SysWOW64\wmploc.dll" >nul
	)
)

call :RemoveFile "%Temp%\ResourceHacker.exe"
call :RemoveFile "%Temp%\ResourceHacker.ini"
call :RemoveFile "%Temp%\ResourceHacker.log"

echo.
echo.-------------------------------------------------------------------------------
echo.####Finished Integrating Windows Media Player Metro Skin#######################
echo.-------------------------------------------------------------------------------

:Stop
echo.
echo.===============================================================================
echo.
pause

set Skins=

endlocal

:: Returning to Integrate Custom Features Menu
goto :IntCustomFeaturesMenu
::-------------------------------------------------------------------------------------------

::-------------------------------------------------------------------------------------------
:: Function to Remove Windows Components Menu
::-------------------------------------------------------------------------------------------
:RemoveWindowsComponentsMenu

:: Remove Windows 10 v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2, Windows 11 v21H2/v22H2 Client
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "22623" (
	cls
	echo.===============================================================================
	echo.                 MSMG ToolKit - Remove Windows Components Menu
	echo.===============================================================================
	echo.
	echo.  [1]   Select Windows Components
	echo.
	echo.  [2]   Start Removing Windows Components
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:12X /N /M "Enter Your Choice : "
	if errorlevel 3 goto :RemoveMenu
	if errorlevel 2 goto :RemoveWindowsComponents
	if errorlevel 1 goto :SelectWindowsComponentsMenu
)

:SelectWindowsComponentsMenu
:: Remove Windows 10 v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2, Windows 11 v21H2/v22H2 Client
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" (
	cls
	echo.===============================================================================
	echo.                 MSMG ToolKit - Remove Windows Components Menu
	echo.===============================================================================
	echo.  [1]   Internet
	echo.
	echo.  [2]   Multimedia
	echo.
	echo.  [3]   Network
	echo.
	echo.  [4]   Privacy
	echo.
	echo.  [5]   Remoting
	echo.
	echo.  [6]   System
	echo.
	echo.  [7]   System Apps
	echo.
	if "%ImageFlag%" equ "EnterpriseS" echo.
	if "%ImageFlag%" equ "EnterpriseSN" echo.

	if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "22623" if "%ImageFlag%" neq "EnterpriseS" if "%ImageFlag%" neq "EnterpriseSN" (
		echo.  [8]   Windows Apps
	)
	echo.
	echo.
	echo.  [X]   Go Back
	echo.===============================================================================
	echo.
	choice /C:12345678X /N /M "Enter Your Choice : "
	if errorlevel 9 goto :RemoveWindowsComponentsMenu
	if errorlevel 8 if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "22623" if "%ImageFlag%" neq "EnterpriseS" if "%ImageFlag%" neq "EnterpriseSN" goto :RemoveWindowsAppsMenu
	if errorlevel 7 goto :RemoveSystemAppsMenu
	if errorlevel 6 goto :RemoveSystemMenu
	if errorlevel 5 goto :RemoveRemotingMenu
	if errorlevel 4 goto :RemovePrivacyMenu
	if errorlevel 3 goto :RemoveNetworkMenu
	if errorlevel 2 goto :RemoveMultimediaMenu
	if errorlevel 1 goto :RemoveInternetMenu
)

:RemoveInternetMenu
:: Remove Windows 10 v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2, Windows 11 v21H2/v22H2 Client Internet Menu
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "22623" (
	cls
	echo.===============================================================================
	echo.                 MSMG ToolKit - Remove Internet Components Menu
	echo.===============================================================================
	echo.
	if "%SelectedSourceOS%" equ "w10" (
		echo.  [1] %C_AdobeFlashForWindows% Adobe Flash For Windows
		echo.
		echo.  [2] %C_EdgeChromium% Edge Chromium Browser
		echo.
		echo.  [3] %C_InternetExplorer% Internet Explorer
		echo.
	)

	if "%SelectedSourceOS%" equ "w11" (
		echo.  [1] %C_EdgeChromium% Edge Chromium Browser ^| Depends on: Edge WebView
		echo.
		echo.  [2] %C_EdgeWebView% Edge WebView ^| Needed for: News and Interests Widgets App
		echo.
		echo.  [3] %C_InternetExplorer% Internet Explorer
		echo.
	)
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.
	echo.  [A]   All Internet Components
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:123AX /N /M "Enter Your Choice : "
	if errorlevel 5 goto :SelectWindowsComponentsMenu
	if errorlevel 4 (
		if "%SelectedSourceOS%" equ "w10" set "C_AdobeFlashForWindows=-"
		set "C_EdgeChromium=-"
		if "%SelectedSourceOS%" equ "w11" (
			set "C_ClientWebExperience=-"
			set "C_EdgeWebView=-"
		)
		set "C_InternetExplorer=-"
	)
	if errorlevel 3 ( if "%C_InternetExplorer%" equ "+" ( set "C_InternetExplorer=-" ) else ( set "C_InternetExplorer=+" ) )
	if errorlevel 2 if "%SelectedSourceOS%" equ "w11" (
		if "%C_EdgeWebView%" equ "+" (
			set "C_ClientWebExperience=-"
			set "C_EdgeChromium=-"
			set "C_EdgeWebView=-"
		) else ( 
			set "C_EdgeWebView=+"
		)
	)
	if errorlevel 2 if "%SelectedSourceOS%" equ "w10" ( if "%C_EdgeChromium%" equ "+" ( set "C_EdgeChromium=-" ) else ( set "C_EdgeChromium=+" ) )
	if errorlevel 1 if "%SelectedSourceOS%" equ "w11" (
		if "%C_EdgeChromium%" equ "+" (
			set "C_EdgeChromium=-"
		) else ( 
			set "C_EdgeChromium=+"
			set "C_EdgeWebView=+"
		)
	)
	if errorlevel 1 if "%SelectedSourceOS%" equ "w10" ( if "%C_AdobeFlashForWindows%" equ "+" ( set "C_AdobeFlashForWindows=-" ) else ( set "C_AdobeFlashForWindows=+" ) )

	goto :RemoveInternetMenu
)

:RemoveMultimediaMenu
:: Remove Windows 10 v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2, Windows 11 v21H2/v22H2 Client Multimedia Menu
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "22623" (
	cls
	echo.===============================================================================
	echo.                 MSMG ToolKit - Remove Multimedia Components Menu
	echo.===============================================================================
	echo.
	echo.  [A] %C_FirstLogonAnimation% First Logon Animation
	echo.  [B] %C_GameExplorer% Game Explorer ^| Needed for: Microsoft Games
	echo.  [C] %C_LockScreenBackground% Lock Screen Background
	echo.  [D] %C_ScreenSavers% Screen Savers
	if "%SelectedSourceOS%" equ "w10" echo.  [E] %C_SnippingTool% Snipping Tool
	echo.  [F] %C_SoundThemes% Sound Themes
	if "%SelectedSourceOS%" equ "w10" echo.  [G] %C_SpeechRecognition% Speech Recognition ^| Needed for: Cortana, Ease of Access
	if "%SelectedSourceOS%" equ "w11" echo.  [G] %C_SpeechRecognition% Speech Recognition ^| Needed for: Cortana, Ease of Access ^& OOBE
	echo.  [H] %C_Wallpapers% Wallpapers
	echo.  [I] %C_WindowsMediaPlayer% Windows Media Player
	echo.  [J] %C_WindowsPhotoViewer% Windows Photo Viewer
	echo.  [K] %C_WindowsThemes% Windows Themes
	echo.  [L] %C_WindowsTIFFIFilter% Windows TIFF IFilter ^(OCR^)
	echo.  [M] %C_WinSAT% Windows System Assessment Tool
	echo.
	echo.
	echo.  [1]   All Multimedia Components
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:ABCDEFGHIJKLM1X /N /M "Enter Your Choice : "
	if errorlevel 15 goto :SelectWindowsComponentsMenu
	if errorlevel 14 (
		set "C_Cortana=-"
		set "C_FirstLogonAnimation=-"
		set "C_GameExplorer=-"
		set "C_LockScreenBackground=-"
		set "C_ScreenSavers=-"
		if "%SelectedSourceOS%" equ "w10" set "C_SnippingTool=-"
		set "C_SoundThemes=-"
		set "C_SpeechRecognition=-"
		set "C_Wallpapers=-"
		set "C_WindowsMediaPlayer=-"
		set "C_WindowsPhotoViewer=-"
		set "C_WindowsThemes=-"
		set "C_WindowsTIFFIFilter=-"
		set "C_WinSAT=-"
	)
	if errorlevel 13 ( if "%C_WinSAT%" equ "+" ( set "C_WinSAT=-" ) else ( set "C_WinSAT=+" ) )
	if errorlevel 12 ( if "%C_WindowsTIFFIFilter%" equ "+" ( set "C_WindowsTIFFIFilter=-" ) else ( set "C_WindowsTIFFIFilter=+" ) )
	if errorlevel 11 ( if "%C_WindowsThemes%" equ "+" ( set "C_WindowsThemes=-" ) else ( set "C_WindowsThemes=+" ) )
	if errorlevel 10 ( if "%C_WindowsPhotoViewer%" equ "+" ( set "C_WindowsPhotoViewer=-" ) else ( set "C_WindowsPhotoViewer=+" ) )
	if errorlevel 9  ( if "%C_WindowsMediaPlayer%" equ "+" ( set "C_WindowsMediaPlayer=-" ) else ( set "C_WindowsMediaPlayer=+" ) )
	if errorlevel 8  ( if "%C_Wallpapers%" equ "+" ( set "C_Wallpapers=-" ) else ( set "C_Wallpapers=+" ) )
	if errorlevel 7  (
		if "%C_SpeechRecognition%" equ "+" ( 
			set "C_Cortana=-"
			set "C_SpeechRecognition=-"
		) else ( 
			set "C_SpeechRecognition=+"
		)
	)
	if errorlevel 6  ( if "%C_SoundThemes%" equ "+" ( set "C_SoundThemes=-" ) else  ( set "C_SoundThemes=+" ) )
	if errorlevel 5  if "%SelectedSourceOS%" equ "w10" ( if "%C_SnippingTool%" equ "+" ( set "C_SnippingTool=-" ) else ( set "C_SnippingTool=+" ) )
	if errorlevel 4  ( if "%C_ScreenSavers%" equ "+" ( set "C_ScreenSavers=-" ) else  ( set "C_ScreenSavers=+" ) )
	if errorlevel 3  ( if "%C_LockScreenBackground%" equ "+" ( set "C_LockScreenBackground=-" ) else  ( set "C_LockScreenBackground=+" ) )
	if errorlevel 2  ( if "%C_GameExplorer%" equ "+" ( set "C_GameExplorer=-" ) else  ( set "C_GameExplorer=+" ) )
	if errorlevel 1  ( if "%C_FirstLogonAnimation%" equ "+" ( set "C_FirstLogonAnimation=-" ) else  ( set "C_FirstLogonAnimation=+" ) )

	goto :RemoveMultimediaMenu
)

:RemoveNetworkMenu
:: Remove Windows 10 v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2, Windows 11 v21H2/v22H2 Client Network Menu
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "22623" (
	cls
	echo.===============================================================================
	echo.                MSMG ToolKit - Remove Network Components Menu
	echo.===============================================================================
	echo.  [1] %C_OfflineFiles% Offline Files
	echo.
	echo.  [2] %C_OpenSSH% Open SSH
	echo.
	echo.  [3] %C_RemoteDesktopClient% Remote Desktop Client
	echo.
	echo.  [4] %C_RemoteDifferentialCompression% Remote Differential Compression ^(RDC^)
	echo.
	echo.  [5] %C_SimpleTCPIPServices% Simple TCP/IP Services
	echo.
	echo.  [6] %C_TelnetClient% Telnet Client
	echo.
	echo.  [7] %C_TFTPClient% TFTP Client
	echo.
	echo.  [8] %C_WalletService% Wallet Service ^| Needed for: Microsoft Pay
	echo.
	echo.  [9] %C_WindowsMail% Windows Mail ^| Needed for: Windows Mail App
	echo.
	echo.  [A]   All Network Components
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:123456789AX /N /M "Enter Your Choice : "
	if errorlevel 11 goto :SelectWindowsComponentsMenu
	if errorlevel 10 (
		set "C_CommunicationsApps=-"
		set "C_OfflineFiles=-"
		set "C_OpenSSH=-"
		set "C_RemoteDesktopClient=-"
		set "C_RemoteDifferentialCompression=-"
		set "C_SimpleTCPIPServices=-"
		set "C_TelnetClient=-"
		set "C_TFTPClient=-"
		set "C_Wallet=-"
		set "C_WalletService=-"
		set "C_WindowsMail=-"
	)
	if errorlevel 9 (
		if "%C_WindowsMail%" equ "+" (
			set "C_CommunicationsApps=-"
			set "C_WindowsMail=-"
		) else (
			set "C_WindowsMail=+"
		)
	)
	if errorlevel 8 (
		if "%C_WalletService%" equ "+" (
			set "C_Wallet=-"
			set "C_WalletService=-"
		) else (
			set "C_WalletService=+"
		)
	)
	if errorlevel 7 ( if "%C_TFTPClient%" equ "+" ( set "C_TFTPClient=-" ) else ( set "C_TFTPClient=+" ) )
	if errorlevel 6 ( if "%C_TelnetClient%" equ "+" ( set "C_TelnetClient=-" ) else ( set "C_TelnetClient=+" ) )
	if errorlevel 5 ( if "%C_SimpleTCPIPServices%" equ "+" ( set "C_SimpleTCPIPServices=-" ) else ( set "C_SimpleTCPIPServices=+" ) )
	if errorlevel 4 ( if "%C_RemoteDifferentialCompression%" equ "+" ( set "C_RemoteDifferentialCompression=-" ) else ( set "C_RemoteDifferentialCompression=+" ) )
	if errorlevel 3 ( if "%C_RemoteDesktopClient%" equ "+" ( set "C_RemoteDesktopClient=-" ) else ( set "C_RemoteDesktopClient=+" ) )
	if errorlevel 2 ( if "%C_OpenSSH%" equ "+" ( set "C_OpenSSH=-" ) else  ( set "C_OpenSSH=+" ) )
	if errorlevel 1 ( if "%C_OfflineFiles%" equ "+" ( set "C_OfflineFiles=-" ) else  ( set "C_OfflineFiles=+" ) )

	goto :RemoveNetworkMenu
)

:RemovePrivacyMenu
:: Remove Windows 10 v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2, Windows 11 v21H2/v22H2 Client Privacy Menu
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "22623" (
	cls
	echo.===============================================================================
	echo.                  MSMG ToolKit - Remove Privacy Components Menu
	echo.===============================================================================
	echo.
	echo.  [A] %C_AssignedAccess% Assigned Access
	echo.  [B] %C_CEIP% Customer Experience Improvement Program ^(CEIP^)
	echo.  [C] %C_FaceRecognition% Face Recognition
	echo.  [D] %C_KernelDebugging% Kernel Debugging ^| Depends on: Windows Error Reporting
	echo.  [E] %C_LocationService% Location Service
	echo.  [F] %C_PicturePassword% Picture Password
	echo.  [G] %C_PinEnrollment% Pin SignIn Support
	echo.  [H] %C_UnifiedTelemetryClient% Unified Telemetry Client ^(Asimov^) ^| Depends on: Windows Error Reporting
	echo.  [I] %C_WiFiNetworkManager% WiFi Network Manager ^(WiFi Sense^)
	if "%ImageBuild%" equ "17763" echo.  [J] %C_WindowsErrorReporting% Windows Error Reporting
	if "%ImageBuild%" geq "18362" if "%ImageBuild%" leq "18363" echo.  [J] %C_WindowsErrorReporting% Windows Error Reporting ^| Needed for: Out of Box Experience
	if "%ImageBuild%" geq "19041" if "%ImageBuild%" leq "22623" echo.  [J] %C_WindowsErrorReporting% Windows Error Reporting
	echo.  [K] %C_WindowsInsiderHub% Windows Insider Hub
	echo.
	echo.
	echo.  [1]   All Privacy Components
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:ABCDEFGHIJK1X /N /M "Enter Your Choice : "
	if errorlevel 13 goto :SelectWindowsComponentsMenu
	if errorlevel 12 (
		set "C_AssignedAccess=-"
		if "%ImageFlag%" neq "Core" if "%ImageFlag%" neq "CoreN" if "%ImageFlag%" neq "CoreSingleLanguage" set "C_AssignedAccessLockApp=-"
		set "C_CEIP=-"
		set "C_FaceRecognition=-"
		set "C_KernelDebugging=-"
		set "C_LocationService=-"
		set "C_PicturePassword=-"
		set "C_PinEnrollment=-"
		set "C_UnifiedTelemetryClient=-"
		set "C_WiFiNetworkManager=-"
		set "C_WindowsErrorReporting=-"
		set "C_WindowsInsiderHub=-"
	)
	if errorlevel 11 ( if "%C_WindowsInsiderHub%" equ "+" ( set "C_WindowsInsiderHub=-" ) else ( set "C_WindowsInsiderHub=+" ) )
	if errorlevel 10 ( 
		if "%C_WindowsErrorReporting%" equ "+" ( 
			set "C_KernelDebugging=-"
			set "C_UnifiedTelemetryClient=-"
			set "C_WindowsErrorReporting=-"
		) else ( 
			set "C_WindowsErrorReporting=+"
		)
	)
	if errorlevel 9  ( if "%C_WiFiNetworkManager%" equ "+" ( set "C_WiFiNetworkManager=-" ) else ( set "C_WiFiNetworkManager=+" ) )
	if errorlevel 8 ( 
		if "%C_UnifiedTelemetryClient%" equ "+" ( 
			set "C_UnifiedTelemetryClient=-"
		) else ( 
			set "C_UnifiedTelemetryClient=+"
			set "C_WindowsErrorReporting=+"
		)
	)
	if errorlevel 7  ( if "%C_PinEnrollment%" equ "+" ( set "C_PinEnrollment=-" ) else ( set "C_PinEnrollment=+" ) )
	if errorlevel 6  ( if "%C_PicturePassword%" equ "+" ( set "C_PicturePassword=-" ) else ( set "C_PicturePassword=+" ) )
	if errorlevel 5  ( if "%C_LocationService%" equ "+" ( set "C_LocationService=-" ) else ( set "C_LocationService=+" ) )
	if errorlevel 4 ( 
		if "%C_KernelDebugging%" equ "+" ( 
			set "C_KernelDebugging=-"
		) else ( 
			set "C_KernelDebugging=+"
			set "C_WindowsErrorReporting=+"
		)
	)
	if errorlevel 3  ( if "%C_FaceRecognition%" equ "+" ( set "C_FaceRecognition=-" ) else ( set "C_FaceRecognition=+" ) )
	if errorlevel 2  ( if "%C_CEIP%" equ "+" ( set "C_CEIP=-" ) else ( set "C_CEIP=+" ) )
	if errorlevel 1 ( 
		if "%C_AssignedAccess%" equ "+" ( 
			set "C_AssignedAccess=-"
			if "%ImageFlag%" neq "Core" if "%ImageFlag%" neq "CoreN" if "%ImageFlag%" neq "CoreSingleLanguage" set "C_AssignedAccessLockApp=-"
		) else ( 
			set "C_AssignedAccess=+"
		)
	)

	goto :RemovePrivacyMenu
)

:RemoveRemotingMenu
:: Remove Windows 10 v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2, Windows 11 v21H2/v22H2 Client Remoting Menu
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "22623" (
	cls
	echo.===============================================================================
	echo.                  MSMG ToolKit - Remove Remoting Components Menu
	echo.===============================================================================
	if "%SelectedSourceOS%" equ "w10" (
		echo.  [1] %C_HomeGroup% Home Group
	)
	echo.
	echo.  [2] %C_MultiPointConnector% MultiPoint Connector
	echo.
	echo.  [3] %C_OneDrive% OneDrive Desktop Client
	echo.
	echo.  [4] %C_RemoteAssistance% Remote Assistance
	echo.
	echo.  [5] %C_RemoteDesktopServer% Remote Desktop Server
	echo.
	echo.  [6] %C_RemoteRegistry% Remote Registry
	echo.
	echo.  [7] %C_WorkFoldersClient% Work Folders Client
	echo.
	echo.  [A]   All Remoting Components
	echo.
	echo.  [X]   Go Back
	echo.
	echo.===============================================================================
	echo.
	choice /C:1234567AX /N /M "Enter Your Choice : "
	if errorlevel 9 goto :SelectWindowsComponentsMenu
	if errorlevel 8 (
		if "%SelectedSourceOS%" equ "w10" set "C_HomeGroup=-"
		set "C_MultiPointConnector=-"
		set "C_OneDrive=-"
		set "C_RemoteAssistance=-"
		set "C_RemoteDesktopServer=-"
		set "C_RemoteRegistry=-"
		set "C_WorkFoldersClient=-"
	)

	if errorlevel 7 ( if "%C_WorkFoldersClient%" equ "+" ( set "C_WorkFoldersClient=-" ) else ( set "C_WorkFoldersClient=+" ) )
	if errorlevel 6 ( if "%C_RemoteRegistry%" equ "+" ( set "C_RemoteRegistry=-" ) else ( set "C_RemoteRegistry=+" ) )
	if errorlevel 5 ( if "%C_RemoteDesktopServer%" equ "+" ( set "C_RemoteDesktopServer=-" ) else ( set "C_RemoteDesktopServer=+" ) )
	if errorlevel 4 ( if "%C_RemoteAssistance%" equ "+" ( set "C_RemoteAssistance=-" ) else ( set "C_RemoteAssistance=+" ) )
	if errorlevel 3 ( if "%C_OneDrive%" equ "+" ( set "C_OneDrive=-" ) else ( set "C_OneDrive=+" ) )
	if errorlevel 2 ( if "%C_MultiPointConnector%" equ "+" ( set "C_MultiPointConnector=-" ) else ( set "C_MultiPointConnector=+" ) )
	if errorlevel 1 if "%SelectedSourceOS%" equ "w10" ( if "%C_HomeGroup%" equ "+" ( set "C_HomeGroup=-" ) else ( set "C_HomeGroup=+" ) )

	goto :RemoveRemotingMenu
)

:RemoveSystemMenu
:: Remove Windows 10 v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2, Windows 11 v21H2/v22H2 Client System Menu
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "22623" (
	cls
	echo.===============================================================================
	echo.                  MSMG ToolKit - Remove System Components Menu
	echo.===============================================================================
	echo.  [A] %C_AccessibilityTools% Accessibility Tools
	if "%ImageFlag%" equ "EnterpriseS" echo.  [B] %C_Calculator% Calculator
	if "%ImageFlag%" equ "EnterpriseSN" echo.  [B] %C_Calculator% Calculator
	echo.  [C] %C_DeviceLockdown% Device Lockdown ^(Embedded Experience^)
	echo.  [D] %C_EaseOfAccessCursors% Ease of Access Cursors ^| Depends on: Accessibility Tools
	echo.  [E] %C_EaseOfAccessThemes% Ease of Access Themes ^| Depends on: Accessibility Tools
	echo.  [F] %C_EasyTransfer% Easy Transfer
	echo.  [G] %C_FileHistory% File History
	echo.  [H] %C_Magnifier% Magnifier ^| Depends on: Accessibility Tools
	echo.  [I] %C_ManualSetup% Manual Setup ^(InPlace Upgrade^)
	echo.  [J] %C_Narrator% Narrator ^| Depends on: Accessibility Tools
	echo.  [K] %C_Notepad% Notepad : ^| Needed for: Open With Dialog
	echo.  [L] %C_OnScreenKeyboard% On Screen Keyboard ^| Depends on: Accessibility Tools
	if "%SelectedSourceOS%" equ "w10" echo.  [M] %C_Paint% Paint
	echo.  [N] %C_ProjFS% Projected File System ^(ProjFS^)
	echo.  [O] %C_SecurityCenter% Security Center ^| Depends on: Windows Defender
	echo.  [P] %C_StepsRecorder% Steps Recorder
	echo.  [Q] %C_StorageSpaces% Storage Spaces
	echo.  [R] %C_SystemRestore% System Restore ^| Depends on: Windows Backup
	echo.  [S] %C_WindowsBackup% Windows Backup
	echo.  [T] %C_WindowsFirewall% Windows Firewall
	echo.  [U] %C_WindowsSubsystemForLinux% Windows Subsystem For Linux
	echo.  [V] %C_WindowsToGo% Windows To Go
	echo.  [W] %C_Wordpad% Wordpad
	echo.
	echo.  [1]   All System Components
	echo.  [X]   Go Back
	echo.===============================================================================
	choice /C:ABCDEFGHIJKLMNOPQRSTUVW1X /N /M "Enter Your Choice : "
	if errorlevel 25 goto :SelectWindowsComponentsMenu
	if errorlevel 24 (
		set "C_AccessibilityTools=-"
		if "%ImageFlag%" equ "EnterpriseS" set "C_Calculator=-"
		if "%ImageFlag%" equ "EnterpriseSN" set "C_Calculator=-"
		set "C_DeviceLockdown=-"
		set "C_EaseOfAccessCursors=-"
		set "C_EaseOfAccessThemes=-"
		set "C_EasyTransfer=-"
		set "C_FileHistory=-"
		set "C_Magnifier=-"
		set "C_ManualSetup=-"
		set "C_Narrator=-"
		set "C_Notepad=-"
		set "C_OnScreenKeyboard=-"
		if "%SelectedSourceOS%" equ "w10" set "C_Paint=-"
		set "C_ProjFS=-"
		set "C_SecurityCenter=-"
		set "C_StepsRecorder=-"
		set "C_StorageSpaces=-"
		set "C_SystemRestore=-"
		set "C_WindowsBackup=-"
		set "C_WindowsFirewall=-"
		set "C_WindowsSubsystemForLinux=-"
		set "C_WindowsToGo=-"
		set "C_Wordpad=-"
	)
	if errorlevel 23 ( if "%C_Wordpad%" equ "+" ( set "C_Wordpad=-" ) else ( set "C_Wordpad=+" ) )
	if errorlevel 22 ( if "%C_WindowsToGo%" equ "+" ( set "C_WindowsToGo=-" ) else ( set "C_WindowsToGo=+" ) )
	if errorlevel 21 ( if "%C_WindowsSubsystemForLinux%" equ "+" ( set "C_WindowsSubsystemForLinux=-" ) else ( set "C_WindowsSubsystemForLinux=+" ) )
	if errorlevel 20 ( if "%C_WindowsFirewall%" equ "+" ( set "C_WindowsFirewall=-" ) else ( set "C_WindowsFirewall=+" ) )
	if errorlevel 19 ( 
		if "%C_WindowsBackup%" equ "+" ( 
			set "C_SystemRestore=-"
			set "C_WindowsBackup=-"
		) else ( 
			set "C_WindowsBackup=+"
		)
	)
	if errorlevel 18 ( 
		if "%C_SystemRestore%" equ "+" ( 
			set "C_SystemRestore=-"
		) else ( 
			set "C_SystemRestore=+"
			set "C_WindowsBackup=+"
		)
	)
	if errorlevel 17 ( if "%C_StorageSpaces%" equ "+" ( set "C_StorageSpaces=-" ) else ( set "C_StorageSpaces=+" ) )
	if errorlevel 16 ( if "%C_StepsRecorder%" equ "+" ( set "C_StepsRecorder=-" ) else ( set "C_StepsRecorder=+" ) )
	if errorlevel 15 (
		if "%C_SecurityCenter%" equ "+" ( 
			set "C_SecurityCenter=-"
		) else ( 
			set "C_SecurityCenter=+"
			set "C_WindowsDefender=+"
		)
	)
	if errorlevel 14 ( if "%C_ProjFS%" equ "+" ( set "C_ProjFS=-" ) else ( set "C_ProjFS=+" ) )
	if errorlevel 13 if "%SelectedSourceOS%" equ "w10" ( if "%C_Paint%" equ "+" ( set "C_Paint=-" ) else ( set "C_Paint=+" ) )
	if errorlevel 12 (
		if "%C_OnScreenKeyboard%" equ "+" (
			set "C_OnScreenKeyboard=-"
		) else (
			set "C_AccessibilityTools=+"
			set "C_OnScreenKeyboard=+"
		)
	)
	if errorlevel 11 ( if "%C_Notepad%" equ "+" ( set "C_Notepad=-" ) else ( set "C_Notepad=+" ) )
	if errorlevel 10 (
		if "%C_Narrator%" equ "+" (
			set "C_Narrator=-"
		) else (
			set "C_AccessibilityTools=+"
			set "C_Narrator=+"
		)
	)
	if errorlevel 9 ( if "%C_ManualSetup%" equ "+" ( set "C_ManualSetup=-" ) else ( set "C_ManualSetup=+" ) )
	if errorlevel 8 (
		if "%C_Magnifier%" equ "+" (
			set "C_Magnifier=-"
		) else (
			set "C_AccessibilityTools=+"
			set "C_Magnifier=+"
		)
	)
	if errorlevel 7 ( if "%C_FileHistory%" equ "+" ( set "C_FileHistory=-" ) else ( set "C_FileHistory=+" ) )
	if errorlevel 6 ( if "%C_EasyTransfer%" equ "+" ( set "C_EasyTransfer=-" ) else ( set "C_EasyTransfer=+" ) )
	if errorlevel 5 (
		if "%C_EaseOfAccessThemes%" equ "+" (
			set "C_EaseOfAccessThemes=-"
		) else (
			set "C_AccessibilityTools=+"
			set "C_EaseOfAccessThemes=+"
		)
	)
	if errorlevel 4 (
		if "%C_EaseOfAccessCursors%" equ "+" (
			set "C_EaseOfAccessCursors=-"
		) else (
			set "C_AccessibilityTools=+"
			set "C_EaseOfAccessCursors=+"
		)
	)
	if errorlevel 3 ( if "%C_DeviceLockdown%" equ "+" ( set "C_DeviceLockdown=-" ) else ( set "C_DeviceLockdown=+" ) )
	if "%ImageFlag%" equ "EnterpriseSN" if errorlevel 2 ( if "%C_Calculator%" equ "+" ( set "C_Calculator=-" ) else ( set "C_Calculator=+" ) )
	if "%ImageFlag%" equ "EnterpriseS" if errorlevel 2 ( if "%C_Calculator%" equ "+" ( set "C_Calculator=-" ) else ( set "C_Calculator=+" ) )
	if errorlevel 1 ( 
		if "%C_AccessibilityTools%" equ "+" (
			set "C_AccessibilityTools=-"
			set "C_EaseOfAccessCursors=-"
			set "C_EaseOfAccessThemes=-"
			set "C_Magnifier=-"
			set "C_Narrator=-"
			set "C_OnScreenKeyboard=-"
		) else (
			set "C_AccessibilityTools=+"
		)
	)

	goto :RemoveSystemMenu
)

:RemoveSystemAppsMenu
:: Remove Windows 10 v1809/v1903/v1909/v2004/v20H2/v21H1/v21H2/v22H2, Windows 11 v21H2/v22H2 Client Edition System Apps Menu
if "%SelectedSourceOS%" neq "w7" if "%SelectedSourceOS%" neq "w81" if "%ImageBuild%" geq "17763" if "%ImageBuild%" leq "22623" (
	cls
	echo.===============================================================================
	echo.                  MSMG ToolKit - Remove System Apps Menu
	echo.===============================================================================
	echo.  [01] %C_AADBrokerPlugin% AAD Broker Plugin - Credential Handler for Microsoft Azure Logon ^| Needed for: Microsoft Account, Windows Store
	echo.  [02] %C_AccountsControl% Accounts Control - App to add Microsoft Account for Microsoft Apps ^| Needed for: Windows Store
	echo.  [03] %C_AddSuggestedFoldersToLibraryDialog% Add Suggested Folders to Library Dialog
	echo.  [04] %C_AppResolv