const fragShader="#ifdef GL_FRAGMENT_PRECISION_HIGH\n#define highmedp highp\n#else\n#define highmedp mediump\n#endif\nprecision highmedp float;\n\n// Scene buffer\nuniform sampler2D uMainSampler; \nvarying vec2 outTexCoord;\n\n// Effect parameters\nuniform float intensity;\nuniform float radius;\nuniform vec2 center;\nuniform vec2 texSize;\n\nvoid main (void) {\n\n  vec2 tc = outTexCoord * texSize;  \n  tc -= center;\n  float dist = length(tc) / radius;\n\n  vec4 front = texture2D(uMainSampler, outTexCoord);\n\n  float intens = 0.0;\n  if(dist < 1.0) {\n    intens = 1.0;\n  }\n\n  vec3 inverse = vec3(front.a - front.rgb);\n  gl_FragColor = vec4(mix(front.rgb, inverse, intens), front.a);\n}\n";export class InvertFX extends Phaser.Renderer.WebGL.Pipelines.PostFXPipeline{constructor(e){super({name:"mInvertFX",game:e,renderTarget:!0,fragShader}),this._intensity=1,this._radius=0}onPreRender(){this.set1f("intensity",this._intensity),this.set1f("radius",this._radius),this.set2f("texSize",100,100),this.set2f("center",.5,.5)}}export default InvertFX;