=begin
(c) TIG 2009 - 2013
Adds new methods to Sketchup::ArcCurve
.is_loop? true=Circle OR Polygon, false=Arc
.is_circle? true=Circle, false=Arc or Polygon
.is_polygon? true=Polygon, false=Arc or Circle
v1.1 .is_loop? improved since a vert can have >1 edges BUT some of these might belong to other curve etc.
v1.2 Update because in v7.1M1 SUp contains own curve.is_polygon? method - future-proofed others too in case they get added later... 20091117 
v1.3 is_loop? changed as built into toolsets.

=end
class Sketchup::ArcCurve
#=begin
 if not Sketchup::Curve.method_defined?(:is_loop?) ########## 
  def is_loop?(a=nil)### circle OR polygon
    a=self unless a
    a.vertices.each{|v|edgecount=0
      v.edges.each{|ee|edgecount+=1 if ee.curve==a}
      return false if edgecount<2
      ### vert can have >1 edge BUT it might belong to other curve etc
    }
    return true
  end#if
 end#if ##################
#=end
  ###
 if not Sketchup::Curve.method_defined?(:is_polygon?) ##########
  def is_polygon?()
    self.edges.each{|e|
      e.vertices.each{|v|
        if not v.edges[1]
          return false ### it's an arc
          break
        end#if
      }
    }
    ### if we get here it might be a polygon !!!
    model=Sketchup.active_model
    entities=model.active_entities
    edge=self.edges[0]
    all_connected=edge.all_connected
    tgroup=entities.add_group(all_connected)
    es=edge.start.position
    ee=edge.end.position
    group=tgroup.copy
    tgroup.explode
    gents=group.entities
    gedges=[]
    gents.each{|e|gedges<<e if e.class==Sketchup::Edge}
    gedge=nil
    gedges.each{|e|
      e.smooth=false
      e.soft=false
      gedge=e if (e.start.position==es and e.end.position==ee)or(e.start.position==ee and e.end.position==es)}
    ### remove all faces so only face and pushpull's remain
    gents.each{|e|e.erase! if e.class==Sketchup::Face}
    gedge.find_faces
    face=nil
    gents.each{|e|face=e if e.class==Sketchup::Face}
    return false if not face
    face.pushpull(1.0)
    edges=[]
    gents.each{|e|edges<<e if e.class==Sketchup::Edge}
    edges.each{|e|
      if e.smooth? and e.soft?
        group.erase! if group.valid?
        return false ### a circle
      end#if
    }
    group.erase! if group.valid?
    return true ### a polygon
  end#def is_polygon?
 end#if##############################################
  ###
 if not Sketchup::Curve.method_defined?(:is_circle?) ########## 
  def is_circle?()
    self.edges.each{|e|
      e.vertices.each{|v|
        if not v.edges[1]
          return false ### it's an arc
          break
        end#if
      }
    }
    ### if we get here it might be a polygon !!!
    model=Sketchup.active_model
    entities=model.active_entities
    edge=self.edges[0]
    all_connected=edge.all_connected
    tgroup=entities.add_group(all_connected)
    es=edge.start.position
    ee=edge.end.position
    group=tgroup.copy
    tgroup.explode
    gents=group.entities
    gedges=[]
    gents.each{|e|gedges<<e if e.class==Sketchup::Edge}
    gedge=nil
    gedges.each{|e|
      e.smooth=false
      e.soft=false
      gedge=e if (e.start.position==es and e.end.position==ee)or(e.start.position==ee and e.end.position==es)}
    ### remove all faces so only face and pushpull's remain
    gents.each{|e|e.erase! if e.class==Sketchup::Face}
    gedge.find_faces
    face=nil
    gents.each{|e|face=e if e.class==Sketchup::Face}
    return false if not face
    face.pushpull(1.0)
    edges=[]
    gents.each{|e|edges<<e if e.class==Sketchup::Edge}
    edges.each{|e|
      if e.smooth? and e.soft?
        group.erase! if group.valid?
        return true ### a circle
      end#if
    }
    group.erase! if group.valid?
    return false ### a polygon
  end#def
 end#if #########################
end#class
###