DefinitionBlock ("DSDT-ASUS-P7H55-M-1101.aml", "DSDT", 1, "A1577", "A1577001", 0x00000001)
{
    Name (TMAC, "P7H55-M-1101 DSDT edits by Beelzebozo at tonymacx86.com 2011-04-16")
    Method (DTGP, 5, NotSerialized)
    {
        If (LEqual (Arg0, Buffer (0x10)
                {
                    /* 0000 */    0xC6, 0xB7, 0xB5, 0xA0, 0x18, 0x13, 0x1C, 0x44, 
                    /* 0008 */    0xB0, 0xC9, 0xFE, 0x69, 0x5E, 0xAF, 0x94, 0x9B
                }))
        {
            If (LEqual (Arg1, One))
            {
                If (LEqual (Arg2, Zero))
                {
                    Store (Buffer (One)
                        {
                            0x03
                        }, Arg4)
                    Return (One)
                }
                If (LEqual (Arg2, One))
                {
                    Return (One)
                }
            }
        }
        Store (Buffer (One)
            {
                0x00
            }, Arg4)
        Return (Zero)
    }
    Scope (_PR)
    {
        Processor (P001, 0x01, 0x00000810, 0x06)
        {
        }
        Alias (P001, CPU1)
        Processor (P002, 0x02, 0x00000000, 0x00)
        {
        }
        Alias (P002, CPU2)
        Processor (P003, 0x03, 0x00000000, 0x00)
        {
        }
        Alias (P003, CPU3)
        Processor (P004, 0x04, 0x00000000, 0x00)
        {
        }
        Alias (P004, CPU4)
        Processor (P005, 0x05, 0x00000000, 0x00)
        {
        }
        Alias (P005, CPU5)
        Processor (P006, 0x06, 0x00000000, 0x00)
        {
        }
        Alias (P006, CPU6)
        Processor (P007, 0x07, 0x00000000, 0x00)
        {
        }
        Alias (P007, CPU7)
        Processor (P008, 0x08, 0x00000000, 0x00)
        {
        }
        Alias (P008, CPU8)
        Processor (P009, 0x09, 0x00000000, 0x00)
        {
        }
        Alias (P009, CPU9)
        Processor (P010, 0x0A, 0x00000000, 0x00)
        {
        }
        Processor (P011, 0x0B, 0x00000000, 0x00)
        {
        }
        Processor (P012, 0x0C, 0x00000000, 0x00)
        {
        }
        Processor (P013, 0x0D, 0x00000000, 0x00)
        {
        }
        Processor (P014, 0x0E, 0x00000000, 0x00)
        {
        }
        Processor (P015, 0x0F, 0x00000000, 0x00)
        {
        }
        Processor (P016, 0x10, 0x00000000, 0x00)
        {
        }
    }
    Name (DP80, 0x80)
    Name (DP90, 0x90)
    Name (WKTP, Zero)
    Name (SPIO, 0x2E)
    Name (IOHW, 0x0290)
    Name (IOSB, Zero)
    Name (IOSL, 0x10)
    Name (IOHB, 0x0290)
    Name (IOHL, 0x10)
    Name (PMBS, 0x0800)
    Name (PMLN, 0x80)
    Name (GPBS, 0x0500)
    Name (GPLN, 0x80)
    Name (SMBL, Zero)
    Name (PM30, 0x0830)
    Name (SUSW, 0xFF)
    Name (TPBA, 0xFED40000)
    Name (TPBL, 0x5000)
    Name (GEBS, Zero)
    Name (GELN, Zero)
    Name (APIC, One)
    Name (SMIP, 0xB2)
    Name (TOBS, 0x0860)
    Name (SUCC, One)
    Name (NVLD, 0x02)
    Name (CRIT, 0x04)
    Name (NCRT, 0x06)
    Name (LIDS, One)
    Name (CHST, 0x0C)
    Name (DVMT, 0x05)
    Name (PCIB, 0xF8000000)
    Name (PCIL, 0x04000000)
    Name (PEHP, One)
    Name (SHPC, Zero)
    Name (PEPM, One)
    Name (PEER, One)
    Name (PECS, One)
    Name (SMIT, 0xB2)
    Name (CMRQ, 0xE0)
    Name (CMER, 0xE1)
    Name (CMOR, 0xE3)
    Name (SMBS, 0x0400)
    Name (CPUC, 0x10)
    OperationRegion (BIOS, SystemMemory, 0x7B778064, 0xFF)
    Field (BIOS, ByteAcc, NoLock, Preserve)
    {
        SS1,    1, 
        SS2,    1, 
        SS3,    1, 
        SS4,    1, 
                Offset (0x01), 
        IOST,   16, 
        TOPM,   32, 
        ROMS,   32, 
        MG1B,   32, 
        MG1L,   32, 
        MG2B,   32, 
        MG2L,   32, 
                Offset (0x1C), 
        DMAX,   8, 
        HPTA,   32, 
        CPB0,   32, 
        CPB1,   32, 
        CPB2,   32, 
        CPB3,   32, 
        ASSB,   8, 
        AOTB,   8, 
        AAXB,   32, 
        SMIF,   8, 
        DTSE,   8, 
        DTS1,   8, 
        DTS2,   8, 
        MPEN,   8, 
        TPMF,   8, 
        MG3B,   32, 
        MG3L,   32, 
        MH1B,   32, 
        MH1L,   32, 
        OSTP,   8, 
        SFLG,   8
    }
    Method (RRIO, 4, NotSerialized)
    {
        Store ("RRIO", Debug)
    }
    Method (RDMA, 3, NotSerialized)
    {
        Store ("rDMA", Debug)
    }
    Name (PICM, Zero)
    Method (_PIC, 1, NotSerialized)
    {
        If (Arg0)
        {
            Store (0xAA, DBG8)
        }
        Else
        {
            Store (0xAC, DBG8)
        }
        Store (Arg0, PICM)
    }
    Name (OSVR, Ones)
    Method (OSFL, 0, NotSerialized)
    {
        If (LNotEqual (OSVR, Ones))
        {
            Return (OSVR)
        }
        Name (T_0, Zero)
        Store (OSYS (), T_0)
        If (LEqual (T_0, One))
        {
            Store (0x03, OSVR)
        }
        Else
        {
            If (LEqual (T_0, 0x10))
            {
                Store (One, OSVR)
            }
            Else
            {
                If (LEqual (T_0, 0x11))
                {
                    Store (0x02, OSVR)
                }
                Else
                {
                    If (LEqual (T_0, 0x12))
                    {
                        Store (0x04, OSVR)
                    }
                    Else
                    {
                        If (LEqual (T_0, 0x13))
                        {
                            Store (Zero, OSVR)
                        }
                        Else
                        {
                            If (LEqual (T_0, 0x14))
                            {
                                Store (Zero, OSVR)
                            }
                            Else
                            {
                                If (LEqual (T_0, 0x15))
                                {
                                    Store (Zero, OSVR)
                                }
                            }
                        }
                    }
                }
            }
        }
        Return (OSVR)
    }
    Method (MCTH, 2, NotSerialized)
    {
        If (LLess (SizeOf (Arg0), SizeOf (Arg1)))
        {
            Return (Zero)
        }
        Add (SizeOf (Arg0), One, Local0)
        Name (BUF0, Buffer (Local0) {})
        Name (BUF1, Buffer (Local0) {})
        Store (Arg0, BUF0)
        Store (Arg1, BUF1)
        While (Local0)
        {
            Decrement (Local0)
            If (LNotEqual (DerefOf (Index (BUF0, Local0)), DerefOf (Index (
                BUF1, Local0))))
            {
                Return (Zero)
            }
        }
        Return (One)
    }
    Name (PRWP, Package (0x02)
    {
        Zero, 
        Zero
    })
    Method (GPRW, 2, NotSerialized)
    {
        Store (Arg0, Index (PRWP, Zero))
        Store (ShiftLeft (SS1, One), Local0)
        Or (Local0, ShiftLeft (SS2, 0x02), Local0)
        Or (Local0, ShiftLeft (SS3, 0x03), Local0)
        Or (Local0, ShiftLeft (SS4, 0x04), Local0)
        If (And (ShiftLeft (One, Arg1), Local0))
        {
            Store (Arg1, Index (PRWP, One))
        }
        Else
        {
            ShiftRight (Local0, One, Local0)
            If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
            {
                FindSetLeftBit (Local0, Index (PRWP, One))
            }
            Else
            {
                FindSetRightBit (Local0, Index (PRWP, One))
            }
        }
        Return (PRWP)
    }
    Name (WAKP, Package (0x02)
    {
        Zero, 
        Zero
    })
    OperationRegion (DEB0, SystemIO, DP80, One)
    Field (DEB0, ByteAcc, NoLock, Preserve)
    {
        DBG8,   8
    }
    OperationRegion (DEB1, SystemIO, DP90, 0x02)
    Field (DEB1, WordAcc, NoLock, Preserve)
    {
        DBG9,   16
    }
    Method (OSYS, 0, NotSerialized)
    {
        Store (0x10, Local0)
        If (CondRefOf (_OSI, Local1))
        {
            If (_OSI ("Windows 2000"))
            {
                Store (0x12, Local0)
            }
            If (_OSI ("Windows 2001"))
            {
                Store (0x13, Local0)
            }
            If (_OSI ("Windows 2001 SP1"))
            {
                Store (0x13, Local0)
            }
            If (_OSI ("Windows 2001 SP2"))
            {
                Store (0x13, Local0)
            }
            If (_OSI ("Windows 2001.1"))
            {
                Store (0x14, Local0)
            }
            If (_OSI ("Windows 2001.1 SP1"))
            {
                Store (0x14, Local0)
            }
            If (_OSI ("Windows 2006"))
            {
                Store (0x15, Local0)
            }
        }
        Else
        {
            If (MCTH (_OS, "Microsoft Windows NT"))
            {
                Store (0x12, Local0)
            }
            Else
            {
                If (MCTH (_OS, "Microsoft WindowsME: Millennium Edition"))
                {
                    Store (0x11, Local0)
                }
                If (MCTH (_OS, "Linux"))
                {
                    Store (One, Local0)
                }
            }
        }
        Return (Local0)
    }
    Scope (_SB)
    {
        Name (PR00, Package (0x28)
        {
            Package (0x04)
            {
                0x0004FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0x0004FFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0x0004FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x0004FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0x001FFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x001DFFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 
            Package (0x04)
            {
                0x001DFFFF, 
                One, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0x001DFFFF, 
                0x02, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0x001DFFFF, 
                0x03, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x001AFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0x001AFFFF, 
                One, 
                LNKF, 
                Zero
            }, 
            Package (0x04)
            {
                0x001AFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x001AFFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0x001BFFFF, 
                Zero, 
                LNKG, 
                Zero
            }, 
            Package (0x04)
            {
                0x0016FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0x0016FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x0016FFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0x0003FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0x0003FFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0x0003FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x0003FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0x0005FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0x0005FFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0x0005FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x0005FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0x0006FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0x0006FFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0x0006FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x0006FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0x001CFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0x001CFFFF, 
                One, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0x001CFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x001CFFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0x001FFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x001FFFFF, 
                0x03, 
                LNKF, 
                Zero
            }, 
            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                LNKA, 
                Zero
            }
        })
        Name (AR00, Package (0x28)
        {
            Package (0x04)
            {
                0x0004FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0x0004FFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0x0004FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x0004FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0x001FFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x001DFFFF, 
                Zero, 
                Zero, 
                0x17
            }, 
            Package (0x04)
            {
                0x001DFFFF, 
                One, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0x001DFFFF, 
                0x02, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0x001DFFFF, 
                0x03, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x001AFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0x001AFFFF, 
                One, 
                Zero, 
                0x15
            }, 
            Package (0x04)
            {
                0x001AFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x001AFFFF, 
                0x03, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0x001BFFFF, 
                Zero, 
                Zero, 
                0x16
            }, 
            Package (0x04)
            {
                0x0016FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0x0016FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x0016FFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0x0003FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0x0003FFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0x0003FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x0003FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0x0005FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0x0005FFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0x0005FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x0005FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0x0006FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0x0006FFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0x0006FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x0006FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0x001CFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0x001CFFFF, 
                One, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0x001CFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x001CFFFF, 
                0x03, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0x001FFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x001FFFFF, 
                0x03, 
                Zero, 
                0x15
            }, 
            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                Zero, 
                0x10
            }
        })
        Name (PR01, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR01, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR03, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR03, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR05, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR05, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR06, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR06, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR20, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR20, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR21, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR21, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x10
            }
        })
        Name (PR22, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKB, 
                Zero
            }
        })
        Name (AR22, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x11
            }
        })
        Name (PR23, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKC, 
                Zero
            }
        })
        Name (AR23, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x12
            }
        })
        Name (PR24, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR24, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR25, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR25, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x10
            }
        })
        Name (PR26, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKB, 
                Zero
            }
        })
        Name (AR26, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x11
            }
        })
        Name (PR27, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKC, 
                Zero
            }
        })
        Name (AR27, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x12
            }
        })
        Name (PR1E, Package (0x08)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 
            Package (0x04)
            {
                0x0002FFFF, 
                One, 
                LNKC, 
                Zero
            }, 
            Package (0x04)
            {
                0x0002FFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 
            Package (0x04)
            {
                0x0002FFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR1E, Package (0x08)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                Zero, 
                0x11
            }, 
            Package (0x04)
            {
                0x0002FFFF, 
                One, 
                Zero, 
                0x12
            }, 
            Package (0x04)
            {
                0x0002FFFF, 
                0x02, 
                Zero, 
                0x13
            }, 
            Package (0x04)
            {
                0x0002FFFF, 
                0x03, 
                Zero, 
                0x10
            }
        })
        Name (PRSA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {3,4,6,7,10,11,12,14,15}
        })
        Name (PRSB, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {5}
        })
        Alias (PRSA, PRSC)
        Alias (PRSA, PRSD)
        Alias (PRSA, PRSE)
        Alias (PRSA, PRSF)
        Alias (PRSA, PRSG)
        Alias (PRSA, PRSH)
        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A08"))
            Name (_CID, EisaId ("PNP0A03"))
            Name (_ADR, Zero)
            Method (^BN00, 0, NotSerialized)
            {
                Return (Zero)
            }
            Method (_BBN, 0, NotSerialized)
            {
                Return (BN00 ())
            }
            Name (_UID, Zero)
            Method (_PRT, 0, NotSerialized)
            {
                If (PICM)
                {
                    Return (AR00)
                }
                Return (PR00)
            }
            Device (IOH)
            {
                Name (_HID, EisaId ("PNP0C01"))
                Name (_UID, 0x0A)
                Name (_CRS, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0xFED14000,         // Address Base
                        0x00006000,         // Address Length
                        )
                })
            }
            Method (NPTS, 1, NotSerialized)
            {
            }
            Method (NWAK, 1, NotSerialized)
            {
            }
            Device (P0P4)
            {
                Name (_ADR, 0x00040000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
            }
            Device (BR1E)
            {
                Name (_ADR, 0x001E0000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0B, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR1E)
                    }
                    Return (PR1E)
                }
            }
            Device (SBRG)
            {
                Name (_ADR, 0x001F0000)
                Device (IELK)
                {
                    Name (_HID, "AWY0001")
                    OperationRegion (RXA0, PCI_Config, 0xA0, 0x20)
                    Field (RXA0, ByteAcc, NoLock, Preserve)
                    {
                            ,   9, 
                        PBLV,   1, 
                                Offset (0x10), 
                            ,   1, 
                        PBMS,   1, 
                            ,   1, 
                        PMCS,   1, 
                        ECNS,   1, 
                                Offset (0x11), 
                        ECT1,   16, 
                        ELEN,   1, 
                                Offset (0x14)
                    }
                    Method (\_GPE._L0A, 0, NotSerialized)
                    {
                        Notify (\_SB.PCI0.SBRG.IELK, 0x81)
                        Store (One, \_SB.PCI0.SBRG.IELK.PMCS)
                    }
                    Method (_STA, 0, NotSerialized)
                    {
                        If (ELEN)
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }
                    Method (SMOD, 1, NotSerialized)
                    {
                    }
                    Method (GPBS, 0, NotSerialized)
                    {
                        Return (XOr (PBLV, One))
                    }
                }
                Method (SPTS, 1, NotSerialized)
                {
                    Store (One, PS1S)
                    Store (One, PS1E)
                    Store (One, SLPS)
                }
                Method (SWAK, 1, NotSerialized)
                {
                    Store (Zero, SLPS)
                    Store (Zero, PS1E)
                    If (LAnd (LEqual (Arg0, One), RTCS)) {}
                    Else
                    {
                        If (LAnd (LEqual (Arg0, 0x03), BRTC)) {}
                        Else
                        {
                            Notify (PWRB, 0x02)
                        }
                    }
                }
                OperationRegion (APMP, SystemIO, SMIP, 0x02)
                Field (APMP, ByteAcc, NoLock, Preserve)
                {
                    APMC,   8, 
                    APMS,   8
                }
                Field (APMP, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x01), 
                        ,   1, 
                    BRTC,   1
                }
                OperationRegion (PMS0, SystemIO, PMBS, 0x04)
                Field (PMS0, ByteAcc, NoLock, Preserve)
                {
                        ,   10, 
                    RTCS,   1, 
                        ,   4, 
                    WAKS,   1, 
                            Offset (0x03), 
                    PWBT,   1, 
                            Offset (0x04)
                }
                OperationRegion (SMIE, SystemIO, PM30, 0x08)
                Field (SMIE, ByteAcc, NoLock, Preserve)
                {
                        ,   4, 
                    PS1E,   1, 
                        ,   31, 
                    PS1S,   1, 
                            Offset (0x08)
                }
                Scope (\_SB)
                {
                    Name (SLPS, Zero)
                }
                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0020,             // Range Minimum
                            0x0020,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A0,             // Range Minimum
                            0x00A0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {2}
                    })
                }
                Device (DMAD)
                {
                    Name (_HID, EisaId ("PNP0200"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        DMA (Compatibility, BusMaster, Transfer8, )
                            {4}
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0081,             // Range Minimum
                            0x0081,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0087,             // Range Minimum
                            0x0087,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0089,             // Range Minimum
                            0x0089,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x008F,             // Range Minimum
                            0x008F,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x00C0,             // Range Minimum
                            0x00C0,             // Range Maximum
                            0x00,               // Alignment
                            0x20,               // Length
                            )
                    })
                }
                Device (TMR)
                {
                    Name (_HID, EisaId ("PNP0100"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {0}
                    })
                }
                Device (RTC0)
                {
                    Name (_HID, EisaId ("PNP0B00"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {8}
                    })
                }
                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0061,             // Range Minimum
                            0x0061,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                    })
                }
                Device (COPR)
                {
                    Name (_HID, EisaId ("PNP0C04"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x00F0,             // Range Minimum
                            0x00F0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IRQNoFlags ()
                            {13}
                    })
                }
                Device (FDC)
                {
                    Name (_HID, EisaId ("PNP0700"))
                    Method (_FDE, 0, NotSerialized)
                    {
                        Name (FDEP, Package (0x05)
                        {
                            Zero, 
                            Zero, 
                            0x02, 
                            0x02, 
                            0x02
                        })
                        If (_STA ())
                        {
                            Store (One, Index (FDEP, Zero))
                        }
                        Return (FDEP)
                    }
                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (0x03))
                    }
                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x03, Zero)
                    }
                    Method (_CRS, 0, NotSerialized)
                    {
                        DCRS (0x03, One)
                        Store (IRQM, IRQE)
                        Store (DMAM, DMAE)
                        Store (IO11, IO21)
                        Store (IO12, IO22)
                        Store (0x06, LEN2)
                        Add (IO21, 0x07, IO31)
                        Store (IO31, IO32)
                        Store (One, LEN3)
                        Return (CRS2)
                    }
                    Method (_SRS, 1, NotSerialized)
                    {
                        DSRS (Arg0, 0x03)
                        CreateWordField (Arg0, 0x11, IRQE)
                        CreateByteField (Arg0, 0x14, DMAE)
                        ENFG (CGLD (0x03))
                        If (IRQE)
                        {
                            FindSetRightBit (IRQE, Local0)
                            Subtract (Local0, One, INTR)
                        }
                        Else
                        {
                            Store (Zero, INTR)
                        }
                        If (DMAE)
                        {
                            FindSetRightBit (DMAE, Local0)
                            Subtract (Local0, One, DMCH)
                        }
                        Else
                        {
                            Store (0x04, DMCH)
                        }
                        EXFG ()
                    }
                    Name (_PRS, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x03F0,             // Range Minimum
                                0x03F0,             // Range Maximum
                                0x01,               // Alignment
                                0x06,               // Length
                                )
                            IO (Decode16,
                                0x03F7,             // Range Minimum
                                0x03F7,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                            IRQNoFlags ()
                                {6}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {2}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03F0,             // Range Minimum
                                0x03F0,             // Range Maximum
                                0x01,               // Alignment
                                0x06,               // Length
                                )
                            IO (Decode16,
                                0x03F7,             // Range Minimum
                                0x03F7,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,2,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0370,             // Range Minimum
                                0x0370,             // Range Maximum
                                0x01,               // Alignment
                                0x06,               // Length
                                )
                            IO (Decode16,
                                0x0377,             // Range Minimum
                                0x0377,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,2,3}
                        }
                        EndDependentFn ()
                    })
                }
                Device (SIOR)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Method (_UID, 0, NotSerialized)
                    {
                        Return (SPIO)
                    }
                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y00)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y01)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y02)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (LAnd (LNotEqual (SPIO, 0x03F0), LGreater (SPIO, 0xF0)))
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y00._MIN, GP10)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y00._MAX, GP11)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIOR._Y00._LEN, GPL1)
                            Store (SPIO, GP10)
                            Store (SPIO, GP11)
                            Store (0x02, GPL1)
                        }
                        If (IOSB)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y01._MIN, GP20)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y01._MAX, GP21)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIOR._Y01._LEN, GPL2)
                            Store (IOSB, GP20)
                            Store (IOSB, GP21)
                            Store (IOSL, GPL2)
                        }
                        If (IOHB)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y02._MIN, GP30)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y02._MAX, GP31)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIOR._Y02._LEN, GPL3)
                            Store (IOHB, GP30)
                            Store (IOHB, GP31)
                            Store (IOHL, GPL3)
                        }
                        Return (CRS)
                    }
                }
                Name (DCAT, Package (0x16)
                {
                    0x02, 
                    0x03, 
                    One, 
                    Zero, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0x06, 
                    0x09, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF
                })
                Method (ENFG, 1, NotSerialized)
                {
                    Store (0x87, INDX)
                    Store (0x87, INDX)
                    Store (Arg0, LDN)
                }
                Method (EXFG, 0, NotSerialized)
                {
                    Store (0xAA, INDX)
                }
                Method (LPTM, 1, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    And (OPT0, 0x02, Local0)
                    EXFG ()
                    Return (Local0)
                }
                Method (UHID, 1, NotSerialized)
                {
                    If (LEqual (Arg0, One))
                    {
                        ENFG (CGLD (Arg0))
                        And (OPT1, 0x38, Local0)
                        EXFG ()
                        If (Local0)
                        {
                            Return (0x1005D041)
                        }
                    }
                    Return (0x0105D041)
                }
                Method (SIOK, 1, NotSerialized)
                {
                    ENFG (0x0A)
                    And (0xFF, OPT3, OPT3)
                    And (Arg0, One, Local0)
                    Or (OPT2, Local0, OPT2)
                    Store (And (Arg0, One), ACTR)
                    EXFG ()
                }
                Name (KBFG, One)
                Name (MSFG, One)
                Name (U1FG, One)
                Name (U2FG, One)
                OperationRegion (KBRW, SystemIO, 0x60, 0x05)
                Field (KBRW, ByteAcc, NoLock, Preserve)
                {
                    KP60,   8, 
                            Offset (0x04), 
                    KP64,   8
                }
                OperationRegion (KB64, SystemIO, 0x64, One)
                Field (KB64, ByteAcc, NoLock, Preserve)
                {
                        ,   1, 
                    KRDY,   1, 
                            Offset (0x01)
                }
                Method (SIOS, 1, NotSerialized)
                {
                    Store ("SIOS", Debug)
                    And (CRE0, 0x1F, CRE0)
                    If (LEqual (Arg0, One))
                    {
                        SIOK (Ones)
                        ENFG (0x0A)
                        If (KBFG)
                        {
                            Or (OPT6, 0x10, OPT6)
                        }
                        If (MSFG)
                        {
                            Or (OPT6, 0x20, OPT6)
                        }
                        EXFG ()
                    }
                    If (LOr (LEqual (Arg0, 0x03), LEqual (Arg0, 0x04)))
                    {
                        If (WKTP)
                        {
                            SIOK (Ones)
                            ENFG (0x0A)
                            If (KBFG)
                            {
                                Or (OPT6, 0x10, OPT6)
                            }
                            If (MSFG)
                            {
                                Or (OPT6, 0x20, OPT6)
                            }
                            EXFG ()
                        }
                        Else
                        {
                            ENFG (0x0A)
                            If (KBFG)
                            {
                                Or (CRE0, 0x41, CRE0)
                            }
                            If (MSFG)
                            {
                                Or (CRE0, 0x22, CRE0)
                                Or (CRE6, 0x80, CRE6)
                            }
                            EXFG ()
                        }
                    }
                }
                Method (SIOW, 1, NotSerialized)
                {
                    Store ("SIOW", Debug)
                    SIOK (Zero)
                    ENFG (0x0A)
                    And (OPT6, 0xCF, OPT6)
                    And (OPT2, 0xFE, OPT2)
                    And (CRE0, 0x1D, CRE0)
                    And (CRE6, 0x7F, CRE6)
                    EXFG ()
                }
                Method (SIOH, 0, NotSerialized)
                {
                    Store ("SIOH", Debug)
                    ENFG (0x0A)
                    If (And (OPT3, 0x10))
                    {
                        Notify (PS2K, 0x02)
                    }
                    If (And (OPT3, 0x20))
                    {
                        Notify (PS2M, 0x02)
                    }
                    SIOK (Zero)
                }
                OperationRegion (IOID, SystemIO, SPIO, 0x02)
                Field (IOID, ByteAcc, NoLock, Preserve)
                {
                    INDX,   8, 
                    DATA,   8
                }
                IndexField (INDX, DATA, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x07), 
                    LDN,    8, 
                            Offset (0x20), 
                    CR20,   8, 
                            Offset (0x22), 
                    FDCP,   1, 
                        ,   2, 
                    LPTP,   1, 
                    URAP,   1, 
                    URBP,   1, 
                            Offset (0x2C), 
                    CR2C,   8, 
                            Offset (0x30), 
                    ACTR,   8, 
                            Offset (0x60), 
                    IOAH,   8, 
                    IOAL,   8, 
                    IOH2,   8, 
                    IOL2,   8, 
                            Offset (0x70), 
                    INTR,   8, 
                            Offset (0x74), 
                    DMCH,   8, 
                            Offset (0xE0), 
                    CRE0,   8, 
                    CRE1,   8, 
                    CRE2,   8, 
                    CRE3,   8, 
                    CRE4,   8, 
                    CRE5,   8, 
                    CRE6,   8, 
                    CRE7,   8, 
                    CRE8,   8, 
                    CRE9,   8, 
                    CREA,   8, 
                    CREB,   8, 
                    CREC,   8, 
                            Offset (0xF0), 
                    OPT0,   8, 
                    OPT1,   8, 
                    OPT2,   8, 
                    OPT3,   8, 
                    OPT4,   8, 
                    OPT5,   8, 
                    OPT6,   8
                }
                Method (CGLD, 1, NotSerialized)
                {
                    Return (DerefOf (Index (DCAT, Arg0)))
                }
                Method (DSTA, 1, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    Store (ACTR, Local0)
                    EXFG ()
                    If (LEqual (Local0, 0xFF))
                    {
                        Return (Zero)
                    }
                    And (Local0, One, Local0)
                    Or (IOST, ShiftLeft (Local0, Arg0), IOST)
                    If (Local0)
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        If (And (ShiftLeft (One, Arg0), IOST))
                        {
                            Return (0x0D)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }
                }
                Method (DCNT, 2, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    ShiftLeft (IOAH, 0x08, Local1)
                    Or (IOAL, Local1, Local1)
                    If (LAnd (LLess (DMCH, 0x04), LNotEqual (And (DMCH, 0x03, 
                        Local1), Zero)))
                    {
                        RDMA (Arg0, Arg1, Increment (Local1))
                    }
                    Store (Arg1, ACTR)
                    RRIO (Arg0, Arg1, Local1, 0x08)
                    EXFG ()
                }
                Name (CRS1, ResourceTemplate ()
                {
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x00,               // Length
                        _Y05)
                    IRQNoFlags (_Y03)
                        {}
                    DMA (Compatibility, NotBusMaster, Transfer8, _Y04)
                        {}
                })
                CreateWordField (CRS1, \_SB.PCI0.SBRG._Y03._INT, IRQM)
                CreateByteField (CRS1, \_SB.PCI0.SBRG._Y04._DMA, DMAM)
                CreateWordField (CRS1, \_SB.PCI0.SBRG._Y05._MIN, IO11)
                CreateWordField (CRS1, \_SB.PCI0.SBRG._Y05._MAX, IO12)
                CreateByteField (CRS1, \_SB.PCI0.SBRG._Y05._LEN, LEN1)
                Name (CRS2, ResourceTemplate ()
                {
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x00,               // Length
                        _Y08)
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x00,               // Length
                        _Y09)
                    IRQNoFlags (_Y06)
                        {6}
                    DMA (Compatibility, NotBusMaster, Transfer8, _Y07)
                        {2}
                })
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y06._INT, IRQE)
                CreateByteField (CRS2, \_SB.PCI0.SBRG._Y07._DMA, DMAE)
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y08._MIN, IO21)
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y08._MAX, IO22)
                CreateByteField (CRS2, \_SB.PCI0.SBRG._Y08._LEN, LEN2)
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y09._MIN, IO31)
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y09._MAX, IO32)
                CreateByteField (CRS2, \_SB.PCI0.SBRG._Y09._LEN, LEN3)
                Method (DCRS, 2, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    ShiftLeft (IOAH, 0x08, IO11)
                    Or (IOAL, IO11, IO11)
                    Store (IO11, IO12)
                    Subtract (FindSetRightBit (IO11), One, Local0)
                    ShiftLeft (One, Local0, LEN1)
                    If (INTR)
                    {
                        ShiftLeft (One, INTR, IRQM)
                    }
                    Else
                    {
                        Store (Zero, IRQM)
                    }
                    If (LOr (LGreater (DMCH, 0x03), LEqual (Arg1, Zero)))
                    {
                        Store (Zero, DMAM)
                    }
                    Else
                    {
                        And (DMCH, 0x03, Local1)
                        ShiftLeft (One, Local1, DMAM)
                    }
                    EXFG ()
                    Return (CRS1)
                }
                Method (DSRS, 2, NotSerialized)
                {
                    CreateWordField (Arg0, 0x09, IRQM)
                    CreateByteField (Arg0, 0x0C, DMAM)
                    CreateWordField (Arg0, 0x02, IO11)
                    ENFG (CGLD (Arg1))
                    ShiftLeft (IOAH, 0x08, Local1)
                    Or (IOAL, Local1, Local1)
                    RRIO (Arg1, Zero, Local1, 0x08)
                    RRIO (Arg1, One, IO11, 0x08)
                    And (IO11, 0xFF, IOAL)
                    ShiftRight (IO11, 0x08, IOAH)
                    If (IRQM)
                    {
                        FindSetRightBit (IRQM, Local0)
                        Subtract (Local0, One, INTR)
                    }
                    Else
                    {
                        Store (Zero, INTR)
                    }
                    If (DMAM)
                    {
                        FindSetRightBit (DMAM, Local0)
                        Subtract (Local0, One, DMCH)
                    }
                    Else
                    {
                        Store (0x04, DMCH)
                    }
                    EXFG ()
                    DCNT (Arg1, One)
                }
                Device (RMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x10)
                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0010,             // Range Minimum
                            0x0010,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0022,             // Range Minimum
                            0x0022,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x0044,             // Range Minimum
                            0x0044,             // Range Maximum
                            0x00,               // Alignment
                            0x0A,               // Length
                            )
                        IO (Decode16,
                            0x0050,             // Range Minimum
                            0x0050,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0062,             // Range Minimum
                            0x0062,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0065,             // Range Minimum
                            0x0065,             // Range Maximum
                            0x00,               // Alignment
                            0x0B,               // Length
                            )
                        IO (Decode16,
                            0x0072,             // Range Minimum
                            0x0072,             // Range Maximum
                            0x00,               // Alignment
                            0x0E,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0084,             // Range Minimum
                            0x0084,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0088,             // Range Minimum
                            0x0088,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x008C,             // Range Minimum
                            0x008C,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0090,             // Range Minimum
                            0x0090,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x00A2,             // Range Minimum
                            0x00A2,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x00E0,             // Range Minimum
                            0x00E0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y0A)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y0B)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y0C)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y0D)
                        Memory32Fixed (ReadWrite,
                            0xFED1C000,         // Address Base
                            0x00004000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0E)
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0F)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0A._MIN, GP00)
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0A._MAX, GP01)
                        CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y0A._LEN, GP0L)
                        Store (PMBS, GP00)
                        Store (PMBS, GP01)
                        Store (PMLN, GP0L)
                        If (SMBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0B._MIN, GP10)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0B._MAX, GP11)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y0B._LEN, GP1L)
                            Store (SMBS, GP10)
                            Store (SMBS, GP11)
                            Store (SMBL, GP1L)
                        }
                        If (GPBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0C._MIN, GP20)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0C._MAX, GP21)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y0C._LEN, GP2L)
                            Store (GPBS, GP20)
                            Store (GPBS, GP21)
                            Store (GPLN, GP2L)
                        }
                        If (GEBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0D._MIN, GP30)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0D._MAX, GP31)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y0D._LEN, GP3L)
                            Store (GEBS, GP30)
                            Store (GEBS, GP31)
                            Store (GELN, GP3L)
                        }
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0E._LEN, TML1)
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0E._BAS, TMB1)
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0F._LEN, TML2)
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0F._BAS, TMB2)
                        Store (0xFED20000, TMB1)
                        Subtract (TPBA, 0xFED20000, TML1)
                        If (TPMF)
                        {
                            Add (TPBA, TPBL, TMB2)
                        }
                        Else
                        {
                            Add (TPBA, Zero, TMB2)
                        }
                        Subtract (0xFED90000, TMB2, TML2)
                        Return (CRS)
                    }
                }
                Scope (\)
                {
                    OperationRegion (RAMW, SystemMemory, 0x7B7DC000, 0x00010000)
                    Field (RAMW, ByteAcc, NoLock, Preserve)
                    {
                        PAR0,   32, 
                        PAR1,   32, 
                        PAR2,   32
                    }
                    OperationRegion (IOB2, SystemIO, 0xB2, 0x02)
                    Field (IOB2, ByteAcc, NoLock, Preserve)
                    {
                        SMIC,   8, 
                        SMIS,   8
                    }
                    Method (ISMI, 1, Serialized)
                    {
                        Store (Arg0, SMIC)
                    }
                    Method (GNVS, 1, Serialized)
                    {
                        Store (Arg0, PAR0)
                        ISMI (0x70)
                        Return (PAR1)
                    }
                    Method (SNVS, 2, Serialized)
                    {
                        Store (Arg0, PAR0)
                        Store (Arg1, PAR1)
                        ISMI (0x71)
                    }
                    Method (SMSR, 3, Serialized)
                    {
                        Store (Arg0, PAR0)
                        Store (Arg1, PAR1)
                        Store (Arg2, PAR2)
                        ISMI (0x79)
                    }
                    Method (GMAX, 1, Serialized)
                    {
                        Store (Arg0, PAR0)
                        ISMI (0x7A)
                        Return (PAR1)
                    }
                    Method (GMDX, 1, Serialized)
                    {
                        Store (Arg0, PAR0)
                        ISMI (0x7B)
                        Return (PAR1)
                    }
                    Method (GCAX, 1, Serialized)
                    {
                        Store (Arg0, PAR0)
                        ISMI (0x7C)
                        Return (PAR1)
                    }
                    Method (GCDX, 1, Serialized)
                    {
                        Store (Arg0, PAR0)
                        ISMI (0x7D)
                        Return (PAR1)
                    }
                }
                Scope (\_SB.PCI0.SBRG)
                {
                    Device (ASOC)
                    {
                        Name (_HID, "ATK0110")
                        Name (_UID, 0x01010110)
                        Method (_STA, 0, NotSerialized)
                        {
                            Return (0x0F)
                        }
                        Method (_INI, 0, NotSerialized)
                        {
                            CUPI ()
                            UMVT ()
                            UVCR ()
                            If (LEqual (ShiftRight (DerefOf (Index (MBIF, 0x02)), 0x18), 
                                0x04))
                            {
                                SFST ()
                            }
                        }
                        Method (CUPI, 0, NotSerialized)
                        {
                            Store (GNVS (0x82A0), Local1)
                            Store (Local1, Index (G3C5, 0x03))
                            If (And (XOr (ShiftRight (GMDX (0x01A0), 0x06), One), 
                                And (ShiftRight (GMAX (0xCE), 0x1C), One)))
                            {
                                Store (Local1, Index (G3C2, 0x04))
                                Store (0x40, Local0)
                                Subtract (Local0, Local1, Index (G3C2, 0x06))
                                Subtract (GNVS (0x82A0), Local1, Index (G3C2, 0x03))
                                If (LNotEqual (GPRE (0x003F1800), Ones))
                                {
                                    Store (0x04, Index (G3DS, 0x06))
                                }
                                Else
                                {
                                    Store (0x02, Index (G3DS, 0x06))
                                }
                                ShiftRight (GNVS (0x8290), One, Local0)
                                If (LEqual (Local0, Zero))
                                {
                                    Store (GNVS (0x82A0), Local0)
                                }
                                If (LNotEqual (GPRE (0x003F1800), Ones))
                                {
                                    Store (GNVS (0x42BC), Local1)
                                }
                                Else
                                {
                                    Store (GNVS (0x42B4), Local1)
                                }
                                Add (Local0, Local1, Local2)
                                If (LGreaterEqual (Local2, GNVS (0x82A0)))
                                {
                                    Store (Zero, Index (G3C2, 0x02))
                                }
                            }
                            Else
                            {
                                Store (D4CR, Index (G3C2, 0x03))
                            }
                            If (LEqual (GPRE (0x003F1800), Ones))
                            {
                                If (LNotEqual (GPRE (0x1000), Ones))
                                {
                                    Store (Zero, Index (G3P0, 0x02))
                                    Store (Zero, Index (G3P1, 0x02))
                                    Subtract (And (GPRE (0x104C), 0x3F), 0x04, Local0)
                                    Store (IMOD (Local0), Index (G3P0, 0x03))
                                }
                            }
                        }
                        Method (UMVT, 0, NotSerialized)
                        {
                            Store (VIDI, Index (G3C1, 0x03))
                        }
                        Method (SFST, 0, NotSerialized)
                        {
                            If (LNotEqual (GNVS (0x174E), Zero))
                            {
                                Name (T_0, Zero)
                                Store (GNVS (0x3505), T_0)
                                If (LEqual (T_0, Zero))
                                {
                                    Store (0x01F4, Index (G613, 0x03))
                                }
                                Else
                                {
                                    If (LEqual (T_0, One))
                                    {
                                        Store (0x0190, Index (G613, 0x03))
                                    }
                                    Else
                                    {
                                        If (LEqual (T_0, 0x02))
                                        {
                                            Store (0x012C, Index (G613, 0x03))
                                        }
                                        Else
                                        {
                                            If (LEqual (T_0, 0x03))
                                            {
                                                Store (0xC8, Index (G613, 0x03))
                                            }
                                            Else
                                            {
                                                If (LEqual (T_0, 0x04))
                                                {
                                                    Store (0x64, Index (G613, 0x03))
                                                }
                                                Else
                                                {
                                                    If (LEqual (T_0, 0x05))
                                                    {
                                                        Store (Zero, Index (G613, 0x03))
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            Else
                            {
                                Store (0xC8, Index (G613, 0x03))
                            }
                            If (LNotEqual (GNVS (0x1750), Zero))
                            {
                                Name (T_1, Zero)
                                Store (GNVS (0x350D), T_1)
                                If (LEqual (T_1, Zero))
                                {
                                    Store (0x01F4, Index (G673, 0x03))
                                }
                                Else
                                {
                                    If (LEqual (T_1, One))
                                    {
                                        Store (0x0190, Index (G673, 0x03))
                                    }
                                    Else
                                    {
                                        If (LEqual (T_1, 0x02))
                                        {
                                            Store (0x012C, Index (G673, 0x03))
                                        }
                                        Else
                                        {
                                            If (LEqual (T_1, 0x03))
                                            {
                                                Store (0xC8, Index (G673, 0x03))
                                            }
                                            Else
                                            {
                                                If (LEqual (T_1, 0x04))
                                                {
                                                    Store (0x64, Index (G673, 0x03))
                                                }
                                                Else
                                                {
                                                    If (LEqual (T_1, 0x05))
                                                    {
                                                        Store (Zero, Index (G673, 0x03))
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            Else
                            {
                                Store (0xC8, Index (G673, 0x03))
                            }
                        }
                        Method (UVCR, 0, NotSerialized)
                        {
                            Store (VIDI, RVCR)
                            ENFG (0x0D)
                            Store (And (CRE4, 0xC0), Local0)
                            EXFG ()
                            If (LEqual (Local0, 0x40))
                            {
                                If (LEqual (GNVS (0x176E), Zero))
                                {
                                    Add (GNVS (0x8358), RVCR, RVCR)
                                }
                                Else
                                {
                                    Subtract (RVCR, GNVS (0x8358), RVCR)
                                }
                            }
                            Else
                            {
                                If (LEqual (Local0, 0x80))
                                {
                                    Store (GNVS (0x8350), Local1)
                                    If (LNotEqual (Local1, Zero))
                                    {
                                        Decrement (Local1)
                                    }
                                    Store (Local1, RVCR)
                                }
                            }
                        }
                        Name (MBIF, Package (0x08)
                        {
                            0x03, 
                            "P7H55-M", 
                            0x04010203, 
                            0x03000100, 
                            0xE0000000, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (ASBF, Buffer (0x0200) {})
                        CreateDWordField (ASBF, Zero, ASB0)
                        CreateDWordField (ASBF, 0x04, ASB1)
                        CreateDWordField (ASBF, 0x08, ASB2)
                        Method (GGRP, 1, Serialized)
                        {
                            Name (T_0, Zero)
                            Store (Arg0, T_0)
                            If (LEqual (T_0, Zero))
                            {
                                Return (GRP0)
                            }
                            Else
                            {
                                If (LEqual (T_0, 0x03))
                                {
                                    Return (GRP3)
                                }
                                Else
                                {
                                    If (LEqual (T_0, 0x04))
                                    {
                                        Return (GRP4)
                                    }
                                    Else
                                    {
                                        If (LEqual (T_0, 0x05))
                                        {
                                            Return (GRP5)
                                        }
                                        Else
                                        {
                                            If (LEqual (T_0, 0x06))
                                            {
                                                Return (GRP6)
                                            }
                                            Else
                                            {
                                                If (LEqual (T_0, 0x09))
                                                {
                                                    Return (GRP9)
                                                }
                                                Else
                                                {
                                                    If (LEqual (T_0, 0x0B))
                                                    {
                                                        Return (GRPB)
                                                    }
                                                    Else
                                                    {
                                                        If (LEqual (T_0, 0x0E))
                                                        {
                                                            Return (GRPE)
                                                        }
                                                        Else
                                                        {
                                                            Return (Zero)
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        Method (GITM, 1, Serialized)
                        {
                            CreateDWordField (Arg0, Zero, PRM0)
                            CreateByteField (Arg0, 0x03, GPID)
                            Store (One, ASB0)
                            Name (T_0, Zero)
                            Store (GPID, T_0)
                            If (LEqual (T_0, Zero))
                            {
                                GIT0 (PRM0)
                            }
                            Else
                            {
                                If (LEqual (T_0, 0x03))
                                {
                                    GIT3 (PRM0)
                                }
                                Else
                                {
                                    If (LEqual (T_0, 0x04))
                                    {
                                        GIT4 (PRM0)
                                    }
                                    Else
                                    {
                                        If (LEqual (T_0, 0x05))
                                        {
                                            CreateDWordField (Arg0, 0x04, PRM1)
                                            GIT5 (PRM0, PRM1)
                                        }
                                        Else
                                        {
                                            If (LEqual (T_0, 0x06))
                                            {
                                                GIT6 (PRM0)
                                            }
                                            Else
                                            {
                                                If (LEqual (T_0, 0x09))
                                                {
                                                    GIT9 (PRM0)
                                                }
                                                Else
                                                {
                                                    If (LEqual (T_0, 0x0B))
                                                    {
                                                        GITB (PRM0)
                                                    }
                                                    Else
                                                    {
                                                        If (LEqual (T_0, 0x0E))
                                                        {
                                                            GITE (PRM0)
                                                        }
                                                        Else
                                                        {
                                                            Store (Zero, ASB0)
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            Return (ASBF)
                        }
                        Method (SITM, 1, Serialized)
                        {
                            CreateDWordField (Arg0, Zero, PRM0)
                            CreateDWordField (Arg0, 0x04, PRM1)
                            CreateDWordField (Arg0, 0x08, PRM2)
                            CreateByteField (Arg0, 0x03, GPID)
                            Store (One, ASB0)
                            Name (T_0, Zero)
                            Store (GPID, T_0)
                            If (LEqual (T_0, Zero))
                            {
                                SIT0 (PRM0, PRM1, PRM2)
                            }
                            Else
                            {
                                If (LEqual (T_0, 0x03))
                                {
                                    SIT3 (PRM0, PRM1, PRM2)
                                }
                                Else
                                {
                                    If (LEqual (T_0, 0x04))
                                    {
                                        SIT4 (PRM0, PRM1, PRM2)
                                    }
                                    Else
                                    {
                                        If (LEqual (T_0, 0x05))
                                        {
                                            SIT5 (PRM0, PRM1, PRM2)
                                        }
                                        Else
                                        {
                                            If (LEqual (T_0, 0x06))
                                            {
                                                SIT6 (PRM0, PRM1, PRM2)
                                            }
                                            Else
                                            {
                                                If (LEqual (T_0, 0x09))
                                                {
                                                    SIT9 (PRM0, PRM1, PRM2)
                                                }
                                                Else
                                                {
                                                    If (LEqual (T_0, 0x0B))
                                                    {
                                                        SITB (PRM0, PRM1, PRM2)
                                                    }
                                                    Else
                                                    {
                                                        If (LEqual (T_0, 0x0E))
                                                        {
                                                            SITE (PRM0, PRM1, PRM2)
                                                        }
                                                        Else
                                                        {
                                                            Store (Zero, ASB0)
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            Return (ASBF)
                        }
                        Method (OP2V, 2, NotSerialized)
                        {
                            Store (DerefOf (Index (Arg1, 0x04)), Local0)
                            Store (DerefOf (Index (Arg1, 0x05)), Local1)
                            Multiply (Arg0, Local1, Local1)
                            Add (Local0, Local1, Local0)
                            Return (Local0)
                        }
                        Method (V2OP, 2, NotSerialized)
                        {
                            Store (DerefOf (Index (Arg1, 0x04)), Local0)
                            Store (DerefOf (Index (Arg1, 0x05)), Local1)
                            Subtract (Arg0, Local0, Local0)
                            Divide (Local0, Local1, Local1, Local0)
                            Return (Local0)
                        }
                    }
                }
                Device (HPET)
                {
                    Name (_HID, EisaId ("PNP0103"))
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0xFED00000,         // Address Base
                            0x00000400,         // Address Length
                            _Y10)
                    })
                    OperationRegion (^LPCR, SystemMemory, 0xFED1F404, 0x04)
                    Field (LPCR, AnyAcc, NoLock, Preserve)
                    {
                        HPTS,   2, 
                            ,   5, 
                        HPTE,   1, 
                                Offset (0x04)
                    }
                    Method (_STA, 0, NotSerialized)
                    {
                        If (LEqual (OSFL (), Zero))
                        {
                            If (HPTE)
                            {
                                Return (0x0F)
                            }
                        }
                        Else
                        {
                            If (HPTE)
                            {
                                Return (0x0B)
                            }
                        }
                        Return (Zero)
                    }
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.HPET._Y10._BAS, HPT)
                        Multiply (HPTS, 0x1000, Local0)
                        Add (Local0, 0xFED00000, HPT)
                        Return (CRS)
                    }
                }
                OperationRegion (RX80, PCI_Config, Zero, 0xFF)
                Field (RX80, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x80), 
                    LPCD,   16, 
                    LPCE,   16
                }
                Name (DBPT, Package (0x04)
                {
                    Package (0x08)
                    {
                        0x03F8, 
                        0x02F8, 
                        0x0220, 
                        0x0228, 
                        0x0238, 
                        0x02E8, 
                        0x0338, 
                        0x03E8
                    }, 
                    Package (0x08)
                    {
                        0x03F8, 
                        0x02F8, 
                        0x0220, 
                        0x0228, 
                        0x0238, 
                        0x02E8, 
                        0x0338, 
                        0x03E8
                    }, 
                    Package (0x03)
                    {
                        0x0378, 
                        0x0278, 
                        0x03BC
                    }, 
                    Package (0x02)
                    {
                        0x03F0, 
                        0x0370
                    }
                })
                Name (DDLT, Package (0x04)
                {
                    Package (0x02)
                    {
                        Zero, 
                        0xFFF8
                    }, 
                    Package (0x02)
                    {
                        0x04, 
                        0xFF8F
                    }, 
                    Package (0x02)
                    {
                        0x08, 
                        0xFCFF
                    }, 
                    Package (0x02)
                    {
                        0x0C, 
                        0xEFFF
                    }
                })
                Method (RRIO, 4, NotSerialized)
                {
                    If (LAnd (LLessEqual (Arg0, 0x03), LGreaterEqual (Arg0, Zero)))
                    {
                        Store (Match (DerefOf (Index (DBPT, Arg0)), MEQ, Arg2, MTR, 
                            Zero, Zero), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            Store (DerefOf (Index (DerefOf (Index (DDLT, Arg0)), Zero)), 
                                Local1)
                            Store (DerefOf (Index (DerefOf (Index (DDLT, Arg0)), One)), 
                                Local2)
                            ShiftLeft (Local0, Local1, Local0)
                            And (LPCD, Local2, LPCD)
                            Or (LPCD, Local0, LPCD)
                            WX82 (Arg0, Arg1)
                        }
                    }
                    If (LEqual (Arg0, 0x08))
                    {
                        If (LEqual (Arg2, 0x0200))
                        {
                            WX82 (0x08, Arg0)
                        }
                        Else
                        {
                            If (LEqual (Arg2, 0x0208))
                            {
                                WX82 (0x09, Arg0)
                            }
                        }
                    }
                    If (LAnd (LLessEqual (Arg0, 0x0D), LGreaterEqual (Arg0, 0x0A)))
                    {
                        WX82 (Arg0, Arg1)
                    }
                }
                Method (WX82, 2, NotSerialized)
                {
                    ShiftLeft (One, Arg0, Local0)
                    If (Arg1)
                    {
                        Or (LPCE, Local0, LPCE)
                    }
                    Else
                    {
                        Not (Local0, Local0)
                        And (LPCE, Local0, LPCE)
                    }
                }
                Method (RDMA, 3, NotSerialized)
                {
                }
                Device (^PCIE)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x11)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0xF8000000,         // Address Base
                            0x04000000,         // Address Length
                            _Y11)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.PCI0.PCIE._Y11._BAS, BAS1)
                        CreateDWordField (CRS, \_SB.PCI0.PCIE._Y11._LEN, LEN1)
                        Store (PCIB, BAS1)
                        Store (PCIL, LEN1)
                        Return (CRS)
                    }
                }
                Scope (\_GPE)
                {
                    Method (_L1D, 0, NotSerialized)
                    {
                        Notify (\_SB.PCI0.SBRG.ASOC, One)
                        Sleep (0x03E8)
                    }
                }
                Scope (ASOC)
                {
                    Name (VESL, Zero)
                    Method (SPLV, 1, Serialized)
                    {
                        And (Arg0, 0xFFFF, VESL)
                        Store (VESL, PAR0)
                        ISMI (0x88)
                        Store (And (PAR0, 0xFFFF), Local0)
                        Return (Local0)
                    }
                    Method (GPLV, 0, Serialized)
                    {
                        Return (VESL)
                    }
                }
                Device (UAR1)
                {
                    Name (_UID, One)
                    Name (_HID, EisaId ("PNP0501"))
                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (Zero))
                    }
                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (Zero, Zero)
                    }
                    Method (_CRS, 0, NotSerialized)
                    {
                        Return (DCRS (Zero, Zero))
                    }
                    Method (_SRS, 1, NotSerialized)
                    {
                        DSRS (Arg0, Zero)
                    }
                    Method (_PRS, 0, NotSerialized)
                    {
                        Return (CMPR)
                    }
                    Name (CMPR, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02F8,             // Range Minimum
                                0x02F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03E8,             // Range Minimum
                                0x03E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02E8,             // Range Minimum
                                0x02E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        EndDependentFn ()
                    })
                }
                Method (UAR1._PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x08, 0x04))
                }
                Device (OMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, Zero)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y12)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y13)
                    })
                    Name (CRS1, ResourceTemplate ()
                    {
                        FixedIO (
                            0x0060,             // Address
                            0x01,               // Length
                            )
                        FixedIO (
                            0x0064,             // Address
                            0x01,               // Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y14)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y15)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (APIC)
                        {
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y12._LEN, ML01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y12._BAS, MB01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y13._LEN, ML02)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y13._BAS, MB02)
                            Store (0xFEC00000, MB01)
                            Store (0x1000, ML01)
                            Store (0xFEE00000, MB02)
                            Store (0x1000, ML02)
                            CreateDWordField (CRS1, \_SB.PCI0.SBRG.OMSC._Y14._LEN, ML03)
                            CreateDWordField (CRS1, \_SB.PCI0.SBRG.OMSC._Y14._BAS, MB03)
                            CreateDWordField (CRS1, \_SB.PCI0.SBRG.OMSC._Y15._LEN, ML04)
                            CreateDWordField (CRS1, \_SB.PCI0.SBRG.OMSC._Y15._BAS, MB04)
                            Store (0xFEC00000, MB03)
                            Store (0x1000, ML03)
                            Store (0xFEE00000, MB04)
                            Store (0x1000, ML04)
                        }
                        ShiftLeft (0x05, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (CRS)
                        }
                        Else
                        {
                            Return (CRS1)
                        }
                    }
                }
                Device (^^RMEM)
                {
                    Name (_HID, EisaId ("PNP0C01"))
                    Name (_UID, One)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x000A0000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y16)
                        Memory32Fixed (ReadOnly,
                            0x000E0000,         // Address Base
                            0x00020000,         // Address Length
                            _Y17)
                        Memory32Fixed (ReadWrite,
                            0x00100000,         // Address Base
                            0x00000000,         // Address Length
                            _Y18)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y19)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.RMEM._Y16._BAS, BAS1)
                        CreateDWordField (CRS, \_SB.RMEM._Y16._LEN, LEN1)
                        CreateDWordField (CRS, \_SB.RMEM._Y17._BAS, BAS2)
                        CreateDWordField (CRS, \_SB.RMEM._Y17._LEN, LEN2)
                        CreateDWordField (CRS, \_SB.RMEM._Y18._LEN, LEN3)
                        CreateDWordField (CRS, \_SB.RMEM._Y19._BAS, BAS4)
                        CreateDWordField (CRS, \_SB.RMEM._Y19._LEN, LEN4)
                        If (OSFL ()) {}
                        Else
                        {
                            If (MG1B)
                            {
                                If (LGreater (MG1B, 0x000C0000))
                                {
                                    Store (0x000C0000, BAS1)
                                    Subtract (MG1B, BAS1, LEN1)
                                }
                            }
                            Else
                            {
                                Store (0x000C0000, BAS1)
                                Store (0x00020000, LEN1)
                            }
                            If (Add (MG1B, MG1L, Local0))
                            {
                                Store (Local0, BAS2)
                                Subtract (0x00100000, BAS2, LEN2)
                            }
                        }
                        Subtract (MG2B, 0x00100000, LEN3)
                        Store (MH1B, BAS4)
                        Subtract (Zero, BAS4, LEN4)
                        Return (CRS)
                    }
                }
                Device (PS2K)
                {
                    Name (_HID, EisaId ("PNP0303"))
                    Name (_CID, EisaId ("PNP030B"))
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }
                        Return (Zero)
                    }
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {1}
                    })
                }
                Method (PS2K._PSW, 1, NotSerialized)
                {
                    If (LNot (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02))))
                    {
                        Store (Arg0, KBFG)
                    }
                }
                Method (PS2K._PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x1B, 0x04))
                }
                Device (LPTE)
                {
                    Method (_HID, 0, NotSerialized)
                    {
                        If (LPTM (0x02))
                        {
                            Return (0x0104D041)
                        }
                        Else
                        {
                            Return (0x0004D041)
                        }
                    }
                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (0x02))
                    }
                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x02, Zero)
                    }
                    Method (_CRS, 0, NotSerialized)
                    {
                        DCRS (0x02, One)
                        If (LPTM (0x02))
                        {
                            Store (IRQM, IRQE)
                            Store (DMAM, DMAE)
                            Store (IO11, IO21)
                            Store (IO12, IO22)
                            Store (LEN1, LEN2)
                            Add (IO21, 0x0400, IO31)
                            Store (IO31, IO32)
                            Store (LEN2, LEN3)
                            Return (CRS2)
                        }
                        Else
                        {
                            Return (CRS1)
                        }
                    }
                    Method (_SRS, 1, NotSerialized)
                    {
                        DSRS (Arg0, 0x02)
                    }
                    Method (_PRS, 0, NotSerialized)
                    {
                        If (LPTM (0x02))
                        {
                            Return (EPPR)
                        }
                        Else
                        {
                            Return (LPPR)
                        }
                    }
                    Name (LPPR, ResourceTemplate ()
                    {
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        EndDependentFn ()
                    })
                    Name (EPPR, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0778,             // Range Minimum
                                0x0778,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {7}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0778,             // Range Minimum
                                0x0778,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,2,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0678,             // Range Minimum
                                0x0678,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,2,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IO (Decode16,
                                0x07BC,             // Range Minimum
                                0x07BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,2,3}
                        }
                        EndDependentFn ()
                    })
                }
                Device (PS2M)
                {
                    Name (_HID, EisaId ("PNP0F03"))
                    Name (_CID, EisaId ("PNP0F13"))
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0C, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }
                        Return (Zero)
                    }
                    Name (M2R0, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {12}
                    })
                    Name (M2R1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {12}
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (M2R0)
                        }
                        Else
                        {
                            Return (M2R1)
                        }
                    }
                }
                Method (PS2M._PSW, 1, NotSerialized)
                {
                    If (LNot (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02))))
                    {
                        Store (Arg0, MSFG)
                    }
                }
                Method (PS2M._PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x1C, 0x04))
                }
            }
            Device (EUSB)
            {
                Name (_ADR, 0x001D0000)
                Device (RHUB)
                {
                    Name (_ADR, Zero)
                    Device (PRT1)
                    {
                        Name (_ADR, One)
                        Name (_UPC, Package (0x04)
                        {
                            0xFF, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Package (0x10)
                        {
                            0x81, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            0x30, 
                            0x1C, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                    }
                }
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0D, 0x04))
                }
            }
            Device (USB0)
            {
                Name (_ADR, 0x001D0001)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }
                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }
                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x03, 0x04))
                }
            }
            Device (USB1)
            {
                Name (_ADR, 0x001D0002)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }
                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }
                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x04, 0x04))
                }
            }
            Device (USB2)
            {
                Name (_ADR, 0x001D0003)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }
                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }
                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0C, 0x04))
                }
            }
            Device (USB3)
            {
                Name (_ADR, 0x001D0004)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }
                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }
                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }
            Device (USBE)
            {
                Name (_ADR, 0x001A0000)
                Device (RHUB)
                {
                    Name (_ADR, Zero)
                    Device (PRT1)
                    {
                        Name (_ADR, One)
                        Name (_UPC, Package (0x04)
                        {
                            0xFF, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Package (0x10)
                        {
                            0x81, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            0x30, 
                            0x1C, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                    }
                }
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0D, 0x04))
                }
            }
            Device (USB4)
            {
                Name (_ADR, 0x001A0001)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }
                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }
                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x05, 0x04))
                }
            }
            Device (USB5)
            {
                Name (_ADR, 0x001A0002)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }
                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }
                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x20, 0x04))
                }
            }
            Device (USB6)
            {
                Name (_ADR, 0x001A0003)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }
                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }
                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x25, 0x04))
                }
            }
            Device (BR21)
            {
                Name (_ADR, 0x001C0001)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR21)
                    }
                    Return (PR21)
                }
                Device (VT00)
                {
                    Name (_ADR, Zero)
                    Name (REFL, One)
                    Name (MSTM, 0x08)
                    Name (SSTM, 0x08)
                    Method (_STA, 0, NotSerialized)
                    {
                        If (LNotEqual (VID, 0x1106))
                        {
                            Return (Zero)
                        }
                        Else
                        {
                            If (LNotEqual (DID, 0x0415))
                            {
                                Return (Zero)
                            }
                            If (LEqual (CMDR, Zero))
                            {
                                Return (0x0D)
                            }
                            Else
                            {
                                Return (0x0F)
                            }
                        }
                    }
                    Method (_REG, 2, NotSerialized)
                    {
                        If (LEqual (Arg0, 0x02))
                        {
                            Store (Arg1, REFL)
                        }
                    }
                    Name (MATX, Buffer (0x14) {})
                    CreateDWordField (MATX, Zero, PIOM)
                    CreateDWordField (MATX, 0x04, DMAM)
                    CreateDWordField (MATX, 0x08, PIOS)
                    CreateDWordField (MATX, 0x0C, DMAS)
                    CreateDWordField (MATX, 0x10, CHFL)
                    OperationRegion (E2PR, PCI_Config, Zero, 0x10)
                    Field (E2PR, ByteAcc, NoLock, Preserve)
                    {
                        VID,    16, 
                        DID,    16, 
                        CMDR,   3
                    }
                    Device (CHN0)
                    {
                        Name (_ADR, Zero)
                        Name (_STA, 0x0F)
                        Method (_GTM, 0, NotSerialized)
                        {
                            Return (GTM ())
                        }
                        Method (_STM, 3, NotSerialized)
                        {
                            Store (Arg0, MATX)
                            STM ()
                        }
                        Device (DRV0)
                        {
                            Name (_ADR, Zero)
                            Method (_GTF, 0, NotSerialized)
                            {
                                Return (GTF (Zero, MSTM))
                            }
                        }
                        Device (DRV1)
                        {
                            Name (_ADR, One)
                            Method (_GTF, 0, NotSerialized)
                            {
                                Return (GTF (One, SSTM))
                            }
                        }
                    }
                    Device (CHN1)
                    {
                        Name (_ADR, One)
                        Name (_STA, Zero)
                    }
                    Method (GTF, 2, Serialized)
                    {
                        Store (Buffer (0x07)
                            {
                                0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                            }, Local0)
                        CreateByteField (Local0, One, MODE)
                        CreateByteField (Local0, 0x05, CHSL)
                        And (Arg0, 0x03, Local1)
                        If (LEqual (And (Local1, One), One))
                        {
                            Store (0xB0, CHSL)
                        }
                        Store (Arg1, MODE)
                        Return (Local0)
                    }
                    Method (GTM, 0, Serialized)
                    {
                        Store (0x78, PIOM)
                        Store (0x78, PIOS)
                        Store (0x0F, DMAM)
                        Store (0x0F, DMAS)
                        Store (0x15, CHFL)
                        Return (MATX)
                    }
                    Method (STM, 0, Serialized)
                    {
                        If (REFL) {}
                        Else
                        {
                            Return (MATX)
                        }
                        If (And (CHFL, One))
                        {
                            If (LEqual (DMAM, 0x78))
                            {
                                Store (0x40, MSTM)
                            }
                            If (LEqual (DMAM, 0x50))
                            {
                                Store (0x41, MSTM)
                            }
                            If (LEqual (DMAM, 0x3C))
                            {
                                Store (0x42, MSTM)
                            }
                            If (LEqual (DMAM, 0x2D))
                            {
                                Store (0x43, MSTM)
                            }
                            If (LEqual (DMAM, 0x1E))
                            {
                                Store (0x44, MSTM)
                            }
                            If (LEqual (DMAM, 0x14))
                            {
                                Store (0x45, MSTM)
                            }
                            If (LEqual (DMAM, 0x0F))
                            {
                                Store (0x46, MSTM)
                            }
                        }
                        Else
                        {
                            If (LEqual (PIOM, 0x0258))
                            {
                                Store (0x08, MSTM)
                            }
                            If (LEqual (PIOM, 0x017F))
                            {
                                Store (0x09, MSTM)
                            }
                            If (LEqual (PIOM, 0xF0))
                            {
                                Store (0x0A, MSTM)
                            }
                            If (LEqual (PIOM, 0xB4))
                            {
                                Store (0x0B, MSTM)
                            }
                            If (LEqual (PIOM, 0x78))
                            {
                                Store (0x0C, MSTM)
                            }
                        }
                        If (And (CHFL, 0x04))
                        {
                            If (LEqual (DMAS, 0x78))
                            {
                                Store (0x40, SSTM)
                            }
                            If (LEqual (DMAS, 0x50))
                            {
                                Store (0x41, SSTM)
                            }
                            If (LEqual (DMAS, 0x3C))
                            {
                                Store (0x42, SSTM)
                            }
                            If (LEqual (DMAS, 0x2D))
                            {
                                Store (0x43, SSTM)
                            }
                            If (LEqual (DMAS, 0x1E))
                            {
                                Store (0x44, SSTM)
                            }
                            If (LEqual (DMAS, 0x14))
                            {
                                Store (0x45, SSTM)
                            }
                            If (LEqual (DMAS, 0x0F))
                            {
                                Store (0x46, SSTM)
                            }
                        }
                        Else
                        {
                            If (LEqual (PIOS, 0x0258))
                            {
                                Store (0x08, SSTM)
                            }
                            If (LEqual (PIOS, 0x017F))
                            {
                                Store (0x09, SSTM)
                            }
                            If (LEqual (PIOS, 0xF0))
                            {
                                Store (0x0A, SSTM)
                            }
                            If (LEqual (PIOS, 0xB4))
                            {
                                Store (0x0B, SSTM)
                            }
                            If (LEqual (PIOS, 0x78))
                            {
                                Store (0x0C, SSTM)
                            }
                        }
                         Return (zero)
                    }
                }
            }
            Device (BR22)
            {
                Name (_ADR, 0x001C0002)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR22)
                    }
                    Return (PR22)
                }
            }
            Device (BR23)
            {
                Name (_ADR, 0x001C0003)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR23)
                    }
                    Return (PR23)
                }
            }
            Device (P0P1)
            {
                Name (_ADR, 0x00010000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR01)
                    }
                    Return (PR01)
                }
            }
            Device (P0P3)
            {
                Name (_ADR, 0x00030000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR03)
                    }
                    Return (PR03)
                }
            }
            Device (P0P5)
            {
                Name (_ADR, 0x00050000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR05)
                    }
                    Return (PR05)
                }
            }
            Device (P0P6)
            {
                Name (_ADR, 0x00060000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR06)
                    }
                    Return (PR06)
                }
            }
            Device (USB8)
            {
                Name (_ADR, 0x001A0007)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }
                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }
                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x20, 0x04))
                }
            }
            Device (BR20)
            {
                Name (_ADR, 0x001C0000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR20)
                    }
                    Return (PR20)
                }
            }
            Device (BR24)
            {
                Name (_ADR, 0x001C0004)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR24)
                    }
                    Return (PR24)
                }
            }
            Device (BR25)
            {
                Name (_ADR, 0x001C0005)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR25)
                    }
                    Return (PR25)
                }
            }
            Device (BR26)
            {
                Name (_ADR, 0x001C0006)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR26)
                    }
                    Return (PR26)
                }
            }
            Device (BR27)
            {
                Name (_ADR, 0x001C0007)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR27)
                    }
                    Return (PR27)
                }
            }
            Device (SATA)
            {
                Name (_ADR, 0x001F0002)
                Name (^NATA, Package (0x01)
                {
                    0x001F0002
                })
                Name (\FZTF, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF5
                })
                Name (REGF, One)
                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (Arg1, REGF)
                    }
                }
                Name (TIM0, Package (0x08)
                {
                    Package (0x04)
                    {
                        0x78, 
                        0xB4, 
                        0xF0, 
                        0x0384
                    }, 
                    Package (0x04)
                    {
                        0x23, 
                        0x21, 
                        0x10, 
                        Zero
                    }, 
                    Package (0x04)
                    {
                        0x0B, 
                        0x09, 
                        0x04, 
                        Zero
                    }, 
                    Package (0x06)
                    {
                        0x78, 
                        0x50, 
                        0x3C, 
                        0x28, 
                        0x1E, 
                        0x14
                    }, 
                    Package (0x06)
                    {
                        Zero, 
                        One, 
                        0x02, 
                        One, 
                        0x02, 
                        One
                    }, 
                    Package (0x06)
                    {
                        Zero, 
                        Zero, 
                        Zero, 
                        One, 
                        One, 
                        One
                    }, 
                    Package (0x04)
                    {
                        0x04, 
                        0x03, 
                        0x02, 
                        Zero
                    }, 
                    Package (0x04)
                    {
                        0x02, 
                        One, 
                        Zero, 
                        Zero
                    }
                })
                Name (TMD0, Buffer (0x14) {})
                CreateDWordField (TMD0, Zero, PIO0)
                CreateDWordField (TMD0, 0x04, DMA0)
                CreateDWordField (TMD0, 0x08, PIO1)
                CreateDWordField (TMD0, 0x0C, DMA1)
                CreateDWordField (TMD0, 0x10, CHNF)
                OperationRegion (CFG2, PCI_Config, 0x40, 0x20)
                Field (CFG2, DWordAcc, NoLock, Preserve)
                {
                    PMPT,   4, 
                    PSPT,   4, 
                    PMRI,   6, 
                            Offset (0x02), 
                    SMPT,   4, 
                    SSPT,   4, 
                    SMRI,   6, 
                            Offset (0x04), 
                    PSRI,   4, 
                    SSRI,   4, 
                            Offset (0x08), 
                    PM3E,   1, 
                    PS3E,   1, 
                    SM3E,   1, 
                    SS3E,   1, 
                            Offset (0x0A), 
                    PMUT,   2, 
                        ,   2, 
                    PSUT,   2, 
                            Offset (0x0B), 
                    SMUT,   2, 
                        ,   2, 
                    SSUT,   2, 
                            Offset (0x0C), 
                            Offset (0x14), 
                    PM6E,   1, 
                    PS6E,   1, 
                    SM6E,   1, 
                    SS6E,   1, 
                    PMCR,   1, 
                    PSCR,   1, 
                    SMCR,   1, 
                    SSCR,   1, 
                        ,   4, 
                    PMAE,   1, 
                    PSAE,   1, 
                    SMAE,   1, 
                    SSAE,   1
                }
                Name (GMPT, Zero)
                Name (GMUE, Zero)
                Name (GMUT, Zero)
                Name (GMCR, Zero)
                Name (GSPT, Zero)
                Name (GSUE, Zero)
                Name (GSUT, Zero)
                Name (GSCR, Zero)
                Device (CHN0)
                {
                    Name (_ADR, Zero)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (PSCR, One, Local1)
                        Or (PMCR, Local1, Local0)
                        ShiftLeft (PMAE, 0x02, Local3)
                        ShiftLeft (PM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PM3E, Local3, Local1)
                        ShiftLeft (PMPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        ShiftLeft (PSAE, 0x02, Local3)
                        ShiftLeft (PS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PS3E, Local3, Local2)
                        ShiftLeft (PSPT, 0x04, Local3)
                        Or (Local2, Local3, Local2)
                        Return (GTM (PMRI, Local1, PMUT, PSRI, Local2, PSUT, Local0))
                    }
                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        ShiftLeft (PMAE, 0x02, Local3)
                        ShiftLeft (PM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PM3E, Local3, Local0)
                        ShiftLeft (PMPT, 0x04, Local3)
                        Or (Local0, Local3, Local0)
                        ShiftLeft (PSAE, 0x02, Local3)
                        ShiftLeft (PS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PS3E, Local3, Local1)
                        ShiftLeft (PSPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        Store (PMRI, GMPT)
                        Store (Local0, GMUE)
                        Store (PMUT, GMUT)
                        Store (PMCR, GMCR)
                        Store (PSRI, GSPT)
                        Store (Local1, GSUE)
                        Store (PSUT, GSUT)
                        Store (PSCR, GSCR)
                        STM ()
                        Store (GMPT, PMRI)
                        Store (GMUE, Local0)
                        Store (GMUT, PMUT)
                        Store (GMCR, PMCR)
                        Store (GSUE, Local1)
                        Store (GSUT, PSUT)
                        Store (GSCR, PSCR)
                        If (And (Local0, One))
                        {
                            Store (One, PM3E)
                        }
                        Else
                        {
                            Store (Zero, PM3E)
                        }
                        If (And (Local0, 0x02))
                        {
                            Store (One, PM6E)
                        }
                        Else
                        {
                            Store (Zero, PM6E)
                        }
                        If (And (Local0, 0x04))
                        {
                            Store (One, PMAE)
                        }
                        Else
                        {
                            Store (Zero, PMAE)
                        }
                        If (And (Local1, One))
                        {
                            Store (One, PS3E)
                        }
                        Else
                        {
                            Store (Zero, PS3E)
                        }
                        If (And (Local1, 0x02))
                        {
                            Store (One, PS6E)
                        }
                        Else
                        {
                            Store (Zero, PS6E)
                        }
                        If (And (Local1, 0x04))
                        {
                            Store (One, PSAE)
                        }
                        Else
                        {
                            Store (Zero, PSAE)
                        }
                        Store (GTF (Zero, Arg1), ATA0)
                        Store (GTF (One, Arg2), ATA1)
                    }
                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA0))
                        }
                    }
                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA1))
                        }
                    }
                }
                Device (CHN1)
                {
                    Name (_ADR, One)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (SSCR, One, Local1)
                        Or (SMCR, Local1, Local0)
                        ShiftLeft (SMAE, 0x02, Local3)
                        ShiftLeft (SM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SM3E, Local3, Local1)
                        ShiftLeft (SMPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        ShiftLeft (SSAE, 0x02, Local3)
                        ShiftLeft (SS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SS3E, Local3, Local2)
                        ShiftLeft (SSPT, 0x04, Local3)
                        Or (Local2, Local3, Local2)
                        Return (GTM (SMRI, Local1, SMUT, SSRI, Local2, SSUT, Local0))
                    }
                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        ShiftLeft (SMAE, 0x02, Local3)
                        ShiftLeft (SM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SM3E, Local3, Local0)
                        ShiftLeft (SMPT, 0x04, Local3)
                        Or (Local0, Local3, Local0)
                        ShiftLeft (SSAE, 0x02, Local3)
                        ShiftLeft (SS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SS3E, Local3, Local1)
                        ShiftLeft (SSPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        Store (SMRI, GMPT)
                        Store (Local0, GMUE)
                        Store (SMUT, GMUT)
                        Store (SMCR, GMCR)
                        Store (SSRI, GSPT)
                        Store (Local1, GSUE)
                        Store (SSUT, GSUT)
                        Store (SSCR, GSCR)
                        STM ()
                        Store (GMPT, SMRI)
                        Store (GMUE, Local0)
                        Store (GMUT, SMUT)
                        Store (GMCR, SMCR)
                        Store (GSUE, Local1)
                        Store (GSUT, SSUT)
                        Store (GSCR, SSCR)
                        If (And (Local0, One))
                        {
                            Store (One, SM3E)
                        }
                        Else
                        {
                            Store (Zero, SM3E)
                        }
                        If (And (Local0, 0x02))
                        {
                            Store (One, SM6E)
                        }
                        Else
                        {
                            Store (Zero, SM6E)
                        }
                        If (And (Local0, 0x04))
                        {
                            Store (One, SMAE)
                        }
                        Else
                        {
                            Store (Zero, SMAE)
                        }
                        If (And (Local1, One))
                        {
                            Store (One, SS3E)
                        }
                        Else
                        {
                            Store (Zero, SS3E)
                        }
                        If (And (Local1, 0x02))
                        {
                            Store (One, SS6E)
                        }
                        Else
                        {
                            Store (Zero, SS6E)
                        }
                        If (And (Local1, 0x04))
                        {
                            Store (One, SSAE)
                        }
                        Else
                        {
                            Store (Zero, SSAE)
                        }
                        Store (GTF (Zero, Arg1), ATA2)
                        Store (GTF (One, Arg2), ATA3)
                    }
                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA2))
                        }
                    }
                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA3))
                        }
                    }
                }
                Method (GTM, 7, Serialized)
                {
                    Store (Ones, PIO0)
                    Store (Ones, PIO1)
                    Store (Ones, DMA0)
                    Store (Ones, DMA1)
                    Store (0x10, CHNF)
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }
                    If (And (Arg1, 0x20))
                    {
                        Or (CHNF, 0x02, CHNF)
                    }
                    Store (Match (DerefOf (Index (TIM0, One)), MEQ, Arg0, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA0)
                    Store (Local7, PIO0)
                    If (And (Arg4, 0x20))
                    {
                        Or (CHNF, 0x08, CHNF)
                    }
                    Store (Match (DerefOf (Index (TIM0, 0x02)), MEQ, Arg3, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA1)
                    Store (Local7, PIO1)
                    If (And (Arg1, 0x07))
                    {
                        Store (Arg2, Local5)
                        If (And (Arg1, 0x02))
                        {
                            Add (Local5, 0x02, Local5)
                        }
                        If (And (Arg1, 0x04))
                        {
                            Add (Local5, 0x04, Local5)
                        }
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA0)
                        Or (CHNF, One, CHNF)
                    }
                    If (And (Arg4, 0x07))
                    {
                        Store (Arg5, Local5)
                        If (And (Arg4, 0x02))
                        {
                            Add (Local5, 0x02, Local5)
                        }
                        If (And (Arg4, 0x04))
                        {
                            Add (Local5, 0x04, Local5)
                        }
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA1)
                        Or (CHNF, 0x04, CHNF)
                    }
                    Store (TMD0, Debug)
                    Return (TMD0)
                }
                Method (STM, 0, Serialized)
                {
                    If (REGF)
                    {
                        Store (Zero, GMUE)
                        Store (Zero, GMUT)
                        Store (Zero, GSUE)
                        Store (Zero, GSUT)
                        If (And (CHNF, One))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA0, MTR, 
                                Zero, Zero), Local0)
                            If (LGreater (Local0, 0x05))
                            {
                                Store (0x05, Local0)
                            }
                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), 
                                GMUT)
                            Or (GMUE, One, GMUE)
                            If (LGreater (Local0, 0x02))
                            {
                                Or (GMUE, 0x02, GMUE)
                            }
                            If (LGreater (Local0, 0x04))
                            {
                                And (GMUE, 0xFD, GMUE)
                                Or (GMUE, 0x04, GMUE)
                            }
                        }
                        Else
                        {
                            If (Or (LEqual (PIO0, Ones), LEqual (PIO0, Zero)))
                            {
                                If (And (LLess (DMA0, Ones), LGreater (DMA0, Zero)))
                                {
                                    Store (DMA0, PIO0)
                                    Or (GMUE, 0x80, GMUE)
                                }
                            }
                        }
                        If (And (CHNF, 0x04))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA1, MTR, 
                                Zero, Zero), Local0)
                            If (LGreater (Local0, 0x05))
                            {
                                Store (0x05, Local0)
                            }
                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), 
                                GSUT)
                            Or (GSUE, One, GSUE)
                            If (LGreater (Local0, 0x02))
                            {
                                Or (GSUE, 0x02, GSUE)
                            }
                            If (LGreater (Local0, 0x04))
                            {
                                And (GSUE, 0xFD, GSUE)
                                Or (GSUE, 0x04, GSUE)
                            }
                        }
                        Else
                        {
                            If (Or (LEqual (PIO1, Ones), LEqual (PIO1, Zero)))
                            {
                                If (And (LLess (DMA1, Ones), LGreater (DMA1, Zero)))
                                {
                                    Store (DMA1, PIO1)
                                    Or (GSUE, 0x80, GSUE)
                                }
                            }
                        }
                        If (And (CHNF, 0x02))
                        {
                            Or (GMUE, 0x20, GMUE)
                        }
                        If (And (CHNF, 0x08))
                        {
                            Or (GSUE, 0x20, GSUE)
                        }
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO0, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, One)), Local0)), 
                            Local1)
                        Store (Local1, GMPT)
                        If (LLess (Local0, 0x03))
                        {
                            Or (GMUE, 0x50, GMUE)
                        }
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO1, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Local0)), 
                            Local1)
                        Store (Local1, GSPT)
                        If (LLess (Local0, 0x03))
                        {
                            Or (GSUE, 0x50, GSUE)
                        }
                    }
                }
                Name (AT01, Buffer (0x07)
                {
                    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (AT02, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90
                })
                Name (AT03, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6
                })
                Name (AT04, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91
                })
                Name (ATA0, Buffer (0x1D) {})
                Name (ATA1, Buffer (0x1D) {})
                Name (ATA2, Buffer (0x1D) {})
                Name (ATA3, Buffer (0x1D) {})
                Name (ATAB, Buffer (0x1D) {})
                CreateByteField (ATAB, Zero, CMDC)
                Method (GTFB, 3, Serialized)
                {
                    Multiply (CMDC, 0x38, Local0)
                    Add (Local0, 0x08, Local1)
                    CreateField (ATAB, Local1, 0x38, CMDX)
                    Multiply (CMDC, 0x07, Local0)
                    CreateByteField (ATAB, Add (Local0, 0x02), A001)
                    CreateByteField (ATAB, Add (Local0, 0x06), A005)
                    Store (Arg0, CMDX)
                    Store (Arg1, A001)
                    Store (Arg2, A005)
                    Increment (CMDC)
                }
                Method (GTF, 2, Serialized)
                {
                    Store (Arg1, Debug)
                    Store (Zero, CMDC)
                    Name (ID49, 0x0C00)
                    Name (ID59, Zero)
                    Name (ID53, 0x04)
                    Name (ID63, 0x0F00)
                    Name (ID88, 0x0F00)
                    Name (IRDY, One)
                    Name (PIOT, Zero)
                    Name (DMAT, Zero)
                    If (LEqual (SizeOf (Arg1), 0x0200))
                    {
                        CreateWordField (Arg1, 0x62, IW49)
                        Store (IW49, ID49)
                        CreateWordField (Arg1, 0x6A, IW53)
                        Store (IW53, ID53)
                        CreateWordField (Arg1, 0x7E, IW63)
                        Store (IW63, ID63)
                        CreateWordField (Arg1, 0x76, IW59)
                        Store (IW59, ID59)
                        CreateWordField (Arg1, 0xB0, IW88)
                        Store (IW88, ID88)
                    }
                    Store (0xA0, Local7)
                    If (Arg0)
                    {
                        Store (0xB0, Local7)
                        And (CHNF, 0x08, IRDY)
                        If (And (CHNF, 0x10))
                        {
                            Store (PIO1, PIOT)
                        }
                        Else
                        {
                            Store (PIO0, PIOT)
                        }
                        If (And (CHNF, 0x04))
                        {
                            If (And (CHNF, 0x10))
                            {
                                Store (DMA1, DMAT)
                            }
                            Else
                            {
                                Store (DMA0, DMAT)
                            }
                        }
                    }
                    Else
                    {
                        And (CHNF, 0x02, IRDY)
                        Store (PIO0, PIOT)
                        If (And (CHNF, One))
                        {
                            Store (DMA0, DMAT)
                        }
                    }
                    If (LAnd (LAnd (And (ID53, 0x04), And (ID88, 0xFF00
                        )), DMAT))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMAT, MTR, 
                            Zero, Zero), Local1)
                        If (LGreater (Local1, 0x05))
                        {
                            Store (0x05, Local1)
                        }
                        GTFB (AT01, Or (0x40, Local1), Local7)
                    }
                    Else
                    {
                        If (LAnd (And (ID63, 0xFF00), PIOT))
                        {
                            And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                                Zero, Zero), 0x03, Local0)
                            Or (0x20, DerefOf (Index (DerefOf (Index (TIM0, 0x07)), Local0
                                )), Local1)
                            GTFB (AT01, Local1, Local7)
                        }
                    }
                    If (IRDY)
                    {
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Or (0x08, DerefOf (Index (DerefOf (Index (TIM0, 0x06)), Local0
                            )), Local1)
                        GTFB (AT01, Local1, Local7)
                    }
                    Else
                    {
                        If (And (ID49, 0x0400))
                        {
                            GTFB (AT01, One, Local7)
                        }
                    }
                    If (LAnd (And (ID59, 0x0100), And (ID59, 0xFF)))
                    {
                        GTFB (AT03, And (ID59, 0xFF), Local7)
                    }
                    Store (ATAB, Debug)
                    Return (ATAB)
                }
                Method (RATA, 1, NotSerialized)
                {
                    CreateByteField (Arg0, Zero, CMDN)
                    Multiply (CMDN, 0x38, Local0)
                    CreateField (Arg0, 0x08, Local0, RETB)
                    Store (RETB, Debug)
                    Return (Concatenate (RETB, FZTF))
                }
            }
            Device (SAT1)
            {
                Name (_ADR, 0x001F0005)
                Name (REGF, One)
                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (Arg1, REGF)
                    }
                }
                Name (TIM0, Package (0x08)
                {
                    Package (0x04)
                    {
                        0x78, 
                        0xB4, 
                        0xF0, 
                        0x0384
                    }, 
                    Package (0x04)
                    {
                        0x23, 
                        0x21, 
                        0x10, 
                        Zero
                    }, 
                    Package (0x04)
                    {
                        0x0B, 
                        0x09, 
                        0x04, 
                        Zero
                    }, 
                    Package (0x06)
                    {
                        0x78, 
                        0x50, 
                        0x3C, 
                        0x28, 
                        0x1E, 
                        0x14
                    }, 
                    Package (0x06)
                    {
                        Zero, 
                        One, 
                        0x02, 
                        One, 
                        0x02, 
                        One
                    }, 
                    Package (0x06)
                    {
                        Zero, 
                        Zero, 
                        Zero, 
                        One, 
                        One, 
                        One
                    }, 
                    Package (0x04)
                    {
                        0x04, 
                        0x03, 
                        0x02, 
                        Zero
                    }, 
                    Package (0x04)
                    {
                        0x02, 
                        One, 
                        Zero, 
                        Zero
                    }
                })
                Name (TMD0, Buffer (0x14) {})
                CreateDWordField (TMD0, Zero, PIO0)
                CreateDWordField (TMD0, 0x04, DMA0)
                CreateDWordField (TMD0, 0x08, PIO1)
                CreateDWordField (TMD0, 0x0C, DMA1)
                CreateDWordField (TMD0, 0x10, CHNF)
                OperationRegion (CFG2, PCI_Config, 0x40, 0x20)
                Field (CFG2, DWordAcc, NoLock, Preserve)
                {
                    PMPT,   4, 
                    PSPT,   4, 
                    PMRI,   6, 
                            Offset (0x02), 
                    SMPT,   4, 
                    SSPT,   4, 
                    SMRI,   6, 
                            Offset (0x04), 
                    PSRI,   4, 
                    SSRI,   4, 
                            Offset (0x08), 
                    PM3E,   1, 
                    PS3E,   1, 
                    SM3E,   1, 
                    SS3E,   1, 
                            Offset (0x0A), 
                    PMUT,   2, 
                        ,   2, 
                    PSUT,   2, 
                            Offset (0x0B), 
                    SMUT,   2, 
                        ,   2, 
                    SSUT,   2, 
                            Offset (0x0C), 
                            Offset (0x14), 
                    PM6E,   1, 
                    PS6E,   1, 
                    SM6E,   1, 
                    SS6E,   1, 
                    PMCR,   1, 
                    PSCR,   1, 
                    SMCR,   1, 
                    SSCR,   1, 
                        ,   4, 
                    PMAE,   1, 
                    PSAE,   1, 
                    SMAE,   1, 
                    SSAE,   1
                }
                Name (GMPT, Zero)
                Name (GMUE, Zero)
                Name (GMUT, Zero)
                Name (GMCR, Zero)
                Name (GSPT, Zero)
                Name (GSUE, Zero)
                Name (GSUT, Zero)
                Name (GSCR, Zero)
                Device (CHN0)
                {
                    Name (_ADR, Zero)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (PSCR, One, Local1)
                        Or (PMCR, Local1, Local0)
                        ShiftLeft (PMAE, 0x02, Local3)
                        ShiftLeft (PM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PM3E, Local3, Local1)
                        ShiftLeft (PMPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        ShiftLeft (PSAE, 0x02, Local3)
                        ShiftLeft (PS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PS3E, Local3, Local2)
                        ShiftLeft (PSPT, 0x04, Local3)
                        Or (Local2, Local3, Local2)
                        Return (GTM (PMRI, Local1, PMUT, PSRI, Local2, PSUT, Local0))
                    }
                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        ShiftLeft (PMAE, 0x02, Local3)
                        ShiftLeft (PM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PM3E, Local3, Local0)
                        ShiftLeft (PMPT, 0x04, Local3)
                        Or (Local0, Local3, Local0)
                        ShiftLeft (PSAE, 0x02, Local3)
                        ShiftLeft (PS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PS3E, Local3, Local1)
                        ShiftLeft (PSPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        Store (PMRI, GMPT)
                        Store (Local0, GMUE)
                        Store (PMUT, GMUT)
                        Store (PMCR, GMCR)
                        Store (PSRI, GSPT)
                        Store (Local1, GSUE)
                        Store (PSUT, GSUT)
                        Store (PSCR, GSCR)
                        STM ()
                        Store (GMPT, PMRI)
                        Store (GMUE, Local0)
                        Store (GMUT, PMUT)
                        Store (GMCR, PMCR)
                        Store (GSUE, Local1)
                        Store (GSUT, PSUT)
                        Store (GSCR, PSCR)
                        If (And (Local0, One))
                        {
                            Store (One, PM3E)
                        }
                        Else
                        {
                            Store (Zero, PM3E)
                        }
                        If (And (Local0, 0x02))
                        {
                            Store (One, PM6E)
                        }
                        Else
                        {
                            Store (Zero, PM6E)
                        }
                        If (And (Local0, 0x04))
                        {
                            Store (One, PMAE)
                        }
                        Else
                        {
                            Store (Zero, PMAE)
                        }
                        If (And (Local1, One))
                        {
                            Store (One, PS3E)
                        }
                        Else
                        {
                            Store (Zero, PS3E)
                        }
                        If (And (Local1, 0x02))
                        {
                            Store (One, PS6E)
                        }
                        Else
                        {
                            Store (Zero, PS6E)
                        }
                        If (And (Local1, 0x04))
                        {
                            Store (One, PSAE)
                        }
                        Else
                        {
                            Store (Zero, PSAE)
                        }
                        Store (GTF (Zero, Arg1), ATA0)
                        Store (GTF (One, Arg2), ATA1)
                    }
                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA0))
                        }
                    }
                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA1))
                        }
                    }
                }
                Device (CHN1)
                {
                    Name (_ADR, One)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (SSCR, One, Local1)
                        Or (SMCR, Local1, Local0)
                        ShiftLeft (SMAE, 0x02, Local3)
                        ShiftLeft (SM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SM3E, Local3, Local1)
                        ShiftLeft (SMPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        ShiftLeft (SSAE, 0x02, Local3)
                        ShiftLeft (SS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SS3E, Local3, Local2)
                        ShiftLeft (SSPT, 0x04, Local3)
                        Or (Local2, Local3, Local2)
                        Return (GTM (SMRI, Local1, SMUT, SSRI, Local2, SSUT, Local0))
                    }
                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        ShiftLeft (SMAE, 0x02, Local3)
                        ShiftLeft (SM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SM3E, Local3, Local0)
                        ShiftLeft (SMPT, 0x04, Local3)
                        Or (Local0, Local3, Local0)
                        ShiftLeft (SSAE, 0x02, Local3)
                        ShiftLeft (SS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SS3E, Local3, Local1)
                        ShiftLeft (SSPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        Store (SMRI, GMPT)
                        Store (Local0, GMUE)
                        Store (SMUT, GMUT)
                        Store (SMCR, GMCR)
                        Store (SSRI, GSPT)
                        Store (Local1, GSUE)
                        Store (SSUT, GSUT)
                        Store (SSCR, GSCR)
                        STM ()
                        Store (GMPT, SMRI)
                        Store (GMUE, Local0)
                        Store (GMUT, SMUT)
                        Store (GMCR, SMCR)
                        Store (GSUE, Local1)
                        Store (GSUT, SSUT)
                        Store (GSCR, SSCR)
                        If (And (Local0, One))
                        {
                            Store (One, SM3E)
                        }
                        Else
                        {
                            Store (Zero, SM3E)
                        }
                        If (And (Local0, 0x02))
                        {
                            Store (One, SM6E)
                        }
                        Else
                        {
                            Store (Zero, SM6E)
                        }
                        If (And (Local0, 0x04))
                        {
                            Store (One, SMAE)
                        }
                        Else
                        {
                            Store (Zero, SMAE)
                        }
                        If (And (Local1, One))
                        {
                            Store (One, SS3E)
                        }
                        Else
                        {
                            Store (Zero, SS3E)
                        }
                        If (And (Local1, 0x02))
                        {
                            Store (One, SS6E)
                        }
                        Else
                        {
                            Store (Zero, SS6E)
                        }
                        If (And (Local1, 0x04))
                        {
                            Store (One, SSAE)
                        }
                        Else
                        {
                            Store (Zero, SSAE)
                        }
                        Store (GTF (Zero, Arg1), ATA2)
                        Store (GTF (One, Arg2), ATA3)
                    }
                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA2))
                        }
                    }
                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA3))
                        }
                    }
                }
                Method (GTM, 7, Serialized)
                {
                    Store (Ones, PIO0)
                    Store (Ones, PIO1)
                    Store (Ones, DMA0)
                    Store (Ones, DMA1)
                    Store (0x10, CHNF)
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }
                    If (And (Arg1, 0x20))
                    {
                        Or (CHNF, 0x02, CHNF)
                    }
                    Store (Match (DerefOf (Index (TIM0, One)), MEQ, Arg0, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA0)
                    Store (Local7, PIO0)
                    If (And (Arg4, 0x20))
                    {
                        Or (CHNF, 0x08, CHNF)
                    }
                    Store (Match (DerefOf (Index (TIM0, 0x02)), MEQ, Arg3, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA1)
                    Store (Local7, PIO1)
                    If (And (Arg1, 0x07))
                    {
                        Store (Arg2, Local5)
                        If (And (Arg1, 0x02))
                        {
                            Add (Local5, 0x02, Local5)
                        }
                        If (And (Arg1, 0x04))
                        {
                            Add (Local5, 0x04, Local5)
                        }
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA0)
                        Or (CHNF, One, CHNF)
                    }
                    If (And (Arg4, 0x07))
                    {
                        Store (Arg5, Local5)
                        If (And (Arg4, 0x02))
                        {
                            Add (Local5, 0x02, Local5)
                        }
                        If (And (Arg4, 0x04))
                        {
                            Add (Local5, 0x04, Local5)
                        }
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA1)
                        Or (CHNF, 0x04, CHNF)
                    }
                    Store (TMD0, Debug)
                    Return (TMD0)
                }
                Method (STM, 0, Serialized)
                {
                    If (REGF)
                    {
                        Store (Zero, GMUE)
                        Store (Zero, GMUT)
                        Store (Zero, GSUE)
                        Store (Zero, GSUT)
                        If (And (CHNF, One))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA0, MTR, 
                                Zero, Zero), Local0)
                            If (LGreater (Local0, 0x05))
                            {
                                Store (0x05, Local0)
                            }
                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), 
                                GMUT)
                            Or (GMUE, One, GMUE)
                            If (LGreater (Local0, 0x02))
                            {
                                Or (GMUE, 0x02, GMUE)
                            }
                            If (LGreater (Local0, 0x04))
                            {
                                And (GMUE, 0xFD, GMUE)
                                Or (GMUE, 0x04, GMUE)
                            }
                        }
                        Else
                        {
                            If (Or (LEqual (PIO0, Ones), LEqual (PIO0, Zero)))
                            {
                                If (And (LLess (DMA0, Ones), LGreater (DMA0, Zero)))
                                {
                                    Store (DMA0, PIO0)
                                    Or (GMUE, 0x80, GMUE)
                                }
                            }
                        }
                        If (And (CHNF, 0x04))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA1, MTR, 
                                Zero, Zero), Local0)
                            If (LGreater (Local0, 0x05))
                            {
                                Store (0x05, Local0)
                            }
                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), 
                                GSUT)
                            Or (GSUE, One, GSUE)
                            If (LGreater (Local0, 0x02))
                            {
                                Or (GSUE, 0x02, GSUE)
                            }
                            If (LGreater (Local0, 0x04))
                            {
                                And (GSUE, 0xFD, GSUE)
                                Or (GSUE, 0x04, GSUE)
                            }
                        }
                        Else
                        {
                            If (Or (LEqual (PIO1, Ones), LEqual (PIO1, Zero)))
                            {
                                If (And (LLess (DMA1, Ones), LGreater (DMA1, Zero)))
                                {
                                    Store (DMA1, PIO1)
                                    Or (GSUE, 0x80, GSUE)
                                }
                            }
                        }
                        If (And (CHNF, 0x02))
                        {
                            Or (GMUE, 0x20, GMUE)
                        }
                        If (And (CHNF, 0x08))
                        {
                            Or (GSUE, 0x20, GSUE)
                        }
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO0, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, One)), Local0)), 
                            Local1)
                        Store (Local1, GMPT)
                        If (LLess (Local0, 0x03))
                        {
                            Or (GMUE, 0x50, GMUE)
                        }
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO1, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Local0)), 
                            Local1)
                        Store (Local1, GSPT)
                        If (LLess (Local0, 0x03))
                        {
                            Or (GSUE, 0x50, GSUE)
                        }
                    }
                }
                Name (AT01, Buffer (0x07)
                {
                    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (AT02, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90
                })
                Name (AT03, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6
                })
                Name (AT04, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91
                })
                Name (ATA0, Buffer (0x1D) {})
                Name (ATA1, Buffer (0x1D) {})
                Name (ATA2, Buffer (0x1D) {})
                Name (ATA3, Buffer (0x1D) {})
                Name (ATAB, Buffer (0x1D) {})
                CreateByteField (ATAB, Zero, CMDC)
                Method (GTFB, 3, Serialized)
                {
                    Multiply (CMDC, 0x38, Local0)
                    Add (Local0, 0x08, Local1)
                    CreateField (ATAB, Local1, 0x38, CMDX)
                    Multiply (CMDC, 0x07, Local0)
                    CreateByteField (ATAB, Add (Local0, 0x02), A001)
                    CreateByteField (ATAB, Add (Local0, 0x06), A005)
                    Store (Arg0, CMDX)
                    Store (Arg1, A001)
                    Store (Arg2, A005)
                    Increment (CMDC)
                }
                Method (GTF, 2, Serialized)
                {
                    Store (Arg1, Debug)
                    Store (Zero, CMDC)
                    Name (ID49, 0x0C00)
                    Name (ID59, Zero)
                    Name (ID53, 0x04)
                    Name (ID63, 0x0F00)
                    Name (ID88, 0x0F00)
                    Name (IRDY, One)
                    Name (PIOT, Zero)
                    Name (DMAT, Zero)
                    If (LEqual (SizeOf (Arg1), 0x0200))
                    {
                        CreateWordField (Arg1, 0x62, IW49)
                        Store (IW49, ID49)
                        CreateWordField (Arg1, 0x6A, IW53)
                        Store (IW53, ID53)
                        CreateWordField (Arg1, 0x7E, IW63)
                        Store (IW63, ID63)
                        CreateWordField (Arg1, 0x76, IW59)
                        Store (IW59, ID59)
                        CreateWordField (Arg1, 0xB0, IW88)
                        Store (IW88, ID88)
                    }
                    Store (0xA0, Local7)
                    If (Arg0)
                    {
                        Store (0xB0, Local7)
                        And (CHNF, 0x08, IRDY)
                        If (And (CHNF, 0x10))
                        {
                            Store (PIO1, PIOT)
                        }
                        Else
                        {
                            Store (PIO0, PIOT)
                        }
                        If (And (CHNF, 0x04))
                        {
                            If (And (CHNF, 0x10))
                            {
                                Store (DMA1, DMAT)
                            }
                            Else
                            {
                                Store (DMA0, DMAT)
                            }
                        }
                    }
                    Else
                    {
                        And (CHNF, 0x02, IRDY)
                        Store (PIO0, PIOT)
                        If (And (CHNF, One))
                        {
                            Store (DMA0, DMAT)
                        }
                    }
                    If (LAnd (LAnd (And (ID53, 0x04), And (ID88, 0xFF00
                        )), DMAT))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMAT, MTR, 
                            Zero, Zero), Local1)
                        If (LGreater (Local1, 0x05))
                        {
                            Store (0x05, Local1)
                        }
                        GTFB (AT01, Or (0x40, Local1), Local7)
                    }
                    Else
                    {
                        If (LAnd (And (ID63, 0xFF00), PIOT))
                        {
                            And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                                Zero, Zero), 0x03, Local0)
                            Or (0x20, DerefOf (Index (DerefOf (Index (TIM0, 0x07)), Local0
                                )), Local1)
                            GTFB (AT01, Local1, Local7)
                        }
                    }
                    If (IRDY)
                    {
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Or (0x08, DerefOf (Index (DerefOf (Index (TIM0, 0x06)), Local0
                            )), Local1)
                        GTFB (AT01, Local1, Local7)
                    }
                    Else
                    {
                        If (And (ID49, 0x0400))
                        {
                            GTFB (AT01, One, Local7)
                        }
                    }
                    If (LAnd (And (ID59, 0x0100), And (ID59, 0xFF)))
                    {
                        GTFB (AT03, And (ID59, 0xFF), Local7)
                    }
                    Store (ATAB, Debug)
                    Return (ATAB)
                }
                Method (RATA, 1, NotSerialized)
                {
                    CreateByteField (Arg0, Zero, CMDN)
                    Multiply (CMDN, 0x38, Local0)
                    CreateField (Arg0, 0x08, Local0, RETB)
                    Store (RETB, Debug)
                    Return (Concatenate (RETB, FZTF))
                }
            }
            Device (SBUS)
            {
                Name (_ADR, 0x001F0003)
                Device (BUS0)
                {
                    Name (_CID, "smbus")
                    Name (_ADR, Zero)
                    Device (DVL0)
                    {
                        Name (_ADR, 0x57)
                        Name (_CID, "diagsvault")
                    }
                }
                Method (_DSM, 4, NotSerialized)
                {
                    Store (Package (0x02)
                        {
                            "device-id", 
                            Buffer (0x04)
                            {
                                0x30, 0x3A, 0x00, 0x00
                            }
                        }, Local0)
                    DTGP (Arg0, Arg1, Arg2, Arg3, RefOf (Local0))
                    Return (Local0)
                }
            }
        }
        Scope (\_GPE)
        {
            Method (_L09, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.P0P4, 0x02)
                Notify (\_SB.PCI0.BR21, 0x02)
                Notify (\_SB.PCI0.BR22, 0x02)
                Notify (\_SB.PCI0.BR23, 0x02)
                Notify (\_SB.PCI0.P0P1, 0x02)
                Notify (\_SB.PCI0.P0P3, 0x02)
                Notify (\_SB.PCI0.P0P5, 0x02)
                Notify (\_SB.PCI0.P0P6, 0x02)
                Notify (\_SB.PCI0.BR20, 0x02)
                Notify (\_SB.PCI0.BR24, 0x02)
                Notify (\_SB.PCI0.BR25, 0x02)
                Notify (\_SB.PCI0.BR26, 0x02)
                Notify (\_SB.PCI0.BR27, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
            Method (_L0B, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.BR1E, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
            Method (_L08, 0, NotSerialized)
            {
                \_SB.PCI0.SBRG.SIOH ()
            }
            Method (_L1B, 0, NotSerialized)
            {
                \_SB.PCI0.SBRG.SIOH ()
            }
            Method (_L1C, 0, NotSerialized)
            {
                \_SB.PCI0.SBRG.SIOH ()
            }
            Method (_L0D, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.EUSB, 0x02)
                Notify (\_SB.PCI0.USBE, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
            Method (_L03, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB0, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
            Method (_L04, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB1, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
            Method (_L0C, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB2, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
            Method (_L0E, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB3, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
            Method (_L05, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB4, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
            Method (_L20, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB5, 0x02)
                Notify (\_SB.PCI0.USB8, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
            Method (_L25, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB6, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
        }
        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))
            Name (_UID, 0xAA)
            Name (_STA, 0x0B)
        }
    }
    Scope (_SB.PCI0.SBRG.ASOC)
    {
        Name (G0T3, Package (0x07)
        {
            0x00070005, 
            "New CPU Installed", 
            One, 
            Zero, 
            Zero, 
            One, 
            0x02
        })
        Name (G0TB, Package (0x07)
        {
            0x0006000B, 
            "System boot mode", 
            One, 
            Zero, 
            Zero, 
            One, 
            0x02
        })
        Name (GRP0, Package (0x02)
        {
            G0T3, 
            G0TB
        })
        Method (GIT0, 1, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, 0x05))
            {
                Store (GNVS (0x17B4), ASB1)
            }
            Else
            {
                If (LEqual (T_0, 0x0B))
                {
                    Store (GNVS (0x12C7), ASB1)
                }
                Else
                {
                    Store (Zero, ASB0)
                }
            }
        }
        Method (SIT0, 3, NotSerialized)
        {
            If (And (Arg2, 0xFFFF))
            {
                Name (T_0, Zero)
                Store (And (Arg0, 0xFFFF), T_0)
                If (LEqual (T_0, 0x05))
                {
                    SNVS (0x17B4, Arg1)
                    Store (0x03, ASB0)
                }
                Else
                {
                    Store (Zero, ASB0)
                }
            }
            Else
            {
                Store (0x03, ASB0)
            }
        }
        Method (GCPR, 0, NotSerialized)
        {
            Store (GNVS (0x8290), Local0)
            If (Local0)
            {
                Return (ShiftRight (Local0, One))
            }
            Else
            {
                Return (And (ShiftRight (GMAX (0xCE), 0x08), 0xFF))
            }
        }
        Method (GPRE, 1, Serialized)
        {
            Store (Arg0, PAR0)
            ISMI (0x7F)
            Return (PAR0)
        }
    }
    Scope (\)
    {
        Field (RAMW, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x24), 
            ECGP,   32
        }
        Field (RAMW, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x28), 
            DMFQ,   32
        }
        Field (RAMW, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x2C), 
            VIDI,   32
        }
        Field (RAMW, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x30), 
                    Offset (0x34)
        }
        Field (RAMW, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x34), 
                    Offset (0x38)
        }
        Field (RAMW, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x3C), 
            D4CR,   32
        }
    }
    Scope (_SB.PCI0.SBRG.ASOC)
    {
        Name (G3C0, Package (0x07)
        {
            0x03010011, 
            "BCLK Frequency", 
            Zero, 
            Zero, 
            0x1F40, 
            0x64, 
            0x01A5
        })
        Name (G3C1, Package (0x07)
        {
            0x03020012, 
            "CPU Voltage", 
            Zero, 
            Zero, 
            0xFE014C08, 
            0x0271, 
            0x89
        })
        Name (G3C2, Package (0x07)
        {
            0x03060013, 
            "CPU Ratio", 
            0x40000000, 
            Zero, 
            Zero, 
            One, 
            0x1C
        })
        Name (G3C5, Package (0x07)
        {
            0x030600F9, 
            "CPU rated ratio", 
            0x40000000, 
            Zero, 
            Zero, 
            One, 
            0x1C
        })
        Name (G3C3, Package (0x07)
        {
            0x03020015, 
            "IMC Voltage", 
            Zero, 
            Zero, 
            0xFE01ADB0, 
            0x0271, 
            0x39
        })
        Name (G3C4, Package (0x07)
        {
            0x03020016, 
            "CPU PLL", 
            Zero, 
            Zero, 
            0x0708, 
            0x32, 
            0x02
        })
        Name (G3D2, Package (0x07)
        {
            0x03020032, 
            "DRAM Bus Voltage", 
            Zero, 
            0x03, 
            0x05DC, 
            0x0F, 
            0x40
        })
        Name (G3S0, Package (0x07)
        {
            0x030200B1, 
            "PCH", 
            Zero, 
            Zero, 
            0xFE019A28, 
            0x0271, 
            0x0B
        })
        Name (G3DS, Package (0x07)
        {
            0x030600F0, 
            "Device Select", 
            0x40000000, 
            Zero, 
            Zero, 
            Zero, 
            Zero
        })
        Name (G3P0, Package (0x07)
        {
            0x03010060, 
            "iGPU Frequency", 
            0x40000000, 
            Zero, 
            0x3415, 
            0x0D05, 
            0x2A
        })
        Name (G3P1, Package (0x07)
        {
            0x03020061, 
            "iGPU Voltage", 
            0x40000000, 
            Zero, 
            0xFF001388, 
            0x7D, 
            0x65
        })
        Name (G3P3, Package (0x07)
        {
            0x03060063, 
            "iGPU State", 
            0x40000000, 
            Zero, 
            Zero, 
            One, 
            0x02
        })
        Name (G3P4, Package (0x07)
        {
            0x03080064, 
            "iGPU Mode", 
            0x40000000, 
            Zero, 
            0x02, 
            "MAX Performance", 
            "Max Battery Life"
        })
        Name (G3P5, Package (0x07)
        {
            0x03010065, 
            "iGPU NOS Frequency", 
            0x40000000, 
            Zero, 
            0x3415, 
            0x0D05, 
            0x2A
        })
        Name (GRP3, Package (0x0E)
        {
            G3C0, 
            G3C1, 
            G3C2, 
            G3C3, 
            G3C4, 
            G3C5, 
            G3D2, 
            G3S0, 
            G3DS, 
            G3P0, 
            G3P1, 
            G3P3, 
            G3P4, 
            G3P5
        })
        OperationRegion (IGDB, SystemMemory, 0xFED15100, 0x0100)
        Field (IGDB, ByteAcc, Lock, Preserve)
        {
                    Offset (0xBA), 
            GXBA,   8, 
            GXBB,   8
        }
        OperationRegion (GPS1, SystemIO, GPBS, 0x50)
        Field (GPS1, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x04), 
            GPSA,   8, 
            GPSB,   8, 
            GPSC,   8, 
            GPSD,   8, 
                    Offset (0x0C), 
            GPLA,   8, 
            GPLB,   8, 
            GPLC,   8, 
            GPLD,   8, 
                    Offset (0x34), 
            GPSE,   8, 
            GPSF,   8, 
            GPSG,   8, 
            GPSH,   8, 
            GPLE,   8, 
            GPLF,   8, 
            GPLG,   8, 
            GPLH,   8, 
                    Offset (0x44), 
            GPSI,   8, 
            GPSJ,   8, 
            GPSK,   8, 
            GPSL,   8, 
            GPLI,   8, 
            GPLJ,   8, 
            GPLK,   8, 
            GPLL,   8
        }
        Name (GODS, Zero)
        Name (TBRT, Buffer (0x08)
        {
            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        })
        Name (TBMK, Buffer (0x08)
        {
            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        })
        Name (RVCR, Zero)
        Name (BCLK, 0xFFFF)
        Name (CLKR, Buffer (0x0A)
        {
            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
            /* 0008 */    0x00, 0x00
        })
        Name (CLKB, Buffer (0x0A)
        {
            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
            /* 0008 */    0x00, 0x00
        })
        Method (GIT3, 1, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, 0x11))
            {
                If (LEqual (BCLK, 0xFFFF))
                {
                    If (LNotEqual (GNVS (0x348D), One))
                    {
                        Subtract (GNVS (0xA780), 0x50, BCLK)
                    }
                    Else
                    {
                        Subtract (0x85, 0x50, BCLK)
                    }
                }
                Store (BCLK, ASB1)
            }
            Else
            {
                If (LEqual (T_0, 0x12))
                {
                    Store (GCVV (), ASB1)
                }
                Else
                {
                    If (LEqual (T_0, 0x13))
                    {
                        If (And (ShiftRight (GMAX (0xCE), 0x1C), One))
                        {
                            If (LNotEqual (GODS, 0xFF))
                            {
                                If (LLess (GODS, 0x04))
                                {
                                    Store (GMAX (0x01AD), Local1)
                                }
                                Else
                                {
                                    Store (GMDX (0x01AD), Local1)
                                    Subtract (GODS, 0x04, GODS)
                                }
                                ShiftLeft (GODS, 0x03, Local5)
                                ShiftRight (Local1, Local5, Local0)
                                Subtract (And (Local0, 0xFF), DerefOf (Index (G3C2, 0x04)), 
                                    Local0)
                                Store (Local0, ASB1)
                            }
                        }
                        Else
                        {
                            Store (GCPR (), ASB1)
                        }
                    }
                    Else
                    {
                        If (LEqual (T_0, 0xF9))
                        {
                            Store (GCPR (), ASB1)
                        }
                        Else
                        {
                            If (LEqual (T_0, 0x15))
                            {
                                Store (RBYT (0x6A, 0x02), ASB1)
                            }
                            Else
                            {
                                If (LEqual (T_0, 0x16))
                                {
                                    Store (GCPV (), ASB1)
                                }
                                Else
                                {
                                    If (LEqual (T_0, 0x32))
                                    {
                                        Store (RBYT (0x6A, 0x03), ASB1)
                                        If (LGreaterEqual (ASB1, 0x40))
                                        {
                                            Store (Zero, ASB1)
                                        }
                                    }
                                    Else
                                    {
                                        If (LEqual (T_0, 0xB1))
                                        {
                                            Store (RBYT (0x6A, One), ASB1)
                                        }
                                        Else
                                        {
                                            If (LEqual (T_0, 0xF0)) {}
                                            Else
                                            {
                                                If (LEqual (T_0, 0x60))
                                                {
                                                    ISMI (0x84)
                                                    Store (PAR0, ASB1)
                                                }
                                                Else
                                                {
                                                    If (LEqual (T_0, 0x61))
                                                    {
                                                        ISMI (0x86)
                                                        Store (PAR0, ASB1)
                                                    }
                                                    Else
                                                    {
                                                        If (LEqual (T_0, 0x63))
                                                        {
                                                            Store (GXBA, Local0)
                                                            If (LEqual (And (Local0, 0xF0), 0x10))
                                                            {
                                                                Store (Zero, ASB1)
                                                            }
                                                            Else
                                                            {
                                                                Store (One, ASB1)
                                                            }
                                                        }
                                                        Else
                                                        {
                                                            If (LEqual (T_0, 0x64))
                                                            {
                                                                Store (GXBB, Local0)
                                                                ShiftRight (And (Local0, 0x40), 0x06, Local1)
                                                                Store (Local1, ASB1)
                                                            }
                                                            Else
                                                            {
                                                                If (LEqual (T_0, 0x65))
                                                                {
                                                                    Subtract (And (GPRE (0x104C), 0x3F), 0x04, Local0)
                                                                    Store (IMOD (Local0), ASB1)
                                                                }
                                                                Else
                                                                {
                                                                    Store (Zero, ASB0)
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Method (IMOD, 1, NotSerialized)
        {
            Store (Arg0, Local0)
            Store (GNVS (0x266C), Local2)
            If (LEqual (Local2, Zero))
            {
                Store (0x02, Local2)
            }
            If (LEqual (Local2, One))
            {
                Return (Local0)
            }
            Multiply (Add (Local0, 0x04), 0x85, Local0)
            If (LEqual (RBCK, Zero))
            {
                Subtract (GNVS (0xA780), 0x50, RBCK)
            }
            Divide (Local0, Add (RBCK, 0x50), Local1, Local0)
            Subtract (Local0, 0x04, Local0)
            Return (Local0)
        }
        Method (SIT3, 3, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, 0x11))
            {
                Store (Arg1, DBG8)
                Store (Arg1, BCLK)
                Store (Arg1, Local0)
                Store (RBLK (0xD2, Zero, 0x09), CLKR)
                CreateByteField (CLKR, One, CB01)
                CreateWordField (CLKR, 0x02, CBMN)
                CreateByteField (CLKR, 0x07, CB07)
                Multiply (Local0, 0x04, Local0)
                CreateWordField (MNBF, Local0, MNVL)
                Add (Local0, 0x02, Local0)
                CreateByteField (MNBF, Local0, NVL0)
                Store (RBLK (0xD2, 0x3C, 0x09), CLKB)
                CreateWordField (CLKB, Zero, CB60)
                Store (And (CB60, 0x7F), CB60)
                Store (Or (CB60, ShiftLeft (NVL0, 0x07)), CB60)
                WBLK (0xD2, 0x3C, 0x09, CLKB)
                Store (MNVL, CBMN)
                Add (Local0, One, Local0)
                CreateByteField (MNBF, Local0, CPUD)
                Store (CPUD, CB07)
                Store (Or (CB01, 0x80), CB01)
                WBLK (0xD2, Zero, 0x09, CLKR)
            }
            Else
            {
                If (LEqual (T_0, 0x12))
                {
                    SCVV (Arg1)
                }
                Else
                {
                    If (LEqual (T_0, 0x13))
                    {
                        If (And (ShiftRight (GMAX (0xCE), 0x1C), One))
                        {
                            If (And (Arg2, 0x03))
                            {
                                If (And (GMDX (0x0199), One))
                                {
                                    Store (0x99, DBG8)
                                }
                                Else
                                {
                                    If (LNotEqual (GODS, 0xFF))
                                    {
                                        Store (GNVS (0x82A0), Local0)
                                        Add (Local0, Arg1, Local0)
                                        Store (Local0, Index (TBRT, GODS))
                                        Store (0xFF, Index (TBMK, GODS))
                                    }
                                    Else
                                    {
                                        CreateDWordField (TBRT, Zero, TRAX)
                                        CreateDWordField (TBRT, 0x04, TRDX)
                                        CreateDWordField (TBMK, Zero, TRMA)
                                        CreateDWordField (TBMK, 0x04, TRMD)
                                        Store (GMAX (0x01AD), Local1)
                                        Store (GMDX (0x01AD), Local2)
                                        Or (And (Local1, Not (TRMA)), TRAX, Local1)
                                        Or (And (Local2, Not (TRMD)), TRDX, Local2)
                                        SMSR (0x01AD, Local1, Local2)
                                        Store (Zero, Local0)
                                        While (LLess (Local0, 0x08))
                                        {
                                            Store (Zero, Index (TBRT, Local0))
                                            Store (Zero, Index (TBMK, Local0))
                                            Increment (Local0)
                                        }
                                        If (LLessEqual (GNVS (0x82A0), And (GMAX (0x0199), 0xFF)))
                                        {
                                            Store (GMDX (0x01A0), Local3)
                                            And (Local3, 0xFFFFFFBF, Local3)
                                            SMSR (0x01A0, GMAX (0x01A0), Local3)
                                            Add (GNVS (0x82A0), One, Local2)
                                            Store (GMAX (0x0199), Local3)
                                            Or (And (Local3, 0xFFFFFF00), Local2, Local2)
                                            SMSR (0x0199, Local2, GMDX (0x0199))
                                        }
                                    }
                                }
                            }
                            If (And (Arg2, One))
                            {
                                SNVS (0x8290, ShiftLeft (Arg1, One))
                            }
                        }
                        Else
                        {
                            If (And (Arg2, One))
                            {
                                SNVS (0x8290, ShiftLeft (Arg1, One))
                            }
                        }
                    }
                    Else
                    {
                        If (LEqual (T_0, 0x15))
                        {
                            WBYT (0x6A, 0x02, Arg1)
                        }
                        Else
                        {
                            If (LEqual (T_0, 0x16))
                            {
                                SCPV (Arg1)
                            }
                            Else
                            {
                                If (LEqual (T_0, 0x32))
                                {
                                    WBYT (0x6A, 0x03, Arg1)
                                }
                                Else
                                {
                                    If (LEqual (T_0, 0xB1))
                                    {
                                        WBYT (0x6A, One, Arg1)
                                    }
                                    Else
                                    {
                                        If (LEqual (T_0, 0xF0))
                                        {
                                            Store (Arg1, GODS)
                                        }
                                        Else
                                        {
                                            If (LEqual (T_0, 0x60))
                                            {
                                                Store (Arg1, PAR0)
                                                ISMI (0x85)
                                            }
                                            Else
                                            {
                                                If (LEqual (T_0, 0x61))
                                                {
                                                    Store (Arg1, PAR0)
                                                    ISMI (0x87)
                                                }
                                                Else
                                                {
                                                    If (LEqual (T_0, 0x64))
                                                    {
                                                        Store (Arg1, Local0)
                                                        Store (GXBB, Local1)
                                                        And (Local1, 0xBF, Local1)
                                                        Or (Local1, ShiftLeft (Local0, 0x06), Local1)
                                                        Store (Local1, GXBB)
                                                    }
                                                    Else
                                                    {
                                                        Store (Zero, ASB0)
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Name (MNBF, Buffer (0x0694)
        {
            /* 0000 */    0x8A, 0x0C, 0x00, 0x61, 0x08, 0x0A, 0x01, 0x61, 
            /* 0008 */    0x48, 0x0A, 0x00, 0x61, 0x48, 0x0A, 0x01, 0x61, 
            /* 0010 */    0x0A, 0x0D, 0x01, 0x61, 0x88, 0x0A, 0x01, 0x61, 
            /* 0018 */    0xC8, 0x0A, 0x00, 0x61, 0xC8, 0x0A, 0x01, 0x61, 
            /* 0020 */    0xCA, 0x0D, 0x00, 0x61, 0x08, 0x0B, 0x01, 0x61, 
            /* 0028 */    0x48, 0x0B, 0x00, 0x61, 0x48, 0x0B, 0x01, 0x61, 
            /* 0030 */    0x4A, 0x0E, 0x01, 0x61, 0x88, 0x0B, 0x01, 0x61, 
            /* 0038 */    0xC8, 0x0B, 0x00, 0x61, 0xC8, 0x0B, 0x01, 0x61, 
            /* 0040 */    0x0A, 0x0F, 0x00, 0x61, 0x08, 0x0C, 0x01, 0x61, 
            /* 0048 */    0x48, 0x0C, 0x00, 0x61, 0x48, 0x0C, 0x01, 0x61, 
            /* 0050 */    0x8A, 0x0F, 0x01, 0x61, 0x88, 0x0C, 0x01, 0x61, 
            /* 0058 */    0xC8, 0x0C, 0x00, 0x61, 0xC8, 0x0C, 0x01, 0x61, 
            /* 0060 */    0x4A, 0x10, 0x00, 0x61, 0x08, 0x0D, 0x01, 0x61, 
            /* 0068 */    0x48, 0x0D, 0x00, 0x61, 0x48, 0x0D, 0x01, 0x61, 
            /* 0070 */    0xCA, 0x10, 0x01, 0x61, 0x88, 0x0D, 0x01, 0x61, 
            /* 0078 */    0xC8, 0x0D, 0x00, 0x61, 0xC8, 0x0D, 0x01, 0x61, 
            /* 0080 */    0x8A, 0x11, 0x00, 0x61, 0x08, 0x0E, 0x01, 0x61, 
            /* 0088 */    0x48, 0x0E, 0x00, 0x61, 0x48, 0x0E, 0x01, 0x61, 
            /* 0090 */    0x0A, 0x12, 0x01, 0x61, 0x88, 0x0E, 0x01, 0x61, 
            /* 0098 */    0xC8, 0x0E, 0x00, 0x61, 0xC8, 0x0E, 0x01, 0x61, 
            /* 00A0 */    0xCA, 0x12, 0x00, 0x61, 0x08, 0x0F, 0x01, 0x61, 
            /* 00A8 */    0x48, 0x0F, 0x00, 0x61, 0x48, 0x0F, 0x01, 0x61, 
            /* 00B0 */    0x4A, 0x13, 0x01, 0x61, 0x88, 0x0F, 0x01, 0x61, 
            /* 00B8 */    0xC8, 0x0F, 0x00, 0x61, 0xC8, 0x0F, 0x01, 0x61, 
            /* 00C0 */    0x0A, 0x14, 0x00, 0x61, 0x08, 0x10, 0x01, 0x61, 
            /* 00C8 */    0x48, 0x10, 0x00, 0x61, 0x48, 0x10, 0x01, 0x61, 
            /* 00D0 */    0x8A, 0x14, 0x01, 0x61, 0x89, 0x0C, 0x00, 0x60, 
            /* 00D8 */    0x46, 0x08, 0x01, 0x60, 0x48, 0x0B, 0x00, 0x60, 
            /* 00E0 */    0xC9, 0x0C, 0x00, 0x60, 0x07, 0x0A, 0x00, 0x60, 
            /* 00E8 */    0x4A, 0x0E, 0x01, 0x60, 0x07, 0x0A, 0x01, 0x60, 
            /* 00F0 */    0x09, 0x0D, 0x01, 0x60, 0xC8, 0x0B, 0x00, 0x60, 
            /* 00F8 */    0xC6, 0x08, 0x01, 0x60, 0xCA, 0x0E, 0x01, 0x60, 
            /* 0100 */    0x0A, 0x0F, 0x00, 0x60, 0x0A, 0x0F, 0x01, 0x60, 
            /* 0108 */    0x06, 0x09, 0x01, 0x60, 0x48, 0x0C, 0x00, 0x60, 
            /* 0110 */    0xC9, 0x0D, 0x01, 0x60, 0xC7, 0x0A, 0x01, 0x60, 
            /* 0118 */    0x8A, 0x0F, 0x01, 0x60, 0x07, 0x0B, 0x00, 0x60, 
            /* 0120 */    0x49, 0x0E, 0x00, 0x60, 0xC8, 0x0C, 0x00, 0x60, 
            /* 0128 */    0x86, 0x09, 0x01, 0x60, 0x0A, 0x10, 0x01, 0x60, 
            /* 0130 */    0x4A, 0x10, 0x00, 0x60, 0x4A, 0x10, 0x01, 0x60, 
            /* 0138 */    0xC6, 0x09, 0x01, 0x60, 0x48, 0x0D, 0x00, 0x60, 
            /* 0140 */    0x09, 0x0F, 0x00, 0x60, 0xC7, 0x0B, 0x00, 0x60, 
            /* 0148 */    0xCA, 0x10, 0x01, 0x60, 0xC7, 0x0B, 0x01, 0x60, 
            /* 0150 */    0x49, 0x0F, 0x01, 0x60, 0xC8, 0x0D, 0x00, 0x60, 
            /* 0158 */    0x46, 0x0A, 0x01, 0x60, 0x4A, 0x11, 0x01, 0x60, 
            /* 0160 */    0x8A, 0x11, 0x00, 0x60, 0x8A, 0x11, 0x01, 0x60, 
            /* 0168 */    0x86, 0x0A, 0x01, 0x60, 0x48, 0x0E, 0x00, 0x60, 
            /* 0170 */    0x09, 0x10, 0x01, 0x60, 0x87, 0x0C, 0x01, 0x60, 
            /* 0178 */    0x0A, 0x12, 0x01, 0x60, 0xC7, 0x0C, 0x00, 0x60, 
            /* 0180 */    0x89, 0x10, 0x00, 0x60, 0xC8, 0x0E, 0x00, 0x60, 
            /* 0188 */    0x06, 0x0B, 0x01, 0x60, 0x8A, 0x12, 0x01, 0x60, 
            /* 0190 */    0xCA, 0x12, 0x00, 0x60, 0xCA, 0x12, 0x01, 0x60, 
            /* 0198 */    0x46, 0x0B, 0x01, 0x60, 0x48, 0x0F, 0x00, 0x60, 
            /* 01A0 */    0x49, 0x11, 0x00, 0x60, 0x87, 0x0D, 0x00, 0x60, 
            /* 01A8 */    0x4A, 0x13, 0x01, 0x60, 0x87, 0x0D, 0x01, 0x60, 
            /* 01B0 */    0x89, 0x11, 0x01, 0x60, 0xC8, 0x0F, 0x00, 0x60, 
            /* 01B8 */    0xC6, 0x0B, 0x01, 0x60, 0xCA, 0x13, 0x01, 0x60, 
            /* 01C0 */    0x0A, 0x14, 0x00, 0x60, 0x0A, 0x14, 0x01, 0x60, 
            /* 01C8 */    0x06, 0x0C, 0x01, 0x60, 0x48, 0x10, 0x00, 0x60, 
            /* 01D0 */    0x49, 0x12, 0x01, 0x60, 0x47, 0x0E, 0x01, 0x60, 
            /* 01D8 */    0x8A, 0x14, 0x01, 0x60, 0x87, 0x0E, 0x00, 0x60, 
            /* 01E0 */    0xC9, 0x12, 0x00, 0x60, 0xC8, 0x10, 0x00, 0x60, 
            /* 01E8 */    0x86, 0x0C, 0x01, 0x60, 0x0A, 0x15, 0x01, 0x60, 
            /* 01F0 */    0x4A, 0x15, 0x00, 0x60, 0x4A, 0x15, 0x01, 0x60, 
            /* 01F8 */    0xC6, 0x0C, 0x01, 0x60, 0x48, 0x11, 0x00, 0x60, 
            /* 0200 */    0x89, 0x13, 0x00, 0x60, 0x47, 0x0F, 0x00, 0x60, 
            /* 0208 */    0xCA, 0x15, 0x01, 0x60, 0x47, 0x0F, 0x01, 0x60, 
            /* 0210 */    0xC9, 0x13, 0x01, 0x60, 0xC8, 0x11, 0x00, 0x60, 
            /* 0218 */    0x46, 0x0D, 0x01, 0x60, 0x4A, 0x16, 0x01, 0x60, 
            /* 0220 */    0x8A, 0x16, 0x00, 0x60, 0x8A, 0x16, 0x01, 0x60, 
            /* 0228 */    0x86, 0x0D, 0x01, 0x60, 0x48, 0x12, 0x00, 0x60, 
            /* 0230 */    0x89, 0x14, 0x01, 0x60, 0x07, 0x10, 0x01, 0x60, 
            /* 0238 */    0x0A, 0x17, 0x01, 0x60, 0x47, 0x10, 0x00, 0x60, 
            /* 0240 */    0x09, 0x15, 0x00, 0x60, 0xC8, 0x12, 0x00, 0x60, 
            /* 0248 */    0x06, 0x0E, 0x01, 0x60, 0x8A, 0x17, 0x01, 0x60, 
            /* 0250 */    0xCA, 0x17, 0x00, 0x60, 0xCA, 0x17, 0x01, 0x60, 
            /* 0258 */    0x46, 0x0E, 0x01, 0x60, 0x48, 0x13, 0x00, 0x60, 
            /* 0260 */    0xC9, 0x15, 0x00, 0x60, 0x07, 0x11, 0x00, 0x60, 
            /* 0268 */    0x4A, 0x18, 0x01, 0x60, 0x07, 0x11, 0x01, 0x60, 
            /* 0270 */    0x09, 0x16, 0x01, 0x60, 0xC8, 0x13, 0x00, 0x60, 
            /* 0278 */    0xC6, 0x0E, 0x01, 0x60, 0xCA, 0x18, 0x01, 0x60, 
            /* 0280 */    0x0A, 0x19, 0x00, 0x60, 0x0A, 0x19, 0x01, 0x60, 
            /* 0288 */    0x06, 0x0F, 0x01, 0x60, 0x48, 0x14, 0x00, 0x60, 
            /* 0290 */    0xC9, 0x16, 0x01, 0x60, 0xC7, 0x11, 0x01, 0x60, 
            /* 0298 */    0x8A, 0x19, 0x01, 0x60, 0x07, 0x12, 0x00, 0x60, 
            /* 02A0 */    0x49, 0x17, 0x00, 0x60, 0xC8, 0x14, 0x00, 0x60, 
            /* 02A8 */    0x86, 0x0F, 0x01, 0x60, 0x0A, 0x1A, 0x01, 0x60, 
            /* 02B0 */    0x4A, 0x1A, 0x00, 0x60, 0x4A, 0x1A, 0x01, 0x60, 
            /* 02B8 */    0xC6, 0x0F, 0x01, 0x60, 0x48, 0x15, 0x00, 0x60, 
            /* 02C0 */    0x09, 0x18, 0x00, 0x60, 0xC7, 0x12, 0x00, 0x60, 
            /* 02C8 */    0xCA, 0x1A, 0x01, 0x60, 0xC7, 0x12, 0x01, 0x60, 
            /* 02D0 */    0x49, 0x18, 0x01, 0x60, 0xC8, 0x15, 0x00, 0x60, 
            /* 02D8 */    0x46, 0x10, 0x01, 0x60, 0x4A, 0x1B, 0x01, 0x60, 
            /* 02E0 */    0x8A, 0x1B, 0x00, 0x60, 0x8A, 0x1B, 0x01, 0x60, 
            /* 02E8 */    0x86, 0x10, 0x01, 0x60, 0x48, 0x16, 0x00, 0x60, 
            /* 02F0 */    0x09, 0x19, 0x01, 0x60, 0x87, 0x13, 0x01, 0x60, 
            /* 02F8 */    0x0A, 0x1C, 0x01, 0x60, 0xC7, 0x13, 0x00, 0x60, 
            /* 0300 */    0x89, 0x19, 0x00, 0x60, 0xC8, 0x16, 0x00, 0x60, 
            /* 0308 */    0x06, 0x11, 0x01, 0x60, 0x8A, 0x1C, 0x01, 0x60, 
            /* 0310 */    0xCA, 0x1C, 0x00, 0x60, 0xCA, 0x1C, 0x01, 0x60, 
            /* 0318 */    0x46, 0x11, 0x01, 0x60, 0x48, 0x17, 0x00, 0x60, 
            /* 0320 */    0x49, 0x1A, 0x00, 0x60, 0x87, 0x14, 0x00, 0x60, 
            /* 0328 */    0x4A, 0x1D, 0x01, 0x60, 0x87, 0x14, 0x01, 0x60, 
            /* 0330 */    0x89, 0x1A, 0x01, 0x60, 0xC8, 0x17, 0x00, 0x60, 
            /* 0338 */    0xC6, 0x11, 0x01, 0x60, 0xCA, 0x1D, 0x01, 0x60, 
            /* 0340 */    0x0A, 0x1E, 0x00, 0x60, 0x0A, 0x1E, 0x01, 0x60, 
            /* 0348 */    0x06, 0x12, 0x01, 0x60, 0x48, 0x18, 0x00, 0x60, 
            /* 0350 */    0x49, 0x1B, 0x01, 0x60, 0x47, 0x15, 0x01, 0x60, 
            /* 0358 */    0x8A, 0x1E, 0x01, 0x60, 0x87, 0x15, 0x00, 0x60, 
            /* 0360 */    0xC9, 0x1B, 0x00, 0x60, 0xC8, 0x18, 0x00, 0x60, 
            /* 0368 */    0x86, 0x12, 0x01, 0x60, 0x0A, 0x1F, 0x01, 0x60, 
            /* 0370 */    0x4A, 0x1F, 0x00, 0x60, 0x4A, 0x1F, 0x01, 0x60, 
            /* 0378 */    0xC6, 0x12, 0x01, 0x60, 0x48, 0x19, 0x00, 0x60, 
            /* 0380 */    0x89, 0x1C, 0x00, 0x60, 0x47, 0x16, 0x00, 0x60, 
            /* 0388 */    0xCA, 0x1F, 0x01, 0x60, 0x47, 0x16, 0x01, 0x60, 
            /* 0390 */    0xC9, 0x1C, 0x01, 0x60, 0xC8, 0x19, 0x00, 0x60, 
            /* 0398 */    0x46, 0x13, 0x01, 0x60, 0x4A, 0x20, 0x01, 0x60, 
            /* 03A0 */    0x8A, 0x20, 0x00, 0x60, 0x8A, 0x20, 0x01, 0x60, 
            /* 03A8 */    0x86, 0x13, 0x01, 0x60, 0x48, 0x1A, 0x00, 0x60, 
            /* 03B0 */    0x89, 0x1D, 0x01, 0x60, 0x07, 0x17, 0x01, 0x60, 
            /* 03B8 */    0x0A, 0x21, 0x01, 0x60, 0x47, 0x17, 0x00, 0x60, 
            /* 03C0 */    0x09, 0x1E, 0x00, 0x60, 0xC8, 0x1A, 0x00, 0x60, 
            /* 03C8 */    0x06, 0x14, 0x01, 0x60, 0x8A, 0x21, 0x01, 0x60, 
            /* 03D0 */    0xCA, 0x21, 0x00, 0x60, 0xCA, 0x21, 0x01, 0x60, 
            /* 03D8 */    0x46, 0x14, 0x01, 0x60, 0x48, 0x1B, 0x00, 0x60, 
            /* 03E0 */    0xC9, 0x1E, 0x00, 0x60, 0x07, 0x18, 0x00, 0x60, 
            /* 03E8 */    0x4A, 0x22, 0x01, 0x60, 0x07, 0x18, 0x01, 0x60, 
            /* 03F0 */    0x09, 0x1F, 0x01, 0x60, 0xC8, 0x1B, 0x00, 0x60, 
            /* 03F8 */    0xC6, 0x14, 0x01, 0x60, 0xCA, 0x22, 0x01, 0x60, 
            /* 0400 */    0x0A, 0x23, 0x00, 0x60, 0x0A, 0x23, 0x01, 0x60, 
            /* 0408 */    0x06, 0x15, 0x01, 0x60, 0x48, 0x1C, 0x00, 0x60, 
            /* 0410 */    0xC9, 0x1F, 0x01, 0x60, 0xC7, 0x18, 0x01, 0x60, 
            /* 0418 */    0x8A, 0x23, 0x01, 0x60, 0x07, 0x19, 0x00, 0x60, 
            /* 0420 */    0x49, 0x20, 0x00, 0x60, 0xC8, 0x1C, 0x00, 0x60, 
            /* 0428 */    0x86, 0x15, 0x01, 0x60, 0x0A, 0x24, 0x01, 0x60, 
            /* 0430 */    0x4A, 0x24, 0x00, 0x60, 0x4A, 0x24, 0x01, 0x60, 
            /* 0438 */    0xC6, 0x15, 0x01, 0x60, 0x48, 0x1D, 0x00, 0x60, 
            /* 0440 */    0x09, 0x21, 0x00, 0x60, 0xC7, 0x19, 0x00, 0x60, 
            /* 0448 */    0xCA, 0x24, 0x01, 0x60, 0xC7, 0x19, 0x01, 0x60, 
            /* 0450 */    0x49, 0x21, 0x01, 0x60, 0xC8, 0x1D, 0x00, 0x60, 
            /* 0458 */    0x46, 0x16, 0x01, 0x60, 0x4A, 0x25, 0x01, 0x60, 
            /* 0460 */    0x8A, 0x25, 0x00, 0x60, 0x8A, 0x25, 0x01, 0x60, 
            /* 0468 */    0x86, 0x16, 0x01, 0x60, 0x48, 0x1E, 0x00, 0x60, 
            /* 0470 */    0x09, 0x22, 0x01, 0x60, 0x87, 0x1A, 0x01, 0x60, 
            /* 0478 */    0x0A, 0x26, 0x01, 0x60, 0xC7, 0x1A, 0x00, 0x60, 
            /* 0480 */    0x89, 0x22, 0x00, 0x60, 0xC8, 0x1E, 0x00, 0x60, 
            /* 0488 */    0x06, 0x17, 0x01, 0x60, 0x8A, 0x26, 0x01, 0x60, 
            /* 0490 */    0xCA, 0x26, 0x00, 0x60, 0xCA, 0x26, 0x01, 0x60, 
            /* 0498 */    0x46, 0x17, 0x01, 0x60, 0x48, 0x1F, 0x00, 0x60, 
            /* 04A0 */    0x49, 0x23, 0x00, 0x60, 0x87, 0x1B, 0x00, 0x60, 
            /* 04A8 */    0x4A, 0x27, 0x01, 0x60, 0x87, 0x1B, 0x01, 0x60, 
            /* 04B0 */    0x89, 0x23, 0x01, 0x60, 0xC8, 0x1F, 0x00, 0x60, 
            /* 04B8 */    0xC6, 0x17, 0x01, 0x60, 0xCA, 0x27, 0x01, 0x60, 
            /* 04C0 */    0x0A, 0x28, 0x00, 0x60, 0x0A, 0x28, 0x01, 0x60, 
            /* 04C8 */    0x06, 0x18, 0x01, 0x60, 0x48, 0x20, 0x00, 0x60, 
            /* 04D0 */    0x49, 0x24, 0x01, 0x60, 0x47, 0x1C, 0x01, 0x60, 
            /* 04D8 */    0x8A, 0x28, 0x01, 0x60, 0x87, 0x1C, 0x00, 0x60, 
            /* 04E0 */    0xC9, 0x24, 0x00, 0x60, 0xC8, 0x20, 0x00, 0x60, 
            /* 04E8 */    0x86, 0x18, 0x01, 0x60, 0x0A, 0x29, 0x01, 0x60, 
            /* 04F0 */    0x4A, 0x29, 0x00, 0x60, 0x4A, 0x29, 0x01, 0x60, 
            /* 04F8 */    0xC6, 0x18, 0x01, 0x60, 0x48, 0x21, 0x00, 0x60, 
            /* 0500 */    0x89, 0x25, 0x00, 0x60, 0x47, 0x1D, 0x00, 0x60, 
            /* 0508 */    0xCA, 0x29, 0x01, 0x60, 0x47, 0x1D, 0x01, 0x60, 
            /* 0510 */    0xC9, 0x25, 0x01, 0x60, 0xC8, 0x21, 0x00, 0x60, 
            /* 0518 */    0x46, 0x19, 0x01, 0x60, 0x4A, 0x2A, 0x01, 0x60, 
            /* 0520 */    0x8A, 0x2A, 0x00, 0x60, 0x8A, 0x2A, 0x01, 0x60, 
            /* 0528 */    0x86, 0x19, 0x01, 0x60, 0x48, 0x22, 0x00, 0x60, 
            /* 0530 */    0x89, 0x26, 0x01, 0x60, 0x07, 0x1E, 0x01, 0x60, 
            /* 0538 */    0x0A, 0x2B, 0x01, 0x60, 0x47, 0x1E, 0x00, 0x60, 
            /* 0540 */    0x09, 0x27, 0x00, 0x60, 0xC8, 0x22, 0x00, 0x60, 
            /* 0548 */    0x06, 0x1A, 0x01, 0x60, 0x8A, 0x2B, 0x01, 0x60, 
            /* 0550 */    0xCA, 0x2B, 0x00, 0x60, 0xCA, 0x2B, 0x01, 0x60, 
            /* 0558 */    0x46, 0x1A, 0x01, 0x60, 0x48, 0x23, 0x00, 0x60, 
            /* 0560 */    0xC9, 0x27, 0x00, 0x60, 0x07, 0x1F, 0x00, 0x60, 
            /* 0568 */    0x4A, 0x2C, 0x01, 0x60, 0x07, 0x1F, 0x01, 0x60, 
            /* 0570 */    0x09, 0x28, 0x01, 0x60, 0xC8, 0x23, 0x00, 0x60, 
            /* 0578 */    0xC6, 0x1A, 0x01, 0x60, 0xCA, 0x2C, 0x01, 0x60, 
            /* 0580 */    0x0A, 0x2D, 0x00, 0x60, 0x0A, 0x2D, 0x01, 0x60, 
            /* 0588 */    0x06, 0x1B, 0x01, 0x60, 0x48, 0x24, 0x00, 0x60, 
            /* 0590 */    0xC9, 0x28, 0x01, 0x60, 0xC7, 0x1F, 0x01, 0x60, 
            /* 0598 */    0x8A, 0x2D, 0x01, 0x60, 0x07, 0x20, 0x00, 0x60, 
            /* 05A0 */    0x49, 0x29, 0x00, 0x60, 0xC8, 0x24, 0x00, 0x60, 
            /* 05A8 */    0x86, 0x1B, 0x01, 0x60, 0x0A, 0x2E, 0x01, 0x60, 
            /* 05B0 */    0x4A, 0x2E, 0x00, 0x60, 0x4A, 0x2E, 0x01, 0x60, 
            /* 05B8 */    0xC6, 0x1B, 0x01, 0x60, 0x48, 0x25, 0x00, 0x60, 
            /* 05C0 */    0x09, 0x2A, 0x00, 0x60, 0xC7, 0x20, 0x00, 0x60, 
            /* 05C8 */    0xCA, 0x2E, 0x01, 0x60, 0xC7, 0x20, 0x01, 0x60, 
            /* 05D0 */    0x49, 0x2A, 0x01, 0x60, 0xC8, 0x25, 0x00, 0x60, 
            /* 05D8 */    0x46, 0x1C, 0x01, 0x60, 0x4A, 0x2F, 0x01, 0x60, 
            /* 05E0 */    0x8A, 0x2F, 0x00, 0x60, 0x8A, 0x2F, 0x01, 0x60, 
            /* 05E8 */    0x86, 0x1C, 0x01, 0x60, 0x48, 0x26, 0x00, 0x60, 
            /* 05F0 */    0x09, 0x2B, 0x01, 0x60, 0x87, 0x21, 0x01, 0x60, 
            /* 05F8 */    0x0A, 0x30, 0x01, 0x60, 0xC7, 0x21, 0x00, 0x60, 
            /* 0600 */    0x89, 0x2B, 0x00, 0x60, 0xC8, 0x26, 0x00, 0x60, 
            /* 0608 */    0x06, 0x1D, 0x01, 0x60, 0x8A, 0x30, 0x01, 0x60, 
            /* 0610 */    0xCA, 0x30, 0x00, 0x60, 0xCA, 0x30, 0x01, 0x60, 
            /* 0618 */    0x46, 0x1D, 0x01, 0x60, 0x48, 0x27, 0x00, 0x60, 
            /* 0620 */    0x49, 0x2C, 0x00, 0x60, 0x87, 0x22, 0x00, 0x60, 
            /* 0628 */    0x4A, 0x31, 0x01, 0x60, 0x87, 0x22, 0x01, 0x60, 
            /* 0630 */    0x89, 0x2C, 0x01, 0x60, 0xC8, 0x27, 0x00, 0x60, 
            /* 0638 */    0xC6, 0x1D, 0x01, 0x60, 0xCA, 0x31, 0x01, 0x60, 
            /* 0640 */    0x0A, 0x32, 0x00, 0x60, 0x0A, 0x32, 0x01, 0x60, 
            /* 0648 */    0x06, 0x1E, 0x01, 0x60, 0x48, 0x28, 0x00, 0x60, 
            /* 0650 */    0x49, 0x2D, 0x01, 0x60, 0x47, 0x23, 0x01, 0x60, 
            /* 0658 */    0x8A, 0x32, 0x01, 0x60, 0x87, 0x23, 0x00, 0x60, 
            /* 0660 */    0xC9, 0x2D, 0x00, 0x60, 0xC8, 0x28, 0x00, 0x60, 
            /* 0668 */    0x86, 0x1E, 0x01, 0x60, 0x0A, 0x33, 0x01, 0x60, 
            /* 0670 */    0x4A, 0x33, 0x00, 0x60, 0x4A, 0x33, 0x01, 0x60, 
            /* 0678 */    0xC6, 0x1E, 0x01, 0x60, 0x48, 0x29, 0x00, 0x60, 
            /* 0680 */    0x89, 0x2E, 0x00, 0x60, 0x47, 0x24, 0x00, 0x60, 
            /* 0688 */    0xCA, 0x33, 0x01, 0x60, 0x47, 0x24, 0x01, 0x60, 
            /* 0690 */    0xC9, 0x2E, 0x01, 0x60
        })
        Method (GSGP, 1, NotSerialized)
        {
            Divide (Arg0, 0x0A, Local0, Local1)
            Name (T_0, Zero)
            Store (Local1, T_0)
            If (LEqual (T_0, 0x05))
            {
                ENFG (0x09)
                And (ShiftRight (OPT5, Local0), One, Local0)
            }
            EXFG ()
            Return (Local0)
        }
        Method (SSGP, 2, NotSerialized)
        {
            Divide (Arg0, 0x0A, Local0, Local1)
            ShiftLeft (One, Local0, Local0)
            Name (T_0, Zero)
            Store (Local1, T_0)
            If (LEqual (T_0, 0x05))
            {
                ENFG (0x09)
                If (LEqual (Arg1, Zero))
                {
                    And (OPT5, Not (Local0), OPT5)
                }
                Else
                {
                    Or (OPT5, Local0, OPT5)
                }
            }
            EXFG ()
            DY40 ()
        }
        OperationRegion (DLYP, SystemIO, 0xE1, One)
        Field (DLYP, ByteAcc, NoLock, Preserve)
        {
            DELY,   8
        }
        Method (DY40, 0, NotSerialized)
        {
            Store (0x80, Local0)
            While (Local0)
            {
                Store (0xFF, DELY)
                Decrement (Local0)
            }
        }
        Method (GCPV, 0, NotSerialized)
        {
            Return (XOr (GSGP (0x32), One))
        }
        Method (SCPV, 1, NotSerialized)
        {
            SSGP (0x32, XOr (And (Arg0, One), One))
            Return (One)
        }
        Method (GCVV, 0, NotSerialized)
        {
            Return (And (0x7FFFFFFF, RVCR))
        }
        Method (DOJP, 1, NotSerialized)
        {
            Store (Arg0, Local0)
            If (LGreater (Local0, 0x78))
            {
                Subtract (Local0, 0x10, Local0)
                WBYT (0x60, 0x03, 0x0A)
            }
            Else
            {
                WBYT (0x60, 0x03, Zero)
            }
            ENFG (0x0D)
            Return (Local0)
        }
        Method (SCVV, 1, NotSerialized)
        {
            Store (Or (Arg0, 0x80000000), RVCR)
            ENFG (0x0D)
            Store (And (CRE4, 0xC0), Local0)
            If (LEqual (Local0, Zero))
            {
                If (LEqual (GNVS (0x176D), Zero))
                {
                    Store (DOJP (Arg0), Local0)
                    Subtract (Local0, DerefOf (Index (G3C1, 0x03)), CRE1)
                    Or (0x40, CRE4, CRE4)
                }
                Else
                {
                    Store (DOJP (Arg0), Local0)
                    Subtract (0x7A, Local0, CRE0)
                    Or (0x80, CRE4, CRE4)
                }
            }
            Else
            {
                If (LEqual (Local0, 0x40))
                {
                    Store (DOJP (Arg0), Local0)
                    Subtract (Local0, DerefOf (Index (G3C1, 0x03)), CRE1)
                }
                Else
                {
                    If (LEqual (Local0, 0x80))
                    {
                        Store (DOJP (Arg0), Local0)
                        Subtract (0x7A, Local0, CRE0)
                    }
                }
            }
            EXFG ()
            Return (One)
        }
        Name (RBCK, Zero)
    }
    Scope (_SB.PCI0.SBRG.ASOC)
    {
        Name (G4T0, Package (0x04)
        {
            0x04070010, 
            "CPU Q-FAN Control", 
            0x80000000, 
            Zero
        })
        Name (G4T1, Package (0x08)
        {
            0x04080011, 
            "CPU Q-FAN Profile", 
            0x00100001, 
            Zero, 
            0x03, 
            "Standard", 
            "Silent", 
            "Turbo"
        })
        Name (GRP4, Package (0x02)
        {
            G4T0, 
            G4T1
        })
        Method (GIT4, 1, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, 0x10))
            {
                Store (GNVS (0x174E), ASB1)
            }
            Else
            {
                If (LEqual (T_0, 0x11))
                {
                    Store (GNVS (0x2696), ASB1)
                }
                Else
                {
                    If (LEqual (T_0, 0x17))
                    {
                        Store (0x3C, ASB1)
                    }
                    Else
                    {
                        If (LEqual (T_0, 0x70))
                        {
                            Store (GNVS (0x1750), ASB1)
                        }
                        Else
                        {
                            If (LEqual (T_0, 0x71))
                            {
                                Store (GNVS (0x26A0), ASB1)
                            }
                            Else
                            {
                                Store (Zero, ASB0)
                            }
                        }
                    }
                }
            }
        }
        Method (SIT4, 3, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, 0x10))
            {
                If (LNotEqual (GNVS (0x174E), Arg1))
                {
                    If (And (Arg2, One))
                    {
                        SNVS (0x174E, Arg1)
                    }
                    Or (ASB0, 0x02, ASB0)
                }
            }
            Else
            {
                If (LEqual (T_0, 0x11))
                {
                    If (LNotEqual (GNVS (0x2696), Arg1))
                    {
                        If (And (Arg2, One))
                        {
                            SNVS (0x2696, Arg1)
                        }
                        Or (ASB0, 0x02, ASB0)
                    }
                }
                Else
                {
                    If (LEqual (T_0, 0x70))
                    {
                        If (LNotEqual (GNVS (0x1750), Arg1))
                        {
                            If (And (Arg2, One))
                            {
                                SNVS (0x1750, Arg1)
                            }
                            Or (ASB0, 0x02, ASB0)
                        }
                    }
                    Else
                    {
                        If (LEqual (T_0, 0x71))
                        {
                            If (LNotEqual (GNVS (0x26A0), Arg1))
                            {
                                If (And (Arg2, One))
                                {
                                    SNVS (0x26A0, Arg1)
                                }
                                Or (ASB0, 0x02, ASB0)
                            }
                        }
                        Else
                        {
                            Store (Zero, ASB0)
                        }
                    }
                }
            }
        }
    }
    Scope (_SB.PCI0.SBRG.ASOC)
    {
        Name (G5T2, Package (0x08)
        {
            0x05080002, 
            "AI Profile", 
            Zero, 
            Zero, 
            0x03, 
            "Performance", 
            "Superior", 
            "Ultimate"
        })
        Name (G5P0, Package (0x07)
        {
            0x05080060, 
            "IGD Link Mode", 
            Zero, 
            Zero, 
            0x03, 
            "Auto", 
            Zero
        })
        Name (GRP5, Package (0x02)
        {
            G5T2, 
            G5P0
        })
        Name (OBID, Zero)
        Name (BUF6, Package (0x06)
        {
            0x03010011, 
            Ones, 
            0x03010060, 
            Ones, 
            0x03020061, 
            Ones
        })
        Method (GIT5, 2, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, 0x02))
            {
                UDBF (Arg1)
                MVBF (Arg1)
                Store (0x05, ASB1)
            }
            Else
            {
                If (LEqual (T_0, 0x60))
                {
                    IGBF (Arg1)
                    Store (0x05, ASB1)
                }
                Else
                {
                    Store (Zero, ASB0)
                }
            }
        }
        Method (SIT5, 3, NotSerialized)
        {
            Store (Zero, ASB0)
        }
        Method (IGFV, 2, NotSerialized)
        {
            Store (Arg0, Local0)
            Name (T_0, Zero)
            Store (Arg1, T_0)
            If (LEqual (T_0, Zero))
            {
                Store (GNVS (0xA780), Local3)
                Store (GNVS (0x266C), Local4)
                If (LEqual (Local4, Zero))
                {
                    Store (0x02, Local4)
                }
                If (LEqual (Local4, 0x02))
                {
                    Store (0x85, Local3)
                }
                Multiply (Add (Local0, 0x04), Local3, Local0)
                Divide (Local0, 0x85, Local1, Local0)
                Subtract (Local0, 0x04, Local0)
            }
            Else
            {
                If (LEqual (T_0, One))
                {
                    Store (GNVS (0xA780), Local3)
                    Multiply (Add (Local0, 0x04), Local3, Local0)
                    Divide (Local0, 0x85, Local1, Local0)
                    Subtract (Local0, 0x04, Local0)
                }
                Else
                {
                }
            }
            Store (Zero, Local1)
            While (LGreater (Local0, DerefOf (Index (IBUF, Local1))))
            {
                Add (Local1, 0x02, Local1)
            }
            Add (Local1, One, Local1)
            Store (DerefOf (Index (IBUF, Local1)), Local2)
            Return (Local2)
        }
        Method (IGBF, 1, NotSerialized)
        {
            Store (0x08, OBID)
            BOBF (OBID, 0x03020061)
            Add (OBID, 0x04, OBID)
            BOBF (OBID, IGFV (Arg0, One))
            Add (OBID, 0x04, OBID)
            BOBF (OBID, Ones)
        }
        Name (IBUF, Buffer (0x1E)
        {
            /* 0000 */    0x12, 0x34, 0x13, 0x36, 0x14, 0x38, 0x15, 0x39, 
            /* 0008 */    0x16, 0x3C, 0x17, 0x3F, 0x18, 0x42, 0x19, 0x46, 
            /* 0010 */    0x1A, 0x4A, 0x1B, 0x4E, 0x1C, 0x58, 0x1D, 0x58, 
            /* 0018 */    0x1E, 0x63, 0x1F, 0x63, 0xFF, 0x63
        })
        Method (BOBF, 2, NotSerialized)
        {
            Store (Arg1, Local0)
            Store (Arg0, Local1)
            Store (Local0, Index (ASBF, Local1))
            ShiftRight (Local0, 0x08, Local0)
            Add (Local1, One, Local1)
            Store (Local0, Index (ASBF, Local1))
            ShiftRight (Local0, 0x08, Local0)
            Add (Local1, One, Local1)
            Store (Local0, Index (ASBF, Local1))
            ShiftRight (Local0, 0x08, Local0)
            Add (Local1, One, Local1)
            Store (Local0, Index (ASBF, Local1))
        }
        Method (UDBF, 1, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, Zero))
            {
                Store (0x36, Index (BUF6, One))
                Store (IMOD (0x19), Index (BUF6, 0x03))
                Store (IGFV (0x19, Zero), Index (BUF6, 0x05))
            }
            Else
            {
                If (LEqual (T_0, One))
                {
                    Store (0x39, Index (BUF6, One))
                    Store (IMOD (0x1A), Index (BUF6, 0x03))
                    Store (IGFV (0x1A, Zero), Index (BUF6, 0x05))
                }
                Else
                {
                    If (LEqual (T_0, 0x02))
                    {
                        Store (0x3C, Index (BUF6, One))
                        Store (IMOD (0x1B), Index (BUF6, 0x03))
                        Store (IGFV (0x1B, Zero), Index (BUF6, 0x05))
                    }
                }
            }
        }
        Method (MVBF, 1, NotSerialized)
        {
            Store (Zero, Local0)
            Store (0x08, Local2)
            Store (SizeOf (BUF6), Local3)
            While (LNotEqual (Local0, Local3))
            {
                Add (Local0, One, Local1)
                If (LNotEqual (DerefOf (Index (BUF6, Local1)), Ones))
                {
                    STBF (DerefOf (Index (BUF6, Local0)), Local2)
                    Add (Local2, 0x04, Local2)
                    STBF (DerefOf (Index (BUF6, Local1)), Local2)
                    Add (Local2, 0x04, Local2)
                }
                STBF (Ones, Local2)
                Add (Local0, 0x02, Local0)
            }
        }
        Method (STBF, 2, NotSerialized)
        {
            Store (Arg0, Local0)
            Store (Arg1, Local1)
            Store (Zero, Local2)
            While (LNotEqual (Local2, 0x20))
            {
                Store (ShiftRight (Local0, Local2), Index (ASBF, Local1))
                Add (Local2, 0x08, Local2)
                Add (Local1, One, Local1)
            }
        }
    }
    Scope (_SB.PCI0.SBRG.ASOC)
    {
        Name (G611, Package (0x07)
        {
            0x06020011, 
            "Vcore Voltage", 
            0x20000000, 
            Zero, 
            0x0320, 
            0x0320, 
            0x02
        })
        Name (G663, Package (0x07)
        {
            0x06020063, 
            "+3.3V Voltage", 
            0x20000000, 
            Zero, 
            0x0B9A, 
            0x0294, 
            0x02
        })
        Name (G662, Package (0x07)
        {
            0x06020062, 
            "+5V Voltage", 
            0x20000000, 
            Zero, 
            0x1194, 
            0x03E8, 
            0x02
        })
        Name (G661, Package (0x07)
        {
            0x06020061, 
            "+12V Voltage", 
            0x20000000, 
            Zero, 
            0x27D8, 
            0x0E10, 
            0x02
        })
        Name (G612, Package (0x07)
        {
            0x06030012, 
            "CPU Temperature", 
            0x20000000, 
            Zero, 
            0x01C2, 
            0x05, 
            0x3D
        })
        Name (G614, Package (0x07)
        {
            0x06030014, 
            "MB Temperature", 
            0x20000000, 
            Zero, 
            0x01C2, 
            0x0A, 
            0x1F
        })
        Name (G613, Package (0x07)
        {
            0x06040013, 
            "CPU Fan Speed", 
            0x20000000, 
            Zero, 
            0xC8, 
            0x1B58, 
            0x02
        })
        Name (G673, Package (0x07)
        {
            0x06040073, 
            "Chassis Fan Speed", 
            0x20000000, 
            Zero, 
            0xC8, 
            0x1B58, 
            0x02
        })
        Name (GRP6, Package (0x08)
        {
            G611, 
            G663, 
            G662, 
            G661, 
            G612, 
            G614, 
            G613, 
            G673
        })
        Method (GIT6, 1, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, 0x11))
            {
                Store (RVLT (Zero), ASB1)
            }
            Else
            {
                If (LEqual (T_0, 0x63))
                {
                    Store (RVLT (One), ASB1)
                }
                Else
                {
                    If (LEqual (T_0, 0x62))
                    {
                        Store (RVLT (0x02), ASB1)
                    }
                    Else
                    {
                        If (LEqual (T_0, 0x61))
                        {
                            Store (RVLT (0x03), ASB1)
                        }
                        Else
                        {
                            If (LEqual (T_0, 0x12))
                            {
                                Store (^^SIOR.HWT1 (), ASB1)
                            }
                            Else
                            {
                                If (LEqual (T_0, 0x14))
                                {
                                    Store (^^SIOR.HWT0 (), ASB1)
                                }
                                Else
                                {
                                    If (LEqual (T_0, 0x13))
                                    {
                                        Store (^^SIOR.HWF1 (), ASB1)
                                    }
                                    Else
                                    {
                                        If (LEqual (T_0, 0x73))
                                        {
                                            Store (^^SIOR.HWF0 (), ASB1)
                                        }
                                        Else
                                        {
                                            Store (Zero, ASB0)
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Method (SIT6, 3, NotSerialized)
        {
        }
    }
    Scope (_SB.PCI0.SBRG.ASOC)
    {
        Name (G9T0, Package (0x0B)
        {
            0x09080000, 
            "AI Overclocking", 
            Zero, 
            One, 
            0x06, 
            "Manual", 
            "Auto", 
            "Standard", 
            Zero, 
            "N.O.S.", 
            Zero
        })
        Name (GRP9, Package (0x01)
        {
            G9T0
        })
        Method (GIT9, 1, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, Zero))
            {
                Store (GNVS (0x348D), ASB1)
            }
            Else
            {
                Store (Zero, ASB0)
            }
        }
        Method (SIT9, 3, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, Zero))
            {
                If (LNotEqual (GNVS (0x348D), Arg1))
                {
                    If (And (Arg2, One))
                    {
                        If (LEqual (Arg1, One))
                        {
                            SNVS (0xA780, 0x85)
                        }
                        SNVS (0x348D, Arg1)
                    }
                    Or (ASB0, 0x02, ASB0)
                }
            }
            Else
            {
                Store (Zero, ASB0)
            }
        }
    }
    Scope (_SB.PCI0.SBRG.ASOC)
    {
        Name (GBT0, Package (0x07)
        {
            0x0B060001, 
            "System Performance", 
            Zero, 
            Zero, 
            0x03, 
            One, 
            0x04
        })
        Name (GBT1, Package (0x07)
        {
            0x0B060002, 
            "System Performance Control", 
            Zero, 
            Zero, 
            Zero, 
            Zero, 
            Zero
        })
        Name (GBT2, Package (0x07)
        {
            0x0B060003, 
            "System GUI", 
            0x08, 
            Zero, 
            Zero, 
            Zero, 
            Zero
        })
        Name (GBT5, Package (0x07)
        {
            0x0B060010, 
            "Level Switch", 
            Zero, 
            Zero, 
            Zero, 
            Zero, 
            Zero
        })
        Name (GBT8, Package (0x07)
        {
            0x0B060022, 
            "AI Gear load line select", 
            Zero, 
            Zero, 
            Zero, 
            One, 
            0x02
        })
        Name (GBT9, Package (0x07)
        {
            0x0B060023, 
            "AI Gear CPU voltage", 
            Zero, 
            Zero, 
            Zero, 
            One, 
            0x02
        })
        Name (GBTA, Package (0x07)
        {
            0x0B060080, 
            "EPU Chip", 
            0x7000, 
            Zero, 
            Zero, 
            Zero, 
            Zero
        })
        Name (GRPB, Package (0x07)
        {
            GBT0, 
            GBT1, 
            GBT2, 
            GBT5, 
            GBT8, 
            GBT9, 
            GBTA
        })
        Method (GITB, 1, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, One))
            {
                Store (And (DerefOf (Index (GBT0, 0x02)), 0xFFFF), ASB1)
            }
            Else
            {
                If (LEqual (T_0, 0x02))
                {
                    Store (DerefOf (Index (GBT1, 0x02)), ASB1)
                }
                Else
                {
                    If (LEqual (T_0, 0x03))
                    {
                        Store (DerefOf (Index (GBT2, 0x02)), ASB1)
                    }
                    Else
                    {
                        If (LEqual (T_0, 0x80))
                        {
                            Store (0x7000, ASB1)
                        }
                        Else
                        {
                            If (LEqual (T_0, 0x22))
                            {
                                Store (GDEF (0x04), ASB1)
                            }
                            Else
                            {
                                If (LEqual (T_0, 0x23))
                                {
                                    Store (GDEF (0x02), ASB1)
                                }
                                Else
                                {
                                    Store (Zero, ASB0)
                                }
                            }
                        }
                    }
                }
            }
        }
        Method (SITB, 3, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, One))
            {
                Name (T_1, Zero)
                Store (And (Arg2, 0xFFFF), T_1)
                If (LEqual (T_1, Zero))
                {
                    Store (And (DerefOf (Index (GBT0, 0x02)), 0xFFFF), Local0)
                    If (LEqual (Local0, Zero))
                    {
                        Store (Local0, PAR0)
                    }
                }
                Else
                {
                    If (LEqual (T_1, One))
                    {
                        And (Arg1, 0xFFFF, Local0)
                        Store (Local0, Index (GBT0, 0x02))
                        Store (SICL (Local0), ASB0)
                        Store (Local0, PAR0)
                    }
                    Else
                    {
                        Store (Zero, ASB0)
                    }
                }
            }
            Else
            {
                If (LEqual (T_0, 0x02))
                {
                    Store (And (Arg1, 0xFF), Local0)
                    If (LEqual (STCG (Local0), One))
                    {
                        Store (Local0, Index (GBT1, 0x02))
                    }
                    Else
                    {
                        Store (Zero, ASB0)
                    }
                }
                Else
                {
                    If (LEqual (T_0, 0x10))
                    {
                        Store (And (Arg1, 0xFF), Local0)
                        AGLS (Local0)
                    }
                    Else
                    {
                        If (LEqual (T_0, 0x22))
                        {
                            Store (And (Arg1, 0xFF), Local0)
                            AGLI (Local0)
                        }
                        Else
                        {
                            If (LEqual (T_0, 0x23))
                            {
                                Store (And (Arg1, 0xFF), Local0)
                                AGCV (Local0)
                            }
                            Else
                            {
                                Store (Zero, ASB0)
                            }
                        }
                    }
                }
            }
        }
    }
    Scope (_GPE)
    {
        Method (_L10, 0, NotSerialized)
        {
            Notify (\_SB.PCI0.SBRG.ASOC, 0x05)
            If (LEqual (\_SB.PCI0.SBRG.ASOC.AIGC, One))
            {
                \_SB.PCI0.SBRG.ASOC.GITE (0x0E060001)
                \_SB.PCI0.SBRG.ASOC.SICL (Or (0x8010, \_SB.PCI0.SBRG.ASOC.ASB1))
            }
            \_SB.PCI0.SBRG.SIOR.GAUT ()
            \_SB.PCI0.SBRG.ASOC.RCAS ()
        }
    }
    OperationRegion (GPS0, SystemIO, GPBS, 0x40)
    Field (GPS0, ByteAcc, NoLock, Preserve)
    {
                Offset (0x0C), 
                Offset (0x38), 
            ,   5, 
        PWTH,   1
    }
    Scope (_SB.PCI0.SBRG.ASOC)
    {
        Name (GET1, Package (0x07)
        {
            0x0E060001, 
            "OC Status", 
            Zero, 
            Zero, 
            Zero, 
            Zero, 
            Zero
        })
        Name (GET2, Package (0x07)
        {
            0x0E0A0011, 
            "ICPU Value", 
            Zero, 
            Zero, 
            Zero, 
            Zero, 
            Zero
        })
        Name (GET3, Package (0x07)
        {
            0x0E020012, 
            "VCPU Value", 
            Zero, 
            Zero, 
            Zero, 
            Zero, 
            Zero
        })
        Name (GET4, Package (0x07)
        {
            0x0E0B0013, 
            "PCPU Value", 
            Zero, 
            Zero, 
            Zero, 
            Zero, 
            Zero
        })
        Name (GET5, Package (0x07)
        {
            0x0E0A0014, 
            "OC Threshold1", 
            Zero, 
            Zero, 
            Zero, 
            Zero, 
            Zero
        })
        Name (GET6, Package (0x07)
        {
            0x0E0A0015, 
            "OC Threshold2", 
            Zero, 
            Zero, 
            Zero, 
            Zero, 
            Zero
        })
        Name (GET7, Package (0x07)
        {
            0x0E0A0016, 
            "OC Threshold3", 
            Zero, 
            Zero, 
            Zero, 
            Zero, 
            Zero
        })
        Name (GRPE, Package (0x07)
        {
            GET1, 
            GET2, 
            GET3, 
            GET4, 
            GET5, 
            GET6, 
            GET7
        })
        Name (ADP3, Package (0x0B)
        {
            0x60, 
            0xF5, 
            0xF1, 
            0x8B, 
            0x96, 
            0xEE, 
            0xEF, 
            0xF0, 
            0x03, 
            One, 
            Zero
        })
        Name (OCST, Buffer (0x04)
        {
            0x00, 0x01, 0x02, 0x03
        })
        Method (GITE, 1, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, One))
            {
                If (^^SIOR.GATS ())
                {
                    Store (0x03, ASB1)
                }
                Else
                {
                    Store (One, ASB1)
                }
            }
            Else
            {
                If (LEqual (T_0, 0x11))
                {
                    Store (^^SIOR.HWT2 (), ASB1)
                }
                Else
                {
                    If (LEqual (T_0, 0x13))
                    {
                        Store (^^SIOR.GAUP (), ASB1)
                    }
                    Else
                    {
                        If (LEqual (T_0, 0x14))
                        {
                            Store (^^SIOR.GATH (), ASB1)
                        }
                        Else
                        {
                            If (LEqual (T_0, 0x15))
                            {
                                Store (^^SIOR.GATO (), ASB1)
                            }
                            Else
                            {
                                If (LEqual (T_0, 0x16))
                                {
                                    Store (Zero, ASB1)
                                }
                                Else
                                {
                                    Store (Zero, ASB0)
                                }
                            }
                        }
                    }
                }
            }
        }
        Method (SITE, 3, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFFFF), T_0)
            If (LEqual (T_0, 0x14))
            {
                ^^SIOR.SATH (Arg1)
            }
            Else
            {
                If (LEqual (T_0, 0x15))
                {
                    ^^SIOR.SATO (Arg1)
                }
                Else
                {
                    If (LEqual (T_0, 0x16)) {}
                    Else
                    {
                        Store (Zero, ASB0)
                    }
                }
            }
        }
        Name (OLTB, Buffer (0x14)
        {
            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
            /* 0008 */    0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 
            /* 0010 */    0x01, 0x01, 0x00, 0x01
        })
        Name (LDLE, Package (0x04)
        {
            Package (0x03)
            {
                0x19, 
                0x19, 
                0x19
            }, 
            Package (0x03)
            {
                0x43, 
                0x43, 
                0x43
            }, 
            Package (0x03)
            {
                0x0A, 
                0x0D, 
                0x11
            }, 
            Package (0x03)
            {
                Zero, 
                Zero, 
                Zero
            }
        })
        Name (CUVR, Package (0x04)
        {
            Package (0x03)
            {
                Zero, 
                Zero, 
                Zero
            }, 
            Package (0x03)
            {
                Zero, 
                Zero, 
                Zero
            }, 
            Package (0x03)
            {
                Zero, 
                Zero, 
                Zero
            }, 
            Package (0x03)
            {
                0x41, 
                0x42, 
                0x43
            }
        })
        Name (AIGC, Zero)
        Name (PICL, One)
        Name (LVIC, Zero)
        Method (STCG, 1, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFF), T_0)
            If (LEqual (T_0, Zero))
            {
                Store (Zero, Local0)
            }
            Else
            {
                If (LEqual (T_0, One))
                {
                    Store (Zero, Local0)
                }
                Else
                {
                    Return (Zero)
                }
            }
            Return (One)
        }
        Method (GDEF, 1, NotSerialized)
        {
            Name (T_0, Zero)
            Store (And (Arg0, 0xFF), T_0)
            If (LEqual (T_0, 0x02))
            {
                Return (GVOT (0x02, LVIC))
            }
            Else
            {
                If (LEqual (T_0, 0x04))
                {
                    Return (GVOT (0x04, LVIC))
                }
                Else
                {
                    Return (Zero)
                }
            }
        }
        Method (AGLS, 1, NotSerialized)
        {
            Store (Arg0, LVIC)
            Return (One)
        }
        Method (AGLI, 1, NotSerialized)
        {
            SVOT (0x04, LVIC, Arg0)
            Return (One)
        }
        Method (AGCV, 1, NotSerialized)
        {
            SVOT (0x02, LVIC, Arg0)
            Return (One)
        }
        Method (SVOT, 3, NotSerialized)
        {
            Add (Arg0, Multiply (Arg1, 0x05), Local0)
            Store (Arg2, Index (OLTB, Local0))
            Return (One)
        }
        Method (GVOT, 2, NotSerialized)
        {
            Add (Arg0, Multiply (Arg1, 0x05), Local0)
            Store (DerefOf (Index (OLTB, Local0)), Local1)
            Return (Local1)
        }
        Method (SICL, 1, NotSerialized)
        {
            If (And (Arg0, 0x8000))
            {
                Store (One, AIGC)
                Name (T_0, Zero)
                Store (And (Arg0, 0xFF), T_0)
                If (LEqual (T_0, Zero))
                {
                    ITAT ()
                }
                Else
                {
                    If (LEqual (T_0, 0x10))
                    {
                        SPIC (One)
                        Store (One, PICL)
                    }
                    Else
                    {
                        If (LEqual (T_0, 0x11))
                        {
                            SPIC (One)
                            Store (One, PICL)
                        }
                        Else
                        {
                            If (LEqual (T_0, 0x12))
                            {
                                SPIC (0x02)
                                Store (0x02, PICL)
                            }
                            Else
                            {
                                If (LEqual (T_0, 0x13))
                                {
                                    SPIC (0x03)
                                    Store (0x03, PICL)
                                }
                                Else
                                {
                                    Return (Zero)
                                }
                            }
                        }
                    }
                }
            }
            Else
            {
                Store (Zero, AIGC)
                Name (T_1, Zero)
                Store (And (Arg0, 0xFF), T_1)
                If (LEqual (T_1, Zero))
                {
                    SPIC (One)
                    Store (One, PICL)
                }
                Else
                {
                    If (LEqual (T_1, One))
                    {
                        SPIC (0x02)
                        Store (0x02, PICL)
                    }
                    Else
                    {
                        If (LEqual (T_1, 0x02))
                        {
                            SPIC (0x03)
                            Store (0x03, PICL)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }
                }
            }
            Return (One)
        }
        Method (SPIC, 1, NotSerialized)
        {
            If (LLessEqual (Arg0, PICL))
            {
                WBYT (DerefOf (Index (ADP3, Zero)), DerefOf (Index (ADP3, 0x08
                    )), DerefOf (Index (DerefOf (Index (CUVR, Arg0)), GVOT (0x02, Arg0)
                    )))
                WBYT (DerefOf (Index (ADP3, Zero)), DerefOf (Index (ADP3, 0x09
                    )), DerefOf (Index (DerefOf (Index (LDLE, Arg0)), GVOT (0x04, Arg0)
                    )))
                If (LEqual (Arg0, 0x03))
                {
                    Store (Zero, PWTH)
                }
                Else
                {
                    Store (One, PWTH)
                }
                If (LEqual (AIGC, Zero))
                {
                    SFSB (Arg0)
                }
            }
            Else
            {
                If (LEqual (AIGC, Zero))
                {
                    SFSB (Arg0)
                }
                If (LEqual (Arg0, 0x03))
                {
                    Store (Zero, PWTH)
                }
                Else
                {
                    Store (One, PWTH)
                }
                WBYT (DerefOf (Index (ADP3, Zero)), DerefOf (Index (ADP3, 0x09
                    )), DerefOf (Index (DerefOf (Index (LDLE, Arg0)), GVOT (0x04, Arg0)
                    )))
                WBYT (DerefOf (Index (ADP3, Zero)), DerefOf (Index (ADP3, 0x08
                    )), DerefOf (Index (DerefOf (Index (CUVR, Arg0)), GVOT (0x02, Arg0)
                    )))
            }
            RCAS ()
        }
        Name (PSLV, Package (0x04)
        {
            Package (0x02)
            {
                0x04F6, 
                0x04E2
            }, 
            Package (0x02)
            {
                0x04F6, 
                0x04E2
            }, 
            Package (0x02)
            {
                0x39, 
                0x35
            }, 
            Package (0x02)
            {
                0x39, 
                0x35
            }
        })
        Method (SFSB, 1, NotSerialized)
        {
            If (LEqual (GNVS (0x348D), Zero))
            {
                Store (Zero, Local5)
            }
            Else
            {
                Store (One, Local5)
            }
            ^^SIOR.SATO (DerefOf (Index (DerefOf (Index (PSLV, Local5)), Zero)))
            ^^SIOR.SATH (DerefOf (Index (DerefOf (Index (PSLV, Local5)), One)))
            Sleep (0x03E8)
        }
        Method (ITAT, 0, NotSerialized)
        {
            If (LEqual (GNVS (0x348D), Zero))
            {
                Store (Zero, Local0)
            }
            Else
            {
                Store (One, Local0)
            }
            ^^SIOR.SATO (DerefOf (Index (DerefOf (Index (PSLV, Local0)), Zero)))
            ^^SIOR.SATH (DerefOf (Index (DerefOf (Index (PSLV, Local0)), One)))
            Sleep (0x03E8)
        }
        Method (RCAS, 0, NotSerialized)
        {
            ^^SIOR.CATS ()
        }
    }
    OperationRegion (_SB.PCI0.SBRG.PIX0, PCI_Config, 0x60, 0x0C)
    Field (\_SB.PCI0.SBRG.PIX0, ByteAcc, NoLock, Preserve)
    {
        PIRA,   8, 
        PIRB,   8, 
        PIRC,   8, 
        PIRD,   8, 
                Offset (0x08), 
        PIRE,   8, 
        PIRF,   8, 
        PIRG,   8, 
        PIRH,   8
    }
    Scope (_SB)
    {
        Name (BUFA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {15}
        })
        CreateWordField (BUFA, One, IRA0)
        Device (LNKA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, One)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRA, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }
            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSA)
            }
            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRA, 0x80, PIRA)
            }
            Method (_CRS, 0, NotSerialized)
            {
                And (PIRA, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }
            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRA)
            }
        }
        Device (LNKB)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x02)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRB, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }
            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSB)
            }
            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRB, 0x80, PIRB)
            }
            Method (_CRS, 0, NotSerialized)
            {
                And (PIRB, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }
            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRB)
            }
        }
        Device (LNKC)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x03)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRC, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }
            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSC)
            }
            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRC, 0x80, PIRC)
            }
            Method (_CRS, 0, NotSerialized)
            {
                And (PIRC, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }
            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRC)
            }
        }
        Device (LNKD)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x04)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRD, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }
            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSD)
            }
            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRD, 0x80, PIRD)
            }
            Method (_CRS, 0, NotSerialized)
            {
                And (PIRD, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }
            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRD)
            }
        }
        Device (LNKE)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x05)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRE, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }
            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSE)
            }
            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRE, 0x80, PIRE)
            }
            Method (_CRS, 0, NotSerialized)
            {
                And (PIRE, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }
            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRE)
            }
        }
        Device (LNKF)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x06)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRF, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }
            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSF)
            }
            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRF, 0x80, PIRF)
            }
            Method (_CRS, 0, NotSerialized)
            {
                And (PIRF, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }
            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRF)
            }
        }
        Device (LNKG)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x07)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRG, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }
            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSG)
            }
            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRG, 0x80, PIRG)
            }
            Method (_CRS, 0, NotSerialized)
            {
                And (PIRG, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }
            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRG)
            }
        }
        Device (LNKH)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x08)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRH, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }
            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSH)
            }
            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRH, 0x80, PIRH)
            }
            Method (_CRS, 0, NotSerialized)
            {
                And (PIRH, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }
            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRH)
            }
        }
    }
    Scope (_SB)
    {
        Name (XCPD, Zero)
        Name (XNPT, One)
        Name (XCAP, 0x02)
        Name (XDCP, 0x04)
        Name (XDCT, 0x08)
        Name (XDST, 0x0A)
        Name (XLCP, 0x0C)
        Name (XLCT, 0x10)
        Name (XLST, 0x12)
        Name (XSCP, 0x14)
        Name (XSCT, 0x18)
        Name (XSST, 0x1A)
        Name (XRCT, 0x1C)
        Mutex (MUTE, 0x00)
        Method (RBPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0xFFFF)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, One)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }
            Release (MUTE)
            Return (XCFG)
        }
        Method (RWPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0xFFFF)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }
            Release (MUTE)
            Return (XCFG)
        }
        Method (RDPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0xFFFF)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }
            Release (MUTE)
            Return (XCFG)
        }
        Method (WBPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0xFFFF)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, One)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }
            Store (Arg1, XCFG)
            Release (MUTE)
        }
        Method (WWPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0xFFFF)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }
            Store (Arg1, XCFG)
            Release (MUTE)
        }
        Method (WDPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0xFFFF)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }
            Store (Arg1, XCFG)
            Release (MUTE)
        }
        Method (RWDP, 3, NotSerialized)
        {
            Acquire (MUTE, 0xFFFF)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }
            And (XCFG, Arg2, Local1)
            Or (Local1, Arg1, XCFG)
            Release (MUTE)
        }
        Method (RPME, 1, NotSerialized)
        {
            Add (Arg0, 0x84, Local0)
            Store (RDPE (Local0), Local1)
            If (LEqual (Local1, Ones))
            {
                Return (Zero)
            }
            Else
            {
                If (LAnd (Local1, 0x00010000))
                {
                    WDPE (Local0, And (Local1, 0x00010000))
                    Return (One)
                }
                Return (Zero)
            }
        }
    }
    Scope (_SB.PCI0)
    {
        Method (_OSC, 4, NotSerialized)
        {
            Name (SUPP, Zero)
            Name (CTRL, Zero)
            CreateDWordField (Arg3, Zero, CDW1)
            CreateDWordField (Arg3, 0x04, CDW2)
            CreateDWordField (Arg3, 0x08, CDW3)
            If (LEqual (Arg0, Buffer (0x10)
                    {
                        /* 0000 */    0x5B, 0x4D, 0xDB, 0x33, 0xF7, 0x1F, 0x1C, 0x40, 
                        /* 0008 */    0x96, 0x57, 0x74, 0x41, 0xC0, 0x3D, 0xD7, 0x66
                    }))
            {
                Store (CDW2, SUPP)
                Store (CDW3, CTRL)
                If (LNotEqual (And (SUPP, 0x16), 0x16))
                {
                    And (CTRL, 0x1E, CTRL)
                }
                If (LNot (PEHP))
                {
                    And (CTRL, 0x1E, CTRL)
                }
                If (LNot (SHPC))
                {
                    And (CTRL, 0x1D, CTRL)
                }
                If (LNot (PEPM))
                {
                    And (CTRL, 0x1B, CTRL)
                }
                If (LNot (PEER))
                {
                    And (CTRL, 0x15, CTRL)
                }
                If (LNot (PECS))
                {
                    And (CTRL, 0x0F, CTRL)
                }
                If (Not (And (CDW1, One)))
                {
                    If (And (CTRL, One)) {}
                    If (And (CTRL, 0x04)) {}
                    If (And (CTRL, 0x10)) {}
                }
                If (LNotEqual (Arg1, One))
                {
                    Or (CDW1, 0x08, CDW1)
                }
                If (LNotEqual (CDW3, CTRL))
                {
                    Or (CDW1, 0x10, CDW1)
                }
                And (CTRL, 0xEF, CTRL)
                Store (CTRL, CDW3)
                Return (Arg3)
            }
            Else
            {
                Or (CDW1, 0x04, CDW1)
                Return (Arg3)
            }
        }
    }
    OperationRegion (SMRG, SystemIO, 0x0400, 0x10)
    Field (SMRG, ByteAcc, NoLock, Preserve)
    {
        HSTS,   8, 
        SSTS,   8, 
        HSTC,   8, 
        HCMD,   8, 
        HADR,   8, 
        HDT0,   8, 
        HDT1,   8, 
        BLKD,   8, 
        SLCT,   8, 
        SHCM,   8, 
        SLEV,   24, 
        AUXC,   8
    }
    Field (SMRG, ByteAcc, NoLock, Preserve)
    {
                Offset (0x05), 
        HDTW,   16
    }
    Method (SCMD, 4, Serialized)
    {
        Store (0x05, Local0)
        While (Decrement (Local0))
        {
            Store (0xFFFF, Local1)
            While (LAnd (HSTS, Decrement (Local1)))
            {
                Store (0xFE, HSTS)
                Stall (0x0A)
            }
            Store (HSTC, Local2)
            Store (Arg0, HADR)
            Store (Arg1, HCMD)
            Store (Arg2, HDTW)
            Store (Arg3, HSTC)
            Store (0xFFFF, Local1)
            While (Decrement (Local1))
            {
                If (And (HSTS, 0x0C))
                {
                    Store (One, Local1)
                }
                If (LEqual (And (HSTS, 0x03), 0x02))
                {
                    Return (HDTW)
                }
                Stall (0x0A)
            }
            Store (0x42, HSTC)
            Store (0xFFFF, Local1)
            While (Decrement (Local1))
            {
                If (And (HSTS, 0x10))
                {
                    Store (One, Local1)
                }
                Stall (0x0A)
            }
            Store (Zero, HSTC)
        }
        Return (Ones)
    }
    Method (SBYT, 2, NotSerialized)
    {
        SCMD (Arg0, Arg1, Zero, 0x44)
    }
    Method (WBYT, 3, NotSerialized)
    {
        SCMD (Arg0, Arg1, Arg2, 0x48)
    }
    Method (WWRD, 3, NotSerialized)
    {
        SCMD (Arg0, Arg1, Arg2, 0x4C)
    }
    Method (RSBT, 2, NotSerialized)
    {
        Or (Arg0, One, Arg0)
        Return (And (SCMD (Arg0, Arg1, Zero, 0x44), 0xFF))
    }
    Method (RBYT, 2, NotSerialized)
    {
        Or (Arg0, One, Arg0)
        Return (And (SCMD (Arg0, Arg1, Zero, 0x48), 0xFF))
    }
    Method (RWRD, 2, NotSerialized)
    {
        Or (Arg0, One, Arg0)
        Return (SCMD (Arg0, Arg1, Zero, 0x4C))
    }
    Method (RBLK, 3, NotSerialized)
    {
        Or (AUXC, 0x02, AUXC)
        Or (Arg0, One, Local0)
        SCMD (Local0, Arg1, Arg2, 0x54)
        Store (HSTC, Local0)
        Store (HDT0, Local0)
        Add (Local0, One, Local7)
        Name (RBUF, Buffer (Local7) {})
        Store (Zero, Local1)
        While (Local0)
        {
            Store (BLKD, Index (RBUF, Local1))
            Decrement (Local0)
            Increment (Local1)
        }
        Return (RBUF)
    }
    Method (WBLK, 4, NotSerialized)
    {
        Or (AUXC, 0x02, AUXC)
        Store (HSTC, Local0)
        Store (Zero, Local0)
        While (LLessEqual (Local0, Arg2))
        {
            Store (DerefOf (Index (Arg3, Local0)), BLKD)
            Increment (Local0)
        }
        And (Arg0, 0xFE, Local0)
        SCMD (Local0, Arg1, Arg2, 0x54)
    }
    Scope (_SB.PCI0.SBRG.SIOR)
    {
        Name (SNCT, Zero)
        Name (E1BK, Zero)
        Method (HWV0, 0, NotSerialized)
        {
            Return (Multiply (VCOR, 0x08))
        }
        Method (HWV1, 0, NotSerialized)
        {
            Return (Multiply (V12V, 0x08))
        }
        Method (HWV3, 0, NotSerialized)
        {
            Return (Multiply (V33V, 0x08))
        }
        Method (HWV4, 0, NotSerialized)
        {
            Return (Multiply (V50V, 0x08))
        }
        Method (HWT0, 0, NotSerialized)
        {
            ENFG (0x0C)
            Store (CR20, Local0)
            EXFG ()
            If (LEqual (Local0, 0xB3))
            {
                Store (Zero, BSEL)
                Store (Zero, SR7D)
                Store (SR7E, Local1)
            }
            Else
            {
                Store (MBTE, Local1)
            }
            If (And (Local1, 0x80))
            {
                Or (Local1, 0xFFFFFF00, Local1)
            }
            Multiply (Local1, 0x0A, Local1)
            Return (Local1)
        }
        Method (HWT1, 0, NotSerialized)
        {
            ENFG (0x0C)
            If (LNotEqual (CRE1, E1BK))
            {
                If (LEqual (E1BK, Zero))
                {
                    Store (CRE1, E1BK)
                }
                Else
                {
                    Store (E1BK, CRE1)
                }
            }
            EXFG ()
            If (LLess (SNCT, 0x02))
            {
                Store (One, BSEL)
                Store (TSR1, Local3)
                Store (Zero, BSEL)
                Add (MBTE, One, Local1)
                XOr (Local1, 0x80, Local1)
                XOr (Local3, 0x80, Local3)
                If (LGreater (Local1, Local3))
                {
                    ENFG (0x0C)
                    If (LAnd (CRE0, 0xF0))
                    {
                        Subtract (Local1, Local3, Local3)
                        ShiftRight (Local3, One, Local3)
                        Add (Local3, 0x03, Local3)
                        Add (CRE1, Local3, CRE1)
                        Store (CRE1, E1BK)
                        Sleep (0x32)
                    }
                    Increment (SNCT)
                    EXFG ()
                }
            }
            Store (One, BSEL)
            Store (TSR1, Local1)
            If (And (Local1, 0x80))
            {
                Or (Local1, 0xFFFFFF00, Local1)
            }
            WBYT (0x80, 0x1D, Local1)
            Multiply (Local1, 0x0A, Local1)
            Store (TSR2, Local2)
            Multiply (Local2, 0x05, Local2)
            Add (Local1, Local2, Local1)
            Return (Local1)
        }
        Method (HWT2, 0, NotSerialized)
        {
            Store (0x02, BSEL)
            Store (TSR1, Local1)
            If (And (Local1, 0x80))
            {
                Or (Local1, 0xFFFFFF00, Local1)
            }
            Multiply (Local1, 0x0A, Local1)
            Store (TSR2, Local2)
            Multiply (Local2, 0x05, Local2)
            Add (Local1, Local2, Local1)
            Return (Local1)
        }
        Method (GAUT, 0, NotSerialized)
        {
            Store (0x02, BSEL)
            Store (TSR1, Local0)
            Return (TSR1)
        }
        Method (GAUI, 0, NotSerialized)
        {
            Store (GAUT (), Local0)
            Multiply (Local0, Local0, Local1)
            Multiply (Local1, Local0, Local2)
            Divide (Multiply (Local2, 0x8A), 0x00989680, Local3, Local4)
            Divide (Multiply (Local1, 0xAC), 0x2710, Local3, Local5)
            Divide (Multiply (Local0, 0x01AA), 0x64, Local3, Local6)
            Add (Local4, Local5, Local5)
            If (LGreater (Local0, 0x49))
            {
                Add (Local5, 0xEB, Local5)
            }
            Else
            {
                If (LGreater (Local0, 0x2D))
                {
                    Add (Local5, 0xE9, Local5)
                }
                Else
                {
                    Add (Local5, 0xE7, Local5)
                }
            }
            If (LGreater (Local5, Local6))
            {
                Store (Subtract (Local5, Local6), Local7)
            }
            Else
            {
                Store (Zero, Local7)
            }
            Return (Local7)
        }
        Method (GAUP, 0, NotSerialized)
        {
            Store (Multiply (HWV0 (), GAUI ()), Local0)
            Return (Local0)
        }
        Method (GATO, 0, NotSerialized)
        {
            Store (0x02, BSEL)
            Store (ATOV, Local1)
            Multiply (Local1, 0x0A, Local1)
            Store (ATOL, Local2)
            Multiply (Local2, 0x05, Local2)
            Add (Local1, Local2, Local1)
            Return (Local1)
        }
        Method (GATH, 0, NotSerialized)
        {
            Store (0x02, BSEL)
            Store (FAN4, Local1)
            Multiply (Local1, 0x0A, Local1)
            Store (ATHL, Local2)
            Multiply (Local2, 0x05, Local2)
            Add (Local1, Local2, Local1)
            Return (Local1)
        }
        Method (SATO, 1, NotSerialized)
        {
            Store (0x02, BSEL)
            Divide (Arg0, 0x0A, Local0, Local1)
            Store (And (Local1, 0xFF), ATOV)
            If (LGreater (Local0, 0x07))
            {
                Store (Add (Local1, One), ATOV)
                Store (Zero, ATOL)
            }
            Else
            {
                If (LGreater (Local0, 0x02))
                {
                    Store (One, ATOL)
                }
                Else
                {
                    Store (Zero, ATOL)
                }
            }
        }
        Method (SATH, 1, NotSerialized)
        {
            Store (0x02, BSEL)
            Divide (Arg0, 0x0A, Local0, Local1)
            Store (And (Local1, 0xFF), FAN4)
            If (LGreater (Local0, 0x07))
            {
                Store (Add (Local1, One), FAN4)
                Store (Zero, ATHL)
            }
            Else
            {
                If (LGreater (Local0, 0x02))
                {
                    Store (One, ATHL)
                }
                Else
                {
                    Store (Zero, ATHL)
                }
            }
        }
        Method (GATS, 0, NotSerialized)
        {
            Store (0x04, BSEL)
            Return (AUTS)
        }
        Method (CATS, 0, NotSerialized)
        {
            Store (Zero, BSEL)
            Store (AUIS, Local0)
        }
        OperationRegion (DBGE, SystemIO, 0x80, 0x04)
        Field (DBGE, WordAcc, NoLock, Preserve)
        {
            DBGG,   22
        }
        Method (HWF0, 0, NotSerialized)
        {
            Store (FAN1, Local0)
            Store (Zero, BSEL)
            And (FD21, 0x20, Local1)
            ShiftRight (Local1, 0x05, Local1)
            Multiply (Local1, 0x04, Local1)
            And (FDR1, 0x30, Local2)
            ShiftRight (Local2, 0x04, Local2)
            Add (Local1, Local2, Local1)
            If (LOr (LGreater (Local1, 0x05), LLess (Local1, 0x02)))
            {
                If (LGreater (Local0, 0xF0))
                {
                    Store (0x02, Local1)
                }
                Else
                {
                    If (LLess (Local0, 0x1E))
                    {
                        Store (0x05, Local1)
                    }
                    Else
                    {
                        Store (0x03, Local1)
                    }
                }
                Divide (Local1, 0x04, Local2, Local3)
                ShiftLeft (Local3, 0x05, Local3)
                Store (FD21, Local4)
                And (Local4, 0xDF, Local4)
                Or (Local3, Local4, FD21)
                Store (FDR1, Local4)
                And (Local4, 0xCF, Local4)
                ShiftLeft (Local2, 0x04, Local2)
                Or (Local4, One, Local4)
                Or (Local4, Local2, FDR1)
                Sleep (0x32)
                Store (FAN1, Local0)
            }
            While (LOr (LAnd (LGreater (Local0, 0xF0), LLess (Local1, 0x05)), LAnd (
                LLess (Local0, 0x1E), LGreater (Local1, 0x02))))
            {
                If (LAnd (LGreater (Local0, 0xF0), LLess (Local1, 0x05)))
                {
                    Add (Local1, One, Local1)
                    Divide (Local1, 0x04, Local2, Local3)
                    Store (Zero, BSEL)
                    ShiftLeft (Local3, 0x05, Local3)
                    Store (FD21, Local4)
                    And (Local4, 0xDF, Local4)
                    Or (Local3, Local4, FD21)
                    Store (FDR1, Local4)
                    And (Local4, 0xCF, Local4)
                    ShiftLeft (Local2, 0x04, Local2)
                    Or (Local4, One, Local4)
                    Or (Local4, Local2, FDR1)
                    Sleep (0x32)
                    Store (FAN1, Local0)
                    Sleep (0x32)
                    Store (FAN1, Local0)
                    Sleep (0x32)
                    Store (FAN1, Local0)
                }
                Else
                {
                    Subtract (Local1, One, Local1)
                    Divide (Local1, 0x04, Local2, Local3)
                    Store (Zero, BSEL)
                    ShiftLeft (Local3, 0x05, Local3)
                    Store (FD21, Local4)
                    And (Local4, 0xDF, Local4)
                    Or (Local3, Local4, FD21)
                    Store (FDR1, Local4)
                    And (Local4, 0xCF, Local4)
                    ShiftLeft (Local2, 0x04, Local2)
                    Or (Local4, One, Local4)
                    Or (Local4, Local2, FDR1)
                    Sleep (0x32)
                    Store (FAN1, Local0)
                    Sleep (0x32)
                    Store (FAN1, Local0)
                    Sleep (0x32)
                    Store (FAN1, Local0)
                }
            }
            If (LAnd (LEqual (Local0, 0xFF), LEqual (Local1, 0x05)))
            {
                Return (Zero)
            }
            If (LAnd (LEqual (Local0, Zero), LEqual (Local1, 0x02)))
            {
                Return (0xFFFF)
            }
            Store (One, Local2)
            While (Local1)
            {
                Multiply (Local2, 0x02, Local2)
                Decrement (Local1)
            }
            Multiply (Local0, Local2, Local0)
            Divide (0x00149970, Local0, Local1, Local0)
            Return (Local0)
        }
        Method (HWF1, 0, NotSerialized)
        {
            Store (Zero, BSEL)
            Store (FAN2, Local0)
            And (FD21, 0x40, Local1)
            ShiftRight (Local1, 0x06, Local1)
            Multiply (Local1, 0x04, Local1)
            And (FDR1, 0xC0, Local2)
            ShiftRight (Local2, 0x06, Local2)
            Add (Local1, Local2, Local1)
            If (LOr (LGreater (Local1, 0x05), LLess (Local1, 0x02)))
            {
                If (LGreater (Local0, 0xF0))
                {
                    Store (0x02, Local1)
                }
                Else
                {
                    If (LLess (Local0, 0x1E))
                    {
                        Store (0x05, Local1)
                    }
                    Else
                    {
                        Store (0x03, Local1)
                    }
                }
                Divide (Local1, 0x04, Local2, Local3)
                ShiftLeft (Local3, 0x06, Local3)
                Store (FD21, Local4)
                And (Local4, 0xBF, Local4)
                Or (Local3, Local4, FD21)
                Store (FDR1, Local4)
                And (Local4, 0x3F, Local4)
                ShiftLeft (Local2, 0x06, Local2)
                Or (Local4, One, Local4)
                Or (Local4, Local2, FDR1)
                Sleep (0x32)
                Store (Zero, BSEL)
                Store (FAN2, Local0)
            }
            While (LOr (LAnd (LGreater (Local0, 0xF0), LLess (Local1, 0x05)), LAnd (
                LLess (Local0, 0x1E), LGreater (Local1, 0x02))))
            {
                If (LAnd (LLess (Local0, 0x1E), LGreater (Local1, 0x02)))
                {
                    Subtract (Local1, One, Local1)
                    Divide (Local1, 0x04, Local2, Local3)
                    Store (Zero, BSEL)
                    ShiftLeft (Local3, 0x06, Local3)
                    Store (FD21, Local4)
                    And (Local4, 0xBF, Local4)
                    Or (Local3, Local4, FD21)
                    Store (FDR1, Local4)
                    And (Local4, 0x3F, Local4)
                    ShiftLeft (Local2, 0x06, Local2)
                    Or (Local4, One, Local4)
                    Or (Local4, Local2, FDR1)
                    Sleep (0x32)
                    Store (Zero, BSEL)
                    Store (FAN2, Local0)
                    Sleep (0x32)
                    Store (FAN2, Local0)
                    Sleep (0x32)
                    Store (FAN2, Local0)
                }
                Else
                {
                    Add (Local1, One, Local1)
                    Divide (Local1, 0x04, Local2, Local3)
                    Store (Zero, BSEL)
                    ShiftLeft (Local3, 0x06, Local3)
                    Store (FD21, Local4)
                    And (Local4, 0xBF, Local4)
                    Or (Local3, Local4, FD21)
                    Store (FDR1, Local4)
                    And (Local4, 0x3F, Local4)
                    ShiftLeft (Local2, 0x06, Local2)
                    Or (Local4, One, Local4)
                    Or (Local4, Local2, FDR1)
                    Sleep (0x32)
                    Store (Zero, BSEL)
                    Store (FAN2, Local0)
                    Sleep (0x32)
                    Store (FAN2, Local0)
                    Sleep (0x32)
                    Store (FAN2, Local0)
                }
            }
            If (LAnd (LEqual (Local0, 0xFF), LEqual (Local1, 0x05)))
            {
                Return (Zero)
            }
            If (LAnd (LEqual (Local0, Zero), LEqual (Local1, 0x02)))
            {
                Return (0xFFFF)
            }
            Store (One, Local2)
            While (Local1)
            {
                Multiply (Local2, 0x02, Local2)
                Decrement (Local1)
            }
            Multiply (Local0, Local2, Local0)
            Divide (0x00149970, Local0, Local1, Local0)
            Return (Local0)
        }
        Method (HWF2, 0, NotSerialized)
        {
            Store (FAN3, Local0)
            Store (Zero, BSEL)
            And (FD21, 0x80, Local1)
            ShiftRight (Local1, 0x07, Local1)
            Multiply (Local1, 0x04, Local1)
            Divide (FD13, 0x40, Local2, Local3)
            Add (Local1, Local3, Local1)
            If (LOr (LGreater (Local1, 0x05), LLess (Local1, 0x02)))
            {
                If (LGreater (Local0, 0xF0))
                {
                    Store (0x02, Local1)
                }
                Else
                {
                    If (LLess (Local0, 0x1E))
                    {
                        Store (0x05, Local1)
                    }
                    Else
                    {
                        Store (0x03, Local1)
                    }
                }
                Divide (Local1, 0x04, Local2, Local3)
                ShiftLeft (Local3, 0x07, Local3)
                Store (FD21, Local4)
                And (Local4, 0x7F, Local4)
                Or (Local3, Local4, FD21)
                Store (FD13, Local3)
                And (Local3, 0x3F, Local3)
                Multiply (Local2, 0x40, Local2)
                Add (Local3, Local2, Local2)
                Store (Local2, FD13)
                Sleep (0x32)
                Store (FAN3, Local0)
            }
            While (LOr (LAnd (LGreater (Local0, 0xF0), LLess (Local1, 0x05)), LAnd (
                LLess (Local0, 0x1E), LGreater (Local1, 0x02))))
            {
                If (LAnd (LGreater (Local0, 0xF0), LLess (Local1, 0x05)))
                {
                    If (LEqual (Local0, 0xFF))
                    {
                        Store (0x05, Local1)
                    }
                    Else
                    {
                        Add (Local1, One, Local1)
                    }
                    Divide (Local1, 0x04, Local2, Local3)
                    Store (Zero, BSEL)
                    ShiftLeft (Local3, 0x07, Local3)
                    Store (FD21, Local4)
                    And (Local4, 0x7F, Local4)
                    Or (Local3, Local4, FD21)
                    Store (FD13, Local3)
                    And (Local3, 0x3F, Local3)
                    Multiply (Local2, 0x40, Local2)
                    Add (Local3, Local2, Local2)
                    Store (Local2, FD13)
                    If (LNotEqual (Local0, 0xFF))
                    {
                        Sleep (0x32)
                    }
                    Store (FAN3, Local0)
                    Sleep (0x32)
                    Store (FAN3, Local0)
                    Sleep (0x32)
                    Store (FAN3, Local0)
                }
                Else
                {
                    Subtract (Local1, One, Local1)
                    Divide (Local1, 0x04, Local2, Local3)
                    Store (Zero, BSEL)
                    ShiftLeft (Local3, 0x07, Local3)
                    Store (FD21, Local4)
                    And (Local4, 0x7F, Local4)
                    Or (Local3, Local4, FD21)
                    Store (FD13, Local3)
                    And (Local3, 0x3F, Local3)
                    Multiply (Local2, 0x40, Local2)
                    Add (Local3, Local2, Local2)
                    Store (Local2, FD13)
                    Sleep (0x32)
                    Store (FAN3, Local0)
                    Sleep (0x32)
                    Store (FAN3, Local0)
                    Sleep (0x32)
                    Store (FAN3, Local0)
                }
            }
            If (LAnd (LEqual (Local0, 0xFF), LEqual (Local1, 0x05)))
            {
                Return (Zero)
            }
            If (LAnd (LEqual (Local0, Zero), LEqual (Local1, 0x02)))
            {
                Return (0xFFFF)
            }
            Store (One, Local2)
            While (Local1)
            {
                Multiply (Local2, 0x02, Local2)
                Decrement (Local1)
            }
            Multiply (Local0, Local2, Local0)
            Divide (0x00149970, Local0, Local1, Local0)
            Return (Local0)
        }
        Method (HWF4, 0, NotSerialized)
        {
            Store (0x05, BSEL)
            Store (FAN4, Local0)
            Store (Zero, BSEL)
            And (FND4, 0x80, Local1)
            ShiftRight (Local1, 0x07, Local1)
            Multiply (Local1, 0x04, Local1)
            And (FND4, 0x0C, Local2)
            ShiftRight (Local2, 0x02, Local2)
            Add (Local1, Local2, Local1)
            If (LOr (LGreater (Local1, 0x05), LLess (Local1, 0x02)))
            {
                If (LGreater (Local0, 0xF0))
                {
                    Store (0x02, Local1)
                }
                Else
                {
                    If (LLess (Local0, 0x1E))
                    {
                        Store (0x05, Local1)
                    }
                    Else
                    {
                        Store (0x03, Local1)
                    }
                }
                Divide (Local1, 0x04, Local2, Local3)
                ShiftLeft (Local3, 0x07, Local3)
                ShiftLeft (Local2, 0x02, Local2)
                Store (FND4, Local4)
                And (Local4, 0x73, Local4)
                Or (Local3, Local2, Local3)
                Or (Local3, Local4, FND4)
                Sleep (0x32)
                Store (0x05, BSEL)
                Store (FAN4, Local0)
            }
            While (LOr (LAnd (LGreater (Local0, 0xF0), LLess (Local1, 0x05)), LAnd (
                LLess (Local0, 0x1E), LGreater (Local1, 0x02))))
            {
                If (LAnd (LGreater (Local0, 0xF0), LLess (Local1, 0x05)))
                {
                    Add (Local1, One, Local1)
                    Divide (Local1, 0x04, Local2, Local3)
                    Store (Zero, BSEL)
                    ShiftLeft (Local3, 0x07, Local3)
                    ShiftLeft (Local2, 0x02, Local2)
                    Store (FND4, Local4)
                    And (Local4, 0x73, Local4)
                    Or (Local3, Local2, Local3)
                    Or (Local3, Local4, FND4)
                    If (LNotEqual (Local0, 0xFF))
                    {
                        Sleep (0x32)
                    }
                    Store (0x05, BSEL)
                    Store (FAN4, Local0)
                    Sleep (0x32)
                    Store (FAN4, Local0)
                    Sleep (0x32)
                    Store (FAN4, Local0)
                    Store (Zero, BSEL)
                }
                Else
                {
                    Subtract (Local1, One, Local1)
                    Divide (Local1, 0x04, Local2, Local3)
                    Store (Zero, BSEL)
                    ShiftLeft (Local3, 0x07, Local3)
                    ShiftLeft (Local2, 0x02, Local2)
                    Store (FND4, Local4)
                    And (Local4, 0x73, Local4)
                    Or (Local3, Local2, Local3)
                    Or (Local3, Local4, FND4)
                    Sleep (0x32)
                    Store (0x05, BSEL)
                    Store (FAN4, Local0)
                    Sleep (0x32)
                    Store (FAN4, Local0)
                    Sleep (0x32)
                    Store (FAN4, Local0)
                    Store (Zero, BSEL)
                }
            }
            If (LAnd (LEqual (Local0, 0xFF), LEqual (Local1, 0x05)))
            {
                Return (Zero)
            }
            If (LAnd (LEqual (Local0, Zero), LEqual (Local1, 0x02)))
            {
                Return (0xFFFF)
            }
            Store (One, Local2)
            While (Local1)
            {
                Multiply (Local2, 0x02, Local2)
                Decrement (Local1)
            }
            Multiply (Local0, Local2, Local0)
            Divide (0x00149970, Local0, Local1, Local0)
            Return (Local0)
        }
        Name (FNDT, Package (0x08)
        {
            One, 
            0x02, 
            0x04, 
            0x08, 
            0x10, 
            0x20, 
            0x40, 
            0x80
        })
        Method (HWF3, 0, NotSerialized)
        {
            Store (Zero, BSEL)
            Store (CFN3, Local0)
            And (FD15, 0x80, Local1)
            ShiftRight (Local1, 0x05, Local1)
            And (FND4, 0x03, Local2)
            Or (Local1, Local2, Local1)
            If (LOr (LGreater (Local1, 0x05), LLess (Local1, 0x02)))
            {
                If (LGreater (Local0, 0xF0))
                {
                    Store (0x02, Local1)
                }
                Else
                {
                    If (LLess (Local0, 0x1E))
                    {
                        Store (0x05, Local1)
                    }
                    Else
                    {
                        Store (0x03, Local1)
                    }
                }
                ShiftLeft (Local1, 0x05, Local2)
                And (Local2, 0x80, Local2)
                And (FD15, 0x7F, Local3)
                Or (Local2, Local3, Local3)
                Store (Local3, FD15)
                And (Local1, 0x03, Local2)
                And (FND4, 0xFC, Local3)
                Or (Local2, Local3, Local3)
                Store (Local3, FND4)
                Sleep (0x32)
                Store (CFN3, Local0)
            }
            While (LOr (LAnd (LGreater (Local0, 0xF0), LLess (Local1, 0x05)), LAnd (
                LLess (Local0, 0x1E), LGreater (Local1, 0x02))))
            {
                If (LAnd (LGreater (Local0, 0xF0), LLess (Local1, 0x05)))
                {
                    Increment (Local1)
                }
                Else
                {
                    Decrement (Local1)
                }
                ShiftLeft (Local1, 0x05, Local2)
                And (Local2, 0x80, Local2)
                And (FD15, 0x7F, Local3)
                Or (Local2, Local3, Local3)
                Store (Local3, FD15)
                And (Local1, 0x03, Local2)
                And (FND4, 0xFC, Local3)
                Or (Local2, Local3, Local3)
                Store (Local3, FND4)
                Sleep (0x32)
                Store (CFN3, Local0)
                Sleep (0x32)
                Store (CFN3, Local0)
                Sleep (0x32)
                Store (CFN3, Local0)
            }
            If (LAnd (LEqual (Local0, 0xFF), LEqual (Local1, 0x05)))
            {
                Return (Zero)
            }
            If (LAnd (LEqual (Local0, Zero), LEqual (Local1, 0x02)))
            {
                Return (0xFFFF)
            }
            Store (DerefOf (Index (FNDT, Local1)), Local2)
            Multiply (Local0, Local2, Local0)
            Divide (0x00149970, Local0, Local1, Local0)
            Return (Local0)
        }
        OperationRegion (HWRE, SystemIO, IOHW, 0x0A)
        Field (HWRE, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x05), 
            HIDX,   8, 
            HDAT,   8
        }
        IndexField (HIDX, HDAT, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x04), 
            CHNM,   1, 
            CFNM,   1, 
            CHNS,   2, 
            CFNS,   2, 
                    Offset (0x05), 
            SYST,   8, 
            TRGT,   8, 
                    Offset (0x08), 
            SSDN,   8, 
            CSDN,   8, 
            SSUP,   8, 
            CSUP,   8, 
                    Offset (0x20), 
            VCOR,   8, 
            V12V,   8, 
                    Offset (0x23), 
            V33V,   8, 
            V50V,   8, 
                    Offset (0x27), 
            MBTE,   8, 
            FAN1,   8, 
            FAN2,   8, 
            FAN3,   8, 
                    Offset (0x3F), 
            CFN3,   8, 
                    Offset (0x41), 
                ,   5, 
            AUIS,   1, 
                    Offset (0x42), 
                    Offset (0x47), 
            FDR1,   8, 
                    Offset (0x4B), 
            FD13,   8, 
            FD15,   8, 
                    Offset (0x4E), 
            BSEL,   4, 
                    Offset (0x4F), 
                    Offset (0x50), 
            TSR1,   8, 
                ,   7, 
            TSR2,   1, 
                    Offset (0x53), 
            FAN4,   8, 
                ,   7, 
            ATHL,   1, 
            ATOV,   8, 
                ,   7, 
            ATOL,   1, 
                    Offset (0x59), 
            FND4,   8, 
                ,   5, 
            AUTS,   1, 
                    Offset (0x5B), 
                    Offset (0x5D), 
            FD21,   8, 
                    Offset (0x7D), 
            SR7D,   8, 
            SR7E,   8
        }
    }
    Scope (_SB.PCI0.SBRG.ASOC)
    {
        Name (CORV, Package (0x05)
        {
            0x06020000, 
            "Vcore Voltage", 
            0x0320, 
            0x0640, 
            One
        })
        Name (V3VV, Package (0x05)
        {
            0x06020001, 
            " +3.3 Voltage", 
            0x0B9A, 
            0x0E2E, 
            One
        })
        Name (V5VV, Package (0x05)
        {
            0x06020002, 
            " +5 Voltage", 
            0x1194, 
            0x157C, 
            One
        })
        Name (VV12, Package (0x05)
        {
            0x06020003, 
            " +12 Voltage", 
            0x27D8, 
            0x35E8, 
            One
        })
        Name (VPAR, Package (0x04)
        {
            Package (0x03)
            {
                Zero, 
                One, 
                Zero
            }, 
            Package (0x03)
            {
                0x22, 
                0x22, 
                Zero
            }, 
            Package (0x03)
            {
                0x14, 
                0x0A, 
                Zero
            }, 
            Package (0x03)
            {
                0x3C, 
                0x0A, 
                Zero
            }
        })
        Name (VBUF, Package (0x05)
        {
            0x04, 
            CORV, 
            V3VV, 
            V5VV, 
            VV12
        })
        Method (VGET, 1, NotSerialized)
        {
            If (LEqual (Arg0, Zero))
            {
                Return (^^SIOR.HWV0 ())
            }
            If (LEqual (Arg0, One))
            {
                Return (^^SIOR.HWV3 ())
            }
            If (LEqual (Arg0, 0x02))
            {
                Return (^^SIOR.HWV4 ())
            }
            If (LEqual (Arg0, 0x03))
            {
                Return (^^SIOR.HWV1 ())
            }
            Return (Zero)
        }
        Name (CPUT, Package (0x05)
        {
            0x06030000, 
            "CPU Temperature", 
            0x0258, 
            0x03B6, 
            0x00010001
        })
        Name (MBTP, Package (0x05)
        {
            0x06030001, 
            "MB Temperature", 
            0x01C2, 
            0x02EE, 
            0x00010001
        })
        Name (TBUF, Package (0x03)
        {
            0x02, 
            CPUT, 
            MBTP
        })
        Method (TGET, 1, NotSerialized)
        {
            If (LEqual (Arg0, Zero))
            {
                Return (^^SIOR.HWT1 ())
            }
            If (LEqual (Arg0, One))
            {
                Return (^^SIOR.HWT0 ())
            }
            Return (Zero)
        }
        Name (CPUF, Package (0x05)
        {
            0x06040000, 
            "CPU FAN Speed", 
            0x0258, 
            0x1C20, 
            0x00010001
        })
        Name (CHF1, Package (0x05)
        {
            0x06040001, 
            "CHASSIS1 FAN Speed", 
            0x0258, 
            0x1C20, 
            0x00010001
        })
        Name (FBUF, Package (0x03)
        {
            0x02, 
            CPUF, 
            CHF1
        })
        Method (FGET, 1, NotSerialized)
        {
            If (LEqual (Arg0, Zero))
            {
                Return (^^SIOR.HWF1 ())
            }
            If (LEqual (Arg0, One))
            {
                Return (^^SIOR.HWF0 ())
            }
            Return (Zero)
        }
        Method (VSIF, 0, NotSerialized)
        {
            Return (VBUF)
        }
        Method (RVLT, 1, NotSerialized)
        {
            And (Arg0, 0xFFFF, Local0)
            Store (VGET (Local0), Local1)
            Store (DerefOf (Index (DerefOf (Index (VPAR, Local0)), Zero)), 
                Local2)
            Store (DerefOf (Index (DerefOf (Index (VPAR, Local0)), One)), 
                Local3)
            Store (DerefOf (Index (DerefOf (Index (VPAR, Local0)), 0x02)), 
                Local4)
            Multiply (Local1, Add (Local2, Local3), Local5)
            Divide (Local5, Local3, , Local5)
            Add (Local5, Local4, Local5)
            Return (Local5)
        }
        Method (SVLT, 1, NotSerialized)
        {
            And (DerefOf (Index (Arg0, Zero)), 0xFFFF, Local0)
            Store (DerefOf (Index (VBUF, Zero)), Local1)
            If (LGreaterEqual (Local0, Local1))
            {
                Return (Zero)
            }
            Increment (Local0)
            Store (DerefOf (Index (Arg0, One)), Index (DerefOf (Index (VBUF, 
                Local0)), One))
            Store (DerefOf (Index (Arg0, 0x02)), Index (DerefOf (Index (VBUF, 
                Local0)), 0x02))
            Store (DerefOf (Index (Arg0, 0x03)), Index (DerefOf (Index (VBUF, 
                Local0)), 0x03))
            Store (DerefOf (Index (Arg0, 0x04)), Index (DerefOf (Index (VBUF, 
                Local0)), 0x04))
            Return (One)
        }
        Method (TSIF, 0, NotSerialized)
        {
            Return (TBUF)
        }
        Method (RTMP, 1, NotSerialized)
        {
            And (Arg0, 0xFFFF, Local0)
            Store (TGET (Local0), Local1)
            Return (Local1)
        }
        Method (STMP, 1, NotSerialized)
        {
            Store (And (DerefOf (Index (Arg0, Zero)), 0xFFFF), Local0)
            Store (DerefOf (Index (TBUF, Zero)), Local1)
            If (LGreaterEqual (Local0, Local1))
            {
                Return (Zero)
            }
            Increment (Local0)
            Store (DerefOf (Index (Arg0, One)), Index (DerefOf (Index (TBUF, 
                Local0)), One))
            Store (DerefOf (Index (Arg0, 0x02)), Index (DerefOf (Index (TBUF, 
                Local0)), 0x02))
            Store (DerefOf (Index (Arg0, 0x03)), Index (DerefOf (Index (TBUF, 
                Local0)), 0x03))
            Store (DerefOf (Index (Arg0, 0x04)), Index (DerefOf (Index (TBUF, 
                Local0)), 0x04))
            Return (One)
        }
        Method (FSIF, 0, NotSerialized)
        {
            Return (FBUF)
        }
        Method (RFAN, 1, NotSerialized)
        {
            And (Arg0, 0xFFFF, Local0)
            Store (FGET (Local0), Local1)
            Return (Local1)
        }
        Method (SFAN, 1, NotSerialized)
        {
            And (DerefOf (Index (Arg0, Zero)), 0xFFFF, Local0)
            Store (DerefOf (Index (FBUF, Zero)), Local1)
            If (LGreaterEqual (Local0, Local1))
            {
                Return (Zero)
            }
            Increment (Local0)
            Store (DerefOf (Index (Arg0, One)), Index (DerefOf (Index (FBUF, 
                Local0)), One))
            Store (DerefOf (Index (Arg0, 0x02)), Index (DerefOf (Index (FBUF, 
                Local0)), 0x02))
            Store (DerefOf (Index (Arg0, 0x03)), Index (DerefOf (Index (FBUF, 
                Local0)), 0x03))
            Store (DerefOf (Index (Arg0, 0x04)), Index (DerefOf (Index (FBUF, 
                Local0)), 0x04))
            Store (DerefOf (Index (Arg0, 0x05)), Index (DerefOf (Index (FBUF, 
                Local0)), 0x05))
            Return (One)
        }
    }
    Scope (_SB.PCI0)
    {
        Device (GFX0)
        {
            Name (_ADR, 0x00020000)
            OperationRegion (IGDM, SystemMemory, 0xFF000000, 0x2000)
            Field (IGDM, AnyAcc, NoLock, Preserve)
            {
                SIGN,   128, 
                SIZE,   32, 
                OVER,   32, 
                SVER,   256, 
                VVER,   128, 
                GVER,   128, 
                MBOX,   32, 
                DMOD,   32, 
                        Offset (0xE0), 
                KSV0,   32, 
                KSV1,   8, 
                        Offset (0xF0), 
                IBTT,   8, 
                IPSC,   2, 
                IPAT,   4, 
                        Offset (0xF2), 
                IBIA,   3, 
                IBLC,   2, 
                    ,   1, 
                ITVF,   4, 
                ITVM,   4, 
                        Offset (0xF4), 
                IDVM,   1, 
                IDVS,   2, 
                ISSC,   1, 
                PAVP,   4, 
                CSTE,   16, 
                NSTE,   16, 
                        Offset (0x100), 
                DRDY,   32, 
                CSTS,   32, 
                CEVT,   32, 
                        Offset (0x120), 
                DIDL,   32, 
                DDL2,   32, 
                DDL3,   32, 
                DDL4,   32, 
                DDL5,   32, 
                DDL6,   32, 
                DDL7,   32, 
                DDL8,   32, 
                CPDL,   32, 
                CPL2,   32, 
                CPL3,   32, 
                CPL4,   32, 
                CPL5,   32, 
                CPL6,   32, 
                CPL7,   32, 
                CPL8,   32, 
                CADL,   32, 
                CAL2,   32, 
                CAL3,   32, 
                CAL4,   32, 
                CAL5,   32, 
                CAL6,   32, 
                CAL7,   32, 
                CAL8,   32, 
                NADL,   32, 
                NDL2,   32, 
                NDL3,   32, 
                NDL4,   32, 
                NDL5,   32, 
                NDL6,   32, 
                NDL7,   32, 
                NDL8,   32, 
                ASLP,   32, 
                TIDX,   32, 
                CHPD,   32, 
                CLID,   32, 
                CDCK,   32, 
                SXSW,   32, 
                EVTS,   32, 
                CNOT,   32, 
                NRDY,   32, 
                        Offset (0x200), 
                SCIE,   1, 
                GEFC,   4, 
                GXFC,   3, 
                GESF,   8, 
                        Offset (0x204), 
                PARM,   32, 
                DSLP,   32, 
                        Offset (0x300), 
                ARDY,   32, 
                ASLC,   32, 
                TCHE,   32, 
                ALSI,   32, 
                BCLP,   32, 
                PFIT,   32, 
                CBLV,   32, 
                BCLM,   320, 
                CPFM,   32, 
                EPFM,   32, 
                PLUT,   592, 
                PFMB,   32, 
                DDCV,   32, 
                        Offset (0x400), 
                GVD1,   49152, 
                PHED,   32, 
                BDDC,   2048
            }
            OperationRegion (TCOI, SystemIO, TOBS, 0x08)
            Field (TCOI, WordAcc, NoLock, Preserve)
            {
                        Offset (0x04), 
                    ,   9, 
                SCIS,   1, 
                        Offset (0x06)
            }
            Name (DBTB, Package (0x15)
            {
                Zero, 
                0x07, 
                0x38, 
                0x01C0, 
                0x0E00, 
                0x3F, 
                0x01C7, 
                0x0E07, 
                0x01F8, 
                0x0E38, 
                0x0FC0, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                0x7000, 
                0x7007, 
                0x7038, 
                0x71C0, 
                0x7E00
            })
            Method (GSCI, 0, Serialized)
            {
                If (LEqual (GEFC, 0x04))
                {
                    Store (GBDA (), GXFC)
                }
                If (LEqual (GEFC, 0x06))
                {
                    Store (SBCB (), GXFC)
                }
                Store (Zero, GEFC)
                Store (One, SCIS)
                Store (Zero, GSSE)
                Store (Zero, SCIE)
                Return (Zero)
            }
            Method (GBDA, 0, Serialized)
            {
                If (LEqual (GESF, Zero))
                {
                    If (LGreaterEqual (DVMT, 0x05))
                    {
                        Store (0x0679, PARM)
                    }
                    Else
                    {
                        Store (0x0279, PARM)
                    }
                    Store (Zero, GESF)
                    Return (SUCC)
                }
                If (LEqual (GESF, One))
                {
                    Store (0x0240, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x04))
                {
                    And (PARM, 0xEFFF0000, PARM)
                    And (PARM, ShiftLeft (DerefOf (Index (DBTB, IBTT)), 0x10), 
                        PARM)
                    Or (IBTT, PARM, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x05))
                {
                    Store (IPSC, PARM)
                    Or (PARM, ShiftLeft (IPAT, 0x08), PARM)
                    Add (PARM, 0x0100, PARM)
                    Or (PARM, ShiftLeft (LIDS, 0x10), PARM)
                    Add (PARM, 0x00010000, PARM)
                    Or (PARM, ShiftLeft (IBIA, 0x14), PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x06))
                {
                    Store (ITVF, PARM)
                    Or (PARM, ShiftLeft (ITVM, 0x04), PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x07))
                {
                    If (LGreaterEqual (DVMT, 0x05))
                    {
                        Store (GIVD, PARM)
                        XOr (PARM, One, PARM)
                        Or (PARM, ShiftLeft (GMFN, One), PARM)
                        Or (PARM, 0x1800, PARM)
                        Or (PARM, ShiftLeft (IDVS, 0x11), PARM)
                        Or (ShiftLeft (CDCT, 0x15), PARM, PARM)
                    }
                    Else
                    {
                        Name (MEMS, 0x0D)
                        Store (GIVD, PARM)
                        XOr (PARM, One, PARM)
                        Or (PARM, ShiftLeft (GMFN, One), PARM)
                        Or (PARM, 0x1000, PARM)
                        Or (ShiftLeft (CDCT, 0x15), PARM, PARM)
                        If (LEqual (IDVM, One))
                        {
                            Store (0x11, MEMS)
                        }
                        If (LLess (TASM, M512))
                        {
                            Or (PARM, ShiftLeft (One, MEMS), PARM)
                        }
                        Else
                        {
                            If (LLess (TASM, M1GB))
                            {
                                If (LLess (IDVS, 0x03))
                                {
                                    Or (PARM, ShiftLeft (IDVS, MEMS), PARM)
                                }
                                Else
                                {
                                    Or (PARM, ShiftLeft (0x02, MEMS), PARM)
                                }
                            }
                            Else
                            {
                                Or (PARM, ShiftLeft (IDVS, MEMS), PARM)
                            }
                        }
                    }
                    Store (One, GESF)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x0A))
                {
                    Store (Zero, PARM)
                    If (ISSC)
                    {
                        Or (PARM, 0x03, PARM)
                    }
                    Store (Zero, GESF)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x0B))
                {
                    Store (KSV0, PARM)
                    Store (KSV1, GESF)
                    Return (SUCC)
                }
                Store (Zero, GESF)
                Return (CRIT)
            }
            Method (SBCB, 0, Serialized)
            {
                If (LEqual (GESF, Zero))
                {
                    Store (0x20, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }
                If (LEqual (GESF, One))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x03))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x04))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x05))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x06))
                {
                    Store (And (PARM, 0x0F), ITVF)
                    Store (ShiftRight (And (PARM, 0xF0), 0x04), ITVM)
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x07))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x08))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x09))
                {
                    And (PARM, 0xFF, IBTT)
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x0A))
                {
                    And (PARM, 0xFF, IPSC)
                    If (And (ShiftRight (PARM, 0x08), 0xFF))
                    {
                        And (ShiftRight (PARM, 0x08), 0xFF, IPAT)
                        Decrement (IPAT)
                    }
                    And (ShiftRight (PARM, 0x14), 0x07, IBIA)
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x0B))
                {
                    If (LGreaterEqual (And (ShiftRight (PARM, 0x0B), 0x03), 
                        0x02))
                    {
                        And (ShiftRight (PARM, 0x0D), 0x0F, Local0)
                        And (ShiftRight (PARM, 0x11), 0x0F, Local1)
                        If (Local0)
                        {
                            Store (Zero, IDVM)
                            Store (Local0, IDVS)
                        }
                        If (Local1)
                        {
                            Store (One, IDVM)
                            Store (Local1, IDVS)
                        }
                    }
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x10))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x11))
                {
                    Store (ShiftLeft (LIDS, 0x08), PARM)
                    Add (PARM, 0x0100, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x12))
                {
                    If (And (PARM, One))
                    {
                        If (LEqual (ShiftRight (PARM, One), One))
                        {
                            Store (One, ISSC)
                        }
                        Else
                        {
                            Store (Zero, GESF)
                            Return (CRIT)
                        }
                    }
                    Else
                    {
                        Store (Zero, ISSC)
                    }
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LEqual (GESF, 0x13))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }
                If (LGreaterEqual (DVMT, 0x05))
                {
                    If (LEqual (GESF, 0x14))
                    {
                        And (PARM, 0x0F, PAVP)
                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }
                }
                Store (Zero, GESF)
                Return (SUCC)
            }
            Scope (^^PCI0)
            {
                OperationRegion (MCHP, PCI_Config, 0x40, 0xC0)
                Field (MCHP, AnyAcc, NoLock, Preserve)
                {
                            Offset (0x60), 
                    TASM,   10, 
                            Offset (0x62)
                }
            }
            OperationRegion (IGDP, PCI_Config, 0x40, 0xC0)
            Field (IGDP, AnyAcc, NoLock, Preserve)
            {
                        Offset (0x12), 
                    ,   1, 
                GIVD,   1, 
                    ,   2, 
                GUMA,   4, 
                        Offset (0x14), 
                    ,   4, 
                GMFN,   1, 
                        Offset (0x18), 
                        Offset (0x8C), 
                CDCT,   10, 
                        Offset (0x8E), 
                        Offset (0xA8), 
                GSSE,   1, 
                GSSB,   14, 
                GSES,   1, 
                        Offset (0xBC), 
                ASLS,   32
            }
            Name (M512, 0x08)
            Name (M1GB, 0x10)
            Scope (\_GPE)
            {
                Method (_L06, 0, NotSerialized)
                {
                    \_SB.PCI0.GFX0.GSCI ()
                }
            }
            Name (OPBS, 0xFFFFFF00)
            Method (OPTS, 1, NotSerialized)
            {
                If (LEqual (Arg0, 0x03))
                {
                    Store (ASLS, OPBS)
                }
            }
            Method (OWAK, 1, NotSerialized)
            {
                If (LEqual (Arg0, 0x03))
                {
                    Store (OPBS, ASLS)
                    Store (One, GSES)
                }
            }
        }
    }
    Scope (_SB.PCI0.SBRG.SIOR)
    {
        Method (SIAS, 1, NotSerialized)
        {
            ENFG (0x09)
            If (LEqual (Arg0, 0x03))
            {
                Or (OPT1, 0x04, OPT1)
                And (OPT0, 0xFB, OPT0)
            }
            EXFG ()
        }
    }
    Scope (_SB)
    {
        Scope (PCI0)
        {
            Name (CRS, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x00FF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0100,             // Length
                    ,, )
                IO (Decode16,
                    0x0CF8,             // Range Minimum
                    0x0CF8,             // Range Maximum
                    0x01,               // Alignment
                    0x08,               // Length
                    )
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x0CF7,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0CF8,             // Length
                    ,, , TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0D00,             // Range Minimum
                    0xFFFF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0xF300,             // Length
                    ,, , TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000A0000,         // Range Minimum
                    0x000BFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C0000,         // Range Minimum
                    0x000DFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, _Y1A, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000001,         // Length
                    ,, _Y1B, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000001,         // Length
                    ,, _Y1C, AddressRangeMemory, TypeStatic)
            })
            CreateDWordField (CRS, \_SB.PCI0._Y1A._MIN, MIN5)
            CreateDWordField (CRS, \_SB.PCI0._Y1A._MAX, MAX5)
            CreateDWordField (CRS, \_SB.PCI0._Y1A._LEN, LEN5)
            CreateDWordField (CRS, \_SB.PCI0._Y1B._MIN, MIN6)
            CreateDWordField (CRS, \_SB.PCI0._Y1B._MAX, MAX6)
            CreateDWordField (CRS, \_SB.PCI0._Y1B._LEN, LEN6)
            CreateDWordField (CRS, \_SB.PCI0._Y1C._MIN, MIN7)
            CreateDWordField (CRS, \_SB.PCI0._Y1C._MAX, MAX7)
            CreateDWordField (CRS, \_SB.PCI0._Y1C._LEN, LEN7)
            Method (_CRS, 0, NotSerialized)
            {
                Store (MG1L, Local0)
                If (Local0)
                {
                    Store (MG1B, MIN5)
                    Store (MG1L, LEN5)
                    Add (MIN5, Decrement (Local0), MAX5)
                }
                Store (MG2B, MIN6)
                Store (MG2L, LEN6)
                Store (MG2L, Local0)
                Add (MIN6, Decrement (Local0), MAX6)
                Store (MG3B, MIN7)
                Store (MG3L, LEN7)
                Store (MG3L, Local0)
                Add (MIN7, Decrement (Local0), MAX7)
                Return (CRS)
            }
        }
    }
    Name (WOTB, Zero)
    Name (WSSB, Zero)
    Name (WAXB, Zero)
    Method (_PTS, 1, NotSerialized)
    {
        Store (Arg0, DBG8)
        PTS (Arg0)
        Store (0x12, DBG8)
        Store (0x89, DBG8)
        Store (Zero, Index (WAKP, Zero))
        Store (Zero, Index (WAKP, One))
        If (LAnd (LEqual (Arg0, 0x04), LEqual (OSFL (), 0x02)))
        {
            Sleep (0x0BB8)
        }
        Store (ASSB, WSSB)
        Store (AOTB, WOTB)
        Store (AAXB, WAXB)
        Store (0x78, DBG8)
        Store (Arg0, ASSB)
        Store (OSFL (), AOTB)
        Store (OSYS (), OSTP)
        Store (Zero, AAXB)
        Store (0x56, DBG8)
    }
    Method (_WAK, 1, NotSerialized)
    {
        ShiftLeft (Arg0, 0x04, DBG8)
        WAK (Arg0)
        If (IOWK) {}
        Else
        {
            Notify (\_SB.PWRB, 0x02)
        }
        If (ASSB)
        {
            Store (WSSB, ASSB)
            Store (WOTB, AOTB)
            Store (WAXB, AAXB)
        }
        If (DerefOf (Index (WAKP, Zero)))
        {
            Store (Zero, Index (WAKP, One))
        }
        Else
        {
            Store (Arg0, Index (WAKP, One))
        }
        Return (WAKP)
    }
    OperationRegion (IORK, SystemIO, 0xB3, One)
    Field (IORK, ByteAcc, NoLock, Preserve)
    {
        IOWK,   8
    }
    Scope (_SB.PCI0)
    {
        OperationRegion (TVID, SystemMemory, 0xFED40F00, 0x02)
        Field (TVID, WordAcc, NoLock, Preserve)
        {
            VIDT,   16
        }
    }
    Device (_SB.PCI0.SBRG.TPM)
    {
        Method (_HID, 0, NotSerialized)
        {
            If (LEqual (SFLG, One))
            {
                Return (0x0435CF4D)
            }
            Else
            {
                Return (0x0201D824)
            }
        }
        Name (_CID, EisaId ("PNP0C31"))
        Name (_UID, One)
        Name (_CRS, ResourceTemplate ()
        {
            IO (Decode16,
                0x004E,             // Range Minimum
                0x004E,             // Range Maximum
                0x01,               // Alignment
                0x02,               // Length
                )
            IO (Decode16,
                0x4700,             // Range Minimum
                0x4700,             // Range Maximum
                0x01,               // Alignment
                0x0C,               // Length
                )
            Memory32Fixed (ReadWrite,
                0xFED40000,         // Address Base
                0x00005000,         // Address Length
                )
        })
        Method (_STA, 0, NotSerialized)
        {
            If (TPMF)
            {
                If (LNotEqual (VIDT, 0x8086))
                {
                    Return (0x0F)
                }
                Return (Zero)
            }
            Else
            {
                Return (Zero)
            }
        }
    }
    Device (_SB.PCI0.ITPM)
    {
        Name (_HID, "INTC0102")
        Name (_CID, EisaId ("PNP0C31"))
        Name (_UID, One)
        Name (_CRS, ResourceTemplate ()
        {
            Memory32Fixed (ReadWrite,
                0xFED40000,         // Address Base
                0x00005000,         // Address Length
                )
        })
        Method (_STA, 0, NotSerialized)
        {
            If (TPMF)
            {
                If (LEqual (VIDT, 0x8086))
                {
                    Return (0x0F)
                }
                Return (Zero)
            }
            Return (Zero)
        }
    }
    Scope (_SB.PCI0.SBRG.TPM)
    {
        Name (TAAX, Zero)
        OperationRegion (MIPT, SystemIO, SMIT, One)
        Field (MIPT, ByteAcc, NoLock, Preserve)
        {
            PSMI,   8
        }
        Name (PPI1, Package (0x02)
        {
            Zero, 
            Zero
        })
        Name (PPI2, Package (0x03)
        {
            Zero, 
            Zero, 
            Zero
        })
        Name (MBUF, Buffer (0x04) {})
        CreateByteField (MBUF, Zero, BUF0)
        CreateByteField (MBUF, One, BUF1)
        CreateByteField (MBUF, 0x02, BUF2)
        CreateByteField (MBUF, 0x03, BUF3)
        Method (_DSM, 4, NotSerialized)
        {
            If (LEqual (Arg0, Buffer (0x10)
                    {
                        /* 0000 */    0xA6, 0xFA, 0xDD, 0x3D, 0x1B, 0x36, 0xB4, 0x4E, 
                        /* 0008 */    0xA4, 0x24, 0x8D, 0x10, 0x08, 0x9D, 0x16, 0x53
                    }))
            {
                Name (T_0, Zero)
                Store (ToInteger (Arg2), T_0)
                If (LEqual (T_0, Zero))
                {
                    Return (Buffer (One)
                    {
                        0x7F
                    })
                }
                Else
                {
                    If (LEqual (T_0, One))
                    {
                        Return ("1.0")
                    }
                    Else
                    {
                        If (LEqual (T_0, 0x02))
                        {
                            Store (AAXB, TAAX)
                            Store (CMRQ, BUF0)
                            Store (0xF0, BUF1)
                            Store (ToInteger (DerefOf (Index (Arg3, Zero))), BUF2)
                            Store (One, BUF3)
                            Store (MBUF, AAXB)
                            Store (0xFB, PSMI)
                            Sleep (0x03E8)
                            Store (TAAX, AAXB)
                            Return (Zero)
                        }
                        Else
                        {
                            If (LEqual (T_0, 0x03))
                            {
                                Store (AAXB, TAAX)
                                Store (CMRQ, BUF0)
                                Store (0x0F, BUF1)
                                Store (Zero, BUF2)
                                Store (Zero, BUF3)
                                Store (MBUF, AAXB)
                                Store (0xFB, PSMI)
                                Sleep (0x03E8)
                                Store (AAXB, MBUF)
                                Store (BUF2, Local3)
                                Store (Zero, Index (PPI1, Zero))
                                Store (Local3, Index (PPI1, One))
                                Store (TAAX, AAXB)
                                Return (PPI1)
                            }
                            Else
                            {
                                If (LEqual (T_0, 0x04))
                                {
                                    Return (0x02)
                                }
                                Else
                                {
                                    If (LEqual (T_0, 0x05))
                                    {
                                        Store (AAXB, TAAX)
                                        Store (CMRQ, BUF0)
                                        Store (0xF0, BUF1)
                                        Store (Zero, BUF2)
                                        Store (Zero, BUF3)
                                        Store (MBUF, AAXB)
                                        Store (0xFB, PSMI)
                                        Sleep (0x03E8)
                                        Store (AAXB, MBUF)
                                        ShiftRight (BUF2, 0x04, Local3)
                                        Store (CMER, BUF0)
                                        Store (0xFF, BUF1)
                                        Store (Zero, BUF2)
                                        Store (Zero, BUF3)
                                        Store (MBUF, AAXB)
                                        Store (0xFB, PSMI)
                                        Sleep (0x03E8)
                                        Store (AAXB, MBUF)
                                        Store (BUF2, Local6)
                                        Add (CMER, One, Local4)
                                        Store (Local4, BUF0)
                                        Store (0xFF, BUF1)
                                        Store (Zero, BUF2)
                                        Store (Zero, BUF3)
                                        Store (MBUF, AAXB)
                                        Store (0xFB, PSMI)
                                        Sleep (0x03E8)
                                        Store (AAXB, MBUF)
                                        Store (BUF2, Local7)
                                        Multiply (Local7, 0x0100, Local2)
                                        Add (Local2, Local6, Local2)
                                        Store (Zero, Index (PPI2, Zero))
                                        Store (Local3, Index (PPI2, One))
                                        If (LEqual (Local2, 0xFFF0))
                                        {
                                            Store (0xFFFFFFF0, Index (PPI2, 0x02))
                                        }
                                        Else
                                        {
                                            If (LEqual (Local2, 0xFFF1))
                                            {
                                                Store (0xFFFFFFF1, Index (PPI2, 0x02))
                                            }
                                            Else
                                            {
                                                Store (Local2, Index (PPI2, 0x02))
                                            }
                                        }
                                        Store (TAAX, AAXB)
                                        Return (PPI2)
                                    }
                                    Else
                                    {
                                        If (LEqual (T_0, 0x06))
                                        {
                                            Return (Zero)
                                        }
                                        Else
                                        {
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            Else
            {
                If (LEqual (Arg0, Buffer (0x10)
                        {
                            /* 0000 */    0xED, 0x54, 0x60, 0x37, 0x13, 0xCC, 0x75, 0x46, 
                            /* 0008 */    0x90, 0x1C, 0x47, 0x56, 0xD7, 0xF2, 0xD4, 0x5D
                        }))
                {
                    Name (T_1, Zero)
                    Store (ToInteger (Arg2), T_1)
                    If (LEqual (T_1, Zero))
                    {
                        Return (Buffer (One)
                        {
                            0x03
                        })
                    }
                    Else
                    {
                        If (LEqual (T_1, One))
                        {
                            Store (AAXB, TAAX)
                            Store (CMOR, BUF0)
                            Store (0xFE, BUF1)
                            Store (ToInteger (DerefOf (Index (Arg3, Zero))), BUF2)
                            Store (One, BUF3)
                            Store (MBUF, AAXB)
                            Store (0xFB, PSMI)
                            Sleep (0x0BB8)
                            Store (TAAX, AAXB)
                            Return (Zero)
                        }
                        Else
                        {
                        }
                    }
                }
            }
            Return (Buffer (One)
            {
                0x00
            })
        }
    }
    Scope (_SB.PCI0.ITPM)
    {
        Name (TAAX, Zero)
        OperationRegion (MIPT, SystemIO, SMIT, One)
        Field (MIPT, ByteAcc, NoLock, Preserve)
        {
            PSMI,   8
        }
        Name (PPI1, Package (0x02)
        {
            Zero, 
            Zero
        })
        Name (PPI2, Package (0x03)
        {
            Zero, 
            Zero, 
            Zero
        })
        Name (MBUF, Buffer (0x04) {})
        CreateByteField (MBUF, Zero, BUF0)
        CreateByteField (MBUF, One, BUF1)
        CreateByteField (MBUF, 0x02, BUF2)
        CreateByteField (MBUF, 0x03, BUF3)
        Method (_DSM, 4, NotSerialized)
        {
            If (LEqual (Arg0, Buffer (0x10)
                    {
                        /* 0000 */    0xA6, 0xFA, 0xDD, 0x3D, 0x1B, 0x36, 0xB4, 0x4E, 
                        /* 0008 */    0xA4, 0x24, 0x8D, 0x10, 0x08, 0x9D, 0x16, 0x53
                    }))
            {
                Name (T_0, Zero)
                Store (ToInteger (Arg2), T_0)
                If (LEqual (T_0, Zero))
                {
                    Return (Buffer (One)
                    {
                        0x7F
                    })
                }
                Else
                {
                    If (LEqual (T_0, One))
                    {
                        Return ("1.0")
                    }
                    Else
                    {
                        If (LEqual (T_0, 0x02))
                        {
                            Store (AAXB, TAAX)
                            Store (CMRQ, BUF0)
                            Store (0xF0, BUF1)
                            Store (ToInteger (DerefOf (Index (Arg3, Zero))), BUF2)
                            Store (One, BUF3)
                            Store (MBUF, AAXB)
                            Store (0xFB, PSMI)
                            Sleep (0x03E8)
                            Store (TAAX, AAXB)
                            Return (Zero)
                        }
                        Else
                        {
                            If (LEqual (T_0, 0x03))
                            {
                                Store (AAXB, TAAX)
                                Store (CMRQ, BUF0)
                                Store (0x0F, BUF1)
                                Store (Zero, BUF2)
                                Store (Zero, BUF3)
                                Store (MBUF, AAXB)
                                Store (0xFB, PSMI)
                                Sleep (0x03E8)
                                Store (AAXB, MBUF)
                                Store (BUF2, Local3)
                                Store (Zero, Index (PPI1, Zero))
                                Store (Local3, Index (PPI1, One))
                                Store (TAAX, AAXB)
                                Return (PPI1)
                            }
                            Else
                            {
                                If (LEqual (T_0, 0x04))
                                {
                                    Return (0x02)
                                }
                                Else
                                {
                                    If (LEqual (T_0, 0x05))
                                    {
                                        Store (AAXB, TAAX)
                                        Store (CMRQ, BUF0)
                                        Store (0xF0, BUF1)
                                        Store (Zero, BUF2)
                                        Store (Zero, BUF3)
                                        Store (MBUF, AAXB)
                                        Store (0xFB, PSMI)
                                        Sleep (0x03E8)
                                        Store (AAXB, MBUF)
                                        ShiftRight (BUF2, 0x04, Local3)
                                        Store (CMER, BUF0)
                                        Store (0xFF, BUF1)
                                        Store (Zero, BUF2)
                                        Store (Zero, BUF3)
                                        Store (MBUF, AAXB)
                                        Store (0xFB, PSMI)
                                        Sleep (0x03E8)
                                        Store (AAXB, MBUF)
                                        Store (BUF2, Local6)
                                        Add (CMER, One, Local4)
                                        Store (Local4, BUF0)
                                        Store (0xFF, BUF1)
                                        Store (Zero, BUF2)
                                        Store (Zero, BUF3)
                                        Store (MBUF, AAXB)
                                        Store (0xFB, PSMI)
                                        Sleep (0x03E8)
                                        Store (AAXB, MBUF)
                                        Store (BUF2, Local7)
                                        Multiply (Local7, 0x0100, Local2)
                                        Add (Local2, Local6, Local2)
                                        Store (Zero, Index (PPI2, Zero))
                                        Store (Local3, Index (PPI2, One))
                                        If (LEqual (Local2, 0xFFF0))
                                        {
                                            Store (0xFFFFFFF0, Index (PPI2, 0x02))
                                        }
                                        Else
                                        {
                                            If (LEqual (Local2, 0xFFF1))
                                            {
                                                Store (0xFFFFFFF1, Index (PPI2, 0x02))
                                            }
                                            Else
                                            {
                                                Store (Local2, Index (PPI2, 0x02))
                                            }
                                        }
                                        Store (TAAX, AAXB)
                                        Return (PPI2)
                                    }
                                    Else
                                    {
                                        If (LEqual (T_0, 0x06))
                                        {
                                            Return (Zero)
                                        }
                                        Else
                                        {
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            Else
            {
                If (LEqual (Arg0, Buffer (0x10)
                        {
                            /* 0000 */    0xED, 0x54, 0x60, 0x37, 0x13, 0xCC, 0x75, 0x46, 
                            /* 0008 */    0x90, 0x1C, 0x47, 0x56, 0xD7, 0xF2, 0xD4, 0x5D
                        }))
                {
                    Name (T_1, Zero)
                    Store (ToInteger (Arg2), T_1)
                    If (LEqual (T_1, Zero))
                    {
                        Return (Buffer (One)
                        {
                            0x03
                        })
                    }
                    Else
                    {
                        If (LEqual (T_1, One))
                        {
                            Store (AAXB, TAAX)
                            Store (CMOR, BUF0)
                            Store (0xFE, BUF1)
                            Store (ToInteger (DerefOf (Index (Arg3, Zero))), BUF2)
                            Store (One, BUF3)
                            Store (MBUF, AAXB)
                            Store (0xFB, PSMI)
                            Sleep (0x0BB8)
                            Store (TAAX, AAXB)
                            Return (Zero)
                        }
                        Else
                        {
                        }
                    }
                }
            }
            Return (Buffer (One)
            {
                0x00
            })
        }
    }
    Name (_S0, Package (0x04)
    {
        Zero, 
        Zero, 
        Zero, 
        Zero
    })
    If (SS1)
    {
        Name (_S1, Package (0x04)
        {
            One, 
            Zero, 
            Zero, 
            Zero
        })
    }
    If (SS3)
    {
        Name (_S3, Package (0x04)
        {
            0x05, 
            Zero, 
            Zero, 
            Zero
        })
    }
    If (SS4)
    {
        Name (_S4, Package (0x04)
        {
            0x06, 
            Zero, 
            Zero, 
            Zero
        })
    }
    Name (_S5, Package (0x04)
    {
        0x07, 
        Zero, 
        Zero, 
        Zero
    })
    Method (PTS, 1, NotSerialized)
    {
        If (Arg0)
        {
            \_SB.PCI0.SBRG.SIOS (Arg0)
            \_SB.PCI0.NPTS (Arg0)
            \_SB.PCI0.SBRG.SPTS (Arg0)
            \_SB.PCI0.GFX0.OPTS (Arg0)
            \_SB.PCI0.SBRG.SIOR.SIAS (Arg0)
        }
    }
    Method (WAK, 1, NotSerialized)
    {
        \_SB.PCI0.SBRG.SIOW (Arg0)
        \_SB.PCI0.NWAK (Arg0)
        \_SB.PCI0.SBRG.SWAK (Arg0)
        \_SB.PCI0.GFX0.OWAK (Arg0)
    }
}
