﻿
if GetLocale() ~= "zhCN" then return end

local achiv = "大脚提供坐骑来源(成就):"
local drop = "大脚提供坐骑来源:"

local mountsDB = MountsDBCN or {}

local function MountsDBReader(SpellId)
	if mountsDB[SpellId] then
		return true,mountsDB[SpellId][2],mountsDB[SpellId][3],mountsDB[SpellId][4]
	end
end

local function MountsSourceFrame_GetMountInfo(SpellId)
	local switch,achivment,drop_name,instance_name = MountsDBReader(SpellId)
	if switch then
		local text
		if achivment~="0" then
			local _,ach
			_,ach = GetAchievementInfo(achivment)
			text = achiv .. ach
			if instance_name~="0" then
				text = text .. "-" .. instance_name
			end
			return text
		elseif drop_name~="0"  then
			text = drop .. drop_name
			if instance_name~="0" then
				text = text .. "-" .. instance_name
			end
			return text
		end
	end
end

local function __ShowMountInfo(toolTip,...)
	local id = select(11,UnitBuff(...))
	if id then
		local text = MountsSourceFrame_GetMountInfo(id)
		if text then
			toolTip:AddDoubleLine(text)
			toolTip:Show()
		end
	end
end

--目标提示
hooksecurefunc(GameTooltip, "SetUnitBuff", function(self,...)
	__ShowMountInfo(self,...);
end)

--自身提示
hooksecurefunc(GameTooltip, "SetUnitAura", function(self,...)
	__ShowMountInfo(self,...);
end)
