
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/soldier.zip" ),
}
local prefabs = { "soldierhelmet", "sparks" }
local start_inv = { "soldierhelmet", "shovel" }

local fn = function(inst)

	inst.components.health:SetMaxHealth(200)
	inst.components.combat.damagemultiplier = 1.75
	inst.components.health:SetAbsorptionAmount(TUNING.WATHGRITHR_ABSORPTION)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 0.8)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 0.8)

	-- choose which sounds this character will play
	inst.soundsname = "wolfgang"

	-- a minimap icon must be specified
    inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("soldiermini.tex")
end
	-- todo: Add an example special power here.
STRINGS.CHARACTER_TITLES.soldier = "ʿ"
STRINGS.CHARACTER_NAMES.soldier = "Jane Doe"
STRINGS.CHARACTER_DESCRIPTIONS.soldier ="*ǿ\n*ͷ\n*һ"
STRINGS.CHARACTER_QUOTES.soldier = "\"ǻ.\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.SOLDIER = require "speech_x"

return MakePlayerCharacter("soldier", prefabs, assets, fn, start_inv)