local assets=
{
	Asset("ANIM", "anim/soldierhelmet.zip"),
	
	Asset("IMAGE", "images/inventoryimages/soldierhelmet.tex"),	
    Asset("ATLAS", "images/inventoryimages/soldierhelmet.xml")
}

local function onequip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "soldierhelmet", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
        
        if owner:HasTag("player") then
			owner.AnimState:Hide("HEAD")
			owner.AnimState:Show("HEAD_HAIR")
		end
end

local function onunequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

		if owner:HasTag("player") then
	        owner.AnimState:Show("HEAD")
			owner.AnimState:Hide("HEAD_HAIR")
		end
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst:AddTag("hat")
    
    anim:SetBank("tophat")
    anim:SetBuild("soldierhelmet")
    anim:PlayAnimation("anim")    
        
	inst:AddComponent("waterproofer")
	    inst.components.waterproofer.effectiveness = 0  
		
    inst:AddComponent("inspectable")
	
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/soldierhelmet.xml"
	
	inst:AddComponent("armor")
	                            inst.components.armor:InitCondition(TUNING.ARMORRUINS, TUNING.ARMORRUINS_ABSORPTION)    
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end

return Prefab( "common/inventory/soldierhelmet", fn, assets) 
