/*
 * Decompiled with CFR 0.152.
 */
package de.promolitor.tchelper.helper;

import de.promolitor.tchelper.TCHelperMain;
import de.promolitor.tchelper.helper.Hexagon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import thaumcraft.api.aspects.Aspect;

public class AspectCalculation {
    public static final int[][] NEIGHBOURS = new int[][]{{1, 0}, {1, -1}, {0, -1}, {-1, 0}, {-1, 1}, {0, 1}};
    public static UndirectedGraph<String, DefaultWeightedEdge> graph;
    public static HashMap<String, Aspect> map;
    public static ArrayList<String[]> solvedIssues;

    public static int getDistance(Hexagon a1, Hexagon a2) {
        return (Math.abs(a1.q - a2.q) + Math.abs(a1.r - a2.r) + Math.abs(a1.q + a1.r - a2.q - a2.r)) / 2;
    }

    public static void clearIssues() {
        solvedIssues = new ArrayList();
    }

    public static String[] solveIssues(Aspect start, Aspect destination) {
        int i;
        DijkstraShortestPath<String, DefaultWeightedEdge> test = new DijkstraShortestPath<String, DefaultWeightedEdge>(graph, start.getTag(), destination.getTag());
        List<DefaultWeightedEdge> list = test.getPathEdgeList();
        String[] paths = new String[list.size() + 1];
        DefaultWeightedEdge first = list.remove(0);
        String stripped = first.toString().replaceAll(" ", "").replaceAll("\\(", "").replaceAll("\\)", "");
        String[] splitted = stripped.split(":");
        if (splitted[0].equals(start.getTag())) {
            paths[0] = start.getTag();
            paths[1] = splitted[1];
        } else {
            paths[0] = start.getTag();
            paths[1] = splitted[0];
        }
        if (TCHelperMain.debugging) {
            System.out.println("");
            System.out.println("-----STARTING DIJKSTRA-----");
            i = 2;
            for (DefaultWeightedEdge object : list) {
                DefaultWeightedEdge a = object;
                stripped = a.toString().replaceAll(" ", "").replaceAll("\\(", "").replaceAll("\\)", "");
                splitted = stripped.split("\\:");
                paths[i] = paths[i - 1].equals(splitted[0]) ? splitted[1] : splitted[0];
                ++i;
            }
        }
        if (TCHelperMain.debugging) {
            System.out.println("");
            for (i = 0; i < paths.length; ++i) {
                System.out.println(paths[i]);
            }
            System.out.println("");
        }
        solvedIssues.add(paths);
        return paths;
    }

    public static void createGraph() {
        graph = new SimpleWeightedGraph<String, DefaultWeightedEdge>(DefaultWeightedEdge.class);
        graph.addVertex(Aspect.AIR.getTag());
        graph.addVertex(Aspect.EARTH.getTag());
        graph.addVertex(Aspect.FIRE.getTag());
        graph.addVertex(Aspect.WATER.getTag());
        graph.addVertex(Aspect.ORDER.getTag());
        graph.addVertex(Aspect.ENTROPY.getTag());
        graph.addVertex(Aspect.VOID.getTag());
        graph.addVertex(Aspect.LIGHT.getTag());
        graph.addVertex(Aspect.MOTION.getTag());
        graph.addVertex(Aspect.COLD.getTag());
        graph.addVertex(Aspect.CRYSTAL.getTag());
        graph.addVertex(Aspect.METAL.getTag());
        graph.addVertex(Aspect.LIFE.getTag());
        graph.addVertex(Aspect.DEATH.getTag());
        graph.addVertex(Aspect.ENERGY.getTag());
        graph.addVertex(Aspect.EXCHANGE.getTag());
        graph.addVertex(Aspect.AURA.getTag());
        graph.addVertex(Aspect.FLUX.getTag());
        graph.addVertex(Aspect.DARKNESS.getTag());
        graph.addVertex(Aspect.ELDRITCH.getTag());
        graph.addVertex(Aspect.FLIGHT.getTag());
        graph.addVertex(Aspect.PLANT.getTag());
        graph.addVertex(Aspect.TOOL.getTag());
        graph.addVertex(Aspect.CRAFT.getTag());
        graph.addVertex(Aspect.MECHANISM.getTag());
        graph.addVertex(Aspect.TRAP.getTag());
        graph.addVertex(Aspect.SOUL.getTag());
        graph.addVertex(Aspect.MIND.getTag());
        graph.addVertex(Aspect.SENSES.getTag());
        graph.addVertex(Aspect.AVERSION.getTag());
        graph.addVertex(Aspect.PROTECT.getTag());
        graph.addVertex(Aspect.DESIRE.getTag());
        graph.addVertex(Aspect.UNDEAD.getTag());
        graph.addVertex(Aspect.BEAST.getTag());
        graph.addVertex(Aspect.MAN.getTag());
        Graphs.addEdge(graph, Aspect.VOID.getTag(), Aspect.AIR.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.VOID.getTag(), Aspect.ENTROPY.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.LIGHT.getTag(), Aspect.AIR.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.LIGHT.getTag(), Aspect.FIRE.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.MOTION.getTag(), Aspect.AIR.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.MOTION.getTag(), Aspect.ORDER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.COLD.getTag(), Aspect.FIRE.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.COLD.getTag(), Aspect.ENTROPY.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.CRYSTAL.getTag(), Aspect.EARTH.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.CRYSTAL.getTag(), Aspect.AIR.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.METAL.getTag(), Aspect.EARTH.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.METAL.getTag(), Aspect.ORDER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.LIFE.getTag(), Aspect.EARTH.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.LIFE.getTag(), Aspect.WATER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.DEATH.getTag(), Aspect.WATER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.DEATH.getTag(), Aspect.ENTROPY.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.ENERGY.getTag(), Aspect.ORDER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.ENERGY.getTag(), Aspect.FIRE.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.EXCHANGE.getTag(), Aspect.ENTROPY.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.EXCHANGE.getTag(), Aspect.ORDER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.AURA.getTag(), Aspect.ENERGY.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.AURA.getTag(), Aspect.AIR.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.FLUX.getTag(), Aspect.ENTROPY.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.FLUX.getTag(), Aspect.ENERGY.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.DARKNESS.getTag(), Aspect.VOID.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.DARKNESS.getTag(), Aspect.LIGHT.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.ELDRITCH.getTag(), Aspect.VOID.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.ELDRITCH.getTag(), Aspect.DARKNESS.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.FLIGHT.getTag(), Aspect.AIR.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.FLIGHT.getTag(), Aspect.MOTION.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.PLANT.getTag(), Aspect.LIFE.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.PLANT.getTag(), Aspect.EARTH.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.TOOL.getTag(), Aspect.METAL.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.TOOL.getTag(), Aspect.ENERGY.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.CRAFT.getTag(), Aspect.EXCHANGE.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.CRAFT.getTag(), Aspect.TOOL.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.MECHANISM.getTag(), Aspect.MOTION.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.MECHANISM.getTag(), Aspect.TOOL.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.TRAP.getTag(), Aspect.MOTION.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.TRAP.getTag(), Aspect.ENTROPY.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.SOUL.getTag(), Aspect.LIFE.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.SOUL.getTag(), Aspect.DEATH.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.MIND.getTag(), Aspect.FIRE.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.MIND.getTag(), Aspect.SOUL.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.SENSES.getTag(), Aspect.AIR.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.SENSES.getTag(), Aspect.SOUL.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.AVERSION.getTag(), Aspect.SOUL.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.AVERSION.getTag(), Aspect.ENTROPY.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.PROTECT.getTag(), Aspect.SOUL.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.PROTECT.getTag(), Aspect.EARTH.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.DESIRE.getTag(), Aspect.SOUL.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.DESIRE.getTag(), Aspect.VOID.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.UNDEAD.getTag(), Aspect.MOTION.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.UNDEAD.getTag(), Aspect.DEATH.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.BEAST.getTag(), Aspect.MOTION.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.BEAST.getTag(), Aspect.LIFE.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.MAN.getTag(), Aspect.SOUL.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.MAN.getTag(), Aspect.LIFE.getTag(), 6.0);
        map.put("aer", Aspect.AIR);
        map.put("terra", Aspect.EARTH);
        map.put("ignis", Aspect.FIRE);
        map.put("aqua", Aspect.WATER);
        map.put("perditio", Aspect.ENTROPY);
        map.put("ordo", Aspect.ORDER);
        map.put("vacuos", Aspect.VOID);
        map.put("lux", Aspect.LIGHT);
        map.put("motus", Aspect.MOTION);
        map.put("gelum", Aspect.COLD);
        map.put("vitreus", Aspect.CRYSTAL);
        map.put("metallum", Aspect.METAL);
        map.put("victus", Aspect.LIFE);
        map.put("mortuus", Aspect.DEATH);
        map.put("potentia", Aspect.ENERGY);
        map.put("permutatio", Aspect.EXCHANGE);
        map.put("auram", Aspect.AURA);
        map.put("vitium", Aspect.FLUX);
        map.put("tenebrae", Aspect.DARKNESS);
        map.put("alienis", Aspect.ELDRITCH);
        map.put("volatus", Aspect.FLIGHT);
        map.put("herba", Aspect.PLANT);
        map.put("instrumentum", Aspect.TOOL);
        map.put("fabrico", Aspect.CRAFT);
        map.put("machina", Aspect.MECHANISM);
        map.put("vinculum", Aspect.TRAP);
        map.put("spiritus", Aspect.SOUL);
        map.put("cognitio", Aspect.MIND);
        map.put("sensus", Aspect.SENSES);
        map.put("aversio", Aspect.AVERSION);
        map.put("praemunio", Aspect.PROTECT);
        map.put("desiderium", Aspect.DESIRE);
        map.put("exanimis", Aspect.UNDEAD);
        map.put("bestia", Aspect.BEAST);
        map.put("humanus", Aspect.MAN);
    }

    static {
        map = new HashMap();
    }
}

