/*
 * Decompiled with CFR 0.152.
 */
package de.promolitor.tchelper;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import de.promolitor.tchelper.TCHelperMain;
import de.promolitor.tchelper.helper.AspectCalculation;
import de.promolitor.tchelper.helper.Combination;
import de.promolitor.tchelper.helper.Hexagon;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class KeyInputEvent {
    public static KeyBinding tcSolveScreen;
    public static boolean drawing;

    public void init() {
        tcSolveScreen = new KeyBinding("Solve TC Research Node", 78, "TC Research Helper");
        ClientRegistry.registerKeyBinding((KeyBinding)tcSolveScreen);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void KeyEvent(InputEvent event) {
        if (tcSolveScreen.func_151468_f()) {
            if (drawing) {
                drawing = false;
            } else {
                ItemStack heldItem = TCHelperMain.mc.field_71439_g.field_71071_by.func_70448_g();
                if (heldItem != null && heldItem.func_77973_b().func_77658_a().equals("item.ItemResearchNotes")) {
                    NBTTagList hexsTagList = heldItem.func_77978_p().func_150295_c("hexgrid", 10);
                    ArrayList<Hexagon> researchAspects = new ArrayList<Hexagon>();
                    Object currentHex = hexsTagList.func_150305_b(0);
                    for (int i = 0; i <= 100; ++i) {
                        if (currentHex.func_74781_a("aspect") != null) {
                            String aspect = currentHex.func_74781_a("aspect").toString().replaceAll("\"", "");
                            researchAspects.add(new Hexagon(currentHex.func_74771_c("hexq"), currentHex.func_74771_c("hexr"), aspect));
                        }
                        currentHex = hexsTagList.func_150305_b(i) != null ? hexsTagList.func_150305_b(i) : null;
                    }
                    AspectCalculation.clearIssues();
                    ArrayList<Combination> toCheck = new ArrayList<Combination>();
                    this.checkRest(researchAspects, toCheck);
                    if (TCHelperMain.debugging) {
                        System.out.println("Combinations to check: " + toCheck);
                        for (Combination combination : toCheck) {
                            if (!AspectCalculation.map.containsKey(combination.h1.aspect) || !AspectCalculation.map.containsKey(combination.h2.aspect)) {
                                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Sorry, no Addon Aspect supported yet!"));
                            }
                            System.out.println("Checking" + combination.h1 + " to");
                            AspectCalculation.solveIssues(AspectCalculation.map.get(combination.h1.aspect), AspectCalculation.map.get(combination.h2.aspect)).toString();
                        }
                    } else {
                        for (Combination combination : toCheck) {
                            if (!AspectCalculation.map.containsKey(combination.h1.aspect) || !AspectCalculation.map.containsKey(combination.h2.aspect)) {
                                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Sorry, no Addon Aspect supported yet!"));
                            }
                            AspectCalculation.solveIssues(AspectCalculation.map.get(combination.h1.aspect), AspectCalculation.map.get(combination.h2.aspect));
                        }
                    }
                    drawing = true;
                }
            }
        }
    }

    private void checkRest(ArrayList<Hexagon> researchAspects, ArrayList<Combination> toCheck) {
        int minDistance = 10000;
        Hexagon h1 = null;
        Hexagon h2 = null;
        for (int i = 0; i < researchAspects.size(); ++i) {
            minDistance = 10000;
            for (Hexagon hexagon : researchAspects) {
                if (researchAspects.get(i).equals(hexagon) || AspectCalculation.getDistance(hexagon, researchAspects.get(i)) >= minDistance || hexagon.visited && researchAspects.get((int)i).visited) continue;
                minDistance = AspectCalculation.getDistance(hexagon, researchAspects.get(i));
                h1 = hexagon;
                h2 = researchAspects.get(i);
            }
        }
        toCheck.add(new Combination(h1, h2));
        h1.visited = true;
        h2.visited = true;
        boolean stillNeedToCheck = false;
        for (Hexagon hexagon : researchAspects) {
            if (hexagon.visited) continue;
            stillNeedToCheck = true;
        }
        if (stillNeedToCheck) {
            this.checkRest(researchAspects, toCheck);
        }
    }

    static {
        drawing = false;
    }
}

