/*
 * Decompiled with CFR 0.152.
 */
package de.promolitor.tchelper.helper;

import de.promolitor.tchelper.TCHelperMain;
import de.promolitor.tchelper.helper.Hexagon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import thaumcraft.api.aspects.Aspect;

public class AspectCalculation {
    public static final int[][] NEIGHBOURS = new int[][]{{1, 0}, {1, -1}, {0, -1}, {-1, 0}, {-1, 1}, {0, 1}};
    public static UndirectedGraph<String, DefaultWeightedEdge> graph;
    public static HashMap<String, Aspect> map;
    private static int iteration;
    public static ArrayList<String[]> solvedIssues;

    public static int getDistance(Hexagon a1, Hexagon a2) {
        return (Math.abs(a1.q - a2.q) + Math.abs(a1.r - a2.r) + Math.abs(a1.q + a1.r - a2.q - a2.r)) / 2;
    }

    public static void clearIssues() {
        solvedIssues = new ArrayList();
    }

    public static String[] solveIssues(Aspect start, Aspect destination) {
        int i;
        DijkstraShortestPath<String, DefaultWeightedEdge> test = new DijkstraShortestPath<String, DefaultWeightedEdge>(graph, start.getTag(), destination.getTag());
        List<DefaultWeightedEdge> list = test.getPathEdgeList();
        String[] paths = new String[list.size() + 1];
        DefaultWeightedEdge first = list.remove(0);
        String stripped = first.toString().replaceAll(" ", "").replaceAll("\\(", "").replaceAll("\\)", "");
        String[] splitted = stripped.split(":");
        if (splitted[0].equals(start.getTag())) {
            paths[0] = start.getTag();
            paths[1] = splitted[1];
        } else {
            paths[0] = start.getTag();
            paths[1] = splitted[0];
        }
        if (TCHelperMain.debugging) {
            System.out.println("");
            System.out.println("-----STARTING DIJKSTRA-----");
            i = 2;
            for (DefaultWeightedEdge object : list) {
                DefaultWeightedEdge a = object;
                stripped = a.toString().replaceAll(" ", "").replaceAll("\\(", "").replaceAll("\\)", "");
                splitted = stripped.split("\\:");
                paths[i] = paths[i - 1].equals(splitted[0]) ? splitted[1] : splitted[0];
                ++i;
            }
        }
        if (TCHelperMain.debugging) {
            System.out.println("");
            for (i = 0; i < paths.length; ++i) {
                System.out.println(paths[i]);
            }
            System.out.println("");
        }
        solvedIssues.add(paths);
        return paths;
    }

    public static void createGraph() {
        graph = new SimpleWeightedGraph<String, DefaultWeightedEdge>(DefaultWeightedEdge.class);
        graph.addVertex(Aspect.AIR.getTag());
        graph.addVertex(Aspect.EARTH.getTag());
        graph.addVertex(Aspect.FIRE.getTag());
        graph.addVertex(Aspect.WATER.getTag());
        graph.addVertex(Aspect.ORDER.getTag());
        graph.addVertex(Aspect.ENTROPY.getTag());
        graph.addVertex(Aspect.VOID.getTag());
        graph.addVertex(Aspect.LIGHT.getTag());
        graph.addVertex(Aspect.WEATHER.getTag());
        graph.addVertex(Aspect.MOTION.getTag());
        graph.addVertex(Aspect.COLD.getTag());
        graph.addVertex(Aspect.CRYSTAL.getTag());
        graph.addVertex(Aspect.LIFE.getTag());
        graph.addVertex(Aspect.POISON.getTag());
        graph.addVertex(Aspect.ENERGY.getTag());
        graph.addVertex(Aspect.EXCHANGE.getTag());
        graph.addVertex(Aspect.METAL.getTag());
        graph.addVertex(Aspect.DEATH.getTag());
        graph.addVertex(Aspect.FLIGHT.getTag());
        graph.addVertex(Aspect.DARKNESS.getTag());
        graph.addVertex(Aspect.SOUL.getTag());
        graph.addVertex(Aspect.HEAL.getTag());
        graph.addVertex(Aspect.TRAVEL.getTag());
        graph.addVertex(Aspect.ELDRITCH.getTag());
        graph.addVertex(Aspect.MAGIC.getTag());
        graph.addVertex(Aspect.AURA.getTag());
        graph.addVertex(Aspect.TAINT.getTag());
        graph.addVertex(Aspect.SLIME.getTag());
        graph.addVertex(Aspect.PLANT.getTag());
        graph.addVertex(Aspect.TREE.getTag());
        graph.addVertex(Aspect.BEAST.getTag());
        graph.addVertex(Aspect.FLESH.getTag());
        graph.addVertex(Aspect.UNDEAD.getTag());
        graph.addVertex(Aspect.MIND.getTag());
        graph.addVertex(Aspect.SENSES.getTag());
        graph.addVertex(Aspect.MAN.getTag());
        graph.addVertex(Aspect.CROP.getTag());
        graph.addVertex(Aspect.MINE.getTag());
        graph.addVertex(Aspect.TOOL.getTag());
        graph.addVertex(Aspect.HARVEST.getTag());
        graph.addVertex(Aspect.WEAPON.getTag());
        graph.addVertex(Aspect.ARMOR.getTag());
        graph.addVertex(Aspect.HUNGER.getTag());
        graph.addVertex(Aspect.GREED.getTag());
        graph.addVertex(Aspect.CRAFT.getTag());
        graph.addVertex(Aspect.CLOTH.getTag());
        graph.addVertex(Aspect.MECHANISM.getTag());
        graph.addVertex(Aspect.TRAP.getTag());
        Graphs.addEdge(graph, Aspect.VOID.getTag(), Aspect.AIR.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.VOID.getTag(), Aspect.ENTROPY.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.LIGHT.getTag(), Aspect.AIR.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.LIGHT.getTag(), Aspect.FIRE.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.WEATHER.getTag(), Aspect.AIR.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.WEATHER.getTag(), Aspect.WATER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.MOTION.getTag(), Aspect.AIR.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.MOTION.getTag(), Aspect.ORDER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.COLD.getTag(), Aspect.FIRE.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.COLD.getTag(), Aspect.ENTROPY.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.CRYSTAL.getTag(), Aspect.EARTH.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.CRYSTAL.getTag(), Aspect.ORDER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.POISON.getTag(), Aspect.WATER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.POISON.getTag(), Aspect.ENTROPY.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.METAL.getTag(), Aspect.EARTH.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.METAL.getTag(), Aspect.CRYSTAL.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.LIFE.getTag(), Aspect.EARTH.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.LIFE.getTag(), Aspect.WATER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.DEATH.getTag(), Aspect.LIFE.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.DEATH.getTag(), Aspect.ENTROPY.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.ENERGY.getTag(), Aspect.ORDER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.ENERGY.getTag(), Aspect.FIRE.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.EXCHANGE.getTag(), Aspect.ENTROPY.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.EXCHANGE.getTag(), Aspect.ORDER.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.AURA.getTag(), Aspect.MAGIC.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.AURA.getTag(), Aspect.AIR.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.TAINT.getTag(), Aspect.ENTROPY.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.TAINT.getTag(), Aspect.MAGIC.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.DARKNESS.getTag(), Aspect.VOID.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.DARKNESS.getTag(), Aspect.LIGHT.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.SLIME.getTag(), Aspect.LIFE.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.SLIME.getTag(), Aspect.WATER.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.ELDRITCH.getTag(), Aspect.VOID.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.ELDRITCH.getTag(), Aspect.DARKNESS.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.FLIGHT.getTag(), Aspect.AIR.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.FLIGHT.getTag(), Aspect.MOTION.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.HEAL.getTag(), Aspect.LIFE.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.HEAL.getTag(), Aspect.ORDER.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.TRAVEL.getTag(), Aspect.MOTION.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.TRAVEL.getTag(), Aspect.EARTH.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.MAGIC.getTag(), Aspect.VOID.getTag(), 2.0);
        Graphs.addEdge(graph, Aspect.MAGIC.getTag(), Aspect.ENERGY.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.PLANT.getTag(), Aspect.LIFE.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.PLANT.getTag(), Aspect.EARTH.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.TREE.getTag(), Aspect.AIR.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.TREE.getTag(), Aspect.PLANT.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.TOOL.getTag(), Aspect.MAN.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.TOOL.getTag(), Aspect.ORDER.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.CRAFT.getTag(), Aspect.MAN.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.CRAFT.getTag(), Aspect.TOOL.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.MECHANISM.getTag(), Aspect.MOTION.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.MECHANISM.getTag(), Aspect.TOOL.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.TRAP.getTag(), Aspect.MOTION.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.TRAP.getTag(), Aspect.ENTROPY.getTag(), 3.0);
        Graphs.addEdge(graph, Aspect.SOUL.getTag(), Aspect.LIFE.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.SOUL.getTag(), Aspect.DEATH.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.MIND.getTag(), Aspect.FIRE.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.MIND.getTag(), Aspect.SOUL.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.SENSES.getTag(), Aspect.AIR.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.SENSES.getTag(), Aspect.SOUL.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.CROP.getTag(), Aspect.PLANT.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.CROP.getTag(), Aspect.MAN.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.ARMOR.getTag(), Aspect.EARTH.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.ARMOR.getTag(), Aspect.TOOL.getTag(), 5.0);
        Graphs.addEdge(graph, Aspect.GREED.getTag(), Aspect.MAN.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.GREED.getTag(), Aspect.HUNGER.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.UNDEAD.getTag(), Aspect.MOTION.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.UNDEAD.getTag(), Aspect.DEATH.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.BEAST.getTag(), Aspect.MOTION.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.BEAST.getTag(), Aspect.LIFE.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.FLESH.getTag(), Aspect.DEATH.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.FLESH.getTag(), Aspect.BEAST.getTag(), 4.0);
        Graphs.addEdge(graph, Aspect.MAN.getTag(), Aspect.BEAST.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.MAN.getTag(), Aspect.MIND.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.MAN.getTag(), Aspect.BEAST.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.MAN.getTag(), Aspect.MIND.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.HARVEST.getTag(), Aspect.CROP.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.HARVEST.getTag(), Aspect.TOOL.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.WEAPON.getTag(), Aspect.TOOL.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.WEAPON.getTag(), Aspect.FIRE.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.HUNGER.getTag(), Aspect.LIFE.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.HUNGER.getTag(), Aspect.VOID.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.CRAFT.getTag(), Aspect.MAN.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.CRAFT.getTag(), Aspect.TOOL.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.CLOTH.getTag(), Aspect.TOOL.getTag(), 6.0);
        Graphs.addEdge(graph, Aspect.CLOTH.getTag(), Aspect.BEAST.getTag(), 6.0);
        map.put(Aspect.AIR.getTag(), Aspect.AIR);
        map.put(Aspect.EARTH.getTag(), Aspect.EARTH);
        map.put(Aspect.FIRE.getTag(), Aspect.FIRE);
        map.put(Aspect.WATER.getTag(), Aspect.WATER);
        map.put(Aspect.ENTROPY.getTag(), Aspect.ENTROPY);
        map.put(Aspect.ORDER.getTag(), Aspect.ORDER);
        map.put(Aspect.VOID.getTag(), Aspect.VOID);
        map.put(Aspect.LIGHT.getTag(), Aspect.LIGHT);
        map.put(Aspect.WEATHER.getTag(), Aspect.WEATHER);
        map.put(Aspect.MOTION.getTag(), Aspect.MOTION);
        map.put(Aspect.COLD.getTag(), Aspect.COLD);
        map.put(Aspect.CRYSTAL.getTag(), Aspect.CRYSTAL);
        map.put(Aspect.METAL.getTag(), Aspect.METAL);
        map.put(Aspect.LIFE.getTag(), Aspect.LIFE);
        map.put(Aspect.POISON.getTag(), Aspect.POISON);
        map.put(Aspect.DEATH.getTag(), Aspect.DEATH);
        map.put(Aspect.ENERGY.getTag(), Aspect.ENERGY);
        map.put(Aspect.EXCHANGE.getTag(), Aspect.EXCHANGE);
        map.put(Aspect.AURA.getTag(), Aspect.AURA);
        map.put(Aspect.TAINT.getTag(), Aspect.TAINT);
        map.put(Aspect.MAGIC.getTag(), Aspect.MAGIC);
        map.put(Aspect.HEAL.getTag(), Aspect.HEAL);
        map.put(Aspect.TRAVEL.getTag(), Aspect.TRAVEL);
        map.put(Aspect.DARKNESS.getTag(), Aspect.DARKNESS);
        map.put(Aspect.ELDRITCH.getTag(), Aspect.ELDRITCH);
        map.put(Aspect.FLIGHT.getTag(), Aspect.FLIGHT);
        map.put(Aspect.PLANT.getTag(), Aspect.PLANT);
        map.put(Aspect.SLIME.getTag(), Aspect.SLIME);
        map.put(Aspect.TOOL.getTag(), Aspect.TOOL);
        map.put(Aspect.CRAFT.getTag(), Aspect.CRAFT);
        map.put(Aspect.MECHANISM.getTag(), Aspect.MECHANISM);
        map.put(Aspect.TRAP.getTag(), Aspect.TRAP);
        map.put(Aspect.SOUL.getTag(), Aspect.SOUL);
        map.put(Aspect.MIND.getTag(), Aspect.MIND);
        map.put(Aspect.SENSES.getTag(), Aspect.SENSES);
        map.put(Aspect.CROP.getTag(), Aspect.CROP);
        map.put(Aspect.ARMOR.getTag(), Aspect.ARMOR);
        map.put(Aspect.GREED.getTag(), Aspect.GREED);
        map.put(Aspect.UNDEAD.getTag(), Aspect.UNDEAD);
        map.put(Aspect.BEAST.getTag(), Aspect.BEAST);
        map.put(Aspect.MAN.getTag(), Aspect.MAN);
        map.put(Aspect.TREE.getTag(), Aspect.TREE);
        map.put(Aspect.FLESH.getTag(), Aspect.FLESH);
        map.put(Aspect.MINE.getTag(), Aspect.MINE);
        map.put(Aspect.HARVEST.getTag(), Aspect.HARVEST);
        map.put(Aspect.WEAPON.getTag(), Aspect.WEAPON);
        map.put(Aspect.HUNGER.getTag(), Aspect.HUNGER);
        map.put(Aspect.CRAFT.getTag(), Aspect.CRAFT);
        map.put(Aspect.CLOTH.getTag(), Aspect.CLOTH);
    }

    static {
        map = new HashMap();
        iteration = 0;
    }
}

