/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.dag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.SimpleDirectedGraph;

public class DirectedAcyclicGraph<V, E>
extends SimpleDirectedGraph<V, E> {
    private static final long serialVersionUID = 4522128427004938150L;
    private TopoComparator<V> topoComparator;
    private TopoOrderMapping<V> topoOrderMap;
    private int maxTopoIndex = 0;
    private int minTopoIndex = 0;
    private long topologyUpdateCount = 0L;
    private VisitedFactory visitedFactory = new VisitedBitSetImpl();
    private TopoOrderMappingFactory<V> topoOrderFactory = new TopoVertexBiMap();

    public DirectedAcyclicGraph(Class<? extends E> arg0) {
        super(arg0);
        this.initialize();
    }

    public DirectedAcyclicGraph(EdgeFactory<V, E> ef) {
        super(ef);
        this.initialize();
    }

    DirectedAcyclicGraph(Class<? extends E> arg0, VisitedFactory visitedFactory, TopoOrderMappingFactory<V> topoOrderFactory) {
        super(arg0);
        if (visitedFactory != null) {
            this.visitedFactory = visitedFactory;
        }
        if (topoOrderFactory != null) {
            this.topoOrderFactory = topoOrderFactory;
        }
        this.initialize();
    }

    private void initialize() {
        this.topoOrderMap = this.topoOrderFactory.getTopoOrderMapping();
        this.topoComparator = new TopoComparator<V>(this.topoOrderMap);
    }

    public Iterator<V> iterator() {
        return new TopoIterator();
    }

    @Override
    public boolean addVertex(V v) {
        boolean added = super.addVertex(v);
        if (added) {
            ++this.maxTopoIndex;
            this.topoOrderMap.putVertex(this.maxTopoIndex, v);
            ++this.topologyUpdateCount;
        }
        return added;
    }

    public boolean addVertex(V v, boolean addToTop) {
        boolean added = super.addVertex(v);
        if (added) {
            int insertIndex = addToTop ? ++this.maxTopoIndex : --this.minTopoIndex;
            this.topoOrderMap.putVertex(insertIndex, v);
            ++this.topologyUpdateCount;
        }
        return added;
    }

    public E addDagEdge(V fromVertex, V toVertex) throws CycleFoundException {
        this.updateDag(fromVertex, toVertex);
        return super.addEdge(fromVertex, toVertex);
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        E result = null;
        try {
            result = this.addDagEdge(sourceVertex, targetVertex);
        }
        catch (CycleFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    public boolean addDagEdge(V fromVertex, V toVertex, E e) throws CycleFoundException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.containsEdge(e)) {
            return false;
        }
        this.updateDag(fromVertex, toVertex);
        return super.addEdge(fromVertex, toVertex, e);
    }

    private void updateDag(V fromVertex, V toVertex) throws CycleFoundException {
        Integer lb = this.topoOrderMap.getTopologicalIndex(toVertex);
        Integer ub = this.topoOrderMap.getTopologicalIndex(fromVertex);
        if (lb == null || ub == null) {
            throw new IllegalArgumentException("vertices must be in the graph already!");
        }
        if (lb < ub) {
            HashSet df = new HashSet();
            HashSet db = new HashSet();
            Region affectedRegion = new Region(lb, ub);
            Visited visited = this.visitedFactory.getInstance(affectedRegion);
            this.dfsF(toVertex, df, visited, affectedRegion);
            this.dfsB(fromVertex, db, visited, affectedRegion);
            this.reorder(df, db, visited);
            ++this.topologyUpdateCount;
        }
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E edge) {
        boolean result;
        try {
            result = this.addDagEdge(sourceVertex, targetVertex, edge);
        }
        catch (CycleFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    @Override
    public boolean removeVertex(V v) {
        boolean removed = super.removeVertex(v);
        if (removed) {
            Integer topoIndex = this.topoOrderMap.removeVertex(v);
            if (topoIndex == this.minTopoIndex) {
                while (this.minTopoIndex < 0 && null == this.topoOrderMap.getVertex(this.minTopoIndex)) {
                    ++this.minTopoIndex;
                }
            }
            if (topoIndex == this.maxTopoIndex) {
                while (this.maxTopoIndex > 0 && null == this.topoOrderMap.getVertex(this.maxTopoIndex)) {
                    --this.maxTopoIndex;
                }
            }
            ++this.topologyUpdateCount;
        }
        return removed;
    }

    @Override
    public boolean removeAllVertices(Collection<? extends V> arg0) {
        boolean removed = super.removeAllVertices(arg0);
        this.topoOrderMap.removeAllVertices();
        this.maxTopoIndex = 0;
        this.minTopoIndex = 0;
        ++this.topologyUpdateCount;
        return removed;
    }

    private void dfsF(V vertex, Set<V> df, Visited visited, Region affectedRegion) throws CycleFoundException {
        int topoIndex = this.topoOrderMap.getTopologicalIndex(vertex);
        visited.setVisited(topoIndex);
        df.add(vertex);
        for (Object outEdge : this.outgoingEdgesOf(vertex)) {
            Object nextVertex = this.getEdgeTarget(outEdge);
            Integer nextVertexTopoIndex = this.topoOrderMap.getTopologicalIndex(nextVertex);
            if (nextVertexTopoIndex == affectedRegion.finish) {
                try {
                    for (V visitedVertex : df) {
                        visited.clearVisited(this.topoOrderMap.getTopologicalIndex(visitedVertex));
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                throw new CycleFoundException();
            }
            if (!affectedRegion.isIn(nextVertexTopoIndex) || visited.getVisited(nextVertexTopoIndex)) continue;
            this.dfsF(nextVertex, df, visited, affectedRegion);
        }
    }

    private void dfsB(V vertex, Set<V> db, Visited visited, Region affectedRegion) {
        int topoIndex = this.topoOrderMap.getTopologicalIndex(vertex);
        visited.setVisited(topoIndex);
        db.add(vertex);
        for (Object inEdge : this.incomingEdgesOf(vertex)) {
            Object previousVertex = this.getEdgeSource(inEdge);
            Integer previousVertexTopoIndex = this.topoOrderMap.getTopologicalIndex(previousVertex);
            if (!affectedRegion.isIn(previousVertexTopoIndex) || visited.getVisited(previousVertexTopoIndex)) continue;
            this.dfsB(previousVertex, db, visited, affectedRegion);
        }
    }

    private void reorder(Set<V> df, Set<V> db, Visited visited) {
        Integer topoIndex;
        ArrayList<V> topoDf = new ArrayList<V>(df);
        ArrayList<V> topoDb = new ArrayList<V>(db);
        Collections.sort(topoDf, this.topoComparator);
        Collections.sort(topoDb, this.topoComparator);
        TreeSet<Integer> availableTopoIndices = new TreeSet<Integer>();
        Object[] bigL = new Object[df.size() + db.size()];
        int lIndex = 0;
        boolean clearVisited = true;
        for (Object vertex : topoDb) {
            topoIndex = this.topoOrderMap.getTopologicalIndex(vertex);
            availableTopoIndices.add(topoIndex);
            bigL[lIndex++] = vertex;
            if (!clearVisited) continue;
            try {
                visited.clearVisited(topoIndex);
            }
            catch (UnsupportedOperationException e) {
                clearVisited = false;
            }
        }
        for (Object vertex : topoDf) {
            topoIndex = this.topoOrderMap.getTopologicalIndex(vertex);
            availableTopoIndices.add(topoIndex);
            bigL[lIndex++] = vertex;
            if (!clearVisited) continue;
            try {
                visited.clearVisited(topoIndex);
            }
            catch (UnsupportedOperationException e) {
                clearVisited = false;
            }
        }
        lIndex = 0;
        for (Integer topoIndex2 : availableTopoIndices) {
            Object vertex = bigL[lIndex++];
            this.topoOrderMap.putVertex(topoIndex2, vertex);
        }
    }

    private class TopoIterator
    implements Iterator<V> {
        private int currentTopoIndex;
        private final long updateCountAtCreation;
        private Integer nextIndex = null;

        public TopoIterator() {
            this.updateCountAtCreation = DirectedAcyclicGraph.this.topologyUpdateCount;
            this.currentTopoIndex = DirectedAcyclicGraph.this.minTopoIndex - 1;
        }

        @Override
        public boolean hasNext() {
            if (this.updateCountAtCreation != DirectedAcyclicGraph.this.topologyUpdateCount) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = this.getNextIndex();
            return this.nextIndex != null;
        }

        @Override
        public V next() {
            if (this.updateCountAtCreation != DirectedAcyclicGraph.this.topologyUpdateCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextIndex == null) {
                this.nextIndex = this.getNextIndex();
            }
            if (this.nextIndex == null) {
                throw new NoSuchElementException();
            }
            this.currentTopoIndex = this.nextIndex;
            this.nextIndex = null;
            return DirectedAcyclicGraph.this.topoOrderMap.getVertex(this.currentTopoIndex);
        }

        @Override
        public void remove() {
            if (this.updateCountAtCreation != DirectedAcyclicGraph.this.topologyUpdateCount) {
                throw new ConcurrentModificationException();
            }
            Object vertexToRemove = null;
            Object v = DirectedAcyclicGraph.this.topoOrderMap.getVertex(this.currentTopoIndex);
            vertexToRemove = v;
            if (null == v) {
                throw new IllegalStateException();
            }
            DirectedAcyclicGraph.this.topoOrderMap.removeVertex(vertexToRemove);
        }

        private Integer getNextIndex() {
            for (int i = this.currentTopoIndex + 1; i <= DirectedAcyclicGraph.this.maxTopoIndex; ++i) {
                if (null == DirectedAcyclicGraph.this.topoOrderMap.getVertex(i)) continue;
                return i;
            }
            return null;
        }
    }

    public static class CycleFoundException
    extends Exception {
        private static final long serialVersionUID = 5583471522212552754L;
    }

    public static class VisitedArrayImpl
    implements Visited,
    VisitedFactory {
        private static final long serialVersionUID = 1L;
        private final boolean[] visited;
        private final Region region;

        public VisitedArrayImpl() {
            this(null);
        }

        public VisitedArrayImpl(Region region) {
            if (region == null) {
                this.visited = null;
                this.region = null;
            } else {
                this.region = region;
                this.visited = new boolean[region.getSize()];
            }
        }

        @Override
        public Visited getInstance(Region affectedRegion) {
            return new VisitedArrayImpl(affectedRegion);
        }

        @Override
        public void setVisited(int index) {
            this.visited[index - this.region.start] = true;
        }

        @Override
        public boolean getVisited(int index) {
            return this.visited[index - this.region.start];
        }

        @Override
        public void clearVisited(int index) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public static class VisitedHashSetImpl
    implements Visited,
    VisitedFactory {
        private static final long serialVersionUID = 1L;
        private final Set<Integer> visited = new HashSet<Integer>();

        @Override
        public Visited getInstance(Region affectedRegion) {
            this.visited.clear();
            return this;
        }

        @Override
        public void setVisited(int index) {
            this.visited.add(index);
        }

        @Override
        public boolean getVisited(int index) {
            return this.visited.contains(index);
        }

        @Override
        public void clearVisited(int index) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public static class VisitedArrayListImpl
    implements Visited,
    VisitedFactory {
        private static final long serialVersionUID = 1L;
        private final List<Boolean> visited = new ArrayList<Boolean>();
        private Region affectedRegion;

        @Override
        public Visited getInstance(Region affectedRegion) {
            int minSize = affectedRegion.finish - affectedRegion.start + 1;
            while (this.visited.size() < minSize) {
                this.visited.add(Boolean.FALSE);
            }
            this.affectedRegion = affectedRegion;
            return this;
        }

        @Override
        public void setVisited(int index) {
            this.visited.set(this.translateIndex(index), Boolean.TRUE);
        }

        @Override
        public boolean getVisited(int index) {
            Boolean result = null;
            result = this.visited.get(this.translateIndex(index));
            return result;
        }

        @Override
        public void clearVisited(int index) throws UnsupportedOperationException {
            this.visited.set(this.translateIndex(index), Boolean.FALSE);
        }

        private int translateIndex(int index) {
            return index - this.affectedRegion.start;
        }
    }

    public static class VisitedBitSetImpl
    implements Visited,
    VisitedFactory {
        private static final long serialVersionUID = 1L;
        private final BitSet visited = new BitSet();
        private Region affectedRegion;

        @Override
        public Visited getInstance(Region affectedRegion) {
            this.affectedRegion = affectedRegion;
            return this;
        }

        @Override
        public void setVisited(int index) {
            this.visited.set(this.translateIndex(index), true);
        }

        @Override
        public boolean getVisited(int index) {
            return this.visited.get(this.translateIndex(index));
        }

        @Override
        public void clearVisited(int index) throws UnsupportedOperationException {
            this.visited.clear(this.translateIndex(index));
        }

        private int translateIndex(int index) {
            return index - this.affectedRegion.start;
        }
    }

    public static class Region
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int start;
        public final int finish;

        public Region(int start, int finish) {
            if (start > finish) {
                throw new IllegalArgumentException("(start > finish): invariant broken");
            }
            this.start = start;
            this.finish = finish;
        }

        public int getSize() {
            return this.finish - this.start + 1;
        }

        public boolean isIn(int index) {
            return index >= this.start && index <= this.finish;
        }
    }

    public class TopoVertexMap
    implements TopoOrderMapping<V>,
    TopoOrderMappingFactory<V> {
        private static final long serialVersionUID = 1L;
        private final List<V> topoToVertex = new ArrayList();
        private final Map<V, Integer> vertexToTopo = new HashMap();

        @Override
        public void putVertex(Integer index, V vertex) {
            int translatedIndex = this.translateIndex(index);
            while (translatedIndex + 1 > this.topoToVertex.size()) {
                this.topoToVertex.add(null);
            }
            this.topoToVertex.set(translatedIndex, vertex);
            this.vertexToTopo.put((Integer)vertex, index);
        }

        @Override
        public V getVertex(Integer index) {
            return this.topoToVertex.get(this.translateIndex(index));
        }

        @Override
        public Integer getTopologicalIndex(V vertex) {
            return this.vertexToTopo.get(vertex);
        }

        @Override
        public Integer removeVertex(V vertex) {
            Integer topoIndex = this.vertexToTopo.remove(vertex);
            if (topoIndex != null) {
                this.topoToVertex.set(this.translateIndex(topoIndex), null);
            }
            return topoIndex;
        }

        @Override
        public void removeAllVertices() {
            this.vertexToTopo.clear();
            this.topoToVertex.clear();
        }

        @Override
        public TopoOrderMapping<V> getTopoOrderMapping() {
            return this;
        }

        private final int translateIndex(int index) {
            if (index >= 0) {
                return 2 * index;
            }
            return -1 * (index * 2 - 1);
        }
    }

    private class TopoVertexBiMap
    implements TopoOrderMapping<V>,
    TopoOrderMappingFactory<V> {
        private static final long serialVersionUID = 1L;
        private final Map<Integer, V> topoToVertex = new HashMap();
        private final Map<V, Integer> vertexToTopo = new HashMap();

        private TopoVertexBiMap() {
        }

        @Override
        public void putVertex(Integer index, V vertex) {
            this.topoToVertex.put(index, vertex);
            this.vertexToTopo.put((Integer)vertex, index);
        }

        @Override
        public V getVertex(Integer index) {
            return this.topoToVertex.get(index);
        }

        @Override
        public Integer getTopologicalIndex(V vertex) {
            Integer topoIndex = this.vertexToTopo.get(vertex);
            return topoIndex;
        }

        @Override
        public Integer removeVertex(V vertex) {
            Integer topoIndex = this.vertexToTopo.remove(vertex);
            if (topoIndex != null) {
                this.topoToVertex.remove(topoIndex);
            }
            return topoIndex;
        }

        @Override
        public void removeAllVertices() {
            this.vertexToTopo.clear();
            this.topoToVertex.clear();
        }

        @Override
        public TopoOrderMapping<V> getTopoOrderMapping() {
            return this;
        }
    }

    private static class TopoComparator<V>
    implements Comparator<V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private TopoOrderMapping<V> topoOrderMap;

        public TopoComparator(TopoOrderMapping<V> topoOrderMap) {
            this.topoOrderMap = topoOrderMap;
        }

        @Override
        public int compare(V o1, V o2) {
            return this.topoOrderMap.getTopologicalIndex(o1).compareTo(this.topoOrderMap.getTopologicalIndex(o2));
        }
    }

    public static interface VisitedFactory
    extends Serializable {
        public Visited getInstance(Region var1);
    }

    public static interface Visited {
        public void setVisited(int var1);

        public boolean getVisited(int var1);

        public void clearVisited(int var1) throws UnsupportedOperationException;
    }

    public static interface TopoOrderMappingFactory<V> {
        public TopoOrderMapping<V> getTopoOrderMapping();
    }

    public static interface TopoOrderMapping<V>
    extends Serializable {
        public void putVertex(Integer var1, V var2);

        public V getVertex(Integer var1);

        public Integer getTopologicalIndex(V var1);

        public Integer removeVertex(V var1);

        public void removeAllVertices();
    }
}

