/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import modinfo.ModInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.entity.Entity;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.cartography.ColorCache;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.WaypointsData;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.forgehandler.EventHandlerManager;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.JMLogger;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.RegionImageCache;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.properties.CoreProperties;
import net.techbrew.journeymap.properties.FullMapProperties;
import net.techbrew.journeymap.properties.MiniMapProperties;
import net.techbrew.journeymap.properties.WaypointProperties;
import net.techbrew.journeymap.properties.WebMapProperties;
import net.techbrew.journeymap.render.overlay.TileCache;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.server.JMServer;
import net.techbrew.journeymap.task.ITaskManager;
import net.techbrew.journeymap.task.MapPlayerTask;
import net.techbrew.journeymap.task.TaskController;
import net.techbrew.journeymap.thread.JMThreadFactory;
import net.techbrew.journeymap.thread.TaskThread;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapOverlay;
import net.techbrew.journeymap.waypoint.WaypointStore;

@SideOnly(value=Side.CLIENT)
@Mod(modid="journeymap", name="JourneyMap", version="4.0.3")
public class JourneyMap {
    static final String VERSION_URL = "https://dl.dropboxusercontent.com/u/38077766/JourneyMap/journeymap-version.js";
    public static final String WEBSITE_URL = "http://journeymap.techbrew.net/";
    public static final String JM_VERSION = "4.0.3";
    public static final String MC_VERSION = "1.6.4";
    public static final String EDITION = JourneyMap.getEdition();
    public static final String MOD_ID = "journeymap";
    public static final String SHORT_MOD_NAME = "JourneyMap";
    public static final String MOD_NAME = "JourneyMap " + EDITION;
    private static JourneyMap INSTANCE;
    private Logger logger;
    private volatile Boolean initialized = false;
    private JMServer jmServer;
    private boolean threadLogging = false;
    public long nextPlayerUpdate = 0L;
    public long nextChunkUpdate = 0L;
    public ModInfo modInfo;
    public CoreProperties coreProperties;
    public FullMapProperties fullMapProperties;
    public MiniMapProperties miniMapProperties;
    public WebMapProperties webMapProperties;
    public WaypointProperties waypointProperties;
    private volatile ScheduledExecutorService taskExecutor;
    private TaskController taskController;
    private Minecraft mc;

    public static JourneyMap getInstance() {
        return INSTANCE;
    }

    public JourneyMap() {
        if (INSTANCE != null) {
            throw new IllegalArgumentException("Use getInstance() after initialization is complete");
        }
        INSTANCE = this;
    }

    private static String getEdition() {
        String ed = null;
        try {
            ed = "4.0.3 " + FeatureManager.getFeatureSetName();
        }
        catch (Throwable t) {
            ed = "4.0.3 ?";
            t.printStackTrace(System.err);
        }
        return ed;
    }

    public Boolean isInitialized() {
        return this.initialized;
    }

    public Boolean isMapping() {
        return this.taskExecutor != null && !this.taskExecutor.isShutdown();
    }

    public Boolean isThreadLogging() {
        return this.threadLogging;
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent event) throws Throwable {
        try {
            this.logger = JMLogger.init();
            this.logger.info(MOD_NAME + " initialize ENTER");
            this.modInfo = new ModInfo("UA-28839029-4", "en_US", MOD_ID, MOD_NAME, JourneyMap.getEdition());
            if (this.initialized.booleanValue()) {
                this.logger.warning("Already initialized, aborting");
                return;
            }
            this.mc = FMLClientHandler.instance().getClient();
            this.coreProperties = (CoreProperties)new CoreProperties().load();
            this.fullMapProperties = (FullMapProperties)new FullMapProperties().load();
            this.miniMapProperties = (MiniMapProperties)new MiniMapProperties().load();
            this.webMapProperties = (WebMapProperties)new WebMapProperties().load();
            this.waypointProperties = (WaypointProperties)new WaypointProperties().load();
            PropertyManager.getInstance().migrateLegacyProperties();
            JMLogger.logProperties();
            this.logger.info(MOD_NAME + " initialize EXIT");
        }
        catch (Throwable t) {
            if (this.logger == null) {
                this.logger = Logger.getLogger(MOD_ID);
            }
            this.logger.severe(LogFormatter.toString(t));
            throw t;
        }
    }

    @Mod.EventHandler
    public void postInitialize(FMLPostInitializationEvent event) {
        try {
            this.logger.info(MOD_NAME + " postInitialize ENTER");
            EventHandlerManager.registerGeneralHandlers();
            EventHandlerManager.registerGuiHandlers();
            this.toggleWebserver(this.webMapProperties.enabled.get(), false);
            this.initialized = true;
            this.logger.info("Initialization complete.");
            JMLogger.setLevelFromProps();
            this.threadLogging = JourneyMap.getLogger().isLoggable(Level.FINER);
            WaypointsData.reset();
            BlockUtils.initialize();
            this.logger.info(MOD_NAME + " postInitialize EXIT");
        }
        catch (Throwable t) {
            if (this.logger == null) {
                this.logger = Logger.getLogger(MOD_ID);
            }
            this.logger.severe(LogFormatter.toString(t));
        }
    }

    public void toggleWebserver(Boolean enable, boolean forceAnnounce) {
        this.webMapProperties.enabled.set(enable);
        this.waypointProperties.save();
        if (enable.booleanValue()) {
            try {
                this.jmServer = new JMServer();
                if (this.jmServer.isReady()) {
                    this.jmServer.start();
                } else {
                    enable = false;
                }
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, LogFormatter.toString(e));
                enable = false;
            }
            if (!enable.booleanValue()) {
                ChatLog.announceError(Constants.getMessageJMERR24());
            }
        } else {
            try {
                if (this.jmServer != null) {
                    this.jmServer.stop();
                }
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, LogFormatter.toString(e));
            }
        }
        if (forceAnnounce) {
            ChatLog.enableAnnounceMod = true;
        }
        ChatLog.announceMod(forceAnnounce);
    }

    public JMServer getJmServer() {
        return this.jmServer;
    }

    public void toggleTask(Class<? extends ITaskManager> managerClass, boolean enable, Object params) {
        if (this.taskController != null) {
            this.taskController.toggleTask(managerClass, enable, params);
        } else {
            this.logger.warning("taskController not available");
        }
    }

    public boolean isTaskManagerEnabled(Class<? extends ITaskManager> managerClass) {
        if (this.taskController != null) {
            return this.taskController.isTaskManagerEnabled(managerClass);
        }
        this.logger.warning("taskController not available");
        return false;
    }

    public ModInfo getModInfo() {
        return this.modInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMapping() {
        JourneyMap journeyMap = this;
        synchronized (journeyMap) {
            if (this.mc.field_71441_e == null) {
                return;
            }
            this.modInfo.reportAppView();
            this.reset();
            if (this.taskExecutor == null || this.taskExecutor.isShutdown()) {
                this.taskExecutor = Executors.newScheduledThreadPool(1, new JMThreadFactory("task"));
            } else {
                this.logger.severe("TaskExecutor in an unexpected state.  Should be null or shutdown.");
            }
            this.taskController = new TaskController();
            this.taskController.enableTasks(this.mc);
            this.logger.info("Mapping started in " + WorldData.getWorldName(this.mc) + " dimension " + this.mc.field_71441_e.field_73011_w.field_76574_g + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMapping() {
        Minecraft minecraft = Minecraft.func_71410_x();
        JourneyMap journeyMap = this;
        synchronized (journeyMap) {
            if (this.taskExecutor != null || this.taskController != null) {
                String dim = ".";
                if (minecraft.field_71441_e != null && minecraft.field_71441_e.field_73011_w != null) {
                    dim = " dimension " + minecraft.field_71441_e.field_73011_w.field_76574_g + ".";
                }
                this.logger.info("Mapping halting in " + WorldData.getWorldName(minecraft) + dim);
            }
            if (this.taskExecutor != null && !this.taskExecutor.isShutdown()) {
                this.taskExecutor.shutdown();
                this.taskExecutor = null;
            }
            if (this.taskController != null) {
                this.taskController.disableTasks(minecraft);
                this.taskController.clear();
                this.taskController = null;
            }
        }
    }

    private void reset() {
        FileHandler.lastJMWorldDir = null;
        DataCache.instance().purge();
        MapOverlay.state().follow = true;
        ColorCache.getInstance().reset();
        BlockUtils.initialize();
        DataCache.instance().purge();
        MapPlayerTask.clearCache();
        StatTimer.resetAll();
        TaskThread.reset();
        TextureCache.instance().purge();
        TileCache.instance().invalidateAll();
        RegionImageCache.getInstance().flushToDisk();
        RegionImageCache.getInstance().clear();
        UIManager.getInstance().reset();
        WaypointStore.instance().reset();
        if (this.waypointProperties.managerEnabled.get()) {
            WaypointStore.instance().load();
        }
    }

    public void updateState() {
        try {
            boolean isGamePaused;
            boolean isDead;
            if (this.mc == null) {
                this.mc = FMLClientHandler.instance().getClient();
            }
            boolean bl = isDead = this.mc.field_71462_r != null && this.mc.field_71462_r instanceof GuiGameOver;
            if (this.mc.field_71439_g != null && isDead && this.isMapping().booleanValue()) {
                this.stopMapping();
                if (this.waypointProperties.managerEnabled.get()) {
                    WaypointStore.instance().save(Waypoint.deathOf((Entity)this.mc.field_71439_g));
                }
                return;
            }
            if (this.mc.field_71441_e == null) {
                if (this.isMapping().booleanValue()) {
                    this.stopMapping();
                }
                return;
            }
            if (!this.isMapping().booleanValue() && !isDead) {
                this.startMapping();
            }
            boolean bl2 = isGamePaused = this.mc.field_71462_r != null && !(this.mc.field_71462_r instanceof MapOverlay);
            if (isGamePaused) {
                TileCache.pause();
                if (!this.isMapping().booleanValue()) {
                    return;
                }
                GuiScreen guiScreen = this.mc.field_71462_r;
                if (guiScreen instanceof GuiMainMenu || guiScreen instanceof GuiSelectWorld || guiScreen instanceof GuiMultiplayer) {
                    this.stopMapping();
                    return;
                }
            } else {
                TileCache.resume();
            }
            TileCache.resume();
            if (!isGamePaused) {
                ChatLog.showChatAnnouncements(this.mc);
            }
            if (!this.isMapping().booleanValue()) {
                this.startMapping();
            }
        }
        catch (Throwable t) {
            this.logger.severe(Constants.getMessageJMERR00(LogFormatter.toString(t)));
        }
    }

    public void performTasks() {
        try {
            if (this.isMapping().booleanValue()) {
                this.taskController.performTasks(this.mc, this.taskExecutor);
            }
        }
        catch (Throwable t) {
            String error = Constants.getMessageJMERR00(t.getMessage());
            ChatLog.announceError(error);
            this.logger.severe(LogFormatter.toString(t));
        }
    }

    public ScheduledExecutorService getChunkExecutor() {
        return this.taskExecutor;
    }

    public static Logger getLogger() {
        return JourneyMap.INSTANCE.logger;
    }
}

