/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Stack;
import net.techbrew.journeymap.cartography.ChunkStandardRenderer;
import net.techbrew.journeymap.cartography.IChunkRenderer;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.RGB;

public class ChunkTopoRenderer
extends ChunkStandardRenderer
implements IChunkRenderer {
    static final int alphaDepth = 5;
    ArrayList<RGB> water = new ArrayList(32);
    ArrayList<RGB> land = new ArrayList(32);

    public ChunkTopoRenderer() {
        this.water.add(new RGB(new Color(31, 40, 79)));
        this.water.add(new RGB(new Color(38, 60, 106)));
        this.water.add(new RGB(new Color(46, 80, 133)));
        this.water.add(new RGB(new Color(53, 99, 160)));
        this.water.add(new RGB(new Color(60, 119, 188)));
        this.water.add(new RGB(new Color(72, 151, 211)));
        this.water.add(new RGB(new Color(90, 185, 233)));
        this.water.add(new RGB(new Color(95, 198, 242)));
        this.water.add(new RGB(new Color(114, 202, 238)));
        this.water.add(new RGB(new Color(141, 210, 239)));
        this.land.add(new RGB(new Color(113, 171, 216)));
        this.land.add(new RGB(new Color(121, 178, 222)));
        this.land.add(new RGB(new Color(132, 185, 227)));
        this.land.add(new RGB(new Color(141, 193, 234)));
        this.land.add(new RGB(new Color(150, 201, 240)));
        this.land.add(new RGB(new Color(161, 210, 247)));
        this.land.add(new RGB(new Color(172, 219, 251)));
        this.land.add(new RGB(new Color(185, 227, 255)));
        this.land.add(new RGB(new Color(198, 236, 255)));
        this.land.add(new RGB(new Color(216, 242, 254)));
        this.land.add(new RGB(new Color(172, 208, 165)));
        this.land.add(new RGB(new Color(148, 191, 139)));
        this.land.add(new RGB(new Color(168, 198, 143)));
        this.land.add(new RGB(new Color(189, 204, 150)));
        this.land.add(new RGB(new Color(209, 215, 171)));
        this.land.add(new RGB(new Color(225, 228, 181)));
        this.land.add(new RGB(new Color(239, 235, 192)));
        this.land.add(new RGB(new Color(232, 225, 182)));
        this.land.add(new RGB(new Color(222, 214, 163)));
        this.land.add(new RGB(new Color(211, 202, 157)));
        this.land.add(new RGB(new Color(202, 185, 130)));
        this.land.add(new RGB(new Color(195, 167, 107)));
        this.land.add(new RGB(new Color(185, 152, 90)));
        this.land.add(new RGB(new Color(170, 135, 83)));
        this.land.add(new RGB(new Color(172, 154, 124)));
        this.land.add(new RGB(new Color(186, 174, 154)));
        this.land.add(new RGB(new Color(202, 195, 184)));
        this.land.add(new RGB(new Color(224, 222, 216)));
        this.land.add(new RGB(new Color(245, 244, 242)));
        this.land.add(new RGB(new Color(255, 255, 255)));
    }

    @Override
    public boolean render(Graphics2D g2D, ChunkMD chunkMd, boolean underground, Integer vSlice, ChunkMD.Set neighbors) {
        if (underground) {
            return false;
        }
        if (chunkMd.surfaceSlopes == null) {
            this.initSurfaceSlopes(chunkMd, neighbors);
        }
        return this.renderSurface(g2D, chunkMd, vSlice, neighbors, false);
    }

    @Override
    protected void initSurfaceSlopes(ChunkMD chunkMd, ChunkMD.Set neighbors) {
        StatTimer timer = StatTimer.get("ChunkStandardRenderer.initSurfaceSlopes");
        timer.start();
        chunkMd.surfaceSlopes = new float[16][16];
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                float slope;
                float h = chunkMd.getSlopeHeightValue(x, y);
                float hN = y == 0 ? this.getBlockHeight(x, y, 0, -1, chunkMd, neighbors, h).floatValue() : (float)chunkMd.getSlopeHeightValue(x, y - 1);
                float hW = x == 0 ? this.getBlockHeight(x, y, -1, 0, chunkMd, neighbors, h).floatValue() : (float)chunkMd.getSlopeHeightValue(x - 1, y);
                float hS = y == 15 ? this.getBlockHeight(x, y, 0, 1, chunkMd, neighbors, h).floatValue() : (float)chunkMd.getSlopeHeightValue(x, y + 1);
                float hE = x == 15 ? this.getBlockHeight(x, y, 1, 0, chunkMd, neighbors, h).floatValue() : (float)chunkMd.getSlopeHeightValue(x + 1, y);
                h = (int)h >> 3;
                hN = (int)hN >> 3;
                hW = (int)hW >> 3;
                hE = (int)hE >> 3;
                hS = (int)hS >> 3;
                chunkMd.surfaceSlopes[x][y] = slope = (h / hN + h / hW + h / hE + h / hS) / 4.0f;
            }
        }
        timer.stop();
    }

    @Override
    protected RGB getBaseBlockColor(ChunkMD chunkMd, BlockMD blockMD, ChunkMD.Set neighbors, int x, int y, int z) {
        float orthoY = y >> 3;
        if (blockMD.isWater()) {
            float saturation = orthoY == 0.0f ? 0.0f : orthoY / 32.0f;
            return new RGB(saturation, saturation, 1.0f);
        }
        int index = 0;
        index = orthoY > 0.0f && y <= 63 ? (int)Math.floor(orthoY / 1.6666666f) : 2 + (int)orthoY;
        index = Math.min(index, this.land.size() - 1);
        return this.land.get(index).copy();
    }

    @Override
    protected RGB renderSurfaceAlpha(Graphics2D g2D, ChunkMD chunkMd, BlockMD blockMD, ChunkMD.Set neighbors, int x, int y, int z) {
        RGB color = this.getBaseBlockColor(chunkMd, blockMD, neighbors, x, y, z);
        this.paintDepth(chunkMd, blockMD, x, y, z, g2D, false);
        return color;
    }

    @Override
    protected void surfaceSlopeColor(RGB color, ChunkMD chunkMd, BlockMD blockMD, ChunkMD.Set neighbors, int x, int ignored, int z) {
        float slope = chunkMd.surfaceSlopes[x][z];
        if (slope < 1.0f) {
            color.setFrom(Color.lightGray.getRGB());
        }
        if (slope > 1.0f) {
            color.setFrom(Color.darkGray.getRGB());
        }
    }

    @Override
    protected void paintDepth(ChunkMD chunkMd, BlockMD blockMD, int x, int y, int z, Graphics2D g2D, boolean useLighting) {
        BlockMD lowerBlock;
        Stack<BlockMD> stack = new Stack<BlockMD>();
        stack.push(blockMD);
        int maxDepth = 256;
        int down = y;
        while (down > 0 && (lowerBlock = BlockMD.getBlockMD(chunkMd, x, --down, z)) != null) {
            stack.push(lowerBlock);
            if (lowerBlock.getAlpha() != 1.0f && y - down <= maxDepth) continue;
            break;
        }
        RGB color = this.getBaseBlockColor(chunkMd, blockMD, null, x, down, z);
        g2D.setComposite(BlockUtils.OPAQUE);
        g2D.setPaint(color.toColor());
        g2D.fillRect(x, z, 1, 1);
    }
}

