/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import modinfo.ModInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockVine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.ReloadableResourceManager;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.client.resources.ResourceManagerReloadListener;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.IconLoader;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;

public class ColorCache
implements ResourceManagerReloadListener {
    private final HashMap<BlockMD, Color> baseColors = new HashMap(256);
    private final HashMap<String, HashMap<BlockMD, Color>> biomeColors = new HashMap(32);
    private volatile IconLoader iconLoader;
    private String lastResourcePack;

    public static ColorCache getInstance() {
        return Holder.INSTANCE;
    }

    private ColorCache() {
        ResourceManager rm = Minecraft.func_71410_x().func_110442_L();
        if (rm instanceof ReloadableResourceManager) {
            ((ReloadableResourceManager)rm).func_110542_a((ResourceManagerReloadListener)this);
        } else {
            JourneyMap.getLogger().warning("Could not register ResourcePack ReloadListener.  Changing resource packs will require restart");
        }
        this.func_110549_a(rm);
    }

    public void func_110549_a(ResourceManager mgr) {
        ResourcePackRepository repo = Minecraft.func_71410_x().func_110438_M();
        String currentPack = Arrays.asList(mgr.func_135055_a().toArray()).toString();
        if (JourneyMap.getInstance().isMapping().booleanValue() || this.iconLoader == null) {
            if (currentPack.equals(this.lastResourcePack)) {
                JourneyMap.getLogger().fine("ResourcePack unchanged: " + currentPack);
            } else {
                JourneyMap.getLogger().info("ResourcePack: " + this.lastResourcePack + " --> " + currentPack);
                ModInfo modInfo = JourneyMap.getInstance().getModInfo();
                if (modInfo != null) {
                    modInfo.reportEvent("Resource Pack", "Load", currentPack);
                }
                this.reset();
                this.lastResourcePack = currentPack;
                this.iconLoader = new IconLoader();
            }
        }
    }

    public Color getBlockColor(ChunkMD chunkMd, BlockMD blockMD, int x, int y, int z) {
        if (this.iconLoader == null) {
            return null;
        }
        Color color = null;
        if (!blockMD.isBiomeColored()) {
            color = this.getBaseColor(blockMD, x, y, z);
        }
        if (blockMD.isBiomeColored()) {
            color = this.getBiomeBlockColor(chunkMd, blockMD, x, y, z);
        }
        return color;
    }

    private Color getBiomeBlockColor(ChunkMD chunkMd, BlockMD blockMD, int x, int y, int z) {
        BiomeGenBase biome = chunkMd.stub.func_76591_a(x, z, chunkMd.worldObj.func_72959_q());
        Block block = blockMD.getBlock();
        if (block instanceof BlockGrass || block instanceof BlockDeadBush || block instanceof BlockTallGrass) {
            return this.getGrassColor(blockMD, biome, x, y, z);
        }
        if (blockMD.isWater()) {
            return this.getWaterColor(blockMD, biome, x, y, z);
        }
        if (blockMD.isFoliage() || block instanceof BlockVine) {
            return this.getFoliageColor(blockMD, biome, x, y, z);
        }
        return this.getCustomBiomeColor(blockMD, biome, x, y, z);
    }

    private Color getCustomBiomeColor(BlockMD blockMD, BiomeGenBase biome, int x, int y, int z) {
        Color color = this.getBiomeColor(blockMD, biome);
        if (color == null) {
            color = this.getBaseColor(blockMD, x, y, z);
            int tint = this.getBiomeColorMultiplier(blockMD, x, y, z);
            if (tint != 0xFFFFFF && tint != -1) {
                color = this.colorMultiplier(color, tint);
                JourneyMap.getLogger().fine("Custom biome tint set for " + blockMD.key + " in " + biome.field_76791_y);
            } else {
                JourneyMap.getLogger().fine("Custom biome tint not found for " + blockMD.key + " in " + biome.field_76791_y);
            }
            this.putBiomeColor(blockMD, biome, color);
        }
        return color;
    }

    private Color getFoliageColor(BlockMD blockMD, BiomeGenBase biome, int x, int y, int z) {
        Color color = this.getBiomeColor(blockMD, biome);
        if (color == null) {
            int leafColor = blockMD.getBlock().func_71889_f_(blockMD.key.meta);
            int biomeColor = BiomeGenBase.field_76772_c.func_76726_l();
            try {
                biomeColor = biome.func_76726_l();
            }
            catch (Throwable t) {
                blockMD.addFlags(BlockUtils.Flag.Error);
                JourneyMap.getLogger().severe("Couldn't get biome foliage color: " + LogFormatter.toString(t));
            }
            int leafTimesBiome = this.colorMultiplier(biomeColor, leafColor);
            int darker = this.colorMultiplier(leafTimesBiome, -5592406);
            color = new Color(darker);
            this.putBiomeColor(blockMD, biome, color);
        }
        return color;
    }

    private Color getGrassColor(BlockMD blockMD, BiomeGenBase biome, int x, int y, int z) {
        Color color = this.getBiomeColor(blockMD, biome);
        if (color == null) {
            Color baseColor = this.getBaseColor(blockMD, x, y, z);
            int biomeColor = BiomeGenBase.field_76772_c.func_76737_k();
            try {
                biomeColor = biome.func_76737_k();
            }
            catch (Throwable t) {
                blockMD.addFlags(BlockUtils.Flag.Error);
                JourneyMap.getLogger().severe("Couldn't get biome grass color: " + LogFormatter.toString(t));
            }
            color = this.colorMultiplier(baseColor, biomeColor);
            this.putBiomeColor(blockMD, biome, color);
        }
        return color;
    }

    private Color getWaterColor(BlockMD blockMD, BiomeGenBase biome, int x, int y, int z) {
        Color color = this.getBiomeColor(blockMD, biome);
        if (color == null) {
            color = this.colorMultiplier(this.getBaseColor(blockMD, x, y, z), biome.field_76759_H);
            this.putBiomeColor(blockMD, biome, color);
        }
        return color;
    }

    private int getBiomeColorMultiplier(BlockMD blockMD, int x, int y, int z) {
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        try {
            return blockMD.getBlock().func_71920_b((IBlockAccess)world, x, 78, z) | 0xFF000000;
        }
        catch (NullPointerException e) {
            JourneyMap.getLogger().warning("Block throws NullPointerException when calling colorMultiplier(): " + blockMD.getBlock().func_71917_a());
            return 0xFFFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<BlockMD, Color> getBiomeColorMap(BiomeGenBase biome) {
        HashMap<String, HashMap<BlockMD, Color>> hashMap = this.biomeColors;
        synchronized (hashMap) {
            HashMap<BlockMD, Color> biomeColorMap = this.biomeColors.get(biome.field_76791_y);
            if (biomeColorMap == null) {
                biomeColorMap = new HashMap(16);
            }
            this.biomeColors.put(biome.field_76791_y, biomeColorMap);
            return biomeColorMap;
        }
    }

    private Color getBiomeColor(BlockMD blockMD, BiomeGenBase biome) {
        return this.getBiomeColorMap(biome).get(blockMD);
    }

    private void putBiomeColor(BlockMD blockMD, BiomeGenBase biome, Color color) {
        this.getBiomeColorMap(biome).put(blockMD, color);
    }

    private Color getBaseColor(BlockMD blockMD, int x, int y, int z) {
        Color color = this.baseColors.get(blockMD);
        if (color == null) {
            if (blockMD.isTransparent()) {
                color = Color.white;
                blockMD.setAlpha(0.0f);
                blockMD.addFlags(BlockUtils.Flag.HasAir, BlockUtils.Flag.NotHideSky, BlockUtils.Flag.NoShadow);
            } else {
                color = this.loadBaseColor(blockMD, x, y, z);
            }
            this.baseColors.put(blockMD, color);
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Color loadBaseColor(BlockMD blockMD, int x, int y, int z) {
        Color baseColor = null;
        IconLoader iconLoader = this.iconLoader;
        synchronized (iconLoader) {
            baseColor = this.iconLoader.loadBlockColor(blockMD);
        }
        if (baseColor != null && !blockMD.isBiomeColored()) {
            int tint = this.getBiomeColorMultiplier(blockMD, x, y, z);
            if (tint != 0xFFFFFF && tint != -1) {
                blockMD.addFlags(BlockUtils.Flag.CustomBiomeColor);
                BlockUtils.setFlags(blockMD.key.uid, BlockUtils.Flag.BiomeColor);
                JourneyMap.getLogger().fine("Custom biome tint discovered for " + blockMD);
            } else {
                int renderColor = blockMD.getBlock().func_71889_f_(blockMD.key.meta & 0xF);
                if (renderColor != 0xFFFFFF && renderColor != -1) {
                    baseColor = this.colorMultiplier(baseColor, 0xFF000000 | renderColor);
                    JourneyMap.getLogger().fine("Applied render color for " + blockMD);
                }
            }
        }
        if (baseColor == null) {
            baseColor = Color.BLACK;
            if (this.iconLoader.failedFor(blockMD)) {
                JourneyMap.getLogger().warning("Iconloader failed to get base color for " + blockMD);
            } else {
                JourneyMap.getLogger().warning("Unknown failure, could not get base color for " + blockMD);
            }
        }
        return baseColor;
    }

    public void reset() {
        this.biomeColors.clear();
        this.baseColors.clear();
        BlockUtils.initialize();
    }

    public String getCacheDebugHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append(LogFormatter.LINEBREAK).append("<!-- color cache --><div>");
        sb.append(LogFormatter.LINEBREAK).append("<b>Current Resource Packs: </b>").append(this.lastResourcePack);
        sb.append(LogFormatter.LINEBREAK).append("<table><tr valign='top'><td width='50%'>");
        sb.append(this.debugCache(BlockUtils.getAlphaMap(), "Block Transparency"));
        sb.append(LogFormatter.LINEBREAK).append("</td><td>");
        sb.append(LogFormatter.LINEBREAK).append(this.debugCache(BlockUtils.getFlagsMap(), "Block Flags"));
        sb.append(LogFormatter.LINEBREAK).append("</td></tr></table>");
        sb.append(LogFormatter.LINEBREAK).append(this.debugCache(this.baseColors, "Base Colors"));
        ArrayList<String> biomeNames = new ArrayList<String>(this.biomeColors.keySet());
        Collections.sort(biomeNames);
        for (String biome : biomeNames) {
            HashMap<BlockMD, Color> colorsForBiome = this.biomeColors.get(biome);
            sb.append(LogFormatter.LINEBREAK).append(this.debugCache(colorsForBiome, "Biome Colors: " + biome));
        }
        sb.append(LogFormatter.LINEBREAK).append("</div><!-- /color cache -->");
        return sb.toString();
    }

    private String debugCache(HashMap cache, String name) {
        if (cache.isEmpty()) {
            return "";
        }
        ArrayList keyList = new ArrayList(cache.keySet());
        Collections.sort(keyList, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        String biome = null;
        StringBuilder sb = new StringBuilder().append(LogFormatter.LINEBREAK).append("<h2>").append(name).append("</h2><div>");
        for (Object key : keyList) {
            String info;
            Object value = cache.get(key);
            if (key instanceof BlockMD) {
                info = ((BlockMD)key).getName();
            } else {
                info = key.toString();
                if (info.indexOf("|") >= 0) {
                    String[] infoSplit = info.split("\\|");
                    if (!infoSplit[0].equals(biome)) {
                        biome = infoSplit[0];
                        sb.append("<h3>").append(biome).append("</h3>");
                    }
                    info = infoSplit[1];
                }
            }
            if (value instanceof Color) {
                Color color = (Color)value;
                String hex = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
                sb.append(LogFormatter.LINEBREAK).append("<span class='entry' title='").append(hex).append("'>");
                sb.append("<span class='rgb' style='background-color:").append(hex).append("'></span>");
                sb.append(info).append("</span>");
                continue;
            }
            if (value instanceof Number) {
                if (Double.parseDouble(value.toString()) == 1.0) continue;
                sb.append(LogFormatter.LINEBREAK).append("<div class='other'><b>").append(info).append("</b>: ");
                sb.append(value).append("</div>");
                continue;
            }
            sb.append(LogFormatter.LINEBREAK).append("<div class='other'><b>").append(info).append("</b>: ");
            sb.append(value).append("</div>");
        }
        sb.append(LogFormatter.LINEBREAK).append("</div><!-- /").append(name).append(" -->");
        return sb.toString();
    }

    Color colorMultiplier(Color color, int mult) {
        return new Color(this.colorMultiplier(color.getRGB(), mult));
    }

    int colorMultiplier(int rgb, int mult) {
        int alpha1 = rgb >> 24 & 0xFF;
        int red1 = rgb >> 16 & 0xFF;
        int green1 = rgb >> 8 & 0xFF;
        int blue1 = rgb >> 0 & 0xFF;
        int alpha2 = mult >> 24 & 0xFF;
        int red2 = mult >> 16 & 0xFF;
        int green2 = mult >> 8 & 0xFF;
        int blue2 = mult >> 0 & 0xFF;
        int alpha = alpha1 * alpha2 / 255;
        int red = red1 * red2 / 255;
        int green = green1 * green2 / 255;
        int blue = blue1 * blue2 / 255;
        int result = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        return result | 0xFF000000;
    }

    private static class Holder {
        private static final ColorCache INSTANCE = new ColorCache();

        private Holder() {
        }
    }
}

