/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import com.google.common.cache.CacheLoader;
import cpw.mods.fml.client.FMLClientHandler;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.NetClientHandler;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.VersionCheck;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.log.LogFormatter;
import org.lwjgl.opengl.Display;

public class WorldData
extends CacheLoader<Class, WorldData> {
    String name;
    int dimension;
    long time;
    boolean hardcore;
    boolean singlePlayer;
    Map<Feature, Boolean> features;
    String jm_version;
    String latest_journeymap_version;
    String mc_version;
    String mod_name = JourneyMap.MOD_NAME;
    int browser_poll;

    public WorldData load(Class aClass) throws Exception {
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldInfo worldInfo = mc.field_71441_e.func_72912_H();
        IntegratedServer server = mc.func_71401_C();
        boolean multiplayer = server == null || server.func_71344_c();
        this.name = WorldData.getWorldName(mc);
        this.dimension = mc.field_71441_e.field_73011_w.field_76574_g;
        this.hardcore = worldInfo.func_76093_s();
        this.singlePlayer = !multiplayer;
        this.time = mc.field_71441_e.func_72820_D() % 24000L;
        this.features = FeatureManager.getAllowedFeatures();
        this.mod_name = JourneyMap.MOD_NAME;
        this.jm_version = "4.0.3";
        this.latest_journeymap_version = VersionCheck.getVersionAvailable();
        this.mc_version = Display.getTitle().split("\\s(?=\\d)")[1];
        this.browser_poll = Math.max(1000, JourneyMap.getInstance().webMapProperties.browserPoll.get());
        return this;
    }

    public static boolean isHardcoreAndMultiplayer() {
        WorldData world = DataCache.instance().getWorld(false);
        return world.hardcore && !world.singlePlayer;
    }

    private static String getServerHash() {
        String serverName = WorldData.getServerName();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            if (md5 != null) {
                byte[] bServerName = serverName.getBytes("UTF-8");
                byte[] hashed = md5.digest(bServerName);
                BigInteger bigInt = new BigInteger(1, hashed);
                String md5Hash = bigInt.toString(16);
                while (md5Hash.length() < 32) {
                    md5Hash = "0" + md5Hash;
                }
                return md5Hash;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serverName;
    }

    private static String getServerName() {
        try {
            NetClientHandler sendQueue = Minecraft.func_71410_x().func_71391_r();
            SocketAddress socketAddress = sendQueue.func_72548_f().func_74430_c();
            if (socketAddress != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                return inetAddr.getHostName();
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe("Couldn't get server name: " + LogFormatter.toString(t));
        }
        return "server";
    }

    public static int getServerPort() {
        try {
            NetClientHandler sendQueue = Minecraft.func_71410_x().func_71391_r();
            SocketAddress socketAddress = sendQueue.func_72548_f().func_74430_c();
            if (socketAddress != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                return inetAddr.getPort();
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe("Couldn't get server port: " + LogFormatter.toString(t));
        }
        return 0;
    }

    public static String getWorldName(Minecraft mc) {
        String worldName = null;
        if (mc.func_71356_B()) {
            worldName = mc.func_71401_C().func_71221_J();
        } else {
            if (mc.field_71441_e == null) {
                return "offline";
            }
            worldName = mc.field_71441_e.func_72912_H().func_76065_j();
            worldName = !"MpServer".equals(worldName) ? WorldData.getServerName() + "_" + worldName : WorldData.getServerName();
        }
        try {
            worldName = URLEncoder.encode(worldName, "UTF-8").replaceAll("\\+", " ");
        }
        catch (UnsupportedEncodingException e) {
            worldName = "Minecraft";
        }
        return worldName;
    }

    public static List<WorldProvider> getDimensionProviders(List<Integer> requiredDimensionList) {
        WorldProvider provider;
        HashSet<Integer> requiredDims = new HashSet<Integer>(requiredDimensionList);
        HashMap<Integer, WorldProvider> dimProviders = new HashMap<Integer, WorldProvider>();
        Level logLevel = Level.FINE;
        JourneyMap.getLogger().log(logLevel, String.format("Required dimensions from waypoints: %s", requiredDimensionList));
        Integer[] dims = DimensionManager.getIDs();
        JourneyMap.getLogger().log(logLevel, String.format("DimensionManager has dims: %s", Arrays.asList(dims)));
        requiredDims.addAll(Arrays.asList(dims));
        dims = DimensionManager.getStaticDimensionIDs();
        JourneyMap.getLogger().log(logLevel, String.format("DimensionManager has static dims: %s", Arrays.asList(dims)));
        requiredDims.addAll(Arrays.asList(dims));
        WorldProvider playerProvider = FMLClientHandler.instance().getClient().field_71439_g.field_70170_p.field_73011_w;
        dimProviders.put(playerProvider.field_76574_g, playerProvider);
        requiredDims.remove(playerProvider.field_76574_g);
        JourneyMap.getLogger().log(logLevel, String.format("Using player's provider for dim %s: %s", playerProvider.field_76574_g, playerProvider.func_80007_l()));
        for (int dim : requiredDims) {
            if (dimProviders.containsKey(dim)) continue;
            if (DimensionManager.getWorld((int)dim) != null) {
                try {
                    WorldProvider dimProvider = DimensionManager.getProvider((int)dim);
                    dimProviders.put(dim, dimProvider);
                    JourneyMap.getLogger().log(logLevel, String.format("DimensionManager.getProvider(%s): %s", dim, dimProvider.func_80007_l()));
                }
                catch (Throwable t) {
                    JourneyMap.getLogger().warning(String.format("Couldn't DimensionManager.getProvider(%s) because of error: %s", dim, t.getMessage()));
                }
                continue;
            }
            try {
                provider = DimensionManager.createProviderFor((int)dim);
                provider.field_76574_g = dim;
                dimProviders.put(dim, provider);
                JourneyMap.getLogger().log(logLevel, String.format("DimensionManager.createProviderFor(%s): %s", dim, provider.func_80007_l()));
            }
            catch (Throwable t) {
                JourneyMap.getLogger().warning(String.format("Couldn't DimensionManager.createProviderFor(%s) because of error: %s", dim, t.getMessage()));
            }
        }
        requiredDims.removeAll(dimProviders.keySet());
        for (int dim : requiredDims) {
            if (dimProviders.containsKey(dim)) continue;
            provider = new FakeDimensionProvider(dim);
            dimProviders.put(dim, provider);
            JourneyMap.getLogger().warning(String.format("Used fake provider for required dim: %s", dim));
        }
        ArrayList<WorldProvider> providerList = new ArrayList<WorldProvider>(dimProviders.values());
        Collections.sort(providerList, new Comparator<WorldProvider>(){

            @Override
            public int compare(WorldProvider o1, WorldProvider o2) {
                return Integer.valueOf(o1.field_76574_g).compareTo(o2.field_76574_g);
            }
        });
        return providerList;
    }

    public long getTTL() {
        return 1000L;
    }

    static class FakeDimensionProvider
    extends WorldProvider {
        FakeDimensionProvider(int dimension) {
            this.field_76574_g = dimension;
        }

        public String func_80007_l() {
            return Constants.getString("JourneyMap.dimension", this.field_76574_g);
        }
    }
}

