/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.forgehandler;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.logging.Level;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.forgehandler.EventHandlerManager;
import net.techbrew.journeymap.task.MapPlayerTask;

public class ChunkUpdateHandler
implements EventHandlerManager.EventHandler {
    Level logLevel = Level.FINER;
    boolean debug = JourneyMap.getLogger().isLoggable(this.logLevel);

    @Override
    public EnumSet<EventHandlerManager.BusType> getBus() {
        return EnumSet.of(EventHandlerManager.BusType.MinecraftForgeBus);
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onChunkLoadEvent(ChunkEvent.Load event) {
        this.queueChunk((Event)event, event.getChunk().func_76632_l());
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onChunkUnloadEvent(ChunkEvent.Unload event) {
        MapPlayerTask.dequeueChunk(event.getChunk().func_76632_l());
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onChunkPopulateEvent(PopulateChunkEvent.Post event) {
        ChunkCoordIntPair coord = new ChunkCoordIntPair(event.chunkX, event.chunkZ);
        this.queueChunk((Event)event, coord);
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onBlockBreakEvent(BlockEvent event) {
        if (event instanceof BlockEvent.HarvestDropsEvent) {
            return;
        }
        ChunkCoordIntPair coord = new ChunkCoordIntPair(event.x >> 4, event.z >> 4);
        this.queueChunk((Event)event, coord);
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onBlockPlaceEvent(PlayerInteractEvent event) {
        if (event.getResult() == event.useBlock) {
            ChunkCoordIntPair coord = new ChunkCoordIntPair(event.x >> 4, event.z >> 4);
            this.queueChunk((Event)event, coord);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onSoundEvent(PlaySoundEvent event) {
        if (event != null) {
            int x = (int)event.x >> 4;
            int z = (int)event.x >> 4;
            if (event.name != null) {
                if (event.name.contains("explode")) {
                    for (int ox = x - 1; ox <= x + 1; ++ox) {
                        for (int oz = z - 1; oz <= z + 1; ++oz) {
                            ChunkCoordIntPair coord = new ChunkCoordIntPair(ox, oz);
                            this.queueChunk((Event)event, coord);
                        }
                    }
                } else if (event.name.contains("dig")) {
                    ChunkCoordIntPair coord = new ChunkCoordIntPair(x, z);
                    this.queueChunk((Event)event, coord);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onHoeEvent(UseHoeEvent event) {
        ChunkCoordIntPair coord = new ChunkCoordIntPair(event.x >> 4, event.z >> 4);
        this.queueChunk((Event)event, coord);
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onBonemealEvent(BonemealEvent event) {
        ChunkCoordIntPair coord = new ChunkCoordIntPair(event.X >> 4, event.Z >> 4);
        this.queueChunk((Event)event, coord);
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onChunkDataEvent(ChunkDataEvent event) {
        this.queueChunk((Event)event, event.getChunk().func_76632_l());
    }

    private void queueChunk(Event event, ChunkCoordIntPair coord) {
        if (MapPlayerTask.queueChunk(coord) && this.debug) {
            JourneyMap.getLogger().log(this.logLevel, String.format("Queuing chunk via %s: %s", event.getClass().getName(), coord));
        }
    }
}

