/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.forgehandler;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraftforge.common.MinecraftForge;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.forgehandler.ChunkUpdateHandler;
import net.techbrew.journeymap.forgehandler.KeyEventHandler;
import net.techbrew.journeymap.forgehandler.MiniMapOverlayHandler;
import net.techbrew.journeymap.forgehandler.StateTickHandler;
import net.techbrew.journeymap.forgehandler.WaypointBeaconHandler;
import net.techbrew.journeymap.forgehandler.WorldEventHandler;
import net.techbrew.journeymap.log.LogFormatter;

public class EventHandlerManager {
    private static HashMap<Class<? extends EventHandler>, EventHandler> handlers = new HashMap();

    public static void registerGeneralHandlers() {
        EventHandlerManager.register(new StateTickHandler());
        EventHandlerManager.register(new WorldEventHandler());
        EventHandlerManager.register(new ChunkUpdateHandler());
        EventHandlerManager.register(new WaypointBeaconHandler());
    }

    public static void registerGuiHandlers() {
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new KeyEventHandler());
        EventHandlerManager.register(new MiniMapOverlayHandler());
    }

    public static void unregisterAll() {
        ArrayList<Class<? extends EventHandler>> list = new ArrayList<Class<? extends EventHandler>>(handlers.keySet());
        for (Class<? extends EventHandler> handlerClass : list) {
            EventHandlerManager.unregister(handlerClass);
        }
    }

    private static void register(EventHandler handler) {
        if (handlers.containsKey(handler.getClass())) {
            JourneyMap.getLogger().warning("Handler already registered: " + handler.getClass().getName());
            return;
        }
        boolean registered = false;
        EnumSet<BusType> buses = handler.getBus();
        for (BusType busType : handler.getBus()) {
            String name = handler.getClass().getName();
            try {
                switch (busType) {
                    case MinecraftForgeBus: {
                        MinecraftForge.EVENT_BUS.register((Object)handler);
                        registered = true;
                        break;
                    }
                    case TickRegistry: {
                        TickRegistry.registerTickHandler((ITickHandler)((ITickHandler)handler), (Side)Side.CLIENT);
                        registered = true;
                        break;
                    }
                    case ScheduledTickRegistry: {
                        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)((IScheduledTickHandler)handler), (Side)Side.CLIENT);
                        registered = true;
                    }
                }
                if (!registered) continue;
                JourneyMap.getLogger().fine(name + " registered in " + (Object)((Object)busType));
            }
            catch (Throwable t) {
                JourneyMap.getLogger().severe(name + " registration FAILED in " + (Object)((Object)busType) + ": " + LogFormatter.toString(t));
            }
        }
        if (registered) {
            handlers.put(handler.getClass(), handler);
        } else {
            JourneyMap.getLogger().warning("Handler was not registered at all: " + handler.getClass().getName());
        }
    }

    public static void unregister(Class<? extends EventHandler> handlerClass) {
        EventHandler handler = handlers.remove(handlerClass);
        if (handler != null) {
            EnumSet<BusType> buses = handler.getBus();
            for (BusType busType : handler.getBus()) {
                String name = handler.getClass().getName();
                try {
                    boolean unregistered = false;
                    switch (busType) {
                        case MinecraftForgeBus: {
                            MinecraftForge.EVENT_BUS.unregister((Object)handler);
                            unregistered = true;
                        }
                    }
                    if (!unregistered) continue;
                    JourneyMap.getLogger().fine(name + " unregistered from " + (Object)((Object)busType));
                }
                catch (Throwable t) {
                    JourneyMap.getLogger().severe(name + " unregistration FAILED from " + (Object)((Object)busType) + ": " + LogFormatter.toString(t));
                }
            }
        }
    }

    public static interface EventHandler {
        public EnumSet<BusType> getBus();
    }

    public static enum BusType {
        TickRegistry,
        ScheduledTickRegistry,
        MinecraftForgeBus;

    }
}

