/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.io.PngjHelper;
import net.techbrew.journeymap.io.RegionImageHandler;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.RegionCoord;
import net.techbrew.journeymap.model.RegionImageCache;

public class MapSaver {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    final File worldDir;
    File saveFile;
    final Constants.MapType mapType;
    final Integer vSlice;
    final int dimension;
    int outputColumns;
    int outputRows;
    ArrayList<File> files;

    public MapSaver(File worldDir, Constants.MapType mapType, Integer vSlice, int dimension) {
        this.worldDir = worldDir;
        this.mapType = mapType;
        this.vSlice = vSlice;
        this.dimension = dimension;
        this.prepareFiles();
    }

    public File saveMap() {
        StatTimer timer = StatTimer.get("MapSaver.saveMap");
        try {
            if (!this.isValid()) {
                JourneyMap.getLogger().warning("No images found in " + this.getImageDir());
                return null;
            }
            RegionImageCache.getInstance().flushToDisk();
            timer.start();
            File[] fileArray = this.files.toArray(new File[this.files.size()]);
            PngjHelper.mergeFiles(fileArray, this.saveFile, this.outputColumns, 512);
            timer.stop();
            JourneyMap.getLogger().info("Map filesize:" + this.saveFile.length());
            String message = Constants.getString("MapSaver.map_saved", this.saveFile);
            ChatLog.announceFile(message, this.saveFile);
        }
        catch (OutOfMemoryError e) {
            String error = Constants.getMessageJMERR18("Out Of Memory: Increase Java Heap Size for Minecraft to save large maps.");
            JourneyMap.getLogger().severe(error);
            ChatLog.announceError(error);
            timer.cancel();
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe(LogFormatter.toString(t));
            ChatLog.announceError(Constants.getMessageJMERR18(t.getMessage()));
            timer.cancel();
            return null;
        }
        return this.saveFile;
    }

    public String getSaveFileName() {
        return this.saveFile.getName();
    }

    public boolean isValid() {
        return this.files != null && this.files.size() > 0;
    }

    private File getImageDir() {
        RegionCoord fakeRc = new RegionCoord(this.worldDir, 0, this.vSlice, 0, this.dimension);
        return RegionImageHandler.getImageDir(fakeRc, this.mapType);
    }

    private void prepareFiles() {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            String date = dateFormat.format(new Date());
            boolean isUnderground = this.mapType.equals((Object)Constants.MapType.underground);
            StringBuilder sb = new StringBuilder(date).append("_");
            sb.append(WorldData.getWorldName(mc)).append("_");
            sb.append(mc.field_71441_e.field_73011_w.func_80007_l()).append("_");
            if (isUnderground) {
                sb.append("slice").append(this.vSlice);
            } else {
                sb.append((Object)this.mapType);
            }
            sb.append(".png");
            File screenshotsDir = new File(Minecraft.func_71410_x().field_71412_D, "screenshots");
            if (!screenshotsDir.exists()) {
                screenshotsDir.mkdir();
            }
            this.saveFile = new File(screenshotsDir, sb.toString());
            RegionImageCache.getInstance().flushToDisk();
            File imageDir = this.getImageDir();
            File[] pngFiles = imageDir.listFiles();
            Pattern tilePattern = Pattern.compile("([^\\.]+)\\,([^\\.]+)\\.png");
            Integer minX = null;
            Integer minZ = null;
            Integer maxX = null;
            Integer maxZ = null;
            for (File file : pngFiles) {
                Matcher matcher = tilePattern.matcher(file.getName());
                if (!matcher.matches()) continue;
                Integer x = Integer.parseInt(matcher.group(1));
                Integer z = Integer.parseInt(matcher.group(2));
                if (minX == null || x < minX) {
                    minX = x;
                }
                if (minZ == null || z < minZ) {
                    minZ = z;
                }
                if (maxX == null || x > maxX) {
                    maxX = x;
                }
                if (maxZ != null && z <= maxZ) continue;
                maxZ = z;
            }
            if (minX == null || maxX == null || minZ == null || maxZ == null) {
                JourneyMap.getLogger().warning("No region files to save in " + imageDir);
                return;
            }
            long blankSize = RegionImageHandler.getBlank512x512ImageFile().length();
            this.outputColumns = maxX - minX + 1;
            this.outputRows = maxZ - minZ + 1;
            this.files = new ArrayList(this.outputColumns * this.outputRows);
            for (int rz = minZ.intValue(); rz <= maxZ; ++rz) {
                for (int rx = minX.intValue(); rx <= maxX; ++rx) {
                    RegionCoord rc = new RegionCoord(this.worldDir, rx, this.vSlice, rz, this.dimension);
                    File rfile = RegionImageHandler.getRegionImageFile(rc, this.mapType, true);
                    if (rfile.canRead()) {
                        this.files.add(rfile);
                        continue;
                    }
                    this.files.add(RegionImageHandler.getBlank512x512ImageFile());
                }
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().log(Level.SEVERE, LogFormatter.toString(t));
        }
    }
}

