/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.log;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StringUtils;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.VersionCheck;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.server.JMServer;

public class ChatLog {
    private static boolean initialized = false;
    public static boolean enableAnnounceMod = false;
    static final List<Chat> announcements = Collections.synchronizedList(new LinkedList());

    public static void queueAnnouncement(Chat chat) {
        chat.text = Constants.getString("JourneyMap.chat_announcement", chat.text);
        announcements.add(chat);
    }

    public static void announceURL(String message, String url) {
        ChatLog.queueAnnouncement(new Chat(message));
    }

    public static void announceFile(String message, File file) {
        ChatLog.queueAnnouncement(new FileChat(message, file));
    }

    public static void announceI18N(String key, Object ... parms) {
        String text = Constants.getString(key, parms);
        ChatLog.queueAnnouncement(new Chat(text));
    }

    public static void announceError(String text) {
        Chat chat = new Chat(text);
        chat.logLevel = Level.SEVERE;
        ChatLog.queueAnnouncement(chat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showChatAnnouncements(Minecraft mc) {
        if (!initialized) {
            enableAnnounceMod = JourneyMap.getInstance().coreProperties.announceMod.get();
            ChatLog.announceMod(false);
            if (!VersionCheck.getVersionIsCurrent().booleanValue()) {
                ChatLog.announceI18N(Constants.getString("JourneyMap.new_version_available", ""), new Object[0]);
                ChatLog.announceURL("http://journeymap.techbrew.net/", "http://journeymap.techbrew.net/");
            }
            initialized = true;
        }
        while (!announcements.isEmpty()) {
            Chat message = announcements.remove(0);
            if (message == null) continue;
            try {
                mc.field_71456_v.func_73827_b().func_73765_a(message.text);
                if (!(message instanceof FileChat)) continue;
                FileHandler.open(((FileChat)message).file);
            }
            catch (Exception e) {
                JourneyMap.getLogger().severe("Could not display announcement in chat: " + LogFormatter.toString(e));
            }
            finally {
                JourneyMap.getLogger().log(message.logLevel, StringUtils.func_76338_a((String)message.text));
            }
        }
    }

    public static void announceMod(boolean forced) {
        if (enableAnnounceMod) {
            ChatLog.announceI18N("JourneyMap.ready", JourneyMap.MOD_NAME);
            if (JourneyMap.getInstance().webMapProperties.enabled.get()) {
                JMServer jmServer = JourneyMap.getInstance().getJmServer();
                String keyName = Constants.getKeyName(Constants.KB_MAP);
                String port = jmServer.getPort() == 80 ? "" : ":" + Integer.toString(jmServer.getPort());
                String message = Constants.getString("JourneyMap.webserver_and_mapgui_ready", keyName, port);
                ChatLog.announceURL(message, "http://localhost" + port);
            } else {
                String keyName = Constants.getKeyName(Constants.KB_MAP);
                ChatLog.announceI18N("JourneyMap.mapgui_only_ready", keyName);
            }
            enableAnnounceMod = false;
        }
    }

    private static class FileChat
    extends Chat {
        final File file;

        public FileChat(String text, File file) {
            super(text);
            this.file = file;
        }
    }

    private static class Chat {
        Level logLevel = Level.INFO;
        String text;

        public Chat(String text) {
            this.text = text;
        }
    }
}

