/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.io.Serializable;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.ColorCache;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.RGB;

public class BlockMD
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final LoadingCache<CacheKey, BlockMD> cache = CacheBuilder.newBuilder().concurrencyLevel(1).initialCapacity(256).build((CacheLoader)new CacheLoader<CacheKey, BlockMD>(){

        public BlockMD load(CacheKey key) throws Exception {
            return BlockMD.createBlockMD(key);
        }
    });
    public final CacheKey key;
    private transient Block block;
    private Color color;
    private float alpha;
    private AlphaComposite alphaComposite;
    private final EnumSet<BlockUtils.Flag> flags;
    private final String name;

    public static BlockMD getBlockMD(ChunkMD chunkMd, int x, int y, int z) {
        boolean isAir = false;
        try {
            int meta;
            Block block;
            if (y >= 0) {
                block = chunkMd.getBlock(x, y, z);
                isAir = block == null || block.field_71990_ca == 0 || block.isAirBlock(chunkMd.worldObj, x, y, z);
                meta = isAir ? 0 : chunkMd.stub.func_76628_c(x, y, z);
            } else {
                block = Block.field_71986_z;
                meta = 0;
            }
            if (isAir) {
                return (BlockMD)cache.get((Object)CacheKey.AIR);
            }
            CacheKey key = new CacheKey(new BlockUtils.UniqueIdentifierProxy(block), meta);
            return (BlockMD)cache.get((Object)key);
        }
        catch (Exception e) {
            JourneyMap.getLogger().severe("Can't get blockId/meta for chunk " + chunkMd.stub.field_76635_g + "," + chunkMd.stub.field_76647_h + " block " + x + "," + y + "," + z + ": " + LogFormatter.toString(e));
            return null;
        }
    }

    public static BlockMD getBlockMD(BlockUtils.UniqueIdentifierProxy uid, int meta) {
        try {
            return (BlockMD)cache.get((Object)new CacheKey(uid, meta));
        }
        catch (Exception e) {
            JourneyMap.getLogger().severe("Can't get BlockMD for block " + uid + " meta " + meta + ": " + LogFormatter.toString(e));
            return null;
        }
    }

    private static final BlockMD createBlockMD(CacheKey key) {
        BlockMD blockMD;
        if (key.uid.blockId == 0 || key.uid.blockId - 1 > Block.field_71973_m.length) {
            blockMD = new BlockMD(key, null, "air");
        } else {
            Block block = Block.field_71973_m[key.uid.blockId];
            blockMD = new BlockMD(key, block, key.uid.toString() + ":" + key.meta);
        }
        if (blockMD.isAir()) {
            blockMD.color = Color.CYAN;
            blockMD.setAlpha(0.0f);
        } else if (BlockUtils.hasAlpha(blockMD.getBlock())) {
            blockMD.setAlpha(BlockUtils.getAlpha(blockMD.getBlock()));
        } else {
            blockMD.setAlpha(1.0f);
        }
        return blockMD;
    }

    private BlockMD(CacheKey key, Block block, String name) {
        this.key = key;
        this.block = block;
        this.name = name;
        this.flags = BlockUtils.getFlags(this.key.uid);
    }

    public boolean hasFlag(BlockUtils.Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public void addFlags(BlockUtils.Flag ... addFlags) {
        for (BlockUtils.Flag flag : addFlags) {
            this.flags.add(flag);
        }
    }

    public RGB getColor(ChunkMD chunkMd, int x, int y, int z) {
        if (this.isAir()) {
            JourneyMap.getLogger();
        }
        if (this.color != null) {
            return new RGB(this.color);
        }
        Color color = ColorCache.getInstance().getBlockColor(chunkMd, this, x, y, z);
        if (color == null) {
            return new RGB(Color.BLACK);
        }
        if (this.isBiomeColored()) {
            return new RGB(color);
        }
        this.color = color;
        return new RGB(color);
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        if (alpha < 1.0f) {
            this.flags.add(BlockUtils.Flag.Transparency);
            this.alphaComposite = AlphaComposite.getInstance(3, alpha);
        } else {
            if (this.hasFlag(BlockUtils.Flag.Transparency)) {
                this.flags.remove((Object)BlockUtils.Flag.Transparency);
            }
            this.alphaComposite = null;
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public AlphaComposite getAlphaComposite() {
        return this.alphaComposite == null ? BlockUtils.OPAQUE : this.alphaComposite;
    }

    public Block getBlock() {
        if (this.block == null && this.key.uid.blockId > 0 && this.key.uid.blockId == 0) {
            this.block = Block.field_71973_m[this.key.uid.blockId];
        }
        return this.block;
    }

    public boolean isTransparent() {
        return this.block.field_72018_cp == Material.field_76249_a;
    }

    public boolean isAir() {
        return this.hasFlag(BlockUtils.Flag.HasAir);
    }

    public boolean isIce() {
        return this.block == Block.field_72036_aT;
    }

    public boolean isTorch() {
        this.getBlock();
        return this.block == Block.field_72069_aq || this.block == Block.field_72035_aQ || this.block == Block.field_72049_aP;
    }

    public boolean isWater() {
        this.getBlock();
        return this.block == Block.field_71942_A || this.block == Block.field_71943_B;
    }

    public boolean isTransparentRoof() {
        return this.hasFlag(BlockUtils.Flag.TransparentRoof);
    }

    public boolean isLava() {
        this.getBlock();
        return this.block == Block.field_71944_C || this.block == Block.field_71938_D;
    }

    public boolean isFoliage() {
        return this.getBlock() instanceof BlockLeaves;
    }

    public boolean isBiomeColored() {
        return this.flags.contains((Object)BlockUtils.Flag.BiomeColor) || this.flags.contains((Object)BlockUtils.Flag.CustomBiomeColor);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockMD)) {
            return false;
        }
        BlockMD other = (BlockMD)obj;
        return this.key.equals(other.key);
    }

    public String toString() {
        return "BlockMD [" + this.key.uid + " meta " + this.key.meta + "]";
    }

    public String getName() {
        return this.name;
    }

    public static void clearCache() {
        cache.invalidateAll();
    }

    public static CacheStats getStats() {
        return cache.stats();
    }

    public static final class CacheKey
    implements Serializable {
        public static final CacheKey AIR = new CacheKey(BlockUtils.AIRPROXY, 0);
        public final BlockUtils.UniqueIdentifierProxy uid;
        public final int meta;

        public CacheKey(BlockUtils.UniqueIdentifierProxy uid, int meta) {
            this.uid = uid;
            this.meta = meta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.meta != cacheKey.meta) {
                return false;
            }
            return this.uid.equals(cacheKey.uid);
        }

        public int hashCode() {
            int result = this.uid.hashCode();
            result = 31 * result + this.meta;
            return result;
        }

        public String toString() {
            return this.uid + ":" + this.meta;
        }
    }
}

