/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraftforge.common.IPlantable;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.model.ChunkMD;

public class BlockUtils {
    public static AlphaComposite OPAQUE = AlphaComposite.getInstance(3, 1.0f);
    public static AlphaComposite CLEAR = AlphaComposite.getInstance(3, 0.0f);
    public static AlphaComposite SEMICLEAR = AlphaComposite.getInstance(3, 0.5f);
    public static AlphaComposite SLIGHTLYCLEAR = AlphaComposite.getInstance(3, 0.8f);
    public static Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    private static final HashMap<UniqueIdentifierProxy, EnumSet<Flag>> blockFlags = new HashMap(64);
    private static final HashMap<UniqueIdentifierProxy, Float> blockAlphas = new HashMap(8);
    public static final UniqueIdentifierProxy AIRPROXY = new UniqueIdentifierProxy(0, "air");

    public static void initialize() {
        blockAlphas.clear();
        BlockUtils.setAlpha(AIRPROXY, Float.valueOf(0.0f));
        BlockUtils.setAlpha(Block.field_72031_aZ, Float.valueOf(0.4f));
        BlockUtils.setAlpha(Block.field_71993_bv, Float.valueOf(0.4f));
        BlockUtils.setAlpha((Block)Block.field_71942_A, Float.valueOf(0.3f));
        BlockUtils.setAlpha(Block.field_71946_M, Float.valueOf(0.3f));
        BlockUtils.setAlpha(Block.field_72003_bq, Float.valueOf(0.3f));
        BlockUtils.setAlpha(Block.field_72036_aT, Float.valueOf(0.8f));
        BlockUtils.setAlpha(Block.field_72002_bp, Float.valueOf(0.4f));
        BlockUtils.setAlpha(Block.field_72098_bB, Float.valueOf(0.4f));
        BlockUtils.setAlpha(Block.field_72069_aq, Float.valueOf(0.5f));
        BlockUtils.setAlpha(Block.field_71998_bu, Float.valueOf(0.2f));
        BlockUtils.setAlpha(Block.field_71943_B, Float.valueOf(0.3f));
        blockFlags.clear();
        if (JourneyMap.getInstance().coreProperties.caveIgnoreGlass.get()) {
            BlockUtils.setFlags(Block.field_71946_M, Flag.NotHideSky);
            BlockUtils.setFlags(Block.field_72003_bq, Flag.NotHideSky);
        }
        BlockUtils.setFlags(AIRPROXY, Flag.HasAir, Flag.NotHideSky, Flag.NoShadow);
        BlockUtils.setFlags(Block.field_72031_aZ, Flag.TransparentRoof);
        BlockUtils.setFlags((Block)Block.field_72067_ar, Flag.NoShadow, Flag.Side2Texture);
        BlockUtils.setFlags((Block)Block.field_71942_A, Flag.NoShadow, Flag.BiomeColor);
        BlockUtils.setFlags(Block.field_71946_M, Flag.TransparentRoof);
        BlockUtils.setFlags(Block.field_72003_bq, Flag.NotHideSky);
        BlockUtils.setFlags((Block)Block.field_71980_u, Flag.BiomeColor);
        BlockUtils.setFlags(Block.field_72002_bp, Flag.Side2Texture, Flag.TransparentRoof);
        BlockUtils.setFlags(Block.field_72055_aF, Flag.NotHideSky);
        BlockUtils.setFlags(Block.field_71938_D, Flag.NoShadow);
        BlockUtils.setFlags((Block)Block.field_71952_K, Flag.NotHideSky, Flag.BiomeColor);
        BlockUtils.setFlags(Block.field_72035_aQ, Flag.HasAir);
        BlockUtils.setFlags((Block)Block.field_71962_X, Flag.BiomeColor);
        BlockUtils.setFlags(Block.field_72069_aq, Flag.HasAir, Flag.NoShadow);
        BlockUtils.setFlags(Block.field_72062_bU, Flag.NoShadow);
        BlockUtils.setFlags((Block)Block.field_72064_bT, Flag.NoShadow);
        BlockUtils.setFlags(Block.field_72049_aP, Flag.HasAir, Flag.NoShadow);
        BlockUtils.setFlags(Block.field_71998_bu, Flag.NotHideSky, Flag.NoShadow, Flag.BiomeColor);
        BlockUtils.setFlags(Block.field_71943_B, Flag.BiomeColor);
        BlockUtils.setFlags(Block.field_71955_W, Flag.NotHideSky, Flag.Side2Texture);
        for (Block block : Block.field_71973_m) {
            if (block == null) continue;
            if (block.func_71917_a().equals("tile.ForgeFiller")) break;
            UniqueIdentifierProxy uidProxy = new UniqueIdentifierProxy(block);
            if (block.field_72018_cp == Material.field_76249_a) {
                BlockUtils.setFlags(uidProxy, Flag.HasAir, Flag.NotHideSky, Flag.NoShadow);
                JourneyMap.getLogger().fine(uidProxy + " flags set to hide block");
                continue;
            }
            if (block instanceof BlockLeavesBase || block instanceof BlockGrass || block instanceof BlockVine || block instanceof BlockLilyPad) {
                BlockUtils.setFlags(uidProxy, Flag.BiomeColor);
                JourneyMap.getLogger().fine(uidProxy + " flag set: Flag.BiomeColor");
            }
            if (!(block instanceof IPlantable)) continue;
            BlockUtils.setFlags(uidProxy, Flag.Side2Texture, Flag.NoShadow);
            JourneyMap.getLogger().fine(uidProxy + " flags set: Flag.Side2Texture, Flag.NoShadow");
        }
    }

    public static boolean skyAbove(ChunkMD chunkMd, int x, int y, int z) {
        int checkY = y;
        int maxY = chunkMd.getHeightValue(x, z);
        if (checkY > maxY) {
            return true;
        }
        boolean seeSky = chunkMd.stub.func_76619_d(x, checkY, z);
        if (!seeSky) {
            seeSky = true;
            while (seeSky && checkY <= maxY) {
                Block block = chunkMd.getBlock(x, checkY, z);
                if (block == null || BlockUtils.hasFlag(block, Flag.HasAir)) {
                    ++checkY;
                    continue;
                }
                if (BlockUtils.hasFlag(block, Flag.NotHideSky)) {
                    ++checkY;
                    continue;
                }
                seeSky = false;
                break;
            }
        }
        return seeSky;
    }

    public static int ceiling(ChunkMD chunkMd, int x, int maxY, int z) {
        int topY;
        int chunkHeight = chunkMd.getHeightValue(x, z);
        int y = topY = Math.min(maxY, chunkHeight);
        try {
            while (y >= 0) {
                Block block = chunkMd.getBlock(x, y, z);
                if (block == null) {
                    --y;
                    continue;
                }
                if (chunkMd.stub.func_76619_d(x, y, z)) {
                    --y;
                    continue;
                }
                if (!BlockUtils.hasFlag(block, Flag.NotHideSky)) break;
                --y;
            }
            return Math.max(0, y);
        }
        catch (Exception e) {
            JourneyMap.getLogger().fine(e + " at " + x + "," + y + "," + z);
            return Math.max(0, topY);
        }
    }

    public static EnumSet<Flag> getFlags(Block block) {
        return BlockUtils.getFlags(new UniqueIdentifierProxy(block));
    }

    public static EnumSet<Flag> getFlags(UniqueIdentifierProxy uidProxy) {
        EnumSet<Flag> flags = blockFlags.get(uidProxy);
        return flags == null ? EnumSet.noneOf(Flag.class) : flags;
    }

    public static void setFlags(Block block, Flag ... flags) {
        UniqueIdentifierProxy uidProxy = new UniqueIdentifierProxy(block);
        BlockUtils.setFlags(uidProxy, flags);
    }

    public static void setFlags(UniqueIdentifierProxy uidProxy, Flag ... flags) {
        EnumSet<Flag> eset = BlockUtils.getFlags(uidProxy);
        eset.addAll(Arrays.asList(flags));
        blockFlags.put(uidProxy, eset);
    }

    public static boolean hasFlag(Block block, Flag flag) {
        EnumSet<Flag> flags = blockFlags.get(new UniqueIdentifierProxy(block));
        return flags != null && flags.contains((Object)flag);
    }

    public static boolean hasAlpha(Block block) {
        return blockAlphas.containsKey(new UniqueIdentifierProxy(block));
    }

    public static float getAlpha(Block block) {
        Float alpha = blockAlphas.get(new UniqueIdentifierProxy(block));
        return alpha == null ? 1.0f : alpha.floatValue();
    }

    public static void setAlpha(UniqueIdentifierProxy uidProxy, Float alpha) {
        blockAlphas.put(uidProxy, alpha);
    }

    public static void setAlpha(Block block, Float alpha) {
        blockAlphas.put(new UniqueIdentifierProxy(block), alpha);
    }

    public static HashMap getFlagsMap() {
        return blockFlags;
    }

    public static HashMap getAlphaMap() {
        return blockAlphas;
    }

    public static class UniqueIdentifierProxy {
        public final int blockId;
        public final String name;

        UniqueIdentifierProxy(int blockId, String name) {
            this.blockId = blockId;
            this.name = name;
        }

        UniqueIdentifierProxy(Block block) {
            this.blockId = block.field_71990_ca;
            this.name = block.func_71917_a();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UniqueIdentifierProxy)) {
                return false;
            }
            UniqueIdentifierProxy that = (UniqueIdentifierProxy)o;
            if (this.blockId != that.blockId) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.blockId;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return this.blockId + ":" + this.name;
        }
    }

    public static enum Flag {
        HasAir,
        BiomeColor,
        CustomBiomeColor,
        NotHideSky,
        NoShadow,
        Side2Texture,
        Transparency,
        Error,
        TransparentRoof;

    }
}

