/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.techbrew.journeymap.render.texture.TextureImpl;
import org.lwjgl.opengl.GL11;

public class DrawUtil {
    private static final float lightmapS = 240.0f;
    private static final float lightmapT = 240.0f;

    public static void resetLightMap() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    public static void drawCenteredLabel(String text, double x, double y, Color bgColor, int bgAlpha, Color color, int alpha, double fontScale) {
        DrawUtil.drawLabel(text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLabel(String text, double x, double y, HAlign hAlign, VAlign vAlign, Color bgColor, int bgAlpha, Color color, int alpha, double fontScale, boolean fontShadow) {
        if (text == null || text.length() == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        boolean drawRect = bgColor != null && alpha > 0;
        int width = fontRenderer.func_78256_a(text);
        int height = drawRect ? DrawUtil.getLabelHeight(fontRenderer, fontShadow) : fontRenderer.field_78288_b;
        GL11.glPushMatrix();
        try {
            if (fontScale != 1.0) {
                x /= fontScale;
                y /= fontScale;
                GL11.glScaled((double)fontScale, (double)fontScale, (double)0.0);
            }
            double textX = x;
            double textY = y;
            double rectX = x;
            double rectY = y;
            switch (hAlign) {
                case Left: {
                    textX = x - (double)width;
                    break;
                }
                case Center: {
                    textX = x - (double)(width / 2);
                    break;
                }
                case Right: {
                    textX = x;
                }
            }
            double vpad = drawRect ? (double)(height - fontRenderer.field_78288_b) / 2.0 : 0.0;
            switch (vAlign) {
                case Above: {
                    rectY = y - (double)height;
                    textY = rectY + vpad + (double)(!fontRenderer.func_82883_a() ? 1 : 0);
                    break;
                }
                case Middle: {
                    rectY = y - (double)(height / 2);
                    textY = rectY + vpad;
                    break;
                }
                case Below: {
                    rectY = y;
                    textY = rectY + vpad;
                }
            }
            if (bgColor != null && bgAlpha > 0) {
                int hpad = 2;
                double rectHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
                DrawUtil.drawRectangle(textX - 2.0 - 0.5, rectY, width + 4, rectHeight, bgColor, bgAlpha);
            }
            int intTextX = (int)Math.floor(textX);
            int intTextY = (int)Math.floor(textY);
            double dTextX = textX - (double)intTextX;
            double dTextY = textY - (double)intTextY;
            GL11.glTranslated((double)dTextX, (double)dTextY, (double)0.0);
            if (color.getTransparency() != alpha) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
            }
            if (fontShadow) {
                fontRenderer.func_78261_a(text, intTextX, intTextY, color.getRGB());
            } else {
                fontRenderer.func_78276_b(text, intTextX, intTextY, color.getRGB());
            }
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    public static int getLabelHeight(FontRenderer fr, boolean fontShadow) {
        int vpad = fr.func_82883_a() ? 0 : (fontShadow ? 3 : 2);
        return fr.field_78288_b + 2 * vpad;
    }

    private static void drawQuad(TextureImpl texture, double x, double y, int width, int height, boolean flip) {
        DrawUtil.drawQuad(texture, x, y, width, height, null, 1.0f, flip, true, 770, 771);
    }

    private static void drawQuad(TextureImpl texture, double x, double y, int width, int height, boolean flip, int glBlendSfactor, int glBlendDFactor) {
        DrawUtil.drawQuad(texture, x, y, width, height, null, 1.0f, flip, true, glBlendSfactor, glBlendDFactor);
    }

    public static void drawQuad(TextureImpl texture, double x, double y, int width, int height, Color color, float alpha, boolean flip, boolean blend, int glBlendSfactor, int glBlendDFactor) {
        if (blend) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)glBlendSfactor, (int)glBlendDFactor);
            if (color != null) {
                float[] c = color.getColorComponents(null);
                GL11.glColor4f((float)c[0], (float)c[1], (float)c[2], (float)alpha);
            } else {
                GL11.glColor4f((float)alpha, (float)alpha, (float)alpha, (float)alpha);
            }
        }
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)texture.func_110552_b());
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        int direction = flip ? -1 : 1;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, (double)height + y, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x + (double)width, (double)height + y, 0.0, (double)direction, 1.0);
        tessellator.func_78374_a(x + (double)width, y, 0.0, (double)direction, 0.0);
        tessellator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        if (blend && (glBlendSfactor != 770 || glBlendDFactor != 771)) {
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    public static void drawRectangle(double x, double y, double width, double height, Color color, int alpha) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78370_a(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        tessellator.func_78374_a(x, height + y, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x + width, height + y, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    public static void drawImage(TextureImpl texture, double x, double y, boolean flip, float scale) {
        DrawUtil.drawQuad(texture, x, y, (int)((float)texture.width * scale), (int)((float)texture.height * scale), flip);
    }

    public static void drawImage(TextureImpl texture, double x, double y, boolean flip, int glBlendSfactor, int glBlendDfactor) {
        DrawUtil.drawQuad(texture, x, y, texture.width, texture.height, flip, glBlendSfactor, glBlendDfactor);
    }

    public static void drawRotatedImage(TextureImpl texture, double x, double y, float heading, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glRotatef((float)heading, (float)0.0f, (float)0.0f, (float)1.0f);
        int width = (int)((float)texture.width * scale);
        int height = (int)((float)texture.height * scale);
        GL11.glTranslated((double)(-width), (double)(-height), (double)0.0);
        DrawUtil.drawQuad(texture, width / 2, height / 2, width, height, false);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawColoredImage(TextureImpl texture, int alpha, Color color, double x, double y) {
        DrawUtil.drawQuad(texture, x, y, texture.width, texture.height, color, alpha, false, true, 770, 771);
    }

    public static void drawColoredImage(TextureImpl texture, int alpha, Color color, double x, double y, boolean blend) {
        DrawUtil.drawQuad(texture, x, y, texture.width, texture.height, color, alpha, false, false, 0, 0);
    }

    public static void drawEntity(double x, double y, Double heading, boolean flipInsteadOfRotate, TextureImpl texture, int bottomMargin, float scale) {
        if (heading == null) {
            DrawUtil.drawImage(texture, x, y, false, scale);
        } else if (!flipInsteadOfRotate) {
            DrawUtil.drawRotatedImage(texture, x, y, heading.floatValue(), scale);
        } else {
            boolean flip = heading < 90.0;
            int width = (int)((float)texture.width * scale);
            int height = (int)((float)texture.height * scale);
            DrawUtil.drawImage(texture, x - (double)(width / 2), y - (double)(height / 2) - (double)bottomMargin, flip, scale);
        }
    }

    public static boolean startUnicode(FontRenderer fr, boolean force) {
        if (!force) {
            return false;
        }
        boolean isUnicode = fr.func_82883_a();
        if (!isUnicode) {
            fr.func_78264_a(true);
            return true;
        }
        return false;
    }

    public static void stopUnicode(FontRenderer fr) {
        fr.func_78264_a(false);
    }

    public static enum VAlign {
        Above,
        Middle,
        Below;

    }

    public static enum HAlign {
        Left,
        Center,
        Right;

    }
}

