/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import java.awt.Color;
import java.awt.geom.Point2D;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class DrawWayPointStep
implements DrawStep {
    public final Waypoint waypoint;
    final Color color;
    final Color fontColor;
    final TextureImpl texture;
    final boolean isEdit;

    public DrawWayPointStep(Waypoint waypoint) {
        this(waypoint, waypoint.getColor(), waypoint.isDeathPoint() ? Color.red : waypoint.getSafeColor(), false);
    }

    public DrawWayPointStep(Waypoint waypoint, Color color, Color fontColor, boolean isEdit) {
        this.waypoint = waypoint;
        this.color = color;
        this.fontColor = fontColor;
        this.isEdit = isEdit;
        this.texture = waypoint.getTexture();
    }

    @Override
    public void draw(double xOffset, double yOffset, GridRenderer gridRenderer, float drawScale, double fontScale) {
        if (!this.waypoint.isInPlayerDimension()) {
            return;
        }
        Point2D.Double pixel = this.getPosition(xOffset, yOffset, gridRenderer);
        double halfTexHeight = this.texture.height / 2;
        if (gridRenderer.isOnScreen(pixel)) {
            DrawUtil.drawLabel(this.waypoint.getName(), pixel.getX(), pixel.getY() - halfTexHeight, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, Color.black, 255, this.fontColor, 255, fontScale, false);
            if (this.isEdit) {
                TextureImpl editTex = TextureCache.instance().getWaypointEdit();
                DrawUtil.drawColoredImage(editTex, 255, this.color, pixel.getX() - (double)(editTex.width / 2), pixel.getY() - (double)(editTex.height / 2));
            }
            DrawUtil.drawColoredImage(this.texture, 255, this.color, pixel.getX() - (double)(this.texture.width / 2), pixel.getY() - halfTexHeight);
        } else if (!this.isEdit) {
            gridRenderer.ensureOnScreen(pixel);
            DrawUtil.drawColoredImage(this.texture, 255, this.color, pixel.getX() - (double)(this.texture.width / 2), pixel.getY() - halfTexHeight);
        }
    }

    protected Point2D.Double getPosition(double xOffset, double yOffset, GridRenderer gridRenderer) {
        double x = this.waypoint.getX();
        double z = this.waypoint.getZ();
        double halfBlock = Math.pow(2.0, gridRenderer.getZoom()) / 2.0;
        Point2D.Double pixel = gridRenderer.getBlockPixelInGrid(x, z);
        pixel.setLocation(pixel.getX() + halfBlock + xOffset, pixel.getY() + halfBlock + yOffset);
        return pixel;
    }

    public boolean isOnScreen(double xOffset, double yOffset, GridRenderer gridRenderer) {
        return gridRenderer.isOnScreen(this.getPosition(xOffset, yOffset, gridRenderer));
    }
}

