/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.overlay;

import com.google.common.cache.Cache;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.model.BlockCoordIntPair;
import net.techbrew.journeymap.properties.MapProperties;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.Tile;
import net.techbrew.journeymap.render.overlay.TileCache;
import net.techbrew.journeymap.render.overlay.TilePos;
import org.lwjgl.opengl.GL11;

public class GridRenderer {
    private final Logger logger = JourneyMap.getLogger();
    private final boolean debug = this.logger.isLoggable(Level.FINE);
    private final TreeMap<TilePos, Integer> grid = new TreeMap();
    private final int gridSize;
    final double srcSize;
    final Cache<Integer, Tile> tc = TileCache.instance();
    final TilePos centerPos = new TilePos(0, 0);
    private Rectangle2D.Double viewPort = null;
    private Rectangle2D.Double screenBounds = null;
    private int lastHeight = -1;
    private int lastWidth = -1;
    private Constants.MapType mapType = Constants.MapType.day;
    private int centerTileHash = Integer.MIN_VALUE;
    private int zoom;
    private double centerBlockX;
    private double centerBlockZ;
    private final Color bgColor = new Color(34, 34, 34);
    private final Point2D.Double centerPixelOffset = new Point2D.Double();
    private Integer dimension;
    private File worldDir;

    public GridRenderer(int gridSize) {
        this.gridSize = gridSize;
        this.srcSize = gridSize * 512;
    }

    public void setViewPort(Rectangle2D.Double viewPort) {
        this.viewPort = viewPort;
        this.screenBounds = null;
        this.updateBounds(this.lastWidth, this.lastHeight);
    }

    private void populateGrid(Tile centerTile) {
        int endRow = (this.gridSize - 1) / 2;
        int endCol = (this.gridSize - 1) / 2;
        int startRow = -endRow;
        int startCol = -endCol;
        Cache<Integer, Tile> tc = TileCache.instance();
        for (int z = startRow; z <= endRow; ++z) {
            for (int x = startCol; x <= endCol; ++x) {
                TilePos pos = new TilePos(x, z);
                Tile tile = this.findNeighbor(centerTile, pos);
                this.grid.put(pos, tile.hashCode());
            }
        }
    }

    public void move(int deltaBlockX, int deltaBlockZ) {
        this.center(this.centerBlockX + (double)deltaBlockX, this.centerBlockZ + (double)deltaBlockZ, this.zoom);
    }

    public boolean center() {
        return this.center(this.centerBlockX, this.centerBlockZ, this.zoom);
    }

    public boolean hasTile(Tile tile) {
        return this.grid.containsValue(tile);
    }

    public boolean center(double blockX, double blockZ, int zoom) {
        int tileZ;
        if (blockX == this.centerBlockX && blockZ == this.centerBlockZ && zoom == this.zoom && !this.grid.isEmpty()) {
            return false;
        }
        this.centerBlockX = blockX;
        this.centerBlockZ = blockZ;
        this.zoom = zoom;
        int tileX = Tile.blockPosToTile((int)Math.floor(this.centerBlockX), this.zoom);
        int newCenterHash = Tile.toHashCode(tileX, tileZ = Tile.blockPosToTile((int)Math.floor(this.centerBlockZ), this.zoom), zoom, this.dimension);
        boolean centerTileChanged = newCenterHash != this.centerTileHash;
        this.centerTileHash = newCenterHash;
        if (centerTileChanged || this.grid.isEmpty()) {
            Tile newCenterTile = this.findTile(tileX, tileZ);
            this.populateGrid(newCenterTile);
            if (this.debug) {
                this.logger.fine("Centered on " + newCenterTile + " with pixel offsets of " + this.centerPixelOffset.x + "," + this.centerPixelOffset.y);
                Minecraft mc = Minecraft.func_71410_x();
                BufferedImage tmp = new BufferedImage(mc.field_71443_c, mc.field_71440_d, 2);
                Graphics2D g = tmp.createGraphics();
                g.setStroke(new BasicStroke(1.0f));
                g.setColor(Color.GREEN);
                g.drawLine(mc.field_71443_c / 2, 0, mc.field_71443_c / 2, mc.field_71440_d);
                g.drawLine(0, mc.field_71440_d / 2, mc.field_71443_c, mc.field_71440_d / 2);
            }
        }
        return true;
    }

    public boolean updateTextures(Constants.MapType mapType, Integer vSlice, int width, int height, boolean fullUpdate, double xOffset, double yOffset, MapProperties mapProperties) {
        this.updateBounds(width, height);
        this.mapType = mapType;
        Integer centerHash = this.grid.get(this.centerPos);
        if (centerHash == null) {
            return false;
        }
        Tile centerTile = (Tile)this.tc.getIfPresent((Object)centerHash);
        if (centerTile == null) {
            int tileX = Tile.blockPosToTile((int)Math.floor(this.centerBlockX), this.zoom);
            int tileZ = Tile.blockPosToTile((int)Math.floor(this.centerBlockZ), this.zoom);
            centerTile = this.findTile(tileX, tileZ);
            this.populateGrid(centerTile);
        }
        Point2D blockPixelOffset = centerTile.blockPixelOffsetInTile(this.centerBlockX, this.centerBlockZ);
        double blockSizeOffset = Math.pow(2.0, this.zoom) / 2.0;
        int magic = (this.gridSize == 5 ? 2 : 1) * 512;
        double displayOffsetX = xOffset + (double)magic - (this.srcSize - (double)this.lastWidth) / 2.0;
        displayOffsetX = this.centerBlockX < 0.0 ? (displayOffsetX -= blockSizeOffset) : (displayOffsetX += blockSizeOffset);
        double displayOffsetY = yOffset + (double)magic - (this.srcSize - (double)this.lastHeight) / 2.0;
        displayOffsetY = this.centerBlockZ < 0.0 ? (displayOffsetY -= blockSizeOffset) : (displayOffsetY += blockSizeOffset);
        this.centerPixelOffset.setLocation(displayOffsetX + blockPixelOffset.getX(), displayOffsetY + blockPixelOffset.getY());
        if (!fullUpdate) {
            return false;
        }
        boolean updated = false;
        for (Map.Entry<TilePos, Integer> entry : this.grid.entrySet()) {
            TilePos pos = entry.getKey();
            Integer hashCode = entry.getValue();
            Tile tile = (Tile)this.tc.getIfPresent((Object)hashCode);
            if (tile == null) {
                tile = this.findNeighbor(centerTile, pos);
                this.grid.put(pos, hashCode);
            }
            if (!this.isOnScreen(pos) || tile == null || !tile.updateTexture(pos, this.mapType, vSlice, mapProperties)) continue;
            updated = true;
        }
        return updated;
    }

    public Point2D.Double getCenterPixelOffset() {
        return this.centerPixelOffset;
    }

    public BlockCoordIntPair getBlockUnderMouse(double mouseX, double mouseY, int screenWidth, int screenHeight) {
        double centerPixelX = (double)screenWidth / 2.0;
        double centerPixelZ = (double)screenHeight / 2.0;
        double blockSize = (int)Math.pow(2.0, this.zoom);
        double deltaX = (centerPixelX - mouseX) / blockSize;
        double deltaZ = (centerPixelZ - mouseY) / blockSize;
        int x = (int)Math.floor(this.centerBlockX - deltaX);
        int z = (int)Math.floor(this.centerBlockZ + deltaZ);
        return new BlockCoordIntPair(x, z);
    }

    public Point2D.Double getBlockPixelInGrid(double x, double z) {
        double localBlockX = x - this.centerBlockX;
        double localBlockZ = z - this.centerBlockZ;
        int blockSize = (int)Math.pow(2.0, this.zoom);
        double pixelOffsetX = (double)(this.lastWidth / 2) + localBlockX * (double)blockSize;
        double pixelOffsetZ = (double)(this.lastHeight / 2) + localBlockZ * (double)blockSize;
        return new Point2D.Double(pixelOffsetX, pixelOffsetZ);
    }

    public void draw(List<? extends DrawStep> drawStepList, double xOffset, double yOffset, float drawScale, double fontScale) {
        if (drawStepList == null || drawStepList.isEmpty()) {
            return;
        }
        this.draw(xOffset, yOffset, drawScale, fontScale, drawStepList.toArray(new DrawStep[drawStepList.size()]));
    }

    public void draw(double xOffset, double yOffset, float drawScale, double fontScale, DrawStep ... drawSteps) {
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        for (DrawStep drawStep : drawSteps) {
            drawStep.draw(xOffset, yOffset, this, drawScale, fontScale);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
    }

    public void draw(float opacity, double offsetX, double offsetZ) {
        if (!this.grid.isEmpty()) {
            double centerX = offsetX + this.centerPixelOffset.x;
            double centerZ = offsetZ + this.centerPixelOffset.y;
            Cache<Integer, Tile> tc = TileCache.instance();
            int index = 0;
            for (Map.Entry<TilePos, Integer> entry : this.grid.entrySet()) {
                ++index;
                TilePos pos = entry.getKey();
                Tile tile = (Tile)tc.getIfPresent((Object)entry.getValue());
                this.drawTile(pos, tile, centerX, centerZ);
            }
        }
    }

    private void drawTile(TilePos pos, Tile tile, double offsetX, double offsetZ) {
        double startX = offsetX + pos.startX;
        double startZ = offsetZ + pos.startZ;
        double endX = offsetX + pos.endX;
        double endZ = offsetZ + pos.endZ;
        if (this.isOnScreen(startX, startZ, 512, 512)) {
            DrawUtil.drawRectangle(startX, startZ, 512.0, 512.0, this.bgColor, 255);
            if (tile != null && tile.hasTexture()) {
                GL11.glDisable((int)2929);
                GL11.glDepthMask((boolean)false);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3553);
                GL11.glBindTexture((int)3553, (int)tile.getTexture().func_110552_b());
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a(startX, endZ, 0.0, 0.0, 1.0);
                tessellator.func_78374_a(endX, endZ, 0.0, 1.0, 1.0);
                tessellator.func_78374_a(endX, startZ, 0.0, 1.0, 0.0);
                tessellator.func_78374_a(startX, startZ, 0.0, 0.0, 0.0);
                tessellator.func_78381_a();
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2929);
            }
        }
        if (this.debug) {
            Color color = tile == null ? Color.RED : Color.BLUE;
            DrawUtil.drawLabel(pos.toString(), startX + 256.0, startZ + 256.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, Color.WHITE, 255, color, 255, 1.0, false);
            DrawUtil.drawRectangle(startX, startZ, 512.0, 1.0, Color.white, 200);
            DrawUtil.drawRectangle(startX, startZ, 1.0, 512.0, Color.white, 200);
            DrawUtil.drawRectangle(startX, startZ + 512.0, 512.0, 1.0, Color.gray, 200);
            DrawUtil.drawRectangle(startX + 512.0, startZ, 1.0, 512.0, Color.gray, 200);
        }
    }

    public Point2D.Double getPixel(double blockX, double blockZ) {
        Point2D.Double pixel = this.getBlockPixelInGrid(blockX, blockZ);
        if (this.isOnScreen(pixel)) {
            return pixel;
        }
        return null;
    }

    public void ensureOnScreen(Point2D pixel) {
        if (this.screenBounds == null) {
            return;
        }
        double x = pixel.getX();
        if (x < this.screenBounds.x) {
            x = this.screenBounds.x;
        } else if (x > this.screenBounds.getMaxX()) {
            x = this.screenBounds.getMaxX();
        }
        double y = pixel.getY();
        if (y < this.screenBounds.y) {
            y = this.screenBounds.y;
        } else if (y > this.screenBounds.getMaxY()) {
            y = this.screenBounds.getMaxY();
        }
        pixel.setLocation(x, y);
    }

    private boolean isOnScreen(TilePos pos) {
        return this.isOnScreen(pos.startX + this.centerPixelOffset.x, pos.startZ + this.centerPixelOffset.y, 512, 512);
    }

    public boolean isOnScreen(Point2D.Double pixel) {
        return this.screenBounds.contains(pixel);
    }

    public boolean isOnScreen(double x, double y) {
        return this.screenBounds.contains(x, y);
    }

    public boolean isOnScreen(double startX, double startY, int width, int height) {
        if (this.screenBounds == null) {
            return false;
        }
        return this.screenBounds.intersects(startX, startY, width, height);
    }

    private void updateBounds(int width, int height) {
        if (this.screenBounds == null || this.lastWidth != width || this.lastHeight != height) {
            this.lastWidth = width;
            this.lastHeight = height;
            this.screenBounds = this.viewPort == null ? new Rectangle2D.Double(0.0, 0.0, width, height) : new Rectangle2D.Double(((double)width - this.viewPort.width) / 2.0, ((double)height - this.viewPort.height) / 2.0, this.viewPort.width, this.viewPort.height);
        }
    }

    private Tile findNeighbor(Tile tile, TilePos pos) {
        if (pos.deltaX == 0 && pos.deltaZ == 0) {
            return tile;
        }
        return this.findTile(tile.tileX + pos.deltaX, tile.tileZ + pos.deltaZ);
    }

    private Tile findTile(int tileX, int tileZ) {
        return TileCache.getOrCreate(this.worldDir, this.mapType, tileX, tileZ, this.zoom, this.dimension);
    }

    public void setContext(File worldDir, int dimension) {
        this.worldDir = worldDir;
        this.dimension = dimension;
    }

    public double getCenterBlockX() {
        return this.centerBlockX;
    }

    public double getCenterBlockZ() {
        return this.centerBlockZ;
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getZoom() {
        return this.zoom;
    }

    public boolean setZoom(int zoom) {
        return this.center(this.centerBlockX, this.centerBlockZ, zoom);
    }

    public int getRenderSize() {
        return this.gridSize * 512;
    }

    public void clear() {
        this.grid.clear();
    }

    public int getWidth() {
        return this.lastWidth;
    }

    public int getHeight() {
        return this.lastHeight;
    }
}

