/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.server;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.MapSaver;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.server.BaseService;
import net.techbrew.journeymap.task.MapRegionTask;
import net.techbrew.journeymap.task.SaveMapTask;
import se.rupy.http.Event;
import se.rupy.http.Query;

public class ActionService
extends BaseService {
    private static final long serialVersionUID = 4412225358529161454L;
    public static final String CHARACTER_ENCODING = "UTF-8";
    private static boolean debug = true;

    @Override
    public String path() {
        return "/action";
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        String type;
        Query query = event.query();
        query.parse();
        Minecraft minecraft = Minecraft.func_71410_x();
        WorldClient theWorld = minecraft.field_71441_e;
        if (theWorld == null) {
            this.throwEventException(503, Constants.getMessageJMERR09(new Object[0]), event, false);
        }
        if (!JourneyMap.getInstance().isMapping().booleanValue()) {
            this.throwEventException(503, Constants.getMessageJMERR02(new Object[0]), event, false);
        }
        if ("savemap".equals(type = this.getParameter(query, "type", (String)null))) {
            this.saveMap(event);
        } else if ("automap".equals(type)) {
            this.autoMap(event);
        } else {
            String error = Constants.getMessageJMERR05("type=" + type);
            this.throwEventException(400, error, event, true);
        }
    }

    private void saveMap(Event event) throws Event, Exception {
        Query query = event.query();
        Minecraft minecraft = Minecraft.func_71410_x();
        WorldClient theWorld = minecraft.field_71441_e;
        try {
            MapSaver mapSaver;
            String error;
            File worldDir = FileHandler.getJMWorldDir(minecraft);
            if (!worldDir.exists() || !worldDir.isDirectory()) {
                String error2 = Constants.getMessageJMERR10(worldDir.getAbsolutePath());
            }
            Integer vSlice = this.getParameter((Map<String, String[]>)query, "depth", (Integer)null);
            int dimension = this.getParameter((Map<String, String[]>)query, "dim", 0);
            String mapTypeString = this.getParameter(query, "mapType", Constants.MapType.day.name());
            Constants.MapType mapType = null;
            try {
                mapType = Constants.MapType.valueOf(mapTypeString);
            }
            catch (Exception e) {
                error = Constants.getMessageJMERR05("mapType=" + (Object)((Object)mapType));
                this.throwEventException(400, error, event, true);
            }
            if (mapType != Constants.MapType.underground) {
                vSlice = null;
            }
            Boolean hardcore = theWorld.func_72912_H().func_76093_s();
            if (mapType.equals((Object)Constants.MapType.underground) && hardcore.booleanValue()) {
                error = "Cave mapping on hardcore servers is not allowed";
                this.throwEventException(403, error, event, true);
            }
            if (!(mapSaver = new MapSaver(worldDir, mapType, vSlice, dimension)).isValid()) {
                this.throwEventException(403, "No image files to save.", event, true);
            }
            JourneyMap.getInstance().toggleTask(SaveMapTask.Manager.class, true, mapSaver);
            Properties response = new Properties();
            response.put("filename", mapSaver.getSaveFileName());
            this.respondJson(event, response);
        }
        catch (NumberFormatException e) {
            this.reportMalformedRequest(event);
        }
        catch (Event eventEx) {
            throw eventEx;
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe(LogFormatter.toString(t));
            this.throwEventException(500, Constants.getMessageJMERR19(this.path), event, true);
        }
    }

    private void autoMap(Event event) throws Event, Exception {
        boolean enabled = JourneyMap.getInstance().isTaskManagerEnabled(MapRegionTask.Manager.class);
        String scope = this.getParameter(event.query(), "scope", "stop");
        HashMap<String, String> responseObj = new HashMap<String, String>();
        if ("stop".equals(scope)) {
            if (enabled) {
                JourneyMap.getInstance().toggleTask(MapRegionTask.Manager.class, false, Boolean.FALSE);
                responseObj.put("message", "automap_complete");
            }
        } else if (!enabled) {
            boolean doAll = "all".equals(scope);
            JourneyMap.getInstance().toggleTask(MapRegionTask.Manager.class, true, doAll);
            responseObj.put("message", "automap_started");
        } else {
            responseObj.put("message", "automap_already_started");
        }
        this.respondJson(event, responseObj);
    }
}

